# OpenCL Backend

DBM processes batches of matrix multiplications which may look like (task):

```C
typedef struct {
  int m;
  int n;
  int k;
  int offset_a;
  int offset_b;
  int offset_c;
} dbm_task_t;
```

Each task is characterized by an M, N, and K parameter as well as offsets pointing into compact data
arrays representing the A, B, and C matrices of an entire batch. The OpenCL backend provides a
universal kernel for a general range of M, N, and K parameters.

The OpenCL backend shares the same data structures (header files) and the same input format as used
for other backends namely CUDA and HIP.

## Tiny Tensor Compiler

The [Tiny Tensor Compiler](https://github.com/intel/tiny-tensor-compiler) aims for tensor
computations on GPUs and other devices, supporting the OpenCL, Level Zero, and SYCL runtime.

The compiler takes a textual and human readable Intermediate Representation (IR) and generates for
instance an OpenCL kernel. Provided the [IR-file](dbm_multiply_opencl.ir), the
[generated kernel](dbm_multiply_opencl.irh) is an optional code-path implemented by the OpenCL
backend (in addition to the universal kernel).

If the OpenCL runtime supports the necessary features, the kernel generated by the Tiny Tensor
Compiler is used by default (an environment variable `DBM_MULTIPLY_GEN=0` can enforce the universal
kernel).
