//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcosmos

import "time"

type APIProperties struct {
	// Describes the ServerVersion of an a MongoDB account.
	ServerVersion *ServerVersion
}

// ARMProxyResource - The resource model definition for a ARM proxy resource. It will have everything other than required
// location and tags
type ARMProxyResource struct {
	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// ARMResourceProperties - The core properties of ARM resources.
type ARMResourceProperties struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// AccountKeyMetadata - The metadata related to an access key for a given database account.
type AccountKeyMetadata struct {
	// READ-ONLY; Generation time in UTC of the key in ISO-8601 format. If the value is missing from the object, it means that
	// the last key regeneration was triggered before 2022-06-18.
	GenerationTime *time.Time
}

// AnalyticalStorageConfiguration - Analytical storage specific properties.
type AnalyticalStorageConfiguration struct {
	// Describes the types of schema for analytical storage.
	SchemaType *AnalyticalStorageSchemaType
}

// AuthenticationMethodLdapProperties - Ldap authentication method properties. This feature is in preview.
type AuthenticationMethodLdapProperties struct {
	// Timeout for connecting to the LDAP server in miliseconds. The default is 5000 ms.
	ConnectionTimeoutInMs *int32

	// Distinguished name of the object to start the recursive search of users from.
	SearchBaseDistinguishedName *string

	// Template to use for searching. Defaults to (cn=%s) where %s will be replaced by the username used to login.
	SearchFilterTemplate *string
	ServerCertificates   []*Certificate

	// Hostname of the LDAP server.
	ServerHostname *string

	// Port of the LDAP server.
	ServerPort *int32

	// Distinguished name of the look up user account, who can look up user details on authentication.
	ServiceUserDistinguishedName *string

	// Password of the look up user.
	ServiceUserPassword *string
}

// AutoUpgradePolicyResource - Cosmos DB resource auto-upgrade policy
type AutoUpgradePolicyResource struct {
	// Represents throughput policy which service must adhere to for auto-upgrade
	ThroughputPolicy *ThroughputPolicyResource
}

type AutoscaleSettings struct {
	// Represents maximum throughput, the resource can scale up to.
	MaxThroughput *int32
}

// AutoscaleSettingsResource - Cosmos DB provisioned throughput settings object
type AutoscaleSettingsResource struct {
	// REQUIRED; Represents maximum throughput container can scale up to.
	MaxThroughput *int32

	// Cosmos DB resource auto-upgrade policy
	AutoUpgradePolicy *AutoUpgradePolicyResource

	// READ-ONLY; Represents target maximum throughput container can scale up to once offer is no longer in pending state.
	TargetMaxThroughput *int32
}

// AzureBlobDataTransferDataSourceSink - An Azure Blob Storage data source/sink
type AzureBlobDataTransferDataSourceSink struct {
	// REQUIRED
	Component *DataTransferComponent

	// REQUIRED
	ContainerName *string
	EndpointURL   *string
}

// GetDataTransferDataSourceSink implements the DataTransferDataSourceSinkClassification interface for type AzureBlobDataTransferDataSourceSink.
func (a *AzureBlobDataTransferDataSourceSink) GetDataTransferDataSourceSink() *DataTransferDataSourceSink {
	return &DataTransferDataSourceSink{
		Component: a.Component,
	}
}

// BackupInformation - Backup information of a resource.
type BackupInformation struct {
	// READ-ONLY; Information about the status of continuous backups.
	ContinuousBackupInformation *ContinuousBackupInformation
}

// BackupPolicy - The object representing the policy for taking backups on an account.
type BackupPolicy struct {
	// REQUIRED; Describes the mode of backups.
	Type *BackupPolicyType

	// The object representing the state of the migration between the backup policies.
	MigrationState *BackupPolicyMigrationState
}

// GetBackupPolicy implements the BackupPolicyClassification interface for type BackupPolicy.
func (b *BackupPolicy) GetBackupPolicy() *BackupPolicy { return b }

// BackupPolicyMigrationState - The object representing the state of the migration between the backup policies.
type BackupPolicyMigrationState struct {
	// Time at which the backup policy migration started (ISO-8601 format).
	StartTime *time.Time

	// Describes the status of migration between backup policy types.
	Status *BackupPolicyMigrationStatus

	// Describes the target backup policy type of the backup policy migration.
	TargetType *BackupPolicyType
}

// BackupResource - A restorable backup of a Cassandra cluster.
type BackupResource struct {
	Properties *BackupResourceProperties

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

type BackupResourceProperties struct {
	// The time this backup was taken, formatted like 2021-01-21T17:35:21
	Timestamp *time.Time
}

// Capability - Cosmos DB capability object
type Capability struct {
	// Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and
	// "EnableGremlin".
	Name *string
}

// Capacity - The object that represents all properties related to capacity enforcement on an account.
type Capacity struct {
	// The total throughput limit imposed on the account. A totalThroughputLimit of 2000 imposes a strict limit of max throughput
	// that can be provisioned on that account to be 2000. A totalThroughputLimit of
	// -1 indicates no limits on provisioning of throughput.
	TotalThroughputLimit *int32
}

// CassandraClusterPublicStatus - Properties of a managed Cassandra cluster public status.
type CassandraClusterPublicStatus struct {
	// List relevant information about any connection errors to the Datacenters.
	ConnectionErrors []*ConnectionError

	// List of the status of each datacenter in this cluster.
	DataCenters []*CassandraClusterPublicStatusDataCentersItem
	ETag        *string

	// List relevant information about any errors about cluster, data center and connection error.
	Errors       []*CassandraError
	ReaperStatus *ManagedCassandraReaperStatus
}

type CassandraClusterPublicStatusDataCentersItem struct {
	// The name of this Datacenter.
	Name  *string
	Nodes []*ComponentsM9L909SchemasCassandraclusterpublicstatusPropertiesDatacentersItemsPropertiesNodesItems

	// A list of all seed nodes in the cluster, managed and unmanaged.
	SeedNodes []*string
}

// CassandraDataTransferDataSourceSink - A CosmosDB Cassandra API data source/sink
type CassandraDataTransferDataSourceSink struct {
	// REQUIRED
	Component *DataTransferComponent

	// REQUIRED
	KeyspaceName *string

	// REQUIRED
	TableName *string
}

// GetDataTransferDataSourceSink implements the DataTransferDataSourceSinkClassification interface for type CassandraDataTransferDataSourceSink.
func (c *CassandraDataTransferDataSourceSink) GetDataTransferDataSourceSink() *DataTransferDataSourceSink {
	return &DataTransferDataSourceSink{
		Component: c.Component,
	}
}

type CassandraError struct {
	// Additional information about the error.
	AdditionalErrorInfo *string

	// The code of error that occurred.
	Code *string

	// The message of the error.
	Message *string

	// The target resource of the error.
	Target *string
}

// CassandraKeyspaceCreateUpdateParameters - Parameters to create and update Cosmos DB Cassandra keyspace.
type CassandraKeyspaceCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Cassandra keyspace.
	Properties *CassandraKeyspaceCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// CassandraKeyspaceCreateUpdateProperties - Properties to create and update Azure Cosmos DB Cassandra keyspace.
type CassandraKeyspaceCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Cassandra keyspace
	Resource *CassandraKeyspaceResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// CassandraKeyspaceGetProperties - The properties of an Azure Cosmos DB Cassandra keyspace
type CassandraKeyspaceGetProperties struct {
	Options  *CassandraKeyspaceGetPropertiesOptions
	Resource *CassandraKeyspaceGetPropertiesResource
}

type CassandraKeyspaceGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32
}

type CassandraKeyspaceGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB Cassandra keyspace
	ID *string

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// CassandraKeyspaceGetResults - An Azure Cosmos DB Cassandra keyspace.
type CassandraKeyspaceGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB Cassandra keyspace
	Properties *CassandraKeyspaceGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// CassandraKeyspaceListResult - The List operation response, that contains the Cassandra keyspaces and their properties.
type CassandraKeyspaceListResult struct {
	// READ-ONLY; List of Cassandra keyspaces and their properties.
	Value []*CassandraKeyspaceGetResults
}

// CassandraKeyspaceResource - Cosmos DB Cassandra keyspace resource object
type CassandraKeyspaceResource struct {
	// REQUIRED; Name of the Cosmos DB Cassandra keyspace
	ID *string
}

// CassandraPartitionKey - Cosmos DB Cassandra table partition key
type CassandraPartitionKey struct {
	// Name of the Cosmos DB Cassandra table partition key
	Name *string
}

// CassandraSchema - Cosmos DB Cassandra table schema
type CassandraSchema struct {
	// List of cluster key.
	ClusterKeys []*ClusterKey

	// List of Cassandra table columns.
	Columns []*Column

	// List of partition key.
	PartitionKeys []*CassandraPartitionKey
}

// CassandraTableCreateUpdateParameters - Parameters to create and update Cosmos DB Cassandra table.
type CassandraTableCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Cassandra table.
	Properties *CassandraTableCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// CassandraTableCreateUpdateProperties - Properties to create and update Azure Cosmos DB Cassandra table.
type CassandraTableCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Cassandra table
	Resource *CassandraTableResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// CassandraTableGetProperties - The properties of an Azure Cosmos DB Cassandra table
type CassandraTableGetProperties struct {
	Options  *CassandraTableGetPropertiesOptions
	Resource *CassandraTableGetPropertiesResource
}

type CassandraTableGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32
}

type CassandraTableGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB Cassandra table
	ID *string

	// Analytical TTL.
	AnalyticalStorageTTL *int32

	// Time to live of the Cosmos DB Cassandra table
	DefaultTTL *int32

	// Schema of the Cosmos DB Cassandra table
	Schema *CassandraSchema

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// CassandraTableGetResults - An Azure Cosmos DB Cassandra table.
type CassandraTableGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB Cassandra table
	Properties *CassandraTableGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// CassandraTableListResult - The List operation response, that contains the Cassandra tables and their properties.
type CassandraTableListResult struct {
	// READ-ONLY; List of Cassandra tables and their properties.
	Value []*CassandraTableGetResults
}

// CassandraTableResource - Cosmos DB Cassandra table resource object
type CassandraTableResource struct {
	// REQUIRED; Name of the Cosmos DB Cassandra table
	ID *string

	// Analytical TTL.
	AnalyticalStorageTTL *int32

	// Time to live of the Cosmos DB Cassandra table
	DefaultTTL *int32

	// Schema of the Cosmos DB Cassandra table
	Schema *CassandraSchema
}

// CassandraViewCreateUpdateParameters - Parameters to create and update Cosmos DB Cassandra view.
type CassandraViewCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Cassandra view.
	Properties *CassandraViewCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// CassandraViewCreateUpdateProperties - Properties to create and update Azure Cosmos DB Cassandra view.
type CassandraViewCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Cassandra view
	Resource *CassandraViewResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// CassandraViewGetProperties - The properties of an Azure Cosmos DB Cassandra view
type CassandraViewGetProperties struct {
	Options  *CassandraViewGetPropertiesOptions
	Resource *CassandraViewGetPropertiesResource
}

type CassandraViewGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32
}

type CassandraViewGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB Cassandra view
	ID *string

	// REQUIRED; View Definition of the Cosmos DB Cassandra view
	ViewDefinition *string

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// CassandraViewGetResults - An Azure Cosmos DB Cassandra view.
type CassandraViewGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB Cassandra view
	Properties *CassandraViewGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// CassandraViewListResult - The List operation response, that contains the Cassandra views and their properties.
type CassandraViewListResult struct {
	// READ-ONLY; List of Cassandra views and their properties.
	Value []*CassandraViewGetResults
}

// CassandraViewResource - Cosmos DB Cassandra view resource object
type CassandraViewResource struct {
	// REQUIRED; Name of the Cosmos DB Cassandra view
	ID *string

	// REQUIRED; View Definition of the Cosmos DB Cassandra view
	ViewDefinition *string
}

type Certificate struct {
	// PEM formatted public key.
	Pem *string
}

// CheckNameAvailabilityRequest - The check availability request body.
type CheckNameAvailabilityRequest struct {
	// The name of the resource for which availability needs to be checked.
	Name *string

	// The resource type.
	Type *string
}

// CheckNameAvailabilityResponse - The check availability result.
type CheckNameAvailabilityResponse struct {
	// Detailed reason why the given name is available.
	Message *string

	// Indicates if the resource name is available.
	NameAvailable *bool

	// The reason why the given name is not available.
	Reason *CheckNameAvailabilityReason
}

// ClientEncryptionIncludedPath - .
type ClientEncryptionIncludedPath struct {
	// REQUIRED; The identifier of the Client Encryption Key to be used to encrypt the path.
	ClientEncryptionKeyID *string

	// REQUIRED; The encryption algorithm which will be used. Eg - AEADAES256CBCHMAC_SHA256.
	EncryptionAlgorithm *string

	// REQUIRED; The type of encryption to be performed. Eg - Deterministic, Randomized.
	EncryptionType *string

	// REQUIRED; Path that needs to be encrypted.
	Path *string
}

// ClientEncryptionKeyCreateUpdateParameters - Parameters to create and update ClientEncryptionKey.
type ClientEncryptionKeyCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update ClientEncryptionKey.
	Properties *ClientEncryptionKeyCreateUpdateProperties
}

// ClientEncryptionKeyCreateUpdateProperties - Properties to create and update ClientEncryptionKey.
type ClientEncryptionKeyCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a ClientEncryptionKey
	Resource *ClientEncryptionKeyResource
}

// ClientEncryptionKeyGetProperties - The properties of a ClientEncryptionKey resource
type ClientEncryptionKeyGetProperties struct {
	Resource *ClientEncryptionKeyGetPropertiesResource
}

type ClientEncryptionKeyGetPropertiesResource struct {
	// Encryption algorithm that will be used along with this client encryption key to encrypt/decrypt data.
	EncryptionAlgorithm *string

	// Name of the ClientEncryptionKey
	ID *string

	// Metadata for the wrapping provider that can be used to unwrap the wrapped client encryption key.
	KeyWrapMetadata *KeyWrapMetadata

	// Wrapped (encrypted) form of the key represented as a byte array.
	WrappedDataEncryptionKey []byte

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// ClientEncryptionKeyGetResults - Client Encryption Key.
type ClientEncryptionKeyGetResults struct {
	// The properties of a ClientEncryptionKey
	Properties *ClientEncryptionKeyGetProperties

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// ClientEncryptionKeyResource - Cosmos DB client encryption key resource object.
type ClientEncryptionKeyResource struct {
	// Encryption algorithm that will be used along with this client encryption key to encrypt/decrypt data.
	EncryptionAlgorithm *string

	// Name of the ClientEncryptionKey
	ID *string

	// Metadata for the wrapping provider that can be used to unwrap the wrapped client encryption key.
	KeyWrapMetadata *KeyWrapMetadata

	// Wrapped (encrypted) form of the key represented as a byte array.
	WrappedDataEncryptionKey []byte
}

// ClientEncryptionKeysListResult - The List operation response, that contains the client encryption keys and their properties.
type ClientEncryptionKeysListResult struct {
	// READ-ONLY; List of client encryption keys and their properties.
	Value []*ClientEncryptionKeyGetResults
}

// ClientEncryptionPolicy - Cosmos DB client encryption policy.
type ClientEncryptionPolicy struct {
	// REQUIRED; Paths of the item that need encryption along with path-specific settings.
	IncludedPaths []*ClientEncryptionIncludedPath

	// REQUIRED; Version of the client encryption policy definition. Supported versions are 1 and 2. Version 2 supports id and
	// partition key path encryption.
	PolicyFormatVersion *int32
}

// ClusterKey - Cosmos DB Cassandra table cluster key
type ClusterKey struct {
	// Name of the Cosmos DB Cassandra table cluster key
	Name *string

	// Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
	OrderBy *string
}

// ClusterResource - Representation of a managed Cassandra cluster.
type ClusterResource struct {
	// Identity for the resource.
	Identity *ManagedCassandraManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Properties of a managed Cassandra cluster.
	Properties *ClusterResourceProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// ClusterResourceProperties - Properties of a managed Cassandra cluster.
type ClusterResourceProperties struct {
	// Which authentication method Cassandra should use to authenticate clients. 'None' turns off authentication, so should not
	// be used except in emergencies. 'Cassandra' is the default password based
	// authentication. The default is 'Cassandra'.
	AuthenticationMethod *AuthenticationMethod

	// Whether Cassandra audit logging is enabled
	CassandraAuditLoggingEnabled *bool

	// Which version of Cassandra should this cluster converge to running (e.g., 3.11). When updated, the cluster may take some
	// time to migrate to the new version.
	CassandraVersion *string

	// List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether
	// clientCertificates is set or not, but if clientCertificates is set, the managed
	// Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more
	// of the public certificates in this property.
	ClientCertificates []*Certificate

	// If you need to set the clusterName property in cassandra.yaml to something besides the resource name of the cluster, set
	// the value to use on this property.
	ClusterNameOverride *string

	// Whether the cluster and associated data centers has been deallocated.
	Deallocated *bool

	// Resource id of a subnet that this cluster's management service should have its network interface attached to. The subnet
	// must be routable to all subnets that will be delegated to data centers. The
	// resource id must be of the form '/subscriptions//resourceGroups//providers/Microsoft.Network/virtualNetworks//subnets/'
	DelegatedManagementSubnetID *string

	// List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged
	// data centers must be verifiable using one of the certificates provided in
	// this property.
	ExternalGossipCertificates []*Certificate

	// List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed
	// nodes.
	ExternalSeedNodes []*SeedNode

	// (Deprecated) Number of hours to wait between taking a backup of the cluster.
	HoursBetweenBackups *int32

	// Initial password for clients connecting as admin to the cluster. Should be changed after cluster creation. Returns null
	// on GET. This field only applies when the authenticationMethod field is
	// 'Cassandra'.
	InitialCassandraAdminPassword *string

	// Hostname or IP address where the Prometheus endpoint containing data about the managed Cassandra nodes can be reached.
	PrometheusEndpoint *SeedNode

	// Error related to resource provisioning.
	ProvisionError *CassandraError

	// The status of the resource at the time the operation was called.
	ProvisioningState *ManagedCassandraProvisioningState

	// Should automatic repairs run on this cluster? If omitted, this is true, and should stay true unless you are running a hybrid
	// cluster where you are already doing your own repairs.
	RepairEnabled *bool

	// To create an empty cluster, omit this field or set it to null. To restore a backup into a new cluster, set this field to
	// the resource id of the backup.
	RestoreFromBackupID *string

	// READ-ONLY; List of TLS certificates that unmanaged nodes must trust for gossip with managed nodes. All managed nodes will
	// present TLS client certificates that are verifiable using one of the certificates
	// provided in this property.
	GossipCertificates []*Certificate

	// READ-ONLY; List of IP addresses of seed nodes in the managed data centers. These should be added to the seed node lists
	// of all unmanaged nodes.
	SeedNodes []*SeedNode
}

// Column - Cosmos DB Cassandra table column
type Column struct {
	// Name of the Cosmos DB Cassandra table column
	Name *string

	// Type of the Cosmos DB Cassandra table column
	Type *string
}

// CommandOutput - Response of /command api
type CommandOutput struct {
	// Output of the command.
	CommandOutput *string
}

// CommandPostBody - Specification of which command to run where
type CommandPostBody struct {
	// REQUIRED; The command which should be run
	Command *string

	// REQUIRED; IP address of the cassandra host to run the command on
	Host *string

	// The arguments for the command to be run
	Arguments map[string]*string

	// If true, stops cassandra before executing the command and then start it again
	CassandraStopStart *bool

	// If true, allows the command to write to the cassandra directory, otherwise read-only.
	Readwrite *bool
}

type Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string
}

type ComponentsM9L909SchemasCassandraclusterpublicstatusPropertiesDatacentersItemsPropertiesNodesItems struct {
	// The node's IP address.
	Address *string

	// A float representing the current system-wide CPU utilization as a percentage.
	CPUUsage *float64

	// Cassandra service status on this node
	CassandraProcessStatus *string

	// The amount of disk free, in kB, of the directory /var/lib/cassandra.
	DiskFreeKB *int64

	// The amount of disk used, in kB, of the directory /var/lib/cassandra.
	DiskUsedKB *int64

	// The network ID of the node.
	HostID *string

	// The amount of file system data in the data directory (e.g., 47.66 kB), excluding all content in the snapshots subdirectories.
	// Because all SSTable data files are included, any data that is not cleaned
	// up (such as TTL-expired cells or tombstones) is counted.
	Load *string

	// Memory used by kernel buffers (Buffers in /proc/meminfo) and page cache and slabs (Cached and SReclaimable in /proc/meminfo),
	// in kB.
	MemoryBuffersAndCachedKB *int64

	// Unused memory (MemFree and SwapFree in /proc/meminfo), in kB.
	MemoryFreeKB *int64

	// Total installed memory (MemTotal and SwapTotal in /proc/meminfo), in kB.
	MemoryTotalKB *int64

	// Used memory (calculated as total - free - buffers - cache), in kB.
	MemoryUsedKB *int64

	// The rack this node is part of.
	Rack *string
	Size *int32

	// The state of the node in Cassandra ring.
	State  *NodeState
	Status *string

	// The timestamp when these statistics were captured.
	Timestamp *string

	// List of tokens this node covers.
	Tokens []*string
}

type CompositePath struct {
	// Sort order for composite paths.
	Order *CompositePathSortOrder

	// The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string
}

// ConflictResolutionPolicy - The conflict resolution policy for the container.
type ConflictResolutionPolicy struct {
	// The conflict resolution path in the case of LastWriterWins mode.
	ConflictResolutionPath *string

	// The procedure to resolve conflicts in the case of custom mode.
	ConflictResolutionProcedure *string

	// Indicates the conflict resolution mode.
	Mode *ConflictResolutionMode
}

type ConnectionError struct {
	// The kind of connection error that occurred.
	ConnectionState *ConnectionState

	// Detailed error message about the failed connection.
	Exception *string

	// The IP of host that originated the failed connection.
	IPFrom *string

	// The IP that the connection attempted to reach.
	IPTo *string

	// The TCP port the connection was attempted on.
	Port *int32
}

// ConnectionString - Connection string for the mongo cluster
type ConnectionString struct {
	// READ-ONLY; Value of the connection string
	ConnectionString *string

	// READ-ONLY; Description of the connection string
	Description *string
}

// ConsistencyPolicy - The consistency policy for the Cosmos DB database account.
type ConsistencyPolicy struct {
	// REQUIRED; The default consistency level and configuration settings of the Cosmos DB account.
	DefaultConsistencyLevel *DefaultConsistencyLevel

	// When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds)
	// tolerated. Accepted range for this value is 5 - 86400. Required when
	// defaultConsistencyPolicy is set to 'BoundedStaleness'.
	MaxIntervalInSeconds *int32

	// When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted
	// range for this value is 1 – 2,147,483,647. Required when
	// defaultConsistencyPolicy is set to 'BoundedStaleness'.
	MaxStalenessPrefix *int64
}

// ContainerPartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
type ContainerPartitionKey struct {
	// Indicates the kind of algorithm used for partitioning. For MultiHash, multiple partition keys (upto three maximum) are
	// supported for container create
	Kind *PartitionKind

	// List of paths using which data within the container can be partitioned
	Paths []*string

	// Indicates the version of the partition key definition
	Version *int32

	// READ-ONLY; Indicates if the container is using a system generated partition key
	SystemKey *bool
}

// ContinuousBackupInformation - Information about the status of continuous backups.
type ContinuousBackupInformation struct {
	// The latest restorable timestamp for a resource.
	LatestRestorableTimestamp *string
}

// ContinuousBackupRestoreLocation - Properties of the regional restorable account.
type ContinuousBackupRestoreLocation struct {
	// The name of the continuous backup restore location.
	Location *string
}

// ContinuousModeBackupPolicy - The object representing continuous mode backup policy.
type ContinuousModeBackupPolicy struct {
	// REQUIRED; Describes the mode of backups.
	Type *BackupPolicyType

	// Configuration values for continuous mode backup
	ContinuousModeProperties *ContinuousModeProperties

	// The object representing the state of the migration between the backup policies.
	MigrationState *BackupPolicyMigrationState
}

// GetBackupPolicy implements the BackupPolicyClassification interface for type ContinuousModeBackupPolicy.
func (c *ContinuousModeBackupPolicy) GetBackupPolicy() *BackupPolicy {
	return &BackupPolicy{
		MigrationState: c.MigrationState,
		Type:           c.Type,
	}
}

// ContinuousModeProperties - Configuration values for periodic mode backup
type ContinuousModeProperties struct {
	// Enum to indicate type of Continuos backup mode
	Tier *ContinuousTier
}

// CorsPolicy - The CORS policy for the Cosmos DB database account.
type CorsPolicy struct {
	// REQUIRED; The origin domains that are permitted to make a request against the service via CORS.
	AllowedOrigins *string

	// The request headers that the origin domain may specify on the CORS request.
	AllowedHeaders *string

	// The methods (HTTP request verbs) that the origin domain may use for a CORS request.
	AllowedMethods *string

	// The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer.
	ExposedHeaders *string

	// The maximum amount time that a browser should cache the preflight OPTIONS request.
	MaxAgeInSeconds *int64
}

// CreateJobRequest - Parameters to create Data Transfer Job
type CreateJobRequest struct {
	// REQUIRED; Data Transfer Create Job Properties
	Properties *DataTransferJobProperties

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are "If-Match", "If-None-Match",
// "Session-Token" and "Throughput"
type CreateUpdateOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings

	// Request Units per second. For example, "throughput": 10000.
	Throughput *int32
}

// DataCenterResource - A managed Cassandra data center.
type DataCenterResource struct {
	// Properties of a managed Cassandra data center.
	Properties *DataCenterResourceProperties

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// DataCenterResourceProperties - Properties of a managed Cassandra data center.
type DataCenterResourceProperties struct {
	// Ldap authentication method properties. This feature is in preview.
	AuthenticationMethodLdapProperties *AuthenticationMethodLdapProperties

	// If the data center has Availability Zone support, apply it to the Virtual Machine ScaleSet that host the cassandra data
	// center virtual machines.
	AvailabilityZone *bool

	// Indicates the Key Uri of the customer key to use for encryption of the backup storage account.
	BackupStorageCustomerKeyURI *string

	// A fragment of a cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this data center.
	// The fragment should be Base64 encoded, and only a subset of keys are allowed.
	Base64EncodedCassandraYamlFragment *string

	// The region this data center should be created in.
	DataCenterLocation *string

	// Whether the data center has been deallocated.
	Deallocated *bool

	// Resource id of a subnet the nodes in this data center should have their network interfaces connected to. The subnet must
	// be in the same region specified in 'dataCenterLocation' and must be able to
	// route to the subnet specified in the cluster's 'delegatedManagementSubnetId' property. This resource id will be of the
	// form '/subscriptions//resourceGroups/
	// /providers/Microsoft.Network/virtualNetworks//subnets/'.
	DelegatedSubnetID *string

	// Number of disks attached to each node. Default is 4.
	DiskCapacity *int32

	// Disk SKU used for data centers. Default value is P30.
	DiskSKU *string

	// Key uri to use for encryption of managed disks. Ensure the system assigned identity of the cluster has been assigned appropriate
	// permissions(key get/wrap/unwrap permissions) on the key.
	ManagedDiskCustomerKeyURI *string

	// The number of nodes the data center should have. This is the desired number. After it is set, it may take some time for
	// the data center to be scaled to match. To monitor the number of nodes and their
	// status, use the fetchNodeStatus method on the cluster.
	NodeCount *int32

	// Error related to resource provisioning.
	ProvisionError *CassandraError

	// The status of the resource at the time the operation was called.
	ProvisioningState *ManagedCassandraProvisioningState

	// Virtual Machine SKU used for data centers. Default value is StandardDS14v2
	SKU *string

	// READ-ONLY; IP addresses for seed nodes in this data center. This is for reference. Generally you will want to use the seedNodes
	// property on the cluster, which aggregates the seed nodes from all data centers in
	// the cluster.
	SeedNodes []*SeedNode
}

// DataTransferDataSourceSink - Base class for all DataTransfer source/sink
type DataTransferDataSourceSink struct {
	// REQUIRED
	Component *DataTransferComponent
}

// GetDataTransferDataSourceSink implements the DataTransferDataSourceSinkClassification interface for type DataTransferDataSourceSink.
func (d *DataTransferDataSourceSink) GetDataTransferDataSourceSink() *DataTransferDataSourceSink {
	return d
}

// DataTransferJobFeedResults - The List operation response, that contains the Data Transfer jobs and their properties.
type DataTransferJobFeedResults struct {
	// READ-ONLY; URL to get the next set of Data Transfer job list results if there are any.
	NextLink *string

	// READ-ONLY; List of Data Transfer jobs and their properties.
	Value []*DataTransferJobGetResults
}

// DataTransferJobGetResults - A Cosmos DB Data Transfer Job
type DataTransferJobGetResults struct {
	// The properties of a DataTransfer Job
	Properties *DataTransferJobProperties

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// DataTransferJobProperties - The properties of a DataTransfer Job
type DataTransferJobProperties struct {
	// REQUIRED; Destination DataStore details
	Destination DataTransferDataSourceSinkClassification

	// REQUIRED; Source DataStore details
	Source DataTransferDataSourceSinkClassification

	// Worker count
	WorkerCount *int32

	// READ-ONLY; Error response for Faulted job
	Error *ErrorResponse

	// READ-ONLY; Job Name
	JobName *string

	// READ-ONLY; Last Updated Time (ISO-8601 format).
	LastUpdatedUTCTime *time.Time

	// READ-ONLY; Processed Count.
	ProcessedCount *int64

	// READ-ONLY; Job Status
	Status *string

	// READ-ONLY; Total Count.
	TotalCount *int64
}

// DataTransferRegionalServiceResource - Resource for a regional service location.
type DataTransferRegionalServiceResource struct {
	// READ-ONLY; The location name.
	Location *string

	// READ-ONLY; The regional service name.
	Name *string

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus
}

// DataTransferServiceResource - Describes the service response property.
type DataTransferServiceResource struct {
	// Properties for DataTransferServiceResource.
	Properties *DataTransferServiceResourceProperties
}

// DataTransferServiceResourceProperties - Properties for DataTransferServiceResource.
type DataTransferServiceResourceProperties struct {
	// REQUIRED; ServiceType for the service.
	ServiceType *ServiceType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Instance count for the service.
	InstanceCount *int32

	// Instance type for the service.
	InstanceSize *ServiceSize

	// READ-ONLY; Time of the last state change (ISO-8601 format).
	CreationTime *time.Time

	// READ-ONLY; An array that contains all of the locations for the service.
	Locations []*DataTransferRegionalServiceResource

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus
}

// GetServiceResourceProperties implements the ServiceResourcePropertiesClassification interface for type DataTransferServiceResourceProperties.
func (d *DataTransferServiceResourceProperties) GetServiceResourceProperties() *ServiceResourceProperties {
	return &ServiceResourceProperties{
		AdditionalProperties: d.AdditionalProperties,
		CreationTime:         d.CreationTime,
		InstanceCount:        d.InstanceCount,
		InstanceSize:         d.InstanceSize,
		ServiceType:          d.ServiceType,
		Status:               d.Status,
	}
}

// DatabaseAccountConnectionString - Connection string for the Cosmos DB account
type DatabaseAccountConnectionString struct {
	// READ-ONLY; Value of the connection string
	ConnectionString *string

	// READ-ONLY; Description of the connection string
	Description *string

	// READ-ONLY; Kind of the connection string key
	KeyKind *Kind

	// READ-ONLY; Type of the connection string
	Type *Type
}

// DatabaseAccountCreateUpdateParameters - Parameters to create and update Cosmos DB database accounts.
type DatabaseAccountCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB database accounts.
	Properties *DatabaseAccountCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// Indicates the type of database account. This can only be set at database account creation.
	Kind *DatabaseAccountKind

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// DatabaseAccountCreateUpdateProperties - Properties to create and update Azure Cosmos DB database accounts.
type DatabaseAccountCreateUpdateProperties struct {
	// CONSTANT; The offer type for the database
	// Field has constant value "Standard", any specified value is ignored.
	DatabaseAccountOfferType *string

	// REQUIRED; An array that contains the georeplication locations enabled for the Cosmos DB account.
	Locations []*Location

	// API specific properties. Currently, supported only for MongoDB API.
	APIProperties *APIProperties

	// Analytical storage specific properties.
	AnalyticalStorageConfiguration *AnalyticalStorageConfiguration

	// The object representing the policy for taking backups on an account.
	BackupPolicy BackupPolicyClassification

	// List of Cosmos DB capabilities for the account
	Capabilities []*Capability

	// The object that represents all properties related to capacity enforcement on an account.
	Capacity *Capacity

	// The cassandra connector offer type for the Cosmos DB database C* account.
	ConnectorOffer *ConnectorOffer

	// The consistency policy for the Cosmos DB account.
	ConsistencyPolicy *ConsistencyPolicy

	// The CORS policy for the Cosmos DB database account.
	Cors []*CorsPolicy

	// Enum to indicate the mode of account creation.
	CreateMode *CreateMode

	// The default identity for accessing key vault used in features like customer managed keys. The default identity needs to
	// be explicitly set by the users. It can be "FirstPartyIdentity",
	// "SystemAssignedIdentity" and more.
	DefaultIdentity *string

	// The Object representing the different Diagnostic log settings for the Cosmos DB Account.
	DiagnosticLogSettings *DiagnosticLogSettings

	// Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool

	// Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
	DisableLocalAuth *bool

	// Flag to indicate whether to enable storage analytics.
	EnableAnalyticalStorage *bool

	// Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic
	// failover will result in a new write region for the account and is chosen
	// based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool

	// Flag to indicate enabling/disabling of Burst Capacity Preview feature on the account
	EnableBurstCapacity *bool

	// Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool

	// Flag to indicate whether Free Tier is enabled.
	EnableFreeTier *bool

	// Flag to indicate whether to enable MaterializedViews on the Cosmos DB account
	EnableMaterializedViews *bool

	// Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool

	// Flag to indicate enabling/disabling of Partition Merge feature on the account
	EnablePartitionMerge *bool

	// List of IpRules.
	IPRules []*IPAddressOrRange

	// Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool

	// The URI of the key vault
	KeyVaultKeyURI *string

	// Indicates the minimum allowed Tls version. The default is Tls 1.0, except for Cassandra and Mongo API's, which only work
	// with Tls 1.2.
	MinimalTLSVersion *MinimalTLSVersion

	// Indicates what services are allowed to bypass firewall checks.
	NetworkACLBypass *NetworkACLBypass

	// An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
	NetworkACLBypassResourceIDs []*string

	// Whether requests from Public Network are allowed
	PublicNetworkAccess *PublicNetworkAccess

	// Parameters to indicate the information about the restore.
	RestoreParameters *RestoreParameters

	// List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules []*VirtualNetworkRule

	// READ-ONLY; This property is ignored during the update/create operation, as the metadata is read-only. The object represents
	// the metadata for the Account Keys of the Cosmos DB account.
	KeysMetadata *DatabaseAccountKeysMetadata
}

// DatabaseAccountGetProperties - Properties for the database account.
type DatabaseAccountGetProperties struct {
	// API specific properties.
	APIProperties *APIProperties

	// Analytical storage specific properties.
	AnalyticalStorageConfiguration *AnalyticalStorageConfiguration

	// The object representing the policy for taking backups on an account.
	BackupPolicy BackupPolicyClassification

	// List of Cosmos DB capabilities for the account
	Capabilities []*Capability

	// The object that represents all properties related to capacity enforcement on an account.
	Capacity *Capacity

	// The cassandra connector offer type for the Cosmos DB database C* account.
	ConnectorOffer *ConnectorOffer

	// The consistency policy for the Cosmos DB database account.
	ConsistencyPolicy *ConsistencyPolicy

	// The CORS policy for the Cosmos DB database account.
	Cors []*CorsPolicy

	// Enum to indicate the mode of account creation.
	CreateMode *CreateMode

	// The default identity for accessing key vault used in features like customer managed keys. The default identity needs to
	// be explicitly set by the users. It can be "FirstPartyIdentity",
	// "SystemAssignedIdentity" and more.
	DefaultIdentity *string

	// The Object representing the different Diagnostic log settings for the Cosmos DB Account.
	DiagnosticLogSettings *DiagnosticLogSettings

	// Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool

	// Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
	DisableLocalAuth *bool

	// Flag to indicate whether to enable storage analytics.
	EnableAnalyticalStorage *bool

	// Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic
	// failover will result in a new write region for the account and is chosen
	// based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool

	// Flag to indicate enabling/disabling of Burst Capacity Preview feature on the account
	EnableBurstCapacity *bool

	// Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool

	// Flag to indicate whether Free Tier is enabled.
	EnableFreeTier *bool

	// Flag to indicate whether to enable MaterializedViews on the Cosmos DB account
	EnableMaterializedViews *bool

	// Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool

	// Flag to indicate enabling/disabling of Partition Merge feature on the account
	EnablePartitionMerge *bool

	// List of IpRules.
	IPRules []*IPAddressOrRange

	// Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool

	// The URI of the key vault
	KeyVaultKeyURI *string

	// Indicates the minimum allowed Tls version. The default is Tls 1.0, except for Cassandra and Mongo API's, which only work
	// with Tls 1.2.
	MinimalTLSVersion *MinimalTLSVersion

	// Indicates what services are allowed to bypass firewall checks.
	NetworkACLBypass *NetworkACLBypass

	// An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
	NetworkACLBypassResourceIDs []*string

	// Whether requests from Public Network are allowed
	PublicNetworkAccess *PublicNetworkAccess

	// Parameters to indicate the information about the restore.
	RestoreParameters *RestoreParameters

	// List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules []*VirtualNetworkRule

	// READ-ONLY; The offer type for the Cosmos DB database account. Default value: Standard.
	DatabaseAccountOfferType *string

	// READ-ONLY; The connection endpoint for the Cosmos DB database account.
	DocumentEndpoint *string

	// READ-ONLY; An array that contains the regions ordered by their failover priorities.
	FailoverPolicies []*FailoverPolicy

	// READ-ONLY; A unique identifier assigned to the database account
	InstanceID *string

	// READ-ONLY; The object that represents the metadata for the Account Keys of the Cosmos DB account.
	KeysMetadata *DatabaseAccountKeysMetadata

	// READ-ONLY; An array that contains all of the locations enabled for the Cosmos DB account.
	Locations []*Location

	// READ-ONLY; List of Private Endpoint Connections configured for the Cosmos DB account.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; The status of the Cosmos DB account at the time the operation was called. The status can be one of following.
	// 'Creating' – the Cosmos DB account is being created. When an account is in Creating state,
	// only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the
	// Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being
	// updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed'
	// – the Cosmos DB account deletion failed.
	ProvisioningState *string

	// READ-ONLY; An array that contains of the read locations enabled for the Cosmos DB account.
	ReadLocations []*Location

	// READ-ONLY; An array that contains the write location for the Cosmos DB account.
	WriteLocations []*Location
}

// DatabaseAccountGetResults - An Azure Cosmos DB database account.
type DatabaseAccountGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// Indicates the type of database account. This can only be set at database account creation.
	Kind *DatabaseAccountKind

	// The location of the resource group to which the resource belongs.
	Location *string

	// Properties for the database account.
	Properties *DatabaseAccountGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The system meta data relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// DatabaseAccountKeysMetadata - The metadata related to each access key for the given Cosmos DB database account.
type DatabaseAccountKeysMetadata struct {
	// READ-ONLY; The metadata related to the Primary Read-Write Key for the given Cosmos DB database account.
	PrimaryMasterKey *AccountKeyMetadata

	// READ-ONLY; The metadata related to the Primary Read-Only Key for the given Cosmos DB database account.
	PrimaryReadonlyMasterKey *AccountKeyMetadata

	// READ-ONLY; The metadata related to the Secondary Read-Write Key for the given Cosmos DB database account.
	SecondaryMasterKey *AccountKeyMetadata

	// READ-ONLY; The metadata related to the Secondary Read-Only Key for the given Cosmos DB database account.
	SecondaryReadonlyMasterKey *AccountKeyMetadata
}

// DatabaseAccountListConnectionStringsResult - The connection strings for the given database account.
type DatabaseAccountListConnectionStringsResult struct {
	// An array that contains the connection strings for the Cosmos DB account.
	ConnectionStrings []*DatabaseAccountConnectionString
}

// DatabaseAccountListKeysResult - The access keys for the given database account.
type DatabaseAccountListKeysResult struct {
	// READ-ONLY; Base 64 encoded value of the primary read-write key.
	PrimaryMasterKey *string

	// READ-ONLY; Base 64 encoded value of the primary read-only key.
	PrimaryReadonlyMasterKey *string

	// READ-ONLY; Base 64 encoded value of the secondary read-write key.
	SecondaryMasterKey *string

	// READ-ONLY; Base 64 encoded value of the secondary read-only key.
	SecondaryReadonlyMasterKey *string
}

// DatabaseAccountListReadOnlyKeysResult - The read-only access keys for the given database account.
type DatabaseAccountListReadOnlyKeysResult struct {
	// READ-ONLY; Base 64 encoded value of the primary read-only key.
	PrimaryReadonlyMasterKey *string

	// READ-ONLY; Base 64 encoded value of the secondary read-only key.
	SecondaryReadonlyMasterKey *string
}

// DatabaseAccountRegenerateKeyParameters - Parameters to regenerate the keys within the database account.
type DatabaseAccountRegenerateKeyParameters struct {
	// REQUIRED; The access key to regenerate.
	KeyKind *KeyKind
}

// DatabaseAccountUpdateParameters - Parameters for patching Azure Cosmos DB database account properties.
type DatabaseAccountUpdateParameters struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Properties to update Azure Cosmos DB database accounts.
	Properties *DatabaseAccountUpdateProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string
}

// DatabaseAccountUpdateProperties - Properties to update Azure Cosmos DB database accounts.
type DatabaseAccountUpdateProperties struct {
	// API specific properties. Currently, supported only for MongoDB API.
	APIProperties *APIProperties

	// Analytical storage specific properties.
	AnalyticalStorageConfiguration *AnalyticalStorageConfiguration

	// The object representing the policy for taking backups on an account.
	BackupPolicy BackupPolicyClassification

	// List of Cosmos DB capabilities for the account
	Capabilities []*Capability

	// The object that represents all properties related to capacity enforcement on an account.
	Capacity *Capacity

	// The cassandra connector offer type for the Cosmos DB database C* account.
	ConnectorOffer *ConnectorOffer

	// The consistency policy for the Cosmos DB account.
	ConsistencyPolicy *ConsistencyPolicy

	// The CORS policy for the Cosmos DB database account.
	Cors []*CorsPolicy

	// The default identity for accessing key vault used in features like customer managed keys. The default identity needs to
	// be explicitly set by the users. It can be "FirstPartyIdentity",
	// "SystemAssignedIdentity" and more.
	DefaultIdentity *string

	// The Object representing the different Diagnostic log settings for the Cosmos DB Account.
	DiagnosticLogSettings *DiagnosticLogSettings

	// Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool

	// Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
	DisableLocalAuth *bool

	// Flag to indicate whether to enable storage analytics.
	EnableAnalyticalStorage *bool

	// Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic
	// failover will result in a new write region for the account and is chosen
	// based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool

	// Flag to indicate enabling/disabling of Burst Capacity Preview feature on the account
	EnableBurstCapacity *bool

	// Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool

	// Flag to indicate whether Free Tier is enabled.
	EnableFreeTier *bool

	// Flag to indicate whether to enable MaterializedViews on the Cosmos DB account
	EnableMaterializedViews *bool

	// Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool

	// Flag to indicate enabling/disabling of Partition Merge feature on the account
	EnablePartitionMerge *bool

	// List of IpRules.
	IPRules []*IPAddressOrRange

	// Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool

	// The URI of the key vault
	KeyVaultKeyURI *string

	// An array that contains the georeplication locations enabled for the Cosmos DB account.
	Locations []*Location

	// Indicates the minimum allowed Tls version. The default is Tls 1.0, except for Cassandra and Mongo API's, which only work
	// with Tls 1.2.
	MinimalTLSVersion *MinimalTLSVersion

	// Indicates what services are allowed to bypass firewall checks.
	NetworkACLBypass *NetworkACLBypass

	// An array that contains the Resource Ids for Network Acl Bypass for the Cosmos DB account.
	NetworkACLBypassResourceIDs []*string

	// Whether requests from Public Network are allowed
	PublicNetworkAccess *PublicNetworkAccess

	// List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules []*VirtualNetworkRule

	// READ-ONLY; This property is ignored during the update operation, as the metadata is read-only. The object represents the
	// metadata for the Account Keys of the Cosmos DB account.
	KeysMetadata *DatabaseAccountKeysMetadata
}

// DatabaseAccountsListResult - The List operation response, that contains the database accounts and their properties.
type DatabaseAccountsListResult struct {
	// READ-ONLY; List of database account and their properties.
	Value []*DatabaseAccountGetResults
}

// DatabaseRestoreResource - Specific Databases to restore.
type DatabaseRestoreResource struct {
	// The names of the collections available for restore.
	CollectionNames []*string

	// The name of the database available for restore.
	DatabaseName *string
}

// DiagnosticLogSettings - Indicates what diagnostic log settings are to be enabled.
type DiagnosticLogSettings struct {
	// Describe the level of detail with which queries are to be logged.
	EnableFullTextQuery *EnableFullTextQuery
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Error Response.
type ErrorResponse struct {
	// Error code.
	Code *string

	// Error message indicating why the operation failed.
	Message *string
}

// ErrorResponseAutoGenerated - Common error response for all Azure Resource Manager APIs to return error details for failed
// operations. (This also follows the OData error response format.).
type ErrorResponseAutoGenerated struct {
	// The error object.
	Error *ErrorDetail
}

type ExcludedPath struct {
	// The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string
}

// ExtendedResourceProperties - The system generated resource properties associated with SQL databases, SQL containers, Gremlin
// databases and Gremlin graphs.
type ExtendedResourceProperties struct {
	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// FailoverPolicies - The list of new failover policies for the failover priority change.
type FailoverPolicies struct {
	// REQUIRED; List of failover policies.
	FailoverPolicies []*FailoverPolicy
}

// FailoverPolicy - The failover policy for a given region of a database account.
type FailoverPolicy struct {
	// The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover
	// priority = (total number of regions - 1). Failover priority values must be
	// unique for each of the regions in which the database account exists.
	FailoverPriority *int32

	// The name of the region in which the database account exists.
	LocationName *string

	// READ-ONLY; The unique identifier of the region in which the database account replicates to. Example: <accountName>-<locationName>.
	ID *string
}

// FirewallRule - Represents a mongo cluster firewall rule.
type FirewallRule struct {
	// REQUIRED; The properties of a firewall rule.
	Properties *FirewallRuleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FirewallRuleListResult - A list of firewall rules.
type FirewallRuleListResult struct {
	// The list of firewall rules in a mongo cluster.
	Value []*FirewallRule

	// READ-ONLY; The link used to get the next page of results.
	NextLink *string
}

// FirewallRuleProperties - The properties of a mongo cluster firewall rule.
type FirewallRuleProperties struct {
	// REQUIRED; The end IP address of the mongo cluster firewall rule. Must be IPv4 format.
	EndIPAddress *string

	// REQUIRED; The start IP address of the mongo cluster firewall rule. Must be IPv4 format.
	StartIPAddress *string

	// READ-ONLY; The provisioning state of the firewall rule.
	ProvisioningState *ProvisioningState
}

// GraphAPIComputeRegionalServiceResource - Resource for a regional service location.
type GraphAPIComputeRegionalServiceResource struct {
	// READ-ONLY; The regional endpoint for GraphAPICompute.
	GraphAPIComputeEndpoint *string

	// READ-ONLY; The location name.
	Location *string

	// READ-ONLY; The regional service name.
	Name *string

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus
}

// GraphAPIComputeServiceResource - Describes the service response property for GraphAPICompute.
type GraphAPIComputeServiceResource struct {
	// Properties for GraphAPIComputeServiceResource.
	Properties *GraphAPIComputeServiceResourceProperties
}

// GraphAPIComputeServiceResourceProperties - Properties for GraphAPIComputeServiceResource.
type GraphAPIComputeServiceResourceProperties struct {
	// REQUIRED; ServiceType for the service.
	ServiceType *ServiceType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// GraphAPICompute endpoint for the service.
	GraphAPIComputeEndpoint *string

	// Instance count for the service.
	InstanceCount *int32

	// Instance type for the service.
	InstanceSize *ServiceSize

	// READ-ONLY; Time of the last state change (ISO-8601 format).
	CreationTime *time.Time

	// READ-ONLY; An array that contains all of the locations for the service.
	Locations []*GraphAPIComputeRegionalServiceResource

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus
}

// GetServiceResourceProperties implements the ServiceResourcePropertiesClassification interface for type GraphAPIComputeServiceResourceProperties.
func (g *GraphAPIComputeServiceResourceProperties) GetServiceResourceProperties() *ServiceResourceProperties {
	return &ServiceResourceProperties{
		AdditionalProperties: g.AdditionalProperties,
		CreationTime:         g.CreationTime,
		InstanceCount:        g.InstanceCount,
		InstanceSize:         g.InstanceSize,
		ServiceType:          g.ServiceType,
		Status:               g.Status,
	}
}

// GraphResource - Cosmos DB Graph resource object
type GraphResource struct {
	// REQUIRED; Name of the Cosmos DB Graph
	ID *string
}

// GraphResourceCreateUpdateParameters - Parameters to create and update Cosmos DB Graph resource.
type GraphResourceCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Graph resource.
	Properties *GraphResourceCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// GraphResourceCreateUpdateProperties - Properties to create and update Azure Cosmos DB Graph resource.
type GraphResourceCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Graph resource
	Resource *GraphResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// GraphResourceGetProperties - The properties of an Azure Cosmos DB SQL database
type GraphResourceGetProperties struct {
	Options  *GraphResourceGetPropertiesOptions
	Resource *GraphResourceGetPropertiesResource
}

type GraphResourceGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32
}

type GraphResourceGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB Graph
	ID *string
}

// GraphResourceGetResults - An Azure Cosmos DB Graph resource.
type GraphResourceGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB Graph resource.
	Properties *GraphResourceGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// GraphResourcesListResult - The List operation response, that contains the Graph resource and their properties.
type GraphResourcesListResult struct {
	// READ-ONLY; List of Graph resource and their properties.
	Value []*GraphResourceGetResults
}

// GremlinDatabaseCreateUpdateParameters - Parameters to create and update Cosmos DB Gremlin database.
type GremlinDatabaseCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Gremlin database.
	Properties *GremlinDatabaseCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// GremlinDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB Gremlin database.
type GremlinDatabaseCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Gremlin database
	Resource *GremlinDatabaseResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// GremlinDatabaseGetProperties - The properties of an Azure Cosmos DB SQL database
type GremlinDatabaseGetProperties struct {
	Options  *GremlinDatabaseGetPropertiesOptions
	Resource *GremlinDatabaseGetPropertiesResource
}

type GremlinDatabaseGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32
}

type GremlinDatabaseGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB Gremlin database
	ID *string

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// GremlinDatabaseGetResults - An Azure Cosmos DB Gremlin database.
type GremlinDatabaseGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB SQL database
	Properties *GremlinDatabaseGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// GremlinDatabaseListResult - The List operation response, that contains the Gremlin databases and their properties.
type GremlinDatabaseListResult struct {
	// READ-ONLY; List of Gremlin databases and their properties.
	Value []*GremlinDatabaseGetResults
}

// GremlinDatabaseResource - Cosmos DB Gremlin database resource object
type GremlinDatabaseResource struct {
	// REQUIRED; Name of the Cosmos DB Gremlin database
	ID *string

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters
}

// GremlinDatabaseRestoreResource - Specific Gremlin Databases to restore.
type GremlinDatabaseRestoreResource struct {
	// The name of the gremlin database available for restore.
	DatabaseName *string

	// The names of the graphs available for restore.
	GraphNames []*string
}

// GremlinGraphCreateUpdateParameters - Parameters to create and update Cosmos DB Gremlin graph.
type GremlinGraphCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Gremlin graph.
	Properties *GremlinGraphCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// GremlinGraphCreateUpdateProperties - Properties to create and update Azure Cosmos DB Gremlin graph.
type GremlinGraphCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Gremlin graph
	Resource *GremlinGraphResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// GremlinGraphGetProperties - The properties of an Azure Cosmos DB Gremlin graph
type GremlinGraphGetProperties struct {
	Options  *GremlinGraphGetPropertiesOptions
	Resource *GremlinGraphGetPropertiesResource
}

type GremlinGraphGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32
}

type GremlinGraphGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB Gremlin graph
	ID *string

	// Analytical TTL.
	AnalyticalStorageTTL *int64

	// The conflict resolution policy for the graph.
	ConflictResolutionPolicy *ConflictResolutionPolicy

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Default time to live
	DefaultTTL *int32

	// The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
	IndexingPolicy *IndexingPolicy

	// The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters

	// The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos
	// DB service.
	UniqueKeyPolicy *UniqueKeyPolicy

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// GremlinGraphGetResults - An Azure Cosmos DB Gremlin graph.
type GremlinGraphGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB Gremlin graph
	Properties *GremlinGraphGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// GremlinGraphListResult - The List operation response, that contains the graphs and their properties.
type GremlinGraphListResult struct {
	// READ-ONLY; List of graphs and their properties.
	Value []*GremlinGraphGetResults
}

// GremlinGraphResource - Cosmos DB Gremlin graph resource object
type GremlinGraphResource struct {
	// REQUIRED; Name of the Cosmos DB Gremlin graph
	ID *string

	// Analytical TTL.
	AnalyticalStorageTTL *int64

	// The conflict resolution policy for the graph.
	ConflictResolutionPolicy *ConflictResolutionPolicy

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Default time to live
	DefaultTTL *int32

	// The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
	IndexingPolicy *IndexingPolicy

	// The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters

	// The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos
	// DB service.
	UniqueKeyPolicy *UniqueKeyPolicy
}

// IPAddressOrRange - IpAddressOrRange object
type IPAddressOrRange struct {
	// A single IPv4 address or a single IPv4 address range in CIDR format. Provided IPs must be well-formatted and cannot be
	// contained in one of the following ranges: 10.0.0.0/8, 100.64.0.0/10,
	// 172.16.0.0/12, 192.168.0.0/16, since these are not enforceable by the IP address filter. Example of valid inputs: “23.40.210.245”
	// or “23.40.210.0/8”.
	IPAddressOrRange *string
}

// IncludedPath - The paths that are included in indexing
type IncludedPath struct {
	// List of indexes for this path
	Indexes []*Indexes

	// The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string
}

// Indexes - The indexes for the path.
type Indexes struct {
	// The datatype for which the indexing behavior is applied to.
	DataType *DataType

	// Indicates the type of index.
	Kind *IndexKind

	// The precision of the index. -1 is maximum precision.
	Precision *int32
}

// IndexingPolicy - Cosmos DB indexing policy
type IndexingPolicy struct {
	// Indicates if the indexing policy is automatic
	Automatic *bool

	// List of composite path list
	CompositeIndexes [][]*CompositePath

	// List of paths to exclude from indexing
	ExcludedPaths []*ExcludedPath

	// List of paths to include in the indexing
	IncludedPaths []*IncludedPath

	// Indicates the indexing mode.
	IndexingMode *IndexingMode

	// List of spatial specifics
	SpatialIndexes []*SpatialSpec
}

// KeyWrapMetadata - Represents key wrap metadata that a key wrapping provider can use to wrap/unwrap a client encryption
// key.
type KeyWrapMetadata struct {
	// Algorithm used in wrapping and unwrapping of the data encryption key.
	Algorithm *string

	// The name of associated KeyEncryptionKey (aka CustomerManagedKey).
	Name *string

	// ProviderName of KeyStoreProvider.
	Type *string

	// Reference / link to the KeyEncryptionKey.
	Value *string
}

// ListBackups - List of restorable backups for a Cassandra cluster.
type ListBackups struct {
	// READ-ONLY; Container for array of backups.
	Value []*BackupResource
}

// ListClusters - List of managed Cassandra clusters.
type ListClusters struct {
	// Container for the array of clusters.
	Value []*ClusterResource
}

// ListConnectionStringsResult - The connection strings for the given mongo cluster.
type ListConnectionStringsResult struct {
	// READ-ONLY; An array that contains the connection strings for a mongo cluster.
	ConnectionStrings []*ConnectionString
}

// ListDataCenters - List of managed Cassandra data centers and their properties.
type ListDataCenters struct {
	// READ-ONLY; Container for array of data centers.
	Value []*DataCenterResource
}

// Location - A region in which the Azure Cosmos DB database account is deployed.
type Location struct {
	// The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover
	// priority = (total number of regions - 1). Failover priority values must be
	// unique for each of the regions in which the database account exists.
	FailoverPriority *int32

	// Flag to indicate whether or not this region is an AvailabilityZone region
	IsZoneRedundant *bool

	// The name of the region.
	LocationName *string

	// READ-ONLY; The connection endpoint for the specific region. Example: https://<accountName>-<locationName>.documents.azure.com:443/
	DocumentEndpoint *string

	// READ-ONLY; The unique identifier of the region within the database account. Example: <accountName>-<locationName>.
	ID *string

	// READ-ONLY; The status of the Cosmos DB account at the time the operation was called. The status can be one of following.
	// 'Creating' – the Cosmos DB account is being created. When an account is in Creating state,
	// only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the
	// Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being
	// updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed'
	// – the Cosmos DB account deletion failed.
	ProvisioningState *string
}

// LocationGetResult - Cosmos DB location get result
type LocationGetResult struct {
	// Cosmos DB location metadata
	Properties *LocationProperties

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// LocationListResult - The List operation response, that contains Cosmos DB locations and their properties.
type LocationListResult struct {
	// READ-ONLY; List of Cosmos DB locations and their properties.
	Value []*LocationGetResult
}

// LocationProperties - Cosmos DB location metadata
type LocationProperties struct {
	// READ-ONLY; The properties of available backup storage redundancies.
	BackupStorageRedundancies []*BackupStorageRedundancy

	// READ-ONLY; Flag indicating whether the location is residency sensitive.
	IsResidencyRestricted *bool

	// READ-ONLY; Flag indicating whether the subscription have access in region for Availability Zones(Az).
	IsSubscriptionRegionAccessAllowedForAz *bool

	// READ-ONLY; Flag indicating whether the subscription have access in region for Non-Availability Zones.
	IsSubscriptionRegionAccessAllowedForRegular *bool

	// READ-ONLY; Enum to indicate current buildout status of the region.
	Status *Status

	// READ-ONLY; Flag indicating whether the location supports availability zones or not.
	SupportsAvailabilityZone *bool
}

// ManagedCassandraARMResourceProperties - The core properties of ARM resources.
type ManagedCassandraARMResourceProperties struct {
	// Identity for the resource.
	Identity *ManagedCassandraManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// ManagedCassandraManagedServiceIdentity - Identity for the resource.
type ManagedCassandraManagedServiceIdentity struct {
	// The type of the resource.
	Type *ManagedCassandraResourceIdentityType

	// READ-ONLY; The object id of the identity resource.
	PrincipalID *string

	// READ-ONLY; The tenant id of the resource.
	TenantID *string
}

type ManagedCassandraReaperStatus struct {
	Healthy *bool

	// Dictionary of
	RepairRunIDs map[string]*string

	// Dictionary of
	RepairSchedules map[string]*string
}

// ManagedServiceIdentity - Identity for the resource.
type ManagedServiceIdentity struct {
	// The type of identity used for the resource. The type 'SystemAssigned,UserAssigned' includes both an implicitly created
	// identity and a set of user assigned identities. The type 'None' will remove any
	// identities from the service.
	Type *ResourceIdentityType

	// The list of user identities associated with resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties

	// READ-ONLY; The principal id of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant id of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// MaterializedViewDefinition - Materialized View definition for the container.
type MaterializedViewDefinition struct {
	// REQUIRED; The definition should be an SQL query which would be used to fetch data from the source container to populate
	// into the Materialized View container.
	Definition *string

	// REQUIRED; The name of the source container on which the Materialized View will be created.
	SourceCollectionID *string

	// READ-ONLY; An unique identifier for the source collection. This is a system generated property.
	SourceCollectionRid *string
}

// MaterializedViewsBuilderRegionalServiceResource - Resource for a regional service location.
type MaterializedViewsBuilderRegionalServiceResource struct {
	// READ-ONLY; The location name.
	Location *string

	// READ-ONLY; The regional service name.
	Name *string

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus
}

// MaterializedViewsBuilderServiceResource - Describes the service response property for MaterializedViewsBuilder.
type MaterializedViewsBuilderServiceResource struct {
	// Properties for MaterializedViewsBuilderServiceResource.
	Properties *MaterializedViewsBuilderServiceResourceProperties
}

// MaterializedViewsBuilderServiceResourceProperties - Properties for MaterializedViewsBuilderServiceResource.
type MaterializedViewsBuilderServiceResourceProperties struct {
	// REQUIRED; ServiceType for the service.
	ServiceType *ServiceType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Instance count for the service.
	InstanceCount *int32

	// Instance type for the service.
	InstanceSize *ServiceSize

	// READ-ONLY; Time of the last state change (ISO-8601 format).
	CreationTime *time.Time

	// READ-ONLY; An array that contains all of the locations for the service.
	Locations []*MaterializedViewsBuilderRegionalServiceResource

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus
}

// GetServiceResourceProperties implements the ServiceResourcePropertiesClassification interface for type MaterializedViewsBuilderServiceResourceProperties.
func (m *MaterializedViewsBuilderServiceResourceProperties) GetServiceResourceProperties() *ServiceResourceProperties {
	return &ServiceResourceProperties{
		AdditionalProperties: m.AdditionalProperties,
		CreationTime:         m.CreationTime,
		InstanceCount:        m.InstanceCount,
		InstanceSize:         m.InstanceSize,
		ServiceType:          m.ServiceType,
		Status:               m.Status,
	}
}

// MergeParameters - The properties of an Azure Cosmos DB merge operations
type MergeParameters struct {
	// Specifies whether the operation is a real merge operation or a simulation.
	IsDryRun *bool
}

// Metric data
type Metric struct {
	// READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *time.Time

	// READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues []*MetricValue

	// READ-ONLY; The name information for the metric.
	Name *MetricName

	// READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *time.Time

	// READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string

	// READ-ONLY; The unit of the metric.
	Unit *UnitType
}

// MetricAvailability - The availability of the metric.
type MetricAvailability struct {
	// READ-ONLY; The retention for the metric values.
	Retention *string

	// READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string
}

// MetricDefinition - The definition of a metric.
type MetricDefinition struct {
	// READ-ONLY; The list of metric availabilities for the account.
	MetricAvailabilities []*MetricAvailability

	// READ-ONLY; The name information for the metric.
	Name *MetricName

	// READ-ONLY; The primary aggregation type of the metric.
	PrimaryAggregationType *PrimaryAggregationType

	// READ-ONLY; The resource uri of the database.
	ResourceURI *string

	// READ-ONLY; The unit of the metric.
	Unit *UnitType
}

// MetricDefinitionsListResult - The response to a list metric definitions request.
type MetricDefinitionsListResult struct {
	// READ-ONLY; The list of metric definitions for the account.
	Value []*MetricDefinition
}

// MetricListResult - The response to a list metrics request.
type MetricListResult struct {
	// READ-ONLY; The list of metrics for the account.
	Value []*Metric
}

// MetricName - A metric name.
type MetricName struct {
	// READ-ONLY; The friendly name of the metric.
	LocalizedValue *string

	// READ-ONLY; The name of the metric.
	Value *string
}

// MetricValue - Represents metrics values.
type MetricValue struct {
	// READ-ONLY; The average value of the metric.
	Average *float64

	// READ-ONLY; The number of values for the metric.
	Count *int32

	// READ-ONLY; The max value of the metric.
	Maximum *float64

	// READ-ONLY; The min value of the metric.
	Minimum *float64

	// READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *time.Time

	// READ-ONLY; The total value of the metric.
	Total *float64
}

// MongoCluster - Represents a mongo cluster resource.
type MongoCluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Properties of the mongo cluster.
	Properties *MongoClusterProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MongoClusterListResult - A list of mongo clusters.
type MongoClusterListResult struct {
	// The list of mongo clusters
	Value []*MongoCluster

	// READ-ONLY; The link used to get the next page of results.
	NextLink *string
}

// MongoClusterProperties - The properties of a mongo cluster.
type MongoClusterProperties struct {
	// The administrator's login for the mongo cluster.
	AdministratorLogin *string

	// The password of the administrator login.
	AdministratorLoginPassword *string

	// The mode to create a mongo cluster.
	CreateMode *CreateMode

	// The list of node group specs in the cluster.
	NodeGroupSpecs []*NodeGroupSpec

	// Parameters used for restore operations
	RestoreParameters *MongoClusterRestoreParameters

	// The Mongo DB server version. Defaults to the latest available version if not specified.
	ServerVersion *string

	// READ-ONLY; A status of the mongo cluster.
	ClusterStatus *MongoClusterStatus

	// READ-ONLY; The default mongo connection string for the cluster.
	ConnectionString *string

	// READ-ONLY; Earliest restore timestamp in UTC ISO8601 format.
	EarliestRestoreTime *string

	// READ-ONLY; A provisioning state of the mongo cluster.
	ProvisioningState *ProvisioningState
}

// MongoClusterRestoreParameters - Parameters used for restore operations
type MongoClusterRestoreParameters struct {
	// UTC point in time to restore a mongo cluster
	PointInTimeUTC *time.Time

	// Resource ID to locate the source cluster to restore
	SourceResourceID *string
}

// MongoClusterUpdate - Represents a mongo cluster resource for updates.
type MongoClusterUpdate struct {
	// Properties of the mongo cluster.
	Properties *MongoClusterProperties

	// Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string
}

// MongoDBCollectionCreateUpdateParameters - Parameters to create and update Cosmos DB MongoDB collection.
type MongoDBCollectionCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB MongoDB collection.
	Properties *MongoDBCollectionCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// MongoDBCollectionCreateUpdateProperties - Properties to create and update Azure Cosmos DB MongoDB collection.
type MongoDBCollectionCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a MongoDB collection
	Resource *MongoDBCollectionResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// MongoDBCollectionGetProperties - The properties of an Azure Cosmos DB MongoDB collection
type MongoDBCollectionGetProperties struct {
	Options  *MongoDBCollectionGetPropertiesOptions
	Resource *MongoDBCollectionGetPropertiesResource
}

type MongoDBCollectionGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32
}

type MongoDBCollectionGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB MongoDB collection
	ID *string

	// Analytical TTL.
	AnalyticalStorageTTL *int32

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// List of index keys
	Indexes []*MongoIndex

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters

	// A key-value pair of shard keys to be applied for the request.
	ShardKey map[string]*string

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// MongoDBCollectionGetResults - An Azure Cosmos DB MongoDB collection.
type MongoDBCollectionGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB MongoDB collection
	Properties *MongoDBCollectionGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// MongoDBCollectionListResult - The List operation response, that contains the MongoDB collections and their properties.
type MongoDBCollectionListResult struct {
	// READ-ONLY; List of MongoDB collections and their properties.
	Value []*MongoDBCollectionGetResults
}

// MongoDBCollectionResource - Cosmos DB MongoDB collection resource object
type MongoDBCollectionResource struct {
	// REQUIRED; Name of the Cosmos DB MongoDB collection
	ID *string

	// Analytical TTL.
	AnalyticalStorageTTL *int32

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// List of index keys
	Indexes []*MongoIndex

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters

	// A key-value pair of shard keys to be applied for the request.
	ShardKey map[string]*string
}

// MongoDBDatabaseCreateUpdateParameters - Parameters to create and update Cosmos DB MongoDB database.
type MongoDBDatabaseCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB MongoDB database.
	Properties *MongoDBDatabaseCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// MongoDBDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB MongoDB database.
type MongoDBDatabaseCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a MongoDB database
	Resource *MongoDBDatabaseResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// MongoDBDatabaseGetProperties - The properties of an Azure Cosmos DB MongoDB database
type MongoDBDatabaseGetProperties struct {
	Options  *MongoDBDatabaseGetPropertiesOptions
	Resource *MongoDBDatabaseGetPropertiesResource
}

type MongoDBDatabaseGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32
}

type MongoDBDatabaseGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB MongoDB database
	ID *string

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// MongoDBDatabaseGetResults - An Azure Cosmos DB MongoDB database.
type MongoDBDatabaseGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB MongoDB database
	Properties *MongoDBDatabaseGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// MongoDBDatabaseListResult - The List operation response, that contains the MongoDB databases and their properties.
type MongoDBDatabaseListResult struct {
	// READ-ONLY; List of MongoDB databases and their properties.
	Value []*MongoDBDatabaseGetResults
}

// MongoDBDatabaseResource - Cosmos DB MongoDB database resource object
type MongoDBDatabaseResource struct {
	// REQUIRED; Name of the Cosmos DB MongoDB database
	ID *string

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters
}

// MongoDataTransferDataSourceSink - A CosmosDB Cassandra API data source/sink
type MongoDataTransferDataSourceSink struct {
	// REQUIRED
	CollectionName *string

	// REQUIRED
	Component *DataTransferComponent

	// REQUIRED
	DatabaseName *string
}

// GetDataTransferDataSourceSink implements the DataTransferDataSourceSinkClassification interface for type MongoDataTransferDataSourceSink.
func (m *MongoDataTransferDataSourceSink) GetDataTransferDataSourceSink() *DataTransferDataSourceSink {
	return &DataTransferDataSourceSink{
		Component: m.Component,
	}
}

// MongoIndex - Cosmos DB MongoDB collection index key
type MongoIndex struct {
	// Cosmos DB MongoDB collection index keys
	Key *MongoIndexKeys

	// Cosmos DB MongoDB collection index key options
	Options *MongoIndexOptions
}

// MongoIndexKeys - Cosmos DB MongoDB collection resource object
type MongoIndexKeys struct {
	// List of keys for each MongoDB collection in the Azure Cosmos DB service
	Keys []*string
}

// MongoIndexOptions - Cosmos DB MongoDB collection index options
type MongoIndexOptions struct {
	// Expire after seconds
	ExpireAfterSeconds *int32

	// Is unique or not
	Unique *bool
}

// MongoRoleDefinitionCreateUpdateParameters - Parameters to create and update an Azure Cosmos DB Mongo Role Definition.
type MongoRoleDefinitionCreateUpdateParameters struct {
	// Properties to create and update an Azure Cosmos DB Mongo Role Definition.
	Properties *MongoRoleDefinitionResource
}

// MongoRoleDefinitionGetResults - An Azure Cosmos DB Mongo Role Definition.
type MongoRoleDefinitionGetResults struct {
	// Properties related to the Mongo Role Definition.
	Properties *MongoRoleDefinitionResource

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// MongoRoleDefinitionListResult - The relevant Mongo Role Definitions.
type MongoRoleDefinitionListResult struct {
	// READ-ONLY; List of Mongo Role Definitions and their properties.
	Value []*MongoRoleDefinitionGetResults
}

// MongoRoleDefinitionResource - Azure Cosmos DB Mongo Role Definition resource object.
type MongoRoleDefinitionResource struct {
	// The database name for which access is being granted for this Role Definition.
	DatabaseName *string

	// A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the entire
	// database account or any underlying Database / Collection. Scopes higher than
	// Database are not enforceable as privilege.
	Privileges []*Privilege

	// A user-friendly name for the Role Definition. Must be unique for the database account.
	RoleName *string

	// The set of roles inherited by this Role Definition.
	Roles []*Role

	// Indicates whether the Role Definition was built-in or user created.
	Type *MongoRoleDefinitionType
}

// MongoUserDefinitionCreateUpdateParameters - Parameters to create and update an Azure Cosmos DB Mongo User Definition.
type MongoUserDefinitionCreateUpdateParameters struct {
	// Properties to create and update an Azure Cosmos DB Mongo User Definition.
	Properties *MongoUserDefinitionResource
}

// MongoUserDefinitionGetResults - An Azure Cosmos DB User Definition
type MongoUserDefinitionGetResults struct {
	// Properties related to the User Definition.
	Properties *MongoUserDefinitionResource

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// MongoUserDefinitionListResult - The relevant User Definition.
type MongoUserDefinitionListResult struct {
	// READ-ONLY; List of User Definition and their properties
	Value []*MongoUserDefinitionGetResults
}

// MongoUserDefinitionResource - Azure Cosmos DB Mongo User Definition resource object.
type MongoUserDefinitionResource struct {
	// A custom definition for the USer Definition.
	CustomData *string

	// The database name for which access is being granted for this User Definition.
	DatabaseName *string

	// The Mongo Auth mechanism. For now, we only support auth mechanism SCRAM-SHA-256.
	Mechanisms *string

	// The password for User Definition. Response does not contain user password.
	Password *string

	// The set of roles inherited by the User Definition.
	Roles []*Role

	// The user name for User Definition.
	UserName *string
}

// NodeGroupProperties - The properties of the node group on a cluster.
type NodeGroupProperties struct {
	// The disk storage size for the node group in GB. Example values: 128, 256, 512, 1024.
	DiskSizeGB *int64

	// Whether high availability is enabled on the node group.
	EnableHa *bool

	// The resource sku for the node group. This defines the size of CPU and memory that is provisioned for each node. Example
	// values: 'M30', 'M40'.
	SKU *string
}

// NodeGroupSpec - Specification for a node group.
type NodeGroupSpec struct {
	// The disk storage size for the node group in GB. Example values: 128, 256, 512, 1024.
	DiskSizeGB *int64

	// Whether high availability is enabled on the node group.
	EnableHa *bool

	// The node type deployed in the node group.
	Kind *NodeKind

	// The number of nodes in the node group.
	NodeCount *int32

	// The resource sku for the node group. This defines the size of CPU and memory that is provisioned for each node. Example
	// values: 'M30', 'M40'.
	SKU *string
}

// NotebookWorkspace - A notebook workspace resource
type NotebookWorkspace struct {
	// Resource properties.
	Properties *NotebookWorkspaceProperties

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// NotebookWorkspaceConnectionInfoResult - The connection info for the given notebook workspace
type NotebookWorkspaceConnectionInfoResult struct {
	// READ-ONLY; Specifies auth token used for connecting to Notebook server (uses token-based auth).
	AuthToken *string

	// READ-ONLY; Specifies the endpoint of Notebook server.
	NotebookServerEndpoint *string
}

// NotebookWorkspaceCreateUpdateParameters - Parameters to create a notebook workspace resource
type NotebookWorkspaceCreateUpdateParameters struct {
	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// NotebookWorkspaceListResult - A list of notebook workspace resources
type NotebookWorkspaceListResult struct {
	// Array of notebook workspace resources
	Value []*NotebookWorkspace
}

// NotebookWorkspaceProperties - Properties of a notebook workspace resource.
type NotebookWorkspaceProperties struct {
	// READ-ONLY; Specifies the endpoint of Notebook server.
	NotebookServerEndpoint *string

	// READ-ONLY; Status of the notebook workspace. Possible values are: Creating, Online, Deleting, Failed, Updating.
	Status *string
}

// Operation - REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}
	Name *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of operation
	Description *string

	// Operation type: Read, write, delete, etc.
	Operation *string

	// Service provider: Microsoft.ResourceProvider
	Provider *string

	// Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string
}

// OperationListResult - Result of the request to list Resource Provider operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of operations supported by the Resource Provider.
	Value []*Operation
}

// OptionsResource - Cosmos DB options resource object
type OptionsResource struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32
}

// PartitionMetric - The metric values for a single partition.
type PartitionMetric struct {
	// READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *time.Time

	// READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues []*MetricValue

	// READ-ONLY; The name information for the metric.
	Name *MetricName

	// READ-ONLY; The partition id (GUID identifier) of the metric values.
	PartitionID *string

	// READ-ONLY; The partition key range id (integer identifier) of the metric values.
	PartitionKeyRangeID *string

	// READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *time.Time

	// READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string

	// READ-ONLY; The unit of the metric.
	Unit *UnitType
}

// PartitionMetricListResult - The response to a list partition metrics request.
type PartitionMetricListResult struct {
	// READ-ONLY; The list of partition-level metrics for the account.
	Value []*PartitionMetric
}

// PartitionUsage - The partition level usage data for a usage request.
type PartitionUsage struct {
	// READ-ONLY; Current value for this metric
	CurrentValue *int64

	// READ-ONLY; Maximum value for this metric
	Limit *int64

	// READ-ONLY; The name information for the metric.
	Name *MetricName

	// READ-ONLY; The partition id (GUID identifier) of the usages.
	PartitionID *string

	// READ-ONLY; The partition key range id (integer identifier) of the usages.
	PartitionKeyRangeID *string

	// READ-ONLY; The quota period used to summarize the usage values.
	QuotaPeriod *string

	// READ-ONLY; The unit of the metric.
	Unit *UnitType
}

// PartitionUsagesResult - The response to a list partition level usage request.
type PartitionUsagesResult struct {
	// READ-ONLY; The list of partition-level usages for the database. A usage is a point in time metric
	Value []*PartitionUsage
}

// PercentileMetric - Percentile Metric data
type PercentileMetric struct {
	// READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *time.Time

	// READ-ONLY; The percentile metric values for the specified time window and timestep.
	MetricValues []*PercentileMetricValue

	// READ-ONLY; The name information for the metric.
	Name *MetricName

	// READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *time.Time

	// READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string

	// READ-ONLY; The unit of the metric.
	Unit *UnitType
}

// PercentileMetricListResult - The response to a list percentile metrics request.
type PercentileMetricListResult struct {
	// READ-ONLY; The list of percentile metrics for the account.
	Value []*PercentileMetric
}

// PercentileMetricValue - Represents percentile metrics values.
type PercentileMetricValue struct {
	// READ-ONLY; The average value of the metric.
	Average *float64

	// READ-ONLY; The number of values for the metric.
	Count *int32

	// READ-ONLY; The max value of the metric.
	Maximum *float64

	// READ-ONLY; The min value of the metric.
	Minimum *float64

	// READ-ONLY; The 10th percentile value for the metric.
	P10 *float64

	// READ-ONLY; The 25th percentile value for the metric.
	P25 *float64

	// READ-ONLY; The 50th percentile value for the metric.
	P50 *float64

	// READ-ONLY; The 75th percentile value for the metric.
	P75 *float64

	// READ-ONLY; The 90th percentile value for the metric.
	P90 *float64

	// READ-ONLY; The 95th percentile value for the metric.
	P95 *float64

	// READ-ONLY; The 99th percentile value for the metric.
	P99 *float64

	// READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *time.Time

	// READ-ONLY; The total value of the metric.
	Total *float64
}

// PeriodicModeBackupPolicy - The object representing periodic mode backup policy.
type PeriodicModeBackupPolicy struct {
	// REQUIRED; Describes the mode of backups.
	Type *BackupPolicyType

	// The object representing the state of the migration between the backup policies.
	MigrationState *BackupPolicyMigrationState

	// Configuration values for periodic mode backup
	PeriodicModeProperties *PeriodicModeProperties
}

// GetBackupPolicy implements the BackupPolicyClassification interface for type PeriodicModeBackupPolicy.
func (p *PeriodicModeBackupPolicy) GetBackupPolicy() *BackupPolicy {
	return &BackupPolicy{
		MigrationState: p.MigrationState,
		Type:           p.Type,
	}
}

// PeriodicModeProperties - Configuration values for periodic mode backup
type PeriodicModeProperties struct {
	// An integer representing the interval in minutes between two backups
	BackupIntervalInMinutes *int32

	// An integer representing the time (in hours) that each backup is retained
	BackupRetentionIntervalInHours *int32

	// Enum to indicate type of backup residency
	BackupStorageRedundancy *BackupStorageRedundancy
}

// Permission - The set of data plane operations permitted through this Role Definition.
type Permission struct {
	// An array of data actions that are allowed.
	DataActions []*string

	// An array of data actions that are denied.
	NotDataActions []*string
}

// PhysicalPartitionID - PhysicalPartitionId object
type PhysicalPartitionID struct {
	// REQUIRED; Id of a physical partition
	ID *string
}

// PhysicalPartitionStorageInfo - The storage of a physical partition
type PhysicalPartitionStorageInfo struct {
	// READ-ONLY; The unique identifier of the partition.
	ID *string

	// READ-ONLY; The storage in KB for the physical partition.
	StorageInKB *float64
}

// PhysicalPartitionStorageInfoCollection - List of physical partitions and their properties returned by a merge operation.
type PhysicalPartitionStorageInfoCollection struct {
	// READ-ONLY; List of physical partitions and their properties.
	PhysicalPartitionStorageInfoCollection []*PhysicalPartitionStorageInfo
}

// PhysicalPartitionThroughputInfoProperties - The properties of an Azure Cosmos DB PhysicalPartitionThroughputInfoProperties
// object
type PhysicalPartitionThroughputInfoProperties struct {
	// Array of physical partition throughput info objects
	PhysicalPartitionThroughputInfo []*PhysicalPartitionThroughputInfoResource
}

// PhysicalPartitionThroughputInfoResource - PhysicalPartitionThroughputInfo object
type PhysicalPartitionThroughputInfoResource struct {
	// REQUIRED; Id of a physical partition
	ID *string

	// Throughput of a physical partition
	Throughput *float64
}

// PhysicalPartitionThroughputInfoResult - An Azure Cosmos DB PhysicalPartitionThroughputInfoResult object.
type PhysicalPartitionThroughputInfoResult struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB PhysicalPartitionThroughputInfoResult object
	Properties *PhysicalPartitionThroughputInfoResultProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// PhysicalPartitionThroughputInfoResultProperties - The properties of an Azure Cosmos DB PhysicalPartitionThroughputInfoResult
// object
type PhysicalPartitionThroughputInfoResultProperties struct {
	// properties of physical partition throughput info
	Resource *PhysicalPartitionThroughputInfoResultPropertiesResource
}

// PhysicalPartitionThroughputInfoResultPropertiesResource - properties of physical partition throughput info
type PhysicalPartitionThroughputInfoResultPropertiesResource struct {
	// Array of physical partition throughput info objects
	PhysicalPartitionThroughputInfo []*PhysicalPartitionThroughputInfoResource
}

// PrivateEndpointConnection - A private endpoint connection
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - A list of private endpoint connections
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// Group id of the private endpoint.
	GroupID *string

	// Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty

	// Connection State of the Private Endpoint Connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionStateProperty

	// Provisioning state of the private endpoint.
	ProvisioningState *string
}

// PrivateEndpointProperty - Private endpoint which the connection belongs to.
type PrivateEndpointProperty struct {
	// Resource id of the private endpoint.
	ID *string
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string

	// READ-ONLY; The private link resource required zone names.
	RequiredZoneNames []*string
}

// PrivateLinkServiceConnectionStateProperty - Connection State of the Private Endpoint Connection.
type PrivateLinkServiceConnectionStateProperty struct {
	// The private link service connection description.
	Description *string

	// The private link service connection status.
	Status *string

	// READ-ONLY; Any action that is required beyond basic workflow (approve/ reject/ disconnect)
	ActionsRequired *string
}

// Privilege - The set of data plane operations permitted through this Role Definition.
type Privilege struct {
	// An array of actions that are allowed.
	Actions []*string

	// An Azure Cosmos DB Mongo DB Resource.
	Resource *PrivilegeResource
}

// PrivilegeResource - An Azure Cosmos DB Mongo DB Resource.
type PrivilegeResource struct {
	// The collection name the role is applied.
	Collection *string

	// The database name the role is applied.
	Db *string
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ProxyResourceAutoGenerated - The resource model definition for a Azure Resource Manager proxy resource. It will not have
// tags and a location
type ProxyResourceAutoGenerated struct {
	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RedistributeThroughputParameters - Cosmos DB redistribute throughput parameters object
type RedistributeThroughputParameters struct {
	// REQUIRED; Properties to redistribute throughput parameters object
	Properties *RedistributeThroughputProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RedistributeThroughputProperties - Properties to redistribute throughput for Azure Cosmos DB resource.
type RedistributeThroughputProperties struct {
	// REQUIRED; The standard JSON format of a resource throughput
	Resource *RedistributeThroughputPropertiesResource
}

// RedistributeThroughputPropertiesResource - Resource to redistribute throughput for Azure Cosmos DB resource
type RedistributeThroughputPropertiesResource struct {
	// REQUIRED; Array of PhysicalPartitionThroughputInfoResource objects.
	SourcePhysicalPartitionThroughputInfo []*PhysicalPartitionThroughputInfoResource

	// REQUIRED; Array of PhysicalPartitionThroughputInfoResource objects.
	TargetPhysicalPartitionThroughputInfo []*PhysicalPartitionThroughputInfoResource

	// REQUIRED; ThroughputPolicy to apply for throughput redistribution
	ThroughputPolicy *ThroughputPolicyType
}

// RegionForOnlineOffline - Cosmos DB region to online or offline.
type RegionForOnlineOffline struct {
	// REQUIRED; Cosmos DB region, with spaces between words and each word capitalized.
	Region *string
}

// RegionalServiceResource - Resource for a regional service location.
type RegionalServiceResource struct {
	// READ-ONLY; The location name.
	Location *string

	// READ-ONLY; The regional service name.
	Name *string

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceAutoGenerated - Common fields that are returned in the response for all Azure Resource Manager resources
type ResourceAutoGenerated struct {
	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceRestoreParameters - Parameters to indicate the information about the restore.
type ResourceRestoreParameters struct {
	// The id of the restorable database account from which the restore has to be initiated. For example:
	// /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
	RestoreSource *string

	// Time to which the account has to be restored (ISO-8601 format).
	RestoreTimestampInUTC *time.Time
}

// RestorableDatabaseAccountGetResult - A Azure Cosmos DB restorable database account.
type RestorableDatabaseAccountGetResult struct {
	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of a restorable database account.
	Properties *RestorableDatabaseAccountProperties

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RestorableDatabaseAccountProperties - The properties of a restorable database account.
type RestorableDatabaseAccountProperties struct {
	// The name of the global database account
	AccountName *string

	// The creation time of the restorable database account (ISO-8601 format).
	CreationTime *time.Time

	// The time at which the restorable database account has been deleted (ISO-8601 format).
	DeletionTime *time.Time

	// The least recent time at which the database account can be restored to (ISO-8601 format).
	OldestRestorableTime *time.Time

	// READ-ONLY; The API type of the restorable database account.
	APIType *APIType

	// READ-ONLY; List of regions where the of the database account can be restored from.
	RestorableLocations []*RestorableLocationResource
}

// RestorableDatabaseAccountsListResult - The List operation response, that contains the restorable database accounts and
// their properties.
type RestorableDatabaseAccountsListResult struct {
	// READ-ONLY; List of restorable database accounts and their properties.
	Value []*RestorableDatabaseAccountGetResult
}

// RestorableGremlinDatabaseGetResult - An Azure Cosmos DB Gremlin database event
type RestorableGremlinDatabaseGetResult struct {
	// The properties of a Gremlin database event.
	Properties *RestorableGremlinDatabaseProperties

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RestorableGremlinDatabaseProperties - The properties of an Azure Cosmos DB Gremlin database event
type RestorableGremlinDatabaseProperties struct {
	// The resource of an Azure Cosmos DB Gremlin database event
	Resource *RestorableGremlinDatabasePropertiesResource
}

// RestorableGremlinDatabasePropertiesResource - The resource of an Azure Cosmos DB Gremlin database event
type RestorableGremlinDatabasePropertiesResource struct {
	// READ-ONLY; The time when this database event happened.
	EventTimestamp *string

	// READ-ONLY; The operation type of this database event.
	OperationType *OperationType

	// READ-ONLY; The name of this Gremlin database.
	OwnerID *string

	// READ-ONLY; The resource ID of this Gremlin database.
	OwnerResourceID *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string
}

// RestorableGremlinDatabasesListResult - The List operation response, that contains the Gremlin database events and their
// properties.
type RestorableGremlinDatabasesListResult struct {
	// READ-ONLY; List of Gremlin database events and their properties.
	Value []*RestorableGremlinDatabaseGetResult
}

// RestorableGremlinGraphGetResult - An Azure Cosmos DB Gremlin graph event
type RestorableGremlinGraphGetResult struct {
	// The properties of a Gremlin graph event.
	Properties *RestorableGremlinGraphProperties

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RestorableGremlinGraphProperties - The properties of an Azure Cosmos DB Gremlin graph event
type RestorableGremlinGraphProperties struct {
	// The resource of an Azure Cosmos DB Gremlin graph event
	Resource *RestorableGremlinGraphPropertiesResource
}

// RestorableGremlinGraphPropertiesResource - The resource of an Azure Cosmos DB Gremlin graph event
type RestorableGremlinGraphPropertiesResource struct {
	// READ-ONLY; The time when this graph event happened.
	EventTimestamp *string

	// READ-ONLY; The operation type of this graph event.
	OperationType *OperationType

	// READ-ONLY; The name of this Gremlin graph.
	OwnerID *string

	// READ-ONLY; The resource ID of this Gremlin graph.
	OwnerResourceID *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string
}

// RestorableGremlinGraphsListResult - The List operation response, that contains the Gremlin graph events and their properties.
type RestorableGremlinGraphsListResult struct {
	// READ-ONLY; List of Gremlin graph events and their properties.
	Value []*RestorableGremlinGraphGetResult
}

// RestorableGremlinResourcesGetResult - Specific Databases to restore.
type RestorableGremlinResourcesGetResult struct {
	// The name of the gremlin database available for restore.
	DatabaseName *string

	// The names of the graphs available for restore.
	GraphNames []*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RestorableGremlinResourcesListResult - The List operation response, that contains the restorable Gremlin resources.
type RestorableGremlinResourcesListResult struct {
	// READ-ONLY; List of restorable Gremlin resources, including the gremlin database and graph names.
	Value []*RestorableGremlinResourcesGetResult
}

// RestorableLocationResource - Properties of the regional restorable account.
type RestorableLocationResource struct {
	// READ-ONLY; The creation time of the regional restorable database account (ISO-8601 format).
	CreationTime *time.Time

	// READ-ONLY; The time at which the regional restorable database account has been deleted (ISO-8601 format).
	DeletionTime *time.Time

	// READ-ONLY; The location of the regional restorable account.
	LocationName *string

	// READ-ONLY; The instance id of the regional restorable account.
	RegionalDatabaseAccountInstanceID *string
}

// RestorableMongodbCollectionGetResult - An Azure Cosmos DB MongoDB collection event
type RestorableMongodbCollectionGetResult struct {
	// The properties of a MongoDB collection event.
	Properties *RestorableMongodbCollectionProperties

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RestorableMongodbCollectionProperties - The properties of an Azure Cosmos DB MongoDB collection event
type RestorableMongodbCollectionProperties struct {
	// The resource of an Azure Cosmos DB MongoDB collection event
	Resource *RestorableMongodbCollectionPropertiesResource
}

// RestorableMongodbCollectionPropertiesResource - The resource of an Azure Cosmos DB MongoDB collection event
type RestorableMongodbCollectionPropertiesResource struct {
	// READ-ONLY; The time when this collection event happened.
	EventTimestamp *string

	// READ-ONLY; The operation type of this collection event.
	OperationType *OperationType

	// READ-ONLY; The name of this MongoDB collection.
	OwnerID *string

	// READ-ONLY; The resource ID of this MongoDB collection.
	OwnerResourceID *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string
}

// RestorableMongodbCollectionsListResult - The List operation response, that contains the MongoDB collection events and their
// properties.
type RestorableMongodbCollectionsListResult struct {
	// READ-ONLY; List of MongoDB collection events and their properties.
	Value []*RestorableMongodbCollectionGetResult
}

// RestorableMongodbDatabaseGetResult - An Azure Cosmos DB MongoDB database event
type RestorableMongodbDatabaseGetResult struct {
	// The properties of a MongoDB database event.
	Properties *RestorableMongodbDatabaseProperties

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RestorableMongodbDatabaseProperties - The properties of an Azure Cosmos DB MongoDB database event
type RestorableMongodbDatabaseProperties struct {
	// The resource of an Azure Cosmos DB MongoDB database event
	Resource *RestorableMongodbDatabasePropertiesResource
}

// RestorableMongodbDatabasePropertiesResource - The resource of an Azure Cosmos DB MongoDB database event
type RestorableMongodbDatabasePropertiesResource struct {
	// READ-ONLY; The time when this database event happened.
	EventTimestamp *string

	// READ-ONLY; The operation type of this database event.
	OperationType *OperationType

	// READ-ONLY; The name of this MongoDB database.
	OwnerID *string

	// READ-ONLY; The resource ID of this MongoDB database.
	OwnerResourceID *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string
}

// RestorableMongodbDatabasesListResult - The List operation response, that contains the MongoDB database events and their
// properties.
type RestorableMongodbDatabasesListResult struct {
	// READ-ONLY; List of MongoDB database events and their properties.
	Value []*RestorableMongodbDatabaseGetResult
}

// RestorableMongodbResourcesGetResult - Specific Databases to restore.
type RestorableMongodbResourcesGetResult struct {
	// The names of the collections available for restore.
	CollectionNames []*string

	// The name of the database available for restore.
	DatabaseName *string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RestorableMongodbResourcesListResult - The List operation response, that contains the restorable MongoDB resources.
type RestorableMongodbResourcesListResult struct {
	// READ-ONLY; List of restorable MongoDB resources, including the database and collection names.
	Value []*RestorableMongodbResourcesGetResult
}

// RestorableSQLContainerGetResult - An Azure Cosmos DB SQL container event
type RestorableSQLContainerGetResult struct {
	// The properties of a SQL container event.
	Properties *RestorableSQLContainerProperties

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RestorableSQLContainerProperties - The properties of an Azure Cosmos DB SQL container event
type RestorableSQLContainerProperties struct {
	// The resource of an Azure Cosmos DB SQL container event
	Resource *RestorableSQLContainerPropertiesResource
}

// RestorableSQLContainerPropertiesResource - The resource of an Azure Cosmos DB SQL container event
type RestorableSQLContainerPropertiesResource struct {
	// Cosmos DB SQL container resource object
	Container *RestorableSQLContainerPropertiesResourceContainer

	// READ-ONLY; The when this container event happened.
	EventTimestamp *string

	// READ-ONLY; The operation type of this container event.
	OperationType *OperationType

	// READ-ONLY; The name of this SQL container.
	OwnerID *string

	// READ-ONLY; The resource ID of this SQL container.
	OwnerResourceID *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string
}

// RestorableSQLContainerPropertiesResourceContainer - Cosmos DB SQL container resource object
type RestorableSQLContainerPropertiesResourceContainer struct {
	// REQUIRED; Name of the Cosmos DB SQL container
	ID *string

	// Analytical TTL.
	AnalyticalStorageTTL *int64

	// The client encryption policy for the container.
	ClientEncryptionPolicy *ClientEncryptionPolicy

	// The conflict resolution policy for the container.
	ConflictResolutionPolicy *ConflictResolutionPolicy

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Default time to live
	DefaultTTL *int32

	// The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
	IndexingPolicy *IndexingPolicy

	// The configuration for defining Materialized Views. This must be specified only for creating a Materialized View container.
	MaterializedViewDefinition *MaterializedViewDefinition

	// The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters

	// The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos
	// DB service.
	UniqueKeyPolicy *UniqueKeyPolicy

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that specifies the addressable path of the container resource.
	Self *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// RestorableSQLContainersListResult - The List operation response, that contains the SQL container events and their properties.
type RestorableSQLContainersListResult struct {
	// READ-ONLY; List of SQL container events and their properties.
	Value []*RestorableSQLContainerGetResult
}

// RestorableSQLDatabaseGetResult - An Azure Cosmos DB SQL database event
type RestorableSQLDatabaseGetResult struct {
	// The properties of a SQL database event.
	Properties *RestorableSQLDatabaseProperties

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RestorableSQLDatabaseProperties - The properties of an Azure Cosmos DB SQL database event
type RestorableSQLDatabaseProperties struct {
	// The resource of an Azure Cosmos DB SQL database event
	Resource *RestorableSQLDatabasePropertiesResource
}

// RestorableSQLDatabasePropertiesResource - The resource of an Azure Cosmos DB SQL database event
type RestorableSQLDatabasePropertiesResource struct {
	// Cosmos DB SQL database resource object
	Database *RestorableSQLDatabasePropertiesResourceDatabase

	// READ-ONLY; The time when this database event happened.
	EventTimestamp *string

	// READ-ONLY; The operation type of this database event.
	OperationType *OperationType

	// READ-ONLY; The name of the SQL database.
	OwnerID *string

	// READ-ONLY; The resource ID of the SQL database.
	OwnerResourceID *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string
}

// RestorableSQLDatabasePropertiesResourceDatabase - Cosmos DB SQL database resource object
type RestorableSQLDatabasePropertiesResourceDatabase struct {
	// REQUIRED; Name of the Cosmos DB SQL database
	ID *string

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters

	// READ-ONLY; A system generated property that specified the addressable path of the collections resource.
	Colls *string

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that specifies the addressable path of the database resource.
	Self *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32

	// READ-ONLY; A system generated property that specifies the addressable path of the users resource.
	Users *string
}

// RestorableSQLDatabasesListResult - The List operation response, that contains the SQL database events and their properties.
type RestorableSQLDatabasesListResult struct {
	// READ-ONLY; List of SQL database events and their properties.
	Value []*RestorableSQLDatabaseGetResult
}

// RestorableSQLResourcesGetResult - Specific Databases to restore.
type RestorableSQLResourcesGetResult struct {
	// The names of the collections available for restore.
	CollectionNames []*string

	// The name of the database available for restore.
	DatabaseName *string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RestorableSQLResourcesListResult - The List operation response, that contains the restorable SQL resources.
type RestorableSQLResourcesListResult struct {
	// READ-ONLY; List of restorable SQL resources, including the database and collection names.
	Value []*RestorableSQLResourcesGetResult
}

// RestorableTableGetResult - An Azure Cosmos DB Table event
type RestorableTableGetResult struct {
	// The properties of a Table event.
	Properties *RestorableTableProperties

	// READ-ONLY; The unique resource Identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RestorableTableProperties - The properties of an Azure Cosmos DB Table event
type RestorableTableProperties struct {
	// The resource of an Azure Cosmos DB Table event
	Resource *RestorableTablePropertiesResource
}

// RestorableTablePropertiesResource - The resource of an Azure Cosmos DB Table event
type RestorableTablePropertiesResource struct {
	// READ-ONLY; The time when this table event happened.
	EventTimestamp *string

	// READ-ONLY; The operation type of this table event.
	OperationType *OperationType

	// READ-ONLY; The name of this Table.
	OwnerID *string

	// READ-ONLY; The resource ID of this Table.
	OwnerResourceID *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string
}

// RestorableTableResourcesGetResult - Specific Databases to restore.
type RestorableTableResourcesGetResult struct {
	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the Table.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RestorableTableResourcesListResult - List of restorable table names.
type RestorableTableResourcesListResult struct {
	// READ-ONLY; List of restorable table names.
	Value []*RestorableTableResourcesGetResult
}

// RestorableTablesListResult - The List operation response, that contains the Table events and their properties.
type RestorableTablesListResult struct {
	// READ-ONLY; List of Table events and their properties.
	Value []*RestorableTableGetResult
}

// RestoreParameters - Parameters to indicate the information about the restore.
type RestoreParameters struct {
	// List of specific databases available for restore.
	DatabasesToRestore []*DatabaseRestoreResource

	// List of specific gremlin databases available for restore.
	GremlinDatabasesToRestore []*GremlinDatabaseRestoreResource

	// Describes the mode of the restore.
	RestoreMode *RestoreMode

	// The id of the restorable database account from which the restore has to be initiated. For example:
	// /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
	RestoreSource *string

	// Time to which the account has to be restored (ISO-8601 format).
	RestoreTimestampInUTC *time.Time

	// The source backup location for restore.
	SourceBackupLocation *string

	// List of specific tables available for restore.
	TablesToRestore []*string
}

// RestoreParametersBase - Parameters to indicate the information about the restore.
type RestoreParametersBase struct {
	// The id of the restorable database account from which the restore has to be initiated. For example:
	// /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
	RestoreSource *string

	// Time to which the account has to be restored (ISO-8601 format).
	RestoreTimestampInUTC *time.Time
}

// RetrieveThroughputParameters - Cosmos DB retrieve throughput parameters object
type RetrieveThroughputParameters struct {
	// REQUIRED; Properties to retrieve throughput parameters object
	Properties *RetrieveThroughputProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// RetrieveThroughputProperties - Properties to retrieve throughput for Azure Cosmos DB resource.
type RetrieveThroughputProperties struct {
	// REQUIRED; The standard JSON format of a resource throughput
	Resource *RetrieveThroughputPropertiesResource
}

// RetrieveThroughputPropertiesResource - Resource to retrieve throughput information for Cosmos DB resource
type RetrieveThroughputPropertiesResource struct {
	// REQUIRED; Array of PhysicalPartitionId objects.
	PhysicalPartitionIDs []*PhysicalPartitionID
}

// Role - The set of roles permitted through this Role Definition.
type Role struct {
	// The database name the role is applied.
	Db *string

	// The role name.
	Role *string
}

// SQLContainerCreateUpdateParameters - Parameters to create and update Cosmos DB container.
type SQLContainerCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB container.
	Properties *SQLContainerCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// SQLContainerCreateUpdateProperties - Properties to create and update Azure Cosmos DB container.
type SQLContainerCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a container
	Resource *SQLContainerResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// SQLContainerGetProperties - The properties of an Azure Cosmos DB container
type SQLContainerGetProperties struct {
	Options  *SQLContainerGetPropertiesOptions
	Resource *SQLContainerGetPropertiesResource
}

type SQLContainerGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32
}

type SQLContainerGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB SQL container
	ID *string

	// Analytical TTL.
	AnalyticalStorageTTL *int64

	// The client encryption policy for the container.
	ClientEncryptionPolicy *ClientEncryptionPolicy

	// The conflict resolution policy for the container.
	ConflictResolutionPolicy *ConflictResolutionPolicy

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Default time to live
	DefaultTTL *int32

	// The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
	IndexingPolicy *IndexingPolicy

	// The configuration for defining Materialized Views. This must be specified only for creating a Materialized View container.
	MaterializedViewDefinition *MaterializedViewDefinition

	// The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters

	// The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos
	// DB service.
	UniqueKeyPolicy *UniqueKeyPolicy

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// SQLContainerGetResults - An Azure Cosmos DB container.
type SQLContainerGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB container
	Properties *SQLContainerGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// SQLContainerListResult - The List operation response, that contains the containers and their properties.
type SQLContainerListResult struct {
	// READ-ONLY; List of containers and their properties.
	Value []*SQLContainerGetResults
}

// SQLContainerResource - Cosmos DB SQL container resource object
type SQLContainerResource struct {
	// REQUIRED; Name of the Cosmos DB SQL container
	ID *string

	// Analytical TTL.
	AnalyticalStorageTTL *int64

	// The client encryption policy for the container.
	ClientEncryptionPolicy *ClientEncryptionPolicy

	// The conflict resolution policy for the container.
	ConflictResolutionPolicy *ConflictResolutionPolicy

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Default time to live
	DefaultTTL *int32

	// The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
	IndexingPolicy *IndexingPolicy

	// The configuration for defining Materialized Views. This must be specified only for creating a Materialized View container.
	MaterializedViewDefinition *MaterializedViewDefinition

	// The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters

	// The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos
	// DB service.
	UniqueKeyPolicy *UniqueKeyPolicy
}

// SQLDataTransferDataSourceSink - A CosmosDB Cassandra API data source/sink
type SQLDataTransferDataSourceSink struct {
	// REQUIRED
	Component *DataTransferComponent

	// REQUIRED
	ContainerName *string

	// REQUIRED
	DatabaseName *string
}

// GetDataTransferDataSourceSink implements the DataTransferDataSourceSinkClassification interface for type SQLDataTransferDataSourceSink.
func (s *SQLDataTransferDataSourceSink) GetDataTransferDataSourceSink() *DataTransferDataSourceSink {
	return &DataTransferDataSourceSink{
		Component: s.Component,
	}
}

// SQLDatabaseCreateUpdateParameters - Parameters to create and update Cosmos DB SQL database.
type SQLDatabaseCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB SQL database.
	Properties *SQLDatabaseCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// SQLDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB SQL database.
type SQLDatabaseCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a SQL database
	Resource *SQLDatabaseResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// SQLDatabaseGetProperties - The properties of an Azure Cosmos DB SQL database
type SQLDatabaseGetProperties struct {
	Options  *SQLDatabaseGetPropertiesOptions
	Resource *SQLDatabaseGetPropertiesResource
}

type SQLDatabaseGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32
}

type SQLDatabaseGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB SQL database
	ID *string

	// A system generated property that specified the addressable path of the collections resource.
	Colls *string

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters

	// A system generated property that specifies the addressable path of the users resource.
	Users *string

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// SQLDatabaseGetResults - An Azure Cosmos DB SQL database.
type SQLDatabaseGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB SQL database
	Properties *SQLDatabaseGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// SQLDatabaseListResult - The List operation response, that contains the SQL databases and their properties.
type SQLDatabaseListResult struct {
	// READ-ONLY; List of SQL databases and their properties.
	Value []*SQLDatabaseGetResults
}

// SQLDatabaseResource - Cosmos DB SQL database resource object
type SQLDatabaseResource struct {
	// REQUIRED; Name of the Cosmos DB SQL database
	ID *string

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters
}

// SQLDedicatedGatewayRegionalServiceResource - Resource for a regional service location.
type SQLDedicatedGatewayRegionalServiceResource struct {
	// READ-ONLY; The location name.
	Location *string

	// READ-ONLY; The regional service name.
	Name *string

	// READ-ONLY; The regional endpoint for SqlDedicatedGateway.
	SQLDedicatedGatewayEndpoint *string

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus
}

// SQLDedicatedGatewayServiceResource - Describes the service response property for SqlDedicatedGateway.
type SQLDedicatedGatewayServiceResource struct {
	// Properties for SqlDedicatedGatewayServiceResource.
	Properties *SQLDedicatedGatewayServiceResourceProperties
}

// SQLDedicatedGatewayServiceResourceProperties - Properties for SqlDedicatedGatewayServiceResource.
type SQLDedicatedGatewayServiceResourceProperties struct {
	// REQUIRED; ServiceType for the service.
	ServiceType *ServiceType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Instance count for the service.
	InstanceCount *int32

	// Instance type for the service.
	InstanceSize *ServiceSize

	// SqlDedicatedGateway endpoint for the service.
	SQLDedicatedGatewayEndpoint *string

	// READ-ONLY; Time of the last state change (ISO-8601 format).
	CreationTime *time.Time

	// READ-ONLY; An array that contains all of the locations for the service.
	Locations []*SQLDedicatedGatewayRegionalServiceResource

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus
}

// GetServiceResourceProperties implements the ServiceResourcePropertiesClassification interface for type SQLDedicatedGatewayServiceResourceProperties.
func (s *SQLDedicatedGatewayServiceResourceProperties) GetServiceResourceProperties() *ServiceResourceProperties {
	return &ServiceResourceProperties{
		AdditionalProperties: s.AdditionalProperties,
		CreationTime:         s.CreationTime,
		InstanceCount:        s.InstanceCount,
		InstanceSize:         s.InstanceSize,
		ServiceType:          s.ServiceType,
		Status:               s.Status,
	}
}

// SQLRoleAssignmentCreateUpdateParameters - Parameters to create and update an Azure Cosmos DB SQL Role Assignment.
type SQLRoleAssignmentCreateUpdateParameters struct {
	// Properties to create and update an Azure Cosmos DB SQL Role Assignment.
	Properties *SQLRoleAssignmentResource
}

// SQLRoleAssignmentGetResults - An Azure Cosmos DB Role Assignment
type SQLRoleAssignmentGetResults struct {
	// Properties related to the Role Assignment.
	Properties *SQLRoleAssignmentResource

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// SQLRoleAssignmentListResult - The relevant Role Assignments.
type SQLRoleAssignmentListResult struct {
	// READ-ONLY; List of Role Assignments and their properties
	Value []*SQLRoleAssignmentGetResults
}

// SQLRoleAssignmentResource - Azure Cosmos DB SQL Role Assignment resource object.
type SQLRoleAssignmentResource struct {
	// The unique identifier for the associated AAD principal in the AAD graph to which access is being granted through this Role
	// Assignment. Tenant ID for the principal is inferred using the tenant
	// associated with the subscription.
	PrincipalID *string

	// The unique identifier for the associated Role Definition.
	RoleDefinitionID *string

	// The data plane resource path for which access is being granted through this Role Assignment.
	Scope *string
}

// SQLRoleDefinitionCreateUpdateParameters - Parameters to create and update an Azure Cosmos DB SQL Role Definition.
type SQLRoleDefinitionCreateUpdateParameters struct {
	// Properties to create and update an Azure Cosmos DB SQL Role Definition.
	Properties *SQLRoleDefinitionResource
}

// SQLRoleDefinitionGetResults - An Azure Cosmos DB SQL Role Definition.
type SQLRoleDefinitionGetResults struct {
	// Properties related to the Role Definition.
	Properties *SQLRoleDefinitionResource

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// SQLRoleDefinitionListResult - The relevant Role Definitions.
type SQLRoleDefinitionListResult struct {
	// READ-ONLY; List of Role Definitions and their properties.
	Value []*SQLRoleDefinitionGetResults
}

// SQLRoleDefinitionResource - Azure Cosmos DB SQL Role Definition resource object.
type SQLRoleDefinitionResource struct {
	// A set of fully qualified Scopes at or below which Role Assignments may be created using this Role Definition. This will
	// allow application of this Role Definition on the entire database account or any
	// underlying Database / Collection. Must have at least one element. Scopes higher than Database account are not enforceable
	// as assignable Scopes. Note that resources referenced in assignable Scopes need
	// not exist.
	AssignableScopes []*string

	// The set of operations allowed through this Role Definition.
	Permissions []*Permission

	// A user-friendly name for the Role Definition. Must be unique for the database account.
	RoleName *string

	// Indicates whether the Role Definition was built-in or user created.
	Type *RoleDefinitionType
}

// SQLStoredProcedureCreateUpdateParameters - Parameters to create and update Cosmos DB storedProcedure.
type SQLStoredProcedureCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB storedProcedure.
	Properties *SQLStoredProcedureCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// SQLStoredProcedureCreateUpdateProperties - Properties to create and update Azure Cosmos DB storedProcedure.
type SQLStoredProcedureCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a storedProcedure
	Resource *SQLStoredProcedureResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// SQLStoredProcedureGetProperties - The properties of an Azure Cosmos DB StoredProcedure
type SQLStoredProcedureGetProperties struct {
	Resource *SQLStoredProcedureGetPropertiesResource
}

type SQLStoredProcedureGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB SQL storedProcedure
	ID *string

	// Body of the Stored Procedure
	Body *string

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// SQLStoredProcedureGetResults - An Azure Cosmos DB storedProcedure.
type SQLStoredProcedureGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB storedProcedure
	Properties *SQLStoredProcedureGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// SQLStoredProcedureListResult - The List operation response, that contains the storedProcedures and their properties.
type SQLStoredProcedureListResult struct {
	// READ-ONLY; List of storedProcedures and their properties.
	Value []*SQLStoredProcedureGetResults
}

// SQLStoredProcedureResource - Cosmos DB SQL storedProcedure resource object
type SQLStoredProcedureResource struct {
	// REQUIRED; Name of the Cosmos DB SQL storedProcedure
	ID *string

	// Body of the Stored Procedure
	Body *string
}

// SQLTriggerCreateUpdateParameters - Parameters to create and update Cosmos DB trigger.
type SQLTriggerCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB trigger.
	Properties *SQLTriggerCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// SQLTriggerCreateUpdateProperties - Properties to create and update Azure Cosmos DB trigger.
type SQLTriggerCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a trigger
	Resource *SQLTriggerResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// SQLTriggerGetProperties - The properties of an Azure Cosmos DB trigger
type SQLTriggerGetProperties struct {
	Resource *SQLTriggerGetPropertiesResource
}

type SQLTriggerGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB SQL trigger
	ID *string

	// Body of the Trigger
	Body *string

	// The operation the trigger is associated with
	TriggerOperation *TriggerOperation

	// Type of the Trigger
	TriggerType *TriggerType

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// SQLTriggerGetResults - An Azure Cosmos DB trigger.
type SQLTriggerGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB trigger
	Properties *SQLTriggerGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// SQLTriggerListResult - The List operation response, that contains the triggers and their properties.
type SQLTriggerListResult struct {
	// READ-ONLY; List of triggers and their properties.
	Value []*SQLTriggerGetResults
}

// SQLTriggerResource - Cosmos DB SQL trigger resource object
type SQLTriggerResource struct {
	// REQUIRED; Name of the Cosmos DB SQL trigger
	ID *string

	// Body of the Trigger
	Body *string

	// The operation the trigger is associated with
	TriggerOperation *TriggerOperation

	// Type of the Trigger
	TriggerType *TriggerType
}

// SQLUserDefinedFunctionCreateUpdateParameters - Parameters to create and update Cosmos DB userDefinedFunction.
type SQLUserDefinedFunctionCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB userDefinedFunction.
	Properties *SQLUserDefinedFunctionCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// SQLUserDefinedFunctionCreateUpdateProperties - Properties to create and update Azure Cosmos DB userDefinedFunction.
type SQLUserDefinedFunctionCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a userDefinedFunction
	Resource *SQLUserDefinedFunctionResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// SQLUserDefinedFunctionGetProperties - The properties of an Azure Cosmos DB userDefinedFunction
type SQLUserDefinedFunctionGetProperties struct {
	Resource *SQLUserDefinedFunctionGetPropertiesResource
}

type SQLUserDefinedFunctionGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB SQL userDefinedFunction
	ID *string

	// Body of the User Defined Function
	Body *string

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// SQLUserDefinedFunctionGetResults - An Azure Cosmos DB userDefinedFunction.
type SQLUserDefinedFunctionGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB userDefinedFunction
	Properties *SQLUserDefinedFunctionGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// SQLUserDefinedFunctionListResult - The List operation response, that contains the userDefinedFunctions and their properties.
type SQLUserDefinedFunctionListResult struct {
	// READ-ONLY; List of userDefinedFunctions and their properties.
	Value []*SQLUserDefinedFunctionGetResults
}

// SQLUserDefinedFunctionResource - Cosmos DB SQL userDefinedFunction resource object
type SQLUserDefinedFunctionResource struct {
	// REQUIRED; Name of the Cosmos DB SQL userDefinedFunction
	ID *string

	// Body of the User Defined Function
	Body *string
}

type SeedNode struct {
	// IP address of this seed node.
	IPAddress *string
}

// ServiceResource - Properties for the database account.
type ServiceResource struct {
	// Services response resource.
	Properties ServiceResourcePropertiesClassification

	// READ-ONLY; The unique resource identifier of the database account.
	ID *string

	// READ-ONLY; The name of the database account.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// ServiceResourceCreateUpdateParameters - Parameters for Create or Update Request for ServiceResource
type ServiceResourceCreateUpdateParameters struct {
	// Properties in ServiceResourceCreateUpdateParameters.
	Properties *ServiceResourceCreateUpdateProperties
}

// ServiceResourceCreateUpdateProperties - Properties in ServiceResourceCreateUpdateParameters.
type ServiceResourceCreateUpdateProperties struct {
	// Instance count for the service.
	InstanceCount *int32

	// Instance type for the service.
	InstanceSize *ServiceSize

	// ServiceType for the service.
	ServiceType *ServiceType
}

// ServiceResourceListResult - The List operation response, that contains the Service Resource and their properties.
type ServiceResourceListResult struct {
	// READ-ONLY; List of Service Resource and their properties.
	Value []*ServiceResource
}

// ServiceResourceProperties - Services response resource.
type ServiceResourceProperties struct {
	// REQUIRED; ServiceType for the service.
	ServiceType *ServiceType

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Instance count for the service.
	InstanceCount *int32

	// Instance type for the service.
	InstanceSize *ServiceSize

	// READ-ONLY; Time of the last state change (ISO-8601 format).
	CreationTime *time.Time

	// READ-ONLY; Describes the status of a service.
	Status *ServiceStatus
}

// GetServiceResourceProperties implements the ServiceResourcePropertiesClassification interface for type ServiceResourceProperties.
func (s *ServiceResourceProperties) GetServiceResourceProperties() *ServiceResourceProperties {
	return s
}

type SpatialSpec struct {
	// The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string

	// List of path's spatial type
	Types []*SpatialType
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TableCreateUpdateParameters - Parameters to create and update Cosmos DB Table.
type TableCreateUpdateParameters struct {
	// REQUIRED; Properties to create and update Azure Cosmos DB Table.
	Properties *TableCreateUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// TableCreateUpdateProperties - Properties to create and update Azure Cosmos DB Table.
type TableCreateUpdateProperties struct {
	// REQUIRED; The standard JSON format of a Table
	Resource *TableResource

	// A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options *CreateUpdateOptions
}

// TableGetProperties - The properties of an Azure Cosmos Table
type TableGetProperties struct {
	Options  *TableGetPropertiesOptions
	Resource *TableGetPropertiesResource
}

type TableGetPropertiesOptions struct {
	// Specifies the Autoscale settings.
	AutoscaleSettings *AutoscaleSettings

	// Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer
	// details.
	Throughput *int32
}

type TableGetPropertiesResource struct {
	// REQUIRED; Name of the Cosmos DB table
	ID *string

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// TableGetResults - An Azure Cosmos DB Table.
type TableGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB Table
	Properties *TableGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// TableListResult - The List operation response, that contains the Table and their properties.
type TableListResult struct {
	// READ-ONLY; List of Table and their properties.
	Value []*TableGetResults
}

// TableResource - Cosmos DB table resource object
type TableResource struct {
	// REQUIRED; Name of the Cosmos DB table
	ID *string

	// Enum to indicate the mode of resource creation.
	CreateMode *CreateMode

	// Parameters to indicate the information about the restore
	RestoreParameters *ResourceRestoreParameters
}

// ThroughputPolicyResource - Cosmos DB resource throughput policy
type ThroughputPolicyResource struct {
	// Represents the percentage by which throughput can increase every time throughput policy kicks in.
	IncrementPercent *int32

	// Determines whether the ThroughputPolicy is active or not
	IsEnabled *bool
}

// ThroughputSettingsGetProperties - The properties of an Azure Cosmos DB resource throughput
type ThroughputSettingsGetProperties struct {
	Resource *ThroughputSettingsGetPropertiesResource
}

type ThroughputSettingsGetPropertiesResource struct {
	// Cosmos DB resource for autoscale settings. Either throughput is required or autoscaleSettings is required, but not both.
	AutoscaleSettings *AutoscaleSettingsResource

	// Value of the Cosmos DB resource throughput. Either throughput is required or autoscaleSettings is required, but not both.
	Throughput *int32

	// READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string

	// READ-ONLY; The minimum throughput of the resource
	MinimumThroughput *string

	// READ-ONLY; The throughput replace is pending
	OfferReplacePending *string

	// READ-ONLY; A system generated property. A unique identifier.
	Rid *string

	// READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts *float32
}

// ThroughputSettingsGetResults - An Azure Cosmos DB resource throughput.
type ThroughputSettingsGetResults struct {
	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// The properties of an Azure Cosmos DB resource throughput
	Properties *ThroughputSettingsGetProperties

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// ThroughputSettingsResource - Cosmos DB resource throughput object. Either throughput is required or autoscaleSettings is
// required, but not both.
type ThroughputSettingsResource struct {
	// Cosmos DB resource for autoscale settings. Either throughput is required or autoscaleSettings is required, but not both.
	AutoscaleSettings *AutoscaleSettingsResource

	// Value of the Cosmos DB resource throughput. Either throughput is required or autoscaleSettings is required, but not both.
	Throughput *int32

	// READ-ONLY; The minimum throughput of the resource
	MinimumThroughput *string

	// READ-ONLY; The throughput replace is pending
	OfferReplacePending *string
}

// ThroughputSettingsUpdateParameters - Parameters to update Cosmos DB resource throughput.
type ThroughputSettingsUpdateParameters struct {
	// REQUIRED; Properties to update Azure Cosmos DB resource throughput.
	Properties *ThroughputSettingsUpdateProperties

	// Identity for the resource.
	Identity *ManagedServiceIdentity

	// The location of the resource group to which the resource belongs.
	Location *string

	// Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource
	// (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example,
	// the default experience for a template type is set with "defaultExperience":
	// "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
	Tags map[string]*string

	// READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string

	// READ-ONLY; The name of the ARM resource.
	Name *string

	// READ-ONLY; The type of Azure resource.
	Type *string
}

// ThroughputSettingsUpdateProperties - Properties to update Azure Cosmos DB resource throughput.
type ThroughputSettingsUpdateProperties struct {
	// REQUIRED; The standard JSON format of a resource throughput
	Resource *ThroughputSettingsResource
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// UniqueKey - The unique key on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB
// service.
type UniqueKey struct {
	// List of paths must be unique for each document in the Azure Cosmos DB service
	Paths []*string
}

// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection
// in the Azure Cosmos DB service.
type UniqueKeyPolicy struct {
	// List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
	UniqueKeys []*UniqueKey
}

// Usage - The usage data for a usage request.
type Usage struct {
	// READ-ONLY; Current value for this metric
	CurrentValue *int64

	// READ-ONLY; Maximum value for this metric
	Limit *int64

	// READ-ONLY; The name information for the metric.
	Name *MetricName

	// READ-ONLY; The quota period used to summarize the usage values.
	QuotaPeriod *string

	// READ-ONLY; The unit of the metric.
	Unit *UnitType
}

// UsagesResult - The response to a list usage request.
type UsagesResult struct {
	// READ-ONLY; The list of usages for the database. A usage is a point in time metric
	Value []*Usage
}

// VirtualNetworkRule - Virtual Network ACL Rule object
type VirtualNetworkRule struct {
	// Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
	ID *string

	// Create firewall rule before the virtual network has vnet service endpoint enabled.
	IgnoreMissingVNetServiceEndpoint *bool
}
