//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcostmanagement

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// GenerateCostDetailsReportClient contains the methods for the GenerateCostDetailsReport group.
// Don't use this type directly, use NewGenerateCostDetailsReportClient() instead.
type GenerateCostDetailsReportClient struct {
	internal *arm.Client
}

// NewGenerateCostDetailsReportClient creates a new instance of GenerateCostDetailsReportClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewGenerateCostDetailsReportClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*GenerateCostDetailsReportClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &GenerateCostDetailsReportClient{
		internal: cl,
	}
	return client, nil
}

// BeginCreateOperation - This API is the replacement for all previously release Usage Details APIs. Request to generate a
// cost details report for the provided date range, billing period (Only enterprise customers) or Invoice
// Id asynchronously at a certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After'
// header. The 'Location' header will provide the endpoint to poll to get
// the result of the report generation. The 'Retry-After' provides the duration to wait before polling for the generated report.
// A call to poll the report operation will provide a 202 response with a
// 'Location' header if the operation is still in progress. Once the report generation operation completes, the polling endpoint
// will provide a 200 response along with details on the report blob(s) that
// are available for download. The details on the file(s) available for download will be available in the polling response
// body. To Understand cost details (formerly known as usage details) fields found
// in files ,see https://learn.microsoft.com/en-us/azure/cost-management-billing/automate/understand-usage-details-fields
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - scope - The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For details, see
//     https://aka.ms/costmgmt/scopes.
//   - parameters - Parameters supplied to the Create cost details operation.
//   - options - GenerateCostDetailsReportClientBeginCreateOperationOptions contains the optional parameters for the GenerateCostDetailsReportClient.BeginCreateOperation
//     method.
func (client *GenerateCostDetailsReportClient) BeginCreateOperation(ctx context.Context, scope string, parameters GenerateCostDetailsReportRequestDefinition, options *GenerateCostDetailsReportClientBeginCreateOperationOptions) (*runtime.Poller[GenerateCostDetailsReportClientCreateOperationResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOperation(ctx, scope, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GenerateCostDetailsReportClientCreateOperationResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GenerateCostDetailsReportClientCreateOperationResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOperation - This API is the replacement for all previously release Usage Details APIs. Request to generate a cost
// details report for the provided date range, billing period (Only enterprise customers) or Invoice
// Id asynchronously at a certain scope. The initial call to request a report will return a 202 with a 'Location' and 'Retry-After'
// header. The 'Location' header will provide the endpoint to poll to get
// the result of the report generation. The 'Retry-After' provides the duration to wait before polling for the generated report.
// A call to poll the report operation will provide a 202 response with a
// 'Location' header if the operation is still in progress. Once the report generation operation completes, the polling endpoint
// will provide a 200 response along with details on the report blob(s) that
// are available for download. The details on the file(s) available for download will be available in the polling response
// body. To Understand cost details (formerly known as usage details) fields found
// in files ,see https://learn.microsoft.com/en-us/azure/cost-management-billing/automate/understand-usage-details-fields
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
func (client *GenerateCostDetailsReportClient) createOperation(ctx context.Context, scope string, parameters GenerateCostDetailsReportRequestDefinition, options *GenerateCostDetailsReportClientBeginCreateOperationOptions) (*http.Response, error) {
	var err error
	const operationName = "GenerateCostDetailsReportClient.BeginCreateOperation"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOperationCreateRequest(ctx, scope, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOperationCreateRequest creates the CreateOperation request.
func (client *GenerateCostDetailsReportClient) createOperationCreateRequest(ctx context.Context, scope string, parameters GenerateCostDetailsReportRequestDefinition, options *GenerateCostDetailsReportClientBeginCreateOperationOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/generateCostDetailsReport"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginGetOperationResults - Get the result of the specified operation. This link is provided in the CostDetails creation
// request response Location header.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
//   - scope - The ARM Resource ID for subscription, resource group, billing account, or other billing scopes. For details, see
//     https://aka.ms/costmgmt/scopes.
//   - operationID - The target operation Id.
//   - options - GenerateCostDetailsReportClientBeginGetOperationResultsOptions contains the optional parameters for the GenerateCostDetailsReportClient.BeginGetOperationResults
//     method.
func (client *GenerateCostDetailsReportClient) BeginGetOperationResults(ctx context.Context, scope string, operationID string, options *GenerateCostDetailsReportClientBeginGetOperationResultsOptions) (*runtime.Poller[GenerateCostDetailsReportClientGetOperationResultsResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.getOperationResults(ctx, scope, operationID, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GenerateCostDetailsReportClientGetOperationResultsResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GenerateCostDetailsReportClientGetOperationResultsResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// GetOperationResults - Get the result of the specified operation. This link is provided in the CostDetails creation request
// response Location header.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-10-01
func (client *GenerateCostDetailsReportClient) getOperationResults(ctx context.Context, scope string, operationID string, options *GenerateCostDetailsReportClientBeginGetOperationResultsOptions) (*http.Response, error) {
	var err error
	const operationName = "GenerateCostDetailsReportClient.BeginGetOperationResults"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getOperationResultsCreateRequest(ctx, scope, operationID, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// getOperationResultsCreateRequest creates the GetOperationResults request.
func (client *GenerateCostDetailsReportClient) getOperationResultsCreateRequest(ctx context.Context, scope string, operationID string, options *GenerateCostDetailsReportClientBeginGetOperationResultsOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.CostManagement/costDetailsOperationResults/{operationId}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
