//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dns/armdns"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// RecordSetsServer is a fake server for instances of the armdns.RecordSetsClient type.
type RecordSetsServer struct {
	// CreateOrUpdate is the fake for method RecordSetsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, zoneName string, relativeRecordSetName string, recordType armdns.RecordType, parameters armdns.RecordSet, options *armdns.RecordSetsClientCreateOrUpdateOptions) (resp azfake.Responder[armdns.RecordSetsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method RecordSetsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, zoneName string, relativeRecordSetName string, recordType armdns.RecordType, options *armdns.RecordSetsClientDeleteOptions) (resp azfake.Responder[armdns.RecordSetsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method RecordSetsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, zoneName string, relativeRecordSetName string, recordType armdns.RecordType, options *armdns.RecordSetsClientGetOptions) (resp azfake.Responder[armdns.RecordSetsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListAllByDNSZonePager is the fake for method RecordSetsClient.NewListAllByDNSZonePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAllByDNSZonePager func(resourceGroupName string, zoneName string, options *armdns.RecordSetsClientListAllByDNSZoneOptions) (resp azfake.PagerResponder[armdns.RecordSetsClientListAllByDNSZoneResponse])

	// NewListByDNSZonePager is the fake for method RecordSetsClient.NewListByDNSZonePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDNSZonePager func(resourceGroupName string, zoneName string, options *armdns.RecordSetsClientListByDNSZoneOptions) (resp azfake.PagerResponder[armdns.RecordSetsClientListByDNSZoneResponse])

	// NewListByTypePager is the fake for method RecordSetsClient.NewListByTypePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTypePager func(resourceGroupName string, zoneName string, recordType armdns.RecordType, options *armdns.RecordSetsClientListByTypeOptions) (resp azfake.PagerResponder[armdns.RecordSetsClientListByTypeResponse])

	// Update is the fake for method RecordSetsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, zoneName string, relativeRecordSetName string, recordType armdns.RecordType, parameters armdns.RecordSet, options *armdns.RecordSetsClientUpdateOptions) (resp azfake.Responder[armdns.RecordSetsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewRecordSetsServerTransport creates a new instance of RecordSetsServerTransport with the provided implementation.
// The returned RecordSetsServerTransport instance is connected to an instance of armdns.RecordSetsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRecordSetsServerTransport(srv *RecordSetsServer) *RecordSetsServerTransport {
	return &RecordSetsServerTransport{
		srv:                      srv,
		newListAllByDNSZonePager: newTracker[azfake.PagerResponder[armdns.RecordSetsClientListAllByDNSZoneResponse]](),
		newListByDNSZonePager:    newTracker[azfake.PagerResponder[armdns.RecordSetsClientListByDNSZoneResponse]](),
		newListByTypePager:       newTracker[azfake.PagerResponder[armdns.RecordSetsClientListByTypeResponse]](),
	}
}

// RecordSetsServerTransport connects instances of armdns.RecordSetsClient to instances of RecordSetsServer.
// Don't use this type directly, use NewRecordSetsServerTransport instead.
type RecordSetsServerTransport struct {
	srv                      *RecordSetsServer
	newListAllByDNSZonePager *tracker[azfake.PagerResponder[armdns.RecordSetsClientListAllByDNSZoneResponse]]
	newListByDNSZonePager    *tracker[azfake.PagerResponder[armdns.RecordSetsClientListByDNSZoneResponse]]
	newListByTypePager       *tracker[azfake.PagerResponder[armdns.RecordSetsClientListByTypeResponse]]
}

// Do implements the policy.Transporter interface for RecordSetsServerTransport.
func (r *RecordSetsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RecordSetsClient.CreateOrUpdate":
		resp, err = r.dispatchCreateOrUpdate(req)
	case "RecordSetsClient.Delete":
		resp, err = r.dispatchDelete(req)
	case "RecordSetsClient.Get":
		resp, err = r.dispatchGet(req)
	case "RecordSetsClient.NewListAllByDNSZonePager":
		resp, err = r.dispatchNewListAllByDNSZonePager(req)
	case "RecordSetsClient.NewListByDNSZonePager":
		resp, err = r.dispatchNewListByDNSZonePager(req)
	case "RecordSetsClient.NewListByTypePager":
		resp, err = r.dispatchNewListByTypePager(req)
	case "RecordSetsClient.Update":
		resp, err = r.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RecordSetsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsZones/(?P<zoneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<recordType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<relativeRecordSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdns.RecordSet](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	zoneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("zoneName")])
	if err != nil {
		return nil, err
	}
	relativeRecordSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relativeRecordSetName")])
	if err != nil {
		return nil, err
	}
	recordTypeParam, err := parseWithCast(matches[regex.SubexpIndex("recordType")], func(v string) (armdns.RecordType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armdns.RecordType(p), nil
	})
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	ifNoneMatchParam := getOptional(getHeaderValue(req.Header, "If-None-Match"))
	var options *armdns.RecordSetsClientCreateOrUpdateOptions
	if ifMatchParam != nil || ifNoneMatchParam != nil {
		options = &armdns.RecordSetsClientCreateOrUpdateOptions{
			IfMatch:     ifMatchParam,
			IfNoneMatch: ifNoneMatchParam,
		}
	}
	respr, errRespr := r.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, zoneNameParam, relativeRecordSetNameParam, recordTypeParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RecordSet, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecordSetsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if r.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsZones/(?P<zoneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<recordType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<relativeRecordSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	zoneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("zoneName")])
	if err != nil {
		return nil, err
	}
	relativeRecordSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relativeRecordSetName")])
	if err != nil {
		return nil, err
	}
	recordTypeParam, err := parseWithCast(matches[regex.SubexpIndex("recordType")], func(v string) (armdns.RecordType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armdns.RecordType(p), nil
	})
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	var options *armdns.RecordSetsClientDeleteOptions
	if ifMatchParam != nil {
		options = &armdns.RecordSetsClientDeleteOptions{
			IfMatch: ifMatchParam,
		}
	}
	respr, errRespr := r.srv.Delete(req.Context(), resourceGroupNameParam, zoneNameParam, relativeRecordSetNameParam, recordTypeParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecordSetsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsZones/(?P<zoneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<recordType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<relativeRecordSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	zoneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("zoneName")])
	if err != nil {
		return nil, err
	}
	relativeRecordSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relativeRecordSetName")])
	if err != nil {
		return nil, err
	}
	recordTypeParam, err := parseWithCast(matches[regex.SubexpIndex("recordType")], func(v string) (armdns.RecordType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armdns.RecordType(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, zoneNameParam, relativeRecordSetNameParam, recordTypeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RecordSet, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RecordSetsServerTransport) dispatchNewListAllByDNSZonePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListAllByDNSZonePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAllByDNSZonePager not implemented")}
	}
	newListAllByDNSZonePager := r.newListAllByDNSZonePager.get(req)
	if newListAllByDNSZonePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsZones/(?P<zoneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/all`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		zoneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("zoneName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		recordSetNameSuffixUnescaped, err := url.QueryUnescape(qp.Get("$recordsetnamesuffix"))
		if err != nil {
			return nil, err
		}
		recordSetNameSuffixParam := getOptional(recordSetNameSuffixUnescaped)
		var options *armdns.RecordSetsClientListAllByDNSZoneOptions
		if topParam != nil || recordSetNameSuffixParam != nil {
			options = &armdns.RecordSetsClientListAllByDNSZoneOptions{
				Top:                 topParam,
				RecordSetNameSuffix: recordSetNameSuffixParam,
			}
		}
		resp := r.srv.NewListAllByDNSZonePager(resourceGroupNameParam, zoneNameParam, options)
		newListAllByDNSZonePager = &resp
		r.newListAllByDNSZonePager.add(req, newListAllByDNSZonePager)
		server.PagerResponderInjectNextLinks(newListAllByDNSZonePager, req, func(page *armdns.RecordSetsClientListAllByDNSZoneResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAllByDNSZonePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListAllByDNSZonePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAllByDNSZonePager) {
		r.newListAllByDNSZonePager.remove(req)
	}
	return resp, nil
}

func (r *RecordSetsServerTransport) dispatchNewListByDNSZonePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByDNSZonePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDNSZonePager not implemented")}
	}
	newListByDNSZonePager := r.newListByDNSZonePager.get(req)
	if newListByDNSZonePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsZones/(?P<zoneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recordsets`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		zoneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("zoneName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		recordsetnamesuffixUnescaped, err := url.QueryUnescape(qp.Get("$recordsetnamesuffix"))
		if err != nil {
			return nil, err
		}
		recordsetnamesuffixParam := getOptional(recordsetnamesuffixUnescaped)
		var options *armdns.RecordSetsClientListByDNSZoneOptions
		if topParam != nil || recordsetnamesuffixParam != nil {
			options = &armdns.RecordSetsClientListByDNSZoneOptions{
				Top:                 topParam,
				Recordsetnamesuffix: recordsetnamesuffixParam,
			}
		}
		resp := r.srv.NewListByDNSZonePager(resourceGroupNameParam, zoneNameParam, options)
		newListByDNSZonePager = &resp
		r.newListByDNSZonePager.add(req, newListByDNSZonePager)
		server.PagerResponderInjectNextLinks(newListByDNSZonePager, req, func(page *armdns.RecordSetsClientListByDNSZoneResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDNSZonePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByDNSZonePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDNSZonePager) {
		r.newListByDNSZonePager.remove(req)
	}
	return resp, nil
}

func (r *RecordSetsServerTransport) dispatchNewListByTypePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByTypePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTypePager not implemented")}
	}
	newListByTypePager := r.newListByTypePager.get(req)
	if newListByTypePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsZones/(?P<zoneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<recordType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		zoneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("zoneName")])
		if err != nil {
			return nil, err
		}
		recordTypeParam, err := parseWithCast(matches[regex.SubexpIndex("recordType")], func(v string) (armdns.RecordType, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armdns.RecordType(p), nil
		})
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		recordsetnamesuffixUnescaped, err := url.QueryUnescape(qp.Get("$recordsetnamesuffix"))
		if err != nil {
			return nil, err
		}
		recordsetnamesuffixParam := getOptional(recordsetnamesuffixUnescaped)
		var options *armdns.RecordSetsClientListByTypeOptions
		if topParam != nil || recordsetnamesuffixParam != nil {
			options = &armdns.RecordSetsClientListByTypeOptions{
				Top:                 topParam,
				Recordsetnamesuffix: recordsetnamesuffixParam,
			}
		}
		resp := r.srv.NewListByTypePager(resourceGroupNameParam, zoneNameParam, recordTypeParam, options)
		newListByTypePager = &resp
		r.newListByTypePager.add(req, newListByTypePager)
		server.PagerResponderInjectNextLinks(newListByTypePager, req, func(page *armdns.RecordSetsClientListByTypeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTypePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByTypePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTypePager) {
		r.newListByTypePager.remove(req)
	}
	return resp, nil
}

func (r *RecordSetsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/dnsZones/(?P<zoneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<recordType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<relativeRecordSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdns.RecordSet](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	zoneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("zoneName")])
	if err != nil {
		return nil, err
	}
	relativeRecordSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("relativeRecordSetName")])
	if err != nil {
		return nil, err
	}
	recordTypeParam, err := parseWithCast(matches[regex.SubexpIndex("recordType")], func(v string) (armdns.RecordType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armdns.RecordType(p), nil
	})
	if err != nil {
		return nil, err
	}
	ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
	var options *armdns.RecordSetsClientUpdateOptions
	if ifMatchParam != nil {
		options = &armdns.RecordSetsClientUpdateOptions{
			IfMatch: ifMatchParam,
		}
	}
	respr, errRespr := r.srv.Update(req.Context(), resourceGroupNameParam, zoneNameParam, relativeRecordSetNameParam, recordTypeParam, body, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RecordSet, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
