//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/eventgrid/armeventgrid/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// VerifiedPartnersServer is a fake server for instances of the armeventgrid.VerifiedPartnersClient type.
type VerifiedPartnersServer struct {
	// Get is the fake for method VerifiedPartnersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, verifiedPartnerName string, options *armeventgrid.VerifiedPartnersClientGetOptions) (resp azfake.Responder[armeventgrid.VerifiedPartnersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method VerifiedPartnersClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armeventgrid.VerifiedPartnersClientListOptions) (resp azfake.PagerResponder[armeventgrid.VerifiedPartnersClientListResponse])
}

// NewVerifiedPartnersServerTransport creates a new instance of VerifiedPartnersServerTransport with the provided implementation.
// The returned VerifiedPartnersServerTransport instance is connected to an instance of armeventgrid.VerifiedPartnersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVerifiedPartnersServerTransport(srv *VerifiedPartnersServer) *VerifiedPartnersServerTransport {
	return &VerifiedPartnersServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armeventgrid.VerifiedPartnersClientListResponse]](),
	}
}

// VerifiedPartnersServerTransport connects instances of armeventgrid.VerifiedPartnersClient to instances of VerifiedPartnersServer.
// Don't use this type directly, use NewVerifiedPartnersServerTransport instead.
type VerifiedPartnersServerTransport struct {
	srv          *VerifiedPartnersServer
	newListPager *tracker[azfake.PagerResponder[armeventgrid.VerifiedPartnersClientListResponse]]
}

// Do implements the policy.Transporter interface for VerifiedPartnersServerTransport.
func (v *VerifiedPartnersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VerifiedPartnersClient.Get":
		resp, err = v.dispatchGet(req)
	case "VerifiedPartnersClient.NewListPager":
		resp, err = v.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VerifiedPartnersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.EventGrid/verifiedPartners/(?P<verifiedPartnerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	verifiedPartnerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("verifiedPartnerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), verifiedPartnerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VerifiedPartner, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VerifiedPartnersServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := v.newListPager.get(req)
	if newListPager == nil {
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.VerifiedPartnersClientListOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.VerifiedPartnersClientListOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := v.srv.NewListPager(options)
		newListPager = &resp
		v.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armeventgrid.VerifiedPartnersClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		v.newListPager.remove(req)
	}
	return resp, nil
}
