GOPHIAN-ESTIMATE-GRAPHVIZ(1)

# NAME

gophian-estimate-graphviz - Visualize the dependency tree of a given Go package

# SYNOPSIS

*gophian estimate-graphviz* <IMPORTPATH> [SOURCE_OUTPUT] [OPTIONS]

# DESCRIPTION

This subcommand is only available when python3-graphviz is installed.

This subcommand recursively finds all dependencies of a given package and
checks if they are packaged in Debian, producing a dependency tree using
Graphviz showing dependencies that are available as Debian packages and which
are not. This is useful for large or complex dependency graphs that are much
better depicted by a Graphviz tree.

A source Graphviz file will be written to *SOURCE_OUTPUT*, and unless
*--no-render* is passed, a rendered PDF will be written in the same directory as
the source file with the same basename, but the ".pdf" output.

# ARGUMENTS

*IMPORTPATH* - The import path of the Go package being estimated.

*SOURCE_OUTPUT* - Output path of the source Graphviz code. By default, this is
the Debianized version of the import path e.g. golang-github-dsnet-compress.gv.

# OPTIONS

*--[no-]quiet* - Don't print warnings.

*--[no-]open* - View rendered output in the most suitable application.
(default: on)

*--[no-]render* - Render the graph using Graphviz. (default: on)

*--[no-]warn-packaged* - Warn if the given Go package has already been packaged
for Debian. (default: on)

*--[no-]include-packaged-deps* - Include packaged dependencies in the estimate.
(default: on)

*--[no-]include-version-conflicts* - Include any version conflicts between the
package's go.mod and the version in Debian unstable. Ignored if
*--no-include-packaged-deps* is passed. (default: on)

*--max-depth* <INT> - Maximum recursion depth of unpackaged dependencies.

*--help* - Show help message and exit.

# SEE ALSO

_gophian-estimate_(1)
