#pragma once
/*
 *  $Id: cairo-utils.h 28793 2025-11-05 08:18:57Z yeti-dn $
 *  Copyright (C) 2012-2024; David Nečas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_CAIRO_UTILS_H__
#define __GWYUI_CAIRO_UTILS_H__

#include <cairo/cairo.h>
#include <gtk/gtk.h>

#include "libgwyddion/rgba.h"
#include "libgwyddion/gradient.h"

G_BEGIN_DECLS

void             gwy_cairo_set_source_rgba        (cairo_t *cr,
                                                   const GwyRGBA *rgba);
cairo_pattern_t* gwy_cairo_pattern_create_gradient(GwyGradient *gradient,
                                                   GtkPositionType towards,
                                                   gboolean use_alpha)      G_GNUC_MALLOC;
void             gwy_cairo_checker_rectangle      (cairo_t *cr,
                                                   const GwyRGBA *even,
                                                   const GwyRGBA *odd,
                                                   gint width,
                                                   gint height,
                                                   gint size);
void             gwy_cairo_line                   (cairo_t *cr,
                                                   gdouble xfrom,
                                                   gdouble yfrom,
                                                   gdouble xto,
                                                   gdouble yto);
void             gwy_cairo_ellipse                (cairo_t *cr,
                                                   gdouble x,
                                                   gdouble y,
                                                   gdouble xr,
                                                   gdouble yr);
void             gwy_cairo_cross                  (cairo_t *cr,
                                                   gdouble x,
                                                   gdouble y,
                                                   gdouble halfside);
void             gwy_cairo_times                  (cairo_t *cr,
                                                   gdouble x,
                                                   gdouble y,
                                                   gdouble halfside);
void             gwy_cairo_asterisk               (cairo_t *cr,
                                                   gdouble x,
                                                   gdouble y,
                                                   gdouble halfside);
void             gwy_cairo_square                 (cairo_t *cr,
                                                   gdouble x,
                                                   gdouble y,
                                                   gdouble halfside);
void             gwy_cairo_diamond                (cairo_t *cr,
                                                   gdouble x,
                                                   gdouble y,
                                                   gdouble halfside);
void             gwy_cairo_triangle_up            (cairo_t *cr,
                                                   gdouble x,
                                                   gdouble y,
                                                   gdouble halfside);
void             gwy_cairo_triangle_down          (cairo_t *cr,
                                                   gdouble x,
                                                   gdouble y,
                                                   gdouble halfside);
void             gwy_cairo_triangle_left          (cairo_t *cr,
                                                   gdouble x,
                                                   gdouble y,
                                                   gdouble halfside);
void             gwy_cairo_triangle_right         (cairo_t *cr,
                                                   gdouble x,
                                                   gdouble y,
                                                   gdouble halfside);


void gwy_cairo_region_add_line      (cairo_region_t *region,
                                     gdouble xfrom,
                                     gdouble yfrom,
                                     gdouble xto,
                                     gdouble yto,
                                     gdouble lw);
void gwy_cairo_region_add_crectangle(cairo_region_t *region,
                                     gdouble xc,
                                     gdouble yc,
                                     gdouble xr,
                                     gdouble yr,
                                     gdouble lw);
void gwy_cairo_region_add_erectangle(cairo_region_t *region,
                                     gdouble x1,
                                     gdouble y1,
                                     gdouble x2,
                                     gdouble y2,
                                     gdouble lw);
void gwy_cairo_region_add_ellipse   (cairo_region_t *region,
                                     gdouble xc,
                                     gdouble yc,
                                     gdouble xr,
                                     gdouble yr,
                                     gdouble lw);

void gwy_cairo_draw_or_add_thin_line(cairo_t *cr,
                                     cairo_region_t *region,
                                     gdouble xfrom,
                                     gdouble yfrom,
                                     gdouble xto,
                                     gdouble yto);
G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
