+++
title = "htmx 1.7.0 has been released!"
date = 2022-02-22
[taxonomies]
tag = ["posts", "announcements"]
+++

## htmx 1.7.0 Release

I'm happy to announce the [1.7.0 release](https://unpkg.com/browse/htmx.org@1.7.0/) of htmx.

### New Features

* The new [`hx-sync`](@/attributes/hx-sync.md) attribute allows you to synchronize multiple element requests on a single
  element using various strategies (e.g. replace)
  * You can also now abort an element making a request by sending it the `htmx:abort` event
* [Server Sent Events](https://github.com/bigskysoftware/htmx-extensions/blob/main/src/sse/README.md) and [Web Sockets](https://github.com/bigskysoftware/htmx-extensions/blob/main/src/ws/README.md) are now available as 
  extensions, in addition to the normal core support.  In htmx 2.0, the current `hx-sse` and `hx-ws` attributes will be
  moved entirely out to these new extensions.  By moving these features to extensions we will be able to add functionality 
  to both of them without compromising the core file size of htmx.  You are encouraged to move over to the new 
  extensions, but `hx-sse` and `hx-ws` will continue to work indefinitely in htmx 1.x.
* You can now mask out [attribute inheritance](@/docs.md#inheritance) via the `hx-disinherit` attribute.
* The `HX-Push` header can now have the `false` value, which will prevent a history snapshot from occurring.
* Many new extensions, with a big thanks to all the contributors!
    * A new [`alpine-morph`](https://github.com/bigskysoftware/htmx-extensions/blob/main/src/alpine-morph/README.md) extension allows you to use Alpine's swapping engine, which preserves Alpine state when you have entire Alpine components swapped by htmx.
    * A [restored](https://github.com/bigskysoftware/htmx-extensions/blob/main/src/restored/README.md) extension was added that will trigger a `restore` event on all elements in the DOM
      on history restoration.
    * A [loading-states](https://github.com/bigskysoftware/htmx-extensions/blob/main/src/loading-states/README.md) extension was added that allows you to easily manage loading states
      while a request is in flight, including disabling elements, and adding and removing CSS classes. 
* The `this` symbol now resolves properly for the [`hx-include`](@/attributes/hx-include.md) and [`hx-indicator`](@/attributes/hx-indicator.md)
  attributes
* When an object is included via the `hx-vals` attribute, it will be converted to JSON (rather 
  than rendering as the string `[Object object]"`)
* You can now pass a swap style in to the `htmx.ajax()` function call.
* Poll events now contain a `target` attribute, allowing you to filter a poll on the element that is polling.
* Two new Out Of Band-related events were added: `htmx:oobBeforeSwap` & `htmx:oobAfterSwap`
  
### Improvements & Bug fixes

* Many, many documentation updates (thank you to all the contributors!)

Enjoy!
