#include <cstdlib>
#include <stdint.h>
#include <string>

template <typename T> struct CustomAlloc {
  using value_type = T;
  using pointer = value_type *;
  using const_pointer = const value_type *;
  using size_type = std::size_t;

  pointer allocate(size_type n) { return (T *)malloc(n * sizeof(T)); }

  void deallocate(pointer p, size_type) {
    if (p)
      free(p);
  }
};

using CustomString =
    std::basic_string<char, std::char_traits<char>, CustomAlloc<char>>;

using CustomWString =
    std::basic_string<wchar_t, std::char_traits<wchar_t>, CustomAlloc<wchar_t>>;

using CustomStringU16 = std::basic_string<char16_t, std::char_traits<char16_t>,
                                          CustomAlloc<char16_t>>;

using CustomStringU32 = std::basic_string<char32_t, std::char_traits<char32_t>,
                                          CustomAlloc<char32_t>>;

size_t touch_string(std::string &in_str) {
  return in_str.size(); // Break here to look at bad string
}

int main() {
  std::wstring wempty(L"");
  std::wstring s(L"hello world! מזל טוב!");
  std::wstring S(L"!!!!");
  const wchar_t *mazeltov = L"מזל טוב";
  std::string empty("");
  std::string q("hello world");
  std::string Q("quite a long std::strin with lots of info inside it");
  std::string overwritten_zero("abc");
  const_cast<char *>(overwritten_zero.data())[3] = 'd';
  std::string TheVeryLongOne(
      "123456789012345678901234567890123456789012345678901234567890123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "901234567890123456789012345678901234567890123456789012345678901234567890"
      "123456789012345678901234567890123456789012345678901234567890123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "901234567890123456789012345678901234567890123456789012345678901234567890"
      "123456789012345678901234567890123456789012345678901234567890123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "901234567890123456789012345678901234567890123456789012345678901234567890"
      "123456789012345678901234567890123456789012345678901234567890123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "901234567890123456789012345678901234567890123456789012345678901234567890"
      "123456789012345678901234567890123456789012345678901234567890123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "901234567890123456789012345678901234567890123456789012345678901234567890"
      "123456789012345678901234567890123456789012345678901234567890123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "901234567890123456789012345678901234567890123456789012345678901234567890"
      "123456789012345678901234567890123456789012345678901234567890123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "9012345678901234567890123456789012345678901234567890someText123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "901234567890123456789012345678901234567890123456789012345678901234567890"
      "123456789012345678901234567890123456789012345678901234567890123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "901234567890123456789012345678901234567890123456789012345678901234567890"
      "123456789012345678901234567890123456789012345678901234567890123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "901234567890123456789012345678901234567890123456789012345678901234567890"
      "123456789012345678901234567890123456789012345678901234567890123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "901234567890123456789012345678901234567890123456789012345678901234567890"
      "123456789012345678901234567890123456789012345678901234567890123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "901234567890123456789012345678901234567890123456789012345678901234567890"
      "123456789012345678901234567890123456789012345678901234567890123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "901234567890123456789012345678901234567890123456789012345678901234567890"
      "123456789012345678901234567890123456789012345678901234567890123456789012"
      "345678901234567890123456789012345678901234567890123456789012345678901234"
      "567890123456789012345678901234567890123456789012345678901234567890123456"
      "789012345678901234567890123456789012345678901234567890123456789012345678"
      "901234567890123456789012345678901234567890123456789012345678901234567890"
      "1234567890123456789012345678901234567890");
  std::string IHaveEmbeddedZeros("a\0b\0c\0d", 7);
  std::wstring IHaveEmbeddedZerosToo(
      L"hello world!\0てざ ル゜䋨ミ㠧槊 きゅへ狦穤襩 じゃ馩リョ 䤦監", 38);
  std::u16string u16_string(u"ß水氶");
  std::u16string u16_empty(u"");
  std::u32string u32_string(U"🍄🍅🍆🍌");
  std::u32string u32_empty(U"");
  std::string *null_str = nullptr;
  auto &rq = q;
  auto &rQ = Q;
  std::string *pq = &q;
  std::string *pQ = &Q;

  CustomString custom_str("hello!");
  CustomWString custom_wstr(L"hello!");
  CustomStringU16 custom_u16(u16_string.c_str());
  CustomStringU16 custom_u16_empty(u"");
  CustomStringU32 custom_u32(u32_string.c_str());
  CustomStringU32 custom_u32_empty(U"");

  S.assign(L"!!!!!"); // Set break point at this line.
  std::string *not_a_string = (std::string *)0x0;
  touch_string(*not_a_string);

  return 0;
}
