message("${BoldGreen}Implementing the UNIX toolchain${ColourReset}")

set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)
set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)

find_package(
    Qt6 REQUIRED
    COMPONENTS Widgets
               Xml
               Svg
               SvgWidgets
               PrintSupport
               Network
               Qml
               Sql
               Concurrent
               Core5Compat
               GLOBAL
)


# Find the libIsoSpec library
find_package(IsoSpec++ GLOBAL REQUIRED)

find_package(PwizLite REQUIRED)

find_package(
    Boost
    COMPONENTS chrono
               container
               filesystem
               iostreams
               thread
    REQUIRED
)

if(SQLite3_FOUND)
else(SQLite3_FOUND)
    set(SQLite3_DIR ${CMAKE_MODULE_PATH})
    find_package(SQLite3 REQUIRED)
endif(SQLite3_FOUND)


find_package(QCustomPlotQt6 REQUIRED)
message(STATUS "Setting definition -DQCUSTOMPLOT_USE_LIBRARY.")

find_package(ZLIB REQUIRED)

find_package(Zstd REQUIRED)

find_package(liblzf REQUIRED)

find_package(OdsStream COMPONENTS Core)

find_package(QuaZip-Qt6 REQUIRED)

find_package(QScintilla REQUIRED)


if(PAPPSO_LOCAL_INST)
    message(STATUS "Selecting the /usr/local/lib pappso libs.")
    include(${CMAKE_TOOLCHAINS_PATH}/unix-toolchain-local-inst-pappso.cmake)
elseif(PAPPSO_LOCAL_DEV)
    message(STATUS "Selecting the local development pappso lib.")
    include(${CMAKE_TOOLCHAINS_PATH}/unix-toolchain-local-dev-pappso.cmake)
else()
    find_package(
        PappsoMSpp
        COMPONENTS Core Gui GLOBAL
        REQUIRED
    )
endif()

if(XPERTMASS_LOCAL_INST)
    message(STATUS "Selecting the /usr/local/lib xpertmass libs.")
    include(${CMAKE_TOOLCHAINS_PATH}/unix-toolchain-local-inst-xpertmass.cmake)
elseif(XPERTMASS_LOCAL_DEV)
    message(STATUS "Selecting the local development xpertmass lib.")
    include(${CMAKE_TOOLCHAINS_PATH}/unix-toolchain-local-dev-xpertmass.cmake)
else()
    find_package(
        XpertMass
        COMPONENTS Core Gui GLOBAL
        REQUIRED
    )
endif()

get_target_property(CORE_LIB_PATH XpertMass::Core LOCATION)
message(STATUS "XpertMass::Core path: ${CORE_LIB_PATH}")
get_target_property(GUI_LIB_PATH XpertMass::Gui LOCATION)
message(STATUS "XpertMass::Gui path: ${GUI_LIB_PATH}")

################# INSTALL directories #################
################# INSTALL directories #################
################# INSTALL directories #################

#### These directories do not include the CMAKE_INSTALL_PREFIX path.
#### In the install actions of this CMake-based configuration, only use
#### PROJECT_INSTALL_<VARIABLE>

set(PROJECT_INSTALL_PREFIX ${CMAKE_INSTALL_PREFIX})
message("The project install prefix: ${PROJECT_INSTALL_PREFIX}")

### The directory where the binary is to be installed
set(PROJECT_INSTALL_BIN_DIR ${CMAKE_INSTALL_BINDIR})
message(STATUS "The project install bin dir: ${PROJECT_INSTALL_BIN_DIR}")

message(STATUS "The install library ${CMAKE_INSTALL_LIBDIR} default: ${CMAKE_INSTALL_LIBDIR}")

# I thought it was necessary to define the install lib dir with triplet, but
# CMake does its choice alone.

# get_deb_triplet_string(DEB_TRIPLET_STRING)
#
# if(NOT "${CMAKE_LIBRARY_ARCHITECTURE}" STREQUAL "${DEB_TRIPLET_STRING}")
#     message(FATAL_ERROR "Odd situation where CMAKE_LIBRARY_ARCHITECTURE is not equal to DEB_TRIPLET_STRING")
# endif()

# if(DEB_TRIPLET_STRING)
#     set(CMAKE_INSTALL_TRIPLET_LIBDIR ${CMAKE_INSTALL_LIBDIR}/${DEB_TRIPLET_STRING})
#     set(CMAKE_INSTALL_FULL_TRIPLET_LIBDIR ${CMAKE_INSTALL_FULL_LIBDIR}/${DEB_TRIPLET_STRING})
# endif()
#
# message(STATUS "The install library is configured: ${CMAKE_INSTALL_LIBDIR}")
# message(STATUS "The full install library is configured: ${CMAKE_INSTALL_FULL_LIBDIR}")
#
# message(STATUS "The install triplet library is configured: ${CMAKE_INSTALL_TRIPLET_LIBDIR}")
# message(STATUS "The full install triplet library is configured: ${CMAKE_INSTALL_FULL_TRIPLET_LIBDIR}")

set(PROJECT_INSTALL_LIB_DIR ${CMAKE_INSTALL_LIBDIR})
message(STATUS "The project install lib dir: ${PROJECT_INSTALL_LIB_DIR}")

# This one is the share directory on UNIX
set(PROJECT_INSTALL_DATA_DIR ${CMAKE_INSTALL_DATADIR}/${LOWCASE_PROJECT_NAME})
message(STATUS "The project install data dir: ${PROJECT_INSTALL_DATA_DIR}")

set(PROJECT_INSTALL_CHEMDATA_DIR ${PROJECT_INSTALL_DATA_DIR}/data)
message(STATUS "The project install chemical data dir: ${PROJECT_INSTALL_CHEMDATA_DIR}")

set(PROJECT_INSTALL_DOC_DIR ${CMAKE_INSTALL_DATADIR}/doc/${LOWCASE_PROJECT_NAME})
message(STATUS "The project install doc dir: ${PROJECT_INSTALL_DOC_DIR}")

# The appstream, desktop and icon files
install(
    FILES org.msxpertsuite.${PROJECT_NAME}.desktop
    DESTINATION ${CMAKE_INSTALL_DATADIR}/applications
)

install(
    FILES org.msxpertsuite.${PROJECT_NAME}.metainfo.xml
    DESTINATION ${CMAKE_INSTALL_DATADIR}/metainfo
)

set(icon_resolutions "16x16" "32x32" "48x48" "64x64" "128x128" "256x256" "512x512")

foreach(resolution IN LISTS icon_resolutions)
    install(
        FILES images/icons/${resolution}/${PROJECT_NAME}.png
        DESTINATION ${CMAKE_INSTALL_DATADIR}/icons/hicolor/${resolution}/apps
)
endforeach()


## Platform-dependent compiler flags:
include(CheckCXXCompilerFlag)

if(WITH_FPIC)
    add_definitions(-fPIC)
endif()
