/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QGroupBox>
#include <QList>
#include <QVBoxLayout>
#include <QFrame>
#include <QGridLayout>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "ChemPadButton.hpp"


namespace MsXpS
{
namespace MassXpert
{


class CalculatorChemPadGroupBox : public QGroupBox
{
  Q_OBJECT

  private:
  QList<QWidget *> m_widgetList;
  QVBoxLayout *mpa_vboxLayout;
  QFrame *mpa_frame;
  QGridLayout *mpa_gridLayout;


  public:
  CalculatorChemPadGroupBox(QWidget * = 0);
  CalculatorChemPadGroupBox(const QString &, QWidget * = 0);

  void addChemPadButton(ChemPadButton *, int, int);

  ~CalculatorChemPadGroupBox();

  public slots:
  void toggled(bool);
};


} // namespace MassXpert
} // namespace MsXpS
