/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QTableView>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/Oligomer.hpp>
#include <MsXpS/libXpertMassCore/OligomerPair.hpp>
#include <MsXpS/libXpertMassCore/OligomerCollection.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes


namespace MsXpS
{
namespace MassXpert
{


class MzLabWnd;
class MzLabInputOligomerTableViewModel;
class MzLabInputOligomerTableViewDlg;


class MzLabInputOligomerTableView : public QTableView
{
  Q_OBJECT
  public:
  MzLabInputOligomerTableView(QWidget *parent = 0);
  ~MzLabInputOligomerTableView();

  void setSourceModel(MzLabInputOligomerTableViewModel *);
  MzLabInputOligomerTableViewModel *sourceModel();

  void setOligomerPairs(
    std::shared_ptr<const std::vector<libXpertMassCore::OligomerPairSPtr>>
      oligomer_pairs_csp);
  const std::shared_ptr<const std::vector<libXpertMassCore::OligomerPairSPtr>>
  getOligomerPairs() const;

  void setParentDlg(MzLabInputOligomerTableViewDlg *);
  MzLabInputOligomerTableViewDlg *parentDlg();

  void setMzLabWnd(MzLabWnd *);
  MzLabWnd *mzLabWnd();

  void mousePressEvent(QMouseEvent *);
  void pasteEvent();

  QString *selectedDataAsPlainText();

  libXpertMassCore::OligomerSPtr parseOnlyMassLine(QStringList &);
  libXpertMassCore::OligomerSPtr parseMassAndChargeLine(QStringList &);
  libXpertMassCore::OligomerSPtr parseFullLine(QStringList &);

  public slots:
  void itemActivated(const QModelIndex &);

  protected:
  MzLabInputOligomerTableViewDlg *mp_parentDlg;
  MzLabWnd *mp_mzLabWnd;

  MzLabInputOligomerTableViewModel *mp_sourceModel;

  std::shared_ptr<const std::vector<libXpertMassCore::OligomerPairSPtr>>
    mcsp_oligomerPairs;

  int testCleaveOligomerDataDropped(QDropEvent *,
                                    libXpertMassCore::OligomerCollection *);
  int testMassSearchOligomerDataDropped(QDropEvent *,
                                        libXpertMassCore::OligomerCollection *);
  int testSimpleTextDataDropped(QDropEvent *,
                                libXpertMassCore::OligomerCollection *);
  int testSimpleTextDataDroppedOrPasted(QString &,
                                        libXpertMassCore::OligomerCollection *);

  void dragEnterEvent(QDragEnterEvent *event);
  void dragMoveEvent(QDragMoveEvent *event);
  void dropEvent(QDropEvent *event);
  libXpertMassCore::Enums::MassType pasteOrDropMassTypeCheck();
};


} // namespace MassXpert
} // namespace MsXpS
