[Setup]
AppName=MassXpert3

; Set version number below
#define version "10.1.2-build-20251130-3fe94c25"
AppVersion={#version}

#define buildtype "Release"

#define arch "vcrt64"
#define platform "win10"
#define buildsystem "MXE"

#define homeDir "z:"

;;;;;; On Wine, z: drive is configured to point to /home/rusconi
;;;;;; Check the winecfg window's Drives tab

;;;;; Oddly enough the syntax below does not work
;;;;; #define sourceDir "{#homeDir}/devel/massxpert/development"
#define sourceDir homeDir + "/devel/massxpert/development"

#define buildDir homeDir + "/devel/massxpert/build-area/mxe"

;;;; This is no more used, because not portable between MXE and WIN10UCRT64
;;;; define docBuildDir "{#homeDir}/devel/massxpert/build-area/unix/doc/user-manual"

;;;;; When a documentation set (PDF, HTML) has been successfully built, that set
;;;;; is copied to this directory for winpackage target consumption.
#define localDocStore homeDir + "/devel/msxpertsuite-store/docs/massxpert"

#define dllSetForPackagesDir homeDir + "/devel/mxe/dll-set-for-packages"


; Set version number below
AppVerName=MassXpert3 version {#version}
DefaultDirName={commonpf}\MassXpert3
DefaultGroupName=MassXpert3
OutputDir="{#sourceDir}\winInstaller"

OutputBaseFilename=MassXpert3-{#platform}-{#buildsystem}-{#arch}-v{#version}-{#buildtype}-setup
OutputManifestFile=MassXpert3-{#platform}-{#buildsystem}-{#arch}-v{#version}-{#buildtype}-setup-manifest.txt

ArchitecturesAllowed=x64
ArchitecturesInstallIn64BitMode=x64

LicenseFile="{#sourceDir}/LICENSE"
AppCopyright="Copyright (C) 2009-2025 Filippo Rusconi"

SetupIconFile={#sourceDir}/images/icons/MassXpert3.ico

AllowNoIcons=yes
AlwaysShowComponentsList=yes
AllowRootDirectory=no
AllowCancelDuringInstall=yes
AppComments=MassXpert3, by Filippo Rusconi"
AppContact="Filippo Rusconi, PhD, Researcher at CNRS, France"
CloseApplications=yes
CreateUninstallRegKey=yes
DirExistsWarning=yes
WindowResizable=yes
WizardImageFile="{#sourceDir}\images\splashscreen-installer.png"
WizardImageStretch=yes

[Dirs]
Name: "{app}\data"
Name: "{app}\doc"

[Files]
Source: "{#dllSetForPackagesDir}/*"; DestDir: {app}; Flags: ignoreversion recursesubdirs;

Source: "{#sourceDir}/doc/history.html"; DestDir: {app}\doc;

Source: "{#buildDir}/src/MassXpert3.exe"; DestDir: {app};

Source: "{#sourceDir}/data/*"; DestDir: {app}\data; Flags: recursesubdirs;

;; The icon (multi-resolution icon file)
Source: {#sourceDir}/images/icons/MassXpert3.ico; DestDir: {app}

Source: "{#localDocStore}/MassXpert3-doc.pdf"; DestDir: {app}\doc;
Source: "{#localDocStore}/html/user-manual/*"; Flags: recursesubdirs; DestDir: {app}\doc\html;

Source: "{#sourceDir}\images\splashscreen-installer.bmp"; DestDir: "{tmp}"; Flags: dontcopy

[Icons]
Name: "{group}\MassXpert3"; Filename: "{app}\MassXpert3.exe"; WorkingDir: "{app}"
Name: "{group}\Uninstall MassXpert3"; Filename: "{uninstallexe}"

[Run]
Filename: "{app}\MassXpert3.exe"; Description: "Launch MassXpert3"; Flags: postinstall nowait unchecked
