C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_x_campbe.F 
C> The nwxcm_x_campbe functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_x_campbe functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_5} &=& 1.0-{{1.0}\over{{{0.01645530784602056\,{\it t_3}
C>    \,{\it t_4}\,\sigma_{\alpha\alpha}}
C>    \over{\rho_\alpha^{{{8}\over{3}}}}}+1.0}}\\\\ 
C>   {\it t_6} &=& -{\it param}\left(3\right)\\\\ 
C>   {\it t_7} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_8} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\alpha}}\\\\ 
C>   {\it t_{10}} &=& 0.9305257363491\,{\it t_2}\,{\it t_1}\,{\it t_5}
C>    +0.9305257363491\,{\it t_1}\\\\ 
C>   {\it t_{11}} &=& \sqrt{{\it t_{10}}}\\\\ 
C>   {\it t_{12}} &=& {\it t_8}^2\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha^2\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_{12}}}}\\\\ 
C>   {\it t_{15}} &=& e^ {- {{14.13716694115413\,{\it t_{13}}\,{
C>    \it t_{14}}}\over{{\it t_{10}}}} }\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_8}}}\\\\ 
C>   {\it t_{17}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{18}} &=& 1.0-{{1.0}\over{{{0.01645530784602056\,{
C>    \it t_3}\,{\it t_4}\,\sigma_{\beta\beta}}
C>    \over{\rho_\beta^{{{8}\over{3}}}}}+1.0}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{\rho_\beta}}\\\\ 
C>   {\it t_{20}} &=& 0.9305257363491\,{\it t_2}\,{\it t_{17}}\,{
C>    \it t_{18}}+0.9305257363491\,{\it t_{17}}\\\\ 
C>   {\it t_{21}} &=& \sqrt{{\it t_{20}}}\\\\ 
C>   {\it t_{22}} &=& \rho_\beta^2\\\\ 
C>   {\it t_{23}} &=& e^ {- {{14.13716694115413\,{\it t_{14}}\,{
C>    \it t_{22}}}\over{{\it t_{20}}}} }\\\\ 
C>   {\it t_{24}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{25}} &=& 1.0-{{1.0}\over{{{0.01645530784602056\,{
C>    \it t_3}\,{\it t_4}\,\sigma_{ss}}\over{\rho_s^{{{8}\over{3}}}}}
C>    +1.0}}\\\\ 
C>   {\it t_{26}} &=& {{1}\over{\rho_s}}\\\\ 
C>   {\it t_{27}} &=& 0.9305257363491\,{\it t_2}\,{\it t_{24}}\,{
C>    \it t_{25}}+0.9305257363491\,{\it t_{24}}\\\\ 
C>   {\it t_{28}} &=& \sqrt{{\it t_{27}}}\\\\ 
C>   {\it t_{29}} &=& \rho_s^2\\\\ 
C>   {\it t_{30}} &=& e^ {- {{14.13716694115413\,{\it t_{14}}\,{
C>    \it t_{29}}}\over{{\it t_{27}}}} }\\\\ 
C>   f &=& 1.0\,\left(-0.9305257363491\,{\it t_2}\,{\it t_{17}}\,{
C>    \it t_{18}}-0.9305257363491\,{\it t_{17}}\right)\,\left(
C>    -0.3546153603568283\,{\it t_7}\,{\it t_8}\,{\it t_{19}}\,{
C>    \it t_{21}}\,\left(1.77245385090552\,\mathrm{erf}
C>    \left({{3.759942411946509\,{\it t_{16}}\,\rho_\beta}\over{{
C>    \it t_{21}}}}\right)+0.2659615202676212\,{\it t_8}\,{
C>    \it t_{19}}\,{\it t_{21}}\,\left({\it t_{23}}
C>    -{{0.03536776513153214\,{\it t_{12}}\,{\it t_{20}}\,\left({
C>    \it t_{23}}-1.0\right)}\over{{\it t_{22}}}}-1.5\right)\right)
C>    +{\it t_6}+1.0\right)+1.0\,\left(-0.9305257363491\,{\it t_2}
C>    \,{\it t_1}\,{\it t_5}-0.9305257363491\,{\it t_1}\right)\,\left(
C>    -0.3546153603568283\,{\it t_7}\,{\it t_8}\,{\it t_9}\,{
C>    \it t_{11}}\,\left(1.77245385090552\,\mathrm{erf}
C>    \left({{3.759942411946509\,{\it t_{16}}\,\rho_\alpha}\over{{
C>    \it t_{11}}}}\right)+0.2659615202676212\,{\it t_8}\,{\it t_9}
C>    \,{\it t_{11}}\,\left({\it t_{15}}-{{0.03536776513153214\,{
C>    \it t_{12}}\,{\it t_{10}}\,\left({\it t_{15}}
C>    -1.0\right)}\over{{\it t_{13}}}}-1.5\right)\right)+{\it t_6}
C>    +1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(-0.9305257363491\,{\it t_2}\,{\it t_{24}}\,{
C>    \it t_{25}}-0.9305257363491\,{\it t_{24}}\right)\,\left(
C>    -0.3546153603568283\,{\it t_7}\,{\it t_8}\,{\it t_{26}}\,{
C>    \it t_{28}}\,\left(1.77245385090552\,\mathrm{erf}
C>    \left({{3.759942411946509\,{\it t_{16}}\,\rho_s}\over{{
C>    \it t_{28}}}}\right)+0.2659615202676212\,{\it t_8}\,{
C>    \it t_{26}}\,{\it t_{28}}\,\left({\it t_{30}}
C>    -{{0.03536776513153214\,{\it t_{12}}\,{\it t_{27}}\,\left({
C>    \it t_{30}}-1.0\right)}\over{{\it t_{29}}}}-1.5\right)\right)
C>    +{\it t_6}+1.0\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] OA Vydrov, GE Scuseria, JP Perdew, J.Chem.Phys. 126
C>    , 154109 (2007)  , DOI: 
C> <a href="https://doi.org/10.1063/1.2723119 "> 
C> 10.1063/1.2723119 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_campbe(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Cmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**1.3333333333333333d+0
            t2 = param(1)
            t3 = param(2)
            t4 = 1.6455307846020564d-2*gammaaa*t3/(rhoa**2.6666666666666
     1         666d+0*t2)+1.0d+0
            t5 = 1.0d+0-1.0d+0/t4
            t6 = -9.305257363491d-1*t1*t2*t5-9.305257363491d-1*t1
            t7 = param(4)
            t8 = param(5)
            t9 = 1/rhoa
            t10 = 9.305257363491d-1*t1*t2*t5+9.305257363491d-1*t1
            t11 = t10**5.0d-1
            t12 = t8**2
            t13 = rhoa**2
            t14 = 1/t13
            t15 = 1/t12
            t16 = 1/t10
            t17 = exp(-1.413716694115413d+1*t13*t15*t16)
            t18 = t17-1.0d+0
            t19 = -3.536776513153214d-2*t10*t12*t14*t18+t17-1.5d+0
            t20 = 1/t8
            t21 = 1/t11
            t22 = 2.659615202676212d-1*t11*t19*t8*t9+1.7724538509055202d
     1         +0*erf(3.759942411946509d+0*rhoa*t20*t21)
            t23 = -3.5461536035682834d-1*t11*t22*t7*t8*t9-param(3)+1.0d+
     1         0
            t24 = 5.641895835477563d-1
            t25 = 1/t4**2
            t26 = 1/rhoa**2.3333333333333334d+0
            t27 = rhoa**3.333333333333333d-1
            t28 = 1.2407009817987999d+0*t2*t27*t5-4.0832233200718415d-2*
     1         gammaaa*t25*t26*t3+1.2407009817987999d+0*t27
            t29 = 1/t11**3
            t30 = 1/t10**2
            t31 = 1.413716694115413d+1*t13*t15*t28*t30-2.827433388230826
     1         d+1*rhoa*t15*t16
            t32 = 1/t1
            fnc(iq) = 2.0d+0*t23*t6*wght+fnc(iq)
            Amat(iq,D1_RA) = (1.0d+0*t6*(-3.5461536035682834d-1*t11*t7*t
     1         8*t9*(2.659615202676212d-1*t11*(-3.536776513153214d-2*t10
     2         *t12*t14*t17*t31+t17*t31-3.536776513153214d-2*t12*t14*t18
     3         *t28+7.073553026306428d-2*t10*t12*t18/rhoa**3)*t8*t9+1.32
     4         9807601338106d-1*t19*t21*t28*t8*t9-2.659615202676212d-1*t
     5         11*t14*t19*t8+3.5449077018110403d+0*t17*t24*(3.7599424119
     6         46509d+0*t20*t21-1.8799712059732546d+0*rhoa*t20*t28*t29))
     7         -1.7730768017841417d-1*t21*t22*t28*t7*t8*t9+3.54615360356
     8         82834d-1*t11*t14*t22*t7*t8)+1.0d+0*t23*(-1.24070098179879
     9         99d+0*t2*t27*t5+4.0832233200718415d-2*gammaaa*t25*t26*t3-
     :         1.2407009817987999d+0*t27))*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = (1.0d+0*t6*(-3.5461536035682834d-1*t11*t7*
     1         t8*t9*(2.659615202676212d-1*t11*(-7.656043725134704d-3*t1
     2         6*t17*t25*t3*t32+2.1646953650200973d-1*rhoa**6.6666666666
     3         66666d-1*t15*t17*t25*t3*t30-5.415543126146093d-4*t12*t18*
     4         t25*t3/rhoa**3.3333333333333337d+0)*t8*t9+2.0362130283722
     5         08d-3*t19*t21*t25*t26*t3*t8-1.0204471812058666d-1*t17*t20
     6         *t24*t25*t29*t3/t27)-2.7149507044962773d-3*t21*t22*t25*t2
     7         6*t3*t7*t8)-1.531208745026941d-2*t23*t25*t3*t32)*wght+Cma
     8         t(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhoa**1.3333333333333333d+0
            t2 = param(1)
            t3 = 1/t2
            t4 = param(2)
            t5 = 1.6455307846020564d-2*gammaaa*t3*t4/rhoa**2.66666666666
     1         66666d+0+1.0d+0
            t6 = 1.0d+0-1.0d+0/t5
            t7 = -9.305257363491d-1*t1*t2*t6-9.305257363491d-1*t1
            t8 = -param(3)
            t9 = param(4)
            t10 = param(5)
            t11 = 1/rhoa
            t12 = 9.305257363491d-1*t1*t2*t6+9.305257363491d-1*t1
            t13 = t12**5.0d-1
            t14 = t10**2
            t15 = rhoa**2
            t16 = 1/t15
            t17 = 1/t14
            t18 = 1/t12
            t19 = exp(-1.413716694115413d+1*t15*t17*t18)
            t20 = t19-1.0d+0
            t21 = -3.536776513153214d-2*t12*t14*t16*t20+t19-1.5d+0
            t22 = 1/t10
            t23 = 1/t13
            t24 = 1.7724538509055202d+0*erf(3.759942411946509d+0*rhoa*t2
     1         2*t23)+2.659615202676212d-1*t10*t11*t13*t21
            t25 = -3.5461536035682834d-1*t10*t11*t13*t24*t9+t8+1.0d+0
            t26 = rhob**1.3333333333333333d+0
            t27 = 1.6455307846020564d-2*gammabb*t3*t4/rhob**2.6666666666
     1         666666d+0+1.0d+0
            t28 = 1.0d+0-1.0d+0/t27
            t29 = -9.305257363491d-1*t2*t26*t28-9.305257363491d-1*t26
            t30 = 1/rhob
            t31 = 9.305257363491d-1*t2*t26*t28+9.305257363491d-1*t26
            t32 = t31**5.0d-1
            t33 = rhob**2
            t34 = 1/t33
            t35 = 1/t31
            t36 = exp(-1.413716694115413d+1*t17*t33*t35)
            t37 = t36-1.0d+0
            t38 = -3.536776513153214d-2*t14*t31*t34*t37+t36-1.5d+0
            t39 = 1/t32
            t40 = 1.7724538509055202d+0*erf(3.759942411946509d+0*rhob*t2
     1         2*t39)+2.659615202676212d-1*t10*t30*t32*t38
            t41 = -3.5461536035682834d-1*t10*t30*t32*t40*t9+t8+1.0d+0
            t42 = 5.641895835477563d-1
            t43 = 1/t5**2
            t44 = 1/rhoa**2.3333333333333334d+0
            t45 = rhoa**3.333333333333333d-1
            t46 = 1.2407009817987999d+0*t2*t45*t6+1.2407009817987999d+0*
     1         t45-4.0832233200718415d-2*gammaaa*t4*t43*t44
            t47 = 1/t13**3
            t48 = 1/t12**2
            t49 = 1.413716694115413d+1*t15*t17*t46*t48-2.827433388230826
     1         d+1*rhoa*t17*t18
            t50 = 1/t27**2
            t51 = 1/rhob**2.3333333333333334d+0
            t52 = rhob**3.333333333333333d-1
            t53 = 1.2407009817987999d+0*t2*t28*t52+1.2407009817987999d+0
     1         *t52-4.0832233200718415d-2*gammabb*t4*t50*t51
            t54 = 1/t32**3
            t55 = 1/t31**2
            t56 = 1.413716694115413d+1*t17*t33*t53*t55-2.827433388230826
     1         d+1*rhob*t17*t35
            t57 = 1/t1
            t58 = 1/t26
            fnc(iq) = (1.0d+0*t25*t7+1.0d+0*t29*t41)*wght+fnc(iq)
            Amat(iq,D1_RA) = (1.0d+0*t7*(-3.5461536035682834d-1*t10*t11*
     1         t13*(2.659615202676212d-1*t10*t11*t13*(-3.536776513153214
     2         d-2*t12*t14*t16*t19*t49+t19*t49-3.536776513153214d-2*t14*
     3         t16*t20*t46+7.073553026306428d-2*t12*t14*t20/rhoa**3)+3.5
     4         449077018110403d+0*t19*t42*(3.759942411946509d+0*t22*t23-
     5         1.8799712059732546d+0*rhoa*t22*t46*t47)+1.329807601338106
     6         d-1*t10*t11*t21*t23*t46-2.659615202676212d-1*t10*t13*t16*
     7         t21)*t9-1.7730768017841417d-1*t10*t11*t23*t24*t46*t9+3.54
     8         61536035682834d-1*t10*t13*t16*t24*t9)+1.0d+0*t25*(-1.2407
     9         009817987999d+0*t2*t45*t6-1.2407009817987999d+0*t45+4.083
     :         2233200718415d-2*gammaaa*t4*t43*t44))*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = (1.0d+0*t29*(-3.5461536035682834d-1*t10*t30
     1         *t32*(2.659615202676212d-1*t10*t30*t32*(-3.53677651315321
     2         4d-2*t14*t31*t34*t36*t56+t36*t56-3.536776513153214d-2*t14
     3         *t34*t37*t53+7.073553026306428d-2*t14*t31*t37/rhob**3)+3.
     4         5449077018110403d+0*t36*t42*(3.759942411946509d+0*t22*t39
     5         -1.8799712059732546d+0*rhob*t22*t53*t54)+1.32980760133810
     6         6d-1*t10*t30*t38*t39*t53-2.659615202676212d-1*t10*t32*t34
     7         *t38)*t9-1.7730768017841417d-1*t10*t30*t39*t40*t53*t9+3.5
     8         461536035682834d-1*t10*t32*t34*t40*t9)+1.0d+0*t41*(-1.240
     9         7009817987999d+0*t2*t28*t52-1.2407009817987999d+0*t52+4.0
     :         832233200718415d-2*gammabb*t4*t50*t51))*wght+Amat(iq,D1_R
     ;         B)
            Cmat(iq,D1_GAA) = (1.0d+0*t7*(-3.5461536035682834d-1*t10*t11
     1         *t13*(2.659615202676212d-1*t10*t11*t13*(-7.65604372513470
     2         4d-3*t18*t19*t4*t43*t57+2.1646953650200973d-1*rhoa**6.666
     3         666666666666d-1*t17*t19*t4*t43*t48-5.415543126146093d-4*t
     4         14*t20*t4*t43/rhoa**3.3333333333333337d+0)-1.020447181205
     5         8666d-1*t19*t22*t4*t42*t43*t47/t45+2.036213028372208d-3*t
     6         10*t21*t23*t4*t43*t44)*t9-2.7149507044962773d-3*t10*t23*t
     7         24*t4*t43*t44*t9)-1.531208745026941d-2*t25*t4*t43*t57)*wg
     8         ht+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = (1.0d+0*t29*(-3.5461536035682834d-1*t10*t3
     1         0*t32*(2.659615202676212d-1*t10*t30*t32*(-7.6560437251347
     2         04d-3*t35*t36*t4*t50*t58+2.1646953650200973d-1*rhob**6.66
     3         6666666666666d-1*t17*t36*t4*t50*t55-5.415543126146093d-4*
     4         t14*t37*t4*t50/rhob**3.3333333333333337d+0)-1.02044718120
     5         58666d-1*t22*t36*t4*t42*t50*t54/t52+2.036213028372208d-3*
     6         t10*t38*t39*t4*t50*t51)*t9-2.7149507044962773d-3*t10*t39*
     7         t4*t40*t50*t51*t9)-1.531208745026941d-2*t4*t41*t50*t58)*w
     8         ght+Cmat(iq,D1_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**1.3333333333333333d+0
            t2 = param(1)
            t3 = param(2)
            t4 = 1.6455307846020564d-2*gammaaa*t3/(rhoa**2.6666666666666
     1         666d+0*t2)+1.0d+0
            t5 = 1.0d+0-1.0d+0/t4
            t6 = -9.305257363491d-1*t1*t2*t5-9.305257363491d-1*t1
            t7 = param(4)
            t8 = param(5)
            t9 = 1/rhoa
            t10 = 9.305257363491d-1*t1*t2*t5+9.305257363491d-1*t1
            t11 = t10**5.0d-1
            t12 = t8**2
            t13 = rhoa**2
            t14 = 1/t13
            t15 = 1/t12
            t16 = 1/t10
            t17 = exp(-1.413716694115413d+1*t13*t15*t16)
            t18 = t17-1.0d+0
            t19 = -3.536776513153214d-2*t10*t12*t14*t18+t17-1.5d+0
            t20 = 1/t8
            t21 = 1/t11
            t22 = 2.659615202676212d-1*t11*t19*t8*t9+1.7724538509055202d
     1         +0*erf(3.759942411946509d+0*rhoa*t20*t21)
            t23 = -3.5461536035682834d-1*t11*t22*t7*t8*t9-param(3)+1.0d+
     1         0
            t24 = 5.641895835477563d-1
            t25 = 1/t4**2
            t26 = 1/rhoa**2.3333333333333334d+0
            t27 = rhoa**3.333333333333333d-1
            t28 = 1.2407009817987999d+0*t2*t27*t5-4.0832233200718415d-2*
     1         gammaaa*t25*t26*t3+1.2407009817987999d+0*t27
            t29 = 1/t11**3
            t30 = 1/t10**2
            t31 = 1.413716694115413d+1*t13*t15*t28*t30-2.827433388230826
     1         d+1*rhoa*t15*t16
            t32 = 1/t1
            fnc(iq) = 1.0d+0*t23*t6*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t6*(-3.5461536035682834d-1*t11*t7*t8
     1         *t9*(2.659615202676212d-1*t11*(-3.536776513153214d-2*t10*
     2         t12*t14*t17*t31+t17*t31-3.536776513153214d-2*t12*t14*t18*
     3         t28+7.073553026306428d-2*t10*t12*t18/rhoa**3)*t8*t9+1.329
     4         807601338106d-1*t19*t21*t28*t8*t9-2.659615202676212d-1*t1
     5         1*t14*t19*t8+3.5449077018110403d+0*t17*t24*(3.75994241194
     6         6509d+0*t20*t21-1.8799712059732546d+0*rhoa*t20*t28*t29))-
     7         1.7730768017841417d-1*t21*t22*t28*t7*t8*t9+3.546153603568
     8         2834d-1*t11*t14*t22*t7*t8)*wght+1.0d+0*t23*(-1.2407009817
     9         987999d+0*t2*t27*t5+4.0832233200718415d-2*gammaaa*t25*t26
     :         *t3-1.2407009817987999d+0*t27)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*t6*(-3.5461536035682834d-1*t11*t7*t
     1         8*t9*(2.659615202676212d-1*t11*(-7.656043725134704d-3*t16
     2         *t17*t25*t3*t32+2.1646953650200973d-1*rhoa**6.66666666666
     3         6666d-1*t15*t17*t25*t3*t30-5.415543126146093d-4*t12*t18*t
     4         25*t3/rhoa**3.3333333333333337d+0)*t8*t9+2.03621302837220
     5         8d-3*t19*t21*t25*t26*t3*t8-1.0204471812058666d-1*t17*t20*
     6         t24*t25*t29*t3/t27)-2.7149507044962773d-3*t21*t22*t25*t26
     7         *t3*t7*t8)*wght-1.531208745026941d-2*t23*t25*t3*t32*wght+
     8         Cmat(iq,D1_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**1.3333333333333333d+0
            t2 = param(1)
            t3 = param(2)
            t4 = 1.6455307846020564d-2*gammabb*t3/(rhob**2.6666666666666
     1         666d+0*t2)+1.0d+0
            t5 = 1.0d+0-1.0d+0/t4
            t6 = -9.305257363491d-1*t1*t2*t5-9.305257363491d-1*t1
            t7 = param(4)
            t8 = param(5)
            t9 = 1/rhob
            t10 = 9.305257363491d-1*t1*t2*t5+9.305257363491d-1*t1
            t11 = t10**5.0d-1
            t12 = t8**2
            t13 = rhob**2
            t14 = 1/t13
            t15 = 1/t12
            t16 = 1/t10
            t17 = exp(-1.413716694115413d+1*t13*t15*t16)
            t18 = t17-1.0d+0
            t19 = -3.536776513153214d-2*t10*t12*t14*t18+t17-1.5d+0
            t20 = 1/t8
            t21 = 1/t11
            t22 = 2.659615202676212d-1*t11*t19*t8*t9+1.7724538509055202d
     1         +0*erf(3.759942411946509d+0*rhob*t20*t21)
            t23 = -3.5461536035682834d-1*t11*t22*t7*t8*t9-param(3)+1.0d+
     1         0
            t24 = 5.641895835477563d-1
            t25 = 1/t4**2
            t26 = 1/rhob**2.3333333333333334d+0
            t27 = rhob**3.333333333333333d-1
            t28 = 1.2407009817987999d+0*t2*t27*t5-4.0832233200718415d-2*
     1         gammabb*t25*t26*t3+1.2407009817987999d+0*t27
            t29 = 1/t11**3
            t30 = 1/t10**2
            t31 = 1.413716694115413d+1*t13*t15*t28*t30-2.827433388230826
     1         d+1*rhob*t15*t16
            t32 = 1/t1
            fnc(iq) = 1.0d+0*t23*t6*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*t6*(-3.5461536035682834d-1*t11*t7*t8
     1         *t9*(2.659615202676212d-1*t11*(-3.536776513153214d-2*t10*
     2         t12*t14*t17*t31+t17*t31-3.536776513153214d-2*t12*t14*t18*
     3         t28+7.073553026306428d-2*t10*t12*t18/rhob**3)*t8*t9+1.329
     4         807601338106d-1*t19*t21*t28*t8*t9-2.659615202676212d-1*t1
     5         1*t14*t19*t8+3.5449077018110403d+0*t17*t24*(3.75994241194
     6         6509d+0*t20*t21-1.8799712059732546d+0*rhob*t20*t28*t29))-
     7         1.7730768017841417d-1*t21*t22*t28*t7*t8*t9+3.546153603568
     8         2834d-1*t11*t14*t22*t7*t8)*wght+1.0d+0*t23*(-1.2407009817
     9         987999d+0*t2*t27*t5+4.0832233200718415d-2*gammabb*t25*t26
     :         *t3-1.2407009817987999d+0*t27)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*t6*(-3.5461536035682834d-1*t11*t7*t
     1         8*t9*(2.659615202676212d-1*t11*(-7.656043725134704d-3*t16
     2         *t17*t25*t3*t32+2.1646953650200973d-1*rhob**6.66666666666
     3         6666d-1*t15*t17*t25*t3*t30-5.415543126146093d-4*t12*t18*t
     4         25*t3/rhob**3.3333333333333337d+0)*t8*t9+2.03621302837220
     5         8d-3*t19*t21*t25*t26*t3*t8-1.0204471812058666d-1*t17*t20*
     6         t24*t25*t29*t3/t27)-2.7149507044962773d-3*t21*t22*t25*t26
     7         *t3*t7*t8)*wght-1.531208745026941d-2*t23*t25*t3*t32*wght+
     8         Cmat(iq,D1_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_x_campbe functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_5} &=& 1.0-{{1.0}\over{{{0.01645530784602056\,{\it t_3}
C>    \,{\it t_4}\,\sigma_{\alpha\alpha}}
C>    \over{\rho_\alpha^{{{8}\over{3}}}}}+1.0}}\\\\ 
C>   {\it t_6} &=& -{\it param}\left(3\right)\\\\ 
C>   {\it t_7} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_8} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\alpha}}\\\\ 
C>   {\it t_{10}} &=& 0.9305257363491\,{\it t_2}\,{\it t_1}\,{\it t_5}
C>    +0.9305257363491\,{\it t_1}\\\\ 
C>   {\it t_{11}} &=& \sqrt{{\it t_{10}}}\\\\ 
C>   {\it t_{12}} &=& {\it t_8}^2\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha^2\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_{12}}}}\\\\ 
C>   {\it t_{15}} &=& e^ {- {{14.13716694115413\,{\it t_{13}}\,{
C>    \it t_{14}}}\over{{\it t_{10}}}} }\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_8}}}\\\\ 
C>   {\it t_{17}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{18}} &=& 1.0-{{1.0}\over{{{0.01645530784602056\,{
C>    \it t_3}\,{\it t_4}\,\sigma_{\beta\beta}}
C>    \over{\rho_\beta^{{{8}\over{3}}}}}+1.0}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{\rho_\beta}}\\\\ 
C>   {\it t_{20}} &=& 0.9305257363491\,{\it t_2}\,{\it t_{17}}\,{
C>    \it t_{18}}+0.9305257363491\,{\it t_{17}}\\\\ 
C>   {\it t_{21}} &=& \sqrt{{\it t_{20}}}\\\\ 
C>   {\it t_{22}} &=& \rho_\beta^2\\\\ 
C>   {\it t_{23}} &=& e^ {- {{14.13716694115413\,{\it t_{14}}\,{
C>    \it t_{22}}}\over{{\it t_{20}}}} }\\\\ 
C>   {\it t_{24}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{25}} &=& 1.0-{{1.0}\over{{{0.01645530784602056\,{
C>    \it t_3}\,{\it t_4}\,\sigma_{ss}}\over{\rho_s^{{{8}\over{3}}}}}
C>    +1.0}}\\\\ 
C>   {\it t_{26}} &=& {{1}\over{\rho_s}}\\\\ 
C>   {\it t_{27}} &=& 0.9305257363491\,{\it t_2}\,{\it t_{24}}\,{
C>    \it t_{25}}+0.9305257363491\,{\it t_{24}}\\\\ 
C>   {\it t_{28}} &=& \sqrt{{\it t_{27}}}\\\\ 
C>   {\it t_{29}} &=& \rho_s^2\\\\ 
C>   {\it t_{30}} &=& e^ {- {{14.13716694115413\,{\it t_{14}}\,{
C>    \it t_{29}}}\over{{\it t_{27}}}} }\\\\ 
C>   f &=& 1.0\,\left(-0.9305257363491\,{\it t_2}\,{\it t_{17}}\,{
C>    \it t_{18}}-0.9305257363491\,{\it t_{17}}\right)\,\left(
C>    -0.3546153603568283\,{\it t_7}\,{\it t_8}\,{\it t_{19}}\,{
C>    \it t_{21}}\,\left(1.77245385090552\,\mathrm{erf}
C>    \left({{3.759942411946509\,{\it t_{16}}\,\rho_\beta}\over{{
C>    \it t_{21}}}}\right)+0.2659615202676212\,{\it t_8}\,{
C>    \it t_{19}}\,{\it t_{21}}\,\left({\it t_{23}}
C>    -{{0.03536776513153214\,{\it t_{12}}\,{\it t_{20}}\,\left({
C>    \it t_{23}}-1.0\right)}\over{{\it t_{22}}}}-1.5\right)\right)
C>    +{\it t_6}+1.0\right)+1.0\,\left(-0.9305257363491\,{\it t_2}
C>    \,{\it t_1}\,{\it t_5}-0.9305257363491\,{\it t_1}\right)\,\left(
C>    -0.3546153603568283\,{\it t_7}\,{\it t_8}\,{\it t_9}\,{
C>    \it t_{11}}\,\left(1.77245385090552\,\mathrm{erf}
C>    \left({{3.759942411946509\,{\it t_{16}}\,\rho_\alpha}\over{{
C>    \it t_{11}}}}\right)+0.2659615202676212\,{\it t_8}\,{\it t_9}
C>    \,{\it t_{11}}\,\left({\it t_{15}}-{{0.03536776513153214\,{
C>    \it t_{12}}\,{\it t_{10}}\,\left({\it t_{15}}
C>    -1.0\right)}\over{{\it t_{13}}}}-1.5\right)\right)+{\it t_6}
C>    +1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(-0.9305257363491\,{\it t_2}\,{\it t_{24}}\,{
C>    \it t_{25}}-0.9305257363491\,{\it t_{24}}\right)\,\left(
C>    -0.3546153603568283\,{\it t_7}\,{\it t_8}\,{\it t_{26}}\,{
C>    \it t_{28}}\,\left(1.77245385090552\,\mathrm{erf}
C>    \left({{3.759942411946509\,{\it t_{16}}\,\rho_s}\over{{
C>    \it t_{28}}}}\right)+0.2659615202676212\,{\it t_8}\,{
C>    \it t_{26}}\,{\it t_{28}}\,\left({\it t_{30}}
C>    -{{0.03536776513153214\,{\it t_{12}}\,{\it t_{27}}\,\left({
C>    \it t_{30}}-1.0\right)}\over{{\it t_{29}}}}-1.5\right)\right)
C>    +{\it t_6}+1.0\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] OA Vydrov, GE Scuseria, JP Perdew, J.Chem.Phys. 126
C>    , 154109 (2007)  , DOI: 
C> <a href="https://doi.org/10.1063/1.2723119 "> 
C> 10.1063/1.2723119 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_campbe_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Cmat,Cmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**1.3333333333333333d+0
            t2 = param(1)
            t3 = 1/t2
            t4 = param(2)
            t5 = 1/rhoa**2.6666666666666666d+0
            t6 = 1.6455307846020564d-2*gammaaa*t3*t4*t5+1.0d+0
            t7 = 1.0d+0-1.0d+0/t6
            t8 = -9.305257363491d-1*t1*t2*t7-9.305257363491d-1*t1
            t9 = param(4)
            t10 = param(5)
            t11 = 1/rhoa
            t12 = 9.305257363491d-1*t1*t2*t7+9.305257363491d-1*t1
            t13 = t12**5.0d-1
            t14 = t10**2
            t15 = rhoa**2
            t16 = 1/t15
            t17 = 1/t14
            t18 = 1/t12
            t19 = exp(-1.413716694115413d+1*t15*t17*t18)
            t20 = t19-1.0d+0
            t21 = -3.536776513153214d-2*t12*t14*t16*t20+t19-1.5d+0
            t22 = 1/t10
            t23 = 1/t13
            t24 = 1.7724538509055202d+0*erf(3.759942411946509d+0*rhoa*t2
     1         2*t23)+2.659615202676212d-1*t10*t11*t13*t21
            t25 = -3.5461536035682834d-1*t10*t11*t13*t24*t9-param(3)+1.0
     1         d+0
            t26 = 5.641895835477563d-1
            t27 = 1/t6**2
            t28 = 1/rhoa**2.3333333333333334d+0
            t29 = rhoa**3.333333333333333d-1
            t30 = 1.2407009817987999d+0*t2*t29*t7-4.0832233200718415d-2*
     1         gammaaa*t27*t28*t4+1.2407009817987999d+0*t29
            t31 = 1/t13**3
            t32 = 3.759942411946509d+0*t22*t23-1.8799712059732546d+0*rho
     1         a*t22*t30*t31
            t33 = 1/rhoa**3
            t34 = 1/t12**2
            t35 = 1.413716694115413d+1*t15*t17*t30*t34-2.827433388230826
     1         d+1*rhoa*t17*t18
            t36 = -3.536776513153214d-2*t12*t14*t16*t19*t35+t19*t35+7.07
     1         3553026306428d-2*t12*t14*t20*t33-3.536776513153214d-2*t14
     2         *t16*t20*t30
            t37 = 2.659615202676212d-1*t10*t11*t13*t36+3.544907701811040
     1         3d+0*t19*t26*t32+1.329807601338106d-1*t10*t11*t21*t23*t30
     2         -2.659615202676212d-1*t10*t13*t16*t21
            t38 = -3.5461536035682834d-1*t10*t11*t13*t37*t9-1.7730768017
     1         841417d-1*t10*t11*t23*t24*t30*t9+3.5461536035682834d-1*t1
     2         0*t13*t16*t24*t9
            t39 = -1.2407009817987999d+0*t2*t29*t7+4.0832233200718415d-2
     1         *gammaaa*t27*t28*t4-1.2407009817987999d+0*t29
            t40 = 1/t29
            t41 = 1/rhoa**3.3333333333333337d+0
            t42 = rhoa**6.666666666666666d-1
            t43 = 1/t1
            t44 = -7.656043725134704d-3*t18*t19*t27*t4*t43+2.16469536502
     1         00973d-1*t17*t19*t27*t34*t4*t42-5.415543126146093d-4*t14*
     2         t20*t27*t4*t41
            t45 = 2.659615202676212d-1*t10*t11*t13*t44-1.020447181205866
     1         6d-1*t19*t22*t26*t27*t31*t4*t40+2.036213028372208d-3*t10*
     2         t21*t23*t27*t28*t4
            t46 = -3.5461536035682834d-1*t10*t11*t13*t45*t9-2.7149507044
     1         962773d-3*t10*t23*t24*t27*t28*t4*t9
            t47 = t30**2
            t48 = 1/t13**5
            t49 = t4**2
            t50 = gammaaa**2
            t51 = 1/t6**3
            t52 = 1/rhoa**6
            t53 = 1/t42
            t54 = 4.135669939329333d-1*t2*t53*t7+4.135669939329333d-1*t5
     1         3-3.5835038259110563d-3*t3*t49*t50*t51*t52+4.083223320071
     2         8415d-2*gammaaa*t27*t4*t41
            t55 = 1/rhoa**4
            t56 = 1/t12**3
            t57 = -2.827433388230826d+1*t15*t17*t47*t56+1.41371669411541
     1         3d+1*t15*t17*t34*t54+5.654866776461652d+1*rhoa*t17*t30*t3
     2         4-2.827433388230826d+1*t17*t18
            t58 = t35**2
            t59 = 1/rhoa**5
            t60 = 1.3438139347166464d-3*gammaaa*t3*t49*t51*t59-2.0416116
     1         600359205d-2*t27*t28*t4
            t61 = 1.413716694115413d+1*t15*t17*t34*t60-4.329390730040194
     1         6d-1*t17*t27*t30*t4*t42*t56+4.3293907300401946d-1*t17*t27
     2         *t34*t4*t40
            t62 = 1/t6**4
            t63 = 1/rhoa**3.6666666666666664d+0
            fnc(iq) = 2.0d+0*t25*t8*wght+fnc(iq)
            Amat(iq,D1_RA) = (1.0d+0*t38*t8+1.0d+0*t25*t39)*wght+Amat(iq
     1         ,D1_RA)
            Cmat(iq,D1_GAA) = (1.0d+0*t46*t8-1.531208745026941d-2*t25*t2
     1         7*t4*t43)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = (1.0d+0*t8*(-3.5461536035682834d-1*t10*
     1         t11*t13*(2.659615202676212d-1*t10*t11*t13*(-3.53677651315
     2         3214d-2*t12*t14*t16*t19*t58+t19*t58-3.536776513153214d-2*
     3         t12*t14*t16*t19*t57+t19*t57-2.1220659078919285d-1*t12*t14
     4         *t20*t55-3.536776513153214d-2*t14*t16*t20*t54+1.414710605
     5         2612857d-1*t12*t14*t19*t33*t35-7.073553026306428d-2*t14*t
     6         16*t19*t30*t35+1.4147106052612857d-1*t14*t20*t30*t33)+3.5
     7         449077018110403d+0*t19*t26*(-1.8799712059732546d+0*rhoa*t
     8         22*t31*t54+2.8199568089598814d+0*rhoa*t22*t47*t48-3.75994
     9         2411946509d+0*t22*t30*t31)+1.329807601338106d-1*t10*t11*t
     :         21*t23*t54-6.649038006690531d-2*t10*t11*t21*t31*t47+2.659
     ;         615202676212d-1*t10*t11*t23*t30*t36-5.319230405352424d-1*
     <         t10*t13*t16*t36+3.5449077018110403d+0*t19*t26*t32*t35+5.3
     =         19230405352424d-1*t10*t13*t21*t33-2.659615202676212d-1*t1
     >         0*t16*t21*t23*t30)*t9-1.7730768017841417d-1*t10*t11*t23*t
     ?         24*t54*t9+8.865384008920708d-2*t10*t11*t24*t31*t47*t9-3.5
     @         461536035682834d-1*t10*t11*t23*t30*t37*t9+7.0923072071365
     1         67d-1*t10*t13*t16*t37*t9-7.092307207136567d-1*t10*t13*t24
     2         *t33*t9+3.5461536035682834d-1*t10*t16*t23*t24*t30*t9)+1.0
     3         d+0*t25*(-4.135669939329333d-1*t2*t53*t7-4.13566993932933
     4         3d-1*t53+3.5835038259110563d-3*t3*t49*t50*t51*t52-4.08322
     5         33200718415d-2*gammaaa*t27*t4*t41)+2.0d+0*t38*t39)*wght+A
     6         mat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = (1.0d+0*t8*(-3.5461536035682834d-1*t10
     1         *t11*t13*(2.659615202676212d-1*t10*t11*t13*(-3.5367765131
     2         53214d-2*t12*t14*t16*t19*t61+t19*t61-3.536776513153214d-2
     3         *t14*t16*t20*t60-7.656043725134704d-3*t18*t19*t27*t35*t4*
     4         t43-7.656043725134704d-3*t19*t27*t30*t34*t4*t43+2.1646953
     5         650200973d-1*t17*t19*t27*t34*t35*t4*t42-5.415543126146093
     6         d-4*t14*t19*t27*t35*t4*t41+1.5312087450269407d-2*t18*t19*
     7         t27*t28*t4+1.0831086252292187d-3*t14*t20*t27*t4/rhoa**4.3
     8         33333333333333d+0)+3.5449077018110403d+0*t19*t26*(-1.8799
     9         712059732546d+0*rhoa*t22*t31*t60+4.317942526477637d-2*t22
     :         *t27*t30*t4*t40*t48-2.878628350985092d-2*t22*t27*t31*t4*t
     ;         43)+1.329807601338106d-1*t10*t11*t21*t23*t60+1.3298076013
     <         38106d-1*t10*t11*t23*t30*t44-2.659615202676212d-1*t10*t13
     =         *t16*t44+7.673645271534404d-1*t17*t19*t26*t27*t32*t34*t4*
     >         t42-2.036213028372208d-3*t10*t21*t23*t27*t4*t41+2.0362130
     ?         28372208d-3*t10*t23*t27*t28*t36*t4-1.018106514186104d-3*t
     @         10*t21*t27*t28*t30*t31*t4)*t9-1.7730768017841417d-1*t10*t
     1         11*t23*t24*t60*t9-1.7730768017841417d-1*t10*t11*t23*t30*t
     2         45*t9+3.5461536035682834d-1*t10*t13*t16*t45*t9+2.71495070
     3         44962773d-3*t10*t23*t24*t27*t4*t41*t9-2.7149507044962773d
     4         -3*t10*t23*t27*t28*t37*t4*t9+1.3574753522481386d-3*t10*t2
     5         4*t27*t28*t30*t31*t4*t9)+1.0d+0*t25*(2.0416116600359205d-
     6         2*t27*t28*t4-1.3438139347166464d-3*gammaaa*t3*t49*t51*t59
     7         )+1.0d+0*t39*t46-1.531208745026941d-2*t27*t38*t4*t43)*wgh
     8         t+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = (1.0d+0*t8*(-3.5461536035682834d-1*t1
     1         0*t11*t13*(-1.5589335978906577d-5*t10*t21*t31*t49*t62*t63
     2         +2.659615202676212d-1*t10*t11*t13*(-8.286501183095146d-3*
     3         t17*t19*t49*t53*t56*t62-1.3552527156068805d-20*t19*t34*t4
     4         9*t5*t62+4.685906023339492d-2*t1*t19*t49*t62/(t10**4*t12*
     5         *4)+2.519651127593712d-4*t18*t19*t3*t49*t51*t55+1.7822885
     6         85882691d-5*t14*t20*t3*t49*t51*t52-7.124145724851911d-3*t
     7         16*t17*t19*t3*t34*t49*t51)+2.3437764715507717d-3*t19*t22*
     8         t26*t48*t49*t62/rhoa**1.6666666666666669d+0-2.20895728340
     9         41626d-2*t19*t26*t29*t49*t62/(t10**3*t13**7)-6.7013024443
     :         88497d-5*t10*t21*t23*t3*t49*t51*t59+3.3583545014692934d-3
     ;         *t19*t22*t26*t3*t31*t33*t49*t51+4.072426056744416d-3*t10*
     <         t23*t27*t28*t4*t44)*t9+2.078578130520877d-5*t10*t24*t31*t
     =         49*t62*t63*t9+8.935069925851332d-5*t10*t23*t24*t3*t49*t51
     >         *t59*t9-5.429901408992555d-3*t10*t23*t27*t28*t4*t45*t9)+5
     ?         .039302255187424d-4*t25*t3*t49*t51*t55-3.062417490053882d
     @         -2*t27*t4*t43*t46)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhoa**1.3333333333333333d+0
            t2 = param(1)
            t3 = 1/t2
            t4 = param(2)
            t5 = 1/rhoa**2.6666666666666666d+0
            t6 = 1.6455307846020564d-2*gammaaa*t3*t4*t5+1.0d+0
            t7 = 1.0d+0-1.0d+0/t6
            t8 = -9.305257363491d-1*t1*t2*t7-9.305257363491d-1*t1
            t9 = -param(3)
            t10 = param(4)
            t11 = param(5)
            t12 = 1/rhoa
            t13 = 9.305257363491d-1*t1*t2*t7+9.305257363491d-1*t1
            t14 = t13**5.0d-1
            t15 = t11**2
            t16 = rhoa**2
            t17 = 1/t16
            t18 = 1/t15
            t19 = 1/t13
            t20 = exp(-1.413716694115413d+1*t16*t18*t19)
            t21 = t20-1.0d+0
            t22 = -3.536776513153214d-2*t13*t15*t17*t21+t20-1.5d+0
            t23 = 1/t11
            t24 = 1/t14
            t25 = 1.7724538509055202d+0*erf(3.759942411946509d+0*rhoa*t2
     1         3*t24)+2.659615202676212d-1*t11*t12*t14*t22
            t26 = t9-3.5461536035682834d-1*t10*t11*t12*t14*t25+1.0d+0
            t27 = rhob**1.3333333333333333d+0
            t28 = 1/rhob**2.6666666666666666d+0
            t29 = 1.6455307846020564d-2*gammabb*t28*t3*t4+1.0d+0
            t30 = 1.0d+0-1.0d+0/t29
            t31 = -9.305257363491d-1*t2*t27*t30-9.305257363491d-1*t27
            t32 = 1/rhob
            t33 = 9.305257363491d-1*t2*t27*t30+9.305257363491d-1*t27
            t34 = t33**5.0d-1
            t35 = rhob**2
            t36 = 1/t35
            t37 = 1/t33
            t38 = exp(-1.413716694115413d+1*t18*t35*t37)
            t39 = t38-1.0d+0
            t40 = -3.536776513153214d-2*t15*t33*t36*t39+t38-1.5d+0
            t41 = 1/t34
            t42 = 1.7724538509055202d+0*erf(3.759942411946509d+0*rhob*t2
     1         3*t41)+2.659615202676212d-1*t11*t32*t34*t40
            t43 = t9-3.5461536035682834d-1*t10*t11*t32*t34*t42+1.0d+0
            t44 = 5.641895835477563d-1
            t45 = 1/t6**2
            t46 = 1/rhoa**2.3333333333333334d+0
            t47 = rhoa**3.333333333333333d-1
            t48 = 1.2407009817987999d+0*t2*t47*t7+1.2407009817987999d+0*
     1         t47-4.0832233200718415d-2*gammaaa*t4*t45*t46
            t49 = 1/t14**3
            t50 = 3.759942411946509d+0*t23*t24-1.8799712059732546d+0*rho
     1         a*t23*t48*t49
            t51 = 1/rhoa**3
            t52 = 1/t13**2
            t53 = 1.413716694115413d+1*t16*t18*t48*t52-2.827433388230826
     1         d+1*rhoa*t18*t19
            t54 = -3.536776513153214d-2*t13*t15*t17*t20*t53+t20*t53+7.07
     1         3553026306428d-2*t13*t15*t21*t51-3.536776513153214d-2*t15
     2         *t17*t21*t48
            t55 = 2.659615202676212d-1*t11*t12*t14*t54+3.544907701811040
     1         3d+0*t20*t44*t50+1.329807601338106d-1*t11*t12*t22*t24*t48
     2         -2.659615202676212d-1*t11*t14*t17*t22
            t56 = -3.5461536035682834d-1*t10*t11*t12*t14*t55-1.773076801
     1         7841417d-1*t10*t11*t12*t24*t25*t48+3.5461536035682834d-1*
     2         t10*t11*t14*t17*t25
            t57 = -1.2407009817987999d+0*t2*t47*t7-1.2407009817987999d+0
     1         *t47+4.0832233200718415d-2*gammaaa*t4*t45*t46
            t58 = 1/t29**2
            t59 = 1/rhob**2.3333333333333334d+0
            t60 = rhob**3.333333333333333d-1
            t61 = 1.2407009817987999d+0*t2*t30*t60+1.2407009817987999d+0
     1         *t60-4.0832233200718415d-2*gammabb*t4*t58*t59
            t62 = 1/t34**3
            t63 = 3.759942411946509d+0*t23*t41-1.8799712059732546d+0*rho
     1         b*t23*t61*t62
            t64 = 1/rhob**3
            t65 = 1/t33**2
            t66 = 1.413716694115413d+1*t18*t35*t61*t65-2.827433388230826
     1         d+1*rhob*t18*t37
            t67 = -3.536776513153214d-2*t15*t33*t36*t38*t66+t38*t66+7.07
     1         3553026306428d-2*t15*t33*t39*t64-3.536776513153214d-2*t15
     2         *t36*t39*t61
            t68 = 2.659615202676212d-1*t11*t32*t34*t67+3.544907701811040
     1         3d+0*t38*t44*t63+1.329807601338106d-1*t11*t32*t40*t41*t61
     2         -2.659615202676212d-1*t11*t34*t36*t40
            t69 = -3.5461536035682834d-1*t10*t11*t32*t34*t68-1.773076801
     1         7841417d-1*t10*t11*t32*t41*t42*t61+3.5461536035682834d-1*
     2         t10*t11*t34*t36*t42
            t70 = -1.2407009817987999d+0*t2*t30*t60-1.2407009817987999d+
     1         0*t60+4.0832233200718415d-2*gammabb*t4*t58*t59
            t71 = 1/t47
            t72 = 1/rhoa**3.3333333333333337d+0
            t73 = rhoa**6.666666666666666d-1
            t74 = 1/t1
            t75 = -7.656043725134704d-3*t19*t20*t4*t45*t74+2.16469536502
     1         00973d-1*t18*t20*t4*t45*t52*t73-5.415543126146093d-4*t15*
     2         t21*t4*t45*t72
            t76 = 2.659615202676212d-1*t11*t12*t14*t75-1.020447181205866
     1         6d-1*t20*t23*t4*t44*t45*t49*t71+2.036213028372208d-3*t11*
     2         t22*t24*t4*t45*t46
            t77 = -3.5461536035682834d-1*t10*t11*t12*t14*t76-2.714950704
     1         4962773d-3*t10*t11*t24*t25*t4*t45*t46
            t78 = 1/t60
            t79 = 1/rhob**3.3333333333333337d+0
            t80 = rhob**6.666666666666666d-1
            t81 = 1/t27
            t82 = -7.656043725134704d-3*t37*t38*t4*t58*t81+2.16469536502
     1         00973d-1*t18*t38*t4*t58*t65*t80-5.415543126146093d-4*t15*
     2         t39*t4*t58*t79
            t83 = 2.659615202676212d-1*t11*t32*t34*t82-1.020447181205866
     1         6d-1*t23*t38*t4*t44*t58*t62*t78+2.036213028372208d-3*t11*
     2         t4*t40*t41*t58*t59
            t84 = -3.5461536035682834d-1*t10*t11*t32*t34*t83-2.714950704
     1         4962773d-3*t10*t11*t4*t41*t42*t58*t59
            t85 = t48**2
            t86 = 1/t14**5
            t87 = t4**2
            t88 = gammaaa**2
            t89 = 1/t6**3
            t90 = 1/rhoa**6
            t91 = 1/t73
            t92 = 4.135669939329333d-1*t2*t7*t91+4.135669939329333d-1*t9
     1         1-3.5835038259110563d-3*t3*t87*t88*t89*t90+4.083223320071
     2         8415d-2*gammaaa*t4*t45*t72
            t93 = 1/rhoa**4
            t94 = 1/t13**3
            t95 = -2.827433388230826d+1*t16*t18*t85*t94+1.41371669411541
     1         3d+1*t16*t18*t52*t92+5.654866776461652d+1*rhoa*t18*t48*t5
     2         2-2.827433388230826d+1*t18*t19
            t96 = t53**2
            t97 = t61**2
            t98 = 1/t34**5
            t99 = gammabb**2
            t100 = 1/t29**3
            t101 = 1/rhob**6
            t102 = 1/t80
            t103 = -3.5835038259110563d-3*t100*t101*t3*t87*t99+4.0832233
     1         200718415d-2*gammabb*t4*t58*t79+4.135669939329333d-1*t102
     2         *t2*t30+4.135669939329333d-1*t102
            t104 = 1/rhob**4
            t105 = 1/t33**3
            t106 = -2.827433388230826d+1*t105*t18*t35*t97+5.654866776461
     1         652d+1*rhob*t18*t61*t65+1.413716694115413d+1*t103*t18*t35
     2         *t65-2.827433388230826d+1*t18*t37
            t107 = t66**2
            t108 = 1/rhoa**5
            t109 = 1.3438139347166464d-3*gammaaa*t108*t3*t87*t89-2.04161
     1         16600359205d-2*t4*t45*t46
            t110 = -4.3293907300401946d-1*t18*t4*t45*t48*t73*t94+4.32939
     1         07300401946d-1*t18*t4*t45*t52*t71+1.413716694115413d+1*t1
     2         09*t16*t18*t52
            t111 = 1/rhob**5
            t112 = 1.3438139347166464d-3*gammabb*t100*t111*t3*t87-2.0416
     1         116600359205d-2*t4*t58*t59
            t113 = -4.3293907300401946d-1*t105*t18*t4*t58*t61*t80+4.3293
     1         907300401946d-1*t18*t4*t58*t65*t78+1.413716694115413d+1*t
     2         112*t18*t35*t65
            t114 = 1/t11**3
            t115 = 1/t6**4
            t116 = 1/rhoa**3.6666666666666664d+0
            t117 = 1/t11**4
            t118 = 1/t29**4
            t119 = 1/rhob**3.6666666666666664d+0
            fnc(iq) = (1.0d+0*t26*t8+1.0d+0*t31*t43)*wght+fnc(iq)
            Amat(iq,D1_RA) = (1.0d+0*t56*t8+1.0d+0*t26*t57)*wght+Amat(iq
     1         ,D1_RA)
            Amat(iq,D1_RB) = (1.0d+0*t43*t70+1.0d+0*t31*t69)*wght+Amat(i
     1         q,D1_RB)
            Cmat(iq,D1_GAA) = (1.0d+0*t77*t8-1.531208745026941d-2*t26*t4
     1         *t45*t74)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = (1.0d+0*t31*t84-1.531208745026941d-2*t4*t4
     1         3*t58*t81)*wght+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = (1.0d+0*t8*(-3.5461536035682834d-1*t10*
     1         t11*t12*t14*(2.659615202676212d-1*t11*t12*t14*(-3.5367765
     2         13153214d-2*t13*t15*t17*t20*t96+t20*t96-3.536776513153214
     3         d-2*t13*t15*t17*t20*t95+t20*t95-2.1220659078919285d-1*t13
     4         *t15*t21*t93-3.536776513153214d-2*t15*t17*t21*t92+1.41471
     5         06052612857d-1*t13*t15*t20*t51*t53-7.073553026306428d-2*t
     6         15*t17*t20*t48*t53+1.4147106052612857d-1*t15*t21*t48*t51)
     7         +3.5449077018110403d+0*t20*t44*(-1.8799712059732546d+0*rh
     8         oa*t23*t49*t92+2.8199568089598814d+0*rhoa*t23*t85*t86-3.7
     9         59942411946509d+0*t23*t48*t49)+1.329807601338106d-1*t11*t
     :         12*t22*t24*t92-6.649038006690531d-2*t11*t12*t22*t49*t85+2
     ;         .659615202676212d-1*t11*t12*t24*t48*t54-5.319230405352424
     <         d-1*t11*t14*t17*t54+3.5449077018110403d+0*t20*t44*t50*t53
     =         +5.319230405352424d-1*t11*t14*t22*t51-2.659615202676212d-
     >         1*t11*t17*t22*t24*t48)-1.7730768017841417d-1*t10*t11*t12*
     ?         t24*t25*t92+8.865384008920708d-2*t10*t11*t12*t25*t49*t85-
     @         3.5461536035682834d-1*t10*t11*t12*t24*t48*t55+7.092307207
     1         136567d-1*t10*t11*t14*t17*t55-7.092307207136567d-1*t10*t1
     2         1*t14*t25*t51+3.5461536035682834d-1*t10*t11*t17*t24*t25*t
     3         48)+1.0d+0*t26*(-4.135669939329333d-1*t2*t7*t91-4.1356699
     4         39329333d-1*t91+3.5835038259110563d-3*t3*t87*t88*t89*t90-
     5         4.0832233200718415d-2*gammaaa*t4*t45*t72)+2.0d+0*t56*t57)
     6         *wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = (1.0d+0*t43*(3.5835038259110563d-3*t100
     1         *t101*t3*t87*t99-4.0832233200718415d-2*gammabb*t4*t58*t79
     2         -4.135669939329333d-1*t102*t2*t30-4.135669939329333d-1*t1
     3         02)+1.0d+0*t31*(-3.5461536035682834d-1*t10*t11*t32*t34*(3
     4         .5449077018110403d+0*t38*t44*(2.8199568089598814d+0*rhob*
     5         t23*t97*t98-3.759942411946509d+0*t23*t61*t62-1.8799712059
     6         732546d+0*rhob*t103*t23*t62)-6.649038006690531d-2*t11*t32
     7         *t40*t62*t97+2.659615202676212d-1*t11*t32*t41*t61*t67-5.3
     8         19230405352424d-1*t11*t34*t36*t67+2.659615202676212d-1*t1
     9         1*t32*t34*(1.4147106052612857d-1*t15*t33*t38*t64*t66-7.07
     :         3553026306428d-2*t15*t36*t38*t61*t66+1.4147106052612857d-
     ;         1*t15*t39*t61*t64-3.536776513153214d-2*t103*t15*t36*t39-2
     <         .1220659078919285d-1*t104*t15*t33*t39-3.536776513153214d-
     =         2*t107*t15*t33*t36*t38-3.536776513153214d-2*t106*t15*t33*
     >         t36*t38+t107*t38+t106*t38)+3.5449077018110403d+0*t38*t44*
     ?         t63*t66+5.319230405352424d-1*t11*t34*t40*t64-2.6596152026
     @         76212d-1*t11*t36*t40*t41*t61+1.329807601338106d-1*t103*t1
     1         1*t32*t40*t41)+8.865384008920708d-2*t10*t11*t32*t42*t62*t
     2         97-3.5461536035682834d-1*t10*t11*t32*t41*t61*t68+7.092307
     3         207136567d-1*t10*t11*t34*t36*t68-7.092307207136567d-1*t10
     4         *t11*t34*t42*t64+3.5461536035682834d-1*t10*t11*t36*t41*t4
     5         2*t61-1.7730768017841417d-1*t10*t103*t11*t32*t41*t42)+2.0
     6         d+0*t69*t70)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = (1.0d+0*t26*(2.0416116600359205d-2*t4*
     1         t45*t46-1.3438139347166464d-3*gammaaa*t108*t3*t87*t89)+1.
     2         0d+0*t8*(-3.5461536035682834d-1*t10*t11*t12*t14*(3.544907
     3         7018110403d+0*t20*t44*(4.317942526477637d-2*t23*t4*t45*t4
     4         8*t71*t86-2.878628350985092d-2*t23*t4*t45*t49*t74-1.87997
     5         12059732546d+0*rhoa*t109*t23*t49)+1.329807601338106d-1*t1
     6         1*t12*t24*t48*t75-2.659615202676212d-1*t11*t14*t17*t75+2.
     7         659615202676212d-1*t11*t12*t14*(-7.656043725134704d-3*t19
     8         *t20*t4*t45*t53*t74-7.656043725134704d-3*t20*t4*t45*t48*t
     9         52*t74+2.1646953650200973d-1*t18*t20*t4*t45*t52*t53*t73-5
     :         .415543126146093d-4*t15*t20*t4*t45*t53*t72+1.531208745026
     ;         9407d-2*t19*t20*t4*t45*t46+1.0831086252292187d-3*t15*t21*
     <         t4*t45/rhoa**4.333333333333333d+0-3.536776513153214d-2*t1
     =         09*t15*t17*t21-3.536776513153214d-2*t110*t13*t15*t17*t20+
     >         t110*t20)+7.673645271534404d-1*t18*t20*t4*t44*t45*t50*t52
     ?         *t73-2.036213028372208d-3*t11*t22*t24*t4*t45*t72+2.036213
     @         028372208d-3*t11*t24*t4*t45*t46*t54-1.018106514186104d-3*
     1         t11*t22*t4*t45*t46*t48*t49+1.329807601338106d-1*t109*t11*
     2         t12*t22*t24)-1.7730768017841417d-1*t10*t11*t12*t24*t48*t7
     3         6+3.5461536035682834d-1*t10*t11*t14*t17*t76+2.71495070449
     4         62773d-3*t10*t11*t24*t25*t4*t45*t72-2.7149507044962773d-3
     5         *t10*t11*t24*t4*t45*t46*t55+1.3574753522481386d-3*t10*t11
     6         *t25*t4*t45*t46*t48*t49-1.7730768017841417d-1*t10*t109*t1
     7         1*t12*t24*t25)+1.0d+0*t57*t77-1.531208745026941d-2*t4*t45
     8         *t56*t74)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = (1.0d+0*t31*(-3.5461536035682834d-1*t1
     1         0*t11*t32*t34*(3.5449077018110403d+0*t38*t44*(4.317942526
     2         477637d-2*t23*t4*t58*t61*t78*t98-2.878628350985092d-2*t23
     3         *t4*t58*t62*t81-1.8799712059732546d+0*rhob*t112*t23*t62)+
     4         1.329807601338106d-1*t11*t32*t41*t61*t82-2.65961520267621
     5         2d-1*t11*t34*t36*t82+2.659615202676212d-1*t11*t32*t34*(-7
     6         .656043725134704d-3*t37*t38*t4*t58*t66*t81-7.656043725134
     7         704d-3*t38*t4*t58*t61*t65*t81+2.1646953650200973d-1*t18*t
     8         38*t4*t58*t65*t66*t80-5.415543126146093d-4*t15*t38*t4*t58
     9         *t66*t79+1.5312087450269407d-2*t37*t38*t4*t58*t59+1.08310
     :         86252292187d-3*t15*t39*t4*t58/rhob**4.333333333333333d+0-
     ;         3.536776513153214d-2*t112*t15*t36*t39-3.536776513153214d-
     <         2*t113*t15*t33*t36*t38+t113*t38)+7.673645271534404d-1*t18
     =         *t38*t4*t44*t58*t63*t65*t80-2.036213028372208d-3*t11*t4*t
     >         40*t41*t58*t79+2.036213028372208d-3*t11*t4*t41*t58*t59*t6
     ?         7-1.018106514186104d-3*t11*t4*t40*t58*t59*t61*t62+1.32980
     @         7601338106d-1*t11*t112*t32*t40*t41)-1.7730768017841417d-1
     1         *t10*t11*t32*t41*t61*t83+3.5461536035682834d-1*t10*t11*t3
     2         4*t36*t83+2.7149507044962773d-3*t10*t11*t4*t41*t42*t58*t7
     3         9-2.7149507044962773d-3*t10*t11*t4*t41*t58*t59*t68+1.3574
     4         753522481386d-3*t10*t11*t4*t42*t58*t59*t61*t62-1.77307680
     5         17841417d-1*t10*t11*t112*t32*t41*t42)+1.0d+0*t43*(2.04161
     6         16600359205d-2*t4*t58*t59-1.3438139347166464d-3*gammabb*t
     7         100*t111*t3*t87)+1.0d+0*t70*t84-1.531208745026941d-2*t4*t
     8         58*t69*t81)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = (1.0d+0*t8*(-3.5461536035682834d-1*t1
     1         0*t11*t12*t14*(2.659615202676212d-1*t11*t12*t14*(-8.28650
     2         1183095146d-3*t115*t18*t20*t87*t91*t94+2.519651127593712d
     3         -4*t19*t20*t3*t87*t89*t93+1.782288585882691d-5*t15*t21*t3
     4         *t87*t89*t90-7.124145724851911d-3*t17*t18*t20*t3*t52*t87*
     5         t89-1.3552527156068805d-20*t115*t20*t5*t52*t87+4.68590602
     6         3339492d-2*t1*t115*t117*t20*t87/t13**4)+3.358354501469293
     7         4d-3*t20*t23*t3*t44*t49*t51*t87*t89-6.701302444388497d-5*
     8         t108*t11*t22*t24*t3*t87*t89+2.3437764715507717d-3*t115*t2
     9         0*t23*t44*t86*t87/rhoa**1.6666666666666669d+0-1.558933597
     :         8906577d-5*t11*t115*t116*t22*t49*t87-2.2089572834041626d-
     ;         2*t114*t115*t20*t44*t47*t87/t14**7+4.072426056744416d-3*t
     <         11*t24*t4*t45*t46*t75)+8.935069925851332d-5*t10*t108*t11*
     =         t24*t25*t3*t87*t89+2.078578130520877d-5*t10*t11*t115*t116
     >         *t25*t49*t87-5.429901408992555d-3*t10*t11*t24*t4*t45*t46*
     ?         t76)+5.039302255187424d-4*t26*t3*t87*t89*t93-3.0624174900
     @         53882d-2*t4*t45*t74*t77)*wght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = (1.0d+0*t31*(-3.5461536035682834d-1*t
     1         10*t11*t32*t34*(2.3437764715507717d-3*t118*t23*t38*t44*t8
     2         7*t98/rhob**1.6666666666666669d+0+2.659615202676212d-1*t1
     3         1*t32*t34*(-7.124145724851911d-3*t100*t18*t3*t36*t38*t65*
     4         t87-1.3552527156068805d-20*t118*t28*t38*t65*t87+1.7822885
     5         85882691d-5*t100*t101*t15*t3*t39*t87+2.519651127593712d-4
     6         *t100*t104*t3*t37*t38*t87+4.685906023339492d-2*t117*t118*
     7         t27*t38*t87/t33**4-8.286501183095146d-3*t102*t105*t118*t1
     8         8*t38*t87)+3.3583545014692934d-3*t100*t23*t3*t38*t44*t62*
     9         t64*t87-1.5589335978906577d-5*t11*t118*t119*t40*t62*t87-2
     :         .2089572834041626d-2*t114*t118*t38*t44*t60*t87/t34**7-6.7
     ;         01302444388497d-5*t100*t11*t111*t3*t40*t41*t87+4.07242605
     <         6744416d-3*t11*t4*t41*t58*t59*t82)+2.078578130520877d-5*t
     =         10*t11*t118*t119*t42*t62*t87+8.935069925851332d-5*t10*t10
     >         0*t11*t111*t3*t41*t42*t87-5.429901408992555d-3*t10*t11*t4
     ?         *t41*t58*t59*t83)+5.039302255187424d-4*t100*t104*t3*t43*t
     @         87-3.062417490053882d-2*t4*t58*t81*t84)*wght+Cmat2(iq,D2_
     1         GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**1.3333333333333333d+0
            t2 = param(1)
            t3 = 1/t2
            t4 = param(2)
            t5 = 1/rhoa**2.6666666666666666d+0
            t6 = 1.6455307846020564d-2*gammaaa*t3*t4*t5+1.0d+0
            t7 = 1.0d+0-1.0d+0/t6
            t8 = -9.305257363491d-1*t1*t2*t7-9.305257363491d-1*t1
            t9 = param(4)
            t10 = param(5)
            t11 = 1/rhoa
            t12 = 9.305257363491d-1*t1*t2*t7+9.305257363491d-1*t1
            t13 = t12**5.0d-1
            t14 = t10**2
            t15 = rhoa**2
            t16 = 1/t15
            t17 = 1/t14
            t18 = 1/t12
            t19 = exp(-1.413716694115413d+1*t15*t17*t18)
            t20 = t19-1.0d+0
            t21 = -3.536776513153214d-2*t12*t14*t16*t20+t19-1.5d+0
            t22 = 1/t10
            t23 = 1/t13
            t24 = 1.7724538509055202d+0*erf(3.759942411946509d+0*rhoa*t2
     1         2*t23)+2.659615202676212d-1*t10*t11*t13*t21
            t25 = -3.5461536035682834d-1*t10*t11*t13*t24*t9-param(3)+1.0
     1         d+0
            t26 = 5.641895835477563d-1
            t27 = 1/t6**2
            t28 = 1/rhoa**2.3333333333333334d+0
            t29 = rhoa**3.333333333333333d-1
            t30 = 1.2407009817987999d+0*t2*t29*t7-4.0832233200718415d-2*
     1         gammaaa*t27*t28*t4+1.2407009817987999d+0*t29
            t31 = 1/t13**3
            t32 = 3.759942411946509d+0*t22*t23-1.8799712059732546d+0*rho
     1         a*t22*t30*t31
            t33 = 1/rhoa**3
            t34 = 1/t12**2
            t35 = 1.413716694115413d+1*t15*t17*t30*t34-2.827433388230826
     1         d+1*rhoa*t17*t18
            t36 = -3.536776513153214d-2*t12*t14*t16*t19*t35+t19*t35+7.07
     1         3553026306428d-2*t12*t14*t20*t33-3.536776513153214d-2*t14
     2         *t16*t20*t30
            t37 = 2.659615202676212d-1*t10*t11*t13*t36+3.544907701811040
     1         3d+0*t19*t26*t32+1.329807601338106d-1*t10*t11*t21*t23*t30
     2         -2.659615202676212d-1*t10*t13*t16*t21
            t38 = -3.5461536035682834d-1*t10*t11*t13*t37*t9-1.7730768017
     1         841417d-1*t10*t11*t23*t24*t30*t9+3.5461536035682834d-1*t1
     2         0*t13*t16*t24*t9
            t39 = -1.2407009817987999d+0*t2*t29*t7+4.0832233200718415d-2
     1         *gammaaa*t27*t28*t4-1.2407009817987999d+0*t29
            t40 = 1/t29
            t41 = 1/rhoa**3.3333333333333337d+0
            t42 = rhoa**6.666666666666666d-1
            t43 = 1/t1
            t44 = -7.656043725134704d-3*t18*t19*t27*t4*t43+2.16469536502
     1         00973d-1*t17*t19*t27*t34*t4*t42-5.415543126146093d-4*t14*
     2         t20*t27*t4*t41
            t45 = 2.659615202676212d-1*t10*t11*t13*t44-1.020447181205866
     1         6d-1*t19*t22*t26*t27*t31*t4*t40+2.036213028372208d-3*t10*
     2         t21*t23*t27*t28*t4
            t46 = -3.5461536035682834d-1*t10*t11*t13*t45*t9-2.7149507044
     1         962773d-3*t10*t23*t24*t27*t28*t4*t9
            t47 = t30**2
            t48 = 1/t13**5
            t49 = t4**2
            t50 = gammaaa**2
            t51 = 1/t6**3
            t52 = 1/rhoa**6
            t53 = 1/t42
            t54 = 4.135669939329333d-1*t2*t53*t7+4.135669939329333d-1*t5
     1         3-3.5835038259110563d-3*t3*t49*t50*t51*t52+4.083223320071
     2         8415d-2*gammaaa*t27*t4*t41
            t55 = 1/rhoa**4
            t56 = 1/t12**3
            t57 = -2.827433388230826d+1*t15*t17*t47*t56+1.41371669411541
     1         3d+1*t15*t17*t34*t54+5.654866776461652d+1*rhoa*t17*t30*t3
     2         4-2.827433388230826d+1*t17*t18
            t58 = t35**2
            t59 = 1/rhoa**5
            t60 = 1.3438139347166464d-3*gammaaa*t3*t49*t51*t59-2.0416116
     1         600359205d-2*t27*t28*t4
            t61 = 1.413716694115413d+1*t15*t17*t34*t60-4.329390730040194
     1         6d-1*t17*t27*t30*t4*t42*t56+4.3293907300401946d-1*t17*t27
     2         *t34*t4*t40
            t62 = 1/t6**4
            t63 = 1/rhoa**3.6666666666666664d+0
            fnc(iq) = 1.0d+0*t25*t8*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t38*t8*wght+1.0d+0*t25*t39*wght+Amat
     1         (iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*t46*t8*wght-1.531208745026941d-2*t2
     1         5*t27*t4*t43*wght+Cmat(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*t8*(-3.5461536035682834d-1*t10*t
     1         11*t13*(2.659615202676212d-1*t10*t11*t13*(-3.536776513153
     2         214d-2*t12*t14*t16*t19*t58+t19*t58-3.536776513153214d-2*t
     3         12*t14*t16*t19*t57+t19*t57-2.1220659078919285d-1*t12*t14*
     4         t20*t55-3.536776513153214d-2*t14*t16*t20*t54+1.4147106052
     5         612857d-1*t12*t14*t19*t33*t35-7.073553026306428d-2*t14*t1
     6         6*t19*t30*t35+1.4147106052612857d-1*t14*t20*t30*t33)+3.54
     7         49077018110403d+0*t19*t26*(-1.8799712059732546d+0*rhoa*t2
     8         2*t31*t54+2.8199568089598814d+0*rhoa*t22*t47*t48-3.759942
     9         411946509d+0*t22*t30*t31)+1.329807601338106d-1*t10*t11*t2
     :         1*t23*t54-6.649038006690531d-2*t10*t11*t21*t31*t47+2.6596
     ;         15202676212d-1*t10*t11*t23*t30*t36-5.319230405352424d-1*t
     <         10*t13*t16*t36+3.5449077018110403d+0*t19*t26*t32*t35+5.31
     =         9230405352424d-1*t10*t13*t21*t33-2.659615202676212d-1*t10
     >         *t16*t21*t23*t30)*t9-1.7730768017841417d-1*t10*t11*t23*t2
     ?         4*t54*t9+8.865384008920708d-2*t10*t11*t24*t31*t47*t9-3.54
     @         61536035682834d-1*t10*t11*t23*t30*t37*t9+7.09230720713656
     1         7d-1*t10*t13*t16*t37*t9-7.092307207136567d-1*t10*t13*t24*
     2         t33*t9+3.5461536035682834d-1*t10*t16*t23*t24*t30*t9)*wght
     3         +1.0d+0*t25*(-4.135669939329333d-1*t2*t53*t7-4.1356699393
     4         29333d-1*t53+3.5835038259110563d-3*t3*t49*t50*t51*t52-4.0
     5         832233200718415d-2*gammaaa*t27*t4*t41)*wght+2.0d+0*t38*t3
     6         9*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*t8*(-3.5461536035682834d-1*t10*
     1         t11*t13*(2.659615202676212d-1*t10*t11*t13*(-3.53677651315
     2         3214d-2*t12*t14*t16*t19*t61+t19*t61-3.536776513153214d-2*
     3         t14*t16*t20*t60-7.656043725134704d-3*t18*t19*t27*t35*t4*t
     4         43-7.656043725134704d-3*t19*t27*t30*t34*t4*t43+2.16469536
     5         50200973d-1*t17*t19*t27*t34*t35*t4*t42-5.415543126146093d
     6         -4*t14*t19*t27*t35*t4*t41+1.5312087450269407d-2*t18*t19*t
     7         27*t28*t4+1.0831086252292187d-3*t14*t20*t27*t4/rhoa**4.33
     8         3333333333333d+0)+3.5449077018110403d+0*t19*t26*(-1.87997
     9         12059732546d+0*rhoa*t22*t31*t60+4.317942526477637d-2*t22*
     :         t27*t30*t4*t40*t48-2.878628350985092d-2*t22*t27*t31*t4*t4
     ;         3)+1.329807601338106d-1*t10*t11*t21*t23*t60+1.32980760133
     <         8106d-1*t10*t11*t23*t30*t44-2.659615202676212d-1*t10*t13*
     =         t16*t44+7.673645271534404d-1*t17*t19*t26*t27*t32*t34*t4*t
     >         42-2.036213028372208d-3*t10*t21*t23*t27*t4*t41+2.03621302
     ?         8372208d-3*t10*t23*t27*t28*t36*t4-1.018106514186104d-3*t1
     @         0*t21*t27*t28*t30*t31*t4)*t9-1.7730768017841417d-1*t10*t1
     1         1*t23*t24*t60*t9-1.7730768017841417d-1*t10*t11*t23*t30*t4
     2         5*t9+3.5461536035682834d-1*t10*t13*t16*t45*t9+2.714950704
     3         4962773d-3*t10*t23*t24*t27*t4*t41*t9-2.7149507044962773d-
     4         3*t10*t23*t27*t28*t37*t4*t9+1.3574753522481386d-3*t10*t24
     5         *t27*t28*t30*t31*t4*t9)*wght+1.0d+0*t25*(2.04161166003592
     6         05d-2*t27*t28*t4-1.3438139347166464d-3*gammaaa*t3*t49*t51
     7         *t59)*wght+1.0d+0*t39*t46*wght-1.531208745026941d-2*t27*t
     8         38*t4*t43*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*t8*(-3.5461536035682834d-1*t10
     1         *t11*t13*(-1.5589335978906577d-5*t10*t21*t31*t49*t62*t63+
     2         2.659615202676212d-1*t10*t11*t13*(-8.286501183095146d-3*t
     3         17*t19*t49*t53*t56*t62-1.3552527156068805d-20*t19*t34*t49
     4         *t5*t62+4.685906023339492d-2*t1*t19*t49*t62/(t10**4*t12**
     5         4)+2.519651127593712d-4*t18*t19*t3*t49*t51*t55+1.78228858
     6         5882691d-5*t14*t20*t3*t49*t51*t52-7.124145724851911d-3*t1
     7         6*t17*t19*t3*t34*t49*t51)+2.3437764715507717d-3*t19*t22*t
     8         26*t48*t49*t62/rhoa**1.6666666666666669d+0-2.208957283404
     9         1626d-2*t19*t26*t29*t49*t62/(t10**3*t13**7)-6.70130244438
     :         8497d-5*t10*t21*t23*t3*t49*t51*t59+3.3583545014692934d-3*
     ;         t19*t22*t26*t3*t31*t33*t49*t51+4.072426056744416d-3*t10*t
     <         23*t27*t28*t4*t44)*t9+2.078578130520877d-5*t10*t24*t31*t4
     =         9*t62*t63*t9+8.935069925851332d-5*t10*t23*t24*t3*t49*t51*
     >         t59*t9-5.429901408992555d-3*t10*t23*t27*t28*t4*t45*t9)*wg
     ?         ht+5.039302255187424d-4*t25*t3*t49*t51*t55*wght-3.0624174
     @         90053882d-2*t27*t4*t43*t46*wght+Cmat2(iq,D2_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**1.3333333333333333d+0
            t2 = param(1)
            t3 = 1/t2
            t4 = param(2)
            t5 = 1/rhob**2.6666666666666666d+0
            t6 = 1.6455307846020564d-2*gammabb*t3*t4*t5+1.0d+0
            t7 = 1.0d+0-1.0d+0/t6
            t8 = -9.305257363491d-1*t1*t2*t7-9.305257363491d-1*t1
            t9 = param(4)
            t10 = param(5)
            t11 = 1/rhob
            t12 = 9.305257363491d-1*t1*t2*t7+9.305257363491d-1*t1
            t13 = t12**5.0d-1
            t14 = t10**2
            t15 = rhob**2
            t16 = 1/t15
            t17 = 1/t14
            t18 = 1/t12
            t19 = exp(-1.413716694115413d+1*t15*t17*t18)
            t20 = t19-1.0d+0
            t21 = -3.536776513153214d-2*t12*t14*t16*t20+t19-1.5d+0
            t22 = 1/t10
            t23 = 1/t13
            t24 = 1.7724538509055202d+0*erf(3.759942411946509d+0*rhob*t2
     1         2*t23)+2.659615202676212d-1*t10*t11*t13*t21
            t25 = -3.5461536035682834d-1*t10*t11*t13*t24*t9-param(3)+1.0
     1         d+0
            t26 = 5.641895835477563d-1
            t27 = 1/t6**2
            t28 = 1/rhob**2.3333333333333334d+0
            t29 = rhob**3.333333333333333d-1
            t30 = 1.2407009817987999d+0*t2*t29*t7-4.0832233200718415d-2*
     1         gammabb*t27*t28*t4+1.2407009817987999d+0*t29
            t31 = 1/t13**3
            t32 = 3.759942411946509d+0*t22*t23-1.8799712059732546d+0*rho
     1         b*t22*t30*t31
            t33 = 1/rhob**3
            t34 = 1/t12**2
            t35 = 1.413716694115413d+1*t15*t17*t30*t34-2.827433388230826
     1         d+1*rhob*t17*t18
            t36 = -3.536776513153214d-2*t12*t14*t16*t19*t35+t19*t35+7.07
     1         3553026306428d-2*t12*t14*t20*t33-3.536776513153214d-2*t14
     2         *t16*t20*t30
            t37 = 2.659615202676212d-1*t10*t11*t13*t36+3.544907701811040
     1         3d+0*t19*t26*t32+1.329807601338106d-1*t10*t11*t21*t23*t30
     2         -2.659615202676212d-1*t10*t13*t16*t21
            t38 = -3.5461536035682834d-1*t10*t11*t13*t37*t9-1.7730768017
     1         841417d-1*t10*t11*t23*t24*t30*t9+3.5461536035682834d-1*t1
     2         0*t13*t16*t24*t9
            t39 = -1.2407009817987999d+0*t2*t29*t7+4.0832233200718415d-2
     1         *gammabb*t27*t28*t4-1.2407009817987999d+0*t29
            t40 = 1/t29
            t41 = 1/rhob**3.3333333333333337d+0
            t42 = rhob**6.666666666666666d-1
            t43 = 1/t1
            t44 = -7.656043725134704d-3*t18*t19*t27*t4*t43+2.16469536502
     1         00973d-1*t17*t19*t27*t34*t4*t42-5.415543126146093d-4*t14*
     2         t20*t27*t4*t41
            t45 = 2.659615202676212d-1*t10*t11*t13*t44-1.020447181205866
     1         6d-1*t19*t22*t26*t27*t31*t4*t40+2.036213028372208d-3*t10*
     2         t21*t23*t27*t28*t4
            t46 = -3.5461536035682834d-1*t10*t11*t13*t45*t9-2.7149507044
     1         962773d-3*t10*t23*t24*t27*t28*t4*t9
            t47 = t30**2
            t48 = 1/t13**5
            t49 = t4**2
            t50 = gammabb**2
            t51 = 1/t6**3
            t52 = 1/rhob**6
            t53 = 1/t42
            t54 = 4.135669939329333d-1*t2*t53*t7+4.135669939329333d-1*t5
     1         3-3.5835038259110563d-3*t3*t49*t50*t51*t52+4.083223320071
     2         8415d-2*gammabb*t27*t4*t41
            t55 = 1/rhob**4
            t56 = 1/t12**3
            t57 = -2.827433388230826d+1*t15*t17*t47*t56+1.41371669411541
     1         3d+1*t15*t17*t34*t54+5.654866776461652d+1*rhob*t17*t30*t3
     2         4-2.827433388230826d+1*t17*t18
            t58 = t35**2
            t59 = 1/rhob**5
            t60 = 1.3438139347166464d-3*gammabb*t3*t49*t51*t59-2.0416116
     1         600359205d-2*t27*t28*t4
            t61 = 1.413716694115413d+1*t15*t17*t34*t60-4.329390730040194
     1         6d-1*t17*t27*t30*t4*t42*t56+4.3293907300401946d-1*t17*t27
     2         *t34*t4*t40
            t62 = 1/t6**4
            t63 = 1/rhob**3.6666666666666664d+0
            fnc(iq) = 1.0d+0*t25*t8*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*t38*t8*wght+1.0d+0*t25*t39*wght+Amat
     1         (iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*t46*t8*wght-1.531208745026941d-2*t2
     1         5*t27*t4*t43*wght+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*t8*(-3.5461536035682834d-1*t10*t
     1         11*t13*(2.659615202676212d-1*t10*t11*t13*(-3.536776513153
     2         214d-2*t12*t14*t16*t19*t58+t19*t58-3.536776513153214d-2*t
     3         12*t14*t16*t19*t57+t19*t57-2.1220659078919285d-1*t12*t14*
     4         t20*t55-3.536776513153214d-2*t14*t16*t20*t54+1.4147106052
     5         612857d-1*t12*t14*t19*t33*t35-7.073553026306428d-2*t14*t1
     6         6*t19*t30*t35+1.4147106052612857d-1*t14*t20*t30*t33)+3.54
     7         49077018110403d+0*t19*t26*(-1.8799712059732546d+0*rhob*t2
     8         2*t31*t54+2.8199568089598814d+0*rhob*t22*t47*t48-3.759942
     9         411946509d+0*t22*t30*t31)+1.329807601338106d-1*t10*t11*t2
     :         1*t23*t54-6.649038006690531d-2*t10*t11*t21*t31*t47+2.6596
     ;         15202676212d-1*t10*t11*t23*t30*t36-5.319230405352424d-1*t
     <         10*t13*t16*t36+3.5449077018110403d+0*t19*t26*t32*t35+5.31
     =         9230405352424d-1*t10*t13*t21*t33-2.659615202676212d-1*t10
     >         *t16*t21*t23*t30)*t9-1.7730768017841417d-1*t10*t11*t23*t2
     ?         4*t54*t9+8.865384008920708d-2*t10*t11*t24*t31*t47*t9-3.54
     @         61536035682834d-1*t10*t11*t23*t30*t37*t9+7.09230720713656
     1         7d-1*t10*t13*t16*t37*t9-7.092307207136567d-1*t10*t13*t24*
     2         t33*t9+3.5461536035682834d-1*t10*t16*t23*t24*t30*t9)*wght
     3         +1.0d+0*t25*(-4.135669939329333d-1*t2*t53*t7-4.1356699393
     4         29333d-1*t53+3.5835038259110563d-3*t3*t49*t50*t51*t52-4.0
     5         832233200718415d-2*gammabb*t27*t4*t41)*wght+2.0d+0*t38*t3
     6         9*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*t8*(-3.5461536035682834d-1*t10*
     1         t11*t13*(2.659615202676212d-1*t10*t11*t13*(-3.53677651315
     2         3214d-2*t12*t14*t16*t19*t61+t19*t61-3.536776513153214d-2*
     3         t14*t16*t20*t60-7.656043725134704d-3*t18*t19*t27*t35*t4*t
     4         43-7.656043725134704d-3*t19*t27*t30*t34*t4*t43+2.16469536
     5         50200973d-1*t17*t19*t27*t34*t35*t4*t42-5.415543126146093d
     6         -4*t14*t19*t27*t35*t4*t41+1.5312087450269407d-2*t18*t19*t
     7         27*t28*t4+1.0831086252292187d-3*t14*t20*t27*t4/rhob**4.33
     8         3333333333333d+0)+3.5449077018110403d+0*t19*t26*(-1.87997
     9         12059732546d+0*rhob*t22*t31*t60+4.317942526477637d-2*t22*
     :         t27*t30*t4*t40*t48-2.878628350985092d-2*t22*t27*t31*t4*t4
     ;         3)+1.329807601338106d-1*t10*t11*t21*t23*t60+1.32980760133
     <         8106d-1*t10*t11*t23*t30*t44-2.659615202676212d-1*t10*t13*
     =         t16*t44+7.673645271534404d-1*t17*t19*t26*t27*t32*t34*t4*t
     >         42-2.036213028372208d-3*t10*t21*t23*t27*t4*t41+2.03621302
     ?         8372208d-3*t10*t23*t27*t28*t36*t4-1.018106514186104d-3*t1
     @         0*t21*t27*t28*t30*t31*t4)*t9-1.7730768017841417d-1*t10*t1
     1         1*t23*t24*t60*t9-1.7730768017841417d-1*t10*t11*t23*t30*t4
     2         5*t9+3.5461536035682834d-1*t10*t13*t16*t45*t9+2.714950704
     3         4962773d-3*t10*t23*t24*t27*t4*t41*t9-2.7149507044962773d-
     4         3*t10*t23*t27*t28*t37*t4*t9+1.3574753522481386d-3*t10*t24
     5         *t27*t28*t30*t31*t4*t9)*wght+1.0d+0*t25*(2.04161166003592
     6         05d-2*t27*t28*t4-1.3438139347166464d-3*gammabb*t3*t49*t51
     7         *t59)*wght+1.0d+0*t39*t46*wght-1.531208745026941d-2*t27*t
     8         38*t4*t43*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*t8*(-3.5461536035682834d-1*t10
     1         *t11*t13*(-1.5589335978906577d-5*t10*t21*t31*t49*t62*t63+
     2         2.659615202676212d-1*t10*t11*t13*(-8.286501183095146d-3*t
     3         17*t19*t49*t53*t56*t62-1.3552527156068805d-20*t19*t34*t49
     4         *t5*t62+4.685906023339492d-2*t1*t19*t49*t62/(t10**4*t12**
     5         4)+2.519651127593712d-4*t18*t19*t3*t49*t51*t55+1.78228858
     6         5882691d-5*t14*t20*t3*t49*t51*t52-7.124145724851911d-3*t1
     7         6*t17*t19*t3*t34*t49*t51)+2.3437764715507717d-3*t19*t22*t
     8         26*t48*t49*t62/rhob**1.6666666666666669d+0-2.208957283404
     9         1626d-2*t19*t26*t29*t49*t62/(t10**3*t13**7)-6.70130244438
     :         8497d-5*t10*t21*t23*t3*t49*t51*t59+3.3583545014692934d-3*
     ;         t19*t22*t26*t3*t31*t33*t49*t51+4.072426056744416d-3*t10*t
     <         23*t27*t28*t4*t44)*t9+2.078578130520877d-5*t10*t24*t31*t4
     =         9*t62*t63*t9+8.935069925851332d-5*t10*t23*t24*t3*t49*t51*
     >         t59*t9-5.429901408992555d-3*t10*t23*t27*t28*t4*t45*t9)*wg
     ?         ht+5.039302255187424d-4*t25*t3*t49*t51*t55*wght-3.0624174
     @         90053882d-2*t27*t4*t43*t46*wght+Cmat2(iq,D2_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_x_campbe functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& {\it param}\left(2\right)\\\\ 
C>   {\it t_5} &=& 1.0-{{1.0}\over{{{0.01645530784602056\,{\it t_3}
C>    \,{\it t_4}\,\sigma_{\alpha\alpha}}
C>    \over{\rho_\alpha^{{{8}\over{3}}}}}+1.0}}\\\\ 
C>   {\it t_6} &=& -{\it param}\left(3\right)\\\\ 
C>   {\it t_7} &=& {\it param}\left(4\right)\\\\ 
C>   {\it t_8} &=& {\it param}\left(5\right)\\\\ 
C>   {\it t_9} &=& {{1}\over{\rho_\alpha}}\\\\ 
C>   {\it t_{10}} &=& 0.9305257363491\,{\it t_2}\,{\it t_1}\,{\it t_5}
C>    +0.9305257363491\,{\it t_1}\\\\ 
C>   {\it t_{11}} &=& \sqrt{{\it t_{10}}}\\\\ 
C>   {\it t_{12}} &=& {\it t_8}^2\\\\ 
C>   {\it t_{13}} &=& \rho_\alpha^2\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_{12}}}}\\\\ 
C>   {\it t_{15}} &=& e^ {- {{14.13716694115413\,{\it t_{13}}\,{
C>    \it t_{14}}}\over{{\it t_{10}}}} }\\\\ 
C>   {\it t_{16}} &=& {{1}\over{{\it t_8}}}\\\\ 
C>   {\it t_{17}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{18}} &=& 1.0-{{1.0}\over{{{0.01645530784602056\,{
C>    \it t_3}\,{\it t_4}\,\sigma_{\beta\beta}}
C>    \over{\rho_\beta^{{{8}\over{3}}}}}+1.0}}\\\\ 
C>   {\it t_{19}} &=& {{1}\over{\rho_\beta}}\\\\ 
C>   {\it t_{20}} &=& 0.9305257363491\,{\it t_2}\,{\it t_{17}}\,{
C>    \it t_{18}}+0.9305257363491\,{\it t_{17}}\\\\ 
C>   {\it t_{21}} &=& \sqrt{{\it t_{20}}}\\\\ 
C>   {\it t_{22}} &=& \rho_\beta^2\\\\ 
C>   {\it t_{23}} &=& e^ {- {{14.13716694115413\,{\it t_{14}}\,{
C>    \it t_{22}}}\over{{\it t_{20}}}} }\\\\ 
C>   {\it t_{24}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{25}} &=& 1.0-{{1.0}\over{{{0.01645530784602056\,{
C>    \it t_3}\,{\it t_4}\,\sigma_{ss}}\over{\rho_s^{{{8}\over{3}}}}}
C>    +1.0}}\\\\ 
C>   {\it t_{26}} &=& {{1}\over{\rho_s}}\\\\ 
C>   {\it t_{27}} &=& 0.9305257363491\,{\it t_2}\,{\it t_{24}}\,{
C>    \it t_{25}}+0.9305257363491\,{\it t_{24}}\\\\ 
C>   {\it t_{28}} &=& \sqrt{{\it t_{27}}}\\\\ 
C>   {\it t_{29}} &=& \rho_s^2\\\\ 
C>   {\it t_{30}} &=& e^ {- {{14.13716694115413\,{\it t_{14}}\,{
C>    \it t_{29}}}\over{{\it t_{27}}}} }\\\\ 
C>   f &=& 1.0\,\left(-0.9305257363491\,{\it t_2}\,{\it t_{17}}\,{
C>    \it t_{18}}-0.9305257363491\,{\it t_{17}}\right)\,\left(
C>    -0.3546153603568283\,{\it t_7}\,{\it t_8}\,{\it t_{19}}\,{
C>    \it t_{21}}\,\left(1.77245385090552\,\mathrm{erf}
C>    \left({{3.759942411946509\,{\it t_{16}}\,\rho_\beta}\over{{
C>    \it t_{21}}}}\right)+0.2659615202676212\,{\it t_8}\,{
C>    \it t_{19}}\,{\it t_{21}}\,\left({\it t_{23}}
C>    -{{0.03536776513153214\,{\it t_{12}}\,{\it t_{20}}\,\left({
C>    \it t_{23}}-1.0\right)}\over{{\it t_{22}}}}-1.5\right)\right)
C>    +{\it t_6}+1.0\right)+1.0\,\left(-0.9305257363491\,{\it t_2}
C>    \,{\it t_1}\,{\it t_5}-0.9305257363491\,{\it t_1}\right)\,\left(
C>    -0.3546153603568283\,{\it t_7}\,{\it t_8}\,{\it t_9}\,{
C>    \it t_{11}}\,\left(1.77245385090552\,\mathrm{erf}
C>    \left({{3.759942411946509\,{\it t_{16}}\,\rho_\alpha}\over{{
C>    \it t_{11}}}}\right)+0.2659615202676212\,{\it t_8}\,{\it t_9}
C>    \,{\it t_{11}}\,\left({\it t_{15}}-{{0.03536776513153214\,{
C>    \it t_{12}}\,{\it t_{10}}\,\left({\it t_{15}}
C>    -1.0\right)}\over{{\it t_{13}}}}-1.5\right)\right)+{\it t_6}
C>    +1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(-0.9305257363491\,{\it t_2}\,{\it t_{24}}\,{
C>    \it t_{25}}-0.9305257363491\,{\it t_{24}}\right)\,\left(
C>    -0.3546153603568283\,{\it t_7}\,{\it t_8}\,{\it t_{26}}\,{
C>    \it t_{28}}\,\left(1.77245385090552\,\mathrm{erf}
C>    \left({{3.759942411946509\,{\it t_{16}}\,\rho_s}\over{{
C>    \it t_{28}}}}\right)+0.2659615202676212\,{\it t_8}\,{
C>    \it t_{26}}\,{\it t_{28}}\,\left({\it t_{30}}
C>    -{{0.03536776513153214\,{\it t_{12}}\,{\it t_{27}}\,\left({
C>    \it t_{30}}-1.0\right)}\over{{\it t_{29}}}}-1.5\right)\right)
C>    +{\it t_6}+1.0\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] OA Vydrov, GE Scuseria, JP Perdew, J.Chem.Phys. 126
C>    , 154109 (2007)  , DOI: 
C> <a href="https://doi.org/10.1063/1.2723119 "> 
C> 10.1063/1.2723119 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_campbe_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,*)  !< [Output] The 3rd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**1.3333333333333333d+0
            t2 = param(1)
            t3 = 1/t2
            t4 = param(2)
            t5 = 1/rhoa**2.6666666666666666d+0
            t6 = 1.6455307846020564d-2*gammaaa*t3*t4*t5+1.0d+0
            t7 = 1.0d+0-1.0d+0/t6
            t8 = -9.305257363491d-1*t1*t2*t7-9.305257363491d-1*t1
            t9 = param(4)
            t10 = param(5)
            t11 = 1/rhoa
            t12 = 9.305257363491d-1*t1*t2*t7+9.305257363491d-1*t1
            t13 = t12**5.0d-1
            t14 = t10**2
            t15 = rhoa**2
            t16 = 1/t15
            t17 = 1/t14
            t18 = 1/t12
            t19 = exp(-1.413716694115413d+1*t15*t17*t18)
            t20 = t19-1.0d+0
            t21 = -3.536776513153214d-2*t12*t14*t16*t20+t19-1.5d+0
            t22 = 1/t10
            t23 = 1/t13
            t24 = 1.7724538509055202d+0*erf(3.759942411946509d+0*rhoa*t2
     1         2*t23)+2.659615202676212d-1*t10*t11*t13*t21
            t25 = -3.5461536035682834d-1*t10*t11*t13*t24*t9-param(3)+1.0
     1         d+0
            t26 = 5.641895835477563d-1
            t27 = 1/t6**2
            t28 = 1/rhoa**2.3333333333333334d+0
            t29 = rhoa**3.333333333333333d-1
            t30 = 1.2407009817987999d+0*t2*t29*t7-4.0832233200718415d-2*
     1         gammaaa*t27*t28*t4+1.2407009817987999d+0*t29
            t31 = 1/t13**3
            t32 = 3.759942411946509d+0*t22*t23-1.8799712059732546d+0*rho
     1         a*t22*t30*t31
            t33 = 1/rhoa**3
            t34 = 1/t12**2
            t35 = 1.413716694115413d+1*t15*t17*t30*t34-2.827433388230826
     1         d+1*rhoa*t17*t18
            t36 = -3.536776513153214d-2*t12*t14*t16*t19*t35+t19*t35+7.07
     1         3553026306428d-2*t12*t14*t20*t33-3.536776513153214d-2*t14
     2         *t16*t20*t30
            t37 = 2.659615202676212d-1*t10*t11*t13*t36+3.544907701811040
     1         3d+0*t19*t26*t32+1.329807601338106d-1*t10*t11*t21*t23*t30
     2         -2.659615202676212d-1*t10*t13*t16*t21
            t38 = -3.5461536035682834d-1*t10*t11*t13*t37*t9-1.7730768017
     1         841417d-1*t10*t11*t23*t24*t30*t9+3.5461536035682834d-1*t1
     2         0*t13*t16*t24*t9
            t39 = -1.2407009817987999d+0*t2*t29*t7+4.0832233200718415d-2
     1         *gammaaa*t27*t28*t4-1.2407009817987999d+0*t29
            t40 = 1/t29
            t41 = 1/rhoa**3.3333333333333337d+0
            t42 = rhoa**6.666666666666666d-1
            t43 = 1/t1
            t44 = -7.656043725134704d-3*t18*t19*t27*t4*t43+2.16469536502
     1         00973d-1*t17*t19*t27*t34*t4*t42-5.415543126146093d-4*t14*
     2         t20*t27*t4*t41
            t45 = 2.659615202676212d-1*t10*t11*t13*t44-1.020447181205866
     1         6d-1*t19*t22*t26*t27*t31*t4*t40+2.036213028372208d-3*t10*
     2         t21*t23*t27*t28*t4
            t46 = -3.5461536035682834d-1*t10*t11*t13*t45*t9-2.7149507044
     1         962773d-3*t10*t23*t24*t27*t28*t4*t9
            t47 = t30**2
            t48 = 1/t13**5
            t49 = t4**2
            t50 = gammaaa**2
            t51 = 1/t6**3
            t52 = 1/rhoa**6
            t53 = 1/t42
            t54 = 4.135669939329333d-1*t2*t53*t7+4.135669939329333d-1*t5
     1         3-3.5835038259110563d-3*t3*t49*t50*t51*t52+4.083223320071
     2         8415d-2*gammaaa*t27*t4*t41
            t55 = -1.8799712059732546d+0*rhoa*t22*t31*t54+2.819956808959
     1         8814d+0*rhoa*t22*t47*t48-3.759942411946509d+0*t22*t30*t31
            t56 = 1/rhoa**4
            t57 = 1/t12**3
            t58 = -2.827433388230826d+1*t15*t17*t47*t57+1.41371669411541
     1         3d+1*t15*t17*t34*t54+5.654866776461652d+1*rhoa*t17*t30*t3
     2         4-2.827433388230826d+1*t17*t18
            t59 = t35**2
            t60 = -3.536776513153214d-2*t12*t14*t16*t19*t59+t19*t59-3.53
     1         6776513153214d-2*t12*t14*t16*t19*t58+t19*t58-2.1220659078
     2         919285d-1*t12*t14*t20*t56-3.536776513153214d-2*t14*t16*t2
     3         0*t54+1.4147106052612857d-1*t12*t14*t19*t33*t35-7.0735530
     4         26306428d-2*t14*t16*t19*t30*t35+1.4147106052612857d-1*t14
     5         *t20*t30*t33
            t61 = 2.659615202676212d-1*t10*t11*t13*t60+3.544907701811040
     1         3d+0*t19*t26*t55+1.329807601338106d-1*t10*t11*t21*t23*t54
     2         -6.649038006690531d-2*t10*t11*t21*t31*t47+2.6596152026762
     3         12d-1*t10*t11*t23*t30*t36-5.319230405352424d-1*t10*t13*t1
     4         6*t36+3.5449077018110403d+0*t19*t26*t32*t35+5.31923040535
     5         2424d-1*t10*t13*t21*t33-2.659615202676212d-1*t10*t16*t21*
     6         t23*t30
            t62 = -3.5461536035682834d-1*t10*t11*t13*t61*t9-1.7730768017
     1         841417d-1*t10*t11*t23*t24*t54*t9+8.865384008920708d-2*t10
     2         *t11*t24*t31*t47*t9-3.5461536035682834d-1*t10*t11*t23*t30
     3         *t37*t9+7.092307207136567d-1*t10*t13*t16*t37*t9-7.0923072
     4         07136567d-1*t10*t13*t24*t33*t9+3.5461536035682834d-1*t10*
     5         t16*t23*t24*t30*t9
            t63 = -4.135669939329333d-1*t2*t53*t7-4.135669939329333d-1*t
     1         53+3.5835038259110563d-3*t3*t49*t50*t51*t52-4.08322332007
     2         18415d-2*gammaaa*t27*t4*t41
            t64 = 1/rhoa**5
            t65 = 1.3438139347166464d-3*gammaaa*t3*t49*t51*t64-2.0416116
     1         600359205d-2*t27*t28*t4
            t66 = -1.8799712059732546d+0*rhoa*t22*t31*t65+4.317942526477
     1         637d-2*t22*t27*t30*t4*t40*t48-2.878628350985092d-2*t22*t2
     2         7*t31*t4*t43
            t67 = 1/rhoa**4.333333333333333d+0
            t68 = 1.413716694115413d+1*t15*t17*t34*t65-4.329390730040194
     1         6d-1*t17*t27*t30*t4*t42*t57+4.3293907300401946d-1*t17*t27
     2         *t34*t4*t40
            t69 = -3.536776513153214d-2*t12*t14*t16*t19*t68+t19*t68+1.08
     1         31086252292187d-3*t14*t20*t27*t4*t67-3.536776513153214d-2
     2         *t14*t16*t20*t65-7.656043725134704d-3*t18*t19*t27*t35*t4*
     3         t43-7.656043725134704d-3*t19*t27*t30*t34*t4*t43+2.1646953
     4         650200973d-1*t17*t19*t27*t34*t35*t4*t42-5.415543126146093
     5         d-4*t14*t19*t27*t35*t4*t41+1.5312087450269407d-2*t18*t19*
     6         t27*t28*t4
            t70 = 2.659615202676212d-1*t10*t11*t13*t69+3.544907701811040
     1         3d+0*t19*t26*t66+1.329807601338106d-1*t10*t11*t21*t23*t65
     2         +1.329807601338106d-1*t10*t11*t23*t30*t44-2.6596152026762
     3         12d-1*t10*t13*t16*t44+7.673645271534404d-1*t17*t19*t26*t2
     4         7*t32*t34*t4*t42-2.036213028372208d-3*t10*t21*t23*t27*t4*
     5         t41+2.036213028372208d-3*t10*t23*t27*t28*t36*t4-1.0181065
     6         14186104d-3*t10*t21*t27*t28*t30*t31*t4
            t71 = -3.5461536035682834d-1*t10*t11*t13*t70*t9-1.7730768017
     1         841417d-1*t10*t11*t23*t24*t65*t9-1.7730768017841417d-1*t1
     2         0*t11*t23*t30*t45*t9+3.5461536035682834d-1*t10*t13*t16*t4
     3         5*t9+2.7149507044962773d-3*t10*t23*t24*t27*t4*t41*t9-2.71
     4         49507044962773d-3*t10*t23*t27*t28*t37*t4*t9+1.35747535224
     5         81386d-3*t10*t24*t27*t28*t30*t31*t4*t9
            t72 = 2.0416116600359205d-2*t27*t28*t4-1.3438139347166464d-3
     1         *gammaaa*t3*t49*t51*t64
            t73 = 1/t10**3
            t74 = 1/t6**4
            t75 = 1/t13**7
            t76 = 1/rhoa**1.6666666666666669d+0
            t77 = 1/rhoa**3.6666666666666664d+0
            t78 = 1/t10**4
            t79 = 1/t12**4
            t80 = 4.685906023339492d-2*t1*t19*t49*t74*t78*t79-8.28650118
     1         3095146d-3*t17*t19*t49*t53*t57*t74-1.3552527156068805d-20
     2         *t19*t34*t49*t5*t74+2.519651127593712d-4*t18*t19*t3*t49*t
     3         51*t56+1.782288585882691d-5*t14*t20*t3*t49*t51*t52-7.1241
     4         45724851911d-3*t16*t17*t19*t3*t34*t49*t51
            t81 = 2.659615202676212d-1*t10*t11*t13*t80-1.558933597890657
     1         7d-5*t10*t21*t31*t49*t74*t77+2.3437764715507717d-3*t19*t2
     2         2*t26*t48*t49*t74*t76-2.2089572834041626d-2*t19*t26*t29*t
     3         49*t73*t74*t75-6.701302444388497d-5*t10*t21*t23*t3*t49*t5
     4         1*t64+3.3583545014692934d-3*t19*t22*t26*t3*t31*t33*t49*t5
     5         1+4.072426056744416d-3*t10*t23*t27*t28*t4*t44
            t82 = -3.5461536035682834d-1*t10*t11*t13*t81*t9+2.0785781305
     1         20877d-5*t10*t24*t31*t49*t74*t77*t9+8.935069925851332d-5*
     2         t10*t23*t24*t3*t49*t51*t64*t9-5.429901408992555d-3*t10*t2
     3         3*t27*t28*t4*t45*t9
            t83 = t30**3
            t84 = 1/t2**2
            t85 = t4**3
            t86 = gammaaa**3
            t87 = 1/rhoa**9.666666666666666d+0
            t88 = 1/rhoa**7
            t89 = 2.50845267813774d-2*t3*t49*t50*t51*t88-4.7174126898207
     1         14d-4*t74*t84*t85*t86*t87-2.757113292886222d-1*t2*t7*t76-
     2         2.757113292886222d-1*t76-1.5425510320271402d-1*gammaaa*t2
     3         7*t4*t67
            t90 = 1.413716694115413d+1*t15*t17*t34*t89+8.482300164692478
     1         d+1*t15*t17*t79*t83-8.482300164692478d+1*t15*t17*t30*t54*
     2         t57-1.6964600329384957d+2*rhoa*t17*t47*t57+8.482300164692
     3         478d+1*rhoa*t17*t34*t54+8.482300164692478d+1*t17*t30*t34
            t91 = t35**3
            t92 = 1/rhoa**8.666666666666666d+0
            t93 = 1.7690297586827677d-4*t50*t74*t84*t85*t92-8.5108215865
     1         3876d-3*gammaaa*t3*t49*t51*t52+4.7637605400838157d-2*t27*
     2         t4*t41
            t94 = 1/rhoa**5.333333333333333d+0
            t95 = 1.413716694115413d+1*t15*t17*t34*t93+1.298817219012058
     1         4d+0*t17*t27*t4*t42*t47*t79-5.654866776461652d+1*t15*t17*
     2         t30*t57*t65+5.654866776461652d+1*rhoa*t17*t34*t65-4.32939
     3         07300401946d-1*t17*t27*t4*t42*t54*t57-1.7317562920160778d
     4         +0*t17*t27*t30*t4*t40*t57+4.3293907300401946d-1*t17*t27*t
     5         34*t4*t43
            t96 = 1/rhoa**7.666666666666667d+0
            t97 = 2.0157209020749695d-3*t3*t49*t51*t64-6.633861595060381
     1         d-5*gammaaa*t74*t84*t85*t96
            t98 = 1/rhoa**4.666666666666667d+0
            t99 = 1.413716694115413d+1*t15*t17*t34*t97+1.988760283942835
     1         3d-2*t17*t30*t49*t53*t74*t79-1.3258401892952237d-2*t17*t4
     2         9*t57*t74*t76-8.658781460080389d-1*t17*t27*t4*t42*t57*t65
     3         +1.4248291449703823d-2*t16*t17*t3*t30*t49*t51*t57-1.42482
     4         91449703823d-2*t17*t3*t33*t34*t49*t51
            t100 = 1/t6**6
            t101 = 1/t6**5
            t102 = 1/rhoa**6.333333333333333d+0
            t103 = 1/rhoa**6.666666666666667d+0
            fnc(iq) = 2.0d+0*t25*t8*wght+fnc(iq)
            Amat(iq,D1_RA) = (1.0d+0*t38*t8+1.0d+0*t25*t39)*wght+Amat(iq
     1         ,D1_RA)
            Cmat(iq,D1_GAA) = (1.0d+0*t46*t8-1.531208745026941d-2*t25*t2
     1         7*t4*t43)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = (1.0d+0*t62*t8+1.0d+0*t25*t63+2.0d+0*t3
     1         8*t39)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = (1.0d+0*t71*t8+1.0d+0*t25*t72+1.0d+0*t
     1         39*t46-1.531208745026941d-2*t27*t38*t4*t43)*wght+Cmat2(iq
     2         ,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = (1.0d+0*t8*t82+5.039302255187424d-4*t
     1         25*t3*t49*t51*t56-3.062417490053882d-2*t27*t4*t43*t46)*wg
     2         ht+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Amat3(iq,D3_RA_RA_RA) = (1.0d+0*t8*(-3.5461536035682834d-1*t
     1         10*t11*t13*t9*(2.659615202676212d-1*t10*t11*t13*(-3.53677
     2         6513153214d-2*t12*t14*t16*t19*t91+t19*t91-3.5367765131532
     3         14d-2*t12*t14*t16*t19*t90+t19*t90-3.536776513153214d-2*t1
     4         4*t16*t20*t89+8.488263631567714d-1*t12*t14*t20*t64+2.1220
     5         659078919285d-1*t12*t14*t19*t33*t59-1.0610329539459643d-1
     6         *t14*t16*t19*t30*t59-1.0610329539459643d-1*t12*t14*t16*t1
     7         9*t35*t58+3*t19*t35*t58+2.1220659078919285d-1*t12*t14*t19
     8         *t33*t58-1.0610329539459643d-1*t14*t16*t19*t30*t58-6.3661
     9         97723675786d-1*t12*t14*t19*t35*t56-6.366197723675786d-1*t
     :         14*t20*t30*t56-1.0610329539459643d-1*t14*t16*t19*t35*t54+
     ;         2.1220659078919285d-1*t14*t20*t33*t54+4.244131815783857d-
     <         1*t14*t19*t30*t33*t35)+3.5449077018110403d+0*t19*t26*(-1.
     =         8799712059732546d+0*rhoa*t22*t31*t89-7.049892022399704d+0
     >         *rhoa*t22*t75*t83+8.459870426879645d+0*rhoa*t22*t30*t48*t
     ?         54-5.639913617919763d+0*t22*t31*t54+8.459870426879645d+0*
     @         t22*t47*t48)+1.329807601338106d-1*t10*t11*t21*t23*t89+9.9
     1         73557010035795d-2*t10*t11*t21*t48*t83+3.989422804014318d-
     2         1*t10*t11*t23*t30*t60-7.978845608028636d-1*t10*t13*t16*t6
     3         0+3.5449077018110403d+0*t19*t26*t32*t59+3.544907701811040
     4         3d+0*t19*t26*t32*t58-1.5957691216057274d+0*t10*t13*t21*t5
     5         6+7.089815403622081d+0*t19*t26*t35*t55+3.989422804014318d
     6         -1*t10*t11*t23*t36*t54-1.994711402007159d-1*t10*t11*t21*t
     7         30*t31*t54-3.989422804014318d-1*t10*t16*t21*t23*t54-1.994
     8         711402007159d-1*t10*t11*t31*t36*t47+1.994711402007159d-1*
     9         t10*t16*t21*t31*t47+1.5957691216057274d+0*t10*t13*t33*t36
     :         -7.978845608028636d-1*t10*t16*t23*t30*t36+7.9788456080286
     ;         36d-1*t10*t21*t23*t30*t33)-1.7730768017841417d-1*t10*t11*
     <         t23*t24*t89*t9-1.3298076013381063d-1*t10*t11*t24*t48*t83*
     =         t9-5.319230405352425d-1*t10*t11*t23*t30*t61*t9+1.06384608
     >         1070485d+0*t10*t13*t16*t61*t9+2.12769216214097d+0*t10*t13
     ?         *t24*t56*t9-5.319230405352425d-1*t10*t11*t23*t37*t54*t9+2
     @         .6596152026762127d-1*t10*t11*t24*t30*t31*t54*t9+5.3192304
     1         05352425d-1*t10*t16*t23*t24*t54*t9+2.6596152026762127d-1*
     2         t10*t11*t31*t37*t47*t9-2.6596152026762127d-1*t10*t16*t24*
     3         t31*t47*t9-2.12769216214097d+0*t10*t13*t33*t37*t9+1.06384
     4         6081070485d+0*t10*t16*t23*t30*t37*t9-1.063846081070485d+0
     5         *t10*t23*t24*t30*t33*t9)+1.0d+0*t25*(-2.50845267813774d-2
     6         *t3*t49*t50*t51*t88+4.717412689820714d-4*t74*t84*t85*t86*
     7         t87+2.757113292886222d-1*t2*t7*t76+2.757113292886222d-1*t
     8         76+1.5425510320271402d-1*gammaaa*t27*t4*t67)+3.0d+0*t38*t
     9         63+3.0d+0*t39*t62)*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
            Cmat3(iq,D3_RA_RA_GAA) = (1.0d+0*t8*(-3.5461536035682834d-1*
     1         t10*t11*t13*t9*(2.659615202676212d-1*t10*t11*t13*(-3.5367
     2         76513153214d-2*t12*t14*t16*t19*t95+t19*t95-3.249325875687
     3         656d-3*t14*t20*t27*t4*t94-3.536776513153214d-2*t14*t16*t2
     4         0*t93-7.073553026306428d-2*t12*t14*t16*t19*t35*t68+2*t19*
     5         t35*t68+1.4147106052612857d-1*t12*t14*t19*t33*t68-7.07355
     6         3026306428d-2*t14*t16*t19*t30*t68+2.1662172504584373d-3*t
     7         14*t19*t27*t35*t4*t67-7.073553026306428d-2*t14*t16*t19*t3
     8         5*t65+1.4147106052612857d-1*t14*t20*t33*t65-7.65604372513
     9         4704d-3*t18*t19*t27*t4*t43*t59+2.1646953650200973d-1*t17*
     :         t19*t27*t34*t4*t42*t59-5.415543126146093d-4*t14*t19*t27*t
     ;         4*t41*t59-7.656043725134704d-3*t18*t19*t27*t4*t43*t58+2.1
     <         646953650200973d-1*t17*t19*t27*t34*t4*t42*t58-5.415543126
     =         146093d-4*t14*t19*t27*t4*t41*t58-7.656043725134704d-3*t19
     >         *t27*t34*t4*t43*t54-1.5312087450269407d-2*t19*t27*t30*t34
     ?         *t35*t4*t43-4.593626235080822d-2*t18*t19*t27*t4*t41+3.062
     @         4174900538814d-2*t18*t19*t27*t28*t35*t4+3.062417490053881
     1         4d-2*t19*t27*t28*t30*t34*t4)+3.5449077018110403d+0*t19*t2
     2         6*(-1.8799712059732546d+0*rhoa*t22*t31*t93-1.079485631619
     3         4094d-1*t22*t27*t4*t40*t47*t75+5.639913617919763d+0*rhoa*
     4         t22*t30*t48*t65-3.759942411946509d+0*t22*t31*t65+4.317942
     5         526477637d-2*t22*t27*t4*t40*t48*t54+8.635885052955274d-2*
     6         t22*t27*t30*t4*t43*t48)+1.329807601338106d-1*t10*t11*t21*
     7         t23*t93+2.659615202676212d-1*t10*t11*t23*t30*t69-5.319230
     8         405352424d-1*t10*t13*t16*t69+3.5449077018110403d+0*t19*t2
     9         6*t32*t68+4.072426056744416d-3*t10*t21*t23*t27*t4*t67+3.5
     :         449077018110403d+0*t19*t26*t35*t66+2.659615202676212d-1*t
     ;         10*t11*t23*t36*t65-1.329807601338106d-1*t10*t11*t21*t30*t
     <         31*t65-2.659615202676212d-1*t10*t16*t21*t23*t65+2.0362130
     =         28372208d-3*t10*t23*t27*t28*t4*t60+7.673645271534404d-1*t
     >         17*t19*t26*t27*t34*t4*t42*t55+1.329807601338106d-1*t10*t1
     ?         1*t23*t44*t54-1.018106514186104d-3*t10*t21*t27*t28*t31*t4
     @         *t54+1.527159771279156d-3*t10*t21*t27*t28*t4*t47*t48-6.64
     1         9038006690531d-2*t10*t11*t31*t44*t47+5.319230405352424d-1
     2         *t10*t13*t33*t44-2.659615202676212d-1*t10*t16*t23*t30*t44
     3         +7.673645271534404d-1*t17*t19*t26*t27*t32*t34*t35*t4*t42-
     4         4.072426056744416d-3*t10*t23*t27*t36*t4*t41+2.03621302837
     5         2208d-3*t10*t21*t27*t30*t31*t4*t41-2.036213028372208d-3*t
     6         10*t27*t28*t30*t31*t36*t4)-1.7730768017841417d-1*t10*t11*
     7         t23*t24*t9*t93-3.5461536035682834d-1*t10*t11*t23*t30*t70*
     8         t9+7.092307207136567d-1*t10*t13*t16*t70*t9-5.429901408992
     9         555d-3*t10*t23*t24*t27*t4*t67*t9-3.5461536035682834d-1*t1
     :         0*t11*t23*t37*t65*t9+1.7730768017841417d-1*t10*t11*t24*t3
     ;         0*t31*t65*t9+3.5461536035682834d-1*t10*t16*t23*t24*t65*t9
     <         -2.7149507044962773d-3*t10*t23*t27*t28*t4*t61*t9-1.773076
     =         8017841417d-1*t10*t11*t23*t45*t54*t9+1.3574753522481386d-
     >         3*t10*t24*t27*t28*t31*t4*t54*t9-2.036213028372208d-3*t10*
     ?         t24*t27*t28*t4*t47*t48*t9+8.865384008920708d-2*t10*t11*t3
     @         1*t45*t47*t9-7.092307207136567d-1*t10*t13*t33*t45*t9+3.54
     1         61536035682834d-1*t10*t16*t23*t30*t45*t9+5.42990140899255
     2         5d-3*t10*t23*t27*t37*t4*t41*t9-2.7149507044962773d-3*t10*
     3         t24*t27*t30*t31*t4*t41*t9+2.7149507044962773d-3*t10*t27*t
     4         28*t30*t31*t37*t4*t9)+1.0d+0*t25*(-1.7690297586827677d-4*
     5         t50*t74*t84*t85*t92+8.51082158653876d-3*gammaaa*t3*t49*t5
     6         1*t52-4.7637605400838157d-2*t27*t4*t41)+2.0d+0*t38*t72+2.
     7         0d+0*t39*t71+1.0d+0*t46*t63-1.531208745026941d-2*t27*t4*t
     8         43*t62)*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = (1.0d+0*t8*(-3.5461536035682834d-1
     1         *t10*t11*t13*t9*(2.659615202676212d-1*t10*t11*t13*(-3.536
     2         776513153214d-2*t12*t14*t16*t19*t99+t19*t99-3.53677651315
     3         3214d-2*t14*t16*t20*t97-3.564577171765382d-5*t14*t20*t3*t
     4         49*t51*t88+4.685906023339492d-2*t1*t19*t35*t49*t74*t78*t7
     5         9-1.6573002366190293d-3*t17*t19*t30*t49*t53*t74*t79+2.710
     6         505431213761d-20*t19*t34*t49*t74*t77+3.3146004732380585d-
     7         3*t17*t19*t49*t57*t74*t76-8.286501183095146d-3*t17*t19*t3
     8         5*t49*t53*t57*t74+2.344600220846979d-4*t19*t30*t49*t5*t57
     9         *t74-1.3552527156068805d-20*t19*t34*t35*t49*t5*t74-1.5312
     :         087450269407d-2*t18*t19*t27*t4*t43*t68+4.3293907300401946
     ;         d-1*t17*t19*t27*t34*t4*t42*t68-1.0831086252292187d-3*t14*
     <         t19*t27*t4*t41*t68-1.5312087450269407d-2*t19*t27*t34*t4*t
     =         43*t65-5.039302255187424d-4*t18*t19*t3*t49*t51*t64+2.5196
     >         51127593712d-4*t18*t19*t3*t35*t49*t51*t56+2.5196511275937
     ?         12d-4*t19*t3*t30*t34*t49*t51*t56+1.782288585882691d-5*t14
     @         *t19*t3*t35*t49*t51*t52-7.124145724851911d-3*t16*t17*t19*
     1         t3*t34*t35*t49*t51)+1.5589335978906577d-5*t10*t21*t31*t49
     2         *t74*t98+3.5449077018110403d+0*t19*t26*(-1.87997120597325
     3         46d+0*rhoa*t22*t31*t97-1.6529178392665705d-3*t22*t30*t49*
     4         t74*t75*t76+6.611671357066283d-4*t22*t48*t49*t5*t74+8.635
     5         885052955274d-2*t22*t27*t4*t40*t48*t65+9.473743137948445d
     6         -4*t22*t3*t31*t49*t51*t56-1.4210614706922667d-3*t22*t3*t3
     7         0*t33*t48*t49*t51)+1.329807601338106d-1*t10*t11*t21*t23*t
     8         97+1.329807601338106d-1*t10*t11*t23*t30*t80-2.65961520267
     9         6212d-1*t10*t13*t16*t80+1.661110435209891d-1*t1*t19*t26*t
     :         32*t49*t74*t78*t79+2.3384003968359865d-5*t10*t21*t30*t48*
     ;         t49*t74*t77-1.5589335978906577d-5*t10*t31*t36*t49*t74*t77
     <         -2.3499905492016226d-2*t17*t19*t26*t32*t49*t53*t57*t74+4.
     =         072426056744416d-3*t10*t23*t27*t28*t4*t69+1.5347290543068
     >         81d+0*t17*t19*t26*t27*t34*t4*t42*t66+2.659615202676212d-1
     ?         *t10*t11*t23*t44*t65-2.036213028372208d-3*t10*t21*t27*t28
     @         *t31*t4*t65-6.701302444388497d-5*t10*t23*t3*t36*t49*t51*t
     1         64+3.3506512221942486d-5*t10*t21*t3*t30*t31*t49*t51*t64+6
     2         .701302444388497d-5*t10*t21*t23*t3*t49*t51*t52-2.52544390
     3         4885174d-2*t16*t17*t19*t26*t3*t32*t34*t49*t51-4.072426056
     4         744416d-3*t10*t23*t27*t4*t41*t44-2.036213028372208d-3*t10
     5         *t27*t28*t30*t31*t4*t44)-2.078578130520877d-5*t10*t24*t31
     6         *t49*t74*t9*t98-1.7730768017841417d-1*t10*t11*t23*t24*t9*
     7         t97-1.7730768017841417d-1*t10*t11*t23*t30*t81*t9+3.546153
     8         6035682834d-1*t10*t13*t16*t81*t9-3.1178671957813153d-5*t1
     9         0*t24*t30*t48*t49*t74*t77*t9+2.078578130520877d-5*t10*t31
     :         *t37*t49*t74*t77*t9-5.429901408992555d-3*t10*t23*t27*t28*
     ;         t4*t70*t9-3.5461536035682834d-1*t10*t11*t23*t45*t65*t9+2.
     <         7149507044962773d-3*t10*t24*t27*t28*t31*t4*t65*t9+8.93506
     =         9925851332d-5*t10*t23*t3*t37*t49*t51*t64*t9-4.46753496292
     >         5666d-5*t10*t24*t3*t30*t31*t49*t51*t64*t9-8.9350699258513
     ?         32d-5*t10*t23*t24*t3*t49*t51*t52*t9+5.429901408992555d-3*
     @         t10*t23*t27*t4*t41*t45*t9+2.7149507044962773d-3*t10*t27*t
     1         28*t30*t31*t4*t45*t9)+1.0d+0*t25*(6.633861595060381d-5*ga
     2         mmaaa*t74*t84*t85*t96-2.0157209020749695d-3*t3*t49*t51*t6
     3         4)+1.0d+0*t39*t82+2.0d+0*t46*t72-3.062417490053882d-2*t27
     4         *t4*t43*t71+5.039302255187424d-4*t3*t38*t49*t51*t56)*wght
     5         +Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = (1.0d+0*t8*(-3.5461536035682834d-
     1         1*t10*t11*t13*t9*(2.659615202676212d-1*t10*t11*t13*(3.516
     2         9003312704855d-4*t17*t19*t34*t74*t84*t85*t98+1.6940658945
     3         086007d-21*t101*t19*t3*t34*t85*t94-8.798432205344503d-7*t
     4         14*t20*t74*t84*t85*t92-1.2438490490738213d-5*t103*t18*t19
     5         *t74*t84*t85-4.6264815690944017d-3*t101*t19*t3*t43*t78*t7
     6         9*t85+3.8065089231694144d-4*t100*t16*t17*t19*t79*t85-4.66
     7         3815182852701d-3*t100*t19*t78*t85/t12**5+4.15034961971753
     8         05d-22*t100*t19*t56*t57*t85+8.181415676054655d-4*t101*t17
     9         *t19*t3*t41*t57*t85+1.0143559049642756d-2*t100*t15*t19*t8
     :         5/(t10**6*t12**6))+3.3081598407510854d-6*t10*t21*t23*t74*
     ;         t84*t85*t96-1.6578827153323844d-4*t19*t22*t26*t31*t74*t84
     <         *t85/rhoa**5.666666666666667d+0+2.1809443270274873d-3*t10
     =         1*t19*t26*t28*t3*t73*t75*t85-8.972027574067322d-5*t100*t1
     >         9*t22*t26*t33*t75*t85+1.6911873548697043d-3*t100*t11*t19*
     ?         t26*t73*t85/t13**9-2.3140538016976683d-4*t101*t19*t22*t26
     @         *t3*t48*t67*t85+3.580579137009732d-7*t10*t100*t21*t48*t64
     1         *t85+1.5391639358877124d-6*t10*t101*t102*t21*t3*t31*t85-4
     2         .781719592912377d-3*rhoa*t100*t19*t26*t85/(t10**5*t13**11
     3         )+6.108639085116625d-3*t10*t23*t27*t28*t4*t80-4.676800793
     4         671973d-5*t10*t31*t44*t49*t74*t77-2.0103907333165494d-4*t
     5         10*t23*t3*t44*t49*t51*t64)-4.4108797876681144d-6*t10*t23*
     6         t24*t74*t84*t85*t9*t96-4.774105516012976d-7*t10*t100*t24*
     7         t48*t64*t85*t9-2.052218581183617d-6*t10*t101*t102*t24*t3*
     8         t31*t85*t9-8.144852113488832d-3*t10*t23*t27*t28*t4*t81*t9
     9         +6.235734391562631d-5*t10*t31*t45*t49*t74*t77*t9+2.680520
     :         9777553995d-4*t10*t23*t3*t45*t49*t51*t64*t9)-2.4876980981
     ;         476426d-5*t103*t25*t74*t84*t85-4.5936262350808227d-2*t27*
     <         t4*t43*t82+1.5117906765562272d-3*t3*t46*t49*t51*t56)*wght
     =         +Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhoa**1.3333333333333333d+0
            t2 = param(1)
            t3 = 1/t2
            t4 = param(2)
            t5 = 1/rhoa**2.6666666666666666d+0
            t6 = 1.6455307846020564d-2*gammaaa*t3*t4*t5+1.0d+0
            t7 = 1.0d+0-1.0d+0/t6
            t8 = -9.305257363491d-1*t1*t2*t7-9.305257363491d-1*t1
            t9 = -param(3)
            t10 = param(4)
            t11 = param(5)
            t12 = 1/rhoa
            t13 = 9.305257363491d-1*t1*t2*t7+9.305257363491d-1*t1
            t14 = t13**5.0d-1
            t15 = t11**2
            t16 = rhoa**2
            t17 = 1/t16
            t18 = 1/t15
            t19 = 1/t13
            t20 = exp(-1.413716694115413d+1*t16*t18*t19)
            t21 = t20-1.0d+0
            t22 = -3.536776513153214d-2*t13*t15*t17*t21+t20-1.5d+0
            t23 = 1/t11
            t24 = 1/t14
            t25 = 1.7724538509055202d+0*erf(3.759942411946509d+0*rhoa*t2
     1         3*t24)+2.659615202676212d-1*t11*t12*t14*t22
            t26 = t9-3.5461536035682834d-1*t10*t11*t12*t14*t25+1.0d+0
            t27 = rhob**1.3333333333333333d+0
            t28 = 1/rhob**2.6666666666666666d+0
            t29 = 1.6455307846020564d-2*gammabb*t28*t3*t4+1.0d+0
            t30 = 1.0d+0-1.0d+0/t29
            t31 = -9.305257363491d-1*t2*t27*t30-9.305257363491d-1*t27
            t32 = 1/rhob
            t33 = 9.305257363491d-1*t2*t27*t30+9.305257363491d-1*t27
            t34 = t33**5.0d-1
            t35 = rhob**2
            t36 = 1/t35
            t37 = 1/t33
            t38 = exp(-1.413716694115413d+1*t18*t35*t37)
            t39 = t38-1.0d+0
            t40 = -3.536776513153214d-2*t15*t33*t36*t39+t38-1.5d+0
            t41 = 1/t34
            t42 = 1.7724538509055202d+0*erf(3.759942411946509d+0*rhob*t2
     1         3*t41)+2.659615202676212d-1*t11*t32*t34*t40
            t43 = t9-3.5461536035682834d-1*t10*t11*t32*t34*t42+1.0d+0
            t44 = 5.641895835477563d-1
            t45 = 1/t6**2
            t46 = 1/rhoa**2.3333333333333334d+0
            t47 = rhoa**3.333333333333333d-1
            t48 = 1.2407009817987999d+0*t2*t47*t7+1.2407009817987999d+0*
     1         t47-4.0832233200718415d-2*gammaaa*t4*t45*t46
            t49 = 1/t14**3
            t50 = 3.759942411946509d+0*t23*t24-1.8799712059732546d+0*rho
     1         a*t23*t48*t49
            t51 = 1/rhoa**3
            t52 = 1/t13**2
            t53 = 1.413716694115413d+1*t16*t18*t48*t52-2.827433388230826
     1         d+1*rhoa*t18*t19
            t54 = -3.536776513153214d-2*t13*t15*t17*t20*t53+t20*t53+7.07
     1         3553026306428d-2*t13*t15*t21*t51-3.536776513153214d-2*t15
     2         *t17*t21*t48
            t55 = 2.659615202676212d-1*t11*t12*t14*t54+3.544907701811040
     1         3d+0*t20*t44*t50+1.329807601338106d-1*t11*t12*t22*t24*t48
     2         -2.659615202676212d-1*t11*t14*t17*t22
            t56 = -3.5461536035682834d-1*t10*t11*t12*t14*t55-1.773076801
     1         7841417d-1*t10*t11*t12*t24*t25*t48+3.5461536035682834d-1*
     2         t10*t11*t14*t17*t25
            t57 = -1.2407009817987999d+0*t2*t47*t7-1.2407009817987999d+0
     1         *t47+4.0832233200718415d-2*gammaaa*t4*t45*t46
            t58 = 1/t29**2
            t59 = 1/rhob**2.3333333333333334d+0
            t60 = rhob**3.333333333333333d-1
            t61 = 1.2407009817987999d+0*t2*t30*t60+1.2407009817987999d+0
     1         *t60-4.0832233200718415d-2*gammabb*t4*t58*t59
            t62 = 1/t34**3
            t63 = 3.759942411946509d+0*t23*t41-1.8799712059732546d+0*rho
     1         b*t23*t61*t62
            t64 = 1/rhob**3
            t65 = 1/t33**2
            t66 = 1.413716694115413d+1*t18*t35*t61*t65-2.827433388230826
     1         d+1*rhob*t18*t37
            t67 = -3.536776513153214d-2*t15*t33*t36*t38*t66+t38*t66+7.07
     1         3553026306428d-2*t15*t33*t39*t64-3.536776513153214d-2*t15
     2         *t36*t39*t61
            t68 = 2.659615202676212d-1*t11*t32*t34*t67+3.544907701811040
     1         3d+0*t38*t44*t63+1.329807601338106d-1*t11*t32*t40*t41*t61
     2         -2.659615202676212d-1*t11*t34*t36*t40
            t69 = -3.5461536035682834d-1*t10*t11*t32*t34*t68-1.773076801
     1         7841417d-1*t10*t11*t32*t41*t42*t61+3.5461536035682834d-1*
     2         t10*t11*t34*t36*t42
            t70 = -1.2407009817987999d+0*t2*t30*t60-1.2407009817987999d+
     1         0*t60+4.0832233200718415d-2*gammabb*t4*t58*t59
            t71 = 1/t47
            t72 = 1/rhoa**3.3333333333333337d+0
            t73 = rhoa**6.666666666666666d-1
            t74 = 1/t1
            t75 = -7.656043725134704d-3*t19*t20*t4*t45*t74+2.16469536502
     1         00973d-1*t18*t20*t4*t45*t52*t73-5.415543126146093d-4*t15*
     2         t21*t4*t45*t72
            t76 = 2.659615202676212d-1*t11*t12*t14*t75-1.020447181205866
     1         6d-1*t20*t23*t4*t44*t45*t49*t71+2.036213028372208d-3*t11*
     2         t22*t24*t4*t45*t46
            t77 = -3.5461536035682834d-1*t10*t11*t12*t14*t76-2.714950704
     1         4962773d-3*t10*t11*t24*t25*t4*t45*t46
            t78 = 1/t60
            t79 = 1/rhob**3.3333333333333337d+0
            t80 = rhob**6.666666666666666d-1
            t81 = 1/t27
            t82 = -7.656043725134704d-3*t37*t38*t4*t58*t81+2.16469536502
     1         00973d-1*t18*t38*t4*t58*t65*t80-5.415543126146093d-4*t15*
     2         t39*t4*t58*t79
            t83 = 2.659615202676212d-1*t11*t32*t34*t82-1.020447181205866
     1         6d-1*t23*t38*t4*t44*t58*t62*t78+2.036213028372208d-3*t11*
     2         t4*t40*t41*t58*t59
            t84 = -3.5461536035682834d-1*t10*t11*t32*t34*t83-2.714950704
     1         4962773d-3*t10*t11*t4*t41*t42*t58*t59
            t85 = t48**2
            t86 = 1/t14**5
            t87 = t4**2
            t88 = gammaaa**2
            t89 = 1/t6**3
            t90 = 1/rhoa**6
            t91 = 1/t73
            t92 = 4.135669939329333d-1*t2*t7*t91+4.135669939329333d-1*t9
     1         1-3.5835038259110563d-3*t3*t87*t88*t89*t90+4.083223320071
     2         8415d-2*gammaaa*t4*t45*t72
            t93 = -1.8799712059732546d+0*rhoa*t23*t49*t92+2.819956808959
     1         8814d+0*rhoa*t23*t85*t86-3.759942411946509d+0*t23*t48*t49
            t94 = 1/rhoa**4
            t95 = 1/t13**3
            t96 = -2.827433388230826d+1*t16*t18*t85*t95+1.41371669411541
     1         3d+1*t16*t18*t52*t92+5.654866776461652d+1*rhoa*t18*t48*t5
     2         2-2.827433388230826d+1*t18*t19
            t97 = t53**2
            t98 = -3.536776513153214d-2*t13*t15*t17*t20*t97+t20*t97-3.53
     1         6776513153214d-2*t13*t15*t17*t20*t96+t20*t96-2.1220659078
     2         919285d-1*t13*t15*t21*t94-3.536776513153214d-2*t15*t17*t2
     3         1*t92+1.4147106052612857d-1*t13*t15*t20*t51*t53-7.0735530
     4         26306428d-2*t15*t17*t20*t48*t53+1.4147106052612857d-1*t15
     5         *t21*t48*t51
            t99 = 2.659615202676212d-1*t11*t12*t14*t98+3.544907701811040
     1         3d+0*t20*t44*t93+1.329807601338106d-1*t11*t12*t22*t24*t92
     2         -6.649038006690531d-2*t11*t12*t22*t49*t85+2.6596152026762
     3         12d-1*t11*t12*t24*t48*t54-5.319230405352424d-1*t11*t14*t1
     4         7*t54+3.5449077018110403d+0*t20*t44*t50*t53+5.31923040535
     5         2424d-1*t11*t14*t22*t51-2.659615202676212d-1*t11*t17*t22*
     6         t24*t48
            t100 = -3.5461536035682834d-1*t10*t11*t12*t14*t99-1.77307680
     1         17841417d-1*t10*t11*t12*t24*t25*t92+8.865384008920708d-2*
     2         t10*t11*t12*t25*t49*t85-3.5461536035682834d-1*t10*t11*t12
     3         *t24*t48*t55+7.092307207136567d-1*t10*t11*t14*t17*t55-7.0
     4         92307207136567d-1*t10*t11*t14*t25*t51+3.5461536035682834d
     5         -1*t10*t11*t17*t24*t25*t48
            t101 = -4.135669939329333d-1*t2*t7*t91-4.135669939329333d-1*
     1         t91+3.5835038259110563d-3*t3*t87*t88*t89*t90-4.0832233200
     2         718415d-2*gammaaa*t4*t45*t72
            t102 = t61**2
            t103 = 1/t34**5
            t104 = gammabb**2
            t105 = 1/t29**3
            t106 = 1/rhob**6
            t107 = 1/t80
            t108 = -3.5835038259110563d-3*t104*t105*t106*t3*t87+4.083223
     1         3200718415d-2*gammabb*t4*t58*t79+4.135669939329333d-1*t10
     2         7*t2*t30+4.135669939329333d-1*t107
            t109 = -3.759942411946509d+0*t23*t61*t62-1.8799712059732546d
     1         +0*rhob*t108*t23*t62+2.8199568089598814d+0*rhob*t102*t103
     2         *t23
            t110 = 1/rhob**4
            t111 = 1/t33**3
            t112 = 5.654866776461652d+1*rhob*t18*t61*t65+1.4137166941154
     1         13d+1*t108*t18*t35*t65-2.827433388230826d+1*t18*t37-2.827
     2         433388230826d+1*t102*t111*t18*t35
            t113 = t66**2
            t114 = 1.4147106052612857d-1*t15*t33*t38*t64*t66-7.073553026
     1         306428d-2*t15*t36*t38*t61*t66+1.4147106052612857d-1*t15*t
     2         39*t61*t64-3.536776513153214d-2*t108*t15*t36*t39-2.122065
     3         9078919285d-1*t110*t15*t33*t39-3.536776513153214d-2*t113*
     4         t15*t33*t36*t38-3.536776513153214d-2*t112*t15*t33*t36*t38
     5         +t113*t38+t112*t38
            t115 = 2.659615202676212d-1*t11*t32*t41*t61*t67-5.3192304053
     1         52424d-1*t11*t34*t36*t67+3.5449077018110403d+0*t38*t44*t6
     2         3*t66+5.319230405352424d-1*t11*t34*t40*t64-6.649038006690
     3         531d-2*t102*t11*t32*t40*t62-2.659615202676212d-1*t11*t36*
     4         t40*t41*t61+3.5449077018110403d+0*t109*t38*t44+1.32980760
     5         1338106d-1*t108*t11*t32*t40*t41+2.659615202676212d-1*t11*
     6         t114*t32*t34
            t116 = -3.5461536035682834d-1*t10*t11*t32*t41*t61*t68+7.0923
     1         07207136567d-1*t10*t11*t34*t36*t68-7.092307207136567d-1*t
     2         10*t11*t34*t42*t64+8.865384008920708d-2*t10*t102*t11*t32*
     3         t42*t62+3.5461536035682834d-1*t10*t11*t36*t41*t42*t61-1.7
     4         730768017841417d-1*t10*t108*t11*t32*t41*t42-3.54615360356
     5         82834d-1*t10*t11*t115*t32*t34
            t117 = 3.5835038259110563d-3*t104*t105*t106*t3*t87-4.0832233
     1         200718415d-2*gammabb*t4*t58*t79-4.135669939329333d-1*t107
     2         *t2*t30-4.135669939329333d-1*t107
            t118 = 1/rhoa**5
            t119 = 1.3438139347166464d-3*gammaaa*t118*t3*t87*t89-2.04161
     1         16600359205d-2*t4*t45*t46
            t120 = 4.317942526477637d-2*t23*t4*t45*t48*t71*t86-2.8786283
     1         50985092d-2*t23*t4*t45*t49*t74-1.8799712059732546d+0*rhoa
     2         *t119*t23*t49
            t121 = 1/rhoa**4.333333333333333d+0
            t122 = -4.3293907300401946d-1*t18*t4*t45*t48*t73*t95+4.32939
     1         07300401946d-1*t18*t4*t45*t52*t71+1.413716694115413d+1*t1
     2         19*t16*t18*t52
            t123 = -7.656043725134704d-3*t19*t20*t4*t45*t53*t74-7.656043
     1         725134704d-3*t20*t4*t45*t48*t52*t74+2.1646953650200973d-1
     2         *t18*t20*t4*t45*t52*t53*t73-5.415543126146093d-4*t15*t20*
     3         t4*t45*t53*t72+1.5312087450269407d-2*t19*t20*t4*t45*t46+1
     4         .0831086252292187d-3*t121*t15*t21*t4*t45-3.53677651315321
     5         4d-2*t119*t15*t17*t21-3.536776513153214d-2*t122*t13*t15*t
     6         17*t20+t122*t20
            t124 = 1.329807601338106d-1*t11*t12*t24*t48*t75-2.6596152026
     1         76212d-1*t11*t14*t17*t75+7.673645271534404d-1*t18*t20*t4*
     2         t44*t45*t50*t52*t73-2.036213028372208d-3*t11*t22*t24*t4*t
     3         45*t72+2.036213028372208d-3*t11*t24*t4*t45*t46*t54-1.0181
     4         06514186104d-3*t11*t22*t4*t45*t46*t48*t49+3.5449077018110
     5         403d+0*t120*t20*t44+1.329807601338106d-1*t11*t119*t12*t22
     6         *t24+2.659615202676212d-1*t11*t12*t123*t14
            t125 = -1.7730768017841417d-1*t10*t11*t12*t24*t48*t76+3.5461
     1         536035682834d-1*t10*t11*t14*t17*t76+2.7149507044962773d-3
     2         *t10*t11*t24*t25*t4*t45*t72-2.7149507044962773d-3*t10*t11
     3         *t24*t4*t45*t46*t55+1.3574753522481386d-3*t10*t11*t25*t4*
     4         t45*t46*t48*t49-1.7730768017841417d-1*t10*t11*t119*t12*t2
     5         4*t25-3.5461536035682834d-1*t10*t11*t12*t124*t14
            t126 = 2.0416116600359205d-2*t4*t45*t46-1.3438139347166464d-
     1         3*gammaaa*t118*t3*t87*t89
            t127 = 1/rhob**5
            t128 = 1.3438139347166464d-3*gammabb*t105*t127*t3*t87-2.0416
     1         116600359205d-2*t4*t58*t59
            t129 = -2.878628350985092d-2*t23*t4*t58*t62*t81+4.3179425264
     1         77637d-2*t103*t23*t4*t58*t61*t78-1.8799712059732546d+0*rh
     2         ob*t128*t23*t62
            t130 = 1/rhob**4.333333333333333d+0
            t131 = -4.3293907300401946d-1*t111*t18*t4*t58*t61*t80+4.3293
     1         907300401946d-1*t18*t4*t58*t65*t78+1.413716694115413d+1*t
     2         128*t18*t35*t65
            t132 = -7.656043725134704d-3*t37*t38*t4*t58*t66*t81-7.656043
     1         725134704d-3*t38*t4*t58*t61*t65*t81+2.1646953650200973d-1
     2         *t18*t38*t4*t58*t65*t66*t80-5.415543126146093d-4*t15*t38*
     3         t4*t58*t66*t79+1.5312087450269407d-2*t37*t38*t4*t58*t59+1
     4         .0831086252292187d-3*t130*t15*t39*t4*t58-3.53677651315321
     5         4d-2*t128*t15*t36*t39-3.536776513153214d-2*t131*t15*t33*t
     6         36*t38+t131*t38
            t133 = 1.329807601338106d-1*t11*t32*t41*t61*t82-2.6596152026
     1         76212d-1*t11*t34*t36*t82+7.673645271534404d-1*t18*t38*t4*
     2         t44*t58*t63*t65*t80-2.036213028372208d-3*t11*t4*t40*t41*t
     3         58*t79+2.036213028372208d-3*t11*t4*t41*t58*t59*t67-1.0181
     4         06514186104d-3*t11*t4*t40*t58*t59*t61*t62+3.5449077018110
     5         403d+0*t129*t38*t44+1.329807601338106d-1*t11*t128*t32*t40
     6         *t41+2.659615202676212d-1*t11*t132*t32*t34
            t134 = -1.7730768017841417d-1*t10*t11*t32*t41*t61*t83+3.5461
     1         536035682834d-1*t10*t11*t34*t36*t83+2.7149507044962773d-3
     2         *t10*t11*t4*t41*t42*t58*t79-2.7149507044962773d-3*t10*t11
     3         *t4*t41*t58*t59*t68+1.3574753522481386d-3*t10*t11*t4*t42*
     4         t58*t59*t61*t62-1.7730768017841417d-1*t10*t11*t128*t32*t4
     5         1*t42-3.5461536035682834d-1*t10*t11*t133*t32*t34
            t135 = 2.0416116600359205d-2*t4*t58*t59-1.3438139347166464d-
     1         3*gammabb*t105*t127*t3*t87
            t136 = 1/t11**3
            t137 = 1/t6**4
            t138 = 1/t14**7
            t139 = 1/rhoa**1.6666666666666669d+0
            t140 = 1/rhoa**3.6666666666666664d+0
            t141 = 1/t11**4
            t142 = 1/t13**4
            t143 = -8.286501183095146d-3*t137*t18*t20*t87*t91*t95+2.5196
     1         51127593712d-4*t19*t20*t3*t87*t89*t94+1.782288585882691d-
     2         5*t15*t21*t3*t87*t89*t90-7.124145724851911d-3*t17*t18*t20
     3         *t3*t52*t87*t89-1.3552527156068805d-20*t137*t20*t5*t52*t8
     4         7+4.685906023339492d-2*t1*t137*t141*t142*t20*t87
            t144 = 3.3583545014692934d-3*t20*t23*t3*t44*t49*t51*t87*t89-
     1         6.701302444388497d-5*t11*t118*t22*t24*t3*t87*t89+2.343776
     2         4715507717d-3*t137*t139*t20*t23*t44*t86*t87-1.55893359789
     3         06577d-5*t11*t137*t140*t22*t49*t87-2.2089572834041626d-2*
     4         t136*t137*t138*t20*t44*t47*t87+4.072426056744416d-3*t11*t
     5         24*t4*t45*t46*t75+2.659615202676212d-1*t11*t12*t14*t143
            t145 = 8.935069925851332d-5*t10*t11*t118*t24*t25*t3*t87*t89+
     1         2.078578130520877d-5*t10*t11*t137*t140*t25*t49*t87-5.4299
     2         01408992555d-3*t10*t11*t24*t4*t45*t46*t76-3.5461536035682
     3         834d-1*t10*t11*t12*t14*t144
            t146 = 1/t29**4
            t147 = 1/t34**7
            t148 = 1/rhob**1.6666666666666669d+0
            t149 = 1/rhob**3.6666666666666664d+0
            t150 = 1/t33**4
            t151 = -7.124145724851911d-3*t105*t18*t3*t36*t38*t65*t87-1.3
     1         552527156068805d-20*t146*t28*t38*t65*t87+1.78228858588269
     2         1d-5*t105*t106*t15*t3*t39*t87+2.519651127593712d-4*t105*t
     3         110*t3*t37*t38*t87+4.685906023339492d-2*t141*t146*t150*t2
     4         7*t38*t87-8.286501183095146d-3*t107*t111*t146*t18*t38*t87
            t152 = 3.3583545014692934d-3*t105*t23*t3*t38*t44*t62*t64*t87
     1         -1.5589335978906577d-5*t11*t146*t149*t40*t62*t87-2.208957
     2         2834041626d-2*t136*t146*t147*t38*t44*t60*t87+2.3437764715
     3         507717d-3*t103*t146*t148*t23*t38*t44*t87-6.70130244438849
     4         7d-5*t105*t11*t127*t3*t40*t41*t87+4.072426056744416d-3*t1
     5         1*t4*t41*t58*t59*t82+2.659615202676212d-1*t11*t151*t32*t3
     6         4
            t153 = 2.078578130520877d-5*t10*t11*t146*t149*t42*t62*t87+8.
     1         935069925851332d-5*t10*t105*t11*t127*t3*t41*t42*t87-5.429
     2         901408992555d-3*t10*t11*t4*t41*t58*t59*t83-3.546153603568
     3         2834d-1*t10*t11*t152*t32*t34
            t154 = t48**3
            t155 = 1/t2**2
            t156 = t4**3
            t157 = gammaaa**3
            t158 = 1/rhoa**9.666666666666666d+0
            t159 = 1/rhoa**7
            t160 = 2.50845267813774d-2*t159*t3*t87*t88*t89-2.75711329288
     1         6222d-1*t139*t2*t7-1.5425510320271402d-1*gammaaa*t121*t4*
     2         t45-4.717412689820714d-4*t137*t155*t156*t157*t158-2.75711
     3         3292886222d-1*t139
            t161 = -8.482300164692478d+1*t16*t18*t48*t92*t95-1.696460032
     1         9384957d+2*rhoa*t18*t85*t95+8.482300164692478d+1*rhoa*t18
     2         *t52*t92+8.482300164692478d+1*t18*t48*t52+1.4137166941154
     3         13d+1*t16*t160*t18*t52+8.482300164692478d+1*t142*t154*t16
     4         *t18
            t162 = t53**3
            t163 = t61**3
            t164 = gammabb**3
            t165 = 1/rhob**9.666666666666666d+0
            t166 = 1/rhob**7
            t167 = 2.50845267813774d-2*t104*t105*t166*t3*t87-1.542551032
     1         0271402d-1*gammabb*t130*t4*t58-2.757113292886222d-1*t148*
     2         t2*t30-4.717412689820714d-4*t146*t155*t156*t164*t165-2.75
     3         7113292886222d-1*t148
            t168 = 8.482300164692478d+1*t18*t61*t65+1.413716694115413d+1
     1         *t167*t18*t35*t65+8.482300164692478d+1*rhob*t108*t18*t65-
     2         8.482300164692478d+1*t108*t111*t18*t35*t61+8.482300164692
     3         478d+1*t150*t163*t18*t35-1.6964600329384957d+2*rhob*t102*
     4         t111*t18
            t169 = t66**3
            t170 = 1/rhoa**8.666666666666666d+0
            t171 = -8.51082158653876d-3*gammaaa*t3*t87*t89*t90+1.7690297
     1         586827677d-4*t137*t155*t156*t170*t88+4.7637605400838157d-
     2         2*t4*t45*t72
            t172 = 1/rhoa**5.333333333333333d+0
            t173 = -4.3293907300401946d-1*t18*t4*t45*t73*t92*t95-1.73175
     1         62920160778d+0*t18*t4*t45*t48*t71*t95-5.654866776461652d+
     2         1*t119*t16*t18*t48*t95+1.2988172190120584d+0*t142*t18*t4*
     3         t45*t73*t85+4.3293907300401946d-1*t18*t4*t45*t52*t74+1.41
     4         3716694115413d+1*t16*t171*t18*t52+5.654866776461652d+1*rh
     5         oa*t119*t18*t52
            t174 = 1/rhob**8.666666666666666d+0
            t175 = -8.51082158653876d-3*gammabb*t105*t106*t3*t87+4.76376
     1         05400838157d-2*t4*t58*t79+1.7690297586827677d-4*t104*t146
     2         *t155*t156*t174
            t176 = 1/rhob**5.333333333333333d+0
            t177 = 4.3293907300401946d-1*t18*t4*t58*t65*t81+1.2988172190
     1         120584d+0*t102*t150*t18*t4*t58*t80-4.3293907300401946d-1*
     2         t108*t111*t18*t4*t58*t80-1.7317562920160778d+0*t111*t18*t
     3         4*t58*t61*t78+1.413716694115413d+1*t175*t18*t35*t65+5.654
     4         866776461652d+1*rhob*t128*t18*t65-5.654866776461652d+1*t1
     5         11*t128*t18*t35*t61
            t178 = 1/rhoa**7.666666666666667d+0
            t179 = 2.0157209020749695d-3*t118*t3*t87*t89-6.6338615950603
     1         81d-5*gammaaa*t137*t155*t156*t178
            t180 = 1/rhoa**4.666666666666667d+0
            t181 = 1.4248291449703823d-2*t17*t18*t3*t48*t87*t89*t95-1.32
     1         58401892952237d-2*t137*t139*t18*t87*t95-8.658781460080389
     2         d-1*t119*t18*t4*t45*t73*t95+1.9887602839428353d-2*t137*t1
     3         42*t18*t48*t87*t91-1.4248291449703823d-2*t18*t3*t51*t52*t
     4         87*t89+1.413716694115413d+1*t16*t179*t18*t52
            t182 = 1/rhob**7.666666666666667d+0
            t183 = 2.0157209020749695d-3*t105*t127*t3*t87-6.633861595060
     1         381d-5*gammabb*t146*t155*t156*t182
            t184 = 1/rhob**4.666666666666667d+0
            t185 = -1.4248291449703823d-2*t105*t18*t3*t64*t65*t87+1.4248
     1         291449703823d-2*t105*t111*t18*t3*t36*t61*t87+1.9887602839
     2         428353d-2*t107*t146*t150*t18*t61*t87-1.3258401892952237d-
     3         2*t111*t146*t148*t18*t87-8.658781460080389d-1*t111*t128*t
     4         18*t4*t58*t80+1.413716694115413d+1*t18*t183*t35*t65
            t186 = 1/t11**5
            t187 = 1/t6**6
            t188 = 1/t6**5
            t189 = 1/rhoa**6.333333333333333d+0
            t190 = 1/t11**6
            t191 = 1/rhoa**6.666666666666667d+0
            t192 = 1/t29**6
            t193 = 1/t29**5
            t194 = 1/rhob**6.333333333333333d+0
            t195 = 1/rhob**6.666666666666667d+0
            fnc(iq) = (1.0d+0*t26*t8+1.0d+0*t31*t43)*wght+fnc(iq)
            Amat(iq,D1_RA) = (1.0d+0*t56*t8+1.0d+0*t26*t57)*wght+Amat(iq
     1         ,D1_RA)
            Amat(iq,D1_RB) = (1.0d+0*t43*t70+1.0d+0*t31*t69)*wght+Amat(i
     1         q,D1_RB)
            Cmat(iq,D1_GAA) = (1.0d+0*t77*t8-1.531208745026941d-2*t26*t4
     1         *t45*t74)*wght+Cmat(iq,D1_GAA)
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = (1.0d+0*t31*t84-1.531208745026941d-2*t4*t4
     1         3*t58*t81)*wght+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RA_RA) = (1.0d+0*t100*t8+2.0d+0*t56*t57+1.0d+0*t
     1         101*t26)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = (2.0d+0*t69*t70+1.0d+0*t117*t43+1.0d+0*
     1         t116*t31)*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = (1.0d+0*t125*t8+1.0d+0*t57*t77-1.53120
     1         8745026941d-2*t4*t45*t56*t74+1.0d+0*t126*t26)*wght+Cmat2(
     2         iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = (1.0d+0*t70*t84-1.531208745026941d-2*t
     1         4*t58*t69*t81+1.0d+0*t135*t43+1.0d+0*t134*t31)*wght+Cmat2
     2         (iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = (5.039302255187424d-4*t26*t3*t87*t89*
     1         t94+1.0d+0*t145*t8-3.062417490053882d-2*t4*t45*t74*t77)*w
     2         ght+Cmat2(iq,D2_GAA_GAA)
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = (5.039302255187424d-4*t105*t110*t3*t4
     1         3*t87-3.062417490053882d-2*t4*t58*t81*t84+1.0d+0*t153*t31
     2         )*wght+Cmat2(iq,D2_GBB_GBB)
            Amat3(iq,D3_RA_RA_RA) = (1.0d+0*t8*(-5.319230405352425d-1*t1
     1         0*t11*t12*t24*t48*t99+1.063846081070485d+0*t10*t11*t14*t1
     2         7*t99-3.5461536035682834d-1*t10*t11*t12*t14*(3.9894228040
     3         14318d-1*t11*t12*t24*t48*t98-7.978845608028636d-1*t11*t14
     4         *t17*t98+2.659615202676212d-1*t11*t12*t14*(2.122065907891
     5         9285d-1*t13*t15*t20*t51*t97-1.0610329539459643d-1*t15*t17
     6         *t20*t48*t97-1.0610329539459643d-1*t13*t15*t17*t20*t53*t9
     7         6+3*t20*t53*t96+2.1220659078919285d-1*t13*t15*t20*t51*t96
     8         -1.0610329539459643d-1*t15*t17*t20*t48*t96-6.366197723675
     9         786d-1*t13*t15*t20*t53*t94-6.366197723675786d-1*t15*t21*t
     :         48*t94-1.0610329539459643d-1*t15*t17*t20*t53*t92+2.122065
     ;         9078919285d-1*t15*t21*t51*t92+4.244131815783857d-1*t15*t2
     <         0*t48*t51*t53-3.536776513153214d-2*t15*t160*t17*t21+8.488
     =         263631567714d-1*t118*t13*t15*t21-3.536776513153214d-2*t13
     >         *t15*t162*t17*t20-3.536776513153214d-2*t13*t15*t161*t17*t
     ?         20+t162*t20+t161*t20)+3.5449077018110403d+0*t20*t44*t50*t
     @         97+3.5449077018110403d+0*t20*t44*t50*t96-1.59576912160572
     1         74d+0*t11*t14*t22*t94+7.089815403622081d+0*t20*t44*t53*t9
     2         3+3.5449077018110403d+0*t20*t44*(8.459870426879645d+0*rho
     3         a*t23*t48*t86*t92-5.639913617919763d+0*t23*t49*t92+8.4598
     4         70426879645d+0*t23*t85*t86-1.8799712059732546d+0*rhoa*t16
     5         0*t23*t49-7.049892022399704d+0*rhoa*t138*t154*t23)+3.9894
     6         22804014318d-1*t11*t12*t24*t54*t92-1.994711402007159d-1*t
     7         11*t12*t22*t48*t49*t92-3.989422804014318d-1*t11*t17*t22*t
     8         24*t92+9.973557010035795d-2*t11*t12*t154*t22*t86-1.994711
     9         402007159d-1*t11*t12*t49*t54*t85+1.994711402007159d-1*t11
     :         *t17*t22*t49*t85+1.5957691216057274d+0*t11*t14*t51*t54-7.
     ;         978845608028636d-1*t11*t17*t24*t48*t54+7.978845608028636d
     <         -1*t11*t22*t24*t48*t51+1.329807601338106d-1*t11*t12*t160*
     =         t22*t24)+2.12769216214097d+0*t10*t11*t14*t25*t94-5.319230
     >         405352425d-1*t10*t11*t12*t24*t55*t92+2.6596152026762127d-
     ?         1*t10*t11*t12*t25*t48*t49*t92+5.319230405352425d-1*t10*t1
     @         1*t17*t24*t25*t92-1.3298076013381063d-1*t10*t11*t12*t154*
     1         t25*t86+2.6596152026762127d-1*t10*t11*t12*t49*t55*t85-2.6
     2         596152026762127d-1*t10*t11*t17*t25*t49*t85-2.127692162140
     3         97d+0*t10*t11*t14*t51*t55+1.063846081070485d+0*t10*t11*t1
     4         7*t24*t48*t55-1.063846081070485d+0*t10*t11*t24*t25*t48*t5
     5         1-1.7730768017841417d-1*t10*t11*t12*t160*t24*t25)+1.0d+0*
     6         t26*(-2.50845267813774d-2*t159*t3*t87*t88*t89+2.757113292
     7         886222d-1*t139*t2*t7+1.5425510320271402d-1*gammaaa*t121*t
     8         4*t45+4.717412689820714d-4*t137*t155*t156*t157*t158+2.757
     9         113292886222d-1*t139)+3.0d+0*t100*t57+3.0d+0*t101*t56)*wg
     :         ht+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = Amat3(iq,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = (1.0d+0*t43*(-2.50845267813774d-2*t1
     1         04*t105*t166*t3*t87+1.5425510320271402d-1*gammabb*t130*t4
     2         *t58+2.757113292886222d-1*t148*t2*t30+4.717412689820714d-
     3         4*t146*t155*t156*t164*t165+2.757113292886222d-1*t148)+3.0
     4         d+0*t116*t70+3.0d+0*t117*t69+1.0d+0*t31*(-2.1276921621409
     5         7d+0*t10*t11*t34*t64*t68+2.6596152026762127d-1*t10*t102*t
     6         11*t32*t62*t68+1.063846081070485d+0*t10*t11*t36*t41*t61*t
     7         68-5.319230405352425d-1*t10*t108*t11*t32*t41*t68-3.546153
     8         6035682834d-1*t10*t11*t32*t34*(1.5957691216057274d+0*t11*
     9         t34*t64*t67-1.994711402007159d-1*t102*t11*t32*t62*t67-7.9
     :         78845608028636d-1*t11*t36*t41*t61*t67+3.989422804014318d-
     ;         1*t108*t11*t32*t41*t67+2.659615202676212d-1*t11*t32*t34*(
     <         4.244131815783857d-1*t15*t38*t61*t64*t66-1.06103295394596
     =         43d-1*t112*t15*t33*t36*t38*t66-1.0610329539459643d-1*t108
     >         *t15*t36*t38*t66-6.366197723675786d-1*t110*t15*t33*t38*t6
     ?         6+3*t112*t38*t66+2.1220659078919285d-1*t108*t15*t39*t64+2
     @         .1220659078919285d-1*t113*t15*t33*t38*t64+2.1220659078919
     1         285d-1*t112*t15*t33*t38*t64-6.366197723675786d-1*t110*t15
     2         *t39*t61-1.0610329539459643d-1*t113*t15*t36*t38*t61-1.061
     3         0329539459643d-1*t112*t15*t36*t38*t61-3.536776513153214d-
     4         2*t15*t167*t36*t39+8.488263631567714d-1*t127*t15*t33*t39-
     5         3.536776513153214d-2*t15*t169*t33*t36*t38-3.5367765131532
     6         14d-2*t15*t168*t33*t36*t38+t169*t38+t168*t38)+7.089815403
     7         622081d+0*t109*t38*t44*t66+7.978845608028636d-1*t11*t40*t
     8         41*t61*t64+3.5449077018110403d+0*t113*t38*t44*t63+3.54490
     9         77018110403d+0*t112*t38*t44*t63+3.5449077018110403d+0*t38
     :         *t44*(-1.8799712059732546d+0*rhob*t167*t23*t62-5.63991361
     ;         7919763d+0*t108*t23*t62+8.459870426879645d+0*rhob*t103*t1
     <         08*t23*t61-7.049892022399704d+0*rhob*t147*t163*t23+8.4598
     =         70426879645d+0*t102*t103*t23)-1.994711402007159d-1*t108*t
     >         11*t32*t40*t61*t62+1.994711402007159d-1*t102*t11*t36*t40*
     ?         t62+3.989422804014318d-1*t11*t114*t32*t41*t61-3.989422804
     @         014318d-1*t108*t11*t36*t40*t41+1.329807601338106d-1*t11*t
     1         167*t32*t40*t41-1.5957691216057274d+0*t11*t110*t34*t40+9.
     2         973557010035795d-2*t103*t11*t163*t32*t40-7.97884560802863
     3         6d-1*t11*t114*t34*t36)-1.063846081070485d+0*t10*t11*t41*t
     4         42*t61*t64+2.6596152026762127d-1*t10*t108*t11*t32*t42*t61
     5         *t62-2.6596152026762127d-1*t10*t102*t11*t36*t42*t62-5.319
     6         230405352425d-1*t10*t11*t115*t32*t41*t61+5.31923040535242
     7         5d-1*t10*t108*t11*t36*t41*t42-1.7730768017841417d-1*t10*t
     8         11*t167*t32*t41*t42+2.12769216214097d+0*t10*t11*t110*t34*
     9         t42-1.3298076013381063d-1*t10*t103*t11*t163*t32*t42+1.063
     :         846081070485d+0*t10*t11*t115*t34*t36))*wght+Amat3(iq,D3_R
     ;         B_RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = (1.0d+0*t8*(-2.7149507044962773d-3*
     1         t10*t11*t24*t4*t45*t46*t99-3.5461536035682834d-1*t10*t11*
     2         t12*t14*(2.036213028372208d-3*t11*t24*t4*t45*t46*t98+2.65
     3         9615202676212d-1*t11*t12*t14*(-7.656043725134704d-3*t19*t
     4         20*t4*t45*t74*t97+2.1646953650200973d-1*t18*t20*t4*t45*t5
     5         2*t73*t97-5.415543126146093d-4*t15*t20*t4*t45*t72*t97-7.6
     6         56043725134704d-3*t19*t20*t4*t45*t74*t96+2.16469536502009
     7         73d-1*t18*t20*t4*t45*t52*t73*t96-5.415543126146093d-4*t15
     8         *t20*t4*t45*t72*t96-7.656043725134704d-3*t20*t4*t45*t52*t
     9         74*t92-1.5312087450269407d-2*t20*t4*t45*t48*t52*t53*t74-4
     :         .593626235080822d-2*t19*t20*t4*t45*t72+3.0624174900538814
     ;         d-2*t19*t20*t4*t45*t46*t53+2.1662172504584373d-3*t121*t15
     <         *t20*t4*t45*t53-7.073553026306428d-2*t122*t13*t15*t17*t20
     =         *t53-7.073553026306428d-2*t119*t15*t17*t20*t53+2*t122*t20
     >         *t53+3.0624174900538814d-2*t20*t4*t45*t46*t48*t52+1.41471
     ?         06052612857d-1*t119*t15*t21*t51+1.4147106052612857d-1*t12
     @         2*t13*t15*t20*t51-7.073553026306428d-2*t122*t15*t17*t20*t
     1         48-3.249325875687656d-3*t15*t172*t21*t4*t45-3.53677651315
     2         3214d-2*t15*t17*t171*t21-3.536776513153214d-2*t13*t15*t17
     3         *t173*t20+t173*t20)+7.673645271534404d-1*t18*t20*t4*t44*t
     4         45*t52*t73*t93+3.5449077018110403d+0*t20*t44*(4.317942526
     5         477637d-2*t23*t4*t45*t71*t86*t92+8.635885052955274d-2*t23
     6         *t4*t45*t48*t74*t86+5.639913617919763d+0*rhoa*t119*t23*t4
     7         8*t86-1.0794856316194094d-1*t138*t23*t4*t45*t71*t85-1.879
     8         9712059732546d+0*rhoa*t171*t23*t49-3.759942411946509d+0*t
     9         119*t23*t49)+1.329807601338106d-1*t11*t12*t24*t75*t92-1.0
     :         18106514186104d-3*t11*t22*t4*t45*t46*t49*t92+1.5271597712
     ;         79156d-3*t11*t22*t4*t45*t46*t85*t86-6.649038006690531d-2*
     <         t11*t12*t49*t75*t85+5.319230405352424d-1*t11*t14*t51*t75-
     =         2.659615202676212d-1*t11*t17*t24*t48*t75+7.67364527153440
     >         4d-1*t18*t20*t4*t44*t45*t50*t52*t53*t73-4.072426056744416
     ?         d-3*t11*t24*t4*t45*t54*t72+2.036213028372208d-3*t11*t22*t
     @         4*t45*t48*t49*t72-2.036213028372208d-3*t11*t4*t45*t46*t48
     1         *t49*t54+2.659615202676212d-1*t11*t119*t12*t24*t54+3.5449
     2         077018110403d+0*t120*t20*t44*t53+3.5449077018110403d+0*t1
     3         22*t20*t44*t50-1.329807601338106d-1*t11*t119*t12*t22*t48*
     4         t49+2.659615202676212d-1*t11*t12*t123*t24*t48+4.072426056
     5         744416d-3*t11*t121*t22*t24*t4*t45+1.329807601338106d-1*t1
     6         1*t12*t171*t22*t24-2.659615202676212d-1*t11*t119*t17*t22*
     7         t24-5.319230405352424d-1*t11*t123*t14*t17)-1.773076801784
     8         1417d-1*t10*t11*t12*t24*t76*t92+1.3574753522481386d-3*t10
     9         *t11*t25*t4*t45*t46*t49*t92-2.036213028372208d-3*t10*t11*
     :         t25*t4*t45*t46*t85*t86+8.865384008920708d-2*t10*t11*t12*t
     ;         49*t76*t85-7.092307207136567d-1*t10*t11*t14*t51*t76+3.546
     <         1536035682834d-1*t10*t11*t17*t24*t48*t76+5.42990140899255
     =         5d-3*t10*t11*t24*t4*t45*t55*t72-2.7149507044962773d-3*t10
     >         *t11*t25*t4*t45*t48*t49*t72+2.7149507044962773d-3*t10*t11
     ?         *t4*t45*t46*t48*t49*t55-3.5461536035682834d-1*t10*t11*t11
     @         9*t12*t24*t55+1.7730768017841417d-1*t10*t11*t119*t12*t25*
     1         t48*t49-3.5461536035682834d-1*t10*t11*t12*t124*t24*t48-5.
     2         429901408992555d-3*t10*t11*t121*t24*t25*t4*t45-1.77307680
     3         17841417d-1*t10*t11*t12*t171*t24*t25+3.5461536035682834d-
     4         1*t10*t11*t119*t17*t24*t25+7.092307207136567d-1*t10*t11*t
     5         124*t14*t17)+1.0d+0*t26*(8.51082158653876d-3*gammaaa*t3*t
     6         87*t89*t90-1.7690297586827677d-4*t137*t155*t156*t170*t88-
     7         4.7637605400838157d-2*t4*t45*t72)+1.0d+0*t101*t77-1.53120
     8         8745026941d-2*t100*t4*t45*t74+2.0d+0*t125*t57+2.0d+0*t126
     9         *t56)*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = Cmat3(iq,D3_RB_RB_GAA)
            Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
            Cmat3(iq,D3_RB_RB_GBB) = (1.0d+0*t43*(8.51082158653876d-3*ga
     1         mmabb*t105*t106*t3*t87-4.7637605400838157d-2*t4*t58*t79-1
     2         .7690297586827677d-4*t104*t146*t155*t156*t174)+1.0d+0*t11
     3         7*t84+1.0d+0*t31*(-7.092307207136567d-1*t10*t11*t34*t64*t
     4         83+8.865384008920708d-2*t10*t102*t11*t32*t62*t83+3.546153
     5         6035682834d-1*t10*t11*t36*t41*t61*t83-1.7730768017841417d
     6         -1*t10*t108*t11*t32*t41*t83-3.5461536035682834d-1*t10*t11
     7         *t32*t34*(5.319230405352424d-1*t11*t34*t64*t82-6.64903800
     8         6690531d-2*t102*t11*t32*t62*t82-2.659615202676212d-1*t11*
     9         t36*t41*t61*t82+1.329807601338106d-1*t108*t11*t32*t41*t82
     :         +2.659615202676212d-1*t11*t32*t34*(-1.5312087450269407d-2
     ;         *t38*t4*t58*t61*t65*t66*t81-7.656043725134704d-3*t108*t38
     <         *t4*t58*t65*t81-7.656043725134704d-3*t113*t37*t38*t4*t58*
     =         t81-7.656043725134704d-3*t112*t37*t38*t4*t58*t81+2.164695
     >         3650200973d-1*t113*t18*t38*t4*t58*t65*t80+2.1646953650200
     ?         973d-1*t112*t18*t38*t4*t58*t65*t80-4.593626235080822d-2*t
     @         37*t38*t4*t58*t79-5.415543126146093d-4*t113*t15*t38*t4*t5
     1         8*t79-5.415543126146093d-4*t112*t15*t38*t4*t58*t79+3.0624
     2         174900538814d-2*t37*t38*t4*t58*t59*t66+2.1662172504584373
     3         d-3*t130*t15*t38*t4*t58*t66-7.073553026306428d-2*t131*t15
     4         *t33*t36*t38*t66-7.073553026306428d-2*t128*t15*t36*t38*t6
     5         6+2*t131*t38*t66+3.0624174900538814d-2*t38*t4*t58*t59*t61
     6         *t65+1.4147106052612857d-1*t128*t15*t39*t64+1.41471060526
     7         12857d-1*t131*t15*t33*t38*t64-7.073553026306428d-2*t131*t
     8         15*t36*t38*t61-3.249325875687656d-3*t15*t176*t39*t4*t58-3
     9         .536776513153214d-2*t15*t175*t36*t39-3.536776513153214d-2
     :         *t15*t177*t33*t36*t38+t177*t38)+3.5449077018110403d+0*t38
     ;         *t44*(8.635885052955274d-2*t103*t23*t4*t58*t61*t81-1.0794
     <         856316194094d-1*t102*t147*t23*t4*t58*t78+4.31794252647763
     =         7d-2*t103*t108*t23*t4*t58*t78-1.8799712059732546d+0*rhob*
     >         t175*t23*t62-3.759942411946509d+0*t128*t23*t62+5.63991361
     ?         7919763d+0*rhob*t103*t128*t23*t61)+7.673645271534404d-1*t
     @         18*t38*t4*t44*t58*t63*t65*t66*t80+7.673645271534404d-1*t1
     1         09*t18*t38*t4*t44*t58*t65*t80-4.072426056744416d-3*t11*t4
     2         *t41*t58*t67*t79+2.036213028372208d-3*t11*t4*t40*t58*t61*
     3         t62*t79-2.036213028372208d-3*t11*t4*t58*t59*t61*t62*t67+2
     4         .659615202676212d-1*t11*t128*t32*t41*t67+3.54490770181104
     5         03d+0*t129*t38*t44*t66+3.5449077018110403d+0*t131*t38*t44
     6         *t63-1.329807601338106d-1*t11*t128*t32*t40*t61*t62-1.0181
     7         06514186104d-3*t108*t11*t4*t40*t58*t59*t62+2.659615202676
     8         212d-1*t11*t132*t32*t41*t61+2.036213028372208d-3*t11*t114
     9         *t4*t41*t58*t59+1.527159771279156d-3*t102*t103*t11*t4*t40
     :         *t58*t59+4.072426056744416d-3*t11*t130*t4*t40*t41*t58-2.6
     ;         59615202676212d-1*t11*t128*t36*t40*t41+1.329807601338106d
     <         -1*t11*t175*t32*t40*t41-5.319230405352424d-1*t11*t132*t34
     =         *t36)+5.429901408992555d-3*t10*t11*t4*t41*t58*t68*t79-2.7
     >         149507044962773d-3*t10*t11*t4*t42*t58*t61*t62*t79+2.71495
     ?         07044962773d-3*t10*t11*t4*t58*t59*t61*t62*t68-3.546153603
     @         5682834d-1*t10*t11*t128*t32*t41*t68+1.7730768017841417d-1
     1         *t10*t11*t128*t32*t42*t61*t62+1.3574753522481386d-3*t10*t
     2         108*t11*t4*t42*t58*t59*t62-3.5461536035682834d-1*t10*t11*
     3         t133*t32*t41*t61-2.036213028372208d-3*t10*t102*t103*t11*t
     4         4*t42*t58*t59-2.7149507044962773d-3*t10*t11*t115*t4*t41*t
     5         58*t59-5.429901408992555d-3*t10*t11*t130*t4*t41*t42*t58+3
     6         .5461536035682834d-1*t10*t11*t128*t36*t41*t42-1.773076801
     7         7841417d-1*t10*t11*t175*t32*t41*t42+7.092307207136567d-1*
     8         t10*t11*t133*t34*t36)-1.531208745026941d-2*t116*t4*t58*t8
     9         1+2.0d+0*t134*t70+2.0d+0*t135*t69)*wght+Cmat3(iq,D3_RB_RB
     :         _GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = (1.0d+0*t8*(-3.5461536035682834d-1
     1         *t10*t11*t12*t14*(2.659615202676212d-1*t11*t12*t14*(-8.28
     2         6501183095146d-3*t137*t18*t20*t53*t87*t91*t95+2.344600220
     3         846979d-4*t137*t20*t48*t5*t87*t95+3.3146004732380585d-3*t
     4         137*t139*t18*t20*t87*t95+2.519651127593712d-4*t19*t20*t3*
     5         t53*t87*t89*t94+2.519651127593712d-4*t20*t3*t48*t52*t87*t
     6         89*t94-1.6573002366190293d-3*t137*t142*t18*t20*t48*t87*t9
     7         1+1.782288585882691d-5*t15*t20*t3*t53*t87*t89*t90-7.12414
     8         5724851911d-3*t17*t18*t20*t3*t52*t53*t87*t89-3.5645771717
     9         65382d-5*t15*t159*t21*t3*t87*t89-5.039302255187424d-4*t11
     :         8*t19*t20*t3*t87*t89-1.3552527156068805d-20*t137*t20*t5*t
     ;         52*t53*t87+4.685906023339492d-2*t1*t137*t141*t142*t20*t53
     <         *t87+2.710505431213761d-20*t137*t140*t20*t52*t87-1.531208
     =         7450269407d-2*t119*t20*t4*t45*t52*t74-1.5312087450269407d
     >         -2*t122*t19*t20*t4*t45*t74+4.3293907300401946d-1*t122*t18
     ?         *t20*t4*t45*t52*t73-1.0831086252292187d-3*t122*t15*t20*t4
     @         *t45*t72-3.536776513153214d-2*t15*t17*t179*t21-3.53677651
     1         3153214d-2*t13*t15*t17*t181*t20+t181*t20)-2.3499905492016
     2         226d-2*t137*t18*t20*t44*t50*t87*t91*t95+3.544907701811040
     3         3d+0*t20*t44*(9.473743137948445d-4*t23*t3*t49*t87*t89*t94
     4         -1.4210614706922667d-3*t23*t3*t48*t51*t86*t87*t89+6.61167
     5         1357066283d-4*t137*t23*t5*t86*t87-1.6529178392665705d-3*t
     6         137*t138*t139*t23*t48*t87+8.635885052955274d-2*t119*t23*t
     7         4*t45*t71*t86-1.8799712059732546d+0*rhoa*t179*t23*t49)+6.
     8         701302444388497d-5*t11*t22*t24*t3*t87*t89*t90-6.701302444
     9         388497d-5*t11*t118*t24*t3*t54*t87*t89-2.525443904885174d-
     :         2*t17*t18*t20*t3*t44*t50*t52*t87*t89+3.3506512221942486d-
     ;         5*t11*t118*t22*t3*t48*t49*t87*t89+2.3384003968359865d-5*t
     <         11*t137*t140*t22*t48*t86*t87-1.5589335978906577d-5*t11*t1
     =         37*t140*t49*t54*t87+1.661110435209891d-1*t1*t137*t141*t14
     >         2*t20*t44*t50*t87+1.5589335978906577d-5*t11*t137*t180*t22
     ?         *t49*t87-4.072426056744416d-3*t11*t24*t4*t45*t72*t75-2.03
     @         6213028372208d-3*t11*t4*t45*t46*t48*t49*t75+2.65961520267
     1         6212d-1*t11*t119*t12*t24*t75+1.534729054306881d+0*t120*t1
     2         8*t20*t4*t44*t45*t52*t73-2.036213028372208d-3*t11*t119*t2
     3         2*t4*t45*t46*t49+1.329807601338106d-1*t11*t12*t143*t24*t4
     4         8+4.072426056744416d-3*t11*t123*t24*t4*t45*t46+1.32980760
     5         1338106d-1*t11*t12*t179*t22*t24-2.659615202676212d-1*t11*
     6         t14*t143*t17)-8.935069925851332d-5*t10*t11*t24*t25*t3*t87
     7         *t89*t90+8.935069925851332d-5*t10*t11*t118*t24*t3*t55*t87
     8         *t89-4.467534962925666d-5*t10*t11*t118*t25*t3*t48*t49*t87
     9         *t89-3.1178671957813153d-5*t10*t11*t137*t140*t25*t48*t86*
     :         t87+2.078578130520877d-5*t10*t11*t137*t140*t49*t55*t87-2.
     ;         078578130520877d-5*t10*t11*t137*t180*t25*t49*t87+5.429901
     <         408992555d-3*t10*t11*t24*t4*t45*t72*t76+2.714950704496277
     =         3d-3*t10*t11*t4*t45*t46*t48*t49*t76-3.5461536035682834d-1
     >         *t10*t11*t119*t12*t24*t76+2.7149507044962773d-3*t10*t11*t
     ?         119*t25*t4*t45*t46*t49-1.7730768017841417d-1*t10*t11*t12*
     @         t144*t24*t48-5.429901408992555d-3*t10*t11*t124*t24*t4*t45
     1         *t46-1.7730768017841417d-1*t10*t11*t12*t179*t24*t25+3.546
     2         1536035682834d-1*t10*t11*t14*t144*t17)+5.039302255187424d
     3         -4*t3*t56*t87*t89*t94+1.0d+0*t26*(6.633861595060381d-5*ga
     4         mmaaa*t137*t155*t156*t178-2.0157209020749695d-3*t118*t3*t
     5         87*t89)+2.0d+0*t126*t77-3.062417490053882d-2*t125*t4*t45*
     6         t74+1.0d+0*t145*t57)*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_RB_GAA_GAA) = Cmat3(iq,D3_RB_GAA_GAA)
            Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
            Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = (1.0d+0*t31*(-3.5461536035682834d-
     1         1*t10*t11*t32*t34*(2.659615202676212d-1*t11*t32*t34*(-7.1
     2         24145724851911d-3*t105*t18*t3*t36*t38*t65*t66*t87-1.35525
     3         27156068805d-20*t146*t28*t38*t65*t66*t87+2.51965112759371
     4         2d-4*t105*t110*t3*t37*t38*t66*t87+1.782288585882691d-5*t1
     5         05*t106*t15*t3*t38*t66*t87+4.685906023339492d-2*t141*t146
     6         *t150*t27*t38*t66*t87-8.286501183095146d-3*t107*t111*t146
     7         *t18*t38*t66*t87+2.519651127593712d-4*t105*t110*t3*t38*t6
     8         1*t65*t87+2.710505431213761d-20*t146*t149*t38*t65*t87+2.3
     9         44600220846979d-4*t111*t146*t28*t38*t61*t87-1.65730023661
     :         90293d-3*t107*t146*t150*t18*t38*t61*t87-3.564577171765382
     ;         d-5*t105*t15*t166*t3*t39*t87-5.039302255187424d-4*t105*t1
     <         27*t3*t37*t38*t87+3.3146004732380585d-3*t111*t146*t148*t1
     =         8*t38*t87-1.5312087450269407d-2*t128*t38*t4*t58*t65*t81-1
     >         .5312087450269407d-2*t131*t37*t38*t4*t58*t81+4.3293907300
     ?         401946d-1*t131*t18*t38*t4*t58*t65*t80-1.0831086252292187d
     @         -3*t131*t15*t38*t4*t58*t79-3.536776513153214d-2*t15*t183*
     1         t36*t39-3.536776513153214d-2*t15*t185*t33*t36*t38+t185*t3
     2         8)+3.5449077018110403d+0*t38*t44*(-1.4210614706922667d-3*
     3         t103*t105*t23*t3*t61*t64*t87+9.473743137948445d-4*t105*t1
     4         10*t23*t3*t62*t87-1.6529178392665705d-3*t146*t147*t148*t2
     5         3*t61*t87+6.611671357066283d-4*t103*t146*t23*t28*t87+8.63
     6         5885052955274d-2*t103*t128*t23*t4*t58*t78-1.8799712059732
     7         546d+0*rhob*t183*t23*t62)-1.5589335978906577d-5*t11*t146*
     8         t149*t62*t67*t87-6.701302444388497d-5*t105*t11*t127*t3*t4
     9         1*t67*t87-2.525443904885174d-2*t105*t18*t3*t36*t38*t44*t6
     :         3*t65*t87+1.661110435209891d-1*t141*t146*t150*t27*t38*t44
     ;         *t63*t87-2.3499905492016226d-2*t107*t111*t146*t18*t38*t44
     <         *t63*t87+3.3506512221942486d-5*t105*t11*t127*t3*t40*t61*t
     =         62*t87+1.5589335978906577d-5*t11*t146*t184*t40*t62*t87+2.
     >         3384003968359865d-5*t103*t11*t146*t149*t40*t61*t87+6.7013
     ?         02444388497d-5*t105*t106*t11*t3*t40*t41*t87-4.07242605674
     @         4416d-3*t11*t4*t41*t58*t79*t82-2.036213028372208d-3*t11*t
     1         4*t58*t59*t61*t62*t82+2.659615202676212d-1*t11*t128*t32*t
     2         41*t82+1.534729054306881d+0*t129*t18*t38*t4*t44*t58*t65*t
     3         80-2.036213028372208d-3*t11*t128*t4*t40*t58*t59*t62+1.329
     4         807601338106d-1*t11*t151*t32*t41*t61+4.072426056744416d-3
     5         *t11*t132*t4*t41*t58*t59+1.329807601338106d-1*t11*t183*t3
     6         2*t40*t41-2.659615202676212d-1*t11*t151*t34*t36)+2.078578
     7         130520877d-5*t10*t11*t146*t149*t62*t68*t87+8.935069925851
     8         332d-5*t10*t105*t11*t127*t3*t41*t68*t87-4.467534962925666
     9         d-5*t10*t105*t11*t127*t3*t42*t61*t62*t87-2.07857813052087
     :         7d-5*t10*t11*t146*t184*t42*t62*t87-3.1178671957813153d-5*
     ;         t10*t103*t11*t146*t149*t42*t61*t87-8.935069925851332d-5*t
     <         10*t105*t106*t11*t3*t41*t42*t87+5.429901408992555d-3*t10*
     =         t11*t4*t41*t58*t79*t83+2.7149507044962773d-3*t10*t11*t4*t
     >         58*t59*t61*t62*t83-3.5461536035682834d-1*t10*t11*t128*t32
     ?         *t41*t83+2.7149507044962773d-3*t10*t11*t128*t4*t42*t58*t5
     @         9*t62-1.7730768017841417d-1*t10*t11*t152*t32*t41*t61-5.42
     1         9901408992555d-3*t10*t11*t133*t4*t41*t58*t59-1.7730768017
     2         841417d-1*t10*t11*t183*t32*t41*t42+3.5461536035682834d-1*
     3         t10*t11*t152*t34*t36)+1.0d+0*t43*(6.633861595060381d-5*ga
     4         mmabb*t146*t155*t156*t182-2.0157209020749695d-3*t105*t127
     5         *t3*t87)+5.039302255187424d-4*t105*t110*t3*t69*t87+2.0d+0
     6         *t135*t84-3.062417490053882d-2*t134*t4*t58*t81+1.0d+0*t15
     7         3*t70)*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = (1.0d+0*t8*(-3.5461536035682834d-
     1         1*t10*t11*t12*t14*(2.659615202676212d-1*t11*t12*t14*(4.15
     2         03496197175305d-22*t156*t187*t20*t94*t95+8.18141567605465
     3         5d-4*t156*t18*t188*t20*t3*t72*t95-4.6264815690944017d-3*t
     4         141*t142*t156*t188*t20*t3*t74+1.6940658945086007d-21*t156
     5         *t172*t188*t20*t3*t52+3.5169003312704855d-4*t137*t155*t15
     6         6*t18*t180*t20*t52-8.798432205344503d-7*t137*t15*t155*t15
     7         6*t170*t21-1.2438490490738213d-5*t137*t155*t156*t19*t191*
     8         t20+1.0143559049642756d-2*t156*t16*t187*t190*t20/t13**6+3
     9         .8065089231694144d-4*t142*t156*t17*t18*t187*t20-4.6638151
     :         82852701d-3*t141*t156*t187*t20/t13**5)-2.0103907333165494
     ;         d-4*t11*t118*t24*t3*t75*t87*t89-4.676800793671973d-5*t11*
     <         t137*t140*t49*t75*t87-2.3140538016976683d-4*t121*t156*t18
     =         8*t20*t23*t3*t44*t86+3.580579137009732d-7*t11*t118*t156*t
     >         187*t22*t86-8.972027574067322d-5*t138*t156*t187*t20*t23*t
     ?         44*t51-1.6578827153323844d-4*t137*t155*t156*t20*t23*t44*t
     @         49/rhoa**5.666666666666667d+0+1.5391639358877124d-6*t11*t
     1         156*t188*t189*t22*t3*t49+6.108639085116625d-3*t11*t143*t2
     2         4*t4*t45*t46+2.1809443270274873d-3*t136*t138*t156*t188*t2
     3         0*t3*t44*t46-4.781719592912377d-3*rhoa*t156*t186*t187*t20
     4         *t44/t14**11+1.6911873548697043d-3*t12*t136*t156*t187*t20
     5         *t44/t14**9+3.3081598407510854d-6*t11*t137*t155*t156*t178
     6         *t22*t24)+2.6805209777553995d-4*t10*t11*t118*t24*t3*t76*t
     7         87*t89+6.235734391562631d-5*t10*t11*t137*t140*t49*t76*t87
     8         -4.774105516012976d-7*t10*t11*t118*t156*t187*t25*t86-2.05
     9         2218581183617d-6*t10*t11*t156*t188*t189*t25*t3*t49-8.1448
     :         52113488832d-3*t10*t11*t144*t24*t4*t45*t46-4.410879787668
     ;         1144d-6*t10*t11*t137*t155*t156*t178*t24*t25)+1.5117906765
     <         562272d-3*t3*t77*t87*t89*t94-4.5936262350808227d-2*t145*t
     =         4*t45*t74-2.4876980981476426d-5*t137*t155*t156*t191*t26)*
     >         wght+Cmat3(iq,D3_GAA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = (1.0d+0*t31*(-3.5461536035682834d
     1         -1*t10*t11*t32*t34*(-4.676800793671973d-5*t11*t146*t149*t
     2         62*t82*t87-2.0103907333165494d-4*t105*t11*t127*t3*t41*t82
     3         *t87+2.659615202676212d-1*t11*t32*t34*(-4.626481569094401
     4         7d-3*t141*t150*t156*t193*t3*t38*t81+8.181415676054655d-4*
     5         t111*t156*t18*t193*t3*t38*t79+1.6940658945086007d-21*t156
     6         *t176*t193*t3*t38*t65+3.5169003312704855d-4*t146*t155*t15
     7         6*t18*t184*t38*t65-8.798432205344503d-7*t146*t15*t155*t15
     8         6*t174*t39-1.2438490490738213d-5*t146*t155*t156*t195*t37*
     9         t38+3.8065089231694144d-4*t150*t156*t18*t192*t36*t38+1.01
     :         43559049642756d-2*t156*t190*t192*t35*t38/t33**6-4.6638151
     ;         82852701d-3*t141*t156*t192*t38/t33**5+4.1503496197175305d
     <         -22*t110*t111*t156*t192*t38)-8.972027574067322d-5*t147*t1
     =         56*t192*t23*t38*t44*t64-1.6578827153323844d-4*t146*t155*t
     >         156*t23*t38*t44*t62/rhob**5.666666666666667d+0+1.53916393
     ?         58877124d-6*t11*t156*t193*t194*t3*t40*t62+6.1086390851166
     @         25d-3*t11*t151*t4*t41*t58*t59+2.1809443270274873d-3*t136*
     1         t147*t156*t193*t3*t38*t44*t59+1.6911873548697043d-3*t136*
     2         t156*t192*t32*t38*t44/t34**9-4.781719592912377d-3*rhob*t1
     3         56*t186*t192*t38*t44/t34**11-2.3140538016976683d-4*t103*t
     4         130*t156*t193*t23*t3*t38*t44+3.3081598407510854d-6*t11*t1
     5         46*t155*t156*t182*t40*t41+3.580579137009732d-7*t103*t11*t
     6         127*t156*t192*t40)+6.235734391562631d-5*t10*t11*t146*t149
     7         *t62*t83*t87+2.6805209777553995d-4*t10*t105*t11*t127*t3*t
     8         41*t83*t87-2.052218581183617d-6*t10*t11*t156*t193*t194*t3
     9         *t42*t62-8.144852113488832d-3*t10*t11*t152*t4*t41*t58*t59
     :         -4.4108797876681144d-6*t10*t11*t146*t155*t156*t182*t41*t4
     ;         2-4.774105516012976d-7*t10*t103*t11*t127*t156*t192*t42)+1
     <         .5117906765562272d-3*t105*t110*t3*t84*t87-4.5936262350808
     =         227d-2*t153*t4*t58*t81-2.4876980981476426d-5*t146*t155*t1
     >         56*t195*t43)*wght+Cmat3(iq,D3_GBB_GBB_GBB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**1.3333333333333333d+0
            t2 = param(1)
            t3 = 1/t2
            t4 = param(2)
            t5 = 1/rhoa**2.6666666666666666d+0
            t6 = 1.6455307846020564d-2*gammaaa*t3*t4*t5+1.0d+0
            t7 = 1.0d+0-1.0d+0/t6
            t8 = -9.305257363491d-1*t1*t2*t7-9.305257363491d-1*t1
            t9 = param(4)
            t10 = param(5)
            t11 = 1/rhoa
            t12 = 9.305257363491d-1*t1*t2*t7+9.305257363491d-1*t1
            t13 = t12**5.0d-1
            t14 = t10**2
            t15 = rhoa**2
            t16 = 1/t15
            t17 = 1/t14
            t18 = 1/t12
            t19 = exp(-1.413716694115413d+1*t15*t17*t18)
            t20 = t19-1.0d+0
            t21 = -3.536776513153214d-2*t12*t14*t16*t20+t19-1.5d+0
            t22 = 1/t10
            t23 = 1/t13
            t24 = 1.7724538509055202d+0*erf(3.759942411946509d+0*rhoa*t2
     1         2*t23)+2.659615202676212d-1*t10*t11*t13*t21
            t25 = -3.5461536035682834d-1*t10*t11*t13*t24*t9-param(3)+1.0
     1         d+0
            t26 = 5.641895835477563d-1
            t27 = 1/t6**2
            t28 = 1/rhoa**2.3333333333333334d+0
            t29 = rhoa**3.333333333333333d-1
            t30 = 1.2407009817987999d+0*t2*t29*t7-4.0832233200718415d-2*
     1         gammaaa*t27*t28*t4+1.2407009817987999d+0*t29
            t31 = 1/t13**3
            t32 = 3.759942411946509d+0*t22*t23-1.8799712059732546d+0*rho
     1         a*t22*t30*t31
            t33 = 1/rhoa**3
            t34 = 1/t12**2
            t35 = 1.413716694115413d+1*t15*t17*t30*t34-2.827433388230826
     1         d+1*rhoa*t17*t18
            t36 = -3.536776513153214d-2*t12*t14*t16*t19*t35+t19*t35+7.07
     1         3553026306428d-2*t12*t14*t20*t33-3.536776513153214d-2*t14
     2         *t16*t20*t30
            t37 = 2.659615202676212d-1*t10*t11*t13*t36+3.544907701811040
     1         3d+0*t19*t26*t32+1.329807601338106d-1*t10*t11*t21*t23*t30
     2         -2.659615202676212d-1*t10*t13*t16*t21
            t38 = -3.5461536035682834d-1*t10*t11*t13*t37*t9-1.7730768017
     1         841417d-1*t10*t11*t23*t24*t30*t9+3.5461536035682834d-1*t1
     2         0*t13*t16*t24*t9
            t39 = -1.2407009817987999d+0*t2*t29*t7+4.0832233200718415d-2
     1         *gammaaa*t27*t28*t4-1.2407009817987999d+0*t29
            t40 = 1/t29
            t41 = 1/rhoa**3.3333333333333337d+0
            t42 = rhoa**6.666666666666666d-1
            t43 = 1/t1
            t44 = -7.656043725134704d-3*t18*t19*t27*t4*t43+2.16469536502
     1         00973d-1*t17*t19*t27*t34*t4*t42-5.415543126146093d-4*t14*
     2         t20*t27*t4*t41
            t45 = 2.659615202676212d-1*t10*t11*t13*t44-1.020447181205866
     1         6d-1*t19*t22*t26*t27*t31*t4*t40+2.036213028372208d-3*t10*
     2         t21*t23*t27*t28*t4
            t46 = -3.5461536035682834d-1*t10*t11*t13*t45*t9-2.7149507044
     1         962773d-3*t10*t23*t24*t27*t28*t4*t9
            t47 = t30**2
            t48 = 1/t13**5
            t49 = t4**2
            t50 = gammaaa**2
            t51 = 1/t6**3
            t52 = 1/rhoa**6
            t53 = 1/t42
            t54 = 4.135669939329333d-1*t2*t53*t7+4.135669939329333d-1*t5
     1         3-3.5835038259110563d-3*t3*t49*t50*t51*t52+4.083223320071
     2         8415d-2*gammaaa*t27*t4*t41
            t55 = -1.8799712059732546d+0*rhoa*t22*t31*t54+2.819956808959
     1         8814d+0*rhoa*t22*t47*t48-3.759942411946509d+0*t22*t30*t31
            t56 = 1/rhoa**4
            t57 = 1/t12**3
            t58 = -2.827433388230826d+1*t15*t17*t47*t57+1.41371669411541
     1         3d+1*t15*t17*t34*t54+5.654866776461652d+1*rhoa*t17*t30*t3
     2         4-2.827433388230826d+1*t17*t18
            t59 = t35**2
            t60 = -3.536776513153214d-2*t12*t14*t16*t19*t59+t19*t59-3.53
     1         6776513153214d-2*t12*t14*t16*t19*t58+t19*t58-2.1220659078
     2         919285d-1*t12*t14*t20*t56-3.536776513153214d-2*t14*t16*t2
     3         0*t54+1.4147106052612857d-1*t12*t14*t19*t33*t35-7.0735530
     4         26306428d-2*t14*t16*t19*t30*t35+1.4147106052612857d-1*t14
     5         *t20*t30*t33
            t61 = 2.659615202676212d-1*t10*t11*t13*t60+3.544907701811040
     1         3d+0*t19*t26*t55+1.329807601338106d-1*t10*t11*t21*t23*t54
     2         -6.649038006690531d-2*t10*t11*t21*t31*t47+2.6596152026762
     3         12d-1*t10*t11*t23*t30*t36-5.319230405352424d-1*t10*t13*t1
     4         6*t36+3.5449077018110403d+0*t19*t26*t32*t35+5.31923040535
     5         2424d-1*t10*t13*t21*t33-2.659615202676212d-1*t10*t16*t21*
     6         t23*t30
            t62 = -3.5461536035682834d-1*t10*t11*t13*t61*t9-1.7730768017
     1         841417d-1*t10*t11*t23*t24*t54*t9+8.865384008920708d-2*t10
     2         *t11*t24*t31*t47*t9-3.5461536035682834d-1*t10*t11*t23*t30
     3         *t37*t9+7.092307207136567d-1*t10*t13*t16*t37*t9-7.0923072
     4         07136567d-1*t10*t13*t24*t33*t9+3.5461536035682834d-1*t10*
     5         t16*t23*t24*t30*t9
            t63 = -4.135669939329333d-1*t2*t53*t7-4.135669939329333d-1*t
     1         53+3.5835038259110563d-3*t3*t49*t50*t51*t52-4.08322332007
     2         18415d-2*gammaaa*t27*t4*t41
            t64 = 1/rhoa**5
            t65 = 1.3438139347166464d-3*gammaaa*t3*t49*t51*t64-2.0416116
     1         600359205d-2*t27*t28*t4
            t66 = -1.8799712059732546d+0*rhoa*t22*t31*t65+4.317942526477
     1         637d-2*t22*t27*t30*t4*t40*t48-2.878628350985092d-2*t22*t2
     2         7*t31*t4*t43
            t67 = 1/rhoa**4.333333333333333d+0
            t68 = 1.413716694115413d+1*t15*t17*t34*t65-4.329390730040194
     1         6d-1*t17*t27*t30*t4*t42*t57+4.3293907300401946d-1*t17*t27
     2         *t34*t4*t40
            t69 = -3.536776513153214d-2*t12*t14*t16*t19*t68+t19*t68+1.08
     1         31086252292187d-3*t14*t20*t27*t4*t67-3.536776513153214d-2
     2         *t14*t16*t20*t65-7.656043725134704d-3*t18*t19*t27*t35*t4*
     3         t43-7.656043725134704d-3*t19*t27*t30*t34*t4*t43+2.1646953
     4         650200973d-1*t17*t19*t27*t34*t35*t4*t42-5.415543126146093
     5         d-4*t14*t19*t27*t35*t4*t41+1.5312087450269407d-2*t18*t19*
     6         t27*t28*t4
            t70 = 2.659615202676212d-1*t10*t11*t13*t69+3.544907701811040
     1         3d+0*t19*t26*t66+1.329807601338106d-1*t10*t11*t21*t23*t65
     2         +1.329807601338106d-1*t10*t11*t23*t30*t44-2.6596152026762
     3         12d-1*t10*t13*t16*t44+7.673645271534404d-1*t17*t19*t26*t2
     4         7*t32*t34*t4*t42-2.036213028372208d-3*t10*t21*t23*t27*t4*
     5         t41+2.036213028372208d-3*t10*t23*t27*t28*t36*t4-1.0181065
     6         14186104d-3*t10*t21*t27*t28*t30*t31*t4
            t71 = -3.5461536035682834d-1*t10*t11*t13*t70*t9-1.7730768017
     1         841417d-1*t10*t11*t23*t24*t65*t9-1.7730768017841417d-1*t1
     2         0*t11*t23*t30*t45*t9+3.5461536035682834d-1*t10*t13*t16*t4
     3         5*t9+2.7149507044962773d-3*t10*t23*t24*t27*t4*t41*t9-2.71
     4         49507044962773d-3*t10*t23*t27*t28*t37*t4*t9+1.35747535224
     5         81386d-3*t10*t24*t27*t28*t30*t31*t4*t9
            t72 = 2.0416116600359205d-2*t27*t28*t4-1.3438139347166464d-3
     1         *gammaaa*t3*t49*t51*t64
            t73 = 1/t10**3
            t74 = 1/t6**4
            t75 = 1/t13**7
            t76 = 1/rhoa**1.6666666666666669d+0
            t77 = 1/rhoa**3.6666666666666664d+0
            t78 = 1/t10**4
            t79 = 1/t12**4
            t80 = 4.685906023339492d-2*t1*t19*t49*t74*t78*t79-8.28650118
     1         3095146d-3*t17*t19*t49*t53*t57*t74-1.3552527156068805d-20
     2         *t19*t34*t49*t5*t74+2.519651127593712d-4*t18*t19*t3*t49*t
     3         51*t56+1.782288585882691d-5*t14*t20*t3*t49*t51*t52-7.1241
     4         45724851911d-3*t16*t17*t19*t3*t34*t49*t51
            t81 = 2.659615202676212d-1*t10*t11*t13*t80-1.558933597890657
     1         7d-5*t10*t21*t31*t49*t74*t77+2.3437764715507717d-3*t19*t2
     2         2*t26*t48*t49*t74*t76-2.2089572834041626d-2*t19*t26*t29*t
     3         49*t73*t74*t75-6.701302444388497d-5*t10*t21*t23*t3*t49*t5
     4         1*t64+3.3583545014692934d-3*t19*t22*t26*t3*t31*t33*t49*t5
     5         1+4.072426056744416d-3*t10*t23*t27*t28*t4*t44
            t82 = -3.5461536035682834d-1*t10*t11*t13*t81*t9+2.0785781305
     1         20877d-5*t10*t24*t31*t49*t74*t77*t9+8.935069925851332d-5*
     2         t10*t23*t24*t3*t49*t51*t64*t9-5.429901408992555d-3*t10*t2
     3         3*t27*t28*t4*t45*t9
            t83 = t30**3
            t84 = 1/t2**2
            t85 = t4**3
            t86 = gammaaa**3
            t87 = 1/rhoa**9.666666666666666d+0
            t88 = 1/rhoa**7
            t89 = 2.50845267813774d-2*t3*t49*t50*t51*t88-4.7174126898207
     1         14d-4*t74*t84*t85*t86*t87-2.757113292886222d-1*t2*t7*t76-
     2         2.757113292886222d-1*t76-1.5425510320271402d-1*gammaaa*t2
     3         7*t4*t67
            t90 = 1.413716694115413d+1*t15*t17*t34*t89+8.482300164692478
     1         d+1*t15*t17*t79*t83-8.482300164692478d+1*t15*t17*t30*t54*
     2         t57-1.6964600329384957d+2*rhoa*t17*t47*t57+8.482300164692
     3         478d+1*rhoa*t17*t34*t54+8.482300164692478d+1*t17*t30*t34
            t91 = t35**3
            t92 = 1/rhoa**8.666666666666666d+0
            t93 = 1.7690297586827677d-4*t50*t74*t84*t85*t92-8.5108215865
     1         3876d-3*gammaaa*t3*t49*t51*t52+4.7637605400838157d-2*t27*
     2         t4*t41
            t94 = 1/rhoa**5.333333333333333d+0
            t95 = 1.413716694115413d+1*t15*t17*t34*t93+1.298817219012058
     1         4d+0*t17*t27*t4*t42*t47*t79-5.654866776461652d+1*t15*t17*
     2         t30*t57*t65+5.654866776461652d+1*rhoa*t17*t34*t65-4.32939
     3         07300401946d-1*t17*t27*t4*t42*t54*t57-1.7317562920160778d
     4         +0*t17*t27*t30*t4*t40*t57+4.3293907300401946d-1*t17*t27*t
     5         34*t4*t43
            t96 = 1/rhoa**7.666666666666667d+0
            t97 = 2.0157209020749695d-3*t3*t49*t51*t64-6.633861595060381
     1         d-5*gammaaa*t74*t84*t85*t96
            t98 = 1/rhoa**4.666666666666667d+0
            t99 = 1.413716694115413d+1*t15*t17*t34*t97+1.988760283942835
     1         3d-2*t17*t30*t49*t53*t74*t79-1.3258401892952237d-2*t17*t4
     2         9*t57*t74*t76-8.658781460080389d-1*t17*t27*t4*t42*t57*t65
     3         +1.4248291449703823d-2*t16*t17*t3*t30*t49*t51*t57-1.42482
     4         91449703823d-2*t17*t3*t33*t34*t49*t51
            t100 = 1/t6**6
            t101 = 1/t6**5
            t102 = 1/rhoa**6.333333333333333d+0
            t103 = 1/rhoa**6.666666666666667d+0
            fnc(iq) = 1.0d+0*t25*t8*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t38*t8*wght+1.0d+0*t25*t39*wght+Amat
     1         (iq,D1_RA)
            Cmat(iq,D1_GAA) = 1.0d+0*t46*t8*wght-1.531208745026941d-2*t2
     1         5*t27*t4*t43*wght+Cmat(iq,D1_GAA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*t62*t8*wght+1.0d+0*t25*t63*wght+
     1         2.0d+0*t38*t39*wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = 1.0d+0*t71*t8*wght+1.0d+0*t25*t72*wght
     1         +1.0d+0*t39*t46*wght-1.531208745026941d-2*t27*t38*t4*t43*
     2         wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = 1.0d+0*t8*t82*wght+5.039302255187424d
     1         -4*t25*t3*t49*t51*t56*wght-3.062417490053882d-2*t27*t4*t4
     2         3*t46*wght+Cmat2(iq,D2_GAA_GAA)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*t8*(-3.5461536035682834d-1*t1
     1         0*t11*t13*t9*(2.659615202676212d-1*t10*t11*t13*(-3.536776
     2         513153214d-2*t12*t14*t16*t19*t91+t19*t91-3.53677651315321
     3         4d-2*t12*t14*t16*t19*t90+t19*t90-3.536776513153214d-2*t14
     4         *t16*t20*t89+8.488263631567714d-1*t12*t14*t20*t64+2.12206
     5         59078919285d-1*t12*t14*t19*t33*t59-1.0610329539459643d-1*
     6         t14*t16*t19*t30*t59-1.0610329539459643d-1*t12*t14*t16*t19
     7         *t35*t58+3*t19*t35*t58+2.1220659078919285d-1*t12*t14*t19*
     8         t33*t58-1.0610329539459643d-1*t14*t16*t19*t30*t58-6.36619
     9         7723675786d-1*t12*t14*t19*t35*t56-6.366197723675786d-1*t1
     :         4*t20*t30*t56-1.0610329539459643d-1*t14*t16*t19*t35*t54+2
     ;         .1220659078919285d-1*t14*t20*t33*t54+4.244131815783857d-1
     <         *t14*t19*t30*t33*t35)+3.5449077018110403d+0*t19*t26*(-1.8
     =         799712059732546d+0*rhoa*t22*t31*t89-7.049892022399704d+0*
     >         rhoa*t22*t75*t83+8.459870426879645d+0*rhoa*t22*t30*t48*t5
     ?         4-5.639913617919763d+0*t22*t31*t54+8.459870426879645d+0*t
     @         22*t47*t48)+1.329807601338106d-1*t10*t11*t21*t23*t89+9.97
     1         3557010035795d-2*t10*t11*t21*t48*t83+3.989422804014318d-1
     2         *t10*t11*t23*t30*t60-7.978845608028636d-1*t10*t13*t16*t60
     3         +3.5449077018110403d+0*t19*t26*t32*t59+3.5449077018110403
     4         d+0*t19*t26*t32*t58-1.5957691216057274d+0*t10*t13*t21*t56
     5         +7.089815403622081d+0*t19*t26*t35*t55+3.989422804014318d-
     6         1*t10*t11*t23*t36*t54-1.994711402007159d-1*t10*t11*t21*t3
     7         0*t31*t54-3.989422804014318d-1*t10*t16*t21*t23*t54-1.9947
     8         11402007159d-1*t10*t11*t31*t36*t47+1.994711402007159d-1*t
     9         10*t16*t21*t31*t47+1.5957691216057274d+0*t10*t13*t33*t36-
     :         7.978845608028636d-1*t10*t16*t23*t30*t36+7.97884560802863
     ;         6d-1*t10*t21*t23*t30*t33)-1.7730768017841417d-1*t10*t11*t
     <         23*t24*t89*t9-1.3298076013381063d-1*t10*t11*t24*t48*t83*t
     =         9-5.319230405352425d-1*t10*t11*t23*t30*t61*t9+1.063846081
     >         070485d+0*t10*t13*t16*t61*t9+2.12769216214097d+0*t10*t13*
     ?         t24*t56*t9-5.319230405352425d-1*t10*t11*t23*t37*t54*t9+2.
     @         6596152026762127d-1*t10*t11*t24*t30*t31*t54*t9+5.31923040
     1         5352425d-1*t10*t16*t23*t24*t54*t9+2.6596152026762127d-1*t
     2         10*t11*t31*t37*t47*t9-2.6596152026762127d-1*t10*t16*t24*t
     3         31*t47*t9-2.12769216214097d+0*t10*t13*t33*t37*t9+1.063846
     4         081070485d+0*t10*t16*t23*t30*t37*t9-1.063846081070485d+0*
     5         t10*t23*t24*t30*t33*t9)*wght+1.0d+0*t25*(-2.5084526781377
     6         4d-2*t3*t49*t50*t51*t88+4.717412689820714d-4*t74*t84*t85*
     7         t86*t87+2.757113292886222d-1*t2*t7*t76+2.757113292886222d
     8         -1*t76+1.5425510320271402d-1*gammaaa*t27*t4*t67)*wght+3.0
     9         d+0*t38*t63*wght+3.0d+0*t39*t62*wght+Amat3(iq,D3_RA_RA_RA
     :         )
            Cmat3(iq,D3_RA_RA_GAA) = 1.0d+0*t8*(-3.5461536035682834d-1*t
     1         10*t11*t13*t9*(2.659615202676212d-1*t10*t11*t13*(-3.53677
     2         6513153214d-2*t12*t14*t16*t19*t95+t19*t95-3.2493258756876
     3         56d-3*t14*t20*t27*t4*t94-3.536776513153214d-2*t14*t16*t20
     4         *t93-7.073553026306428d-2*t12*t14*t16*t19*t35*t68+2*t19*t
     5         35*t68+1.4147106052612857d-1*t12*t14*t19*t33*t68-7.073553
     6         026306428d-2*t14*t16*t19*t30*t68+2.1662172504584373d-3*t1
     7         4*t19*t27*t35*t4*t67-7.073553026306428d-2*t14*t16*t19*t35
     8         *t65+1.4147106052612857d-1*t14*t20*t33*t65-7.656043725134
     9         704d-3*t18*t19*t27*t4*t43*t59+2.1646953650200973d-1*t17*t
     :         19*t27*t34*t4*t42*t59-5.415543126146093d-4*t14*t19*t27*t4
     ;         *t41*t59-7.656043725134704d-3*t18*t19*t27*t4*t43*t58+2.16
     <         46953650200973d-1*t17*t19*t27*t34*t4*t42*t58-5.4155431261
     =         46093d-4*t14*t19*t27*t4*t41*t58-7.656043725134704d-3*t19*
     >         t27*t34*t4*t43*t54-1.5312087450269407d-2*t19*t27*t30*t34*
     ?         t35*t4*t43-4.593626235080822d-2*t18*t19*t27*t4*t41+3.0624
     @         174900538814d-2*t18*t19*t27*t28*t35*t4+3.0624174900538814
     1         d-2*t19*t27*t28*t30*t34*t4)+3.5449077018110403d+0*t19*t26
     2         *(-1.8799712059732546d+0*rhoa*t22*t31*t93-1.0794856316194
     3         094d-1*t22*t27*t4*t40*t47*t75+5.639913617919763d+0*rhoa*t
     4         22*t30*t48*t65-3.759942411946509d+0*t22*t31*t65+4.3179425
     5         26477637d-2*t22*t27*t4*t40*t48*t54+8.635885052955274d-2*t
     6         22*t27*t30*t4*t43*t48)+1.329807601338106d-1*t10*t11*t21*t
     7         23*t93+2.659615202676212d-1*t10*t11*t23*t30*t69-5.3192304
     8         05352424d-1*t10*t13*t16*t69+3.5449077018110403d+0*t19*t26
     9         *t32*t68+4.072426056744416d-3*t10*t21*t23*t27*t4*t67+3.54
     :         49077018110403d+0*t19*t26*t35*t66+2.659615202676212d-1*t1
     ;         0*t11*t23*t36*t65-1.329807601338106d-1*t10*t11*t21*t30*t3
     <         1*t65-2.659615202676212d-1*t10*t16*t21*t23*t65+2.03621302
     =         8372208d-3*t10*t23*t27*t28*t4*t60+7.673645271534404d-1*t1
     >         7*t19*t26*t27*t34*t4*t42*t55+1.329807601338106d-1*t10*t11
     ?         *t23*t44*t54-1.018106514186104d-3*t10*t21*t27*t28*t31*t4*
     @         t54+1.527159771279156d-3*t10*t21*t27*t28*t4*t47*t48-6.649
     1         038006690531d-2*t10*t11*t31*t44*t47+5.319230405352424d-1*
     2         t10*t13*t33*t44-2.659615202676212d-1*t10*t16*t23*t30*t44+
     3         7.673645271534404d-1*t17*t19*t26*t27*t32*t34*t35*t4*t42-4
     4         .072426056744416d-3*t10*t23*t27*t36*t4*t41+2.036213028372
     5         208d-3*t10*t21*t27*t30*t31*t4*t41-2.036213028372208d-3*t1
     6         0*t27*t28*t30*t31*t36*t4)-1.7730768017841417d-1*t10*t11*t
     7         23*t24*t9*t93-3.5461536035682834d-1*t10*t11*t23*t30*t70*t
     8         9+7.092307207136567d-1*t10*t13*t16*t70*t9-5.4299014089925
     9         55d-3*t10*t23*t24*t27*t4*t67*t9-3.5461536035682834d-1*t10
     :         *t11*t23*t37*t65*t9+1.7730768017841417d-1*t10*t11*t24*t30
     ;         *t31*t65*t9+3.5461536035682834d-1*t10*t16*t23*t24*t65*t9-
     <         2.7149507044962773d-3*t10*t23*t27*t28*t4*t61*t9-1.7730768
     =         017841417d-1*t10*t11*t23*t45*t54*t9+1.3574753522481386d-3
     >         *t10*t24*t27*t28*t31*t4*t54*t9-2.036213028372208d-3*t10*t
     ?         24*t27*t28*t4*t47*t48*t9+8.865384008920708d-2*t10*t11*t31
     @         *t45*t47*t9-7.092307207136567d-1*t10*t13*t33*t45*t9+3.546
     1         1536035682834d-1*t10*t16*t23*t30*t45*t9+5.429901408992555
     2         d-3*t10*t23*t27*t37*t4*t41*t9-2.7149507044962773d-3*t10*t
     3         24*t27*t30*t31*t4*t41*t9+2.7149507044962773d-3*t10*t27*t2
     4         8*t30*t31*t37*t4*t9)*wght+1.0d+0*t25*(-1.7690297586827677
     5         d-4*t50*t74*t84*t85*t92+8.51082158653876d-3*gammaaa*t3*t4
     6         9*t51*t52-4.7637605400838157d-2*t27*t4*t41)*wght+2.0d+0*t
     7         38*t72*wght+2.0d+0*t39*t71*wght+1.0d+0*t46*t63*wght-1.531
     8         208745026941d-2*t27*t4*t43*t62*wght+Cmat3(iq,D3_RA_RA_GAA
     9         )
            Cmat3(iq,D3_RA_GAA_GAA) = 1.0d+0*t8*(-3.5461536035682834d-1*
     1         t10*t11*t13*t9*(2.659615202676212d-1*t10*t11*t13*(-3.5367
     2         76513153214d-2*t12*t14*t16*t19*t99+t19*t99-3.536776513153
     3         214d-2*t14*t16*t20*t97-3.564577171765382d-5*t14*t20*t3*t4
     4         9*t51*t88+4.685906023339492d-2*t1*t19*t35*t49*t74*t78*t79
     5         -1.6573002366190293d-3*t17*t19*t30*t49*t53*t74*t79+2.7105
     6         05431213761d-20*t19*t34*t49*t74*t77+3.3146004732380585d-3
     7         *t17*t19*t49*t57*t74*t76-8.286501183095146d-3*t17*t19*t35
     8         *t49*t53*t57*t74+2.344600220846979d-4*t19*t30*t49*t5*t57*
     9         t74-1.3552527156068805d-20*t19*t34*t35*t49*t5*t74-1.53120
     :         87450269407d-2*t18*t19*t27*t4*t43*t68+4.3293907300401946d
     ;         -1*t17*t19*t27*t34*t4*t42*t68-1.0831086252292187d-3*t14*t
     <         19*t27*t4*t41*t68-1.5312087450269407d-2*t19*t27*t34*t4*t4
     =         3*t65-5.039302255187424d-4*t18*t19*t3*t49*t51*t64+2.51965
     >         1127593712d-4*t18*t19*t3*t35*t49*t51*t56+2.51965112759371
     ?         2d-4*t19*t3*t30*t34*t49*t51*t56+1.782288585882691d-5*t14*
     @         t19*t3*t35*t49*t51*t52-7.124145724851911d-3*t16*t17*t19*t
     1         3*t34*t35*t49*t51)+1.5589335978906577d-5*t10*t21*t31*t49*
     2         t74*t98+3.5449077018110403d+0*t19*t26*(-1.879971205973254
     3         6d+0*rhoa*t22*t31*t97-1.6529178392665705d-3*t22*t30*t49*t
     4         74*t75*t76+6.611671357066283d-4*t22*t48*t49*t5*t74+8.6358
     5         85052955274d-2*t22*t27*t4*t40*t48*t65+9.473743137948445d-
     6         4*t22*t3*t31*t49*t51*t56-1.4210614706922667d-3*t22*t3*t30
     7         *t33*t48*t49*t51)+1.329807601338106d-1*t10*t11*t21*t23*t9
     8         7+1.329807601338106d-1*t10*t11*t23*t30*t80-2.659615202676
     9         212d-1*t10*t13*t16*t80+1.661110435209891d-1*t1*t19*t26*t3
     :         2*t49*t74*t78*t79+2.3384003968359865d-5*t10*t21*t30*t48*t
     ;         49*t74*t77-1.5589335978906577d-5*t10*t31*t36*t49*t74*t77-
     <         2.3499905492016226d-2*t17*t19*t26*t32*t49*t53*t57*t74+4.0
     =         72426056744416d-3*t10*t23*t27*t28*t4*t69+1.53472905430688
     >         1d+0*t17*t19*t26*t27*t34*t4*t42*t66+2.659615202676212d-1*
     ?         t10*t11*t23*t44*t65-2.036213028372208d-3*t10*t21*t27*t28*
     @         t31*t4*t65-6.701302444388497d-5*t10*t23*t3*t36*t49*t51*t6
     1         4+3.3506512221942486d-5*t10*t21*t3*t30*t31*t49*t51*t64+6.
     2         701302444388497d-5*t10*t21*t23*t3*t49*t51*t52-2.525443904
     3         885174d-2*t16*t17*t19*t26*t3*t32*t34*t49*t51-4.0724260567
     4         44416d-3*t10*t23*t27*t4*t41*t44-2.036213028372208d-3*t10*
     5         t27*t28*t30*t31*t4*t44)-2.078578130520877d-5*t10*t24*t31*
     6         t49*t74*t9*t98-1.7730768017841417d-1*t10*t11*t23*t24*t9*t
     7         97-1.7730768017841417d-1*t10*t11*t23*t30*t81*t9+3.5461536
     8         035682834d-1*t10*t13*t16*t81*t9-3.1178671957813153d-5*t10
     9         *t24*t30*t48*t49*t74*t77*t9+2.078578130520877d-5*t10*t31*
     :         t37*t49*t74*t77*t9-5.429901408992555d-3*t10*t23*t27*t28*t
     ;         4*t70*t9-3.5461536035682834d-1*t10*t11*t23*t45*t65*t9+2.7
     <         149507044962773d-3*t10*t24*t27*t28*t31*t4*t65*t9+8.935069
     =         925851332d-5*t10*t23*t3*t37*t49*t51*t64*t9-4.467534962925
     >         666d-5*t10*t24*t3*t30*t31*t49*t51*t64*t9-8.93506992585133
     ?         2d-5*t10*t23*t24*t3*t49*t51*t52*t9+5.429901408992555d-3*t
     @         10*t23*t27*t4*t41*t45*t9+2.7149507044962773d-3*t10*t27*t2
     1         8*t30*t31*t4*t45*t9)*wght+1.0d+0*t25*(6.633861595060381d-
     2         5*gammaaa*t74*t84*t85*t96-2.0157209020749695d-3*t3*t49*t5
     3         1*t64)*wght+1.0d+0*t39*t82*wght+2.0d+0*t46*t72*wght-3.062
     4         417490053882d-2*t27*t4*t43*t71*wght+5.039302255187424d-4*
     5         t3*t38*t49*t51*t56*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = 1.0d+0*t8*(-3.5461536035682834d-1
     1         *t10*t11*t13*t9*(2.659615202676212d-1*t10*t11*t13*(3.5169
     2         003312704855d-4*t17*t19*t34*t74*t84*t85*t98+1.69406589450
     3         86007d-21*t101*t19*t3*t34*t85*t94-8.798432205344503d-7*t1
     4         4*t20*t74*t84*t85*t92-1.2438490490738213d-5*t103*t18*t19*
     5         t74*t84*t85-4.6264815690944017d-3*t101*t19*t3*t43*t78*t79
     6         *t85+3.8065089231694144d-4*t100*t16*t17*t19*t79*t85-4.663
     7         815182852701d-3*t100*t19*t78*t85/t12**5+4.150349619717530
     8         5d-22*t100*t19*t56*t57*t85+8.181415676054655d-4*t101*t17*
     9         t19*t3*t41*t57*t85+1.0143559049642756d-2*t100*t15*t19*t85
     :         /(t10**6*t12**6))+3.3081598407510854d-6*t10*t21*t23*t74*t
     ;         84*t85*t96-1.6578827153323844d-4*t19*t22*t26*t31*t74*t84*
     <         t85/rhoa**5.666666666666667d+0+2.1809443270274873d-3*t101
     =         *t19*t26*t28*t3*t73*t75*t85-8.972027574067322d-5*t100*t19
     >         *t22*t26*t33*t75*t85+1.6911873548697043d-3*t100*t11*t19*t
     ?         26*t73*t85/t13**9-2.3140538016976683d-4*t101*t19*t22*t26*
     @         t3*t48*t67*t85+3.580579137009732d-7*t10*t100*t21*t48*t64*
     1         t85+1.5391639358877124d-6*t10*t101*t102*t21*t3*t31*t85-4.
     2         781719592912377d-3*rhoa*t100*t19*t26*t85/(t10**5*t13**11)
     3         +6.108639085116625d-3*t10*t23*t27*t28*t4*t80-4.6768007936
     4         71973d-5*t10*t31*t44*t49*t74*t77-2.0103907333165494d-4*t1
     5         0*t23*t3*t44*t49*t51*t64)-4.4108797876681144d-6*t10*t23*t
     6         24*t74*t84*t85*t9*t96-4.774105516012976d-7*t10*t100*t24*t
     7         48*t64*t85*t9-2.052218581183617d-6*t10*t101*t102*t24*t3*t
     8         31*t85*t9-8.144852113488832d-3*t10*t23*t27*t28*t4*t81*t9+
     9         6.235734391562631d-5*t10*t31*t45*t49*t74*t77*t9+2.6805209
     :         777553995d-4*t10*t23*t3*t45*t49*t51*t64*t9)*wght-2.487698
     ;         0981476426d-5*t103*t25*t74*t84*t85*wght-4.593626235080822
     <         7d-2*t27*t4*t43*t82*wght+1.5117906765562272d-3*t3*t46*t49
     =         *t51*t56*wght+Cmat3(iq,D3_GAA_GAA_GAA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**1.3333333333333333d+0
            t2 = param(1)
            t3 = 1/t2
            t4 = param(2)
            t5 = 1/rhob**2.6666666666666666d+0
            t6 = 1.6455307846020564d-2*gammabb*t3*t4*t5+1.0d+0
            t7 = 1.0d+0-1.0d+0/t6
            t8 = -9.305257363491d-1*t1*t2*t7-9.305257363491d-1*t1
            t9 = param(4)
            t10 = param(5)
            t11 = 1/rhob
            t12 = 9.305257363491d-1*t1*t2*t7+9.305257363491d-1*t1
            t13 = t12**5.0d-1
            t14 = t10**2
            t15 = rhob**2
            t16 = 1/t15
            t17 = 1/t14
            t18 = 1/t12
            t19 = exp(-1.413716694115413d+1*t15*t17*t18)
            t20 = t19-1.0d+0
            t21 = -3.536776513153214d-2*t12*t14*t16*t20+t19-1.5d+0
            t22 = 1/t10
            t23 = 1/t13
            t24 = 1.7724538509055202d+0*erf(3.759942411946509d+0*rhob*t2
     1         2*t23)+2.659615202676212d-1*t10*t11*t13*t21
            t25 = -3.5461536035682834d-1*t10*t11*t13*t24*t9-param(3)+1.0
     1         d+0
            t26 = 5.641895835477563d-1
            t27 = 1/t6**2
            t28 = 1/rhob**2.3333333333333334d+0
            t29 = rhob**3.333333333333333d-1
            t30 = 1.2407009817987999d+0*t2*t29*t7-4.0832233200718415d-2*
     1         gammabb*t27*t28*t4+1.2407009817987999d+0*t29
            t31 = 1/t13**3
            t32 = 3.759942411946509d+0*t22*t23-1.8799712059732546d+0*rho
     1         b*t22*t30*t31
            t33 = 1/rhob**3
            t34 = 1/t12**2
            t35 = 1.413716694115413d+1*t15*t17*t30*t34-2.827433388230826
     1         d+1*rhob*t17*t18
            t36 = -3.536776513153214d-2*t12*t14*t16*t19*t35+t19*t35+7.07
     1         3553026306428d-2*t12*t14*t20*t33-3.536776513153214d-2*t14
     2         *t16*t20*t30
            t37 = 2.659615202676212d-1*t10*t11*t13*t36+3.544907701811040
     1         3d+0*t19*t26*t32+1.329807601338106d-1*t10*t11*t21*t23*t30
     2         -2.659615202676212d-1*t10*t13*t16*t21
            t38 = -3.5461536035682834d-1*t10*t11*t13*t37*t9-1.7730768017
     1         841417d-1*t10*t11*t23*t24*t30*t9+3.5461536035682834d-1*t1
     2         0*t13*t16*t24*t9
            t39 = -1.2407009817987999d+0*t2*t29*t7+4.0832233200718415d-2
     1         *gammabb*t27*t28*t4-1.2407009817987999d+0*t29
            t40 = 1/t29
            t41 = 1/rhob**3.3333333333333337d+0
            t42 = rhob**6.666666666666666d-1
            t43 = 1/t1
            t44 = -7.656043725134704d-3*t18*t19*t27*t4*t43+2.16469536502
     1         00973d-1*t17*t19*t27*t34*t4*t42-5.415543126146093d-4*t14*
     2         t20*t27*t4*t41
            t45 = 2.659615202676212d-1*t10*t11*t13*t44-1.020447181205866
     1         6d-1*t19*t22*t26*t27*t31*t4*t40+2.036213028372208d-3*t10*
     2         t21*t23*t27*t28*t4
            t46 = -3.5461536035682834d-1*t10*t11*t13*t45*t9-2.7149507044
     1         962773d-3*t10*t23*t24*t27*t28*t4*t9
            t47 = t30**2
            t48 = 1/t13**5
            t49 = t4**2
            t50 = gammabb**2
            t51 = 1/t6**3
            t52 = 1/rhob**6
            t53 = 1/t42
            t54 = 4.135669939329333d-1*t2*t53*t7+4.135669939329333d-1*t5
     1         3-3.5835038259110563d-3*t3*t49*t50*t51*t52+4.083223320071
     2         8415d-2*gammabb*t27*t4*t41
            t55 = -1.8799712059732546d+0*rhob*t22*t31*t54+2.819956808959
     1         8814d+0*rhob*t22*t47*t48-3.759942411946509d+0*t22*t30*t31
            t56 = 1/rhob**4
            t57 = 1/t12**3
            t58 = -2.827433388230826d+1*t15*t17*t47*t57+1.41371669411541
     1         3d+1*t15*t17*t34*t54+5.654866776461652d+1*rhob*t17*t30*t3
     2         4-2.827433388230826d+1*t17*t18
            t59 = t35**2
            t60 = -3.536776513153214d-2*t12*t14*t16*t19*t59+t19*t59-3.53
     1         6776513153214d-2*t12*t14*t16*t19*t58+t19*t58-2.1220659078
     2         919285d-1*t12*t14*t20*t56-3.536776513153214d-2*t14*t16*t2
     3         0*t54+1.4147106052612857d-1*t12*t14*t19*t33*t35-7.0735530
     4         26306428d-2*t14*t16*t19*t30*t35+1.4147106052612857d-1*t14
     5         *t20*t30*t33
            t61 = 2.659615202676212d-1*t10*t11*t13*t60+3.544907701811040
     1         3d+0*t19*t26*t55+1.329807601338106d-1*t10*t11*t21*t23*t54
     2         -6.649038006690531d-2*t10*t11*t21*t31*t47+2.6596152026762
     3         12d-1*t10*t11*t23*t30*t36-5.319230405352424d-1*t10*t13*t1
     4         6*t36+3.5449077018110403d+0*t19*t26*t32*t35+5.31923040535
     5         2424d-1*t10*t13*t21*t33-2.659615202676212d-1*t10*t16*t21*
     6         t23*t30
            t62 = -3.5461536035682834d-1*t10*t11*t13*t61*t9-1.7730768017
     1         841417d-1*t10*t11*t23*t24*t54*t9+8.865384008920708d-2*t10
     2         *t11*t24*t31*t47*t9-3.5461536035682834d-1*t10*t11*t23*t30
     3         *t37*t9+7.092307207136567d-1*t10*t13*t16*t37*t9-7.0923072
     4         07136567d-1*t10*t13*t24*t33*t9+3.5461536035682834d-1*t10*
     5         t16*t23*t24*t30*t9
            t63 = -4.135669939329333d-1*t2*t53*t7-4.135669939329333d-1*t
     1         53+3.5835038259110563d-3*t3*t49*t50*t51*t52-4.08322332007
     2         18415d-2*gammabb*t27*t4*t41
            t64 = 1/rhob**5
            t65 = 1.3438139347166464d-3*gammabb*t3*t49*t51*t64-2.0416116
     1         600359205d-2*t27*t28*t4
            t66 = -1.8799712059732546d+0*rhob*t22*t31*t65+4.317942526477
     1         637d-2*t22*t27*t30*t4*t40*t48-2.878628350985092d-2*t22*t2
     2         7*t31*t4*t43
            t67 = 1/rhob**4.333333333333333d+0
            t68 = 1.413716694115413d+1*t15*t17*t34*t65-4.329390730040194
     1         6d-1*t17*t27*t30*t4*t42*t57+4.3293907300401946d-1*t17*t27
     2         *t34*t4*t40
            t69 = -3.536776513153214d-2*t12*t14*t16*t19*t68+t19*t68+1.08
     1         31086252292187d-3*t14*t20*t27*t4*t67-3.536776513153214d-2
     2         *t14*t16*t20*t65-7.656043725134704d-3*t18*t19*t27*t35*t4*
     3         t43-7.656043725134704d-3*t19*t27*t30*t34*t4*t43+2.1646953
     4         650200973d-1*t17*t19*t27*t34*t35*t4*t42-5.415543126146093
     5         d-4*t14*t19*t27*t35*t4*t41+1.5312087450269407d-2*t18*t19*
     6         t27*t28*t4
            t70 = 2.659615202676212d-1*t10*t11*t13*t69+3.544907701811040
     1         3d+0*t19*t26*t66+1.329807601338106d-1*t10*t11*t21*t23*t65
     2         +1.329807601338106d-1*t10*t11*t23*t30*t44-2.6596152026762
     3         12d-1*t10*t13*t16*t44+7.673645271534404d-1*t17*t19*t26*t2
     4         7*t32*t34*t4*t42-2.036213028372208d-3*t10*t21*t23*t27*t4*
     5         t41+2.036213028372208d-3*t10*t23*t27*t28*t36*t4-1.0181065
     6         14186104d-3*t10*t21*t27*t28*t30*t31*t4
            t71 = -3.5461536035682834d-1*t10*t11*t13*t70*t9-1.7730768017
     1         841417d-1*t10*t11*t23*t24*t65*t9-1.7730768017841417d-1*t1
     2         0*t11*t23*t30*t45*t9+3.5461536035682834d-1*t10*t13*t16*t4
     3         5*t9+2.7149507044962773d-3*t10*t23*t24*t27*t4*t41*t9-2.71
     4         49507044962773d-3*t10*t23*t27*t28*t37*t4*t9+1.35747535224
     5         81386d-3*t10*t24*t27*t28*t30*t31*t4*t9
            t72 = 2.0416116600359205d-2*t27*t28*t4-1.3438139347166464d-3
     1         *gammabb*t3*t49*t51*t64
            t73 = 1/t10**3
            t74 = 1/t6**4
            t75 = 1/t13**7
            t76 = 1/rhob**1.6666666666666669d+0
            t77 = 1/rhob**3.6666666666666664d+0
            t78 = 1/t10**4
            t79 = 1/t12**4
            t80 = 4.685906023339492d-2*t1*t19*t49*t74*t78*t79-8.28650118
     1         3095146d-3*t17*t19*t49*t53*t57*t74-1.3552527156068805d-20
     2         *t19*t34*t49*t5*t74+2.519651127593712d-4*t18*t19*t3*t49*t
     3         51*t56+1.782288585882691d-5*t14*t20*t3*t49*t51*t52-7.1241
     4         45724851911d-3*t16*t17*t19*t3*t34*t49*t51
            t81 = 2.659615202676212d-1*t10*t11*t13*t80-1.558933597890657
     1         7d-5*t10*t21*t31*t49*t74*t77+2.3437764715507717d-3*t19*t2
     2         2*t26*t48*t49*t74*t76-2.2089572834041626d-2*t19*t26*t29*t
     3         49*t73*t74*t75-6.701302444388497d-5*t10*t21*t23*t3*t49*t5
     4         1*t64+3.3583545014692934d-3*t19*t22*t26*t3*t31*t33*t49*t5
     5         1+4.072426056744416d-3*t10*t23*t27*t28*t4*t44
            t82 = -3.5461536035682834d-1*t10*t11*t13*t81*t9+2.0785781305
     1         20877d-5*t10*t24*t31*t49*t74*t77*t9+8.935069925851332d-5*
     2         t10*t23*t24*t3*t49*t51*t64*t9-5.429901408992555d-3*t10*t2
     3         3*t27*t28*t4*t45*t9
            t83 = t30**3
            t84 = 1/t2**2
            t85 = t4**3
            t86 = gammabb**3
            t87 = 1/rhob**9.666666666666666d+0
            t88 = 1/rhob**7
            t89 = 2.50845267813774d-2*t3*t49*t50*t51*t88-4.7174126898207
     1         14d-4*t74*t84*t85*t86*t87-2.757113292886222d-1*t2*t7*t76-
     2         2.757113292886222d-1*t76-1.5425510320271402d-1*gammabb*t2
     3         7*t4*t67
            t90 = 1.413716694115413d+1*t15*t17*t34*t89+8.482300164692478
     1         d+1*t15*t17*t79*t83-8.482300164692478d+1*t15*t17*t30*t54*
     2         t57-1.6964600329384957d+2*rhob*t17*t47*t57+8.482300164692
     3         478d+1*rhob*t17*t34*t54+8.482300164692478d+1*t17*t30*t34
            t91 = t35**3
            t92 = 1/rhob**8.666666666666666d+0
            t93 = 1.7690297586827677d-4*t50*t74*t84*t85*t92-8.5108215865
     1         3876d-3*gammabb*t3*t49*t51*t52+4.7637605400838157d-2*t27*
     2         t4*t41
            t94 = 1/rhob**5.333333333333333d+0
            t95 = 1.413716694115413d+1*t15*t17*t34*t93+1.298817219012058
     1         4d+0*t17*t27*t4*t42*t47*t79-5.654866776461652d+1*t15*t17*
     2         t30*t57*t65+5.654866776461652d+1*rhob*t17*t34*t65-4.32939
     3         07300401946d-1*t17*t27*t4*t42*t54*t57-1.7317562920160778d
     4         +0*t17*t27*t30*t4*t40*t57+4.3293907300401946d-1*t17*t27*t
     5         34*t4*t43
            t96 = 1/rhob**7.666666666666667d+0
            t97 = 2.0157209020749695d-3*t3*t49*t51*t64-6.633861595060381
     1         d-5*gammabb*t74*t84*t85*t96
            t98 = 1/rhob**4.666666666666667d+0
            t99 = 1.413716694115413d+1*t15*t17*t34*t97+1.988760283942835
     1         3d-2*t17*t30*t49*t53*t74*t79-1.3258401892952237d-2*t17*t4
     2         9*t57*t74*t76-8.658781460080389d-1*t17*t27*t4*t42*t57*t65
     3         +1.4248291449703823d-2*t16*t17*t3*t30*t49*t51*t57-1.42482
     4         91449703823d-2*t17*t3*t33*t34*t49*t51
            t100 = 1/t6**6
            t101 = 1/t6**5
            t102 = 1/rhob**6.333333333333333d+0
            t103 = 1/rhob**6.666666666666667d+0
            fnc(iq) = 1.0d+0*t25*t8*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*t38*t8*wght+1.0d+0*t25*t39*wght+Amat
     1         (iq,D1_RB)
            Cmat(iq,D1_GBB) = 1.0d+0*t46*t8*wght-1.531208745026941d-2*t2
     1         5*t27*t4*t43*wght+Cmat(iq,D1_GBB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*t62*t8*wght+1.0d+0*t25*t63*wght+
     1         2.0d+0*t38*t39*wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = 1.0d+0*t71*t8*wght+1.0d+0*t25*t72*wght
     1         +1.0d+0*t39*t46*wght-1.531208745026941d-2*t27*t38*t4*t43*
     2         wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = 1.0d+0*t8*t82*wght+5.039302255187424d
     1         -4*t25*t3*t49*t51*t56*wght-3.062417490053882d-2*t27*t4*t4
     2         3*t46*wght+Cmat2(iq,D2_GBB_GBB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*t8*(-3.5461536035682834d-1*t1
     1         0*t11*t13*t9*(2.659615202676212d-1*t10*t11*t13*(-3.536776
     2         513153214d-2*t12*t14*t16*t19*t91+t19*t91-3.53677651315321
     3         4d-2*t12*t14*t16*t19*t90+t19*t90-3.536776513153214d-2*t14
     4         *t16*t20*t89+8.488263631567714d-1*t12*t14*t20*t64+2.12206
     5         59078919285d-1*t12*t14*t19*t33*t59-1.0610329539459643d-1*
     6         t14*t16*t19*t30*t59-1.0610329539459643d-1*t12*t14*t16*t19
     7         *t35*t58+3*t19*t35*t58+2.1220659078919285d-1*t12*t14*t19*
     8         t33*t58-1.0610329539459643d-1*t14*t16*t19*t30*t58-6.36619
     9         7723675786d-1*t12*t14*t19*t35*t56-6.366197723675786d-1*t1
     :         4*t20*t30*t56-1.0610329539459643d-1*t14*t16*t19*t35*t54+2
     ;         .1220659078919285d-1*t14*t20*t33*t54+4.244131815783857d-1
     <         *t14*t19*t30*t33*t35)+3.5449077018110403d+0*t19*t26*(-1.8
     =         799712059732546d+0*rhob*t22*t31*t89-7.049892022399704d+0*
     >         rhob*t22*t75*t83+8.459870426879645d+0*rhob*t22*t30*t48*t5
     ?         4-5.639913617919763d+0*t22*t31*t54+8.459870426879645d+0*t
     @         22*t47*t48)+1.329807601338106d-1*t10*t11*t21*t23*t89+9.97
     1         3557010035795d-2*t10*t11*t21*t48*t83+3.989422804014318d-1
     2         *t10*t11*t23*t30*t60-7.978845608028636d-1*t10*t13*t16*t60
     3         +3.5449077018110403d+0*t19*t26*t32*t59+3.5449077018110403
     4         d+0*t19*t26*t32*t58-1.5957691216057274d+0*t10*t13*t21*t56
     5         +7.089815403622081d+0*t19*t26*t35*t55+3.989422804014318d-
     6         1*t10*t11*t23*t36*t54-1.994711402007159d-1*t10*t11*t21*t3
     7         0*t31*t54-3.989422804014318d-1*t10*t16*t21*t23*t54-1.9947
     8         11402007159d-1*t10*t11*t31*t36*t47+1.994711402007159d-1*t
     9         10*t16*t21*t31*t47+1.5957691216057274d+0*t10*t13*t33*t36-
     :         7.978845608028636d-1*t10*t16*t23*t30*t36+7.97884560802863
     ;         6d-1*t10*t21*t23*t30*t33)-1.7730768017841417d-1*t10*t11*t
     <         23*t24*t89*t9-1.3298076013381063d-1*t10*t11*t24*t48*t83*t
     =         9-5.319230405352425d-1*t10*t11*t23*t30*t61*t9+1.063846081
     >         070485d+0*t10*t13*t16*t61*t9+2.12769216214097d+0*t10*t13*
     ?         t24*t56*t9-5.319230405352425d-1*t10*t11*t23*t37*t54*t9+2.
     @         6596152026762127d-1*t10*t11*t24*t30*t31*t54*t9+5.31923040
     1         5352425d-1*t10*t16*t23*t24*t54*t9+2.6596152026762127d-1*t
     2         10*t11*t31*t37*t47*t9-2.6596152026762127d-1*t10*t16*t24*t
     3         31*t47*t9-2.12769216214097d+0*t10*t13*t33*t37*t9+1.063846
     4         081070485d+0*t10*t16*t23*t30*t37*t9-1.063846081070485d+0*
     5         t10*t23*t24*t30*t33*t9)*wght+1.0d+0*t25*(-2.5084526781377
     6         4d-2*t3*t49*t50*t51*t88+4.717412689820714d-4*t74*t84*t85*
     7         t86*t87+2.757113292886222d-1*t2*t7*t76+2.757113292886222d
     8         -1*t76+1.5425510320271402d-1*gammabb*t27*t4*t67)*wght+3.0
     9         d+0*t38*t63*wght+3.0d+0*t39*t62*wght+Amat3(iq,D3_RB_RB_RB
     :         )
            Cmat3(iq,D3_RB_RB_GBB) = 1.0d+0*t8*(-3.5461536035682834d-1*t
     1         10*t11*t13*t9*(2.659615202676212d-1*t10*t11*t13*(-3.53677
     2         6513153214d-2*t12*t14*t16*t19*t95+t19*t95-3.2493258756876
     3         56d-3*t14*t20*t27*t4*t94-3.536776513153214d-2*t14*t16*t20
     4         *t93-7.073553026306428d-2*t12*t14*t16*t19*t35*t68+2*t19*t
     5         35*t68+1.4147106052612857d-1*t12*t14*t19*t33*t68-7.073553
     6         026306428d-2*t14*t16*t19*t30*t68+2.1662172504584373d-3*t1
     7         4*t19*t27*t35*t4*t67-7.073553026306428d-2*t14*t16*t19*t35
     8         *t65+1.4147106052612857d-1*t14*t20*t33*t65-7.656043725134
     9         704d-3*t18*t19*t27*t4*t43*t59+2.1646953650200973d-1*t17*t
     :         19*t27*t34*t4*t42*t59-5.415543126146093d-4*t14*t19*t27*t4
     ;         *t41*t59-7.656043725134704d-3*t18*t19*t27*t4*t43*t58+2.16
     <         46953650200973d-1*t17*t19*t27*t34*t4*t42*t58-5.4155431261
     =         46093d-4*t14*t19*t27*t4*t41*t58-7.656043725134704d-3*t19*
     >         t27*t34*t4*t43*t54-1.5312087450269407d-2*t19*t27*t30*t34*
     ?         t35*t4*t43-4.593626235080822d-2*t18*t19*t27*t4*t41+3.0624
     @         174900538814d-2*t18*t19*t27*t28*t35*t4+3.0624174900538814
     1         d-2*t19*t27*t28*t30*t34*t4)+3.5449077018110403d+0*t19*t26
     2         *(-1.8799712059732546d+0*rhob*t22*t31*t93-1.0794856316194
     3         094d-1*t22*t27*t4*t40*t47*t75+5.639913617919763d+0*rhob*t
     4         22*t30*t48*t65-3.759942411946509d+0*t22*t31*t65+4.3179425
     5         26477637d-2*t22*t27*t4*t40*t48*t54+8.635885052955274d-2*t
     6         22*t27*t30*t4*t43*t48)+1.329807601338106d-1*t10*t11*t21*t
     7         23*t93+2.659615202676212d-1*t10*t11*t23*t30*t69-5.3192304
     8         05352424d-1*t10*t13*t16*t69+3.5449077018110403d+0*t19*t26
     9         *t32*t68+4.072426056744416d-3*t10*t21*t23*t27*t4*t67+3.54
     :         49077018110403d+0*t19*t26*t35*t66+2.659615202676212d-1*t1
     ;         0*t11*t23*t36*t65-1.329807601338106d-1*t10*t11*t21*t30*t3
     <         1*t65-2.659615202676212d-1*t10*t16*t21*t23*t65+2.03621302
     =         8372208d-3*t10*t23*t27*t28*t4*t60+7.673645271534404d-1*t1
     >         7*t19*t26*t27*t34*t4*t42*t55+1.329807601338106d-1*t10*t11
     ?         *t23*t44*t54-1.018106514186104d-3*t10*t21*t27*t28*t31*t4*
     @         t54+1.527159771279156d-3*t10*t21*t27*t28*t4*t47*t48-6.649
     1         038006690531d-2*t10*t11*t31*t44*t47+5.319230405352424d-1*
     2         t10*t13*t33*t44-2.659615202676212d-1*t10*t16*t23*t30*t44+
     3         7.673645271534404d-1*t17*t19*t26*t27*t32*t34*t35*t4*t42-4
     4         .072426056744416d-3*t10*t23*t27*t36*t4*t41+2.036213028372
     5         208d-3*t10*t21*t27*t30*t31*t4*t41-2.036213028372208d-3*t1
     6         0*t27*t28*t30*t31*t36*t4)-1.7730768017841417d-1*t10*t11*t
     7         23*t24*t9*t93-3.5461536035682834d-1*t10*t11*t23*t30*t70*t
     8         9+7.092307207136567d-1*t10*t13*t16*t70*t9-5.4299014089925
     9         55d-3*t10*t23*t24*t27*t4*t67*t9-3.5461536035682834d-1*t10
     :         *t11*t23*t37*t65*t9+1.7730768017841417d-1*t10*t11*t24*t30
     ;         *t31*t65*t9+3.5461536035682834d-1*t10*t16*t23*t24*t65*t9-
     <         2.7149507044962773d-3*t10*t23*t27*t28*t4*t61*t9-1.7730768
     =         017841417d-1*t10*t11*t23*t45*t54*t9+1.3574753522481386d-3
     >         *t10*t24*t27*t28*t31*t4*t54*t9-2.036213028372208d-3*t10*t
     ?         24*t27*t28*t4*t47*t48*t9+8.865384008920708d-2*t10*t11*t31
     @         *t45*t47*t9-7.092307207136567d-1*t10*t13*t33*t45*t9+3.546
     1         1536035682834d-1*t10*t16*t23*t30*t45*t9+5.429901408992555
     2         d-3*t10*t23*t27*t37*t4*t41*t9-2.7149507044962773d-3*t10*t
     3         24*t27*t30*t31*t4*t41*t9+2.7149507044962773d-3*t10*t27*t2
     4         8*t30*t31*t37*t4*t9)*wght+1.0d+0*t25*(-1.7690297586827677
     5         d-4*t50*t74*t84*t85*t92+8.51082158653876d-3*gammabb*t3*t4
     6         9*t51*t52-4.7637605400838157d-2*t27*t4*t41)*wght+2.0d+0*t
     7         38*t72*wght+2.0d+0*t39*t71*wght+1.0d+0*t46*t63*wght-1.531
     8         208745026941d-2*t27*t4*t43*t62*wght+Cmat3(iq,D3_RB_RB_GBB
     9         )
            Cmat3(iq,D3_RB_GBB_GBB) = 1.0d+0*t8*(-3.5461536035682834d-1*
     1         t10*t11*t13*t9*(2.659615202676212d-1*t10*t11*t13*(-3.5367
     2         76513153214d-2*t12*t14*t16*t19*t99+t19*t99-3.536776513153
     3         214d-2*t14*t16*t20*t97-3.564577171765382d-5*t14*t20*t3*t4
     4         9*t51*t88+4.685906023339492d-2*t1*t19*t35*t49*t74*t78*t79
     5         -1.6573002366190293d-3*t17*t19*t30*t49*t53*t74*t79+2.7105
     6         05431213761d-20*t19*t34*t49*t74*t77+3.3146004732380585d-3
     7         *t17*t19*t49*t57*t74*t76-8.286501183095146d-3*t17*t19*t35
     8         *t49*t53*t57*t74+2.344600220846979d-4*t19*t30*t49*t5*t57*
     9         t74-1.3552527156068805d-20*t19*t34*t35*t49*t5*t74-1.53120
     :         87450269407d-2*t18*t19*t27*t4*t43*t68+4.3293907300401946d
     ;         -1*t17*t19*t27*t34*t4*t42*t68-1.0831086252292187d-3*t14*t
     <         19*t27*t4*t41*t68-1.5312087450269407d-2*t19*t27*t34*t4*t4
     =         3*t65-5.039302255187424d-4*t18*t19*t3*t49*t51*t64+2.51965
     >         1127593712d-4*t18*t19*t3*t35*t49*t51*t56+2.51965112759371
     ?         2d-4*t19*t3*t30*t34*t49*t51*t56+1.782288585882691d-5*t14*
     @         t19*t3*t35*t49*t51*t52-7.124145724851911d-3*t16*t17*t19*t
     1         3*t34*t35*t49*t51)+1.5589335978906577d-5*t10*t21*t31*t49*
     2         t74*t98+3.5449077018110403d+0*t19*t26*(-1.879971205973254
     3         6d+0*rhob*t22*t31*t97-1.6529178392665705d-3*t22*t30*t49*t
     4         74*t75*t76+6.611671357066283d-4*t22*t48*t49*t5*t74+8.6358
     5         85052955274d-2*t22*t27*t4*t40*t48*t65+9.473743137948445d-
     6         4*t22*t3*t31*t49*t51*t56-1.4210614706922667d-3*t22*t3*t30
     7         *t33*t48*t49*t51)+1.329807601338106d-1*t10*t11*t21*t23*t9
     8         7+1.329807601338106d-1*t10*t11*t23*t30*t80-2.659615202676
     9         212d-1*t10*t13*t16*t80+1.661110435209891d-1*t1*t19*t26*t3
     :         2*t49*t74*t78*t79+2.3384003968359865d-5*t10*t21*t30*t48*t
     ;         49*t74*t77-1.5589335978906577d-5*t10*t31*t36*t49*t74*t77-
     <         2.3499905492016226d-2*t17*t19*t26*t32*t49*t53*t57*t74+4.0
     =         72426056744416d-3*t10*t23*t27*t28*t4*t69+1.53472905430688
     >         1d+0*t17*t19*t26*t27*t34*t4*t42*t66+2.659615202676212d-1*
     ?         t10*t11*t23*t44*t65-2.036213028372208d-3*t10*t21*t27*t28*
     @         t31*t4*t65-6.701302444388497d-5*t10*t23*t3*t36*t49*t51*t6
     1         4+3.3506512221942486d-5*t10*t21*t3*t30*t31*t49*t51*t64+6.
     2         701302444388497d-5*t10*t21*t23*t3*t49*t51*t52-2.525443904
     3         885174d-2*t16*t17*t19*t26*t3*t32*t34*t49*t51-4.0724260567
     4         44416d-3*t10*t23*t27*t4*t41*t44-2.036213028372208d-3*t10*
     5         t27*t28*t30*t31*t4*t44)-2.078578130520877d-5*t10*t24*t31*
     6         t49*t74*t9*t98-1.7730768017841417d-1*t10*t11*t23*t24*t9*t
     7         97-1.7730768017841417d-1*t10*t11*t23*t30*t81*t9+3.5461536
     8         035682834d-1*t10*t13*t16*t81*t9-3.1178671957813153d-5*t10
     9         *t24*t30*t48*t49*t74*t77*t9+2.078578130520877d-5*t10*t31*
     :         t37*t49*t74*t77*t9-5.429901408992555d-3*t10*t23*t27*t28*t
     ;         4*t70*t9-3.5461536035682834d-1*t10*t11*t23*t45*t65*t9+2.7
     <         149507044962773d-3*t10*t24*t27*t28*t31*t4*t65*t9+8.935069
     =         925851332d-5*t10*t23*t3*t37*t49*t51*t64*t9-4.467534962925
     >         666d-5*t10*t24*t3*t30*t31*t49*t51*t64*t9-8.93506992585133
     ?         2d-5*t10*t23*t24*t3*t49*t51*t52*t9+5.429901408992555d-3*t
     @         10*t23*t27*t4*t41*t45*t9+2.7149507044962773d-3*t10*t27*t2
     1         8*t30*t31*t4*t45*t9)*wght+1.0d+0*t25*(6.633861595060381d-
     2         5*gammabb*t74*t84*t85*t96-2.0157209020749695d-3*t3*t49*t5
     3         1*t64)*wght+1.0d+0*t39*t82*wght+2.0d+0*t46*t72*wght-3.062
     4         417490053882d-2*t27*t4*t43*t71*wght+5.039302255187424d-4*
     5         t3*t38*t49*t51*t56*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = 1.0d+0*t8*(-3.5461536035682834d-1
     1         *t10*t11*t13*t9*(2.659615202676212d-1*t10*t11*t13*(3.5169
     2         003312704855d-4*t17*t19*t34*t74*t84*t85*t98+1.69406589450
     3         86007d-21*t101*t19*t3*t34*t85*t94-8.798432205344503d-7*t1
     4         4*t20*t74*t84*t85*t92-1.2438490490738213d-5*t103*t18*t19*
     5         t74*t84*t85-4.6264815690944017d-3*t101*t19*t3*t43*t78*t79
     6         *t85+3.8065089231694144d-4*t100*t16*t17*t19*t79*t85-4.663
     7         815182852701d-3*t100*t19*t78*t85/t12**5+4.150349619717530
     8         5d-22*t100*t19*t56*t57*t85+8.181415676054655d-4*t101*t17*
     9         t19*t3*t41*t57*t85+1.0143559049642756d-2*t100*t15*t19*t85
     :         /(t10**6*t12**6))+3.3081598407510854d-6*t10*t21*t23*t74*t
     ;         84*t85*t96-1.6578827153323844d-4*t19*t22*t26*t31*t74*t84*
     <         t85/rhob**5.666666666666667d+0+2.1809443270274873d-3*t101
     =         *t19*t26*t28*t3*t73*t75*t85-8.972027574067322d-5*t100*t19
     >         *t22*t26*t33*t75*t85+1.6911873548697043d-3*t100*t11*t19*t
     ?         26*t73*t85/t13**9-2.3140538016976683d-4*t101*t19*t22*t26*
     @         t3*t48*t67*t85+3.580579137009732d-7*t10*t100*t21*t48*t64*
     1         t85+1.5391639358877124d-6*t10*t101*t102*t21*t3*t31*t85-4.
     2         781719592912377d-3*rhob*t100*t19*t26*t85/(t10**5*t13**11)
     3         +6.108639085116625d-3*t10*t23*t27*t28*t4*t80-4.6768007936
     4         71973d-5*t10*t31*t44*t49*t74*t77-2.0103907333165494d-4*t1
     5         0*t23*t3*t44*t49*t51*t64)-4.4108797876681144d-6*t10*t23*t
     6         24*t74*t84*t85*t9*t96-4.774105516012976d-7*t10*t100*t24*t
     7         48*t64*t85*t9-2.052218581183617d-6*t10*t101*t102*t24*t3*t
     8         31*t85*t9-8.144852113488832d-3*t10*t23*t27*t28*t4*t81*t9+
     9         6.235734391562631d-5*t10*t31*t45*t49*t74*t77*t9+2.6805209
     :         777553995d-4*t10*t23*t3*t45*t49*t51*t64*t9)*wght-2.487698
     ;         0981476426d-5*t103*t25*t74*t84*t85*wght-4.593626235080822
     <         7d-2*t27*t4*t43*t82*wght+1.5117906765562272d-3*t3*t46*t49
     =         *t51*t56*wght+Cmat3(iq,D3_GBB_GBB_GBB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
