#!/bin/sh
#
# SPDX-FileCopyrightText: Peter Pentchev <roam@ringlet.net>
# SPDX-License-Identifier: GPL-2.0-or-later

myself="$(readlink -f -- "$0")"
test_dir="$(dirname -- "$myself")"
. "$test_dir/tap-functions.sh"

[ -z "$PRIPS" ] && PRIPS='./prips'

plan_ 8

v=`$PRIPS -d33 17.1.0.40/29 2>/dev/null`
res="$?"
exp='17.1.0.40!17.1.0.41!17.1.0.42!17.1.0.43!17.1.0.44!17.1.0.45!17.1.0.46!17.1.0.47!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -i2 17.1.0.40/29 2>/dev/null`
res="$?"
exp='17.1.0.40!17.1.0.42!17.1.0.44!17.1.0.46!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -i3 17.1.0.40/29 2>/dev/null`
res="$?"
exp='17.1.0.40!17.1.0.43!17.1.0.46!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -i5 77.0.1.43 77.0.1.60 2>/dev/null`
res="$?"
exp='77.0.1.43!77.0.1.48!77.0.1.53!77.0.1.58!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi
