# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.authorization.aio import AuthorizationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAuthorizationManagementAlertsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AuthorizationManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_get(self, resource_group):
        response = await self.client.alerts.get(
            scope="str",
            alert_id="str",
            api_version="2022-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_update(self, resource_group):
        response = await self.client.alerts.update(
            scope="str",
            alert_id="str",
            parameters={
                "alertConfiguration": {
                    "alertDefinition": {
                        "description": "str",
                        "displayName": "str",
                        "howToPrevent": "str",
                        "id": "str",
                        "isConfigurable": bool,
                        "isRemediatable": bool,
                        "mitigationSteps": "str",
                        "name": "str",
                        "scope": "str",
                        "securityImpact": "str",
                        "severityLevel": "str",
                        "type": "str",
                    },
                    "alertDefinitionId": "str",
                    "id": "str",
                    "isEnabled": bool,
                    "name": "str",
                    "scope": "str",
                    "type": "str",
                },
                "alertDefinition": {
                    "description": "str",
                    "displayName": "str",
                    "howToPrevent": "str",
                    "id": "str",
                    "isConfigurable": bool,
                    "isRemediatable": bool,
                    "mitigationSteps": "str",
                    "name": "str",
                    "scope": "str",
                    "securityImpact": "str",
                    "severityLevel": "str",
                    "type": "str",
                },
                "alertIncidents": [{"id": "str", "name": "str", "type": "str"}],
                "id": "str",
                "incidentCount": 0,
                "isActive": bool,
                "lastModifiedDateTime": "2020-02-20 00:00:00",
                "lastScannedDateTime": "2020-02-20 00:00:00",
                "name": "str",
                "scope": "str",
                "type": "str",
            },
            api_version="2022-08-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_list_for_scope(self, resource_group):
        response = self.client.alerts.list_for_scope(
            scope="str",
            api_version="2022-08-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_begin_refresh(self, resource_group):
        response = await (
            await self.client.alerts.begin_refresh(
                scope="str",
                alert_id="str",
                api_version="2022-08-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_alerts_begin_refresh_all(self, resource_group):
        response = await (
            await self.client.alerts.begin_refresh_all(
                scope="str",
                api_version="2022-08-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
