# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class BillingInfoResponse(_serialization.Model):
    """Marketplace Subscription and Organization details to which resource gets billed into.

    :ivar marketplace_saas_info: Marketplace Subscription details.
    :vartype marketplace_saas_info: ~azure.mgmt.elastic.models.MarketplaceSaaSInfo
    :ivar partner_billing_entity: Partner Billing Entity details: Organization Info.
    :vartype partner_billing_entity: ~azure.mgmt.elastic.models.PartnerBillingEntity
    """

    _attribute_map = {
        "marketplace_saas_info": {"key": "marketplaceSaasInfo", "type": "MarketplaceSaaSInfo"},
        "partner_billing_entity": {"key": "partnerBillingEntity", "type": "PartnerBillingEntity"},
    }

    def __init__(
        self,
        *,
        marketplace_saas_info: Optional["_models.MarketplaceSaaSInfo"] = None,
        partner_billing_entity: Optional["_models.PartnerBillingEntity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword marketplace_saas_info: Marketplace Subscription details.
        :paramtype marketplace_saas_info: ~azure.mgmt.elastic.models.MarketplaceSaaSInfo
        :keyword partner_billing_entity: Partner Billing Entity details: Organization Info.
        :paramtype partner_billing_entity: ~azure.mgmt.elastic.models.PartnerBillingEntity
        """
        super().__init__(**kwargs)
        self.marketplace_saas_info = marketplace_saas_info
        self.partner_billing_entity = partner_billing_entity


class CompanyInfo(_serialization.Model):
    """Company information of the user to be passed to partners.

    :ivar domain: Domain of the company.
    :vartype domain: str
    :ivar business: Business of the company.
    :vartype business: str
    :ivar employees_number: Number of employees in the company.
    :vartype employees_number: str
    :ivar state: State of the company location.
    :vartype state: str
    :ivar country: Country of the company location.
    :vartype country: str
    """

    _validation = {
        "domain": {"max_length": 256},
        "business": {"max_length": 128},
        "employees_number": {"max_length": 20},
        "state": {"max_length": 128},
        "country": {"max_length": 128},
    }

    _attribute_map = {
        "domain": {"key": "domain", "type": "str"},
        "business": {"key": "business", "type": "str"},
        "employees_number": {"key": "employeesNumber", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "country": {"key": "country", "type": "str"},
    }

    def __init__(
        self,
        *,
        domain: Optional[str] = None,
        business: Optional[str] = None,
        employees_number: Optional[str] = None,
        state: Optional[str] = None,
        country: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword domain: Domain of the company.
        :paramtype domain: str
        :keyword business: Business of the company.
        :paramtype business: str
        :keyword employees_number: Number of employees in the company.
        :paramtype employees_number: str
        :keyword state: State of the company location.
        :paramtype state: str
        :keyword country: Country of the company location.
        :paramtype country: str
        """
        super().__init__(**kwargs)
        self.domain = domain
        self.business = business
        self.employees_number = employees_number
        self.state = state
        self.country = country


class ConnectedPartnerResourceProperties(_serialization.Model):
    """Connected Partner Resource Properties.

    :ivar partner_deployment_name: Elastic resource name.
    :vartype partner_deployment_name: str
    :ivar partner_deployment_uri: URL of the resource in Elastic cloud.
    :vartype partner_deployment_uri: str
    :ivar azure_resource_id: The azure resource Id of the resource.
    :vartype azure_resource_id: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar type: The hosting type of the resource.
    :vartype type: str
    """

    _attribute_map = {
        "partner_deployment_name": {"key": "partnerDeploymentName", "type": "str"},
        "partner_deployment_uri": {"key": "partnerDeploymentUri", "type": "str"},
        "azure_resource_id": {"key": "azureResourceId", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        partner_deployment_name: Optional[str] = None,
        partner_deployment_uri: Optional[str] = None,
        azure_resource_id: Optional[str] = None,
        location: Optional[str] = None,
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword partner_deployment_name: Elastic resource name.
        :paramtype partner_deployment_name: str
        :keyword partner_deployment_uri: URL of the resource in Elastic cloud.
        :paramtype partner_deployment_uri: str
        :keyword azure_resource_id: The azure resource Id of the resource.
        :paramtype azure_resource_id: str
        :keyword location: The location of the resource.
        :paramtype location: str
        :keyword type: The hosting type of the resource.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.partner_deployment_name = partner_deployment_name
        self.partner_deployment_uri = partner_deployment_uri
        self.azure_resource_id = azure_resource_id
        self.location = location
        self.type = type


class ConnectedPartnerResourcesListFormat(_serialization.Model):
    """Connected Partner Resources List Format.

    :ivar properties: Connected Partner Resource Properties.
    :vartype properties: ~azure.mgmt.elastic.models.ConnectedPartnerResourceProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ConnectedPartnerResourceProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.ConnectedPartnerResourceProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Connected Partner Resource Properties.
        :paramtype properties: ~azure.mgmt.elastic.models.ConnectedPartnerResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ConnectedPartnerResourcesListResponse(_serialization.Model):
    """List of all active elastic deployments.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.elastic.models.ConnectedPartnerResourcesListFormat]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectedPartnerResourcesListFormat]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ConnectedPartnerResourcesListFormat"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.elastic.models.ConnectedPartnerResourcesListFormat]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DeploymentInfoResponse(_serialization.Model):
    """The properties of deployment in Elastic cloud corresponding to the Elastic monitor resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The Elastic deployment status. Known values are: "Healthy" and "Unhealthy".
    :vartype status: str or ~azure.mgmt.elastic.models.ElasticDeploymentStatus
    :ivar version: Version of the elasticsearch in Elastic cloud deployment.
    :vartype version: str
    :ivar memory_capacity: RAM capacity of the elasticsearch in Elastic cloud deployment.
    :vartype memory_capacity: str
    :ivar disk_capacity: Disk capacity of the elasticsearch in Elastic cloud deployment.
    :vartype disk_capacity: str
    :ivar elasticsearch_end_point: Elasticsearch endpoint in Elastic cloud deployment. This is
     either the aliased_endpoint if available, or the service_url otherwise.
    :vartype elasticsearch_end_point: str
    :ivar deployment_url: Deployment URL of the elasticsearch in Elastic cloud deployment.
    :vartype deployment_url: str
    :ivar marketplace_saas_info: Marketplace SaaS Info of the resource.
    :vartype marketplace_saas_info: ~azure.mgmt.elastic.models.MarketplaceSaaSInfo
    :ivar project_type: Project Type - Applicable for Serverless only.
    :vartype project_type: str
    :ivar configuration_type: ConfigurationType Type - Applicable for Serverless only.
    :vartype configuration_type: str
    """

    _validation = {
        "status": {"readonly": True},
        "version": {"readonly": True},
        "memory_capacity": {"readonly": True},
        "disk_capacity": {"readonly": True},
        "elasticsearch_end_point": {"readonly": True},
        "deployment_url": {"readonly": True},
        "marketplace_saas_info": {"readonly": True},
        "project_type": {"readonly": True},
        "configuration_type": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "memory_capacity": {"key": "memoryCapacity", "type": "str"},
        "disk_capacity": {"key": "diskCapacity", "type": "str"},
        "elasticsearch_end_point": {"key": "elasticsearchEndPoint", "type": "str"},
        "deployment_url": {"key": "deploymentUrl", "type": "str"},
        "marketplace_saas_info": {"key": "marketplaceSaasInfo", "type": "MarketplaceSaaSInfo"},
        "project_type": {"key": "projectType", "type": "str"},
        "configuration_type": {"key": "configurationType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status: Optional[Union[str, "_models.ElasticDeploymentStatus"]] = None
        self.version: Optional[str] = None
        self.memory_capacity: Optional[str] = None
        self.disk_capacity: Optional[str] = None
        self.elasticsearch_end_point: Optional[str] = None
        self.deployment_url: Optional[str] = None
        self.marketplace_saas_info: Optional["_models.MarketplaceSaaSInfo"] = None
        self.project_type: Optional[str] = None
        self.configuration_type: Optional[str] = None


class ElasticCloudDeployment(_serialization.Model):
    """Details of the user's elastic deployment associated with the monitor resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Elastic deployment name.
    :vartype name: str
    :ivar deployment_id: Elastic deployment Id.
    :vartype deployment_id: str
    :ivar azure_subscription_id: Associated Azure subscription Id for the elastic deployment.
    :vartype azure_subscription_id: str
    :ivar elasticsearch_region: Region where Deployment at Elastic side took place.
    :vartype elasticsearch_region: str
    :ivar elasticsearch_service_url: Elasticsearch ingestion endpoint of the Elastic deployment.
    :vartype elasticsearch_service_url: str
    :ivar kibana_service_url: Kibana endpoint of the Elastic deployment.
    :vartype kibana_service_url: str
    :ivar kibana_sso_url: Kibana dashboard sso URL of the Elastic deployment.
    :vartype kibana_sso_url: str
    """

    _validation = {
        "name": {"readonly": True},
        "deployment_id": {"readonly": True},
        "azure_subscription_id": {"readonly": True},
        "elasticsearch_region": {"readonly": True},
        "elasticsearch_service_url": {"readonly": True},
        "kibana_service_url": {"readonly": True},
        "kibana_sso_url": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "deployment_id": {"key": "deploymentId", "type": "str"},
        "azure_subscription_id": {"key": "azureSubscriptionId", "type": "str"},
        "elasticsearch_region": {"key": "elasticsearchRegion", "type": "str"},
        "elasticsearch_service_url": {"key": "elasticsearchServiceUrl", "type": "str"},
        "kibana_service_url": {"key": "kibanaServiceUrl", "type": "str"},
        "kibana_sso_url": {"key": "kibanaSsoUrl", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.deployment_id: Optional[str] = None
        self.azure_subscription_id: Optional[str] = None
        self.elasticsearch_region: Optional[str] = None
        self.elasticsearch_service_url: Optional[str] = None
        self.kibana_service_url: Optional[str] = None
        self.kibana_sso_url: Optional[str] = None


class ElasticCloudUser(_serialization.Model):
    """Details of the user's elastic account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar email_address: Email of the Elastic User Account.
    :vartype email_address: str
    :ivar id: User Id of the elastic account of the User.
    :vartype id: str
    :ivar elastic_cloud_sso_default_url: Elastic cloud default dashboard sso URL of the Elastic
     user account.
    :vartype elastic_cloud_sso_default_url: str
    """

    _validation = {
        "email_address": {"readonly": True},
        "id": {"readonly": True},
        "elastic_cloud_sso_default_url": {"readonly": True},
    }

    _attribute_map = {
        "email_address": {"key": "emailAddress", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "elastic_cloud_sso_default_url": {"key": "elasticCloudSsoDefaultUrl", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.email_address: Optional[str] = None
        self.id: Optional[str] = None
        self.elastic_cloud_sso_default_url: Optional[str] = None


class ElasticMonitorResource(_serialization.Model):
    """Monitor resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: ARM id of the monitor resource.
    :vartype id: str
    :ivar name: Name of the monitor resource.
    :vartype name: str
    :ivar type: The type of the monitor resource.
    :vartype type: str
    :ivar kind: The kind of the Elastic resource - observability, security, search etc.
    :vartype kind: str
    :ivar sku: SKU of the monitor resource.
    :vartype sku: ~azure.mgmt.elastic.models.ResourceSku
    :ivar properties: Properties of the monitor resource.
    :vartype properties: ~azure.mgmt.elastic.models.MonitorProperties
    :ivar identity: Identity properties of the monitor resource.
    :vartype identity: ~azure.mgmt.elastic.models.IdentityProperties
    :ivar tags: The tags of the monitor resource.
    :vartype tags: dict[str, str]
    :ivar location: The location of the monitor resource. Required.
    :vartype location: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.elastic.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "sku": {"key": "sku", "type": "ResourceSku"},
        "properties": {"key": "properties", "type": "MonitorProperties"},
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        sku: Optional["_models.ResourceSku"] = None,
        properties: Optional["_models.MonitorProperties"] = None,
        identity: Optional["_models.IdentityProperties"] = None,
        tags: Optional[dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of the Elastic resource - observability, security, search etc.
        :paramtype kind: str
        :keyword sku: SKU of the monitor resource.
        :paramtype sku: ~azure.mgmt.elastic.models.ResourceSku
        :keyword properties: Properties of the monitor resource.
        :paramtype properties: ~azure.mgmt.elastic.models.MonitorProperties
        :keyword identity: Identity properties of the monitor resource.
        :paramtype identity: ~azure.mgmt.elastic.models.IdentityProperties
        :keyword tags: The tags of the monitor resource.
        :paramtype tags: dict[str, str]
        :keyword location: The location of the monitor resource. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.kind = kind
        self.sku = sku
        self.properties = properties
        self.identity = identity
        self.tags = tags
        self.location = location
        self.system_data: Optional["_models.SystemData"] = None


class ElasticMonitorResourceListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.elastic.models.ElasticMonitorResource]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ElasticMonitorResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ElasticMonitorResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.elastic.models.ElasticMonitorResource]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ElasticMonitorResourceUpdateParameters(_serialization.Model):
    """Monitor resource update parameters.

    :ivar tags: elastic monitor resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: elastic monitor resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ElasticMonitorUpgrade(_serialization.Model):
    """Upgrade elastic monitor version.

    :ivar version: Version to which the elastic monitor should be upgraded to.
    :vartype version: str
    """

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword version: Version to which the elastic monitor should be upgraded to.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.version = version


class ElasticOrganizationToAzureSubscriptionMappingResponse(_serialization.Model):  # pylint: disable=name-too-long
    """The Azure Subscription ID to which the Organization of the logged in user belongs and gets
    billed into.

    :ivar properties: The properties of Azure Subscription ID to which the Organization of the
     logged in user belongs and gets billed into.
    :vartype properties:
     ~azure.mgmt.elastic.models.ElasticOrganizationToAzureSubscriptionMappingResponseProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ElasticOrganizationToAzureSubscriptionMappingResponseProperties"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.ElasticOrganizationToAzureSubscriptionMappingResponseProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: The properties of Azure Subscription ID to which the Organization of the
         logged in user belongs and gets billed into.
        :paramtype properties:
         ~azure.mgmt.elastic.models.ElasticOrganizationToAzureSubscriptionMappingResponseProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ElasticOrganizationToAzureSubscriptionMappingResponseProperties(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The properties of Azure Subscription ID to which the Organization of the logged in user belongs
    and gets billed into.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar billed_azure_subscription_id: The Azure Subscription ID to which the Organization belongs
     and gets billed into. This is empty for a new user OR a user without an Elastic Organization.
    :vartype billed_azure_subscription_id: str
    :ivar marketplace_saas_info: Marketplace SaaS Info of the resource.
    :vartype marketplace_saas_info: ~azure.mgmt.elastic.models.MarketplaceSaaSInfo
    :ivar elastic_organization_id: The Elastic Organization Id.
    :vartype elastic_organization_id: str
    :ivar elastic_organization_name: The Elastic Organization Name.
    :vartype elastic_organization_name: str
    """

    _validation = {
        "marketplace_saas_info": {"readonly": True},
    }

    _attribute_map = {
        "billed_azure_subscription_id": {"key": "billedAzureSubscriptionId", "type": "str"},
        "marketplace_saas_info": {"key": "marketplaceSaasInfo", "type": "MarketplaceSaaSInfo"},
        "elastic_organization_id": {"key": "elasticOrganizationId", "type": "str"},
        "elastic_organization_name": {"key": "elasticOrganizationName", "type": "str"},
    }

    def __init__(
        self,
        *,
        billed_azure_subscription_id: Optional[str] = None,
        elastic_organization_id: Optional[str] = None,
        elastic_organization_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword billed_azure_subscription_id: The Azure Subscription ID to which the Organization
         belongs and gets billed into. This is empty for a new user OR a user without an Elastic
         Organization.
        :paramtype billed_azure_subscription_id: str
        :keyword elastic_organization_id: The Elastic Organization Id.
        :paramtype elastic_organization_id: str
        :keyword elastic_organization_name: The Elastic Organization Name.
        :paramtype elastic_organization_name: str
        """
        super().__init__(**kwargs)
        self.billed_azure_subscription_id = billed_azure_subscription_id
        self.marketplace_saas_info: Optional["_models.MarketplaceSaaSInfo"] = None
        self.elastic_organization_id = elastic_organization_id
        self.elastic_organization_name = elastic_organization_name


class ElasticProperties(_serialization.Model):
    """Elastic Resource Properties.

    :ivar elastic_cloud_user: Details of the user's elastic account.
    :vartype elastic_cloud_user: ~azure.mgmt.elastic.models.ElasticCloudUser
    :ivar elastic_cloud_deployment: Details of the elastic cloud deployment.
    :vartype elastic_cloud_deployment: ~azure.mgmt.elastic.models.ElasticCloudDeployment
    """

    _attribute_map = {
        "elastic_cloud_user": {"key": "elasticCloudUser", "type": "ElasticCloudUser"},
        "elastic_cloud_deployment": {"key": "elasticCloudDeployment", "type": "ElasticCloudDeployment"},
    }

    def __init__(
        self,
        *,
        elastic_cloud_user: Optional["_models.ElasticCloudUser"] = None,
        elastic_cloud_deployment: Optional["_models.ElasticCloudDeployment"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword elastic_cloud_user: Details of the user's elastic account.
        :paramtype elastic_cloud_user: ~azure.mgmt.elastic.models.ElasticCloudUser
        :keyword elastic_cloud_deployment: Details of the elastic cloud deployment.
        :paramtype elastic_cloud_deployment: ~azure.mgmt.elastic.models.ElasticCloudDeployment
        """
        super().__init__(**kwargs)
        self.elastic_cloud_user = elastic_cloud_user
        self.elastic_cloud_deployment = elastic_cloud_deployment


class ElasticTrafficFilter(_serialization.Model):
    """Elastic traffic filter object.

    :ivar id: Id of the elastic filter.
    :vartype id: str
    :ivar name: Name of the elastic filter.
    :vartype name: str
    :ivar description: Description of the elastic filter.
    :vartype description: str
    :ivar region: Region of the elastic filter.
    :vartype region: str
    :ivar type: Type of the elastic filter. Known values are: "ip" and "azure_private_endpoint".
    :vartype type: str or ~azure.mgmt.elastic.models.Type
    :ivar include_by_default: IncludeByDefault for the elastic filter.
    :vartype include_by_default: bool
    :ivar rules: Rules in the elastic filter.
    :vartype rules: list[~azure.mgmt.elastic.models.ElasticTrafficFilterRule]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "include_by_default": {"key": "includeByDefault", "type": "bool"},
        "rules": {"key": "rules", "type": "[ElasticTrafficFilterRule]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        description: Optional[str] = None,
        region: Optional[str] = None,
        type: Optional[Union[str, "_models.Type"]] = None,
        include_by_default: Optional[bool] = None,
        rules: Optional[list["_models.ElasticTrafficFilterRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Id of the elastic filter.
        :paramtype id: str
        :keyword name: Name of the elastic filter.
        :paramtype name: str
        :keyword description: Description of the elastic filter.
        :paramtype description: str
        :keyword region: Region of the elastic filter.
        :paramtype region: str
        :keyword type: Type of the elastic filter. Known values are: "ip" and "azure_private_endpoint".
        :paramtype type: str or ~azure.mgmt.elastic.models.Type
        :keyword include_by_default: IncludeByDefault for the elastic filter.
        :paramtype include_by_default: bool
        :keyword rules: Rules in the elastic filter.
        :paramtype rules: list[~azure.mgmt.elastic.models.ElasticTrafficFilterRule]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.description = description
        self.region = region
        self.type = type
        self.include_by_default = include_by_default
        self.rules = rules


class ElasticTrafficFilterResponse(_serialization.Model):
    """List of elastic traffic filters in the account.

    :ivar rulesets: List of elastic traffic filters in the account.
    :vartype rulesets: list[~azure.mgmt.elastic.models.ElasticTrafficFilter]
    """

    _attribute_map = {
        "rulesets": {"key": "rulesets", "type": "[ElasticTrafficFilter]"},
    }

    def __init__(self, *, rulesets: Optional[list["_models.ElasticTrafficFilter"]] = None, **kwargs: Any) -> None:
        """
        :keyword rulesets: List of elastic traffic filters in the account.
        :paramtype rulesets: list[~azure.mgmt.elastic.models.ElasticTrafficFilter]
        """
        super().__init__(**kwargs)
        self.rulesets = rulesets


class ElasticTrafficFilterRule(_serialization.Model):
    """Elastic traffic filter rule object.

    :ivar source: IP of the elastic filter rule.
    :vartype source: str
    :ivar description: Description of the elastic filter rule.
    :vartype description: str
    :ivar azure_endpoint_guid: Guid of Private Endpoint in the elastic filter rule.
    :vartype azure_endpoint_guid: str
    :ivar azure_endpoint_name: Name of the Private Endpoint in the elastic filter rule.
    :vartype azure_endpoint_name: str
    :ivar id: Id of the elastic filter rule.
    :vartype id: str
    """

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "azure_endpoint_guid": {"key": "azureEndpointGuid", "type": "str"},
        "azure_endpoint_name": {"key": "azureEndpointName", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        source: Optional[str] = None,
        description: Optional[str] = None,
        azure_endpoint_guid: Optional[str] = None,
        azure_endpoint_name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword source: IP of the elastic filter rule.
        :paramtype source: str
        :keyword description: Description of the elastic filter rule.
        :paramtype description: str
        :keyword azure_endpoint_guid: Guid of Private Endpoint in the elastic filter rule.
        :paramtype azure_endpoint_guid: str
        :keyword azure_endpoint_name: Name of the Private Endpoint in the elastic filter rule.
        :paramtype azure_endpoint_name: str
        :keyword id: Id of the elastic filter rule.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.source = source
        self.description = description
        self.azure_endpoint_guid = azure_endpoint_guid
        self.azure_endpoint_name = azure_endpoint_name
        self.id = id


class ElasticVersionListFormat(_serialization.Model):
    """Elastic Version List Format.

    :ivar properties: Elastic Version Properties.
    :vartype properties: ~azure.mgmt.elastic.models.ElasticVersionListProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "ElasticVersionListProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ElasticVersionListProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Elastic Version Properties.
        :paramtype properties: ~azure.mgmt.elastic.models.ElasticVersionListProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ElasticVersionListProperties(_serialization.Model):
    """Elastic Version Properties.

    :ivar version: Available elastic version of the given region.
    :vartype version: str
    """

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword version: Available elastic version of the given region.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.version = version


class ElasticVersionsListResponse(_serialization.Model):
    """List of elastic versions available in a region.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.elastic.models.ElasticVersionListFormat]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ElasticVersionListFormat]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.ElasticVersionListFormat"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.elastic.models.ElasticVersionListFormat]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.elastic.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.elastic.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[list["_models.ErrorDetail"]] = None
        self.additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.elastic.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.elastic.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseBody(_serialization.Model):
    """Error response body.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar target: Error target.
    :vartype target: str
    :ivar details: Error details.
    :vartype details: list[~azure.mgmt.elastic.models.ErrorResponseBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponseBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[list["_models.ErrorResponseBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message.
        :paramtype message: str
        :keyword target: Error target.
        :paramtype target: str
        :keyword details: Error details.
        :paramtype details: list[~azure.mgmt.elastic.models.ErrorResponseBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ExternalUserCreationResponse(_serialization.Model):
    """The properties of the response we got from elastic while creating external user.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created: Shows if user is created or updated.
    :vartype created: bool
    """

    _validation = {
        "created": {"readonly": True},
    }

    _attribute_map = {
        "created": {"key": "created", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.created: Optional[bool] = None


class ExternalUserInfo(_serialization.Model):
    """The properties of the request required for creating user on elastic side.

    :ivar user_name: Username of the user to be created or updated.
    :vartype user_name: str
    :ivar full_name: Full name of the user to be created or updated.
    :vartype full_name: str
    :ivar password: Password of the user to be created or updated.
    :vartype password: str
    :ivar email_id: Email id of the user to be created or updated.
    :vartype email_id: str
    :ivar roles: Roles to be assigned for  created or updated user.
    :vartype roles: list[str]
    """

    _attribute_map = {
        "user_name": {"key": "userName", "type": "str"},
        "full_name": {"key": "fullName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "email_id": {"key": "emailId", "type": "str"},
        "roles": {"key": "roles", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        user_name: Optional[str] = None,
        full_name: Optional[str] = None,
        password: Optional[str] = None,
        email_id: Optional[str] = None,
        roles: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_name: Username of the user to be created or updated.
        :paramtype user_name: str
        :keyword full_name: Full name of the user to be created or updated.
        :paramtype full_name: str
        :keyword password: Password of the user to be created or updated.
        :paramtype password: str
        :keyword email_id: Email id of the user to be created or updated.
        :paramtype email_id: str
        :keyword roles: Roles to be assigned for  created or updated user.
        :paramtype roles: list[str]
        """
        super().__init__(**kwargs)
        self.user_name = user_name
        self.full_name = full_name
        self.password = password
        self.email_id = email_id
        self.roles = roles


class FilteringTag(_serialization.Model):
    """The definition of a filtering tag. Filtering tags are used for capturing resources and
    include/exclude them from being monitored.

    :ivar name: The name (also known as the key) of the tag.
    :vartype name: str
    :ivar value: The value of the tag.
    :vartype value: str
    :ivar action: Valid actions for a filtering tag. Known values are: "Include" and "Exclude".
    :vartype action: str or ~azure.mgmt.elastic.models.TagAction
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        action: Optional[Union[str, "_models.TagAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name (also known as the key) of the tag.
        :paramtype name: str
        :keyword value: The value of the tag.
        :paramtype value: str
        :keyword action: Valid actions for a filtering tag. Known values are: "Include" and "Exclude".
        :paramtype action: str or ~azure.mgmt.elastic.models.TagAction
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.action = action


class IdentityProperties(_serialization.Model):
    """Identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The identity ID.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: Managed identity type. "SystemAssigned"
    :vartype type: str or ~azure.mgmt.elastic.models.ManagedIdentityTypes
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.ManagedIdentityTypes"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: Managed identity type. "SystemAssigned"
        :paramtype type: str or ~azure.mgmt.elastic.models.ManagedIdentityTypes
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type


class LogRules(_serialization.Model):
    """Set of rules for sending logs for the Monitor resource.

    :ivar send_aad_logs: Flag specifying if AAD logs should be sent for the Monitor resource.
    :vartype send_aad_logs: bool
    :ivar send_subscription_logs: Flag specifying if subscription logs should be sent for the
     Monitor resource.
    :vartype send_subscription_logs: bool
    :ivar send_activity_logs: Flag specifying if activity logs from Azure resources should be sent
     for the Monitor resource.
    :vartype send_activity_logs: bool
    :ivar filtering_tags: List of filtering tags to be used for capturing logs. This only takes
     effect if SendActivityLogs flag is enabled. If empty, all resources will be captured. If only
     Exclude action is specified, the rules will apply to the list of all available resources. If
     Include actions are specified, the rules will only include resources with the associated tags.
    :vartype filtering_tags: list[~azure.mgmt.elastic.models.FilteringTag]
    """

    _attribute_map = {
        "send_aad_logs": {"key": "sendAadLogs", "type": "bool"},
        "send_subscription_logs": {"key": "sendSubscriptionLogs", "type": "bool"},
        "send_activity_logs": {"key": "sendActivityLogs", "type": "bool"},
        "filtering_tags": {"key": "filteringTags", "type": "[FilteringTag]"},
    }

    def __init__(
        self,
        *,
        send_aad_logs: Optional[bool] = None,
        send_subscription_logs: Optional[bool] = None,
        send_activity_logs: Optional[bool] = None,
        filtering_tags: Optional[list["_models.FilteringTag"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword send_aad_logs: Flag specifying if AAD logs should be sent for the Monitor resource.
        :paramtype send_aad_logs: bool
        :keyword send_subscription_logs: Flag specifying if subscription logs should be sent for the
         Monitor resource.
        :paramtype send_subscription_logs: bool
        :keyword send_activity_logs: Flag specifying if activity logs from Azure resources should be
         sent for the Monitor resource.
        :paramtype send_activity_logs: bool
        :keyword filtering_tags: List of filtering tags to be used for capturing logs. This only takes
         effect if SendActivityLogs flag is enabled. If empty, all resources will be captured. If only
         Exclude action is specified, the rules will apply to the list of all available resources. If
         Include actions are specified, the rules will only include resources with the associated tags.
        :paramtype filtering_tags: list[~azure.mgmt.elastic.models.FilteringTag]
        """
        super().__init__(**kwargs)
        self.send_aad_logs = send_aad_logs
        self.send_subscription_logs = send_subscription_logs
        self.send_activity_logs = send_activity_logs
        self.filtering_tags = filtering_tags


class MarketplaceSaaSInfo(_serialization.Model):
    """Marketplace SAAS Info of the resource.

    :ivar marketplace_subscription: Marketplace Subscription.
    :vartype marketplace_subscription:
     ~azure.mgmt.elastic.models.MarketplaceSaaSInfoMarketplaceSubscription
    :ivar marketplace_name: Marketplace Subscription Details: SAAS Name.
    :vartype marketplace_name: str
    :ivar marketplace_resource_id: Marketplace Subscription Details: Resource URI.
    :vartype marketplace_resource_id: str
    :ivar marketplace_status: Marketplace Subscription Details: SaaS Subscription Status.
    :vartype marketplace_status: str
    :ivar billed_azure_subscription_id: The Azure Subscription ID to which the Marketplace
     Subscription belongs and gets billed into.
    :vartype billed_azure_subscription_id: str
    :ivar subscribed: Flag specifying if the Marketplace status is subscribed or not.
    :vartype subscribed: bool
    """

    _attribute_map = {
        "marketplace_subscription": {
            "key": "marketplaceSubscription",
            "type": "MarketplaceSaaSInfoMarketplaceSubscription",
        },
        "marketplace_name": {"key": "marketplaceName", "type": "str"},
        "marketplace_resource_id": {"key": "marketplaceResourceId", "type": "str"},
        "marketplace_status": {"key": "marketplaceStatus", "type": "str"},
        "billed_azure_subscription_id": {"key": "billedAzureSubscriptionId", "type": "str"},
        "subscribed": {"key": "subscribed", "type": "bool"},
    }

    def __init__(
        self,
        *,
        marketplace_subscription: Optional["_models.MarketplaceSaaSInfoMarketplaceSubscription"] = None,
        marketplace_name: Optional[str] = None,
        marketplace_resource_id: Optional[str] = None,
        marketplace_status: Optional[str] = None,
        billed_azure_subscription_id: Optional[str] = None,
        subscribed: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword marketplace_subscription: Marketplace Subscription.
        :paramtype marketplace_subscription:
         ~azure.mgmt.elastic.models.MarketplaceSaaSInfoMarketplaceSubscription
        :keyword marketplace_name: Marketplace Subscription Details: SAAS Name.
        :paramtype marketplace_name: str
        :keyword marketplace_resource_id: Marketplace Subscription Details: Resource URI.
        :paramtype marketplace_resource_id: str
        :keyword marketplace_status: Marketplace Subscription Details: SaaS Subscription Status.
        :paramtype marketplace_status: str
        :keyword billed_azure_subscription_id: The Azure Subscription ID to which the Marketplace
         Subscription belongs and gets billed into.
        :paramtype billed_azure_subscription_id: str
        :keyword subscribed: Flag specifying if the Marketplace status is subscribed or not.
        :paramtype subscribed: bool
        """
        super().__init__(**kwargs)
        self.marketplace_subscription = marketplace_subscription
        self.marketplace_name = marketplace_name
        self.marketplace_resource_id = marketplace_resource_id
        self.marketplace_status = marketplace_status
        self.billed_azure_subscription_id = billed_azure_subscription_id
        self.subscribed = subscribed


class MarketplaceSaaSInfoMarketplaceSubscription(_serialization.Model):  # pylint: disable=name-too-long
    """Marketplace Subscription.

    :ivar id: Marketplace Subscription Id. This is a GUID-formatted string.
    :vartype id: str
    :ivar publisher_id: Publisher Id of the Marketplace offer.
    :vartype publisher_id: str
    :ivar offer_id: Offer Id of the Marketplace offer,.
    :vartype offer_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "publisher_id": {"key": "publisherId", "type": "str"},
        "offer_id": {"key": "offerId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        publisher_id: Optional[str] = None,
        offer_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Marketplace Subscription Id. This is a GUID-formatted string.
        :paramtype id: str
        :keyword publisher_id: Publisher Id of the Marketplace offer.
        :paramtype publisher_id: str
        :keyword offer_id: Offer Id of the Marketplace offer,.
        :paramtype offer_id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.publisher_id = publisher_id
        self.offer_id = offer_id


class MonitoredResource(_serialization.Model):
    """The properties of a resource currently being monitored by the Elastic monitor resource.

    :ivar id: The ARM id of the resource.
    :vartype id: str
    :ivar sending_logs: Flag indicating the status of the resource for sending logs operation to
     Elastic. Known values are: "True" and "False".
    :vartype sending_logs: str or ~azure.mgmt.elastic.models.SendingLogs
    :ivar reason_for_logs_status: Reason for why the resource is sending logs (or why it is not
     sending).
    :vartype reason_for_logs_status: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "sending_logs": {"key": "sendingLogs", "type": "str"},
        "reason_for_logs_status": {"key": "reasonForLogsStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        sending_logs: Optional[Union[str, "_models.SendingLogs"]] = None,
        reason_for_logs_status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ARM id of the resource.
        :paramtype id: str
        :keyword sending_logs: Flag indicating the status of the resource for sending logs operation to
         Elastic. Known values are: "True" and "False".
        :paramtype sending_logs: str or ~azure.mgmt.elastic.models.SendingLogs
        :keyword reason_for_logs_status: Reason for why the resource is sending logs (or why it is not
         sending).
        :paramtype reason_for_logs_status: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.sending_logs = sending_logs
        self.reason_for_logs_status = reason_for_logs_status


class MonitoredResourceListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.elastic.models.MonitoredResource]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MonitoredResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.MonitoredResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.elastic.models.MonitoredResource]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MonitoredSubscription(_serialization.Model):
    """The list of subscriptions and it's monitoring status by current Elastic monitor.

    :ivar subscription_id: The subscriptionId to be monitored.
    :vartype subscription_id: str
    :ivar status: The state of monitoring. Known values are: "InProgress", "Active", "Failed", and
     "Deleting".
    :vartype status: str or ~azure.mgmt.elastic.models.Status
    :ivar error: The reason of not monitoring the subscription.
    :vartype error: str
    :ivar tag_rules: Definition of the properties for a TagRules resource.
    :vartype tag_rules: ~azure.mgmt.elastic.models.MonitoringTagRulesProperties
    """

    _attribute_map = {
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "str"},
        "tag_rules": {"key": "tagRules", "type": "MonitoringTagRulesProperties"},
    }

    def __init__(
        self,
        *,
        subscription_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        error: Optional[str] = None,
        tag_rules: Optional["_models.MonitoringTagRulesProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subscription_id: The subscriptionId to be monitored.
        :paramtype subscription_id: str
        :keyword status: The state of monitoring. Known values are: "InProgress", "Active", "Failed",
         and "Deleting".
        :paramtype status: str or ~azure.mgmt.elastic.models.Status
        :keyword error: The reason of not monitoring the subscription.
        :paramtype error: str
        :keyword tag_rules: Definition of the properties for a TagRules resource.
        :paramtype tag_rules: ~azure.mgmt.elastic.models.MonitoringTagRulesProperties
        """
        super().__init__(**kwargs)
        self.subscription_id = subscription_id
        self.status = status
        self.error = error
        self.tag_rules = tag_rules


class MonitoredSubscriptionProperties(_serialization.Model):
    """The request to update subscriptions needed to be monitored by the Elastic monitor resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the monitored subscription resource.
    :vartype name: str
    :ivar id: The id of the monitored subscription resource.
    :vartype id: str
    :ivar type: The type of the monitored subscription resource.
    :vartype type: str
    :ivar properties: The request to update subscriptions needed to be monitored by the Elastic
     monitor resource.
    :vartype properties: ~azure.mgmt.elastic.models.SubscriptionList
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "SubscriptionList"},
    }

    def __init__(self, *, properties: Optional["_models.SubscriptionList"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The request to update subscriptions needed to be monitored by the Elastic
         monitor resource.
        :paramtype properties: ~azure.mgmt.elastic.models.SubscriptionList
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.id: Optional[str] = None
        self.type: Optional[str] = None
        self.properties = properties


class MonitoredSubscriptionPropertiesList(_serialization.Model):
    """MonitoredSubscriptionPropertiesList.

    :ivar value:
    :vartype value: list[~azure.mgmt.elastic.models.MonitoredSubscriptionProperties]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MonitoredSubscriptionProperties]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.MonitoredSubscriptionProperties"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.elastic.models.MonitoredSubscriptionProperties]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MonitoringTagRules(_serialization.Model):
    """Capture logs and metrics of Azure resources based on ARM tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the rule set.
    :vartype name: str
    :ivar id: The id of the rule set.
    :vartype id: str
    :ivar type: The type of the rule set.
    :vartype type: str
    :ivar properties: Properties of the monitoring tag rules.
    :vartype properties: ~azure.mgmt.elastic.models.MonitoringTagRulesProperties
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.elastic.models.SystemData
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "MonitoringTagRulesProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, *, properties: Optional["_models.MonitoringTagRulesProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the monitoring tag rules.
        :paramtype properties: ~azure.mgmt.elastic.models.MonitoringTagRulesProperties
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.id: Optional[str] = None
        self.type: Optional[str] = None
        self.properties = properties
        self.system_data: Optional["_models.SystemData"] = None


class MonitoringTagRulesListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.elastic.models.MonitoringTagRules]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MonitoringTagRules]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.MonitoringTagRules"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.elastic.models.MonitoringTagRules]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MonitoringTagRulesProperties(_serialization.Model):
    """Definition of the properties for a TagRules resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the monitoring tag rules. Known values are:
     "Accepted", "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted",
     and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.elastic.models.ProvisioningState
    :ivar log_rules: Rules for sending logs.
    :vartype log_rules: ~azure.mgmt.elastic.models.LogRules
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "log_rules": {"key": "logRules", "type": "LogRules"},
    }

    def __init__(self, *, log_rules: Optional["_models.LogRules"] = None, **kwargs: Any) -> None:
        """
        :keyword log_rules: Rules for sending logs.
        :paramtype log_rules: ~azure.mgmt.elastic.models.LogRules
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.log_rules = log_rules


class MonitorProperties(_serialization.Model):
    """Properties specific to the monitor resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the monitor resource. Known values are:
     "Accepted", "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted",
     and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.elastic.models.ProvisioningState
    :ivar monitoring_status: Flag specifying if the resource monitoring is enabled or disabled.
     Known values are: "Enabled" and "Disabled".
    :vartype monitoring_status: str or ~azure.mgmt.elastic.models.MonitoringStatus
    :ivar elastic_properties: Elastic cloud properties.
    :vartype elastic_properties: ~azure.mgmt.elastic.models.ElasticProperties
    :ivar user_info: User information.
    :vartype user_info: ~azure.mgmt.elastic.models.UserInfo
    :ivar plan_details: Plan details of the monitor resource.
    :vartype plan_details: ~azure.mgmt.elastic.models.PlanDetails
    :ivar version: Version of elastic of the monitor resource.
    :vartype version: str
    :ivar subscription_state: State of the Azure Subscription containing the monitor resource.
    :vartype subscription_state: str
    :ivar saa_s_azure_subscription_status: Status of Azure Subscription where Marketplace SaaS is
     located.
    :vartype saa_s_azure_subscription_status: str
    :ivar source_campaign_name: Name of the marketing campaign.
    :vartype source_campaign_name: str
    :ivar source_campaign_id: A unique identifier associated with the campaign.
    :vartype source_campaign_id: str
    :ivar liftr_resource_category: Known values are: "Unknown" and "MonitorLogs".
    :vartype liftr_resource_category: str or ~azure.mgmt.elastic.models.LiftrResourceCategories
    :ivar liftr_resource_preference: The priority of the resource.
    :vartype liftr_resource_preference: int
    :ivar generate_api_key: Flag to determine if User API Key has to be generated and shared.
    :vartype generate_api_key: bool
    :ivar hosting_type: Hosting type of the monitor resource - either Hosted deployments OR
     Serverless Projects. Known values are: "Hosted" and "Serverless".
    :vartype hosting_type: str or ~azure.mgmt.elastic.models.HostingType
    :ivar project_details: Project details of the monitor resource IF it belongs to Serverless
     offer kind.
    :vartype project_details: ~azure.mgmt.elastic.models.ProjectDetails
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "liftr_resource_category": {"readonly": True},
        "liftr_resource_preference": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "monitoring_status": {"key": "monitoringStatus", "type": "str"},
        "elastic_properties": {"key": "elasticProperties", "type": "ElasticProperties"},
        "user_info": {"key": "userInfo", "type": "UserInfo"},
        "plan_details": {"key": "planDetails", "type": "PlanDetails"},
        "version": {"key": "version", "type": "str"},
        "subscription_state": {"key": "subscriptionState", "type": "str"},
        "saa_s_azure_subscription_status": {"key": "saaSAzureSubscriptionStatus", "type": "str"},
        "source_campaign_name": {"key": "sourceCampaignName", "type": "str"},
        "source_campaign_id": {"key": "sourceCampaignId", "type": "str"},
        "liftr_resource_category": {"key": "liftrResourceCategory", "type": "str"},
        "liftr_resource_preference": {"key": "liftrResourcePreference", "type": "int"},
        "generate_api_key": {"key": "generateApiKey", "type": "bool"},
        "hosting_type": {"key": "hostingType", "type": "str"},
        "project_details": {"key": "projectDetails", "type": "ProjectDetails"},
    }

    def __init__(
        self,
        *,
        monitoring_status: Optional[Union[str, "_models.MonitoringStatus"]] = None,
        elastic_properties: Optional["_models.ElasticProperties"] = None,
        user_info: Optional["_models.UserInfo"] = None,
        plan_details: Optional["_models.PlanDetails"] = None,
        version: Optional[str] = None,
        subscription_state: Optional[str] = None,
        saa_s_azure_subscription_status: Optional[str] = None,
        source_campaign_name: Optional[str] = None,
        source_campaign_id: Optional[str] = None,
        generate_api_key: Optional[bool] = None,
        hosting_type: Optional[Union[str, "_models.HostingType"]] = None,
        project_details: Optional["_models.ProjectDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword monitoring_status: Flag specifying if the resource monitoring is enabled or disabled.
         Known values are: "Enabled" and "Disabled".
        :paramtype monitoring_status: str or ~azure.mgmt.elastic.models.MonitoringStatus
        :keyword elastic_properties: Elastic cloud properties.
        :paramtype elastic_properties: ~azure.mgmt.elastic.models.ElasticProperties
        :keyword user_info: User information.
        :paramtype user_info: ~azure.mgmt.elastic.models.UserInfo
        :keyword plan_details: Plan details of the monitor resource.
        :paramtype plan_details: ~azure.mgmt.elastic.models.PlanDetails
        :keyword version: Version of elastic of the monitor resource.
        :paramtype version: str
        :keyword subscription_state: State of the Azure Subscription containing the monitor resource.
        :paramtype subscription_state: str
        :keyword saa_s_azure_subscription_status: Status of Azure Subscription where Marketplace SaaS
         is located.
        :paramtype saa_s_azure_subscription_status: str
        :keyword source_campaign_name: Name of the marketing campaign.
        :paramtype source_campaign_name: str
        :keyword source_campaign_id: A unique identifier associated with the campaign.
        :paramtype source_campaign_id: str
        :keyword generate_api_key: Flag to determine if User API Key has to be generated and shared.
        :paramtype generate_api_key: bool
        :keyword hosting_type: Hosting type of the monitor resource - either Hosted deployments OR
         Serverless Projects. Known values are: "Hosted" and "Serverless".
        :paramtype hosting_type: str or ~azure.mgmt.elastic.models.HostingType
        :keyword project_details: Project details of the monitor resource IF it belongs to Serverless
         offer kind.
        :paramtype project_details: ~azure.mgmt.elastic.models.ProjectDetails
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.monitoring_status = monitoring_status
        self.elastic_properties = elastic_properties
        self.user_info = user_info
        self.plan_details = plan_details
        self.version = version
        self.subscription_state = subscription_state
        self.saa_s_azure_subscription_status = saa_s_azure_subscription_status
        self.source_campaign_name = source_campaign_name
        self.source_campaign_id = source_campaign_id
        self.liftr_resource_category: Optional[Union[str, "_models.LiftrResourceCategories"]] = None
        self.liftr_resource_preference: Optional[int] = None
        self.generate_api_key = generate_api_key
        self.hosting_type = hosting_type
        self.project_details = project_details


class OpenAIIntegrationProperties(_serialization.Model):
    """Open AI Integration details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar open_ai_resource_id: The resource name of Open AI resource.
    :vartype open_ai_resource_id: str
    :ivar open_ai_resource_endpoint: The API endpoint for Open AI resource.
    :vartype open_ai_resource_endpoint: str
    :ivar open_ai_connector_id: The connector id of Open AI resource.
    :vartype open_ai_connector_id: str
    :ivar key: Value of API key for Open AI resource.
    :vartype key: str
    :ivar last_refresh_at: Last Update Timestamp for key updation.
    :vartype last_refresh_at: ~datetime.datetime
    """

    _validation = {
        "last_refresh_at": {"readonly": True},
    }

    _attribute_map = {
        "open_ai_resource_id": {"key": "openAIResourceId", "type": "str"},
        "open_ai_resource_endpoint": {"key": "openAIResourceEndpoint", "type": "str"},
        "open_ai_connector_id": {"key": "openAIConnectorId", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "last_refresh_at": {"key": "lastRefreshAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        open_ai_resource_id: Optional[str] = None,
        open_ai_resource_endpoint: Optional[str] = None,
        open_ai_connector_id: Optional[str] = None,
        key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword open_ai_resource_id: The resource name of Open AI resource.
        :paramtype open_ai_resource_id: str
        :keyword open_ai_resource_endpoint: The API endpoint for Open AI resource.
        :paramtype open_ai_resource_endpoint: str
        :keyword open_ai_connector_id: The connector id of Open AI resource.
        :paramtype open_ai_connector_id: str
        :keyword key: Value of API key for Open AI resource.
        :paramtype key: str
        """
        super().__init__(**kwargs)
        self.open_ai_resource_id = open_ai_resource_id
        self.open_ai_resource_endpoint = open_ai_resource_endpoint
        self.open_ai_connector_id = open_ai_connector_id
        self.key = key
        self.last_refresh_at: Optional[datetime.datetime] = None


class OpenAIIntegrationRPModel(_serialization.Model):
    """Capture properties of Open AI resource Integration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the integration.
    :vartype name: str
    :ivar id: The id of the integration.
    :vartype id: str
    :ivar type: The type of the integration.
    :vartype type: str
    :ivar properties: Open AI Integration details.
    :vartype properties: ~azure.mgmt.elastic.models.OpenAIIntegrationProperties
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "OpenAIIntegrationProperties"},
    }

    def __init__(self, *, properties: Optional["_models.OpenAIIntegrationProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Open AI Integration details.
        :paramtype properties: ~azure.mgmt.elastic.models.OpenAIIntegrationProperties
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.id: Optional[str] = None
        self.type: Optional[str] = None
        self.properties = properties


class OpenAIIntegrationRPModelListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.elastic.models.OpenAIIntegrationRPModel]
    :ivar next_link: Link to the next set of results, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OpenAIIntegrationRPModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.OpenAIIntegrationRPModel"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.elastic.models.OpenAIIntegrationRPModel]
        :keyword next_link: Link to the next set of results, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OpenAIIntegrationStatusResponse(_serialization.Model):
    """Status of the OpenAI Integration.

    :ivar properties: Status of the OpenAI Integration.
    :vartype properties: ~azure.mgmt.elastic.models.OpenAIIntegrationStatusResponseProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "OpenAIIntegrationStatusResponseProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.OpenAIIntegrationStatusResponseProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Status of the OpenAI Integration.
        :paramtype properties: ~azure.mgmt.elastic.models.OpenAIIntegrationStatusResponseProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class OpenAIIntegrationStatusResponseProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Status of the OpenAI Integration.

    :ivar status: Status of the OpenAI Integration.
    :vartype status: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword status: Status of the OpenAI Integration.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.status = status


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider, i.e., Microsoft.Elastic.
    :vartype provider: str
    :ivar resource: Type on which the operation is performed, e.g., 'monitors'.
    :vartype resource: str
    :ivar operation: Operation type, e.g., read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation, e.g., 'Write monitors'.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider, i.e., Microsoft.Elastic.
        :paramtype provider: str
        :keyword resource: Type on which the operation is performed, e.g., 'monitors'.
        :paramtype resource: str
        :keyword operation: Operation type, e.g., read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation, e.g., 'Write monitors'.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of GET request to list the Microsoft.Elastic operations.

    :ivar value: List of operations supported by the Microsoft.Elastic provider.
    :vartype value: list[~azure.mgmt.elastic.models.OperationResult]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.OperationResult"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of operations supported by the Microsoft.Elastic provider.
        :paramtype value: list[~azure.mgmt.elastic.models.OperationResult]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationResult(_serialization.Model):
    """A Microsoft.Elastic REST API operation.

    :ivar name: Operation name, i.e., {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.elastic.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name, i.e., {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.elastic.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin


class PartnerBillingEntity(_serialization.Model):
    """Partner Billing details associated with the resource.

    :ivar id: The Elastic Organization Id.
    :vartype id: str
    :ivar name: The Elastic Organization Name.
    :vartype name: str
    :ivar partner_entity_uri: Link to the elastic organization page.
    :vartype partner_entity_uri: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "partner_entity_uri": {"key": "partnerEntityUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        partner_entity_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The Elastic Organization Id.
        :paramtype id: str
        :keyword name: The Elastic Organization Name.
        :paramtype name: str
        :keyword partner_entity_uri: Link to the elastic organization page.
        :paramtype partner_entity_uri: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.partner_entity_uri = partner_entity_uri


class PlanDetails(_serialization.Model):
    """Plan details of the monitor resource.

    :ivar offer_id: Offer ID of the plan.
    :vartype offer_id: str
    :ivar publisher_id: Publisher ID of the plan.
    :vartype publisher_id: str
    :ivar term_id: Term ID of the plan.
    :vartype term_id: str
    :ivar plan_id: Plan ID.
    :vartype plan_id: str
    :ivar plan_name: Plan Name.
    :vartype plan_name: str
    """

    _attribute_map = {
        "offer_id": {"key": "offerID", "type": "str"},
        "publisher_id": {"key": "publisherID", "type": "str"},
        "term_id": {"key": "termID", "type": "str"},
        "plan_id": {"key": "planID", "type": "str"},
        "plan_name": {"key": "planName", "type": "str"},
    }

    def __init__(
        self,
        *,
        offer_id: Optional[str] = None,
        publisher_id: Optional[str] = None,
        term_id: Optional[str] = None,
        plan_id: Optional[str] = None,
        plan_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword offer_id: Offer ID of the plan.
        :paramtype offer_id: str
        :keyword publisher_id: Publisher ID of the plan.
        :paramtype publisher_id: str
        :keyword term_id: Term ID of the plan.
        :paramtype term_id: str
        :keyword plan_id: Plan ID.
        :paramtype plan_id: str
        :keyword plan_name: Plan Name.
        :paramtype plan_name: str
        """
        super().__init__(**kwargs)
        self.offer_id = offer_id
        self.publisher_id = publisher_id
        self.term_id = term_id
        self.plan_id = plan_id
        self.plan_name = plan_name


class ProjectDetails(_serialization.Model):
    """Project details of the monitor resource IF it belongs to Serverless offer kind.

    :ivar project_type: Project type; ex: Elasticsearch / Observability / Security. Known values
     are: "Elasticsearch", "Observability", "Security", and "NotApplicable".
    :vartype project_type: str or ~azure.mgmt.elastic.models.ProjectType
    :ivar configuration_type: Configuration type of the Elasticsearch project. Known values are:
     "GeneralPurpose", "Vector", "TimeSeries", and "NotApplicable".
    :vartype configuration_type: str or ~azure.mgmt.elastic.models.ConfigurationType
    """

    _attribute_map = {
        "project_type": {"key": "projectType", "type": "str"},
        "configuration_type": {"key": "configurationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        project_type: Optional[Union[str, "_models.ProjectType"]] = None,
        configuration_type: Optional[Union[str, "_models.ConfigurationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword project_type: Project type; ex: Elasticsearch / Observability / Security. Known values
         are: "Elasticsearch", "Observability", "Security", and "NotApplicable".
        :paramtype project_type: str or ~azure.mgmt.elastic.models.ProjectType
        :keyword configuration_type: Configuration type of the Elasticsearch project. Known values are:
         "GeneralPurpose", "Vector", "TimeSeries", and "NotApplicable".
        :paramtype configuration_type: str or ~azure.mgmt.elastic.models.ConfigurationType
        """
        super().__init__(**kwargs)
        self.project_type = project_type
        self.configuration_type = configuration_type


class ResourceProviderDefaultErrorResponse(_serialization.Model):
    """RP default error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Response body of Error.
    :vartype error: ~azure.mgmt.elastic.models.ErrorResponseBody
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseBody"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error: Optional["_models.ErrorResponseBody"] = None


class ResourceSku(_serialization.Model):
    """Microsoft.Elastic SKU.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the SKU. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Name of the SKU. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class ResubscribeProperties(_serialization.Model):
    """Resubscribe Properties.

    :ivar plan_id: Newly selected plan Id to create the new Marketplace subscription for
     Resubscribe.
    :vartype plan_id: str
    :ivar term: Newly selected term to create the new Marketplace subscription for Resubscribe.
    :vartype term: str
    :ivar subscription_id: Newly selected Azure Subscription Id in which the new Marketplace
     subscription will be created for Resubscribe.
    :vartype subscription_id: str
    :ivar resource_group: Newly selected Azure resource group in which the new Marketplace
     subscription will be created for Resubscribe.
    :vartype resource_group: str
    :ivar organization_id: Organization Id of the Elastic Organization that needs to be
     resubscribed.
    :vartype organization_id: str
    """

    _attribute_map = {
        "plan_id": {"key": "planId", "type": "str"},
        "term": {"key": "term", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "organization_id": {"key": "organizationId", "type": "str"},
    }

    def __init__(
        self,
        *,
        plan_id: Optional[str] = None,
        term: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        organization_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword plan_id: Newly selected plan Id to create the new Marketplace subscription for
         Resubscribe.
        :paramtype plan_id: str
        :keyword term: Newly selected term to create the new Marketplace subscription for Resubscribe.
        :paramtype term: str
        :keyword subscription_id: Newly selected Azure Subscription Id in which the new Marketplace
         subscription will be created for Resubscribe.
        :paramtype subscription_id: str
        :keyword resource_group: Newly selected Azure resource group in which the new Marketplace
         subscription will be created for Resubscribe.
        :paramtype resource_group: str
        :keyword organization_id: Organization Id of the Elastic Organization that needs to be
         resubscribed.
        :paramtype organization_id: str
        """
        super().__init__(**kwargs)
        self.plan_id = plan_id
        self.term = term
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.organization_id = organization_id


class SubscriptionList(_serialization.Model):
    """The request to update subscriptions needed to be monitored by the Elastic monitor resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar operation: The operation for the patch on the resource. Known values are: "AddBegin",
     "AddComplete", "DeleteBegin", "DeleteComplete", and "Active".
    :vartype operation: str or ~azure.mgmt.elastic.models.Operation
    :ivar monitored_subscription_list: List of subscriptions and the state of the monitoring.
    :vartype monitored_subscription_list: list[~azure.mgmt.elastic.models.MonitoredSubscription]
    :ivar provisioning_state: Provisioning State of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.elastic.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "operation": {"key": "operation", "type": "str"},
        "monitored_subscription_list": {"key": "monitoredSubscriptionList", "type": "[MonitoredSubscription]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        operation: Optional[Union[str, "_models.Operation"]] = None,
        monitored_subscription_list: Optional[list["_models.MonitoredSubscription"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation: The operation for the patch on the resource. Known values are: "AddBegin",
         "AddComplete", "DeleteBegin", "DeleteComplete", and "Active".
        :paramtype operation: str or ~azure.mgmt.elastic.models.Operation
        :keyword monitored_subscription_list: List of subscriptions and the state of the monitoring.
        :paramtype monitored_subscription_list: list[~azure.mgmt.elastic.models.MonitoredSubscription]
        """
        super().__init__(**kwargs)
        self.operation = operation
        self.monitored_subscription_list = monitored_subscription_list
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.elastic.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.elastic.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.elastic.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.elastic.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UpgradableVersionsList(_serialization.Model):
    """Stack Versions that this version can upgrade to.

    :ivar current_version: Current version of the elastic monitor.
    :vartype current_version: str
    :ivar upgradable_versions: Stack Versions that this version can upgrade to.
    :vartype upgradable_versions: list[str]
    """

    _attribute_map = {
        "current_version": {"key": "currentVersion", "type": "str"},
        "upgradable_versions": {"key": "upgradableVersions", "type": "[str]"},
    }

    def __init__(
        self, *, current_version: Optional[str] = None, upgradable_versions: Optional[list[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword current_version: Current version of the elastic monitor.
        :paramtype current_version: str
        :keyword upgradable_versions: Stack Versions that this version can upgrade to.
        :paramtype upgradable_versions: list[str]
        """
        super().__init__(**kwargs)
        self.current_version = current_version
        self.upgradable_versions = upgradable_versions


class UserApiKeyResponse(_serialization.Model):
    """The User Api Key created for the Organization associated with the User Email Id that was passed
    in the request.

    :ivar properties:
    :vartype properties: ~azure.mgmt.elastic.models.UserApiKeyResponseProperties
    """

    _attribute_map = {
        "properties": {"key": "properties", "type": "UserApiKeyResponseProperties"},
    }

    def __init__(self, *, properties: Optional["_models.UserApiKeyResponseProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.elastic.models.UserApiKeyResponseProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class UserApiKeyResponseProperties(_serialization.Model):
    """UserApiKeyResponseProperties.

    :ivar api_key: The User Api Key Generated based on GenerateApiKey flag. This is applicable for
     non-Portal clients only.
    :vartype api_key: str
    """

    _attribute_map = {
        "api_key": {"key": "apiKey", "type": "str"},
    }

    def __init__(self, *, api_key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword api_key: The User Api Key Generated based on GenerateApiKey flag. This is applicable
         for non-Portal clients only.
        :paramtype api_key: str
        """
        super().__init__(**kwargs)
        self.api_key = api_key


class UserEmailId(_serialization.Model):
    """Email Id of the User Organization, of which the API Key must be returned.

    :ivar email_id: The User email Id.
    :vartype email_id: str
    """

    _attribute_map = {
        "email_id": {"key": "emailId", "type": "str"},
    }

    def __init__(self, *, email_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword email_id: The User email Id.
        :paramtype email_id: str
        """
        super().__init__(**kwargs)
        self.email_id = email_id


class UserInfo(_serialization.Model):
    """User Information to be passed to partners.

    :ivar first_name: First name of the user.
    :vartype first_name: str
    :ivar last_name: Last name of the user.
    :vartype last_name: str
    :ivar company_name: Company name of the user.
    :vartype company_name: str
    :ivar email_address: Email of the user used by Elastic for contacting them if needed.
    :vartype email_address: str
    :ivar company_info: Company information of the user to be passed to partners.
    :vartype company_info: ~azure.mgmt.elastic.models.CompanyInfo
    """

    _validation = {
        "first_name": {"max_length": 128},
        "last_name": {"max_length": 128},
        "company_name": {"max_length": 128},
        "email_address": {
            "pattern": r'^([^<>()\[\]\.,;:\s@"]+(\.[^<>()\[\]\.,;:\s@"]+)*)@(([a-zA-Z-_0-9]+\.)+[a-zA-Z]{2,})$'
        },
    }

    _attribute_map = {
        "first_name": {"key": "firstName", "type": "str"},
        "last_name": {"key": "lastName", "type": "str"},
        "company_name": {"key": "companyName", "type": "str"},
        "email_address": {"key": "emailAddress", "type": "str"},
        "company_info": {"key": "companyInfo", "type": "CompanyInfo"},
    }

    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        company_name: Optional[str] = None,
        email_address: Optional[str] = None,
        company_info: Optional["_models.CompanyInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword first_name: First name of the user.
        :paramtype first_name: str
        :keyword last_name: Last name of the user.
        :paramtype last_name: str
        :keyword company_name: Company name of the user.
        :paramtype company_name: str
        :keyword email_address: Email of the user used by Elastic for contacting them if needed.
        :paramtype email_address: str
        :keyword company_info: Company information of the user to be passed to partners.
        :paramtype company_info: ~azure.mgmt.elastic.models.CompanyInfo
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.company_name = company_name
        self.email_address = email_address
        self.company_info = company_info


class VMCollectionUpdate(_serialization.Model):
    """Update VM resource collection.

    :ivar vm_resource_id: ARM id of the VM resource.
    :vartype vm_resource_id: str
    :ivar operation_name: Operation to be performed for given VM. Known values are: "Add" and
     "Delete".
    :vartype operation_name: str or ~azure.mgmt.elastic.models.OperationName
    """

    _attribute_map = {
        "vm_resource_id": {"key": "vmResourceId", "type": "str"},
        "operation_name": {"key": "operationName", "type": "str"},
    }

    def __init__(
        self,
        *,
        vm_resource_id: Optional[str] = None,
        operation_name: Optional[Union[str, "_models.OperationName"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_resource_id: ARM id of the VM resource.
        :paramtype vm_resource_id: str
        :keyword operation_name: Operation to be performed for given VM. Known values are: "Add" and
         "Delete".
        :paramtype operation_name: str or ~azure.mgmt.elastic.models.OperationName
        """
        super().__init__(**kwargs)
        self.vm_resource_id = vm_resource_id
        self.operation_name = operation_name


class VMHostListResponse(_serialization.Model):
    """Response of a list operation.

    :ivar value: Results of a list operation.
    :vartype value: list[~azure.mgmt.elastic.models.VMResources]
    :ivar next_link: Link to the next Vm resource Id, if any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VMResources]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[list["_models.VMResources"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of a list operation.
        :paramtype value: list[~azure.mgmt.elastic.models.VMResources]
        :keyword next_link: Link to the next Vm resource Id, if any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VMIngestionDetailsResponse(_serialization.Model):
    """The vm ingestion details to install an agent.

    :ivar cloud_id: The cloudId of given Elastic monitor resource.
    :vartype cloud_id: str
    :ivar ingestion_key: Ingestion details to install agent on given VM.
    :vartype ingestion_key: str
    """

    _attribute_map = {
        "cloud_id": {"key": "cloudId", "type": "str"},
        "ingestion_key": {"key": "ingestionKey", "type": "str"},
    }

    def __init__(self, *, cloud_id: Optional[str] = None, ingestion_key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_id: The cloudId of given Elastic monitor resource.
        :paramtype cloud_id: str
        :keyword ingestion_key: Ingestion details to install agent on given VM.
        :paramtype ingestion_key: str
        """
        super().__init__(**kwargs)
        self.cloud_id = cloud_id
        self.ingestion_key = ingestion_key


class VMResources(_serialization.Model):
    """The vm resource properties that is currently being monitored by the Elastic monitor resource.

    :ivar vm_resource_id: The ARM id of the VM resource.
    :vartype vm_resource_id: str
    """

    _attribute_map = {
        "vm_resource_id": {"key": "vmResourceId", "type": "str"},
    }

    def __init__(self, *, vm_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword vm_resource_id: The ARM id of the VM resource.
        :paramtype vm_resource_id: str
        """
        super().__init__(**kwargs)
        self.vm_resource_id = vm_resource_id
