# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    from .. import models as _models


class AssessedDisk(_serialization.Model):
    """AssessedDisk.

    :ivar suitability: Gets the suitability. Known values are: "Unknown", "NotSuitable",
     "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
    :vartype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
    :ivar suitability_explanation: Gets the suitability explanation. Known values are: "Unknown",
     "NotApplicable", "DiskSizeGreaterThanSupported", "NoSuitableDiskSizeForIops",
     "NoSuitableDiskSizeForThroughput", "NoDiskSizeFoundInSelectedLocation",
     "NoDiskSizeFoundForSelectedRedundancy", "InternalErrorOccurredForDiskEvaluation", and
     "NoEaPriceFoundForDiskSize".
    :vartype suitability_explanation: str or
     ~azure.mgmt.migrationassessment.models.AzureDiskSuitabilityExplanation
    :ivar suitability_detail: Gets the suitability detail. Known values are: "None",
     "NumberOfReadOperationsPerSecondMissing", "NumberOfWriteOperationsPerSecondMissing",
     "MegabytesPerSecondOfReadMissing", "MegabytesPerSecondOfWriteMissing",
     "DiskGigabytesConsumedMissing", "DiskGigabytesProvisionedMissing",
     "NumberOfReadOperationsPerSecondOutOfRange", "NumberOfWriteOperationsPerSecondOutOfRange",
     "MegabytesPerSecondOfReadOutOfRange", "MegabytesPerSecondOfWriteOutOfRange",
     "DiskGigabytesConsumedOutOfRange", and "DiskGigabytesProvisionedOutOfRange".
    :vartype suitability_detail: str or
     ~azure.mgmt.migrationassessment.models.AzureDiskSuitabilityDetail
    :ivar recommended_disk_size: Gets the recommended disk size. Known values are: "Unknown",
     "Standard_S4", "Standard_S6", "Standard_S10", "Standard_S15", "Standard_S20", "Standard_S30",
     "Standard_S40", "Standard_S50", "Standard_S60", "Standard_S70", "Standard_S80", "Premium_P4",
     "Premium_P6", "Premium_P10", "Premium_P15", "Premium_P20", "Premium_P30", "Premium_P40",
     "Premium_P50", "Premium_P60", "Premium_P70", "Premium_P80", "StandardSSD_E10",
     "StandardSSD_E15", "StandardSSD_E20", "StandardSSD_E30", "StandardSSD_E40", "StandardSSD_E50",
     "StandardSSD_E60", "StandardSSD_E70", "StandardSSD_E80", "StandardSSD_E4", "StandardSSD_E6",
     "StandardSSD_E1", "StandardSSD_E2", "StandardSSD_E3", "Premium_P1", "Premium_P2", "Premium_P3",
     "Ultra", and "PremiumV2".
    :vartype recommended_disk_size: str or ~azure.mgmt.migrationassessment.models.AzureDiskSize
    :ivar recommended_disk_type: Gets the recommended disk type. Known values are: "Unknown",
     "Standard", "StandardSSD", "Premium", "StandardOrPremium", "Ultra", and "PremiumV2".
    :vartype recommended_disk_type: str or ~azure.mgmt.migrationassessment.models.AzureDiskType
    :ivar gigabytes_for_recommended_disk_size: Gets the recommended disk size.
    :vartype gigabytes_for_recommended_disk_size: int
    :ivar recommend_disk_throughput_in_mbps: Gets the recommended disk throughput.
    :vartype recommend_disk_throughput_in_mbps: float
    :ivar recommended_disk_iops: Gets the recommended disk iops.
    :vartype recommended_disk_iops: float
    :ivar monthly_storage_cost: Gets the monthly storage cost.
    :vartype monthly_storage_cost: float
    :ivar name: Gets the name.
    :vartype name: str
    :ivar display_name: Gets the machine display name.
    :vartype display_name: str
    :ivar gigabytes_provisioned: Gets the gigabytes provisioned.
    :vartype gigabytes_provisioned: float
    :ivar megabytes_per_second_of_read: Gets the megabytes per second of read.
    :vartype megabytes_per_second_of_read: float
    :ivar megabytes_per_second_of_write: Gets the megabytes per second of write.
    :vartype megabytes_per_second_of_write: float
    :ivar number_of_read_operations_per_second: Gets the number of read operations per second.
    :vartype number_of_read_operations_per_second: float
    :ivar number_of_write_operations_per_second: Gets the number of write operations per second.
    :vartype number_of_write_operations_per_second: float
    """

    _attribute_map = {
        "suitability": {"key": "suitability", "type": "str"},
        "suitability_explanation": {"key": "suitabilityExplanation", "type": "str"},
        "suitability_detail": {"key": "suitabilityDetail", "type": "str"},
        "recommended_disk_size": {"key": "recommendedDiskSize", "type": "str"},
        "recommended_disk_type": {"key": "recommendedDiskType", "type": "str"},
        "gigabytes_for_recommended_disk_size": {"key": "gigabytesForRecommendedDiskSize", "type": "int"},
        "recommend_disk_throughput_in_mbps": {"key": "recommendDiskThroughputInMbps", "type": "float"},
        "recommended_disk_iops": {"key": "recommendedDiskIops", "type": "float"},
        "monthly_storage_cost": {"key": "monthlyStorageCost", "type": "float"},
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "gigabytes_provisioned": {"key": "gigabytesProvisioned", "type": "float"},
        "megabytes_per_second_of_read": {"key": "megabytesPerSecondOfRead", "type": "float"},
        "megabytes_per_second_of_write": {"key": "megabytesPerSecondOfWrite", "type": "float"},
        "number_of_read_operations_per_second": {"key": "numberOfReadOperationsPerSecond", "type": "float"},
        "number_of_write_operations_per_second": {"key": "numberOfWriteOperationsPerSecond", "type": "float"},
    }

    def __init__(
        self,
        *,
        suitability: Optional[Union[str, "_models.CloudSuitability"]] = None,
        suitability_explanation: Optional[Union[str, "_models.AzureDiskSuitabilityExplanation"]] = None,
        suitability_detail: Optional[Union[str, "_models.AzureDiskSuitabilityDetail"]] = None,
        recommended_disk_size: Optional[Union[str, "_models.AzureDiskSize"]] = None,
        recommended_disk_type: Optional[Union[str, "_models.AzureDiskType"]] = None,
        gigabytes_for_recommended_disk_size: Optional[int] = None,
        recommend_disk_throughput_in_mbps: Optional[float] = None,
        recommended_disk_iops: Optional[float] = None,
        monthly_storage_cost: Optional[float] = None,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        gigabytes_provisioned: Optional[float] = None,
        megabytes_per_second_of_read: Optional[float] = None,
        megabytes_per_second_of_write: Optional[float] = None,
        number_of_read_operations_per_second: Optional[float] = None,
        number_of_write_operations_per_second: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword suitability: Gets the suitability. Known values are: "Unknown", "NotSuitable",
         "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
        :paramtype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
        :keyword suitability_explanation: Gets the suitability explanation. Known values are:
         "Unknown", "NotApplicable", "DiskSizeGreaterThanSupported", "NoSuitableDiskSizeForIops",
         "NoSuitableDiskSizeForThroughput", "NoDiskSizeFoundInSelectedLocation",
         "NoDiskSizeFoundForSelectedRedundancy", "InternalErrorOccurredForDiskEvaluation", and
         "NoEaPriceFoundForDiskSize".
        :paramtype suitability_explanation: str or
         ~azure.mgmt.migrationassessment.models.AzureDiskSuitabilityExplanation
        :keyword suitability_detail: Gets the suitability detail. Known values are: "None",
         "NumberOfReadOperationsPerSecondMissing", "NumberOfWriteOperationsPerSecondMissing",
         "MegabytesPerSecondOfReadMissing", "MegabytesPerSecondOfWriteMissing",
         "DiskGigabytesConsumedMissing", "DiskGigabytesProvisionedMissing",
         "NumberOfReadOperationsPerSecondOutOfRange", "NumberOfWriteOperationsPerSecondOutOfRange",
         "MegabytesPerSecondOfReadOutOfRange", "MegabytesPerSecondOfWriteOutOfRange",
         "DiskGigabytesConsumedOutOfRange", and "DiskGigabytesProvisionedOutOfRange".
        :paramtype suitability_detail: str or
         ~azure.mgmt.migrationassessment.models.AzureDiskSuitabilityDetail
        :keyword recommended_disk_size: Gets the recommended disk size. Known values are: "Unknown",
         "Standard_S4", "Standard_S6", "Standard_S10", "Standard_S15", "Standard_S20", "Standard_S30",
         "Standard_S40", "Standard_S50", "Standard_S60", "Standard_S70", "Standard_S80", "Premium_P4",
         "Premium_P6", "Premium_P10", "Premium_P15", "Premium_P20", "Premium_P30", "Premium_P40",
         "Premium_P50", "Premium_P60", "Premium_P70", "Premium_P80", "StandardSSD_E10",
         "StandardSSD_E15", "StandardSSD_E20", "StandardSSD_E30", "StandardSSD_E40", "StandardSSD_E50",
         "StandardSSD_E60", "StandardSSD_E70", "StandardSSD_E80", "StandardSSD_E4", "StandardSSD_E6",
         "StandardSSD_E1", "StandardSSD_E2", "StandardSSD_E3", "Premium_P1", "Premium_P2", "Premium_P3",
         "Ultra", and "PremiumV2".
        :paramtype recommended_disk_size: str or ~azure.mgmt.migrationassessment.models.AzureDiskSize
        :keyword recommended_disk_type: Gets the recommended disk type. Known values are: "Unknown",
         "Standard", "StandardSSD", "Premium", "StandardOrPremium", "Ultra", and "PremiumV2".
        :paramtype recommended_disk_type: str or ~azure.mgmt.migrationassessment.models.AzureDiskType
        :keyword gigabytes_for_recommended_disk_size: Gets the recommended disk size.
        :paramtype gigabytes_for_recommended_disk_size: int
        :keyword recommend_disk_throughput_in_mbps: Gets the recommended disk throughput.
        :paramtype recommend_disk_throughput_in_mbps: float
        :keyword recommended_disk_iops: Gets the recommended disk iops.
        :paramtype recommended_disk_iops: float
        :keyword monthly_storage_cost: Gets the monthly storage cost.
        :paramtype monthly_storage_cost: float
        :keyword name: Gets the name.
        :paramtype name: str
        :keyword display_name: Gets the machine display name.
        :paramtype display_name: str
        :keyword gigabytes_provisioned: Gets the gigabytes provisioned.
        :paramtype gigabytes_provisioned: float
        :keyword megabytes_per_second_of_read: Gets the megabytes per second of read.
        :paramtype megabytes_per_second_of_read: float
        :keyword megabytes_per_second_of_write: Gets the megabytes per second of write.
        :paramtype megabytes_per_second_of_write: float
        :keyword number_of_read_operations_per_second: Gets the number of read operations per second.
        :paramtype number_of_read_operations_per_second: float
        :keyword number_of_write_operations_per_second: Gets the number of write operations per second.
        :paramtype number_of_write_operations_per_second: float
        """
        super().__init__(**kwargs)
        self.suitability = suitability
        self.suitability_explanation = suitability_explanation
        self.suitability_detail = suitability_detail
        self.recommended_disk_size = recommended_disk_size
        self.recommended_disk_type = recommended_disk_type
        self.gigabytes_for_recommended_disk_size = gigabytes_for_recommended_disk_size
        self.recommend_disk_throughput_in_mbps = recommend_disk_throughput_in_mbps
        self.recommended_disk_iops = recommended_disk_iops
        self.monthly_storage_cost = monthly_storage_cost
        self.name = name
        self.display_name = display_name
        self.gigabytes_provisioned = gigabytes_provisioned
        self.megabytes_per_second_of_read = megabytes_per_second_of_read
        self.megabytes_per_second_of_write = megabytes_per_second_of_write
        self.number_of_read_operations_per_second = number_of_read_operations_per_second
        self.number_of_write_operations_per_second = number_of_write_operations_per_second


class AssessedDiskData(_serialization.Model):
    """Assessed Disk data. Used in Assessed SQL machine DTO.

    :ivar suitability: Gets the suitability. Known values are: "Unknown", "NotSuitable",
     "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
    :vartype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
    :ivar suitability_explanation: Gets the suitability explanation. Known values are: "Unknown",
     "NotApplicable", "DiskSizeGreaterThanSupported", "NoSuitableDiskSizeForIops",
     "NoSuitableDiskSizeForThroughput", "NoDiskSizeFoundInSelectedLocation",
     "NoDiskSizeFoundForSelectedRedundancy", "InternalErrorOccurredForDiskEvaluation", and
     "NoEaPriceFoundForDiskSize".
    :vartype suitability_explanation: str or
     ~azure.mgmt.migrationassessment.models.AzureDiskSuitabilityExplanation
    :ivar suitability_detail: Gets the suitability detail. Known values are: "None",
     "NumberOfReadOperationsPerSecondMissing", "NumberOfWriteOperationsPerSecondMissing",
     "MegabytesPerSecondOfReadMissing", "MegabytesPerSecondOfWriteMissing",
     "DiskGigabytesConsumedMissing", "DiskGigabytesProvisionedMissing",
     "NumberOfReadOperationsPerSecondOutOfRange", "NumberOfWriteOperationsPerSecondOutOfRange",
     "MegabytesPerSecondOfReadOutOfRange", "MegabytesPerSecondOfWriteOutOfRange",
     "DiskGigabytesConsumedOutOfRange", and "DiskGigabytesProvisionedOutOfRange".
    :vartype suitability_detail: str or
     ~azure.mgmt.migrationassessment.models.AzureDiskSuitabilityDetail
    :ivar recommended_disk_size: Gets the recommended disk size. Known values are: "Unknown",
     "Standard_S4", "Standard_S6", "Standard_S10", "Standard_S15", "Standard_S20", "Standard_S30",
     "Standard_S40", "Standard_S50", "Standard_S60", "Standard_S70", "Standard_S80", "Premium_P4",
     "Premium_P6", "Premium_P10", "Premium_P15", "Premium_P20", "Premium_P30", "Premium_P40",
     "Premium_P50", "Premium_P60", "Premium_P70", "Premium_P80", "StandardSSD_E10",
     "StandardSSD_E15", "StandardSSD_E20", "StandardSSD_E30", "StandardSSD_E40", "StandardSSD_E50",
     "StandardSSD_E60", "StandardSSD_E70", "StandardSSD_E80", "StandardSSD_E4", "StandardSSD_E6",
     "StandardSSD_E1", "StandardSSD_E2", "StandardSSD_E3", "Premium_P1", "Premium_P2", "Premium_P3",
     "Ultra", and "PremiumV2".
    :vartype recommended_disk_size: str or ~azure.mgmt.migrationassessment.models.AzureDiskSize
    :ivar recommended_disk_type: Gets the recommended disk type. Known values are: "Unknown",
     "Standard", "StandardSSD", "Premium", "StandardOrPremium", "Ultra", and "PremiumV2".
    :vartype recommended_disk_type: str or ~azure.mgmt.migrationassessment.models.AzureDiskType
    :ivar recommended_disk_size_gigabytes: Gets the recommended disk size.
    :vartype recommended_disk_size_gigabytes: int
    :ivar recommend_disk_throughput_in_mbps: Gets the recommended disk throughput.
    :vartype recommend_disk_throughput_in_mbps: float
    :ivar recommended_disk_iops: Gets the recommended disk iops.
    :vartype recommended_disk_iops: float
    :ivar monthly_storage_cost: Gets the monthly storage cost.
    :vartype monthly_storage_cost: float
    :ivar name: Gets the name.
    :vartype name: str
    :ivar display_name: Gets the machine display name.
    :vartype display_name: str
    :ivar gigabytes_provisioned: Gets the gigabytes provisioned.
    :vartype gigabytes_provisioned: float
    :ivar megabytes_per_second_of_read: Gets the megabytes per second of read.
    :vartype megabytes_per_second_of_read: float
    :ivar megabytes_per_second_of_write: Gets the megabytes per second of write.
    :vartype megabytes_per_second_of_write: float
    :ivar number_of_read_operations_per_second: Gets the number of read operations per second.
    :vartype number_of_read_operations_per_second: float
    :ivar number_of_write_operations_per_second: Gets the number of write operations per second.
    :vartype number_of_write_operations_per_second: float
    """

    _attribute_map = {
        "suitability": {"key": "suitability", "type": "str"},
        "suitability_explanation": {"key": "suitabilityExplanation", "type": "str"},
        "suitability_detail": {"key": "suitabilityDetail", "type": "str"},
        "recommended_disk_size": {"key": "recommendedDiskSize", "type": "str"},
        "recommended_disk_type": {"key": "recommendedDiskType", "type": "str"},
        "recommended_disk_size_gigabytes": {"key": "recommendedDiskSizeGigabytes", "type": "int"},
        "recommend_disk_throughput_in_mbps": {"key": "recommendDiskThroughputInMbps", "type": "float"},
        "recommended_disk_iops": {"key": "recommendedDiskIops", "type": "float"},
        "monthly_storage_cost": {"key": "monthlyStorageCost", "type": "float"},
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "gigabytes_provisioned": {"key": "gigabytesProvisioned", "type": "float"},
        "megabytes_per_second_of_read": {"key": "megabytesPerSecondOfRead", "type": "float"},
        "megabytes_per_second_of_write": {"key": "megabytesPerSecondOfWrite", "type": "float"},
        "number_of_read_operations_per_second": {"key": "numberOfReadOperationsPerSecond", "type": "float"},
        "number_of_write_operations_per_second": {"key": "numberOfWriteOperationsPerSecond", "type": "float"},
    }

    def __init__(
        self,
        *,
        suitability: Optional[Union[str, "_models.CloudSuitability"]] = None,
        suitability_explanation: Optional[Union[str, "_models.AzureDiskSuitabilityExplanation"]] = None,
        suitability_detail: Optional[Union[str, "_models.AzureDiskSuitabilityDetail"]] = None,
        recommended_disk_size: Optional[Union[str, "_models.AzureDiskSize"]] = None,
        recommended_disk_type: Optional[Union[str, "_models.AzureDiskType"]] = None,
        recommended_disk_size_gigabytes: Optional[int] = None,
        recommend_disk_throughput_in_mbps: Optional[float] = None,
        recommended_disk_iops: Optional[float] = None,
        monthly_storage_cost: Optional[float] = None,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        gigabytes_provisioned: Optional[float] = None,
        megabytes_per_second_of_read: Optional[float] = None,
        megabytes_per_second_of_write: Optional[float] = None,
        number_of_read_operations_per_second: Optional[float] = None,
        number_of_write_operations_per_second: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword suitability: Gets the suitability. Known values are: "Unknown", "NotSuitable",
         "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
        :paramtype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
        :keyword suitability_explanation: Gets the suitability explanation. Known values are:
         "Unknown", "NotApplicable", "DiskSizeGreaterThanSupported", "NoSuitableDiskSizeForIops",
         "NoSuitableDiskSizeForThroughput", "NoDiskSizeFoundInSelectedLocation",
         "NoDiskSizeFoundForSelectedRedundancy", "InternalErrorOccurredForDiskEvaluation", and
         "NoEaPriceFoundForDiskSize".
        :paramtype suitability_explanation: str or
         ~azure.mgmt.migrationassessment.models.AzureDiskSuitabilityExplanation
        :keyword suitability_detail: Gets the suitability detail. Known values are: "None",
         "NumberOfReadOperationsPerSecondMissing", "NumberOfWriteOperationsPerSecondMissing",
         "MegabytesPerSecondOfReadMissing", "MegabytesPerSecondOfWriteMissing",
         "DiskGigabytesConsumedMissing", "DiskGigabytesProvisionedMissing",
         "NumberOfReadOperationsPerSecondOutOfRange", "NumberOfWriteOperationsPerSecondOutOfRange",
         "MegabytesPerSecondOfReadOutOfRange", "MegabytesPerSecondOfWriteOutOfRange",
         "DiskGigabytesConsumedOutOfRange", and "DiskGigabytesProvisionedOutOfRange".
        :paramtype suitability_detail: str or
         ~azure.mgmt.migrationassessment.models.AzureDiskSuitabilityDetail
        :keyword recommended_disk_size: Gets the recommended disk size. Known values are: "Unknown",
         "Standard_S4", "Standard_S6", "Standard_S10", "Standard_S15", "Standard_S20", "Standard_S30",
         "Standard_S40", "Standard_S50", "Standard_S60", "Standard_S70", "Standard_S80", "Premium_P4",
         "Premium_P6", "Premium_P10", "Premium_P15", "Premium_P20", "Premium_P30", "Premium_P40",
         "Premium_P50", "Premium_P60", "Premium_P70", "Premium_P80", "StandardSSD_E10",
         "StandardSSD_E15", "StandardSSD_E20", "StandardSSD_E30", "StandardSSD_E40", "StandardSSD_E50",
         "StandardSSD_E60", "StandardSSD_E70", "StandardSSD_E80", "StandardSSD_E4", "StandardSSD_E6",
         "StandardSSD_E1", "StandardSSD_E2", "StandardSSD_E3", "Premium_P1", "Premium_P2", "Premium_P3",
         "Ultra", and "PremiumV2".
        :paramtype recommended_disk_size: str or ~azure.mgmt.migrationassessment.models.AzureDiskSize
        :keyword recommended_disk_type: Gets the recommended disk type. Known values are: "Unknown",
         "Standard", "StandardSSD", "Premium", "StandardOrPremium", "Ultra", and "PremiumV2".
        :paramtype recommended_disk_type: str or ~azure.mgmt.migrationassessment.models.AzureDiskType
        :keyword recommended_disk_size_gigabytes: Gets the recommended disk size.
        :paramtype recommended_disk_size_gigabytes: int
        :keyword recommend_disk_throughput_in_mbps: Gets the recommended disk throughput.
        :paramtype recommend_disk_throughput_in_mbps: float
        :keyword recommended_disk_iops: Gets the recommended disk iops.
        :paramtype recommended_disk_iops: float
        :keyword monthly_storage_cost: Gets the monthly storage cost.
        :paramtype monthly_storage_cost: float
        :keyword name: Gets the name.
        :paramtype name: str
        :keyword display_name: Gets the machine display name.
        :paramtype display_name: str
        :keyword gigabytes_provisioned: Gets the gigabytes provisioned.
        :paramtype gigabytes_provisioned: float
        :keyword megabytes_per_second_of_read: Gets the megabytes per second of read.
        :paramtype megabytes_per_second_of_read: float
        :keyword megabytes_per_second_of_write: Gets the megabytes per second of write.
        :paramtype megabytes_per_second_of_write: float
        :keyword number_of_read_operations_per_second: Gets the number of read operations per second.
        :paramtype number_of_read_operations_per_second: float
        :keyword number_of_write_operations_per_second: Gets the number of write operations per second.
        :paramtype number_of_write_operations_per_second: float
        """
        super().__init__(**kwargs)
        self.suitability = suitability
        self.suitability_explanation = suitability_explanation
        self.suitability_detail = suitability_detail
        self.recommended_disk_size = recommended_disk_size
        self.recommended_disk_type = recommended_disk_type
        self.recommended_disk_size_gigabytes = recommended_disk_size_gigabytes
        self.recommend_disk_throughput_in_mbps = recommend_disk_throughput_in_mbps
        self.recommended_disk_iops = recommended_disk_iops
        self.monthly_storage_cost = monthly_storage_cost
        self.name = name
        self.display_name = display_name
        self.gigabytes_provisioned = gigabytes_provisioned
        self.megabytes_per_second_of_read = megabytes_per_second_of_read
        self.megabytes_per_second_of_write = megabytes_per_second_of_write
        self.number_of_read_operations_per_second = number_of_read_operations_per_second
        self.number_of_write_operations_per_second = number_of_write_operations_per_second


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    """


class AssessedMachine(ProxyResource):
    """Machine assessment Assessed Machine resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.AssessedMachineProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AssessedMachineProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AssessedMachineProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.AssessedMachineProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AssessedMachineListResult(_serialization.Model):
    """The response of a AssessedMachine list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AssessedMachine items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.AssessedMachine]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AssessedMachine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AssessedMachine"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AssessedMachine items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.AssessedMachine]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AssessedMachineProperties(_serialization.Model):
    """Assessed machine properties class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar errors: List of errors for this machine.
    :vartype errors: list[~azure.mgmt.migrationassessment.models.Error]
    :ivar disks: Dictionary of disks attached to the machine. Key is ID of disk. Value is a disk
     object.
    :vartype disks: dict[str, ~azure.mgmt.migrationassessment.models.AssessedDisk]
    :ivar monthly_ultra_storage_cost: Monthly ultra storage cost.
    :vartype monthly_ultra_storage_cost: float
    :ivar host_processor: Gets or sets the processor details of the host.
    :vartype host_processor: ~azure.mgmt.migrationassessment.models.ProcessorInfo
    :ivar cost_components: Gets or sets the collection of cost components.
    :vartype cost_components: list[~azure.mgmt.migrationassessment.models.CostComponent]
    :ivar product_support_status: Gets the product support status related details.
    :vartype product_support_status: ~azure.mgmt.migrationassessment.models.ProductSupportStatus
    :ivar monthly_bandwidth_cost: Monthly networking cost.
    :vartype monthly_bandwidth_cost: float
    :ivar monthly_storage_cost: Monthly storage cost.
    :vartype monthly_storage_cost: float
    :ivar monthly_premium_storage_cost: Monthly premium storage cost.
    :vartype monthly_premium_storage_cost: float
    :ivar monthly_standard_ssd_storage_cost: Monthly standard SSD storage cost.
    :vartype monthly_standard_ssd_storage_cost: float
    :ivar network_adapters: List of Network Adapters that were assessed as part of this machine's
     assessment.
    :vartype network_adapters: dict[str,
     ~azure.mgmt.migrationassessment.models.AssessedNetworkAdapter]
    :ivar recommended_size: Recommended Azure Size for the machine. Known values are: "Unknown",
     "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A0", "Standard_A1",
     "Standard_A2", "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6", "Standard_A7",
     "Standard_A8", "Standard_A9", "Standard_A10", "Standard_A11", "Standard_A1_v2",
     "Standard_A2_v2", "Standard_A4_v2", "Standard_A8_v2", "Standard_A2m_v2", "Standard_A4m_v2",
     "Standard_A8m_v2", "Standard_D1", "Standard_D2", "Standard_D3", "Standard_D4", "Standard_D11",
     "Standard_D12", "Standard_D13", "Standard_D14", "Standard_D1_v2", "Standard_D2_v2",
     "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_D11_v2", "Standard_D12_v2",
     "Standard_D13_v2", "Standard_D14_v2", "Standard_D15_v2", "Standard_DS1", "Standard_DS2",
     "Standard_DS3", "Standard_DS4", "Standard_DS11", "Standard_DS12", "Standard_DS13",
     "Standard_DS14", "Standard_DS1_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2",
     "Standard_DS5_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2",
     "Standard_DS14_v2", "Standard_DS15_v2", "Standard_F1", "Standard_F2", "Standard_F4",
     "Standard_F8", "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
     "Standard_F16s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5",
     "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5", "Standard_H8",
     "Standard_H16", "Standard_H8m", "Standard_H16m", "Standard_H16r", "Standard_H16mr",
     "Standard_L4s", "Standard_L8s", "Standard_L16s", "Standard_L32s", "Standard_D2s_v3",
     "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3", "Standard_D32s_v3",
     "Standard_D64s_v3", "Standard_D2_v3", "Standard_D4_v3", "Standard_D8_v3", "Standard_D16_v3",
     "Standard_D32_v3", "Standard_D64_v3", "Standard_F2s_v2", "Standard_F4s_v2", "Standard_F8s_v2",
     "Standard_F16s_v2", "Standard_F32s_v2", "Standard_F64s_v2", "Standard_F72s_v2",
     "Standard_E2_v3", "Standard_E4_v3", "Standard_E8_v3", "Standard_E16_v3", "Standard_E32_v3",
     "Standard_E64_v3", "Standard_E2s_v3", "Standard_E4s_v3", "Standard_E8s_v3", "Standard_E16s_v3",
     "Standard_E32s_v3", "Standard_E64s_v3", "Standard_M64s", "Standard_M64ms", "Standard_M128s",
     "Standard_M128ms", "Standard_DC2s", "Standard_DC4s", "Standard_E20_v3", "Standard_E20s_v3",
     "Standard_E64i_v3", "Standard_E64is_v3", "Standard_M8ms", "Standard_M16ms", "Standard_M32ls",
     "Standard_M32ms", "Standard_M32ts", "Standard_M64", "Standard_M64ls", "Standard_M64m",
     "Standard_M128", "Standard_M128m", "Standard_L8s_v2", "Standard_L16s_v2", "Standard_L32s_v2",
     "Standard_L48s_v2", "Standard_L64s_v2", "Standard_L80s_v2", "Standard_D2_v4", "Standard_D4_v4",
     "Standard_D8_v4", "Standard_D16_v4", "Standard_D32_v4", "Standard_D48_v4", "Standard_D64_v4",
     "Standard_D2s_v4", "Standard_D4s_v4", "Standard_D8s_v4", "Standard_D16s_v4",
     "Standard_D32s_v4", "Standard_D48s_v4", "Standard_D64s_v4", "Standard_D2d_v4",
     "Standard_D4d_v4", "Standard_D8d_v4", "Standard_D16d_v4", "Standard_D32d_v4",
     "Standard_D48d_v4", "Standard_D64d_v4", "Standard_D2ds_v4", "Standard_D4ds_v4",
     "Standard_D8ds_v4", "Standard_D16ds_v4", "Standard_D32ds_v4", "Standard_D48ds_v4",
     "Standard_D64ds_v4", "Standard_E2_v4", "Standard_E4_v4", "Standard_E8_v4", "Standard_E16_v4",
     "Standard_E20_v4", "Standard_E32_v4", "Standard_E48_v4", "Standard_E64_v4", "Standard_E2s_v4",
     "Standard_E4s_v4", "Standard_E8s_v4", "Standard_E16s_v4", "Standard_E20s_v4",
     "Standard_E32s_v4", "Standard_E48s_v4", "Standard_E64s_v4", "Standard_E2d_v4",
     "Standard_E4d_v4", "Standard_E8d_v4", "Standard_E16d_v4", "Standard_E20d_v4",
     "Standard_E32d_v4", "Standard_E48d_v4", "Standard_E64d_v4", "Standard_E2ds_v4",
     "Standard_E4ds_v4", "Standard_E8ds_v4", "Standard_E16ds_v4", "Standard_E20ds_v4",
     "Standard_E32ds_v4", "Standard_E48ds_v4", "Standard_E64ds_v4", "Standard_E2as_v4",
     "Standard_E4as_v4", "Standard_E8as_v4", "Standard_E16as_v4", "Standard_E20as_v4",
     "Standard_E32as_v4", "Standard_E48as_v4", "Standard_E64as_v4", "Standard_E96as_v4",
     "Standard_D2as_v4", "Standard_D4as_v4", "Standard_D8as_v4", "Standard_D16as_v4",
     "Standard_D32as_v4", "Standard_D48as_v4", "Standard_D64as_v4", "Standard_D96as_v4",
     "Standard_M208ms_v2", "Standard_M208s_v2", "Standard_M416ms_v2", "Standard_M416s_v2",
     "Standard_F48s_v2", "Standard_E48_v3", "Standard_E48s_v3", "Standard_E80is_v4",
     "Standard_E80ids_v4", "Standard_E2a_v4", "Standard_E4a_v4", "Standard_E8a_v4",
     "Standard_E16a_v4", "Standard_E20a_v4", "Standard_E32a_v4", "Standard_E48a_v4",
     "Standard_E64a_v4", "Standard_E96a_v4", "Standard_D2a_v4", "Standard_D4a_v4",
     "Standard_D8a_v4", "Standard_D16a_v4", "Standard_D32a_v4", "Standard_D48a_v4",
     "Standard_D64a_v4", "Standard_D96a_v4", "Standard_M32ms_v2", "Standard_M64s_v2",
     "Standard_M64ms_v2", "Standard_M128s_v2", "Standard_M128ms_v2", "Standard_M192is_v2",
     "Standard_M192ims_v2", "Standard_M32dms_v2", "Standard_M64ds_v2", "Standard_M64dms_v2",
     "Standard_M128ds_v2", "Standard_M128dms_v2", "Standard_M192ids_v2", "Standard_M192idms_v2",
     "Standard_D2_v5", "Standard_D4_v5", "Standard_D8_v5", "Standard_D16_v5", "Standard_D32_v5",
     "Standard_D48_v5", "Standard_D64_v5", "Standard_D96_v5", "Standard_D2s_v5", "Standard_D4s_v5",
     "Standard_D8s_v5", "Standard_D16s_v5", "Standard_D32s_v5", "Standard_D48s_v5",
     "Standard_D64s_v5", "Standard_D96s_v5", "Standard_D2d_v5", "Standard_D4d_v5",
     "Standard_D8d_v5", "Standard_D16d_v5", "Standard_D32d_v5", "Standard_D48d_v5",
     "Standard_D64d_v5", "Standard_D96d_v5", "Standard_D2ds_v5", "Standard_D4ds_v5",
     "Standard_D8ds_v5", "Standard_D16ds_v5", "Standard_D32ds_v5", "Standard_D48ds_v5",
     "Standard_D64ds_v5", "Standard_D96ds_v5", "Standard_D2as_v5", "Standard_D4as_v5",
     "Standard_D8as_v5", "Standard_D16as_v5", "Standard_D32as_v5", "Standard_D48as_v5",
     "Standard_D64as_v5", "Standard_D96as_v5", "Standard_D2ads_v5", "Standard_D4ads_v5",
     "Standard_D8ads_v5", "Standard_D16ads_v5", "Standard_D32ads_v5", "Standard_D48ads_v5",
     "Standard_D64ads_v5", "Standard_D96ads_v5", "Standard_E2_v5", "Standard_E4_v5",
     "Standard_E8_v5", "Standard_E16_v5", "Standard_E20_v5", "Standard_E32_v5", "Standard_E48_v5",
     "Standard_E64_v5", "Standard_E96_v5", "Standard_E104i_v5", "Standard_E2s_v5",
     "Standard_E4s_v5", "Standard_E8s_v5", "Standard_E16s_v5", "Standard_E20s_v5",
     "Standard_E32s_v5", "Standard_E48s_v5", "Standard_E64s_v5", "Standard_E96s_v5",
     "Standard_E104is_v5", "Standard_E2d_v5", "Standard_E4d_v5", "Standard_E8d_v5",
     "Standard_E16d_v5", "Standard_E20d_v5", "Standard_E32d_v5", "Standard_E48d_v5",
     "Standard_E64d_v5", "Standard_E96d_v5", "Standard_E104id_v5", "Standard_E2ds_v5",
     "Standard_E4ds_v5", "Standard_E8ds_v5", "Standard_E16ds_v5", "Standard_E20ds_v5",
     "Standard_E32ds_v5", "Standard_E48ds_v5", "Standard_E64ds_v5", "Standard_E96ds_v5",
     "Standard_E104ids_v5", "Standard_E2as_v5", "Standard_E4as_v5", "Standard_E8as_v5",
     "Standard_E16as_v5", "Standard_E20as_v5", "Standard_E32as_v5", "Standard_E48as_v5",
     "Standard_E64as_v5", "Standard_E96as_v5", "Standard_E2ads_v5", "Standard_E4ads_v5",
     "Standard_E8ads_v5", "Standard_E16ads_v5", "Standard_E20ads_v5", "Standard_E32ads_v5",
     "Standard_E48ads_v5", "Standard_E64ads_v5", "Standard_E96ads_v5", "Standard_M8_2ms",
     "Standard_M8_4ms", "Standard_M16_4ms", "Standard_M16_8ms", "Standard_M32_8ms",
     "Standard_M32_16ms", "Standard_M64_32ms", "Standard_M64_16ms", "Standard_M128_64ms",
     "Standard_M128_32ms", "Standard_E4_2s_v3", "Standard_E8_4s_v3", "Standard_E8_2s_v3",
     "Standard_E16_8s_v3", "Standard_E16_4s_v3", "Standard_E32_16s_v3", "Standard_E32_8s_v3",
     "Standard_E64_32s_v3", "Standard_E64_16s_v3", "Standard_E4_2s_v4", "Standard_E8_4s_v4",
     "Standard_E8_2s_v4", "Standard_E16_8s_v4", "Standard_E16_4s_v4", "Standard_E32_16s_v4",
     "Standard_E32_8s_v4", "Standard_E64_32s_v4", "Standard_E64_16s_v4", "Standard_E4_2ds_v4",
     "Standard_E8_4ds_v4", "Standard_E8_2ds_v4", "Standard_E16_8ds_v4", "Standard_E16_4ds_v4",
     "Standard_E32_16ds_v4", "Standard_E32_8ds_v4", "Standard_E64_32ds_v4", "Standard_E64_16ds_v4",
     "Standard_E4_2as_v4", "Standard_E8_4as_v4", "Standard_E8_2as_v4", "Standard_E16_8as_v4",
     "Standard_E16_4as_v4", "Standard_E32_16as_v4", "Standard_E32_8as_v4", "Standard_E64_32as_v4",
     "Standard_E64_16as_v4", "Standard_E96_48as_v4", "Standard_E96_24as_v4", "Standard_E4_2ads_v5",
     "Standard_E8_4ads_v5", "Standard_E8_2ads_v5", "Standard_E16_8ads_v5", "Standard_E16_4ads_v5",
     "Standard_E32_16ads_v5", "Standard_E32_8ads_v5", "Standard_E64_32ads_v5",
     "Standard_E64_16ads_v5", "Standard_E96_48ads_v5", "Standard_E96_24ads_v5", "Standard_E4_2s_v5",
     "Standard_E8_4s_v5", "Standard_E8_2s_v5", "Standard_E16_8s_v5", "Standard_E16_4s_v5",
     "Standard_E32_16s_v5", "Standard_E32_8s_v5", "Standard_E64_32s_v5", "Standard_E64_16s_v5",
     "Standard_E96_48s_v5", "Standard_E96_24s_v5", "Standard_E4_2ds_v5", "Standard_E8_4ds_v5",
     "Standard_E8_2ds_v5", "Standard_E16_8ds_v5", "Standard_E16_4ds_v5", "Standard_E32_16ds_v5",
     "Standard_E32_8ds_v5", "Standard_E64_32ds_v5", "Standard_E64_16ds_v5", "Standard_E96_48ds_v5",
     "Standard_E96_24ds_v5", "Standard_E4_2as_v5", "Standard_E8_4as_v5", "Standard_E8_2as_v5",
     "Standard_E16_8as_v5", "Standard_E16_4as_v5", "Standard_E32_16as_v5", "Standard_E32_8as_v5",
     "Standard_E64_32as_v5", "Standard_E64_16as_v5", "Standard_E96_48as_v5", "Standard_E96_24as_v5",
     "Standard_GS4_8", "Standard_GS4_4", "Standard_GS5_16", "Standard_GS5_8", "Standard_DS11_1_v2",
     "Standard_DS12_2_v2", "Standard_DS12_1_v2", "Standard_DS13_4_v2", "Standard_DS13_2_v2",
     "Standard_DS14_8_v2", "Standard_DS14_4_v2", "Standard_M416_208s_v2", "Standard_M416_208ms_v2",
     "Standard_E2bs_v5", "Standard_E4bs_v5", "Standard_E8bs_v5", "Standard_E16bs_v5",
     "Standard_E32bs_v5", "Standard_E48bs_v5", "Standard_E64bs_v5", "Standard_E2bds_v5",
     "Standard_E4bds_v5", "Standard_E8bds_v5", "Standard_E16bds_v5", "Standard_E32bds_v5",
     "Standard_E48bds_v5", and "Standard_E64bds_v5".
    :vartype recommended_size: str or ~azure.mgmt.migrationassessment.models.AzureVmSize
    :ivar number_of_cores_for_recommended_size: Number of cores for recommended size. Read Only.
    :vartype number_of_cores_for_recommended_size: int
    :ivar megabytes_of_memory_for_recommended_size: Megabytes of memory for recommended size. Read
     Only.
    :vartype megabytes_of_memory_for_recommended_size: float
    :ivar monthly_compute_cost_for_recommended_size: Monthly Compute cost calculated for
     Recommended size, for a 31-day month.
    :vartype monthly_compute_cost_for_recommended_size: float
    :ivar suitability_explanation: Gets the explanation if machine is not suitable for cloud. Known
     values are: "Unknown", "NotApplicable", "GuestOperatingSystemArchitectureNotSupported",
     "GuestOperatingSystemNotSupported", "BootTypeNotSupported", "MoreDisksThanSupported",
     "NoSuitableVmSizeFound", "OneOrMoreDisksNotSuitable", "OneOrMoreAdaptersNotSuitable",
     "InternalErrorOccurredDuringComputeEvaluation", "InternalErrorOccurredDuringStorageEvaluation",
     "InternalErrorOccurredDuringNetworkEvaluation", "NoVmSizeSupportsStoragePerformance",
     "NoVmSizeSupportsNetworkPerformance", "NoVmSizeForSelectedPricingTier",
     "NoVmSizeForSelectedAzureLocation", "CheckRedHatLinuxVersion", "CheckOpenSuseLinuxVersion",
     "CheckWindowsServer2008R2Version", "CheckCentOsVersion", "CheckDebianLinuxVersion",
     "CheckSuseLinuxVersion", "CheckOracleLinuxVersion", "CheckUbuntuLinuxVersion",
     "CheckCoreOsLinuxVersion", "WindowsServerVersionConditionallySupported",
     "NoGuestOperatingSystemConditionallySupported", "WindowsClientVersionsConditionallySupported",
     "BootTypeUnknown", "GuestOperatingSystemUnknown", "WindowsServerVersionsSupportedWithCaveat",
     "WindowsOSNoLongerUnderMSSupport", "EndorsedWithConditionsLinuxDistributions",
     "UnendorsedLinuxDistributions", "NoVmSizeForStandardPricingTier",
     "NoVmSizeForBasicPricingTier", "NoVmSizeInSelectedFamilyFound", "NoEaPriceFoundForVmSize", and
     "NoVmSizeFoundForOfferCurrencyReservedInstance".
    :vartype suitability_explanation: str or
     ~azure.mgmt.migrationassessment.models.AzureVmSuitabilityExplanation
    :ivar suitability_detail: Gets the details if machine is not suitable for cloud. Known values
     are: "None", "RecommendedSizeHasLessNetworkAdapters", "CannotReportComputeCost",
     "CannotReportStorageCost", "CannotReportBandwidthCosts", "PercentageOfCoresUtilizedMissing",
     "PercentageOfMemoryUtilizedMissing", "PercentageOfCoresUtilizedOutOfRange", and
     "PercentageOfMemoryUtilizedOutOfRange".
    :vartype suitability_detail: str or
     ~azure.mgmt.migrationassessment.models.AzureVmSuitabilityDetail
    :ivar type: Assessed machine type. Known values are: "Unknown", "AssessedMachine",
     "AvsAssessedMachine", and "SqlAssessedMachine".
    :vartype type: str or ~azure.mgmt.migrationassessment.models.AssessedMachineType
    :ivar boot_type: Boot type of machine discovered in private data center. Known values are:
     "Unknown", "EFI", "BIOS", and "NotSpecified".
    :vartype boot_type: str or ~azure.mgmt.migrationassessment.models.MachineBootType
    :ivar operating_system_type: Operating system as reported by datacenter management solution.
    :vartype operating_system_type: str
    :ivar operating_system_name: Operating system as reported by datacenter management solution.
    :vartype operating_system_name: str
    :ivar operating_system_version: Operating system version as reported by datacenter management
     solution.
    :vartype operating_system_version: str
    :ivar operating_system_architecture: Operating system architecture as reported by datacenter
     management solution. Known values are: "Unknown", "X86", and "X64".
    :vartype operating_system_architecture: str or
     ~azure.mgmt.migrationassessment.models.GuestOperatingSystemArchitecture
    :ivar created_timestamp: When was machine first created.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: When was machine last updated.
    :vartype updated_timestamp: ~datetime.datetime
    :ivar display_name: Display Name of the Machine.
    :vartype display_name: str
    :ivar description: Description for the machine.
    :vartype description: str
    :ivar datacenter_machine_arm_id: Data center machine ARM id.
    :vartype datacenter_machine_arm_id: str
    :ivar datacenter_management_server_arm_id: Data center management server ARM id.
    :vartype datacenter_management_server_arm_id: str
    :ivar datacenter_management_server_name: Data center management server name.
    :vartype datacenter_management_server_name: str
    :ivar megabytes_of_memory: Megabytes of memory found allocated for the machine in private data
     center.
    :vartype megabytes_of_memory: float
    :ivar number_of_cores: Number of CPU cores found on the machine.
    :vartype number_of_cores: int
    :ivar confidence_rating_in_percentage: Confidence Rating in Percentage.
    :vartype confidence_rating_in_percentage: float
    :ivar percentage_cores_utilization: Percentile of Percentage of Cores Utilized noted during
     time period T.

        Here N and T are settings on Assessment.
    :vartype percentage_cores_utilization: float
    :ivar percentage_memory_utilization: Percentile of Percentage of Memory Utilized noted during
     time period T.

     .. code-block::

        Here N and T are settings on Assessment.
    :vartype percentage_memory_utilization: float
    :ivar suitability: Gets a value indicating whether machine is suitable for the cloud platform
     selected. Known values are: "Unknown", "NotSuitable", "Suitable", "ConditionallySuitable", and
     "ReadinessUnknown".
    :vartype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
    """

    _validation = {
        "errors": {"readonly": True},
        "disks": {"readonly": True},
        "monthly_ultra_storage_cost": {"readonly": True},
        "product_support_status": {"readonly": True},
        "monthly_bandwidth_cost": {"readonly": True},
        "monthly_storage_cost": {"readonly": True},
        "monthly_premium_storage_cost": {"readonly": True},
        "monthly_standard_ssd_storage_cost": {"readonly": True},
        "network_adapters": {"readonly": True},
        "recommended_size": {"readonly": True},
        "number_of_cores_for_recommended_size": {"readonly": True},
        "megabytes_of_memory_for_recommended_size": {"readonly": True},
        "monthly_compute_cost_for_recommended_size": {"readonly": True},
        "suitability_explanation": {"readonly": True},
        "suitability_detail": {"readonly": True},
        "type": {"readonly": True},
        "boot_type": {"readonly": True},
        "operating_system_type": {"readonly": True},
        "operating_system_name": {"readonly": True},
        "operating_system_version": {"readonly": True},
        "operating_system_architecture": {"readonly": True},
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "datacenter_machine_arm_id": {"readonly": True},
        "datacenter_management_server_arm_id": {"readonly": True},
        "datacenter_management_server_name": {"readonly": True},
        "megabytes_of_memory": {"readonly": True},
        "number_of_cores": {"readonly": True},
        "confidence_rating_in_percentage": {"readonly": True},
        "percentage_cores_utilization": {"readonly": True},
        "percentage_memory_utilization": {"readonly": True},
        "suitability": {"readonly": True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[Error]"},
        "disks": {"key": "disks", "type": "{AssessedDisk}"},
        "monthly_ultra_storage_cost": {"key": "monthlyUltraStorageCost", "type": "float"},
        "host_processor": {"key": "hostProcessor", "type": "ProcessorInfo"},
        "cost_components": {"key": "costComponents", "type": "[CostComponent]"},
        "product_support_status": {"key": "productSupportStatus", "type": "ProductSupportStatus"},
        "monthly_bandwidth_cost": {"key": "monthlyBandwidthCost", "type": "float"},
        "monthly_storage_cost": {"key": "monthlyStorageCost", "type": "float"},
        "monthly_premium_storage_cost": {"key": "monthlyPremiumStorageCost", "type": "float"},
        "monthly_standard_ssd_storage_cost": {"key": "monthlyStandardSsdStorageCost", "type": "float"},
        "network_adapters": {"key": "networkAdapters", "type": "{AssessedNetworkAdapter}"},
        "recommended_size": {"key": "recommendedSize", "type": "str"},
        "number_of_cores_for_recommended_size": {"key": "numberOfCoresForRecommendedSize", "type": "int"},
        "megabytes_of_memory_for_recommended_size": {"key": "megabytesOfMemoryForRecommendedSize", "type": "float"},
        "monthly_compute_cost_for_recommended_size": {"key": "monthlyComputeCostForRecommendedSize", "type": "float"},
        "suitability_explanation": {"key": "suitabilityExplanation", "type": "str"},
        "suitability_detail": {"key": "suitabilityDetail", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "boot_type": {"key": "bootType", "type": "str"},
        "operating_system_type": {"key": "operatingSystemType", "type": "str"},
        "operating_system_name": {"key": "operatingSystemName", "type": "str"},
        "operating_system_version": {"key": "operatingSystemVersion", "type": "str"},
        "operating_system_architecture": {"key": "operatingSystemArchitecture", "type": "str"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "datacenter_machine_arm_id": {"key": "datacenterMachineArmId", "type": "str"},
        "datacenter_management_server_arm_id": {"key": "datacenterManagementServerArmId", "type": "str"},
        "datacenter_management_server_name": {"key": "datacenterManagementServerName", "type": "str"},
        "megabytes_of_memory": {"key": "megabytesOfMemory", "type": "float"},
        "number_of_cores": {"key": "numberOfCores", "type": "int"},
        "confidence_rating_in_percentage": {"key": "confidenceRatingInPercentage", "type": "float"},
        "percentage_cores_utilization": {"key": "percentageCoresUtilization", "type": "float"},
        "percentage_memory_utilization": {"key": "percentageMemoryUtilization", "type": "float"},
        "suitability": {"key": "suitability", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        host_processor: Optional["_models.ProcessorInfo"] = None,
        cost_components: Optional[List["_models.CostComponent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_processor: Gets or sets the processor details of the host.
        :paramtype host_processor: ~azure.mgmt.migrationassessment.models.ProcessorInfo
        :keyword cost_components: Gets or sets the collection of cost components.
        :paramtype cost_components: list[~azure.mgmt.migrationassessment.models.CostComponent]
        """
        super().__init__(**kwargs)
        self.errors = None
        self.disks = None
        self.monthly_ultra_storage_cost = None
        self.host_processor = host_processor
        self.cost_components = cost_components
        self.product_support_status = None
        self.monthly_bandwidth_cost = None
        self.monthly_storage_cost = None
        self.monthly_premium_storage_cost = None
        self.monthly_standard_ssd_storage_cost = None
        self.network_adapters = None
        self.recommended_size = None
        self.number_of_cores_for_recommended_size = None
        self.megabytes_of_memory_for_recommended_size = None
        self.monthly_compute_cost_for_recommended_size = None
        self.suitability_explanation = None
        self.suitability_detail = None
        self.type = None
        self.boot_type = None
        self.operating_system_type = None
        self.operating_system_name = None
        self.operating_system_version = None
        self.operating_system_architecture = None
        self.created_timestamp = None
        self.updated_timestamp = None
        self.display_name = None
        self.description = None
        self.datacenter_machine_arm_id = None
        self.datacenter_management_server_arm_id = None
        self.datacenter_management_server_name = None
        self.megabytes_of_memory = None
        self.number_of_cores = None
        self.confidence_rating_in_percentage = None
        self.percentage_cores_utilization = None
        self.percentage_memory_utilization = None
        self.suitability = None


class AssessedNetworkAdapter(_serialization.Model):
    """Assessed Network Adapter.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar suitability: Gets the suitability. Known values are: "Unknown", "NotSuitable",
     "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
    :vartype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
    :ivar suitability_detail: Gets the suitability detail. Known values are: "None",
     "MegabytesOfDataTransmittedMissing", "MegabytesOfDataTransmittedOutOfRange",
     "MegabytesOfDataRecievedMissing", and "MegabytesOfDataRecievedOutOfRange".
    :vartype suitability_detail: str or
     ~azure.mgmt.migrationassessment.models.AzureNetworkAdapterSuitabilityDetail
    :ivar suitability_explanation: Gets the suitability explanation. Known values are: "Unknown",
     "NotApplicable", and "InternalErrorOccurred".
    :vartype suitability_explanation: str or
     ~azure.mgmt.migrationassessment.models.AzureNetworkAdapterSuitabilityExplanation
    :ivar monthly_bandwidth_costs: Gets the monthly bandwidth costs.
    :vartype monthly_bandwidth_costs: float
    :ivar net_gigabytes_transmitted_per_month: Gets the net gigabytes transmitted per month.
    :vartype net_gigabytes_transmitted_per_month: float
    :ivar display_name: Gets the display name.
    :vartype display_name: str
    :ivar mac_address: Gets the mac address.
    :vartype mac_address: str
    :ivar ip_addresses: Gets the ip addresses.
    :vartype ip_addresses: list[str]
    :ivar megabytes_per_second_received: Gets the megabytes per second received.
    :vartype megabytes_per_second_received: float
    :ivar megabytes_per_second_transmitted: Gets the megabytes per second transmitted.
    :vartype megabytes_per_second_transmitted: float
    """

    _validation = {
        "ip_addresses": {"readonly": True},
    }

    _attribute_map = {
        "suitability": {"key": "suitability", "type": "str"},
        "suitability_detail": {"key": "suitabilityDetail", "type": "str"},
        "suitability_explanation": {"key": "suitabilityExplanation", "type": "str"},
        "monthly_bandwidth_costs": {"key": "monthlyBandwidthCosts", "type": "float"},
        "net_gigabytes_transmitted_per_month": {"key": "netGigabytesTransmittedPerMonth", "type": "float"},
        "display_name": {"key": "displayName", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "ip_addresses": {"key": "ipAddresses", "type": "[str]"},
        "megabytes_per_second_received": {"key": "megabytesPerSecondReceived", "type": "float"},
        "megabytes_per_second_transmitted": {"key": "megabytesPerSecondTransmitted", "type": "float"},
    }

    def __init__(
        self,
        *,
        suitability: Optional[Union[str, "_models.CloudSuitability"]] = None,
        suitability_detail: Optional[Union[str, "_models.AzureNetworkAdapterSuitabilityDetail"]] = None,
        suitability_explanation: Optional[Union[str, "_models.AzureNetworkAdapterSuitabilityExplanation"]] = None,
        monthly_bandwidth_costs: Optional[float] = None,
        net_gigabytes_transmitted_per_month: Optional[float] = None,
        display_name: Optional[str] = None,
        mac_address: Optional[str] = None,
        megabytes_per_second_received: Optional[float] = None,
        megabytes_per_second_transmitted: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword suitability: Gets the suitability. Known values are: "Unknown", "NotSuitable",
         "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
        :paramtype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
        :keyword suitability_detail: Gets the suitability detail. Known values are: "None",
         "MegabytesOfDataTransmittedMissing", "MegabytesOfDataTransmittedOutOfRange",
         "MegabytesOfDataRecievedMissing", and "MegabytesOfDataRecievedOutOfRange".
        :paramtype suitability_detail: str or
         ~azure.mgmt.migrationassessment.models.AzureNetworkAdapterSuitabilityDetail
        :keyword suitability_explanation: Gets the suitability explanation. Known values are:
         "Unknown", "NotApplicable", and "InternalErrorOccurred".
        :paramtype suitability_explanation: str or
         ~azure.mgmt.migrationassessment.models.AzureNetworkAdapterSuitabilityExplanation
        :keyword monthly_bandwidth_costs: Gets the monthly bandwidth costs.
        :paramtype monthly_bandwidth_costs: float
        :keyword net_gigabytes_transmitted_per_month: Gets the net gigabytes transmitted per month.
        :paramtype net_gigabytes_transmitted_per_month: float
        :keyword display_name: Gets the display name.
        :paramtype display_name: str
        :keyword mac_address: Gets the mac address.
        :paramtype mac_address: str
        :keyword megabytes_per_second_received: Gets the megabytes per second received.
        :paramtype megabytes_per_second_received: float
        :keyword megabytes_per_second_transmitted: Gets the megabytes per second transmitted.
        :paramtype megabytes_per_second_transmitted: float
        """
        super().__init__(**kwargs)
        self.suitability = suitability
        self.suitability_detail = suitability_detail
        self.suitability_explanation = suitability_explanation
        self.monthly_bandwidth_costs = monthly_bandwidth_costs
        self.net_gigabytes_transmitted_per_month = net_gigabytes_transmitted_per_month
        self.display_name = display_name
        self.mac_address = mac_address
        self.ip_addresses = None
        self.megabytes_per_second_received = megabytes_per_second_received
        self.megabytes_per_second_transmitted = megabytes_per_second_transmitted


class AssessedSqlDatabaseV2(ProxyResource):
    """Assessed SQL database web model class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.AssessedSqlDatabaseV2Properties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AssessedSqlDatabaseV2Properties"},
    }

    def __init__(
        self, *, properties: Optional["_models.AssessedSqlDatabaseV2Properties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.AssessedSqlDatabaseV2Properties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AssessedSqlDatabaseV2ListResult(_serialization.Model):
    """The response of a AssessedSqlDatabaseV2 list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AssessedSqlDatabaseV2 items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.AssessedSqlDatabaseV2]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AssessedSqlDatabaseV2]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AssessedSqlDatabaseV2"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AssessedSqlDatabaseV2 items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.AssessedSqlDatabaseV2]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AssessedSqlDatabaseV2Properties(_serialization.Model):
    """Assessed SQL database properties web model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar recommended_azure_sql_target_type: Gets or sets the recommended azure SQL target type.
     Known values are: "Unknown", "Recommended", "AzureSqlDatabase", "AzureSqlManagedInstance",
     "AzureSqlVirtualMachine", and "AzureVirtualMachine".
    :vartype recommended_azure_sql_target_type: str or
     ~azure.mgmt.migrationassessment.models.TargetType
    :ivar recommended_suitability: Gets or sets the recommended azure SQL suitability. Known values
     are: "Unknown", "SuitableForSqlDB", "SuitableForSqlMI", "SuitableForVM",
     "PotentiallySuitableForVM", "ReadinessUnknown", "NotSuitable", "SuitableForSqlVM",
     "ConditionallySuitableForSqlDB", "ConditionallySuitableForSqlMI", "ConditionallySuitableForVM",
     and "ConditionallySuitableForSqlVM".
    :vartype recommended_suitability: str or
     ~azure.mgmt.migrationassessment.models.RecommendedSuitability
    :ivar buffer_cache_size_in_mb: Gets or sets the aggregated cache size of this database. This is
     a performance
     data metric for this DB.
    :vartype buffer_cache_size_in_mb: float
    :ivar product_support_status: Gets the product support status related details.
    :vartype product_support_status: ~azure.mgmt.migrationassessment.models.ProductSupportStatus
    :ivar azure_sql_mi_suitability_details: Gets or sets the azure SQL MI suitability details.
    :vartype azure_sql_mi_suitability_details:
     ~azure.mgmt.migrationassessment.models.SqlAssessmentV2PaasSuitabilityData
    :ivar azure_sql_db_suitability_details: Gets or sets the azure SQL DB suitability details.
    :vartype azure_sql_db_suitability_details:
     ~azure.mgmt.migrationassessment.models.SqlAssessmentV2PaasSuitabilityData
    :ivar is_database_highly_available: Gets a value indicating whether the assessed SQL database
     is highly available
     or not.
    :vartype is_database_highly_available: bool
    :ivar linked_availability_group_overview: Gets the linked availability group overview if the
     database being assessed is
     highly available.
    :vartype linked_availability_group_overview:
     ~azure.mgmt.migrationassessment.models.SqlAvailabilityGroupDataOverview
    :ivar machine_arm_id: Machine arm id.
    :vartype machine_arm_id: str
    :ivar assessed_sql_instance_arm_id: Assessed SQL instance arm id.
    :vartype assessed_sql_instance_arm_id: str
    :ivar machine_name: Machine display name.
    :vartype machine_name: str
    :ivar instance_name: SQL instance name.
    :vartype instance_name: str
    :ivar database_name: SQL database name.
    :vartype database_name: str
    :ivar database_size_in_mb: SQL database size in megabytes.
    :vartype database_size_in_mb: float
    :ivar compatibility_level: Database compatibility level. Known values are: "Unknown",
     "CompatLevel80", "CompatLevel90", "CompatLevel100", "CompatLevel110", "CompatLevel120",
     "CompatLevel130", "CompatLevel140", and "CompatLevel150".
    :vartype compatibility_level: str or ~azure.mgmt.migrationassessment.models.CompatibilityLevel
    :ivar sql_database_sds_arm_id: SQL database SDS arm id.
    :vartype sql_database_sds_arm_id: str
    :ivar percentage_cores_utilization: The percentage of the total number of cores being utilized
     by the SQL database.
    :vartype percentage_cores_utilization: float
    :ivar megabytes_per_second_of_read: The read throughput of the SQL database.
    :vartype megabytes_per_second_of_read: float
    :ivar megabytes_per_second_of_write: The write throughput of the SQL database.
    :vartype megabytes_per_second_of_write: float
    :ivar number_of_read_operations_per_second: The read operations per second of the SQL database.
    :vartype number_of_read_operations_per_second: float
    :ivar number_of_write_operations_per_second: The write operations per second of the SQL
     database.
    :vartype number_of_write_operations_per_second: float
    :ivar confidence_rating_in_percentage: Confidence Rating in Percentage.
    :vartype confidence_rating_in_percentage: float
    :ivar sizing_criterion: Assessment sizing criterion. Known values are: "PerformanceBased" and
     "AsOnPremises".
    :vartype sizing_criterion: str or
     ~azure.mgmt.migrationassessment.models.AssessmentSizingCriterion
    :ivar created_timestamp: When was assessed SQL database first created.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: When was assessed SQL database last updated.
    :vartype updated_timestamp: ~datetime.datetime
    """

    _validation = {
        "recommended_azure_sql_target_type": {"readonly": True},
        "recommended_suitability": {"readonly": True},
        "buffer_cache_size_in_mb": {"readonly": True},
        "product_support_status": {"readonly": True},
        "azure_sql_mi_suitability_details": {"readonly": True},
        "azure_sql_db_suitability_details": {"readonly": True},
        "is_database_highly_available": {"readonly": True},
        "linked_availability_group_overview": {"readonly": True},
        "machine_arm_id": {"readonly": True},
        "assessed_sql_instance_arm_id": {"readonly": True},
        "machine_name": {"readonly": True},
        "instance_name": {"readonly": True},
        "database_name": {"readonly": True},
        "database_size_in_mb": {"readonly": True},
        "compatibility_level": {"readonly": True},
        "sql_database_sds_arm_id": {"readonly": True},
        "percentage_cores_utilization": {"readonly": True},
        "megabytes_per_second_of_read": {"readonly": True},
        "megabytes_per_second_of_write": {"readonly": True},
        "number_of_read_operations_per_second": {"readonly": True},
        "number_of_write_operations_per_second": {"readonly": True},
        "confidence_rating_in_percentage": {"readonly": True},
        "sizing_criterion": {"readonly": True},
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "recommended_azure_sql_target_type": {"key": "recommendedAzureSqlTargetType", "type": "str"},
        "recommended_suitability": {"key": "recommendedSuitability", "type": "str"},
        "buffer_cache_size_in_mb": {"key": "bufferCacheSizeInMB", "type": "float"},
        "product_support_status": {"key": "productSupportStatus", "type": "ProductSupportStatus"},
        "azure_sql_mi_suitability_details": {
            "key": "azureSqlMISuitabilityDetails",
            "type": "SqlAssessmentV2PaasSuitabilityData",
        },
        "azure_sql_db_suitability_details": {
            "key": "azureSqlDBSuitabilityDetails",
            "type": "SqlAssessmentV2PaasSuitabilityData",
        },
        "is_database_highly_available": {"key": "isDatabaseHighlyAvailable", "type": "bool"},
        "linked_availability_group_overview": {
            "key": "linkedAvailabilityGroupOverview",
            "type": "SqlAvailabilityGroupDataOverview",
        },
        "machine_arm_id": {"key": "machineArmId", "type": "str"},
        "assessed_sql_instance_arm_id": {"key": "assessedSqlInstanceArmId", "type": "str"},
        "machine_name": {"key": "machineName", "type": "str"},
        "instance_name": {"key": "instanceName", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "database_size_in_mb": {"key": "databaseSizeInMB", "type": "float"},
        "compatibility_level": {"key": "compatibilityLevel", "type": "str"},
        "sql_database_sds_arm_id": {"key": "sqlDatabaseSdsArmId", "type": "str"},
        "percentage_cores_utilization": {"key": "percentageCoresUtilization", "type": "float"},
        "megabytes_per_second_of_read": {"key": "megabytesPerSecondOfRead", "type": "float"},
        "megabytes_per_second_of_write": {"key": "megabytesPerSecondOfWrite", "type": "float"},
        "number_of_read_operations_per_second": {"key": "numberOfReadOperationsPerSecond", "type": "float"},
        "number_of_write_operations_per_second": {"key": "numberOfWriteOperationsPerSecond", "type": "float"},
        "confidence_rating_in_percentage": {"key": "confidenceRatingInPercentage", "type": "float"},
        "sizing_criterion": {"key": "sizingCriterion", "type": "str"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:  # pylint: disable=too-many-locals
        """ """
        super().__init__(**kwargs)
        self.recommended_azure_sql_target_type = None
        self.recommended_suitability = None
        self.buffer_cache_size_in_mb = None
        self.product_support_status = None
        self.azure_sql_mi_suitability_details = None
        self.azure_sql_db_suitability_details = None
        self.is_database_highly_available = None
        self.linked_availability_group_overview = None
        self.machine_arm_id = None
        self.assessed_sql_instance_arm_id = None
        self.machine_name = None
        self.instance_name = None
        self.database_name = None
        self.database_size_in_mb = None
        self.compatibility_level = None
        self.sql_database_sds_arm_id = None
        self.percentage_cores_utilization = None
        self.megabytes_per_second_of_read = None
        self.megabytes_per_second_of_write = None
        self.number_of_read_operations_per_second = None
        self.number_of_write_operations_per_second = None
        self.confidence_rating_in_percentage = None
        self.sizing_criterion = None
        self.created_timestamp = None
        self.updated_timestamp = None


class AssessedSqlInstanceDatabaseSummary(_serialization.Model):
    """Assessed Sql Instance Database Summary.

    :ivar number_of_user_databases: Gets the number of user databases.
    :vartype number_of_user_databases: int
    :ivar total_database_size_in_mb: Gets the total database size in MB.
    :vartype total_database_size_in_mb: float
    :ivar largest_database_size_in_mb: Gets the largest database size in MB.
    :vartype largest_database_size_in_mb: float
    :ivar total_discovered_user_databases: Gets the total discovered user databases.
    :vartype total_discovered_user_databases: int
    """

    _attribute_map = {
        "number_of_user_databases": {"key": "numberOfUserDatabases", "type": "int"},
        "total_database_size_in_mb": {"key": "totalDatabaseSizeInMB", "type": "float"},
        "largest_database_size_in_mb": {"key": "largestDatabaseSizeInMB", "type": "float"},
        "total_discovered_user_databases": {"key": "totalDiscoveredUserDatabases", "type": "int"},
    }

    def __init__(
        self,
        *,
        number_of_user_databases: Optional[int] = None,
        total_database_size_in_mb: Optional[float] = None,
        largest_database_size_in_mb: Optional[float] = None,
        total_discovered_user_databases: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number_of_user_databases: Gets the number of user databases.
        :paramtype number_of_user_databases: int
        :keyword total_database_size_in_mb: Gets the total database size in MB.
        :paramtype total_database_size_in_mb: float
        :keyword largest_database_size_in_mb: Gets the largest database size in MB.
        :paramtype largest_database_size_in_mb: float
        :keyword total_discovered_user_databases: Gets the total discovered user databases.
        :paramtype total_discovered_user_databases: int
        """
        super().__init__(**kwargs)
        self.number_of_user_databases = number_of_user_databases
        self.total_database_size_in_mb = total_database_size_in_mb
        self.largest_database_size_in_mb = largest_database_size_in_mb
        self.total_discovered_user_databases = total_discovered_user_databases


class AssessedSqlInstanceDiskDetails(_serialization.Model):
    """Assessed Sql Instance Disk Details.

    :ivar disk_id: Gets the disk id.
    :vartype disk_id: str
    :ivar disk_size_in_mb: Gets the disk size in mb.
    :vartype disk_size_in_mb: float
    :ivar megabytes_per_second_of_read: Gets the megabytes per second of read.
    :vartype megabytes_per_second_of_read: float
    :ivar megabytes_per_second_of_write: Gets the megabytes per second of write.
    :vartype megabytes_per_second_of_write: float
    :ivar number_of_read_operations_per_second: Gets the number of read operations per second.
    :vartype number_of_read_operations_per_second: float
    :ivar number_of_write_operations_per_second: Gets the number of write operations per second.
    :vartype number_of_write_operations_per_second: float
    """

    _attribute_map = {
        "disk_id": {"key": "diskId", "type": "str"},
        "disk_size_in_mb": {"key": "diskSizeInMB", "type": "float"},
        "megabytes_per_second_of_read": {"key": "megabytesPerSecondOfRead", "type": "float"},
        "megabytes_per_second_of_write": {"key": "megabytesPerSecondOfWrite", "type": "float"},
        "number_of_read_operations_per_second": {"key": "numberOfReadOperationsPerSecond", "type": "float"},
        "number_of_write_operations_per_second": {"key": "numberOfWriteOperationsPerSecond", "type": "float"},
    }

    def __init__(
        self,
        *,
        disk_id: Optional[str] = None,
        disk_size_in_mb: Optional[float] = None,
        megabytes_per_second_of_read: Optional[float] = None,
        megabytes_per_second_of_write: Optional[float] = None,
        number_of_read_operations_per_second: Optional[float] = None,
        number_of_write_operations_per_second: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_id: Gets the disk id.
        :paramtype disk_id: str
        :keyword disk_size_in_mb: Gets the disk size in mb.
        :paramtype disk_size_in_mb: float
        :keyword megabytes_per_second_of_read: Gets the megabytes per second of read.
        :paramtype megabytes_per_second_of_read: float
        :keyword megabytes_per_second_of_write: Gets the megabytes per second of write.
        :paramtype megabytes_per_second_of_write: float
        :keyword number_of_read_operations_per_second: Gets the number of read operations per second.
        :paramtype number_of_read_operations_per_second: float
        :keyword number_of_write_operations_per_second: Gets the number of write operations per second.
        :paramtype number_of_write_operations_per_second: float
        """
        super().__init__(**kwargs)
        self.disk_id = disk_id
        self.disk_size_in_mb = disk_size_in_mb
        self.megabytes_per_second_of_read = megabytes_per_second_of_read
        self.megabytes_per_second_of_write = megabytes_per_second_of_write
        self.number_of_read_operations_per_second = number_of_read_operations_per_second
        self.number_of_write_operations_per_second = number_of_write_operations_per_second


class AssessedSqlInstanceStorageDetails(_serialization.Model):
    """Assessed Sql Instance Storage Details.

    :ivar storage_type: Gets the storage type.
    :vartype storage_type: str
    :ivar disk_size_in_mb: Gets the disk size in mb.
    :vartype disk_size_in_mb: float
    :ivar megabytes_per_second_of_read: Gets the megabytes per second of read.
    :vartype megabytes_per_second_of_read: float
    :ivar megabytes_per_second_of_write: Gets the megabytes per second of read.
    :vartype megabytes_per_second_of_write: float
    :ivar number_of_read_operations_per_second: Gets the number of read operations per second.
    :vartype number_of_read_operations_per_second: float
    :ivar number_of_write_operations_per_second: Gets the number of write operations per second.
    :vartype number_of_write_operations_per_second: float
    """

    _attribute_map = {
        "storage_type": {"key": "storageType", "type": "str"},
        "disk_size_in_mb": {"key": "diskSizeInMB", "type": "float"},
        "megabytes_per_second_of_read": {"key": "megabytesPerSecondOfRead", "type": "float"},
        "megabytes_per_second_of_write": {"key": "megabytesPerSecondOfWrite", "type": "float"},
        "number_of_read_operations_per_second": {"key": "numberOfReadOperationsPerSecond", "type": "float"},
        "number_of_write_operations_per_second": {"key": "numberOfWriteOperationsPerSecond", "type": "float"},
    }

    def __init__(
        self,
        *,
        storage_type: Optional[str] = None,
        disk_size_in_mb: Optional[float] = None,
        megabytes_per_second_of_read: Optional[float] = None,
        megabytes_per_second_of_write: Optional[float] = None,
        number_of_read_operations_per_second: Optional[float] = None,
        number_of_write_operations_per_second: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_type: Gets the storage type.
        :paramtype storage_type: str
        :keyword disk_size_in_mb: Gets the disk size in mb.
        :paramtype disk_size_in_mb: float
        :keyword megabytes_per_second_of_read: Gets the megabytes per second of read.
        :paramtype megabytes_per_second_of_read: float
        :keyword megabytes_per_second_of_write: Gets the megabytes per second of read.
        :paramtype megabytes_per_second_of_write: float
        :keyword number_of_read_operations_per_second: Gets the number of read operations per second.
        :paramtype number_of_read_operations_per_second: float
        :keyword number_of_write_operations_per_second: Gets the number of write operations per second.
        :paramtype number_of_write_operations_per_second: float
        """
        super().__init__(**kwargs)
        self.storage_type = storage_type
        self.disk_size_in_mb = disk_size_in_mb
        self.megabytes_per_second_of_read = megabytes_per_second_of_read
        self.megabytes_per_second_of_write = megabytes_per_second_of_write
        self.number_of_read_operations_per_second = number_of_read_operations_per_second
        self.number_of_write_operations_per_second = number_of_write_operations_per_second


class AssessedSqlInstanceSummary(_serialization.Model):
    """Assessed Sql Instance Summary.

    :ivar instance_id: Gets the instance id.
    :vartype instance_id: str
    :ivar instance_name: Gets the instance name.
    :vartype instance_name: str
    :ivar sql_instance_sds_arm_id: Gets the instance arm id.
    :vartype sql_instance_sds_arm_id: str
    :ivar sql_instance_entity_id: Gets the instance entity id.
    :vartype sql_instance_entity_id: str
    :ivar sql_edition: Gets the Sql edition.
    :vartype sql_edition: str
    :ivar sql_version: Gets the Sql version.
    :vartype sql_version: str
    :ivar is_clustered: Gets whether Sql is clustered.
    :vartype is_clustered: bool
    :ivar is_high_availability_enabled: Gets whether Sql is highly available.
    :vartype is_high_availability_enabled: bool
    :ivar sql_fci_state: Gets the Sql Fci state. Known values are: "Unknown", "Active", "Passive",
     and "NotApplicable".
    :vartype sql_fci_state: str or ~azure.mgmt.migrationassessment.models.SqlFCIState
    """

    _attribute_map = {
        "instance_id": {"key": "instanceId", "type": "str"},
        "instance_name": {"key": "instanceName", "type": "str"},
        "sql_instance_sds_arm_id": {"key": "sqlInstanceSdsArmId", "type": "str"},
        "sql_instance_entity_id": {"key": "sqlInstanceEntityId", "type": "str"},
        "sql_edition": {"key": "sqlEdition", "type": "str"},
        "sql_version": {"key": "sqlVersion", "type": "str"},
        "is_clustered": {"key": "isClustered", "type": "bool"},
        "is_high_availability_enabled": {"key": "isHighAvailabilityEnabled", "type": "bool"},
        "sql_fci_state": {"key": "sqlFciState", "type": "str"},
    }

    def __init__(
        self,
        *,
        instance_id: Optional[str] = None,
        instance_name: Optional[str] = None,
        sql_instance_sds_arm_id: Optional[str] = None,
        sql_instance_entity_id: Optional[str] = None,
        sql_edition: Optional[str] = None,
        sql_version: Optional[str] = None,
        is_clustered: Optional[bool] = None,
        is_high_availability_enabled: Optional[bool] = None,
        sql_fci_state: Optional[Union[str, "_models.SqlFCIState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword instance_id: Gets the instance id.
        :paramtype instance_id: str
        :keyword instance_name: Gets the instance name.
        :paramtype instance_name: str
        :keyword sql_instance_sds_arm_id: Gets the instance arm id.
        :paramtype sql_instance_sds_arm_id: str
        :keyword sql_instance_entity_id: Gets the instance entity id.
        :paramtype sql_instance_entity_id: str
        :keyword sql_edition: Gets the Sql edition.
        :paramtype sql_edition: str
        :keyword sql_version: Gets the Sql version.
        :paramtype sql_version: str
        :keyword is_clustered: Gets whether Sql is clustered.
        :paramtype is_clustered: bool
        :keyword is_high_availability_enabled: Gets whether Sql is highly available.
        :paramtype is_high_availability_enabled: bool
        :keyword sql_fci_state: Gets the Sql Fci state. Known values are: "Unknown", "Active",
         "Passive", and "NotApplicable".
        :paramtype sql_fci_state: str or ~azure.mgmt.migrationassessment.models.SqlFCIState
        """
        super().__init__(**kwargs)
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.sql_instance_sds_arm_id = sql_instance_sds_arm_id
        self.sql_instance_entity_id = sql_instance_entity_id
        self.sql_edition = sql_edition
        self.sql_version = sql_version
        self.is_clustered = is_clustered
        self.is_high_availability_enabled = is_high_availability_enabled
        self.sql_fci_state = sql_fci_state


class AssessedSqlInstanceV2(ProxyResource):
    """Assessed SQL instance web model class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.AssessedSqlInstanceV2Properties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AssessedSqlInstanceV2Properties"},
    }

    def __init__(
        self, *, properties: Optional["_models.AssessedSqlInstanceV2Properties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.AssessedSqlInstanceV2Properties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AssessedSqlInstanceV2ListResult(_serialization.Model):
    """The response of a AssessedSqlInstanceV2 list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AssessedSqlInstanceV2 items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.AssessedSqlInstanceV2]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AssessedSqlInstanceV2]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AssessedSqlInstanceV2"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AssessedSqlInstanceV2 items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.AssessedSqlInstanceV2]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AssessedSqlInstanceV2Properties(_serialization.Model):
    """Assessed SQL instance properties web model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar memory_in_use_in_mb: Gets or sets the memory used by SQL instance in megabytes.
    :vartype memory_in_use_in_mb: float
    :ivar has_scan_occurred: Gets or sets a value indicating whether SQL instance has been deep
     discovered.
    :vartype has_scan_occurred: bool
    :ivar recommended_azure_sql_target_type: Gets or sets the recommended azure SQL target type.
     Known values are: "Unknown", "Recommended", "AzureSqlDatabase", "AzureSqlManagedInstance",
     "AzureSqlVirtualMachine", and "AzureVirtualMachine".
    :vartype recommended_azure_sql_target_type: str or
     ~azure.mgmt.migrationassessment.models.TargetType
    :ivar recommended_suitability: Gets or sets the recommended azure SQL suitability. Known values
     are: "Unknown", "SuitableForSqlDB", "SuitableForSqlMI", "SuitableForVM",
     "PotentiallySuitableForVM", "ReadinessUnknown", "NotSuitable", "SuitableForSqlVM",
     "ConditionallySuitableForSqlDB", "ConditionallySuitableForSqlMI", "ConditionallySuitableForVM",
     and "ConditionallySuitableForSqlVM".
    :vartype recommended_suitability: str or
     ~azure.mgmt.migrationassessment.models.RecommendedSuitability
    :ivar azure_sql_mi_suitability_details: SQL instance azure SQL MI suitability details.
    :vartype azure_sql_mi_suitability_details:
     ~azure.mgmt.migrationassessment.models.SqlAssessmentV2PaasSuitabilityData
    :ivar azure_sql_db_suitability_details: SQL instance azure SQL DB suitability details.
    :vartype azure_sql_db_suitability_details:
     ~azure.mgmt.migrationassessment.models.SqlAssessmentV2PaasSuitabilityData
    :ivar azure_sql_vm_suitability_details: SQL instance azure SQL VM suitability details.
    :vartype azure_sql_vm_suitability_details:
     ~azure.mgmt.migrationassessment.models.SqlAssessmentV2IaasSuitabilityData
    :ivar storage_type_based_details: Gets the storage details.
    :vartype storage_type_based_details:
     list[~azure.mgmt.migrationassessment.models.AssessedSqlInstanceStorageDetails]
    :ivar product_support_status: Gets the product support status related details.
    :vartype product_support_status: ~azure.mgmt.migrationassessment.models.ProductSupportStatus
    :ivar fci_metadata: Gets the FCI metadata if this instance represents an FCI instance.
    :vartype fci_metadata: ~azure.mgmt.migrationassessment.models.SqlFCIMetadata
    :ivar availability_replica_summary: Gets the overview counts of availability replicas in the
     assessed instance, by
     commit mode and read type.
    :vartype availability_replica_summary:
     ~azure.mgmt.migrationassessment.models.SqlAvailabilityReplicaSummary
    :ivar is_clustered: Gets a value indicating whether the SQL instance is clustered or not.
    :vartype is_clustered: bool
    :ivar is_high_availability_enabled: Gets a value indicating whether the high availability is
     enabled or not.
    :vartype is_high_availability_enabled: bool
    :ivar recommended_target_reasonings: Gets the list of recommended target reasoning.
    :vartype recommended_target_reasonings:
     list[~azure.mgmt.migrationassessment.models.SqlRecommendationReasoning]
    :ivar machine_arm_id: Machine arm id.
    :vartype machine_arm_id: str
    :ivar machine_name: Machine display name.
    :vartype machine_name: str
    :ivar instance_name: SQL instance name.
    :vartype instance_name: str
    :ivar sql_instance_sds_arm_id: SQL instance SDS arm id.
    :vartype sql_instance_sds_arm_id: str
    :ivar sql_edition: SQL instance edition.
    :vartype sql_edition: str
    :ivar sql_version: SQL instance version.
    :vartype sql_version: str
    :ivar number_of_cores_allocated: Number of CPU cores assigned to the SQL instance.
    :vartype number_of_cores_allocated: int
    :ivar percentage_cores_utilization: The percentage of the total number of cores being utilized
     by the SQL instance.
    :vartype percentage_cores_utilization: float
    :ivar logical_disks: The logical disk details.
    :vartype logical_disks:
     list[~azure.mgmt.migrationassessment.models.AssessedSqlInstanceDiskDetails]
    :ivar database_summary: The databases summary.
    :vartype database_summary:
     ~azure.mgmt.migrationassessment.models.AssessedSqlInstanceDatabaseSummary
    :ivar confidence_rating_in_percentage: Confidence Rating in Percentage.
    :vartype confidence_rating_in_percentage: float
    :ivar sizing_criterion: Assessment sizing criterion. Known values are: "PerformanceBased" and
     "AsOnPremises".
    :vartype sizing_criterion: str or
     ~azure.mgmt.migrationassessment.models.AssessmentSizingCriterion
    :ivar created_timestamp: When was assessed SQL instance first created.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: When was assessed SQL instance last updated.
    :vartype updated_timestamp: ~datetime.datetime
    """

    _validation = {
        "memory_in_use_in_mb": {"readonly": True},
        "has_scan_occurred": {"readonly": True},
        "recommended_azure_sql_target_type": {"readonly": True},
        "recommended_suitability": {"readonly": True},
        "azure_sql_mi_suitability_details": {"readonly": True},
        "azure_sql_db_suitability_details": {"readonly": True},
        "azure_sql_vm_suitability_details": {"readonly": True},
        "storage_type_based_details": {"readonly": True},
        "product_support_status": {"readonly": True},
        "fci_metadata": {"readonly": True},
        "availability_replica_summary": {"readonly": True},
        "is_clustered": {"readonly": True},
        "is_high_availability_enabled": {"readonly": True},
        "recommended_target_reasonings": {"readonly": True},
        "machine_arm_id": {"readonly": True},
        "machine_name": {"readonly": True},
        "instance_name": {"readonly": True},
        "sql_instance_sds_arm_id": {"readonly": True},
        "sql_edition": {"readonly": True},
        "sql_version": {"readonly": True},
        "number_of_cores_allocated": {"readonly": True},
        "percentage_cores_utilization": {"readonly": True},
        "logical_disks": {"readonly": True},
        "database_summary": {"readonly": True},
        "confidence_rating_in_percentage": {"readonly": True},
        "sizing_criterion": {"readonly": True},
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "memory_in_use_in_mb": {"key": "memoryInUseInMB", "type": "float"},
        "has_scan_occurred": {"key": "hasScanOccurred", "type": "bool"},
        "recommended_azure_sql_target_type": {"key": "recommendedAzureSqlTargetType", "type": "str"},
        "recommended_suitability": {"key": "recommendedSuitability", "type": "str"},
        "azure_sql_mi_suitability_details": {
            "key": "azureSqlMISuitabilityDetails",
            "type": "SqlAssessmentV2PaasSuitabilityData",
        },
        "azure_sql_db_suitability_details": {
            "key": "azureSqlDBSuitabilityDetails",
            "type": "SqlAssessmentV2PaasSuitabilityData",
        },
        "azure_sql_vm_suitability_details": {
            "key": "azureSqlVMSuitabilityDetails",
            "type": "SqlAssessmentV2IaasSuitabilityData",
        },
        "storage_type_based_details": {"key": "storageTypeBasedDetails", "type": "[AssessedSqlInstanceStorageDetails]"},
        "product_support_status": {"key": "productSupportStatus", "type": "ProductSupportStatus"},
        "fci_metadata": {"key": "fciMetadata", "type": "SqlFCIMetadata"},
        "availability_replica_summary": {"key": "availabilityReplicaSummary", "type": "SqlAvailabilityReplicaSummary"},
        "is_clustered": {"key": "isClustered", "type": "bool"},
        "is_high_availability_enabled": {"key": "isHighAvailabilityEnabled", "type": "bool"},
        "recommended_target_reasonings": {"key": "recommendedTargetReasonings", "type": "[SqlRecommendationReasoning]"},
        "machine_arm_id": {"key": "machineArmId", "type": "str"},
        "machine_name": {"key": "machineName", "type": "str"},
        "instance_name": {"key": "instanceName", "type": "str"},
        "sql_instance_sds_arm_id": {"key": "sqlInstanceSdsArmId", "type": "str"},
        "sql_edition": {"key": "sqlEdition", "type": "str"},
        "sql_version": {"key": "sqlVersion", "type": "str"},
        "number_of_cores_allocated": {"key": "numberOfCoresAllocated", "type": "int"},
        "percentage_cores_utilization": {"key": "percentageCoresUtilization", "type": "float"},
        "logical_disks": {"key": "logicalDisks", "type": "[AssessedSqlInstanceDiskDetails]"},
        "database_summary": {"key": "databaseSummary", "type": "AssessedSqlInstanceDatabaseSummary"},
        "confidence_rating_in_percentage": {"key": "confidenceRatingInPercentage", "type": "float"},
        "sizing_criterion": {"key": "sizingCriterion", "type": "str"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:  # pylint: disable=too-many-locals
        """ """
        super().__init__(**kwargs)
        self.memory_in_use_in_mb = None
        self.has_scan_occurred = None
        self.recommended_azure_sql_target_type = None
        self.recommended_suitability = None
        self.azure_sql_mi_suitability_details = None
        self.azure_sql_db_suitability_details = None
        self.azure_sql_vm_suitability_details = None
        self.storage_type_based_details = None
        self.product_support_status = None
        self.fci_metadata = None
        self.availability_replica_summary = None
        self.is_clustered = None
        self.is_high_availability_enabled = None
        self.recommended_target_reasonings = None
        self.machine_arm_id = None
        self.machine_name = None
        self.instance_name = None
        self.sql_instance_sds_arm_id = None
        self.sql_edition = None
        self.sql_version = None
        self.number_of_cores_allocated = None
        self.percentage_cores_utilization = None
        self.logical_disks = None
        self.database_summary = None
        self.confidence_rating_in_percentage = None
        self.sizing_criterion = None
        self.created_timestamp = None
        self.updated_timestamp = None


class AssessedSqlMachine(ProxyResource):
    """SQL Assessment REST resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.AssessedSqlMachineProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AssessedSqlMachineProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AssessedSqlMachineProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.AssessedSqlMachineProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AssessedSqlMachineListResult(_serialization.Model):
    """The response of a AssessedSqlMachine list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AssessedSqlMachine items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.AssessedSqlMachine]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AssessedSqlMachine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AssessedSqlMachine"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AssessedSqlMachine items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.AssessedSqlMachine]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AssessedSqlMachineProperties(_serialization.Model):
    """Assessed SQL machine properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar bios_guid: Gets or sets the BIOS GUID for the machine.
    :vartype bios_guid: str
    :ivar fqdn: Gets or sets the FQDN for the machine.
    :vartype fqdn: str
    :ivar sql_instances: Gets the list of SQL instances discovered on the machine.
    :vartype sql_instances: list[~azure.mgmt.migrationassessment.models.AssessedSqlInstanceSummary]
    :ivar suitability_detail: Gets or sets the detailed messages that were set on the machine
     during
     evaluation. Known values are: "None", "RecommendedSizeHasLessNetworkAdapters",
     "CannotReportComputeCost", "CannotReportStorageCost", "CannotReportBandwidthCosts",
     "PercentageOfCoresUtilizedMissing", "PercentageOfMemoryUtilizedMissing",
     "PercentageOfCoresUtilizedOutOfRange", and "PercentageOfMemoryUtilizedOutOfRange".
    :vartype suitability_detail: str or
     ~azure.mgmt.migrationassessment.models.AzureVmSuitabilityDetail
    :ivar suitability_explanation: Gets or sets the explanation if machine is not suitable for
     cloud. Known values are: "Unknown", "NotApplicable",
     "GuestOperatingSystemArchitectureNotSupported", "GuestOperatingSystemNotSupported",
     "BootTypeNotSupported", "MoreDisksThanSupported", "NoSuitableVmSizeFound",
     "OneOrMoreDisksNotSuitable", "OneOrMoreAdaptersNotSuitable",
     "InternalErrorOccurredDuringComputeEvaluation", "InternalErrorOccurredDuringStorageEvaluation",
     "InternalErrorOccurredDuringNetworkEvaluation", "NoVmSizeSupportsStoragePerformance",
     "NoVmSizeSupportsNetworkPerformance", "NoVmSizeForSelectedPricingTier",
     "NoVmSizeForSelectedAzureLocation", "CheckRedHatLinuxVersion", "CheckOpenSuseLinuxVersion",
     "CheckWindowsServer2008R2Version", "CheckCentOsVersion", "CheckDebianLinuxVersion",
     "CheckSuseLinuxVersion", "CheckOracleLinuxVersion", "CheckUbuntuLinuxVersion",
     "CheckCoreOsLinuxVersion", "WindowsServerVersionConditionallySupported",
     "NoGuestOperatingSystemConditionallySupported", "WindowsClientVersionsConditionallySupported",
     "BootTypeUnknown", "GuestOperatingSystemUnknown", "WindowsServerVersionsSupportedWithCaveat",
     "WindowsOSNoLongerUnderMSSupport", "EndorsedWithConditionsLinuxDistributions",
     "UnendorsedLinuxDistributions", "NoVmSizeForStandardPricingTier",
     "NoVmSizeForBasicPricingTier", "NoVmSizeInSelectedFamilyFound", "NoEaPriceFoundForVmSize", and
     "NoVmSizeFoundForOfferCurrencyReservedInstance".
    :vartype suitability_explanation: str or
     ~azure.mgmt.migrationassessment.models.AzureVmSuitabilityExplanation
    :ivar recommended_vm_size: Gets or sets the Recommended Azure Size for the machine. Known
     values are: "Unknown", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4",
     "Standard_A0", "Standard_A1", "Standard_A2", "Standard_A3", "Standard_A4", "Standard_A5",
     "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A9", "Standard_A10", "Standard_A11",
     "Standard_A1_v2", "Standard_A2_v2", "Standard_A4_v2", "Standard_A8_v2", "Standard_A2m_v2",
     "Standard_A4m_v2", "Standard_A8m_v2", "Standard_D1", "Standard_D2", "Standard_D3",
     "Standard_D4", "Standard_D11", "Standard_D12", "Standard_D13", "Standard_D14",
     "Standard_D1_v2", "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2",
     "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2", "Standard_D15_v2",
     "Standard_DS1", "Standard_DS2", "Standard_DS3", "Standard_DS4", "Standard_DS11",
     "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_DS1_v2", "Standard_DS2_v2",
     "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2",
     "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS15_v2", "Standard_F1",
     "Standard_F2", "Standard_F4", "Standard_F8", "Standard_F16", "Standard_F1s", "Standard_F2s",
     "Standard_F4s", "Standard_F8s", "Standard_F16s", "Standard_G1", "Standard_G2", "Standard_G3",
     "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4",
     "Standard_GS5", "Standard_H8", "Standard_H16", "Standard_H8m", "Standard_H16m",
     "Standard_H16r", "Standard_H16mr", "Standard_L4s", "Standard_L8s", "Standard_L16s",
     "Standard_L32s", "Standard_D2s_v3", "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3",
     "Standard_D32s_v3", "Standard_D64s_v3", "Standard_D2_v3", "Standard_D4_v3", "Standard_D8_v3",
     "Standard_D16_v3", "Standard_D32_v3", "Standard_D64_v3", "Standard_F2s_v2", "Standard_F4s_v2",
     "Standard_F8s_v2", "Standard_F16s_v2", "Standard_F32s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_E2_v3", "Standard_E4_v3", "Standard_E8_v3", "Standard_E16_v3",
     "Standard_E32_v3", "Standard_E64_v3", "Standard_E2s_v3", "Standard_E4s_v3", "Standard_E8s_v3",
     "Standard_E16s_v3", "Standard_E32s_v3", "Standard_E64s_v3", "Standard_M64s", "Standard_M64ms",
     "Standard_M128s", "Standard_M128ms", "Standard_DC2s", "Standard_DC4s", "Standard_E20_v3",
     "Standard_E20s_v3", "Standard_E64i_v3", "Standard_E64is_v3", "Standard_M8ms", "Standard_M16ms",
     "Standard_M32ls", "Standard_M32ms", "Standard_M32ts", "Standard_M64", "Standard_M64ls",
     "Standard_M64m", "Standard_M128", "Standard_M128m", "Standard_L8s_v2", "Standard_L16s_v2",
     "Standard_L32s_v2", "Standard_L48s_v2", "Standard_L64s_v2", "Standard_L80s_v2",
     "Standard_D2_v4", "Standard_D4_v4", "Standard_D8_v4", "Standard_D16_v4", "Standard_D32_v4",
     "Standard_D48_v4", "Standard_D64_v4", "Standard_D2s_v4", "Standard_D4s_v4", "Standard_D8s_v4",
     "Standard_D16s_v4", "Standard_D32s_v4", "Standard_D48s_v4", "Standard_D64s_v4",
     "Standard_D2d_v4", "Standard_D4d_v4", "Standard_D8d_v4", "Standard_D16d_v4",
     "Standard_D32d_v4", "Standard_D48d_v4", "Standard_D64d_v4", "Standard_D2ds_v4",
     "Standard_D4ds_v4", "Standard_D8ds_v4", "Standard_D16ds_v4", "Standard_D32ds_v4",
     "Standard_D48ds_v4", "Standard_D64ds_v4", "Standard_E2_v4", "Standard_E4_v4", "Standard_E8_v4",
     "Standard_E16_v4", "Standard_E20_v4", "Standard_E32_v4", "Standard_E48_v4", "Standard_E64_v4",
     "Standard_E2s_v4", "Standard_E4s_v4", "Standard_E8s_v4", "Standard_E16s_v4",
     "Standard_E20s_v4", "Standard_E32s_v4", "Standard_E48s_v4", "Standard_E64s_v4",
     "Standard_E2d_v4", "Standard_E4d_v4", "Standard_E8d_v4", "Standard_E16d_v4",
     "Standard_E20d_v4", "Standard_E32d_v4", "Standard_E48d_v4", "Standard_E64d_v4",
     "Standard_E2ds_v4", "Standard_E4ds_v4", "Standard_E8ds_v4", "Standard_E16ds_v4",
     "Standard_E20ds_v4", "Standard_E32ds_v4", "Standard_E48ds_v4", "Standard_E64ds_v4",
     "Standard_E2as_v4", "Standard_E4as_v4", "Standard_E8as_v4", "Standard_E16as_v4",
     "Standard_E20as_v4", "Standard_E32as_v4", "Standard_E48as_v4", "Standard_E64as_v4",
     "Standard_E96as_v4", "Standard_D2as_v4", "Standard_D4as_v4", "Standard_D8as_v4",
     "Standard_D16as_v4", "Standard_D32as_v4", "Standard_D48as_v4", "Standard_D64as_v4",
     "Standard_D96as_v4", "Standard_M208ms_v2", "Standard_M208s_v2", "Standard_M416ms_v2",
     "Standard_M416s_v2", "Standard_F48s_v2", "Standard_E48_v3", "Standard_E48s_v3",
     "Standard_E80is_v4", "Standard_E80ids_v4", "Standard_E2a_v4", "Standard_E4a_v4",
     "Standard_E8a_v4", "Standard_E16a_v4", "Standard_E20a_v4", "Standard_E32a_v4",
     "Standard_E48a_v4", "Standard_E64a_v4", "Standard_E96a_v4", "Standard_D2a_v4",
     "Standard_D4a_v4", "Standard_D8a_v4", "Standard_D16a_v4", "Standard_D32a_v4",
     "Standard_D48a_v4", "Standard_D64a_v4", "Standard_D96a_v4", "Standard_M32ms_v2",
     "Standard_M64s_v2", "Standard_M64ms_v2", "Standard_M128s_v2", "Standard_M128ms_v2",
     "Standard_M192is_v2", "Standard_M192ims_v2", "Standard_M32dms_v2", "Standard_M64ds_v2",
     "Standard_M64dms_v2", "Standard_M128ds_v2", "Standard_M128dms_v2", "Standard_M192ids_v2",
     "Standard_M192idms_v2", "Standard_D2_v5", "Standard_D4_v5", "Standard_D8_v5",
     "Standard_D16_v5", "Standard_D32_v5", "Standard_D48_v5", "Standard_D64_v5", "Standard_D96_v5",
     "Standard_D2s_v5", "Standard_D4s_v5", "Standard_D8s_v5", "Standard_D16s_v5",
     "Standard_D32s_v5", "Standard_D48s_v5", "Standard_D64s_v5", "Standard_D96s_v5",
     "Standard_D2d_v5", "Standard_D4d_v5", "Standard_D8d_v5", "Standard_D16d_v5",
     "Standard_D32d_v5", "Standard_D48d_v5", "Standard_D64d_v5", "Standard_D96d_v5",
     "Standard_D2ds_v5", "Standard_D4ds_v5", "Standard_D8ds_v5", "Standard_D16ds_v5",
     "Standard_D32ds_v5", "Standard_D48ds_v5", "Standard_D64ds_v5", "Standard_D96ds_v5",
     "Standard_D2as_v5", "Standard_D4as_v5", "Standard_D8as_v5", "Standard_D16as_v5",
     "Standard_D32as_v5", "Standard_D48as_v5", "Standard_D64as_v5", "Standard_D96as_v5",
     "Standard_D2ads_v5", "Standard_D4ads_v5", "Standard_D8ads_v5", "Standard_D16ads_v5",
     "Standard_D32ads_v5", "Standard_D48ads_v5", "Standard_D64ads_v5", "Standard_D96ads_v5",
     "Standard_E2_v5", "Standard_E4_v5", "Standard_E8_v5", "Standard_E16_v5", "Standard_E20_v5",
     "Standard_E32_v5", "Standard_E48_v5", "Standard_E64_v5", "Standard_E96_v5",
     "Standard_E104i_v5", "Standard_E2s_v5", "Standard_E4s_v5", "Standard_E8s_v5",
     "Standard_E16s_v5", "Standard_E20s_v5", "Standard_E32s_v5", "Standard_E48s_v5",
     "Standard_E64s_v5", "Standard_E96s_v5", "Standard_E104is_v5", "Standard_E2d_v5",
     "Standard_E4d_v5", "Standard_E8d_v5", "Standard_E16d_v5", "Standard_E20d_v5",
     "Standard_E32d_v5", "Standard_E48d_v5", "Standard_E64d_v5", "Standard_E96d_v5",
     "Standard_E104id_v5", "Standard_E2ds_v5", "Standard_E4ds_v5", "Standard_E8ds_v5",
     "Standard_E16ds_v5", "Standard_E20ds_v5", "Standard_E32ds_v5", "Standard_E48ds_v5",
     "Standard_E64ds_v5", "Standard_E96ds_v5", "Standard_E104ids_v5", "Standard_E2as_v5",
     "Standard_E4as_v5", "Standard_E8as_v5", "Standard_E16as_v5", "Standard_E20as_v5",
     "Standard_E32as_v5", "Standard_E48as_v5", "Standard_E64as_v5", "Standard_E96as_v5",
     "Standard_E2ads_v5", "Standard_E4ads_v5", "Standard_E8ads_v5", "Standard_E16ads_v5",
     "Standard_E20ads_v5", "Standard_E32ads_v5", "Standard_E48ads_v5", "Standard_E64ads_v5",
     "Standard_E96ads_v5", "Standard_M8_2ms", "Standard_M8_4ms", "Standard_M16_4ms",
     "Standard_M16_8ms", "Standard_M32_8ms", "Standard_M32_16ms", "Standard_M64_32ms",
     "Standard_M64_16ms", "Standard_M128_64ms", "Standard_M128_32ms", "Standard_E4_2s_v3",
     "Standard_E8_4s_v3", "Standard_E8_2s_v3", "Standard_E16_8s_v3", "Standard_E16_4s_v3",
     "Standard_E32_16s_v3", "Standard_E32_8s_v3", "Standard_E64_32s_v3", "Standard_E64_16s_v3",
     "Standard_E4_2s_v4", "Standard_E8_4s_v4", "Standard_E8_2s_v4", "Standard_E16_8s_v4",
     "Standard_E16_4s_v4", "Standard_E32_16s_v4", "Standard_E32_8s_v4", "Standard_E64_32s_v4",
     "Standard_E64_16s_v4", "Standard_E4_2ds_v4", "Standard_E8_4ds_v4", "Standard_E8_2ds_v4",
     "Standard_E16_8ds_v4", "Standard_E16_4ds_v4", "Standard_E32_16ds_v4", "Standard_E32_8ds_v4",
     "Standard_E64_32ds_v4", "Standard_E64_16ds_v4", "Standard_E4_2as_v4", "Standard_E8_4as_v4",
     "Standard_E8_2as_v4", "Standard_E16_8as_v4", "Standard_E16_4as_v4", "Standard_E32_16as_v4",
     "Standard_E32_8as_v4", "Standard_E64_32as_v4", "Standard_E64_16as_v4", "Standard_E96_48as_v4",
     "Standard_E96_24as_v4", "Standard_E4_2ads_v5", "Standard_E8_4ads_v5", "Standard_E8_2ads_v5",
     "Standard_E16_8ads_v5", "Standard_E16_4ads_v5", "Standard_E32_16ads_v5",
     "Standard_E32_8ads_v5", "Standard_E64_32ads_v5", "Standard_E64_16ads_v5",
     "Standard_E96_48ads_v5", "Standard_E96_24ads_v5", "Standard_E4_2s_v5", "Standard_E8_4s_v5",
     "Standard_E8_2s_v5", "Standard_E16_8s_v5", "Standard_E16_4s_v5", "Standard_E32_16s_v5",
     "Standard_E32_8s_v5", "Standard_E64_32s_v5", "Standard_E64_16s_v5", "Standard_E96_48s_v5",
     "Standard_E96_24s_v5", "Standard_E4_2ds_v5", "Standard_E8_4ds_v5", "Standard_E8_2ds_v5",
     "Standard_E16_8ds_v5", "Standard_E16_4ds_v5", "Standard_E32_16ds_v5", "Standard_E32_8ds_v5",
     "Standard_E64_32ds_v5", "Standard_E64_16ds_v5", "Standard_E96_48ds_v5", "Standard_E96_24ds_v5",
     "Standard_E4_2as_v5", "Standard_E8_4as_v5", "Standard_E8_2as_v5", "Standard_E16_8as_v5",
     "Standard_E16_4as_v5", "Standard_E32_16as_v5", "Standard_E32_8as_v5", "Standard_E64_32as_v5",
     "Standard_E64_16as_v5", "Standard_E96_48as_v5", "Standard_E96_24as_v5", "Standard_GS4_8",
     "Standard_GS4_4", "Standard_GS5_16", "Standard_GS5_8", "Standard_DS11_1_v2",
     "Standard_DS12_2_v2", "Standard_DS12_1_v2", "Standard_DS13_4_v2", "Standard_DS13_2_v2",
     "Standard_DS14_8_v2", "Standard_DS14_4_v2", "Standard_M416_208s_v2", "Standard_M416_208ms_v2",
     "Standard_E2bs_v5", "Standard_E4bs_v5", "Standard_E8bs_v5", "Standard_E16bs_v5",
     "Standard_E32bs_v5", "Standard_E48bs_v5", "Standard_E64bs_v5", "Standard_E2bds_v5",
     "Standard_E4bds_v5", "Standard_E8bds_v5", "Standard_E16bds_v5", "Standard_E32bds_v5",
     "Standard_E48bds_v5", and "Standard_E64bds_v5".
    :vartype recommended_vm_size: str or ~azure.mgmt.migrationassessment.models.AzureVmSize
    :ivar recommended_vm_family: Gets or sets the Recommended Azure VM Family for the machine.
     Known values are: "Unknown", "Basic_A0_A4", "Standard_A0_A7", "Standard_A8_A11", "Av2_series",
     "D_series", "Dv2_series", "DS_series", "DSv2_series", "F_series", "Fs_series", "G_series",
     "GS_series", "H_series", "Ls_series", "Dsv3_series", "Dv3_series", "Fsv2_series", "Ev3_series",
     "Esv3_series", "M_series", "DC_Series", "Lsv2_series", "Ev4_series", "Esv4_series",
     "Edv4_series", "Edsv4_series", "Dv4_series", "Dsv4_series", "Ddv4_series", "Ddsv4_series",
     "Easv4_series", "Dasv4_series", "Mv2_series", "Eav4_series", "Dav4_series", "Msv2_series",
     "Mdsv2_series", "Dv5_series", "Dsv5_series", "Ddv5_series", "Ddsv5_series", "Dasv5_series",
     "Dadsv5_series", "Ev5_series", "Esv5_series", "Edv5_series", "Edsv5_series", "Easv5_series",
     "Eadsv5_series", "Ebsv5_series", and "Ebdsv5_series".
    :vartype recommended_vm_family: str or ~azure.mgmt.migrationassessment.models.AzureVmFamily
    :ivar product_support_status: Gets the product support status related details.
    :vartype product_support_status: ~azure.mgmt.migrationassessment.models.ProductSupportStatus
    :ivar recommended_vm_size_number_of_cores: Gets or sets the Number of cores for recommended
     size.
    :vartype recommended_vm_size_number_of_cores: int
    :ivar recommended_vm_size_megabytes_of_memory: Gets or sets the Megabytes of memory for
     recommended size.
    :vartype recommended_vm_size_megabytes_of_memory: float
    :ivar monthly_compute_cost: Gets or sets the monthly compute cost calculated for recommended
     size.
    :vartype monthly_compute_cost: float
    :ivar disks: Gets the list of data disks that were assessed as part of this assessment.
    :vartype disks: dict[str, ~azure.mgmt.migrationassessment.models.AssessedDiskData]
    :ivar network_adapters: Gets the list of network adapters that were assessed as part of this
     assessment.
    :vartype network_adapters: dict[str,
     ~azure.mgmt.migrationassessment.models.SqlAssessedNetworkAdapter]
    :ivar monthly_bandwidth_cost: Gets or sets the monthly networking cost.
    :vartype monthly_bandwidth_cost: float
    :ivar monthly_storage_cost: Gets or sets the monthly total storage cost.
    :vartype monthly_storage_cost: float
    :ivar cost_components: Gets the collection of cost components.
    :vartype cost_components: list[~azure.mgmt.migrationassessment.models.CostComponent]
    :ivar security_suitability: Gets the suitability for Microsoft cloud defender. Known values
     are: "Unknown", "NotSuitable", "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
    :vartype security_suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
    :ivar migration_guidelines: Gets the list of migration guidelines applicable.
    :vartype migration_guidelines:
     list[~azure.mgmt.migrationassessment.models.SqlMigrationGuideline]
    :ivar boot_type: Boot type of machine discovered in private data center. Known values are:
     "Unknown", "EFI", "BIOS", and "NotSpecified".
    :vartype boot_type: str or ~azure.mgmt.migrationassessment.models.MachineBootType
    :ivar operating_system_type: Operating system as reported by datacenter management solution.
    :vartype operating_system_type: str
    :ivar operating_system_name: Operating system as reported by datacenter management solution.
    :vartype operating_system_name: str
    :ivar operating_system_version: Operating system version as reported by datacenter management
     solution.
    :vartype operating_system_version: str
    :ivar operating_system_architecture: Operating system architecture as reported by datacenter
     management solution. Known values are: "Unknown", "X86", and "X64".
    :vartype operating_system_architecture: str or
     ~azure.mgmt.migrationassessment.models.GuestOperatingSystemArchitecture
    :ivar created_timestamp: When was machine first created.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: When was machine last updated.
    :vartype updated_timestamp: ~datetime.datetime
    :ivar display_name: Display Name of the Machine.
    :vartype display_name: str
    :ivar type: Assessed machine type. Known values are: "Unknown", "AssessedMachine",
     "AvsAssessedMachine", and "SqlAssessedMachine".
    :vartype type: str or ~azure.mgmt.migrationassessment.models.AssessedMachineType
    :ivar description: Description for the machine.
    :vartype description: str
    :ivar datacenter_machine_arm_id: Data center machine ARM id.
    :vartype datacenter_machine_arm_id: str
    :ivar datacenter_management_server_arm_id: Data center management server ARM id.
    :vartype datacenter_management_server_arm_id: str
    :ivar datacenter_management_server_name: Data center management server name.
    :vartype datacenter_management_server_name: str
    :ivar megabytes_of_memory: Megabytes of memory found allocated for the machine in private data
     center.
    :vartype megabytes_of_memory: float
    :ivar number_of_cores: Number of CPU cores found on the machine.
    :vartype number_of_cores: int
    :ivar confidence_rating_in_percentage: Confidence Rating in Percentage.
    :vartype confidence_rating_in_percentage: float
    :ivar percentage_cores_utilization: Percentile of Percentage of Cores Utilized noted during
     time period T.

        Here N and T are settings on Assessment.
    :vartype percentage_cores_utilization: float
    :ivar percentage_memory_utilization: Percentile of Percentage of Memory Utilized noted during
     time period T.

     .. code-block::

        Here N and T are settings on Assessment.
    :vartype percentage_memory_utilization: float
    :ivar suitability: Gets a value indicating whether machine is suitable for the cloud platform
     selected. Known values are: "Unknown", "NotSuitable", "Suitable", "ConditionallySuitable", and
     "ReadinessUnknown".
    :vartype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
    :ivar sizing_criterion: Assessment sizing criterion. Known values are: "PerformanceBased" and
     "AsOnPremises".
    :vartype sizing_criterion: str or
     ~azure.mgmt.migrationassessment.models.AssessmentSizingCriterion
    """

    _validation = {
        "bios_guid": {"readonly": True},
        "fqdn": {"readonly": True},
        "sql_instances": {"readonly": True},
        "suitability_detail": {"readonly": True},
        "suitability_explanation": {"readonly": True},
        "recommended_vm_size": {"readonly": True},
        "recommended_vm_family": {"readonly": True},
        "product_support_status": {"readonly": True},
        "recommended_vm_size_number_of_cores": {"readonly": True},
        "recommended_vm_size_megabytes_of_memory": {"readonly": True},
        "monthly_compute_cost": {"readonly": True},
        "disks": {"readonly": True},
        "network_adapters": {"readonly": True},
        "monthly_bandwidth_cost": {"readonly": True},
        "monthly_storage_cost": {"readonly": True},
        "security_suitability": {"readonly": True},
        "migration_guidelines": {"readonly": True},
        "boot_type": {"readonly": True},
        "operating_system_type": {"readonly": True},
        "operating_system_name": {"readonly": True},
        "operating_system_version": {"readonly": True},
        "operating_system_architecture": {"readonly": True},
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
        "display_name": {"readonly": True},
        "type": {"readonly": True},
        "description": {"readonly": True},
        "datacenter_machine_arm_id": {"readonly": True},
        "datacenter_management_server_arm_id": {"readonly": True},
        "datacenter_management_server_name": {"readonly": True},
        "megabytes_of_memory": {"readonly": True},
        "number_of_cores": {"readonly": True},
        "confidence_rating_in_percentage": {"readonly": True},
        "percentage_cores_utilization": {"readonly": True},
        "percentage_memory_utilization": {"readonly": True},
        "suitability": {"readonly": True},
        "sizing_criterion": {"readonly": True},
    }

    _attribute_map = {
        "bios_guid": {"key": "biosGuid", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "sql_instances": {"key": "sqlInstances", "type": "[AssessedSqlInstanceSummary]"},
        "suitability_detail": {"key": "suitabilityDetail", "type": "str"},
        "suitability_explanation": {"key": "suitabilityExplanation", "type": "str"},
        "recommended_vm_size": {"key": "recommendedVmSize", "type": "str"},
        "recommended_vm_family": {"key": "recommendedVmFamily", "type": "str"},
        "product_support_status": {"key": "productSupportStatus", "type": "ProductSupportStatus"},
        "recommended_vm_size_number_of_cores": {"key": "recommendedVmSizeNumberOfCores", "type": "int"},
        "recommended_vm_size_megabytes_of_memory": {"key": "recommendedVmSizeMegabytesOfMemory", "type": "float"},
        "monthly_compute_cost": {"key": "monthlyComputeCost", "type": "float"},
        "disks": {"key": "disks", "type": "{AssessedDiskData}"},
        "network_adapters": {"key": "networkAdapters", "type": "{SqlAssessedNetworkAdapter}"},
        "monthly_bandwidth_cost": {"key": "monthlyBandwidthCost", "type": "float"},
        "monthly_storage_cost": {"key": "monthlyStorageCost", "type": "float"},
        "cost_components": {"key": "costComponents", "type": "[CostComponent]"},
        "security_suitability": {"key": "securitySuitability", "type": "str"},
        "migration_guidelines": {"key": "migrationGuidelines", "type": "[SqlMigrationGuideline]"},
        "boot_type": {"key": "bootType", "type": "str"},
        "operating_system_type": {"key": "operatingSystemType", "type": "str"},
        "operating_system_name": {"key": "operatingSystemName", "type": "str"},
        "operating_system_version": {"key": "operatingSystemVersion", "type": "str"},
        "operating_system_architecture": {"key": "operatingSystemArchitecture", "type": "str"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
        "display_name": {"key": "displayName", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "datacenter_machine_arm_id": {"key": "datacenterMachineArmId", "type": "str"},
        "datacenter_management_server_arm_id": {"key": "datacenterManagementServerArmId", "type": "str"},
        "datacenter_management_server_name": {"key": "datacenterManagementServerName", "type": "str"},
        "megabytes_of_memory": {"key": "megabytesOfMemory", "type": "float"},
        "number_of_cores": {"key": "numberOfCores", "type": "int"},
        "confidence_rating_in_percentage": {"key": "confidenceRatingInPercentage", "type": "float"},
        "percentage_cores_utilization": {"key": "percentageCoresUtilization", "type": "float"},
        "percentage_memory_utilization": {"key": "percentageMemoryUtilization", "type": "float"},
        "suitability": {"key": "suitability", "type": "str"},
        "sizing_criterion": {"key": "sizingCriterion", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self, *, cost_components: Optional[List["_models.CostComponent"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword cost_components: Gets the collection of cost components.
        :paramtype cost_components: list[~azure.mgmt.migrationassessment.models.CostComponent]
        """
        super().__init__(**kwargs)
        self.bios_guid = None
        self.fqdn = None
        self.sql_instances = None
        self.suitability_detail = None
        self.suitability_explanation = None
        self.recommended_vm_size = None
        self.recommended_vm_family = None
        self.product_support_status = None
        self.recommended_vm_size_number_of_cores = None
        self.recommended_vm_size_megabytes_of_memory = None
        self.monthly_compute_cost = None
        self.disks = None
        self.network_adapters = None
        self.monthly_bandwidth_cost = None
        self.monthly_storage_cost = None
        self.cost_components = cost_components
        self.security_suitability = None
        self.migration_guidelines = None
        self.boot_type = None
        self.operating_system_type = None
        self.operating_system_name = None
        self.operating_system_version = None
        self.operating_system_architecture = None
        self.created_timestamp = None
        self.updated_timestamp = None
        self.display_name = None
        self.type = None
        self.description = None
        self.datacenter_machine_arm_id = None
        self.datacenter_management_server_arm_id = None
        self.datacenter_management_server_name = None
        self.megabytes_of_memory = None
        self.number_of_cores = None
        self.confidence_rating_in_percentage = None
        self.percentage_cores_utilization = None
        self.percentage_memory_utilization = None
        self.suitability = None
        self.sizing_criterion = None


class AssessedSqlRecommendedEntity(ProxyResource):
    """SQL Assessment REST resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.migrationassessment.models.AssessedSqlRecommendedEntityProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AssessedSqlRecommendedEntityProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.AssessedSqlRecommendedEntityProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties:
         ~azure.mgmt.migrationassessment.models.AssessedSqlRecommendedEntityProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AssessedSqlRecommendedEntityListResult(_serialization.Model):
    """The response of a AssessedSqlRecommendedEntity list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AssessedSqlRecommendedEntity items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.AssessedSqlRecommendedEntity]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AssessedSqlRecommendedEntity]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AssessedSqlRecommendedEntity"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AssessedSqlRecommendedEntity items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.AssessedSqlRecommendedEntity]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AssessedSqlRecommendedEntityProperties(_serialization.Model):
    """Assessed SQL recommended entity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar machine_name: Gets or sets machine name.
    :vartype machine_name: str
    :ivar instance_name: Gets or sets SQL instance name.
    :vartype instance_name: str
    :ivar product_support_status: Gets the product support status related details.
    :vartype product_support_status: ~azure.mgmt.migrationassessment.models.ProductSupportStatus
    :ivar db_count: Gets or sets assessed database count.
    :vartype db_count: int
    :ivar discovered_db_count: Gets or sets the total discovered database count.
    :vartype discovered_db_count: int
    :ivar has_scan_occurred: Gets or sets a value indicating whether instance deep discovery has
     occurred or
     not.
    :vartype has_scan_occurred: bool
    :ivar recommended_azure_sql_target_type: Gets or sets the recommended azure SQL target type.
     Known values are: "Unknown", "Recommended", "AzureSqlDatabase", "AzureSqlManagedInstance",
     "AzureSqlVirtualMachine", and "AzureVirtualMachine".
    :vartype recommended_azure_sql_target_type: str or
     ~azure.mgmt.migrationassessment.models.TargetType
    :ivar recommended_suitability: Gets or sets the recommended azure SQL suitability. Known values
     are: "Unknown", "SuitableForSqlDB", "SuitableForSqlMI", "SuitableForVM",
     "PotentiallySuitableForVM", "ReadinessUnknown", "NotSuitable", "SuitableForSqlVM",
     "ConditionallySuitableForSqlDB", "ConditionallySuitableForSqlMI", "ConditionallySuitableForVM",
     and "ConditionallySuitableForSqlVM".
    :vartype recommended_suitability: str or
     ~azure.mgmt.migrationassessment.models.RecommendedSuitability
    :ivar azure_sql_mi_suitability_details: SQL instance azure SQL MI suitability details.
    :vartype azure_sql_mi_suitability_details:
     ~azure.mgmt.migrationassessment.models.SqlAssessmentV2PaasSuitabilityData
    :ivar azure_sql_db_suitability_details: SQL instance azure SQL DB suitability details.
    :vartype azure_sql_db_suitability_details:
     ~azure.mgmt.migrationassessment.models.SqlAssessmentV2PaasSuitabilityData
    :ivar azure_sql_vm_suitability_details: SQL instance azure SQL VM suitability details.
    :vartype azure_sql_vm_suitability_details:
     ~azure.mgmt.migrationassessment.models.SqlAssessmentV2IaasSuitabilityData
    :ivar assessed_sql_entity_arm_id: Gets or sets Arm id of assessed entity.
    :vartype assessed_sql_entity_arm_id: str
    :ivar is_clustered: Gets or sets a value indicating whether the SQL instance is clustered or
     not.
    :vartype is_clustered: bool
    :ivar is_high_availability_enabled: Gets or sets a value indicating whether the high
     availability is enabled or not.
    :vartype is_high_availability_enabled: bool
    :ivar sql_edition: Gets the SQL edition from the recommended entity if applicable.
    :vartype sql_edition: str
    :ivar sql_version: Gets the SQL version from the recommended entity if applicable.
    :vartype sql_version: str
    :ivar sizing_criterion: Assessment sizing criterion. Known values are: "PerformanceBased" and
     "AsOnPremises".
    :vartype sizing_criterion: str or
     ~azure.mgmt.migrationassessment.models.AssessmentSizingCriterion
    """

    _validation = {
        "machine_name": {"readonly": True},
        "instance_name": {"readonly": True},
        "product_support_status": {"readonly": True},
        "db_count": {"readonly": True},
        "discovered_db_count": {"readonly": True},
        "has_scan_occurred": {"readonly": True},
        "recommended_azure_sql_target_type": {"readonly": True},
        "recommended_suitability": {"readonly": True},
        "azure_sql_mi_suitability_details": {"readonly": True},
        "azure_sql_db_suitability_details": {"readonly": True},
        "azure_sql_vm_suitability_details": {"readonly": True},
        "is_clustered": {"readonly": True},
        "is_high_availability_enabled": {"readonly": True},
        "sql_edition": {"readonly": True},
        "sql_version": {"readonly": True},
        "sizing_criterion": {"readonly": True},
    }

    _attribute_map = {
        "machine_name": {"key": "machineName", "type": "str"},
        "instance_name": {"key": "instanceName", "type": "str"},
        "product_support_status": {"key": "productSupportStatus", "type": "ProductSupportStatus"},
        "db_count": {"key": "dbCount", "type": "int"},
        "discovered_db_count": {"key": "discoveredDBCount", "type": "int"},
        "has_scan_occurred": {"key": "hasScanOccurred", "type": "bool"},
        "recommended_azure_sql_target_type": {"key": "recommendedAzureSqlTargetType", "type": "str"},
        "recommended_suitability": {"key": "recommendedSuitability", "type": "str"},
        "azure_sql_mi_suitability_details": {
            "key": "azureSqlMISuitabilityDetails",
            "type": "SqlAssessmentV2PaasSuitabilityData",
        },
        "azure_sql_db_suitability_details": {
            "key": "azureSqlDBSuitabilityDetails",
            "type": "SqlAssessmentV2PaasSuitabilityData",
        },
        "azure_sql_vm_suitability_details": {
            "key": "azureSqlVMSuitabilityDetails",
            "type": "SqlAssessmentV2IaasSuitabilityData",
        },
        "assessed_sql_entity_arm_id": {"key": "assessedSqlEntityArmId", "type": "str"},
        "is_clustered": {"key": "isClustered", "type": "bool"},
        "is_high_availability_enabled": {"key": "isHighAvailabilityEnabled", "type": "bool"},
        "sql_edition": {"key": "sqlEdition", "type": "str"},
        "sql_version": {"key": "sqlVersion", "type": "str"},
        "sizing_criterion": {"key": "sizingCriterion", "type": "str"},
    }

    def __init__(self, *, assessed_sql_entity_arm_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword assessed_sql_entity_arm_id: Gets or sets Arm id of assessed entity.
        :paramtype assessed_sql_entity_arm_id: str
        """
        super().__init__(**kwargs)
        self.machine_name = None
        self.instance_name = None
        self.product_support_status = None
        self.db_count = None
        self.discovered_db_count = None
        self.has_scan_occurred = None
        self.recommended_azure_sql_target_type = None
        self.recommended_suitability = None
        self.azure_sql_mi_suitability_details = None
        self.azure_sql_db_suitability_details = None
        self.azure_sql_vm_suitability_details = None
        self.assessed_sql_entity_arm_id = assessed_sql_entity_arm_id
        self.is_clustered = None
        self.is_high_availability_enabled = None
        self.sql_edition = None
        self.sql_version = None
        self.sizing_criterion = None


class Assessment(ProxyResource):
    """Machine assessment resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.MachineAssessmentProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "MachineAssessmentProperties"},
    }

    def __init__(self, *, properties: Optional["_models.MachineAssessmentProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.MachineAssessmentProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AssessmentListResult(_serialization.Model):
    """The response of a Assessment list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The Assessment items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.Assessment]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Assessment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Assessment"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Assessment items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.Assessment]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AssessmentOptions(ProxyResource):
    """Assessment options resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.AssessmentOptionsProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AssessmentOptionsProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AssessmentOptionsProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.AssessmentOptionsProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AssessmentOptionsListResult(_serialization.Model):
    """The response of a AssessmentOptions list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AssessmentOptions items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.AssessmentOptions]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AssessmentOptions]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AssessmentOptions"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AssessmentOptions items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.AssessmentOptions]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AssessmentOptionsProperties(_serialization.Model):
    """Assessment options properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vm_families: Dictionary of VM families grouped by vm family name describing the targeted
     azure locations of VM family and the category of the family.
    :vartype vm_families: list[~azure.mgmt.migrationassessment.models.VmFamilyOptions]
    :ivar reserved_instance_vm_families: List of supported VM Families.
    :vartype reserved_instance_vm_families: list[str]
    :ivar reserved_instance_supported_locations: List of supported Azure regions for reserved
     instances.
    :vartype reserved_instance_supported_locations: list[str]
    :ivar reserved_instance_supported_currencies: List of supported currencies for reserved
     instances.
    :vartype reserved_instance_supported_currencies: list[str]
    :ivar reserved_instance_supported_offers: List of supported Azure offer codes for reserved
     instances.
    :vartype reserved_instance_supported_offers: list[str]
    :ivar ultra_disk_vm_families: Ultra disk related assessment options.
    :vartype ultra_disk_vm_families:
     list[~azure.mgmt.migrationassessment.models.UltraDiskAssessmentOptions]
    :ivar premium_disk_vm_families: List of VM Families that support premium disks for assessments.
    :vartype premium_disk_vm_families: list[str]
    :ivar savings_plan_vm_families: List of VM Families that support Savings plan offer for
     assessments.
    :vartype savings_plan_vm_families: list[str]
    :ivar savings_plan_supported_locations: List of Azure locations that support Savings plan offer
     for assessments.
    :vartype savings_plan_supported_locations: list[str]
    """

    _validation = {
        "vm_families": {"readonly": True},
        "reserved_instance_vm_families": {"readonly": True},
        "reserved_instance_supported_locations": {"readonly": True},
        "reserved_instance_supported_currencies": {"readonly": True},
        "reserved_instance_supported_offers": {"readonly": True},
        "ultra_disk_vm_families": {"readonly": True},
        "premium_disk_vm_families": {"readonly": True},
        "savings_plan_vm_families": {"readonly": True},
        "savings_plan_supported_locations": {"readonly": True},
    }

    _attribute_map = {
        "vm_families": {"key": "vmFamilies", "type": "[VmFamilyOptions]"},
        "reserved_instance_vm_families": {"key": "reservedInstanceVmFamilies", "type": "[str]"},
        "reserved_instance_supported_locations": {"key": "reservedInstanceSupportedLocations", "type": "[str]"},
        "reserved_instance_supported_currencies": {"key": "reservedInstanceSupportedCurrencies", "type": "[str]"},
        "reserved_instance_supported_offers": {"key": "reservedInstanceSupportedOffers", "type": "[str]"},
        "ultra_disk_vm_families": {"key": "ultraDiskVmFamilies", "type": "[UltraDiskAssessmentOptions]"},
        "premium_disk_vm_families": {"key": "premiumDiskVmFamilies", "type": "[str]"},
        "savings_plan_vm_families": {"key": "savingsPlanVmFamilies", "type": "[str]"},
        "savings_plan_supported_locations": {"key": "savingsPlanSupportedLocations", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.vm_families = None
        self.reserved_instance_vm_families = None
        self.reserved_instance_supported_locations = None
        self.reserved_instance_supported_currencies = None
        self.reserved_instance_supported_offers = None
        self.ultra_disk_vm_families = None
        self.premium_disk_vm_families = None
        self.savings_plan_vm_families = None
        self.savings_plan_supported_locations = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AssessmentProject(TrackedResource):
    """An Assessment project site resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.ProjectProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "ProjectProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ProjectProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.ProjectProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class AssessmentProjectListResult(_serialization.Model):
    """The response of a AssessmentProject list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AssessmentProject items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.AssessmentProject]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AssessmentProject]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AssessmentProject"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AssessmentProject items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.AssessmentProject]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AssessmentProjectSummary(ProxyResource):
    """Assessment project summary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.AssessmentProjectSummaryProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AssessmentProjectSummaryProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.AssessmentProjectSummaryProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties:
         ~azure.mgmt.migrationassessment.models.AssessmentProjectSummaryProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AssessmentProjectSummaryListResult(_serialization.Model):
    """The response of a AssessmentProjectSummary list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AssessmentProjectSummary items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.AssessmentProjectSummary]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AssessmentProjectSummary]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AssessmentProjectSummary"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AssessmentProjectSummary items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.AssessmentProjectSummary]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AssessmentProjectSummaryProperties(_serialization.Model):
    """Assessment project summary properties class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_summary_affected_entities: Gets the Error summary by feature. Contains number of
     affected Entities per
     feature.
    :vartype error_summary_affected_entities:
     list[~azure.mgmt.migrationassessment.models.ErrorSummary]
    :ivar number_of_private_endpoint_connections: Gets the number of private endpoint connections.
    :vartype number_of_private_endpoint_connections: int
    :ivar number_of_groups: Gets the number of groups created in this project.
    :vartype number_of_groups: int
    :ivar number_of_machines: Gets the number of machines part of this project.
    :vartype number_of_machines: int
    :ivar number_of_import_machines: Gets the number of import machines part of this project.
    :vartype number_of_import_machines: int
    :ivar number_of_assessments: Gets the number of assessments created in this project.
    :vartype number_of_assessments: int
    :ivar last_assessment_timestamp: Gets the last assessment timestamp.
    :vartype last_assessment_timestamp: ~datetime.datetime
    """

    _validation = {
        "error_summary_affected_entities": {"readonly": True},
        "number_of_private_endpoint_connections": {"readonly": True},
        "number_of_groups": {"readonly": True},
        "number_of_machines": {"readonly": True},
        "number_of_import_machines": {"readonly": True},
        "number_of_assessments": {"readonly": True},
        "last_assessment_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "error_summary_affected_entities": {"key": "errorSummaryAffectedEntities", "type": "[ErrorSummary]"},
        "number_of_private_endpoint_connections": {"key": "numberOfPrivateEndpointConnections", "type": "int"},
        "number_of_groups": {"key": "numberOfGroups", "type": "int"},
        "number_of_machines": {"key": "numberOfMachines", "type": "int"},
        "number_of_import_machines": {"key": "numberOfImportMachines", "type": "int"},
        "number_of_assessments": {"key": "numberOfAssessments", "type": "int"},
        "last_assessment_timestamp": {"key": "lastAssessmentTimestamp", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error_summary_affected_entities = None
        self.number_of_private_endpoint_connections = None
        self.number_of_groups = None
        self.number_of_machines = None
        self.number_of_import_machines = None
        self.number_of_assessments = None
        self.last_assessment_timestamp = None


class AssessmentProjectUpdate(_serialization.Model):
    """The type used for update operations of the AssessmentProject.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the AssessmentProject.
    :vartype properties: ~azure.mgmt.migrationassessment.models.AssessmentProjectUpdateProperties
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "AssessmentProjectUpdateProperties"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AssessmentProjectUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The updatable properties of the AssessmentProject.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.AssessmentProjectUpdateProperties
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class AssessmentProjectUpdateProperties(_serialization.Model):
    """The updatable properties of the AssessmentProject.

    :ivar assessment_solution_id: Assessment solution ARM id tracked by
     Microsoft.Migrate/migrateProjects.
    :vartype assessment_solution_id: str
    :ivar project_status: Assessment project status. Known values are: "Active" and "Inactive".
    :vartype project_status: str or ~azure.mgmt.migrationassessment.models.ProjectStatus
    :ivar customer_workspace_id: The ARM id of service map workspace created by customer.
    :vartype customer_workspace_id: str
    :ivar customer_workspace_location: Location of service map workspace created by customer.
    :vartype customer_workspace_location: str
    :ivar public_network_access: This value can be set to 'enabled' to avoid breaking changes on
     existing
     customer resources and templates. If set to 'disabled', traffic over public
     interface is not allowed, and private endpoint connections would be the
     exclusive access method.
    :vartype public_network_access: str
    :ivar customer_storage_account_arm_id: The ARM id of the storage account used for interactions
     when public access is
     disabled.
    :vartype customer_storage_account_arm_id: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
    """

    _attribute_map = {
        "assessment_solution_id": {"key": "assessmentSolutionId", "type": "str"},
        "project_status": {"key": "projectStatus", "type": "str"},
        "customer_workspace_id": {"key": "customerWorkspaceId", "type": "str"},
        "customer_workspace_location": {"key": "customerWorkspaceLocation", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "customer_storage_account_arm_id": {"key": "customerStorageAccountArmId", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        assessment_solution_id: Optional[str] = None,
        project_status: Optional[Union[str, "_models.ProjectStatus"]] = None,
        customer_workspace_id: Optional[str] = None,
        customer_workspace_location: Optional[str] = None,
        public_network_access: Optional[str] = None,
        customer_storage_account_arm_id: Optional[str] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword assessment_solution_id: Assessment solution ARM id tracked by
         Microsoft.Migrate/migrateProjects.
        :paramtype assessment_solution_id: str
        :keyword project_status: Assessment project status. Known values are: "Active" and "Inactive".
        :paramtype project_status: str or ~azure.mgmt.migrationassessment.models.ProjectStatus
        :keyword customer_workspace_id: The ARM id of service map workspace created by customer.
        :paramtype customer_workspace_id: str
        :keyword customer_workspace_location: Location of service map workspace created by customer.
        :paramtype customer_workspace_location: str
        :keyword public_network_access: This value can be set to 'enabled' to avoid breaking changes on
         existing
         customer resources and templates. If set to 'disabled', traffic over public
         interface is not allowed, and private endpoint connections would be the
         exclusive access method.
        :paramtype public_network_access: str
        :keyword customer_storage_account_arm_id: The ARM id of the storage account used for
         interactions when public access is
         disabled.
        :paramtype customer_storage_account_arm_id: str
        :keyword provisioning_state: The status of the last operation. Known values are: "Succeeded",
         "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
        :paramtype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
        """
        super().__init__(**kwargs)
        self.assessment_solution_id = assessment_solution_id
        self.project_status = project_status
        self.customer_workspace_id = customer_workspace_id
        self.customer_workspace_location = customer_workspace_location
        self.public_network_access = public_network_access
        self.customer_storage_account_arm_id = customer_storage_account_arm_id
        self.provisioning_state = provisioning_state


class AvsAssessedDisk(_serialization.Model):
    """AVS assessed disk web model class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Gets the ID of the disk.
    :vartype name: str
    :ivar display_name: Gets the display name of the disk.
    :vartype display_name: str
    :ivar gigabytes_provisioned: Gigabytes Provisioned for a disk in private data center.
    :vartype gigabytes_provisioned: float
    :ivar megabytes_per_second_of_read: Disk Read Throughput in MB/s.
    :vartype megabytes_per_second_of_read: float
    :ivar megabytes_per_second_of_write: Disk Write Throughput in MB/s.
    :vartype megabytes_per_second_of_write: float
    :ivar number_of_read_operations_per_second: Read Operations per second.
    :vartype number_of_read_operations_per_second: float
    :ivar number_of_write_operations_per_second: Write Operations per second.
    :vartype number_of_write_operations_per_second: float
    """

    _validation = {
        "name": {"readonly": True},
        "display_name": {"readonly": True},
        "gigabytes_provisioned": {"readonly": True},
        "megabytes_per_second_of_read": {"readonly": True},
        "megabytes_per_second_of_write": {"readonly": True},
        "number_of_read_operations_per_second": {"readonly": True},
        "number_of_write_operations_per_second": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "gigabytes_provisioned": {"key": "gigabytesProvisioned", "type": "float"},
        "megabytes_per_second_of_read": {"key": "megabytesPerSecondOfRead", "type": "float"},
        "megabytes_per_second_of_write": {"key": "megabytesPerSecondOfWrite", "type": "float"},
        "number_of_read_operations_per_second": {"key": "numberOfReadOperationsPerSecond", "type": "float"},
        "number_of_write_operations_per_second": {"key": "numberOfWriteOperationsPerSecond", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.gigabytes_provisioned = None
        self.megabytes_per_second_of_read = None
        self.megabytes_per_second_of_write = None
        self.number_of_read_operations_per_second = None
        self.number_of_write_operations_per_second = None


class AvsAssessedMachine(ProxyResource):
    """AVS assessment Assessed Machine resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.AvsAssessedMachineProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AvsAssessedMachineProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AvsAssessedMachineProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.AvsAssessedMachineProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AvsAssessedMachineListResult(_serialization.Model):
    """The response of a AvsAssessedMachine list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AvsAssessedMachine items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.AvsAssessedMachine]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvsAssessedMachine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AvsAssessedMachine"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AvsAssessedMachine items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.AvsAssessedMachine]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AvsAssessedMachineProperties(_serialization.Model):
    """AVS assessed machine properties web model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar errors: List of errors for this machine.
    :vartype errors: list[~azure.mgmt.migrationassessment.models.Error]
    :ivar disks: List of Disks that were assessed as part of this machine's assessment.
    :vartype disks: dict[str, ~azure.mgmt.migrationassessment.models.AvsAssessedDisk]
    :ivar network_adapters: List of Network Adapters that were assessed as part of this machine's
     assessment.
    :vartype network_adapters: dict[str,
     ~azure.mgmt.migrationassessment.models.AvsAssessedNetworkAdapter]
    :ivar storage_in_use_gb: Gets the storage in use.
    :vartype storage_in_use_gb: float
    :ivar suitability_explanation: Gets the explanation if machine is not suitable for cloud. Known
     values are: "Unknown", "NotApplicable", "IpV6NotSupported", and "UnsupportedOperatingSystem".
    :vartype suitability_explanation: str or
     ~azure.mgmt.migrationassessment.models.AzureAvsVmSuitabilityExplanation
    :ivar suitability_detail: Gets the details if machine is not suitable for cloud. Known values
     are: "None", "PercentageOfCoresUtilizedMissing", "PercentageOfMemoryUtilizedMissing",
     "PercentageOfCoresUtilizedOutOfRange", "PercentageOfMemoryUtilizedOutOfRange", and
     "PercentageOfStorageUtilizedOutOfRange".
    :vartype suitability_detail: str or
     ~azure.mgmt.migrationassessment.models.AzureAvsVmSuitabilityDetail
    :ivar type: Assessed machine type. Known values are: "Unknown", "AssessedMachine",
     "AvsAssessedMachine", and "SqlAssessedMachine".
    :vartype type: str or ~azure.mgmt.migrationassessment.models.AssessedMachineType
    :ivar boot_type: Boot type of machine discovered in private data center. Known values are:
     "Unknown", "EFI", "BIOS", and "NotSpecified".
    :vartype boot_type: str or ~azure.mgmt.migrationassessment.models.MachineBootType
    :ivar operating_system_type: Operating system as reported by datacenter management solution.
    :vartype operating_system_type: str
    :ivar operating_system_name: Operating system as reported by datacenter management solution.
    :vartype operating_system_name: str
    :ivar operating_system_version: Operating system version as reported by datacenter management
     solution.
    :vartype operating_system_version: str
    :ivar operating_system_architecture: Operating system architecture as reported by datacenter
     management solution. Known values are: "Unknown", "X86", and "X64".
    :vartype operating_system_architecture: str or
     ~azure.mgmt.migrationassessment.models.GuestOperatingSystemArchitecture
    :ivar created_timestamp: When was machine first created.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: When was machine last updated.
    :vartype updated_timestamp: ~datetime.datetime
    :ivar display_name: Display Name of the Machine.
    :vartype display_name: str
    :ivar description: Description for the machine.
    :vartype description: str
    :ivar datacenter_machine_arm_id: Data center machine ARM id.
    :vartype datacenter_machine_arm_id: str
    :ivar datacenter_management_server_arm_id: Data center management server ARM id.
    :vartype datacenter_management_server_arm_id: str
    :ivar datacenter_management_server_name: Data center management server name.
    :vartype datacenter_management_server_name: str
    :ivar megabytes_of_memory: Megabytes of memory found allocated for the machine in private data
     center.
    :vartype megabytes_of_memory: float
    :ivar number_of_cores: Number of CPU cores found on the machine.
    :vartype number_of_cores: int
    :ivar confidence_rating_in_percentage: Confidence Rating in Percentage.
    :vartype confidence_rating_in_percentage: float
    :ivar percentage_cores_utilization: Percentile of Percentage of Cores Utilized noted during
     time period T.

        Here N and T are settings on Assessment.
    :vartype percentage_cores_utilization: float
    :ivar percentage_memory_utilization: Percentile of Percentage of Memory Utilized noted during
     time period T.

     .. code-block::

        Here N and T are settings on Assessment.
    :vartype percentage_memory_utilization: float
    :ivar suitability: Gets a value indicating whether machine is suitable for the cloud platform
     selected. Known values are: "Unknown", "NotSuitable", "Suitable", "ConditionallySuitable", and
     "ReadinessUnknown".
    :vartype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
    """

    _validation = {
        "errors": {"readonly": True},
        "disks": {"readonly": True},
        "network_adapters": {"readonly": True},
        "storage_in_use_gb": {"readonly": True},
        "suitability_explanation": {"readonly": True},
        "suitability_detail": {"readonly": True},
        "type": {"readonly": True},
        "boot_type": {"readonly": True},
        "operating_system_type": {"readonly": True},
        "operating_system_name": {"readonly": True},
        "operating_system_version": {"readonly": True},
        "operating_system_architecture": {"readonly": True},
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "datacenter_machine_arm_id": {"readonly": True},
        "datacenter_management_server_arm_id": {"readonly": True},
        "datacenter_management_server_name": {"readonly": True},
        "megabytes_of_memory": {"readonly": True},
        "number_of_cores": {"readonly": True},
        "confidence_rating_in_percentage": {"readonly": True},
        "percentage_cores_utilization": {"readonly": True},
        "percentage_memory_utilization": {"readonly": True},
        "suitability": {"readonly": True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[Error]"},
        "disks": {"key": "disks", "type": "{AvsAssessedDisk}"},
        "network_adapters": {"key": "networkAdapters", "type": "{AvsAssessedNetworkAdapter}"},
        "storage_in_use_gb": {"key": "storageInUseGB", "type": "float"},
        "suitability_explanation": {"key": "suitabilityExplanation", "type": "str"},
        "suitability_detail": {"key": "suitabilityDetail", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "boot_type": {"key": "bootType", "type": "str"},
        "operating_system_type": {"key": "operatingSystemType", "type": "str"},
        "operating_system_name": {"key": "operatingSystemName", "type": "str"},
        "operating_system_version": {"key": "operatingSystemVersion", "type": "str"},
        "operating_system_architecture": {"key": "operatingSystemArchitecture", "type": "str"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "datacenter_machine_arm_id": {"key": "datacenterMachineArmId", "type": "str"},
        "datacenter_management_server_arm_id": {"key": "datacenterManagementServerArmId", "type": "str"},
        "datacenter_management_server_name": {"key": "datacenterManagementServerName", "type": "str"},
        "megabytes_of_memory": {"key": "megabytesOfMemory", "type": "float"},
        "number_of_cores": {"key": "numberOfCores", "type": "int"},
        "confidence_rating_in_percentage": {"key": "confidenceRatingInPercentage", "type": "float"},
        "percentage_cores_utilization": {"key": "percentageCoresUtilization", "type": "float"},
        "percentage_memory_utilization": {"key": "percentageMemoryUtilization", "type": "float"},
        "suitability": {"key": "suitability", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:  # pylint: disable=too-many-locals
        """ """
        super().__init__(**kwargs)
        self.errors = None
        self.disks = None
        self.network_adapters = None
        self.storage_in_use_gb = None
        self.suitability_explanation = None
        self.suitability_detail = None
        self.type = None
        self.boot_type = None
        self.operating_system_type = None
        self.operating_system_name = None
        self.operating_system_version = None
        self.operating_system_architecture = None
        self.created_timestamp = None
        self.updated_timestamp = None
        self.display_name = None
        self.description = None
        self.datacenter_machine_arm_id = None
        self.datacenter_management_server_arm_id = None
        self.datacenter_management_server_name = None
        self.megabytes_of_memory = None
        self.number_of_cores = None
        self.confidence_rating_in_percentage = None
        self.percentage_cores_utilization = None
        self.percentage_memory_utilization = None
        self.suitability = None


class AvsAssessedNetworkAdapter(_serialization.Model):
    """Second level object returned as part of AVS AssessedMachine REST resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mac_address: Mac address of the NIC.
    :vartype mac_address: str
    :ivar ip_addresses: IP V4 addresses for the machine.
    :vartype ip_addresses: list[str]
    :ivar display_name: Gets the display name of the network adapter.
    :vartype display_name: str
    :ivar megabytes_per_second_received: Gets the Received data for Network Adapter in MB/s.
                 This value is
     the percentile of historical data based on options selected in Assessment.
    :vartype megabytes_per_second_received: float
    :ivar megabytes_per_second_transmitted: Gets the Transmitted data for Network Adapter in MB/s.
                 This value
     is the percentile of historical data based on options selected in Assessment.
    :vartype megabytes_per_second_transmitted: float
    """

    _validation = {
        "mac_address": {"readonly": True},
        "ip_addresses": {"readonly": True},
        "display_name": {"readonly": True},
        "megabytes_per_second_received": {"readonly": True},
        "megabytes_per_second_transmitted": {"readonly": True},
    }

    _attribute_map = {
        "mac_address": {"key": "macAddress", "type": "str"},
        "ip_addresses": {"key": "ipAddresses", "type": "[str]"},
        "display_name": {"key": "displayName", "type": "str"},
        "megabytes_per_second_received": {"key": "megabytesPerSecondReceived", "type": "float"},
        "megabytes_per_second_transmitted": {"key": "megabytesPerSecondTransmitted", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mac_address = None
        self.ip_addresses = None
        self.display_name = None
        self.megabytes_per_second_received = None
        self.megabytes_per_second_transmitted = None


class AvsAssessment(ProxyResource):
    """AVS assessment resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.AvsAssessmentProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AvsAssessmentProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AvsAssessmentProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.AvsAssessmentProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AvsAssessmentListResult(_serialization.Model):
    """The response of a AvsAssessment list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AvsAssessment items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.AvsAssessment]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvsAssessment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AvsAssessment"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The AvsAssessment items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.AvsAssessment]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AvsAssessmentOptions(ProxyResource):
    """AVS Assessment options resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.AvsAssessmentOptionsProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AvsAssessmentOptionsProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AvsAssessmentOptionsProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.AvsAssessmentOptionsProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AvsAssessmentOptionsListResult(_serialization.Model):
    """The response of a AvsAssessmentOptions list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The AvsAssessmentOptions items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.AvsAssessmentOptions]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvsAssessmentOptions]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.AvsAssessmentOptions"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The AvsAssessmentOptions items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.AvsAssessmentOptions]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AvsAssessmentOptionsProperties(_serialization.Model):
    """AVS Assessment options properties.

    :ivar avs_nodes: AVS SKU Nodes.
    :vartype avs_nodes: list[~azure.mgmt.migrationassessment.models.AvsSkuOptions]
    :ivar failures_to_tolerate_and_raid_level_values: FTT and Raid level values.
    :vartype failures_to_tolerate_and_raid_level_values: list[str or
     ~azure.mgmt.migrationassessment.models.FttAndRaidLevel]
    :ivar reserved_instance_avs_nodes: List of AVS nodes for RI.
    :vartype reserved_instance_avs_nodes: list[str or
     ~azure.mgmt.migrationassessment.models.AzureAvsNodeType]
    :ivar reserved_instance_supported_locations: List of supported Azure regions for reserved
     instances.
    :vartype reserved_instance_supported_locations: list[str or
     ~azure.mgmt.migrationassessment.models.AzureLocation]
    :ivar reserved_instance_supported_currencies: List of supported currencies for reserved
     instances.
    :vartype reserved_instance_supported_currencies: list[str or
     ~azure.mgmt.migrationassessment.models.AzureCurrency]
    :ivar reserved_instance_supported_offers: List of supported Azure offer codes for reserved
     instances.
    :vartype reserved_instance_supported_offers: list[str or
     ~azure.mgmt.migrationassessment.models.AzureOfferCode]
    """

    _attribute_map = {
        "avs_nodes": {"key": "avsNodes", "type": "[AvsSkuOptions]"},
        "failures_to_tolerate_and_raid_level_values": {"key": "failuresToTolerateAndRaidLevelValues", "type": "[str]"},
        "reserved_instance_avs_nodes": {"key": "reservedInstanceAvsNodes", "type": "[str]"},
        "reserved_instance_supported_locations": {"key": "reservedInstanceSupportedLocations", "type": "[str]"},
        "reserved_instance_supported_currencies": {"key": "reservedInstanceSupportedCurrencies", "type": "[str]"},
        "reserved_instance_supported_offers": {"key": "reservedInstanceSupportedOffers", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        avs_nodes: Optional[List["_models.AvsSkuOptions"]] = None,
        failures_to_tolerate_and_raid_level_values: Optional[List[Union[str, "_models.FttAndRaidLevel"]]] = None,
        reserved_instance_avs_nodes: Optional[List[Union[str, "_models.AzureAvsNodeType"]]] = None,
        reserved_instance_supported_locations: Optional[List[Union[str, "_models.AzureLocation"]]] = None,
        reserved_instance_supported_currencies: Optional[List[Union[str, "_models.AzureCurrency"]]] = None,
        reserved_instance_supported_offers: Optional[List[Union[str, "_models.AzureOfferCode"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword avs_nodes: AVS SKU Nodes.
        :paramtype avs_nodes: list[~azure.mgmt.migrationassessment.models.AvsSkuOptions]
        :keyword failures_to_tolerate_and_raid_level_values: FTT and Raid level values.
        :paramtype failures_to_tolerate_and_raid_level_values: list[str or
         ~azure.mgmt.migrationassessment.models.FttAndRaidLevel]
        :keyword reserved_instance_avs_nodes: List of AVS nodes for RI.
        :paramtype reserved_instance_avs_nodes: list[str or
         ~azure.mgmt.migrationassessment.models.AzureAvsNodeType]
        :keyword reserved_instance_supported_locations: List of supported Azure regions for reserved
         instances.
        :paramtype reserved_instance_supported_locations: list[str or
         ~azure.mgmt.migrationassessment.models.AzureLocation]
        :keyword reserved_instance_supported_currencies: List of supported currencies for reserved
         instances.
        :paramtype reserved_instance_supported_currencies: list[str or
         ~azure.mgmt.migrationassessment.models.AzureCurrency]
        :keyword reserved_instance_supported_offers: List of supported Azure offer codes for reserved
         instances.
        :paramtype reserved_instance_supported_offers: list[str or
         ~azure.mgmt.migrationassessment.models.AzureOfferCode]
        """
        super().__init__(**kwargs)
        self.avs_nodes = avs_nodes
        self.failures_to_tolerate_and_raid_level_values = failures_to_tolerate_and_raid_level_values
        self.reserved_instance_avs_nodes = reserved_instance_avs_nodes
        self.reserved_instance_supported_locations = reserved_instance_supported_locations
        self.reserved_instance_supported_currencies = reserved_instance_supported_currencies
        self.reserved_instance_supported_offers = reserved_instance_supported_offers


class AzureResourceProperties(_serialization.Model):
    """Common properties for all azure tracked and proxy resources.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self, *, provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The status of the last operation. Known values are: "Succeeded",
         "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
        :paramtype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state


class AvsAssessmentProperties(AzureResourceProperties):
    """Properties of the AVS assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
    :ivar assessment_error_summary: Gets the assessment error summary.
                 This is the number of machines
     affected by each type of error in this assessment.
    :vartype assessment_error_summary: dict[str, int]
    :ivar failures_to_tolerate_and_raid_level: Failures to tolerate and RAID level in a common
     property. Known values are: "Unknown", "Ftt1Raid1", "Ftt1Raid5", "Ftt2Raid1", "Ftt2Raid6", and
     "Ftt3Raid1".
    :vartype failures_to_tolerate_and_raid_level: str or
     ~azure.mgmt.migrationassessment.models.FttAndRaidLevel
    :ivar vcpu_oversubscription: VCPU over subscription.
    :vartype vcpu_oversubscription: float
    :ivar node_type: AVS node type. Known values are: "Unknown" and "AV36".
    :vartype node_type: str or ~azure.mgmt.migrationassessment.models.AzureAvsNodeType
    :ivar reserved_instance: Reserved instance. Known values are: "None", "RI1Year", and "RI3Year".
    :vartype reserved_instance: str or ~azure.mgmt.migrationassessment.models.AzureReservedInstance
    :ivar total_monthly_cost: Total monthly cost.
    :vartype total_monthly_cost: float
    :ivar suitability: Gets or sets the Assessment cloud suitability. Known values are: "Unknown",
     "NotSuitable", "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
    :vartype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
    :ivar suitability_explanation: Gets or sets the Assessment suitability explanation. Known
     values are: "Unknown", "NotApplicable", and "UnsupportedLocationForSelectedNode".
    :vartype suitability_explanation: str or
     ~azure.mgmt.migrationassessment.models.AzureAvsSuitabilityExplanation
    :ivar number_of_nodes: Recommended number of nodes.
    :vartype number_of_nodes: int
    :ivar cpu_utilization: Predicted CPU utilization.
    :vartype cpu_utilization: float
    :ivar ram_utilization: Predicted RAM utilization.
    :vartype ram_utilization: float
    :ivar storage_utilization: Predicted storage utilization.
    :vartype storage_utilization: float
    :ivar total_cpu_cores: Predicted total CPU cores used.
    :vartype total_cpu_cores: float
    :ivar total_ram_in_gb: Predicted total RAM used in GB.
    :vartype total_ram_in_gb: float
    :ivar total_storage_in_gb: Predicted total Storage used in GB.
    :vartype total_storage_in_gb: float
    :ivar number_of_machines: Number of machines part of the assessment.
    :vartype number_of_machines: int
    :ivar suitability_summary: Cloud suitability summary for all the machines in the assessment.
    :vartype suitability_summary: dict[str, int]
    :ivar mem_overcommit: Memory overcommit.
    :vartype mem_overcommit: float
    :ivar dedupe_compression: De-duplication compression.
    :vartype dedupe_compression: float
    :ivar limiting_factor: Limiting factor.
    :vartype limiting_factor: str
    :ivar is_stretch_cluster_enabled: Is Stretch Cluster Enabled.
    :vartype is_stretch_cluster_enabled: bool
    :ivar group_type: Gets the group type for the assessment. Known values are: "Default",
     "Import", and "Import".
    :vartype group_type: str or ~azure.mgmt.migrationassessment.models.GroupType
    :ivar assessment_type: Assessment type of the assessment. Known values are: "Unknown",
     "MachineAssessment", "AvsAssessment", "SqlAssessment", and "WebAppAssessment".
    :vartype assessment_type: str or ~azure.mgmt.migrationassessment.models.AssessmentType
    :ivar azure_location: Azure Location or Azure region where to which the machines will be
     migrated. Known values are: "Unknown", "EastAsia", "SoutheastAsia", "AustraliaEast",
     "AustraliaSoutheast", "BrazilSouth", "CanadaCentral", "CanadaEast", "WestEurope",
     "NorthEurope", "CentralIndia", "SouthIndia", "WestIndia", "JapanEast", "JapanWest",
     "KoreaCentral", "KoreaSouth", "UkWest", "UkSouth", "NorthCentralUs", "EastUs", "WestUs2",
     "SouthCentralUs", "CentralUs", "EastUs2", "WestUs", "WestCentralUs", "GermanyCentral",
     "GermanyNortheast", "ChinaNorth", "ChinaEast", "USGovArizona", "USGovTexas", "USGovIowa",
     "USGovVirginia", "USDoDCentral", "USDoDEast", "FranceCentral", "AustraliaCentral",
     "SouthAfricaNorth", "FranceSouth", "AustraliaCentral2", "SouthAfricaWest", "GermanyNorth",
     "GermanyWestCentral", "NorwayEast", "NorwayWest", "ChinaEast2", "ChinaNorth2",
     "SwitzerlandNorth", "SwitzerlandWest", "UAENorth", "UAECentral", "UsNatEast", "UsNatWest",
     "UsSecEast", "UsSecCentral", "UsSecWest", "SwedenCentral", and "QatarCentral".
    :vartype azure_location: str or ~azure.mgmt.migrationassessment.models.AzureLocation
    :ivar azure_offer_code: Azure Offer code according to which cost estimation is done. Known
     values are: "Unknown", "MSAZR0003P", "MSAZR0044P", "MSAZR0059P", "MSAZR0060P", "MSAZR0062P",
     "MSAZR0063P", "MSAZR0064P", "MSAZR0029P", "MSAZR0022P", "MSAZR0023P", "MSAZR0148P",
     "MSAZR0025P", "MSAZR0036P", "MSAZR0120P", "MSAZR0121P", "MSAZR0122P", "MSAZR0123P",
     "MSAZR0124P", "MSAZR0125P", "MSAZR0126P", "MSAZR0127P", "MSAZR0128P", "MSAZR0129P",
     "MSAZR0130P", "MSAZR0111P", "MSAZR0144P", "MSAZR0149P", "MSMCAZR0044P", "MSMCAZR0059P",
     "MSMCAZR0060P", "MSMCAZR0063P", "MSMCAZR0120P", "MSMCAZR0121P", "MSMCAZR0125P", "MSMCAZR0128P",
     "MSAZRDE0003P", "MSAZRDE0044P", "MSAZRUSGOV0003P", "EA", "MSAZR0243P", "SavingsPlan1Year", and
     "SavingsPlan3Year".
    :vartype azure_offer_code: str or ~azure.mgmt.migrationassessment.models.AzureOfferCode
    :ivar currency: Currency in which prices should be reported. Known values are: "Unknown",
     "USD", "DKK", "CAD", "IDR", "JPY", "KRW", "NZD", "NOK", "RUB", "SAR", "ZAR", "SEK", "TRY",
     "GBP", "MXN", "MYR", "INR", "HKD", "BRL", "TWD", "EUR", "CHF", "ARS", "AUD", "CNY", and "TRY".
    :vartype currency: str or ~azure.mgmt.migrationassessment.models.AzureCurrency
    :ivar scaling_factor: Percentage of buffer that user wants on performance metrics when
     recommending
     Azure sizes.
    :vartype scaling_factor: float
    :ivar percentile: Percentile of the utilization data values to be considered while assessing
     machines. Known values are: "Percentile50", "Percentile90", "Percentile95", and
     "Percentile99".
    :vartype percentile: str or ~azure.mgmt.migrationassessment.models.Percentile
    :ivar time_range: Time Range for which the historic utilization data should be considered for
     assessment. Known values are: "Day", "Week", "Month", and "Custom".
    :vartype time_range: str or ~azure.mgmt.migrationassessment.models.TimeRange
    :ivar perf_data_start_time: Gets or sets the start time to consider performance data for
     assessment.
    :vartype perf_data_start_time: ~datetime.datetime
    :ivar perf_data_end_time: Gets or sets the end time to consider performance data for
     assessment.
    :vartype perf_data_end_time: ~datetime.datetime
    :ivar stage: User configurable setting to display the Stage of Assessment. Known values are:
     "InProgress", "UnderReview", and "Approved".
    :vartype stage: str or ~azure.mgmt.migrationassessment.models.AssessmentStage
    :ivar discount_percentage: Custom discount percentage.
    :vartype discount_percentage: float
    :ivar sizing_criterion: Assessment sizing criterion. Known values are: "PerformanceBased" and
     "AsOnPremises".
    :vartype sizing_criterion: str or
     ~azure.mgmt.migrationassessment.models.AssessmentSizingCriterion
    :ivar confidence_rating_in_percentage: Confidence Rating in Percentage.
    :vartype confidence_rating_in_percentage: float
    :ivar prices_timestamp: Time when the Azure Prices were queried. Date-Time represented in
     ISO-8601
     format.
    :vartype prices_timestamp: ~datetime.datetime
    :ivar created_timestamp: Date and Time when assessment was created.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: Date and Time when assessment was last updated.
    :vartype updated_timestamp: ~datetime.datetime
    :ivar status: Whether assessment is in valid state and all machines have been assessed. Known
     values are: "Created", "Updated", "Running", "Completed", "Invalid", "OutOfSync", "OutDated",
     and "Deleted".
    :vartype status: str or ~azure.mgmt.migrationassessment.models.AssessmentStatus
    :ivar schema_version: Schema version.
    :vartype schema_version: str
    """

    _validation = {
        "assessment_error_summary": {"readonly": True},
        "total_monthly_cost": {"readonly": True},
        "suitability": {"readonly": True},
        "suitability_explanation": {"readonly": True},
        "number_of_nodes": {"readonly": True},
        "cpu_utilization": {"readonly": True},
        "ram_utilization": {"readonly": True},
        "storage_utilization": {"readonly": True},
        "total_cpu_cores": {"readonly": True},
        "total_ram_in_gb": {"readonly": True},
        "total_storage_in_gb": {"readonly": True},
        "number_of_machines": {"readonly": True},
        "suitability_summary": {"readonly": True},
        "limiting_factor": {"readonly": True},
        "group_type": {"readonly": True},
        "assessment_type": {"readonly": True},
        "stage": {"readonly": True},
        "confidence_rating_in_percentage": {"readonly": True},
        "prices_timestamp": {"readonly": True},
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
        "status": {"readonly": True},
        "schema_version": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "assessment_error_summary": {"key": "assessmentErrorSummary", "type": "{int}"},
        "failures_to_tolerate_and_raid_level": {"key": "failuresToTolerateAndRaidLevel", "type": "str"},
        "vcpu_oversubscription": {"key": "vcpuOversubscription", "type": "float"},
        "node_type": {"key": "nodeType", "type": "str"},
        "reserved_instance": {"key": "reservedInstance", "type": "str"},
        "total_monthly_cost": {"key": "totalMonthlyCost", "type": "float"},
        "suitability": {"key": "suitability", "type": "str"},
        "suitability_explanation": {"key": "suitabilityExplanation", "type": "str"},
        "number_of_nodes": {"key": "numberOfNodes", "type": "int"},
        "cpu_utilization": {"key": "cpuUtilization", "type": "float"},
        "ram_utilization": {"key": "ramUtilization", "type": "float"},
        "storage_utilization": {"key": "storageUtilization", "type": "float"},
        "total_cpu_cores": {"key": "totalCpuCores", "type": "float"},
        "total_ram_in_gb": {"key": "totalRamInGB", "type": "float"},
        "total_storage_in_gb": {"key": "totalStorageInGB", "type": "float"},
        "number_of_machines": {"key": "numberOfMachines", "type": "int"},
        "suitability_summary": {"key": "suitabilitySummary", "type": "{int}"},
        "mem_overcommit": {"key": "memOvercommit", "type": "float"},
        "dedupe_compression": {"key": "dedupeCompression", "type": "float"},
        "limiting_factor": {"key": "limitingFactor", "type": "str"},
        "is_stretch_cluster_enabled": {"key": "isStretchClusterEnabled", "type": "bool"},
        "group_type": {"key": "groupType", "type": "str"},
        "assessment_type": {"key": "assessmentType", "type": "str"},
        "azure_location": {"key": "azureLocation", "type": "str"},
        "azure_offer_code": {"key": "azureOfferCode", "type": "str"},
        "currency": {"key": "currency", "type": "str"},
        "scaling_factor": {"key": "scalingFactor", "type": "float"},
        "percentile": {"key": "percentile", "type": "str"},
        "time_range": {"key": "timeRange", "type": "str"},
        "perf_data_start_time": {"key": "perfDataStartTime", "type": "iso-8601"},
        "perf_data_end_time": {"key": "perfDataEndTime", "type": "iso-8601"},
        "stage": {"key": "stage", "type": "str"},
        "discount_percentage": {"key": "discountPercentage", "type": "float"},
        "sizing_criterion": {"key": "sizingCriterion", "type": "str"},
        "confidence_rating_in_percentage": {"key": "confidenceRatingInPercentage", "type": "float"},
        "prices_timestamp": {"key": "pricesTimestamp", "type": "iso-8601"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "schema_version": {"key": "schemaVersion", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        failures_to_tolerate_and_raid_level: Optional[Union[str, "_models.FttAndRaidLevel"]] = None,
        vcpu_oversubscription: Optional[float] = None,
        node_type: Optional[Union[str, "_models.AzureAvsNodeType"]] = None,
        reserved_instance: Optional[Union[str, "_models.AzureReservedInstance"]] = None,
        mem_overcommit: Optional[float] = None,
        dedupe_compression: Optional[float] = None,
        is_stretch_cluster_enabled: Optional[bool] = None,
        azure_location: Optional[Union[str, "_models.AzureLocation"]] = None,
        azure_offer_code: Optional[Union[str, "_models.AzureOfferCode"]] = None,
        currency: Optional[Union[str, "_models.AzureCurrency"]] = None,
        scaling_factor: Optional[float] = None,
        percentile: Optional[Union[str, "_models.Percentile"]] = None,
        time_range: Optional[Union[str, "_models.TimeRange"]] = None,
        perf_data_start_time: Optional[datetime.datetime] = None,
        perf_data_end_time: Optional[datetime.datetime] = None,
        discount_percentage: Optional[float] = None,
        sizing_criterion: Optional[Union[str, "_models.AssessmentSizingCriterion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The status of the last operation. Known values are: "Succeeded",
         "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
        :paramtype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
        :keyword failures_to_tolerate_and_raid_level: Failures to tolerate and RAID level in a common
         property. Known values are: "Unknown", "Ftt1Raid1", "Ftt1Raid5", "Ftt2Raid1", "Ftt2Raid6", and
         "Ftt3Raid1".
        :paramtype failures_to_tolerate_and_raid_level: str or
         ~azure.mgmt.migrationassessment.models.FttAndRaidLevel
        :keyword vcpu_oversubscription: VCPU over subscription.
        :paramtype vcpu_oversubscription: float
        :keyword node_type: AVS node type. Known values are: "Unknown" and "AV36".
        :paramtype node_type: str or ~azure.mgmt.migrationassessment.models.AzureAvsNodeType
        :keyword reserved_instance: Reserved instance. Known values are: "None", "RI1Year", and
         "RI3Year".
        :paramtype reserved_instance: str or
         ~azure.mgmt.migrationassessment.models.AzureReservedInstance
        :keyword mem_overcommit: Memory overcommit.
        :paramtype mem_overcommit: float
        :keyword dedupe_compression: De-duplication compression.
        :paramtype dedupe_compression: float
        :keyword is_stretch_cluster_enabled: Is Stretch Cluster Enabled.
        :paramtype is_stretch_cluster_enabled: bool
        :keyword azure_location: Azure Location or Azure region where to which the machines will be
         migrated. Known values are: "Unknown", "EastAsia", "SoutheastAsia", "AustraliaEast",
         "AustraliaSoutheast", "BrazilSouth", "CanadaCentral", "CanadaEast", "WestEurope",
         "NorthEurope", "CentralIndia", "SouthIndia", "WestIndia", "JapanEast", "JapanWest",
         "KoreaCentral", "KoreaSouth", "UkWest", "UkSouth", "NorthCentralUs", "EastUs", "WestUs2",
         "SouthCentralUs", "CentralUs", "EastUs2", "WestUs", "WestCentralUs", "GermanyCentral",
         "GermanyNortheast", "ChinaNorth", "ChinaEast", "USGovArizona", "USGovTexas", "USGovIowa",
         "USGovVirginia", "USDoDCentral", "USDoDEast", "FranceCentral", "AustraliaCentral",
         "SouthAfricaNorth", "FranceSouth", "AustraliaCentral2", "SouthAfricaWest", "GermanyNorth",
         "GermanyWestCentral", "NorwayEast", "NorwayWest", "ChinaEast2", "ChinaNorth2",
         "SwitzerlandNorth", "SwitzerlandWest", "UAENorth", "UAECentral", "UsNatEast", "UsNatWest",
         "UsSecEast", "UsSecCentral", "UsSecWest", "SwedenCentral", and "QatarCentral".
        :paramtype azure_location: str or ~azure.mgmt.migrationassessment.models.AzureLocation
        :keyword azure_offer_code: Azure Offer code according to which cost estimation is done. Known
         values are: "Unknown", "MSAZR0003P", "MSAZR0044P", "MSAZR0059P", "MSAZR0060P", "MSAZR0062P",
         "MSAZR0063P", "MSAZR0064P", "MSAZR0029P", "MSAZR0022P", "MSAZR0023P", "MSAZR0148P",
         "MSAZR0025P", "MSAZR0036P", "MSAZR0120P", "MSAZR0121P", "MSAZR0122P", "MSAZR0123P",
         "MSAZR0124P", "MSAZR0125P", "MSAZR0126P", "MSAZR0127P", "MSAZR0128P", "MSAZR0129P",
         "MSAZR0130P", "MSAZR0111P", "MSAZR0144P", "MSAZR0149P", "MSMCAZR0044P", "MSMCAZR0059P",
         "MSMCAZR0060P", "MSMCAZR0063P", "MSMCAZR0120P", "MSMCAZR0121P", "MSMCAZR0125P", "MSMCAZR0128P",
         "MSAZRDE0003P", "MSAZRDE0044P", "MSAZRUSGOV0003P", "EA", "MSAZR0243P", "SavingsPlan1Year", and
         "SavingsPlan3Year".
        :paramtype azure_offer_code: str or ~azure.mgmt.migrationassessment.models.AzureOfferCode
        :keyword currency: Currency in which prices should be reported. Known values are: "Unknown",
         "USD", "DKK", "CAD", "IDR", "JPY", "KRW", "NZD", "NOK", "RUB", "SAR", "ZAR", "SEK", "TRY",
         "GBP", "MXN", "MYR", "INR", "HKD", "BRL", "TWD", "EUR", "CHF", "ARS", "AUD", "CNY", and "TRY".
        :paramtype currency: str or ~azure.mgmt.migrationassessment.models.AzureCurrency
        :keyword scaling_factor: Percentage of buffer that user wants on performance metrics when
         recommending
         Azure sizes.
        :paramtype scaling_factor: float
        :keyword percentile: Percentile of the utilization data values to be considered while assessing
         machines. Known values are: "Percentile50", "Percentile90", "Percentile95", and
         "Percentile99".
        :paramtype percentile: str or ~azure.mgmt.migrationassessment.models.Percentile
        :keyword time_range: Time Range for which the historic utilization data should be considered
         for
         assessment. Known values are: "Day", "Week", "Month", and "Custom".
        :paramtype time_range: str or ~azure.mgmt.migrationassessment.models.TimeRange
        :keyword perf_data_start_time: Gets or sets the start time to consider performance data for
         assessment.
        :paramtype perf_data_start_time: ~datetime.datetime
        :keyword perf_data_end_time: Gets or sets the end time to consider performance data for
         assessment.
        :paramtype perf_data_end_time: ~datetime.datetime
        :keyword discount_percentage: Custom discount percentage.
        :paramtype discount_percentage: float
        :keyword sizing_criterion: Assessment sizing criterion. Known values are: "PerformanceBased"
         and "AsOnPremises".
        :paramtype sizing_criterion: str or
         ~azure.mgmt.migrationassessment.models.AssessmentSizingCriterion
        """
        super().__init__(provisioning_state=provisioning_state, **kwargs)
        self.assessment_error_summary = None
        self.failures_to_tolerate_and_raid_level = failures_to_tolerate_and_raid_level
        self.vcpu_oversubscription = vcpu_oversubscription
        self.node_type = node_type
        self.reserved_instance = reserved_instance
        self.total_monthly_cost = None
        self.suitability = None
        self.suitability_explanation = None
        self.number_of_nodes = None
        self.cpu_utilization = None
        self.ram_utilization = None
        self.storage_utilization = None
        self.total_cpu_cores = None
        self.total_ram_in_gb = None
        self.total_storage_in_gb = None
        self.number_of_machines = None
        self.suitability_summary = None
        self.mem_overcommit = mem_overcommit
        self.dedupe_compression = dedupe_compression
        self.limiting_factor = None
        self.is_stretch_cluster_enabled = is_stretch_cluster_enabled
        self.group_type = None
        self.assessment_type = None
        self.azure_location = azure_location
        self.azure_offer_code = azure_offer_code
        self.currency = currency
        self.scaling_factor = scaling_factor
        self.percentile = percentile
        self.time_range = time_range
        self.perf_data_start_time = perf_data_start_time
        self.perf_data_end_time = perf_data_end_time
        self.stage = None
        self.discount_percentage = discount_percentage
        self.sizing_criterion = sizing_criterion
        self.confidence_rating_in_percentage = None
        self.prices_timestamp = None
        self.created_timestamp = None
        self.updated_timestamp = None
        self.status = None
        self.schema_version = None


class AvsSkuOptions(_serialization.Model):
    """AVS SKU specific options.

    :ivar node_type: AVS Node type. Known values are: "Unknown" and "AV36".
    :vartype node_type: str or ~azure.mgmt.migrationassessment.models.AzureAvsNodeType
    :ivar target_locations: List of locations where this node type is available.
    :vartype target_locations: list[str or ~azure.mgmt.migrationassessment.models.AzureLocation]
    """

    _attribute_map = {
        "node_type": {"key": "nodeType", "type": "str"},
        "target_locations": {"key": "targetLocations", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        node_type: Optional[Union[str, "_models.AzureAvsNodeType"]] = None,
        target_locations: Optional[List[Union[str, "_models.AzureLocation"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword node_type: AVS Node type. Known values are: "Unknown" and "AV36".
        :paramtype node_type: str or ~azure.mgmt.migrationassessment.models.AzureAvsNodeType
        :keyword target_locations: List of locations where this node type is available.
        :paramtype target_locations: list[str or ~azure.mgmt.migrationassessment.models.AzureLocation]
        """
        super().__init__(**kwargs)
        self.node_type = node_type
        self.target_locations = target_locations


class AzureManagedDiskSkuDTO(_serialization.Model):
    """Class representing an Azure Managed Disk SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_type: Gets the Type ("tier") of disk - e.g. standard, premium, ultra. Known values
     are: "Unknown", "Standard", "StandardSSD", "Premium", "StandardOrPremium", "Ultra", and
     "PremiumV2".
    :vartype disk_type: str or
     ~azure.mgmt.migrationassessment.models.AzureManagedDiskSkuDTODiskType
    :ivar disk_size: Gets the Size of the managed disk - e.g. P30, P40. Known values are:
     "Unknown", "Standard_S4", "Standard_S6", "Standard_S10", "Standard_S15", "Standard_S20",
     "Standard_S30", "Standard_S40", "Standard_S50", "Standard_S60", "Standard_S70", "Standard_S80",
     "Premium_P4", "Premium_P6", "Premium_P10", "Premium_P15", "Premium_P20", "Premium_P30",
     "Premium_P40", "Premium_P50", "Premium_P60", "Premium_P70", "Premium_P80", "StandardSSD_E10",
     "StandardSSD_E15", "StandardSSD_E20", "StandardSSD_E30", "StandardSSD_E40", "StandardSSD_E50",
     "StandardSSD_E60", "StandardSSD_E70", "StandardSSD_E80", "StandardSSD_E4", "StandardSSD_E6",
     "StandardSSD_E1", "StandardSSD_E2", "StandardSSD_E3", "Premium_P1", "Premium_P2", "Premium_P3",
     "Ultra", and "PremiumV2".
    :vartype disk_size: str or ~azure.mgmt.migrationassessment.models.AzureDiskSize
    :ivar disk_redundancy: Gets disk redundancy - e.g. LRS, ZRS. Known values are: "Unknown",
     "LRS", and "ZRS".
    :vartype disk_redundancy: str or
     ~azure.mgmt.migrationassessment.models.AzureManagedDiskSkuDTODiskRedundancy
    :ivar storage_cost: Gets the managed disk storage cost.
    :vartype storage_cost: float
    :ivar recommended_size_in_gib: Gets the recommended in GB of the managed disk.
    :vartype recommended_size_in_gib: float
    :ivar recommended_throughput_in_mbps: Gets the recommended throughput in MBPS of the managed
     disk.
    :vartype recommended_throughput_in_mbps: float
    :ivar recommended_iops: Gets the recommended IOPS of the managed disk.
    :vartype recommended_iops: float
    """

    _validation = {
        "disk_type": {"readonly": True},
        "disk_size": {"readonly": True},
        "disk_redundancy": {"readonly": True},
        "storage_cost": {"readonly": True},
        "recommended_size_in_gib": {"readonly": True},
        "recommended_throughput_in_mbps": {"readonly": True},
        "recommended_iops": {"readonly": True},
    }

    _attribute_map = {
        "disk_type": {"key": "diskType", "type": "str"},
        "disk_size": {"key": "diskSize", "type": "str"},
        "disk_redundancy": {"key": "diskRedundancy", "type": "str"},
        "storage_cost": {"key": "storageCost", "type": "float"},
        "recommended_size_in_gib": {"key": "recommendedSizeInGib", "type": "float"},
        "recommended_throughput_in_mbps": {"key": "recommendedThroughputInMbps", "type": "float"},
        "recommended_iops": {"key": "recommendedIops", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.disk_type = None
        self.disk_size = None
        self.disk_redundancy = None
        self.storage_cost = None
        self.recommended_size_in_gib = None
        self.recommended_throughput_in_mbps = None
        self.recommended_iops = None


class AzureQuorumWitnessDTO(_serialization.Model):
    """Quorum Witness.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar quorum_witness_type: Gets quorum witness type. Known values are: "Unknown", "Cloud", and
     "Disk".
    :vartype quorum_witness_type: str or
     ~azure.mgmt.migrationassessment.models.AzureQuorumWitnessDTOQuorumWitnessType
    """

    _validation = {
        "quorum_witness_type": {"readonly": True},
    }

    _attribute_map = {
        "quorum_witness_type": {"key": "quorumWitnessType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.quorum_witness_type = None


class AzureSqlIaasSkuDTO(_serialization.Model):
    """Class representing Azure SQL IAAS SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar virtual_machine_size: Gets the The Azure Compute Virtual Machine.
    :vartype virtual_machine_size: ~azure.mgmt.migrationassessment.models.AzureVirtualMachineSkuDTO
    :ivar data_disk_sizes: Gets the The list of data disk sizes.
    :vartype data_disk_sizes: list[~azure.mgmt.migrationassessment.models.AzureManagedDiskSkuDTO]
    :ivar log_disk_sizes: Gets the The list of log disk sizes.
    :vartype log_disk_sizes: list[~azure.mgmt.migrationassessment.models.AzureManagedDiskSkuDTO]
    :ivar azure_sql_target_type: Gets the target type. Known values are: "Unknown", "Recommended",
     "AzureSqlDatabase", "AzureSqlManagedInstance", "AzureSqlVirtualMachine", and
     "AzureVirtualMachine".
    :vartype azure_sql_target_type: str or ~azure.mgmt.migrationassessment.models.TargetType
    """

    _validation = {
        "virtual_machine_size": {"readonly": True},
        "data_disk_sizes": {"readonly": True},
        "log_disk_sizes": {"readonly": True},
        "azure_sql_target_type": {"readonly": True},
    }

    _attribute_map = {
        "virtual_machine_size": {"key": "virtualMachineSize", "type": "AzureVirtualMachineSkuDTO"},
        "data_disk_sizes": {"key": "dataDiskSizes", "type": "[AzureManagedDiskSkuDTO]"},
        "log_disk_sizes": {"key": "logDiskSizes", "type": "[AzureManagedDiskSkuDTO]"},
        "azure_sql_target_type": {"key": "azureSqlTargetType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.virtual_machine_size = None
        self.data_disk_sizes = None
        self.log_disk_sizes = None
        self.azure_sql_target_type = None


class AzureSqlPaasSkuDTO(_serialization.Model):
    """Class representing Azure SQL PAAS SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar azure_sql_service_tier: Gets the service tier. Known values are: "Unknown", "Automatic",
     "GeneralPurpose", "BusinessCritical", and "HyperScale".
    :vartype azure_sql_service_tier: str or
     ~azure.mgmt.migrationassessment.models.AzureSqlServiceTier
    :ivar azure_sql_compute_tier: Gets the compute tier. Known values are: "Unknown", "Automatic",
     "Provisioned", and "Serverless".
    :vartype azure_sql_compute_tier: str or ~azure.mgmt.migrationassessment.models.ComputeTier
    :ivar azure_sql_hardware_generation: Gets the hardware generation. Known values are: "Unknown",
     "Automatic", "Gen5", "Fsv2_series", "M_series", and "DC_series".
    :vartype azure_sql_hardware_generation: str or
     ~azure.mgmt.migrationassessment.models.HardwareGeneration
    :ivar storage_max_size_in_mb: Gets the storage maximum size in megabytes.
    :vartype storage_max_size_in_mb: float
    :ivar predicted_data_size_in_mb: Gets the predicted data size in megabytes in the Azure SQL,
     will impact the
     billing cost.
    :vartype predicted_data_size_in_mb: float
    :ivar predicted_log_size_in_mb: Gets the predicted log size in megabytes in the Azure SQL, will
     impact the
     billing cost.
    :vartype predicted_log_size_in_mb: float
    :ivar cores: Gets the number of cores.
    :vartype cores: int
    :ivar azure_sql_target_type: Gets the target type. Known values are: "Unknown", "Recommended",
     "AzureSqlDatabase", "AzureSqlManagedInstance", "AzureSqlVirtualMachine", and
     "AzureVirtualMachine".
    :vartype azure_sql_target_type: str or ~azure.mgmt.migrationassessment.models.TargetType
    """

    _validation = {
        "azure_sql_service_tier": {"readonly": True},
        "azure_sql_compute_tier": {"readonly": True},
        "azure_sql_hardware_generation": {"readonly": True},
        "storage_max_size_in_mb": {"readonly": True},
        "predicted_data_size_in_mb": {"readonly": True},
        "predicted_log_size_in_mb": {"readonly": True},
        "cores": {"readonly": True},
        "azure_sql_target_type": {"readonly": True},
    }

    _attribute_map = {
        "azure_sql_service_tier": {"key": "azureSqlServiceTier", "type": "str"},
        "azure_sql_compute_tier": {"key": "azureSqlComputeTier", "type": "str"},
        "azure_sql_hardware_generation": {"key": "azureSqlHardwareGeneration", "type": "str"},
        "storage_max_size_in_mb": {"key": "storageMaxSizeInMB", "type": "float"},
        "predicted_data_size_in_mb": {"key": "predictedDataSizeInMB", "type": "float"},
        "predicted_log_size_in_mb": {"key": "predictedLogSizeInMB", "type": "float"},
        "cores": {"key": "cores", "type": "int"},
        "azure_sql_target_type": {"key": "azureSqlTargetType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.azure_sql_service_tier = None
        self.azure_sql_compute_tier = None
        self.azure_sql_hardware_generation = None
        self.storage_max_size_in_mb = None
        self.predicted_data_size_in_mb = None
        self.predicted_log_size_in_mb = None
        self.cores = None
        self.azure_sql_target_type = None


class AzureVirtualMachineSkuDTO(_serialization.Model):
    """Azure Virtual Machine SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar azure_vm_family: Gets the Virtual Machine Family, for example : standardMSFamily. Known
     values are: "Unknown", "Basic_A0_A4", "Standard_A0_A7", "Standard_A8_A11", "Av2_series",
     "D_series", "Dv2_series", "DS_series", "DSv2_series", "F_series", "Fs_series", "G_series",
     "GS_series", "H_series", "Ls_series", "Dsv3_series", "Dv3_series", "Fsv2_series", "Ev3_series",
     "Esv3_series", "M_series", "DC_Series", "Lsv2_series", "Ev4_series", "Esv4_series",
     "Edv4_series", "Edsv4_series", "Dv4_series", "Dsv4_series", "Ddv4_series", "Ddsv4_series",
     "Easv4_series", "Dasv4_series", "Mv2_series", "Eav4_series", "Dav4_series", "Msv2_series",
     "Mdsv2_series", "Dv5_series", "Dsv5_series", "Ddv5_series", "Ddsv5_series", "Dasv5_series",
     "Dadsv5_series", "Ev5_series", "Esv5_series", "Edv5_series", "Edsv5_series", "Easv5_series",
     "Eadsv5_series", "Ebsv5_series", and "Ebdsv5_series".
    :vartype azure_vm_family: str or ~azure.mgmt.migrationassessment.models.AzureVmFamily
    :ivar cores: Gets the Compute Size in vCores.
    :vartype cores: int
    :ivar azure_sku_name: Gets the Virtual Machine SKU name,: E.g. : Standard_F16s. Known values
     are: "Unknown", "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A0",
     "Standard_A1", "Standard_A2", "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6",
     "Standard_A7", "Standard_A8", "Standard_A9", "Standard_A10", "Standard_A11", "Standard_A1_v2",
     "Standard_A2_v2", "Standard_A4_v2", "Standard_A8_v2", "Standard_A2m_v2", "Standard_A4m_v2",
     "Standard_A8m_v2", "Standard_D1", "Standard_D2", "Standard_D3", "Standard_D4", "Standard_D11",
     "Standard_D12", "Standard_D13", "Standard_D14", "Standard_D1_v2", "Standard_D2_v2",
     "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_D11_v2", "Standard_D12_v2",
     "Standard_D13_v2", "Standard_D14_v2", "Standard_D15_v2", "Standard_DS1", "Standard_DS2",
     "Standard_DS3", "Standard_DS4", "Standard_DS11", "Standard_DS12", "Standard_DS13",
     "Standard_DS14", "Standard_DS1_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2",
     "Standard_DS5_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2",
     "Standard_DS14_v2", "Standard_DS15_v2", "Standard_F1", "Standard_F2", "Standard_F4",
     "Standard_F8", "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
     "Standard_F16s", "Standard_G1", "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5",
     "Standard_GS1", "Standard_GS2", "Standard_GS3", "Standard_GS4", "Standard_GS5", "Standard_H8",
     "Standard_H16", "Standard_H8m", "Standard_H16m", "Standard_H16r", "Standard_H16mr",
     "Standard_L4s", "Standard_L8s", "Standard_L16s", "Standard_L32s", "Standard_D2s_v3",
     "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3", "Standard_D32s_v3",
     "Standard_D64s_v3", "Standard_D2_v3", "Standard_D4_v3", "Standard_D8_v3", "Standard_D16_v3",
     "Standard_D32_v3", "Standard_D64_v3", "Standard_F2s_v2", "Standard_F4s_v2", "Standard_F8s_v2",
     "Standard_F16s_v2", "Standard_F32s_v2", "Standard_F64s_v2", "Standard_F72s_v2",
     "Standard_E2_v3", "Standard_E4_v3", "Standard_E8_v3", "Standard_E16_v3", "Standard_E32_v3",
     "Standard_E64_v3", "Standard_E2s_v3", "Standard_E4s_v3", "Standard_E8s_v3", "Standard_E16s_v3",
     "Standard_E32s_v3", "Standard_E64s_v3", "Standard_M64s", "Standard_M64ms", "Standard_M128s",
     "Standard_M128ms", "Standard_DC2s", "Standard_DC4s", "Standard_E20_v3", "Standard_E20s_v3",
     "Standard_E64i_v3", "Standard_E64is_v3", "Standard_M8ms", "Standard_M16ms", "Standard_M32ls",
     "Standard_M32ms", "Standard_M32ts", "Standard_M64", "Standard_M64ls", "Standard_M64m",
     "Standard_M128", "Standard_M128m", "Standard_L8s_v2", "Standard_L16s_v2", "Standard_L32s_v2",
     "Standard_L48s_v2", "Standard_L64s_v2", "Standard_L80s_v2", "Standard_D2_v4", "Standard_D4_v4",
     "Standard_D8_v4", "Standard_D16_v4", "Standard_D32_v4", "Standard_D48_v4", "Standard_D64_v4",
     "Standard_D2s_v4", "Standard_D4s_v4", "Standard_D8s_v4", "Standard_D16s_v4",
     "Standard_D32s_v4", "Standard_D48s_v4", "Standard_D64s_v4", "Standard_D2d_v4",
     "Standard_D4d_v4", "Standard_D8d_v4", "Standard_D16d_v4", "Standard_D32d_v4",
     "Standard_D48d_v4", "Standard_D64d_v4", "Standard_D2ds_v4", "Standard_D4ds_v4",
     "Standard_D8ds_v4", "Standard_D16ds_v4", "Standard_D32ds_v4", "Standard_D48ds_v4",
     "Standard_D64ds_v4", "Standard_E2_v4", "Standard_E4_v4", "Standard_E8_v4", "Standard_E16_v4",
     "Standard_E20_v4", "Standard_E32_v4", "Standard_E48_v4", "Standard_E64_v4", "Standard_E2s_v4",
     "Standard_E4s_v4", "Standard_E8s_v4", "Standard_E16s_v4", "Standard_E20s_v4",
     "Standard_E32s_v4", "Standard_E48s_v4", "Standard_E64s_v4", "Standard_E2d_v4",
     "Standard_E4d_v4", "Standard_E8d_v4", "Standard_E16d_v4", "Standard_E20d_v4",
     "Standard_E32d_v4", "Standard_E48d_v4", "Standard_E64d_v4", "Standard_E2ds_v4",
     "Standard_E4ds_v4", "Standard_E8ds_v4", "Standard_E16ds_v4", "Standard_E20ds_v4",
     "Standard_E32ds_v4", "Standard_E48ds_v4", "Standard_E64ds_v4", "Standard_E2as_v4",
     "Standard_E4as_v4", "Standard_E8as_v4", "Standard_E16as_v4", "Standard_E20as_v4",
     "Standard_E32as_v4", "Standard_E48as_v4", "Standard_E64as_v4", "Standard_E96as_v4",
     "Standard_D2as_v4", "Standard_D4as_v4", "Standard_D8as_v4", "Standard_D16as_v4",
     "Standard_D32as_v4", "Standard_D48as_v4", "Standard_D64as_v4", "Standard_D96as_v4",
     "Standard_M208ms_v2", "Standard_M208s_v2", "Standard_M416ms_v2", "Standard_M416s_v2",
     "Standard_F48s_v2", "Standard_E48_v3", "Standard_E48s_v3", "Standard_E80is_v4",
     "Standard_E80ids_v4", "Standard_E2a_v4", "Standard_E4a_v4", "Standard_E8a_v4",
     "Standard_E16a_v4", "Standard_E20a_v4", "Standard_E32a_v4", "Standard_E48a_v4",
     "Standard_E64a_v4", "Standard_E96a_v4", "Standard_D2a_v4", "Standard_D4a_v4",
     "Standard_D8a_v4", "Standard_D16a_v4", "Standard_D32a_v4", "Standard_D48a_v4",
     "Standard_D64a_v4", "Standard_D96a_v4", "Standard_M32ms_v2", "Standard_M64s_v2",
     "Standard_M64ms_v2", "Standard_M128s_v2", "Standard_M128ms_v2", "Standard_M192is_v2",
     "Standard_M192ims_v2", "Standard_M32dms_v2", "Standard_M64ds_v2", "Standard_M64dms_v2",
     "Standard_M128ds_v2", "Standard_M128dms_v2", "Standard_M192ids_v2", "Standard_M192idms_v2",
     "Standard_D2_v5", "Standard_D4_v5", "Standard_D8_v5", "Standard_D16_v5", "Standard_D32_v5",
     "Standard_D48_v5", "Standard_D64_v5", "Standard_D96_v5", "Standard_D2s_v5", "Standard_D4s_v5",
     "Standard_D8s_v5", "Standard_D16s_v5", "Standard_D32s_v5", "Standard_D48s_v5",
     "Standard_D64s_v5", "Standard_D96s_v5", "Standard_D2d_v5", "Standard_D4d_v5",
     "Standard_D8d_v5", "Standard_D16d_v5", "Standard_D32d_v5", "Standard_D48d_v5",
     "Standard_D64d_v5", "Standard_D96d_v5", "Standard_D2ds_v5", "Standard_D4ds_v5",
     "Standard_D8ds_v5", "Standard_D16ds_v5", "Standard_D32ds_v5", "Standard_D48ds_v5",
     "Standard_D64ds_v5", "Standard_D96ds_v5", "Standard_D2as_v5", "Standard_D4as_v5",
     "Standard_D8as_v5", "Standard_D16as_v5", "Standard_D32as_v5", "Standard_D48as_v5",
     "Standard_D64as_v5", "Standard_D96as_v5", "Standard_D2ads_v5", "Standard_D4ads_v5",
     "Standard_D8ads_v5", "Standard_D16ads_v5", "Standard_D32ads_v5", "Standard_D48ads_v5",
     "Standard_D64ads_v5", "Standard_D96ads_v5", "Standard_E2_v5", "Standard_E4_v5",
     "Standard_E8_v5", "Standard_E16_v5", "Standard_E20_v5", "Standard_E32_v5", "Standard_E48_v5",
     "Standard_E64_v5", "Standard_E96_v5", "Standard_E104i_v5", "Standard_E2s_v5",
     "Standard_E4s_v5", "Standard_E8s_v5", "Standard_E16s_v5", "Standard_E20s_v5",
     "Standard_E32s_v5", "Standard_E48s_v5", "Standard_E64s_v5", "Standard_E96s_v5",
     "Standard_E104is_v5", "Standard_E2d_v5", "Standard_E4d_v5", "Standard_E8d_v5",
     "Standard_E16d_v5", "Standard_E20d_v5", "Standard_E32d_v5", "Standard_E48d_v5",
     "Standard_E64d_v5", "Standard_E96d_v5", "Standard_E104id_v5", "Standard_E2ds_v5",
     "Standard_E4ds_v5", "Standard_E8ds_v5", "Standard_E16ds_v5", "Standard_E20ds_v5",
     "Standard_E32ds_v5", "Standard_E48ds_v5", "Standard_E64ds_v5", "Standard_E96ds_v5",
     "Standard_E104ids_v5", "Standard_E2as_v5", "Standard_E4as_v5", "Standard_E8as_v5",
     "Standard_E16as_v5", "Standard_E20as_v5", "Standard_E32as_v5", "Standard_E48as_v5",
     "Standard_E64as_v5", "Standard_E96as_v5", "Standard_E2ads_v5", "Standard_E4ads_v5",
     "Standard_E8ads_v5", "Standard_E16ads_v5", "Standard_E20ads_v5", "Standard_E32ads_v5",
     "Standard_E48ads_v5", "Standard_E64ads_v5", "Standard_E96ads_v5", "Standard_M8_2ms",
     "Standard_M8_4ms", "Standard_M16_4ms", "Standard_M16_8ms", "Standard_M32_8ms",
     "Standard_M32_16ms", "Standard_M64_32ms", "Standard_M64_16ms", "Standard_M128_64ms",
     "Standard_M128_32ms", "Standard_E4_2s_v3", "Standard_E8_4s_v3", "Standard_E8_2s_v3",
     "Standard_E16_8s_v3", "Standard_E16_4s_v3", "Standard_E32_16s_v3", "Standard_E32_8s_v3",
     "Standard_E64_32s_v3", "Standard_E64_16s_v3", "Standard_E4_2s_v4", "Standard_E8_4s_v4",
     "Standard_E8_2s_v4", "Standard_E16_8s_v4", "Standard_E16_4s_v4", "Standard_E32_16s_v4",
     "Standard_E32_8s_v4", "Standard_E64_32s_v4", "Standard_E64_16s_v4", "Standard_E4_2ds_v4",
     "Standard_E8_4ds_v4", "Standard_E8_2ds_v4", "Standard_E16_8ds_v4", "Standard_E16_4ds_v4",
     "Standard_E32_16ds_v4", "Standard_E32_8ds_v4", "Standard_E64_32ds_v4", "Standard_E64_16ds_v4",
     "Standard_E4_2as_v4", "Standard_E8_4as_v4", "Standard_E8_2as_v4", "Standard_E16_8as_v4",
     "Standard_E16_4as_v4", "Standard_E32_16as_v4", "Standard_E32_8as_v4", "Standard_E64_32as_v4",
     "Standard_E64_16as_v4", "Standard_E96_48as_v4", "Standard_E96_24as_v4", "Standard_E4_2ads_v5",
     "Standard_E8_4ads_v5", "Standard_E8_2ads_v5", "Standard_E16_8ads_v5", "Standard_E16_4ads_v5",
     "Standard_E32_16ads_v5", "Standard_E32_8ads_v5", "Standard_E64_32ads_v5",
     "Standard_E64_16ads_v5", "Standard_E96_48ads_v5", "Standard_E96_24ads_v5", "Standard_E4_2s_v5",
     "Standard_E8_4s_v5", "Standard_E8_2s_v5", "Standard_E16_8s_v5", "Standard_E16_4s_v5",
     "Standard_E32_16s_v5", "Standard_E32_8s_v5", "Standard_E64_32s_v5", "Standard_E64_16s_v5",
     "Standard_E96_48s_v5", "Standard_E96_24s_v5", "Standard_E4_2ds_v5", "Standard_E8_4ds_v5",
     "Standard_E8_2ds_v5", "Standard_E16_8ds_v5", "Standard_E16_4ds_v5", "Standard_E32_16ds_v5",
     "Standard_E32_8ds_v5", "Standard_E64_32ds_v5", "Standard_E64_16ds_v5", "Standard_E96_48ds_v5",
     "Standard_E96_24ds_v5", "Standard_E4_2as_v5", "Standard_E8_4as_v5", "Standard_E8_2as_v5",
     "Standard_E16_8as_v5", "Standard_E16_4as_v5", "Standard_E32_16as_v5", "Standard_E32_8as_v5",
     "Standard_E64_32as_v5", "Standard_E64_16as_v5", "Standard_E96_48as_v5", "Standard_E96_24as_v5",
     "Standard_GS4_8", "Standard_GS4_4", "Standard_GS5_16", "Standard_GS5_8", "Standard_DS11_1_v2",
     "Standard_DS12_2_v2", "Standard_DS12_1_v2", "Standard_DS13_4_v2", "Standard_DS13_2_v2",
     "Standard_DS14_8_v2", "Standard_DS14_4_v2", "Standard_M416_208s_v2", "Standard_M416_208ms_v2",
     "Standard_E2bs_v5", "Standard_E4bs_v5", "Standard_E8bs_v5", "Standard_E16bs_v5",
     "Standard_E32bs_v5", "Standard_E48bs_v5", "Standard_E64bs_v5", "Standard_E2bds_v5",
     "Standard_E4bds_v5", "Standard_E8bds_v5", "Standard_E16bds_v5", "Standard_E32bds_v5",
     "Standard_E48bds_v5", and "Standard_E64bds_v5".
    :vartype azure_sku_name: str or ~azure.mgmt.migrationassessment.models.AzureVmSize
    :ivar available_cores: Gets the Available vCores. This can be less than the vCores in the
     Constrained
     vCPU VM Sizes.
    :vartype available_cores: int
    :ivar max_network_interfaces: Gets the Max network interfaces.
    :vartype max_network_interfaces: int
    """

    _validation = {
        "azure_vm_family": {"readonly": True},
        "cores": {"readonly": True},
        "azure_sku_name": {"readonly": True},
        "available_cores": {"readonly": True},
        "max_network_interfaces": {"readonly": True},
    }

    _attribute_map = {
        "azure_vm_family": {"key": "azureVmFamily", "type": "str"},
        "cores": {"key": "cores", "type": "int"},
        "azure_sku_name": {"key": "azureSkuName", "type": "str"},
        "available_cores": {"key": "availableCores", "type": "int"},
        "max_network_interfaces": {"key": "maxNetworkInterfaces", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.azure_vm_family = None
        self.cores = None
        self.azure_sku_name = None
        self.available_cores = None
        self.max_network_interfaces = None


class CollectorAgentPropertiesBase(_serialization.Model):
    """Collector agent property class.

    :ivar id: Gets the collector agent id.
    :vartype id: str
    :ivar version: Gets the collector agent version.
    :vartype version: str
    :ivar last_heartbeat_utc: Gets the collector last heartbeat time.
    :vartype last_heartbeat_utc: ~datetime.datetime
    :ivar spn_details: Gets or sets the SPN details.
    :vartype spn_details: ~azure.mgmt.migrationassessment.models.CollectorAgentSpnPropertiesBase
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "last_heartbeat_utc": {"key": "lastHeartbeatUtc", "type": "iso-8601"},
        "spn_details": {"key": "spnDetails", "type": "CollectorAgentSpnPropertiesBase"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        version: Optional[str] = None,
        last_heartbeat_utc: Optional[datetime.datetime] = None,
        spn_details: Optional["_models.CollectorAgentSpnPropertiesBase"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Gets the collector agent id.
        :paramtype id: str
        :keyword version: Gets the collector agent version.
        :paramtype version: str
        :keyword last_heartbeat_utc: Gets the collector last heartbeat time.
        :paramtype last_heartbeat_utc: ~datetime.datetime
        :keyword spn_details: Gets or sets the SPN details.
        :paramtype spn_details: ~azure.mgmt.migrationassessment.models.CollectorAgentSpnPropertiesBase
        """
        super().__init__(**kwargs)
        self.id = id
        self.version = version
        self.last_heartbeat_utc = last_heartbeat_utc
        self.spn_details = spn_details


class CollectorAgentSpnPropertiesBase(_serialization.Model):
    """Collector agent SPN details class.

    :ivar authority: Gets the AAD authority endpoint.
    :vartype authority: str
    :ivar application_id: Gets the AAD application id.
    :vartype application_id: str
    :ivar audience: Gets the AAD audience url.
    :vartype audience: str
    :ivar object_id: Gets the object id of the AAD application.
    :vartype object_id: str
    :ivar tenant_id: Gets the tenant id of the AAD application.
    :vartype tenant_id: str
    """

    _attribute_map = {
        "authority": {"key": "authority", "type": "str"},
        "application_id": {"key": "applicationId", "type": "str"},
        "audience": {"key": "audience", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        authority: Optional[str] = None,
        application_id: Optional[str] = None,
        audience: Optional[str] = None,
        object_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authority: Gets the AAD authority endpoint.
        :paramtype authority: str
        :keyword application_id: Gets the AAD application id.
        :paramtype application_id: str
        :keyword audience: Gets the AAD audience url.
        :paramtype audience: str
        :keyword object_id: Gets the object id of the AAD application.
        :paramtype object_id: str
        :keyword tenant_id: Gets the tenant id of the AAD application.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.authority = authority
        self.application_id = application_id
        self.audience = audience
        self.object_id = object_id
        self.tenant_id = tenant_id


class CollectorPropertiesBase(AzureResourceProperties):
    """Collector properties class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
    :ivar discovery_site_id: Gets the discovery site id.
    :vartype discovery_site_id: str
    :ivar created_timestamp: Gets the Timestamp when collector was created.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: Timestamp when collector was last updated.
    :vartype updated_timestamp: ~datetime.datetime
    """

    _validation = {
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "discovery_site_id": {"key": "discoverySiteId", "type": "str"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        discovery_site_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The status of the last operation. Known values are: "Succeeded",
         "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
        :paramtype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
        :keyword discovery_site_id: Gets the discovery site id.
        :paramtype discovery_site_id: str
        """
        super().__init__(provisioning_state=provisioning_state, **kwargs)
        self.discovery_site_id = discovery_site_id
        self.created_timestamp = None
        self.updated_timestamp = None


class CollectorPropertiesBaseWithAgent(AzureResourceProperties):
    """Collector properties class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
    :ivar agent_properties: Gets or sets the collector agent properties.
    :vartype agent_properties: ~azure.mgmt.migrationassessment.models.CollectorAgentPropertiesBase
    :ivar discovery_site_id: Gets the discovery site id.
    :vartype discovery_site_id: str
    :ivar created_timestamp: Gets the Timestamp when collector was created.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: Timestamp when collector was last updated.
    :vartype updated_timestamp: ~datetime.datetime
    """

    _validation = {
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "agent_properties": {"key": "agentProperties", "type": "CollectorAgentPropertiesBase"},
        "discovery_site_id": {"key": "discoverySiteId", "type": "str"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        agent_properties: Optional["_models.CollectorAgentPropertiesBase"] = None,
        discovery_site_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The status of the last operation. Known values are: "Succeeded",
         "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
        :paramtype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
        :keyword agent_properties: Gets or sets the collector agent properties.
        :paramtype agent_properties:
         ~azure.mgmt.migrationassessment.models.CollectorAgentPropertiesBase
        :keyword discovery_site_id: Gets the discovery site id.
        :paramtype discovery_site_id: str
        """
        super().__init__(provisioning_state=provisioning_state, **kwargs)
        self.agent_properties = agent_properties
        self.discovery_site_id = discovery_site_id
        self.created_timestamp = None
        self.updated_timestamp = None


class CostComponent(_serialization.Model):
    """Class to represent the component of the cost.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Gets the name of the component. Known values are: "Unknown",
     "MonthlyAzureHybridCostSavings", "MonthlySecurityCost", and "MonthlyPremiumV2StorageCost".
    :vartype name: str or ~azure.mgmt.migrationassessment.models.CostComponentName
    :ivar value: The value of the component.
    :vartype value: float
    :ivar description: The textual description of the component.
    :vartype description: str
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "float"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, value: Optional[float] = None, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The value of the component.
        :paramtype value: float
        :keyword description: The textual description of the component.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = None
        self.value = value
        self.description = description


class Disk(_serialization.Model):
    """A disk discovered on a machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar gigabytes_allocated: Gigabytes of storage provisioned for this disk.
    :vartype gigabytes_allocated: float
    :ivar display_name: User friendly name of the disk.
    :vartype display_name: str
    """

    _validation = {
        "gigabytes_allocated": {"readonly": True},
        "display_name": {"readonly": True},
    }

    _attribute_map = {
        "gigabytes_allocated": {"key": "gigabytesAllocated", "type": "float"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.gigabytes_allocated = None
        self.display_name = None


class DownloadUrl(_serialization.Model):
    """Data model of Download URL for assessment report.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar assessment_report_url: Hyperlink to download report. Required.
    :vartype assessment_report_url: str
    :ivar expiration_time: Expiry date of download url. Required.
    :vartype expiration_time: ~datetime.datetime
    """

    _validation = {
        "assessment_report_url": {"required": True, "readonly": True},
        "expiration_time": {"required": True, "readonly": True},
    }

    _attribute_map = {
        "assessment_report_url": {"key": "assessmentReportUrl", "type": "str"},
        "expiration_time": {"key": "expirationTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.assessment_report_url = None
        self.expiration_time = None


class EntityUptime(_serialization.Model):
    """Entity Uptime.

    :ivar days_per_month: Gets the days per month.
    :vartype days_per_month: int
    :ivar hours_per_day: Gets the hours per day.
    :vartype hours_per_day: int
    """

    _attribute_map = {
        "days_per_month": {"key": "daysPerMonth", "type": "int"},
        "hours_per_day": {"key": "hoursPerDay", "type": "int"},
    }

    def __init__(
        self, *, days_per_month: Optional[int] = None, hours_per_day: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword days_per_month: Gets the days per month.
        :paramtype days_per_month: int
        :keyword hours_per_day: Gets the hours per day.
        :paramtype hours_per_day: int
        """
        super().__init__(**kwargs)
        self.days_per_month = days_per_month
        self.hours_per_day = hours_per_day


class Error(_serialization.Model):
    """Error web model class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Gets the error ID.
    :vartype id: int
    :ivar code: Gets the error code.
    :vartype code: str
    :ivar run_as_account_id: Gets the Run as account ID.
    :vartype run_as_account_id: str
    :ivar appliance_name: Gets the Appliance name.
    :vartype appliance_name: str
    :ivar message: Gets the error message.
    :vartype message: str
    :ivar summary_message: Gets the error summary message.
    :vartype summary_message: str
    :ivar agent_scenario: Gets the agent scenario where this error occurred.
    :vartype agent_scenario: str
    :ivar possible_causes: Gets the error possible causes.
    :vartype possible_causes: str
    :ivar recommended_action: Gets the recommended action for the error.
    :vartype recommended_action: str
    :ivar severity: Gets the error severity.
    :vartype severity: str
    :ivar message_parameters: Gets the error message parameters.
    :vartype message_parameters: dict[str, str]
    :ivar updated_time_stamp: Gets the time stamp when the error was updated.
    :vartype updated_time_stamp: ~datetime.datetime
    :ivar impacted_assessment_type: Gets the type of assessment impacted by this error.
    :vartype impacted_assessment_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "code": {"readonly": True},
        "run_as_account_id": {"readonly": True},
        "appliance_name": {"readonly": True},
        "message": {"readonly": True},
        "summary_message": {"readonly": True},
        "agent_scenario": {"readonly": True},
        "possible_causes": {"readonly": True},
        "recommended_action": {"readonly": True},
        "severity": {"readonly": True},
        "message_parameters": {"readonly": True},
        "updated_time_stamp": {"readonly": True},
        "impacted_assessment_type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "code": {"key": "code", "type": "str"},
        "run_as_account_id": {"key": "runAsAccountId", "type": "str"},
        "appliance_name": {"key": "applianceName", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "summary_message": {"key": "summaryMessage", "type": "str"},
        "agent_scenario": {"key": "agentScenario", "type": "str"},
        "possible_causes": {"key": "possibleCauses", "type": "str"},
        "recommended_action": {"key": "recommendedAction", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "message_parameters": {"key": "messageParameters", "type": "{str}"},
        "updated_time_stamp": {"key": "updatedTimeStamp", "type": "iso-8601"},
        "impacted_assessment_type": {"key": "impactedAssessmentType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.code = None
        self.run_as_account_id = None
        self.appliance_name = None
        self.message = None
        self.summary_message = None
        self.agent_scenario = None
        self.possible_causes = None
        self.recommended_action = None
        self.severity = None
        self.message_parameters = None
        self.updated_time_stamp = None
        self.impacted_assessment_type = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.migrationassessment.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.migrationassessment.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.migrationassessment.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.migrationassessment.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorSummary(_serialization.Model):
    """Error summary containing affected entities for each type of assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar assessment_type: Gets the assessment type. Known values are: "Unknown",
     "MachineAssessment", "AvsAssessment", "SqlAssessment", and "WebAppAssessment".
    :vartype assessment_type: str or ~azure.mgmt.migrationassessment.models.AssessmentType
    :ivar count: Gets the affected entity count.
    :vartype count: int
    """

    _validation = {
        "assessment_type": {"readonly": True},
        "count": {"readonly": True},
    }

    _attribute_map = {
        "assessment_type": {"key": "assessmentType", "type": "str"},
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.assessment_type = None
        self.count = None


class Group(ProxyResource):
    """Group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.GroupProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GroupProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GroupProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.GroupProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class GroupBodyProperties(_serialization.Model):
    """Body properties of group update.

    :ivar operation_type: Whether to add or remove the machines. Known values are: "Add" and
     "Remove".
    :vartype operation_type: str or ~azure.mgmt.migrationassessment.models.GroupUpdateOperation
    :ivar machines: List of machine names that are part of this group.
    :vartype machines: list[str]
    """

    _attribute_map = {
        "operation_type": {"key": "operationType", "type": "str"},
        "machines": {"key": "machines", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        operation_type: Optional[Union[str, "_models.GroupUpdateOperation"]] = None,
        machines: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_type: Whether to add or remove the machines. Known values are: "Add" and
         "Remove".
        :paramtype operation_type: str or ~azure.mgmt.migrationassessment.models.GroupUpdateOperation
        :keyword machines: List of machine names that are part of this group.
        :paramtype machines: list[str]
        """
        super().__init__(**kwargs)
        self.operation_type = operation_type
        self.machines = machines


class GroupListResult(_serialization.Model):
    """The response of a Group list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The Group items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.Group]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Group]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Group"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Group items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.Group]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GroupProperties(AzureResourceProperties):
    """Properties of group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
    :ivar group_status: Whether the group has been created and is valid. Known values are:
     "Created", "Updated", "Running", "Completed", and "Invalid".
    :vartype group_status: str or ~azure.mgmt.migrationassessment.models.GroupStatus
    :ivar machine_count: Number of machines part of this group.
    :vartype machine_count: int
    :ivar assessments: List of References to Assessments created on this group.
    :vartype assessments: list[str]
    :ivar supported_assessment_types: List of assessment types supported on this group.
    :vartype supported_assessment_types: list[str or
     ~azure.mgmt.migrationassessment.models.AssessmentType]
    :ivar are_assessments_running: If the assessments are in running state.
    :vartype are_assessments_running: bool
    :ivar created_timestamp: Time when this group was created. Date-Time represented in ISO-8601
     format.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: Time when this group was last updated. Date-Time represented in
     ISO-8601 format.
    :vartype updated_timestamp: ~datetime.datetime
    :ivar group_type: The type of group. Known values are: "Default", "Import", and "Import".
    :vartype group_type: str or ~azure.mgmt.migrationassessment.models.GroupType
    """

    _validation = {
        "group_status": {"readonly": True},
        "machine_count": {"readonly": True},
        "assessments": {"readonly": True},
        "are_assessments_running": {"readonly": True},
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "group_status": {"key": "groupStatus", "type": "str"},
        "machine_count": {"key": "machineCount", "type": "int"},
        "assessments": {"key": "assessments", "type": "[str]"},
        "supported_assessment_types": {"key": "supportedAssessmentTypes", "type": "[str]"},
        "are_assessments_running": {"key": "areAssessmentsRunning", "type": "bool"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
        "group_type": {"key": "groupType", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        supported_assessment_types: Optional[List[Union[str, "_models.AssessmentType"]]] = None,
        group_type: Optional[Union[str, "_models.GroupType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The status of the last operation. Known values are: "Succeeded",
         "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
        :paramtype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
        :keyword supported_assessment_types: List of assessment types supported on this group.
        :paramtype supported_assessment_types: list[str or
         ~azure.mgmt.migrationassessment.models.AssessmentType]
        :keyword group_type: The type of group. Known values are: "Default", "Import", and "Import".
        :paramtype group_type: str or ~azure.mgmt.migrationassessment.models.GroupType
        """
        super().__init__(provisioning_state=provisioning_state, **kwargs)
        self.group_status = None
        self.machine_count = None
        self.assessments = None
        self.supported_assessment_types = supported_assessment_types
        self.are_assessments_running = None
        self.created_timestamp = None
        self.updated_timestamp = None
        self.group_type = group_type


class HypervCollector(ProxyResource):
    """Hyper-V collector resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.CollectorPropertiesBaseWithAgent
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "CollectorPropertiesBaseWithAgent"},
    }

    def __init__(
        self, *, properties: Optional["_models.CollectorPropertiesBaseWithAgent"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.CollectorPropertiesBaseWithAgent
        """
        super().__init__(**kwargs)
        self.properties = properties


class HypervCollectorListResult(_serialization.Model):
    """The response of a HypervCollector list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The HypervCollector items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.HypervCollector]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HypervCollector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.HypervCollector"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The HypervCollector items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.HypervCollector]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ImpactedAssessmentObject(_serialization.Model):
    """Class representing the impacted objects.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar object_name: Gets the object name.
    :vartype object_name: str
    :ivar object_type: Gets the object type.
    :vartype object_type: str
    """

    _validation = {
        "object_name": {"readonly": True},
        "object_type": {"readonly": True},
    }

    _attribute_map = {
        "object_name": {"key": "objectName", "type": "str"},
        "object_type": {"key": "objectType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_name = None
        self.object_type = None


class ImportCollector(ProxyResource):
    """Import collector resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.CollectorPropertiesBase
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "CollectorPropertiesBase"},
    }

    def __init__(self, *, properties: Optional["_models.CollectorPropertiesBase"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.CollectorPropertiesBase
        """
        super().__init__(**kwargs)
        self.properties = properties


class ImportCollectorListResult(_serialization.Model):
    """The response of a ImportCollector list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The ImportCollector items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.ImportCollector]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ImportCollector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.ImportCollector"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The ImportCollector items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.ImportCollector]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Machine(ProxyResource):
    """Machine resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.MachineProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "MachineProperties"},
    }

    def __init__(self, *, properties: Optional["_models.MachineProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.MachineProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class MachineAssessmentProperties(AzureResourceProperties):
    """Properties of an assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
    :ivar assessment_error_summary: Gets or sets the assessment error summary.
                 This is the number of
     machines affected by each type of error in this assessment.
    :vartype assessment_error_summary: dict[str, int]
    :ivar monthly_ultra_storage_cost: Gets or sets the aggregate ultra storage cost for all
     machines in the
     assessment.
    :vartype monthly_ultra_storage_cost: float
    :ivar cost_components: Gets the collection of cost components.
    :vartype cost_components: list[~azure.mgmt.migrationassessment.models.CostComponent]
    :ivar ea_subscription_id: Gets or sets enterprise agreement subscription id.
    :vartype ea_subscription_id: str
    :ivar azure_pricing_tier: Gets or sets Azure Pricing Tier - Free, Basic, etc. Known values are:
     "Standard" and "Basic".
    :vartype azure_pricing_tier: str or ~azure.mgmt.migrationassessment.models.AzurePricingTier
    :ivar azure_storage_redundancy: Gets or sets the Azure Storage Redundancy. Example: Locally
     Redundant Storage. Known values are: "Unknown", "LocallyRedundant", "ZoneRedundant",
     "GeoRedundant", and "ReadAccessGeoRedundant".
    :vartype azure_storage_redundancy: str or
     ~azure.mgmt.migrationassessment.models.AzureStorageRedundancy
    :ivar reserved_instance: Gets or sets the Azure Reserved Instance - 1-Year, 3-Year. Known
     values are: "None", "RI1Year", and "RI3Year".
    :vartype reserved_instance: str or ~azure.mgmt.migrationassessment.models.AzureReservedInstance
    :ivar azure_hybrid_use_benefit: Gets or sets the user configurable setting to display the azure
     hybrid use
     benefit. Known values are: "Unknown", "Yes", and "No".
    :vartype azure_hybrid_use_benefit: str or
     ~azure.mgmt.migrationassessment.models.AzureHybridUseBenefit
    :ivar azure_disk_types: Gets or sets the azure storage type. Premium, Standard etc.
    :vartype azure_disk_types: list[str or ~azure.mgmt.migrationassessment.models.AzureDiskType]
    :ivar azure_vm_families: Gets or sets the Azure VM families.
    :vartype azure_vm_families: list[str or ~azure.mgmt.migrationassessment.models.AzureVmFamily]
    :ivar distribution_by_support_status: Gets the distribution of sqlInstances by support status.
    :vartype distribution_by_support_status: dict[str, int]
    :ivar distribution_by_service_pack_insight: Gets the distribution distribution of sqlInstances
     by service pack insight.
    :vartype distribution_by_service_pack_insight: dict[str, int]
    :ivar distribution_by_os_name: Gets the distribution by os name.
    :vartype distribution_by_os_name: dict[str, int]
    :ivar monthly_compute_cost: Gets or sets the aggregate Compute Cost for all machines in the
     assessment.
    :vartype monthly_compute_cost: float
    :ivar monthly_bandwidth_cost: Gets or sets the aggregate Bandwidth Cost for all machines in the
     assessment.
    :vartype monthly_bandwidth_cost: float
    :ivar monthly_storage_cost: Gets or sets the aggregate Storage Cost for all machines in the
     assessment.
    :vartype monthly_storage_cost: float
    :ivar monthly_premium_storage_cost: Gets or sets the aggregate premium storage cost for all
     machines in the
     assessment.
    :vartype monthly_premium_storage_cost: float
    :ivar monthly_standard_ssd_storage_cost: Gets or sets the aggregate standard SSD storage cost
     for all the machines in
     the assessment.
    :vartype monthly_standard_ssd_storage_cost: float
    :ivar suitability_summary: Gets or sets the Cloud suitability summary for all the machines in
     the
     assessment.
    :vartype suitability_summary: dict[str, int]
    :ivar number_of_machines: Gets or sets the Number of machines part of the assessment.
    :vartype number_of_machines: int
    :ivar vm_uptime: Gets or sets the duration for which the VMs are up in the on-premises
     environment.
    :vartype vm_uptime: ~azure.mgmt.migrationassessment.models.VmUptime
    :ivar group_type: Gets the group type for the assessment. Known values are: "Default",
     "Import", and "Import".
    :vartype group_type: str or ~azure.mgmt.migrationassessment.models.GroupType
    :ivar assessment_type: Assessment type of the assessment. Known values are: "Unknown",
     "MachineAssessment", "AvsAssessment", "SqlAssessment", and "WebAppAssessment".
    :vartype assessment_type: str or ~azure.mgmt.migrationassessment.models.AssessmentType
    :ivar azure_location: Azure Location or Azure region where to which the machines will be
     migrated.
    :vartype azure_location: str
    :ivar azure_offer_code: Azure Offer Code. Known values are: "Unknown", "MSAZR0003P",
     "MSAZR0044P", "MSAZR0059P", "MSAZR0060P", "MSAZR0062P", "MSAZR0063P", "MSAZR0064P",
     "MSAZR0029P", "MSAZR0022P", "MSAZR0023P", "MSAZR0148P", "MSAZR0025P", "MSAZR0036P",
     "MSAZR0120P", "MSAZR0121P", "MSAZR0122P", "MSAZR0123P", "MSAZR0124P", "MSAZR0125P",
     "MSAZR0126P", "MSAZR0127P", "MSAZR0128P", "MSAZR0129P", "MSAZR0130P", "MSAZR0111P",
     "MSAZR0144P", "MSAZR0149P", "MSMCAZR0044P", "MSMCAZR0059P", "MSMCAZR0060P", "MSMCAZR0063P",
     "MSMCAZR0120P", "MSMCAZR0121P", "MSMCAZR0125P", "MSMCAZR0128P", "MSAZRDE0003P", "MSAZRDE0044P",
     "MSAZRUSGOV0003P", "EA", "MSAZR0243P", "SavingsPlan1Year", and "SavingsPlan3Year".
    :vartype azure_offer_code: str or ~azure.mgmt.migrationassessment.models.AzureOfferCode
    :ivar currency: Currency in which prices should be reported. Known values are: "Unknown",
     "USD", "DKK", "CAD", "IDR", "JPY", "KRW", "NZD", "NOK", "RUB", "SAR", "ZAR", "SEK", "TRY",
     "GBP", "MXN", "MYR", "INR", "HKD", "BRL", "TWD", "EUR", "CHF", "ARS", "AUD", "CNY", and "TRY".
    :vartype currency: str or ~azure.mgmt.migrationassessment.models.AzureCurrency
    :ivar scaling_factor: Percentage of buffer that user wants on performance metrics when
     recommending
     Azure sizes.
    :vartype scaling_factor: float
    :ivar percentile: Percentile of the utilization data values to be considered while assessing
     machines. Known values are: "Percentile50", "Percentile90", "Percentile95", and
     "Percentile99".
    :vartype percentile: str or ~azure.mgmt.migrationassessment.models.Percentile
    :ivar time_range: Time Range for which the historic utilization data should be considered for
     assessment. Known values are: "Day", "Week", "Month", and "Custom".
    :vartype time_range: str or ~azure.mgmt.migrationassessment.models.TimeRange
    :ivar perf_data_start_time: Gets or sets the start time to consider performance data for
     assessment.
    :vartype perf_data_start_time: ~datetime.datetime
    :ivar perf_data_end_time: Gets or sets the end time to consider performance data for
     assessment.
    :vartype perf_data_end_time: ~datetime.datetime
    :ivar stage: User configurable setting to display the Stage of Assessment. Known values are:
     "InProgress", "UnderReview", and "Approved".
    :vartype stage: str or ~azure.mgmt.migrationassessment.models.AssessmentStage
    :ivar discount_percentage: Custom discount percentage.
    :vartype discount_percentage: float
    :ivar sizing_criterion: Assessment sizing criterion. Known values are: "PerformanceBased" and
     "AsOnPremises".
    :vartype sizing_criterion: str or
     ~azure.mgmt.migrationassessment.models.AssessmentSizingCriterion
    :ivar confidence_rating_in_percentage: Confidence Rating in Percentage.
    :vartype confidence_rating_in_percentage: float
    :ivar prices_timestamp: Last time when rates were queried.
    :vartype prices_timestamp: ~datetime.datetime
    :ivar created_timestamp: Date and Time when assessment was created.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: Date and Time when assessment was last updated.
    :vartype updated_timestamp: ~datetime.datetime
    :ivar status: Whether assessment is in valid state and all machines have been assessed. Known
     values are: "Created", "Updated", "Running", "Completed", "Invalid", "OutOfSync", "OutDated",
     and "Deleted".
    :vartype status: str or ~azure.mgmt.migrationassessment.models.AssessmentStatus
    :ivar schema_version: Schema version.
    :vartype schema_version: str
    """

    _validation = {
        "assessment_error_summary": {"readonly": True},
        "monthly_ultra_storage_cost": {"readonly": True},
        "cost_components": {"readonly": True},
        "distribution_by_support_status": {"readonly": True},
        "distribution_by_service_pack_insight": {"readonly": True},
        "distribution_by_os_name": {"readonly": True},
        "monthly_compute_cost": {"readonly": True},
        "monthly_bandwidth_cost": {"readonly": True},
        "monthly_storage_cost": {"readonly": True},
        "monthly_premium_storage_cost": {"readonly": True},
        "monthly_standard_ssd_storage_cost": {"readonly": True},
        "suitability_summary": {"readonly": True},
        "number_of_machines": {"readonly": True},
        "group_type": {"readonly": True},
        "assessment_type": {"readonly": True},
        "stage": {"readonly": True},
        "confidence_rating_in_percentage": {"readonly": True},
        "prices_timestamp": {"readonly": True},
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
        "status": {"readonly": True},
        "schema_version": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "assessment_error_summary": {"key": "assessmentErrorSummary", "type": "{int}"},
        "monthly_ultra_storage_cost": {"key": "monthlyUltraStorageCost", "type": "float"},
        "cost_components": {"key": "costComponents", "type": "[CostComponent]"},
        "ea_subscription_id": {"key": "eaSubscriptionId", "type": "str"},
        "azure_pricing_tier": {"key": "azurePricingTier", "type": "str"},
        "azure_storage_redundancy": {"key": "azureStorageRedundancy", "type": "str"},
        "reserved_instance": {"key": "reservedInstance", "type": "str"},
        "azure_hybrid_use_benefit": {"key": "azureHybridUseBenefit", "type": "str"},
        "azure_disk_types": {"key": "azureDiskTypes", "type": "[str]"},
        "azure_vm_families": {"key": "azureVmFamilies", "type": "[str]"},
        "distribution_by_support_status": {"key": "distributionBySupportStatus", "type": "{int}"},
        "distribution_by_service_pack_insight": {"key": "distributionByServicePackInsight", "type": "{int}"},
        "distribution_by_os_name": {"key": "distributionByOsName", "type": "{int}"},
        "monthly_compute_cost": {"key": "monthlyComputeCost", "type": "float"},
        "monthly_bandwidth_cost": {"key": "monthlyBandwidthCost", "type": "float"},
        "monthly_storage_cost": {"key": "monthlyStorageCost", "type": "float"},
        "monthly_premium_storage_cost": {"key": "monthlyPremiumStorageCost", "type": "float"},
        "monthly_standard_ssd_storage_cost": {"key": "monthlyStandardSsdStorageCost", "type": "float"},
        "suitability_summary": {"key": "suitabilitySummary", "type": "{int}"},
        "number_of_machines": {"key": "numberOfMachines", "type": "int"},
        "vm_uptime": {"key": "vmUptime", "type": "VmUptime"},
        "group_type": {"key": "groupType", "type": "str"},
        "assessment_type": {"key": "assessmentType", "type": "str"},
        "azure_location": {"key": "azureLocation", "type": "str"},
        "azure_offer_code": {"key": "azureOfferCode", "type": "str"},
        "currency": {"key": "currency", "type": "str"},
        "scaling_factor": {"key": "scalingFactor", "type": "float"},
        "percentile": {"key": "percentile", "type": "str"},
        "time_range": {"key": "timeRange", "type": "str"},
        "perf_data_start_time": {"key": "perfDataStartTime", "type": "iso-8601"},
        "perf_data_end_time": {"key": "perfDataEndTime", "type": "iso-8601"},
        "stage": {"key": "stage", "type": "str"},
        "discount_percentage": {"key": "discountPercentage", "type": "float"},
        "sizing_criterion": {"key": "sizingCriterion", "type": "str"},
        "confidence_rating_in_percentage": {"key": "confidenceRatingInPercentage", "type": "float"},
        "prices_timestamp": {"key": "pricesTimestamp", "type": "iso-8601"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "schema_version": {"key": "schemaVersion", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        ea_subscription_id: Optional[str] = None,
        azure_pricing_tier: Optional[Union[str, "_models.AzurePricingTier"]] = None,
        azure_storage_redundancy: Optional[Union[str, "_models.AzureStorageRedundancy"]] = None,
        reserved_instance: Optional[Union[str, "_models.AzureReservedInstance"]] = None,
        azure_hybrid_use_benefit: Optional[Union[str, "_models.AzureHybridUseBenefit"]] = None,
        azure_disk_types: Optional[List[Union[str, "_models.AzureDiskType"]]] = None,
        azure_vm_families: Optional[List[Union[str, "_models.AzureVmFamily"]]] = None,
        vm_uptime: Optional["_models.VmUptime"] = None,
        azure_location: Optional[str] = None,
        azure_offer_code: Optional[Union[str, "_models.AzureOfferCode"]] = None,
        currency: Optional[Union[str, "_models.AzureCurrency"]] = None,
        scaling_factor: Optional[float] = None,
        percentile: Optional[Union[str, "_models.Percentile"]] = None,
        time_range: Optional[Union[str, "_models.TimeRange"]] = None,
        perf_data_start_time: Optional[datetime.datetime] = None,
        perf_data_end_time: Optional[datetime.datetime] = None,
        discount_percentage: Optional[float] = None,
        sizing_criterion: Optional[Union[str, "_models.AssessmentSizingCriterion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The status of the last operation. Known values are: "Succeeded",
         "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
        :paramtype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
        :keyword ea_subscription_id: Gets or sets enterprise agreement subscription id.
        :paramtype ea_subscription_id: str
        :keyword azure_pricing_tier: Gets or sets Azure Pricing Tier - Free, Basic, etc. Known values
         are: "Standard" and "Basic".
        :paramtype azure_pricing_tier: str or ~azure.mgmt.migrationassessment.models.AzurePricingTier
        :keyword azure_storage_redundancy: Gets or sets the Azure Storage Redundancy. Example: Locally
         Redundant Storage. Known values are: "Unknown", "LocallyRedundant", "ZoneRedundant",
         "GeoRedundant", and "ReadAccessGeoRedundant".
        :paramtype azure_storage_redundancy: str or
         ~azure.mgmt.migrationassessment.models.AzureStorageRedundancy
        :keyword reserved_instance: Gets or sets the Azure Reserved Instance - 1-Year, 3-Year. Known
         values are: "None", "RI1Year", and "RI3Year".
        :paramtype reserved_instance: str or
         ~azure.mgmt.migrationassessment.models.AzureReservedInstance
        :keyword azure_hybrid_use_benefit: Gets or sets the user configurable setting to display the
         azure hybrid use
         benefit. Known values are: "Unknown", "Yes", and "No".
        :paramtype azure_hybrid_use_benefit: str or
         ~azure.mgmt.migrationassessment.models.AzureHybridUseBenefit
        :keyword azure_disk_types: Gets or sets the azure storage type. Premium, Standard etc.
        :paramtype azure_disk_types: list[str or ~azure.mgmt.migrationassessment.models.AzureDiskType]
        :keyword azure_vm_families: Gets or sets the Azure VM families.
        :paramtype azure_vm_families: list[str or ~azure.mgmt.migrationassessment.models.AzureVmFamily]
        :keyword vm_uptime: Gets or sets the duration for which the VMs are up in the on-premises
         environment.
        :paramtype vm_uptime: ~azure.mgmt.migrationassessment.models.VmUptime
        :keyword azure_location: Azure Location or Azure region where to which the machines will be
         migrated.
        :paramtype azure_location: str
        :keyword azure_offer_code: Azure Offer Code. Known values are: "Unknown", "MSAZR0003P",
         "MSAZR0044P", "MSAZR0059P", "MSAZR0060P", "MSAZR0062P", "MSAZR0063P", "MSAZR0064P",
         "MSAZR0029P", "MSAZR0022P", "MSAZR0023P", "MSAZR0148P", "MSAZR0025P", "MSAZR0036P",
         "MSAZR0120P", "MSAZR0121P", "MSAZR0122P", "MSAZR0123P", "MSAZR0124P", "MSAZR0125P",
         "MSAZR0126P", "MSAZR0127P", "MSAZR0128P", "MSAZR0129P", "MSAZR0130P", "MSAZR0111P",
         "MSAZR0144P", "MSAZR0149P", "MSMCAZR0044P", "MSMCAZR0059P", "MSMCAZR0060P", "MSMCAZR0063P",
         "MSMCAZR0120P", "MSMCAZR0121P", "MSMCAZR0125P", "MSMCAZR0128P", "MSAZRDE0003P", "MSAZRDE0044P",
         "MSAZRUSGOV0003P", "EA", "MSAZR0243P", "SavingsPlan1Year", and "SavingsPlan3Year".
        :paramtype azure_offer_code: str or ~azure.mgmt.migrationassessment.models.AzureOfferCode
        :keyword currency: Currency in which prices should be reported. Known values are: "Unknown",
         "USD", "DKK", "CAD", "IDR", "JPY", "KRW", "NZD", "NOK", "RUB", "SAR", "ZAR", "SEK", "TRY",
         "GBP", "MXN", "MYR", "INR", "HKD", "BRL", "TWD", "EUR", "CHF", "ARS", "AUD", "CNY", and "TRY".
        :paramtype currency: str or ~azure.mgmt.migrationassessment.models.AzureCurrency
        :keyword scaling_factor: Percentage of buffer that user wants on performance metrics when
         recommending
         Azure sizes.
        :paramtype scaling_factor: float
        :keyword percentile: Percentile of the utilization data values to be considered while assessing
         machines. Known values are: "Percentile50", "Percentile90", "Percentile95", and
         "Percentile99".
        :paramtype percentile: str or ~azure.mgmt.migrationassessment.models.Percentile
        :keyword time_range: Time Range for which the historic utilization data should be considered
         for
         assessment. Known values are: "Day", "Week", "Month", and "Custom".
        :paramtype time_range: str or ~azure.mgmt.migrationassessment.models.TimeRange
        :keyword perf_data_start_time: Gets or sets the start time to consider performance data for
         assessment.
        :paramtype perf_data_start_time: ~datetime.datetime
        :keyword perf_data_end_time: Gets or sets the end time to consider performance data for
         assessment.
        :paramtype perf_data_end_time: ~datetime.datetime
        :keyword discount_percentage: Custom discount percentage.
        :paramtype discount_percentage: float
        :keyword sizing_criterion: Assessment sizing criterion. Known values are: "PerformanceBased"
         and "AsOnPremises".
        :paramtype sizing_criterion: str or
         ~azure.mgmt.migrationassessment.models.AssessmentSizingCriterion
        """
        super().__init__(provisioning_state=provisioning_state, **kwargs)
        self.assessment_error_summary = None
        self.monthly_ultra_storage_cost = None
        self.cost_components = None
        self.ea_subscription_id = ea_subscription_id
        self.azure_pricing_tier = azure_pricing_tier
        self.azure_storage_redundancy = azure_storage_redundancy
        self.reserved_instance = reserved_instance
        self.azure_hybrid_use_benefit = azure_hybrid_use_benefit
        self.azure_disk_types = azure_disk_types
        self.azure_vm_families = azure_vm_families
        self.distribution_by_support_status = None
        self.distribution_by_service_pack_insight = None
        self.distribution_by_os_name = None
        self.monthly_compute_cost = None
        self.monthly_bandwidth_cost = None
        self.monthly_storage_cost = None
        self.monthly_premium_storage_cost = None
        self.monthly_standard_ssd_storage_cost = None
        self.suitability_summary = None
        self.number_of_machines = None
        self.vm_uptime = vm_uptime
        self.group_type = None
        self.assessment_type = None
        self.azure_location = azure_location
        self.azure_offer_code = azure_offer_code
        self.currency = currency
        self.scaling_factor = scaling_factor
        self.percentile = percentile
        self.time_range = time_range
        self.perf_data_start_time = perf_data_start_time
        self.perf_data_end_time = perf_data_end_time
        self.stage = None
        self.discount_percentage = discount_percentage
        self.sizing_criterion = sizing_criterion
        self.confidence_rating_in_percentage = None
        self.prices_timestamp = None
        self.created_timestamp = None
        self.updated_timestamp = None
        self.status = None
        self.schema_version = None


class MachineListResult(_serialization.Model):
    """The response of a Machine list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The Machine items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.Machine]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Machine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Machine"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The Machine items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.Machine]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MachineProperties(_serialization.Model):
    """Properties of a machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar workload_summary: Gets or sets workload summary.
    :vartype workload_summary: ~azure.mgmt.migrationassessment.models.WorkloadSummary
    :ivar errors: List of errors for this machine.
    :vartype errors: list[~azure.mgmt.migrationassessment.models.Error]
    :ivar host_processor: Gets Processor details of the host.
    :vartype host_processor: ~azure.mgmt.migrationassessment.models.ProcessorInfo
    :ivar product_support_status: Gets the product support status related details.
    :vartype product_support_status: ~azure.mgmt.migrationassessment.models.ProductSupportStatus
    :ivar discovery_machine_arm_id: Site id of machine discovered in private data center.
    :vartype discovery_machine_arm_id: str
    :ivar datacenter_management_server_arm_id: The data center management server ARM Id for the
     machine.
    :vartype datacenter_management_server_arm_id: str
    :ivar datacenter_management_server_name: The data center management server name for the
     machine.
    :vartype datacenter_management_server_name: str
    :ivar boot_type: Boot type of machine discovered in private data center. Known values are:
     "Unknown", "EFI", "BIOS", and "NotSpecified".
    :vartype boot_type: str or ~azure.mgmt.migrationassessment.models.MachineBootType
    :ivar display_name: Display Name of the Machine.
    :vartype display_name: str
    :ivar megabytes_of_memory: Megabytes of memory found allocated for the machine in private data
     center.
    :vartype megabytes_of_memory: float
    :ivar number_of_cores: Number of CPU cores found on the machine.
    :vartype number_of_cores: int
    :ivar operating_system_type: Operating system as reported by datacenter management solution.
    :vartype operating_system_type: str
    :ivar operating_system_name: Operating system as reported by datacenter management solution.
    :vartype operating_system_name: str
    :ivar operating_system_version: Operating system version as reported by datacenter management
     solution.
    :vartype operating_system_version: str
    :ivar description: Description for the machine.
    :vartype description: str
    :ivar created_timestamp: When was machine first created.
    :vartype created_timestamp: ~datetime.datetime
    :ivar disks: Disks attached to the machine discovered in private data center.
    :vartype disks: dict[str, ~azure.mgmt.migrationassessment.models.Disk]
    :ivar groups: Gets the References to the groups that this machine is member of.
    :vartype groups: list[str]
    :ivar network_adapters: Network adapters attached to the machine discovered in private data
     center.
    :vartype network_adapters: dict[str, ~azure.mgmt.migrationassessment.models.NetworkAdapter]
    :ivar sql_instances: SQL instances discovered on the machine.
    :vartype sql_instances: list[str]
    :ivar web_applications: Web applications discovered on the machine.
    :vartype web_applications: list[str]
    :ivar updated_timestamp: When was machine last updated.
    :vartype updated_timestamp: ~datetime.datetime
    """

    _validation = {
        "workload_summary": {"readonly": True},
        "errors": {"readonly": True},
        "host_processor": {"readonly": True},
        "product_support_status": {"readonly": True},
        "discovery_machine_arm_id": {"readonly": True},
        "datacenter_management_server_arm_id": {"readonly": True},
        "datacenter_management_server_name": {"readonly": True},
        "boot_type": {"readonly": True},
        "display_name": {"readonly": True},
        "megabytes_of_memory": {"readonly": True},
        "number_of_cores": {"readonly": True},
        "operating_system_type": {"readonly": True},
        "operating_system_name": {"readonly": True},
        "operating_system_version": {"readonly": True},
        "description": {"readonly": True},
        "created_timestamp": {"readonly": True},
        "disks": {"readonly": True},
        "groups": {"readonly": True},
        "network_adapters": {"readonly": True},
        "sql_instances": {"readonly": True},
        "web_applications": {"readonly": True},
        "updated_timestamp": {"readonly": True},
    }

    _attribute_map = {
        "workload_summary": {"key": "workloadSummary", "type": "WorkloadSummary"},
        "errors": {"key": "errors", "type": "[Error]"},
        "host_processor": {"key": "hostProcessor", "type": "ProcessorInfo"},
        "product_support_status": {"key": "productSupportStatus", "type": "ProductSupportStatus"},
        "discovery_machine_arm_id": {"key": "discoveryMachineArmId", "type": "str"},
        "datacenter_management_server_arm_id": {"key": "datacenterManagementServerArmId", "type": "str"},
        "datacenter_management_server_name": {"key": "datacenterManagementServerName", "type": "str"},
        "boot_type": {"key": "bootType", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "megabytes_of_memory": {"key": "megabytesOfMemory", "type": "float"},
        "number_of_cores": {"key": "numberOfCores", "type": "int"},
        "operating_system_type": {"key": "operatingSystemType", "type": "str"},
        "operating_system_name": {"key": "operatingSystemName", "type": "str"},
        "operating_system_version": {"key": "operatingSystemVersion", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "disks": {"key": "disks", "type": "{Disk}"},
        "groups": {"key": "groups", "type": "[str]"},
        "network_adapters": {"key": "networkAdapters", "type": "{NetworkAdapter}"},
        "sql_instances": {"key": "sqlInstances", "type": "[str]"},
        "web_applications": {"key": "webApplications", "type": "[str]"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.workload_summary = None
        self.errors = None
        self.host_processor = None
        self.product_support_status = None
        self.discovery_machine_arm_id = None
        self.datacenter_management_server_arm_id = None
        self.datacenter_management_server_name = None
        self.boot_type = None
        self.display_name = None
        self.megabytes_of_memory = None
        self.number_of_cores = None
        self.operating_system_type = None
        self.operating_system_name = None
        self.operating_system_version = None
        self.description = None
        self.created_timestamp = None
        self.disks = None
        self.groups = None
        self.network_adapters = None
        self.sql_instances = None
        self.web_applications = None
        self.updated_timestamp = None


class MigrationGuidelineContext(_serialization.Model):
    """Migration Guideline Context.

    :ivar context_key: Gets the reasoning context key.
    :vartype context_key: str
    :ivar context_value: Gets the reasoning context value.
    :vartype context_value: str
    """

    _attribute_map = {
        "context_key": {"key": "contextKey", "type": "str"},
        "context_value": {"key": "contextValue", "type": "str"},
    }

    def __init__(
        self, *, context_key: Optional[str] = None, context_value: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword context_key: Gets the reasoning context key.
        :paramtype context_key: str
        :keyword context_value: Gets the reasoning context value.
        :paramtype context_value: str
        """
        super().__init__(**kwargs)
        self.context_key = context_key
        self.context_value = context_value


class NetworkAdapter(_serialization.Model):
    """A network adapter discovered on a machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mac_address: MAC Address of the network adapter.
    :vartype mac_address: str
    :ivar ip_addresses: List of IP Addresses on the network adapter.
    :vartype ip_addresses: list[str]
    :ivar display_name: User friendly name of the network adapter.
    :vartype display_name: str
    """

    _validation = {
        "mac_address": {"readonly": True},
        "ip_addresses": {"readonly": True},
        "display_name": {"readonly": True},
    }

    _attribute_map = {
        "mac_address": {"key": "macAddress", "type": "str"},
        "ip_addresses": {"key": "ipAddresses", "type": "[str]"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.mac_address = None
        self.ip_addresses = None
        self.display_name = None


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.migrationassessment.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.migrationassessment.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.migrationassessment.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.migrationassessment.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.migrationassessment.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpoint(_serialization.Model):
    """The private endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for private endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(ProxyResource):
    """Private endpoint connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.PrivateEndpointConnectionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PrivateEndpointConnectionProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.PrivateEndpointConnectionProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties:
         ~azure.mgmt.migrationassessment.models.PrivateEndpointConnectionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PrivateEndpointConnectionListResult(_serialization.Model):
    """The response of a PrivateEndpointConnection list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The PrivateEndpointConnection items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.PrivateEndpointConnection]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.PrivateEndpointConnection"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The PrivateEndpointConnection items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.PrivateEndpointConnection]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateEndpointConnectionProperties(_serialization.Model):
    """Properties of the private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar group_ids: The group ids for the private endpoint resource.
    :vartype group_ids: list[str]
    :ivar private_endpoint: The private endpoint resource.
    :vartype private_endpoint: ~azure.mgmt.migrationassessment.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider. Required.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.migrationassessment.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.migrationassessment.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "group_ids": {"readonly": True},
        "private_link_service_connection_state": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "group_ids": {"key": "groupIds", "type": "[str]"},
        "private_endpoint": {"key": "privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_link_service_connection_state: "_models.PrivateLinkServiceConnectionState",
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The private endpoint resource.
        :paramtype private_endpoint: ~azure.mgmt.migrationassessment.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider. Required.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.migrationassessment.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.group_ids = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateLinkResource(ProxyResource):
    """Private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.PrivateLinkResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PrivateLinkResourceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.PrivateLinkResourceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.PrivateLinkResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PrivateLinkResourceListResult(_serialization.Model):
    """The response of a PrivateLinkResource list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The PrivateLinkResource items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.PrivateLinkResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.PrivateLinkResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The PrivateLinkResource items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.PrivateLinkResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResourceProperties(_serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: The private link resource private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or
     ~azure.mgmt.migrationassessment.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or
         ~azure.mgmt.migrationassessment.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ProcessorInfo(_serialization.Model):
    """Represents a information details of a processor.

    :ivar name: Gets or sets the name model of a processor.
    :vartype name: str
    :ivar number_of_sockets: Gets or sets the number of sockets.
    :vartype number_of_sockets: int
    :ivar number_of_cores_per_socket: Gets or sets the number of cores in a socket.
    :vartype number_of_cores_per_socket: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "number_of_sockets": {"key": "numberOfSockets", "type": "int"},
        "number_of_cores_per_socket": {"key": "numberOfCoresPerSocket", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        number_of_sockets: Optional[int] = None,
        number_of_cores_per_socket: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Gets or sets the name model of a processor.
        :paramtype name: str
        :keyword number_of_sockets: Gets or sets the number of sockets.
        :paramtype number_of_sockets: int
        :keyword number_of_cores_per_socket: Gets or sets the number of cores in a socket.
        :paramtype number_of_cores_per_socket: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.number_of_sockets = number_of_sockets
        self.number_of_cores_per_socket = number_of_cores_per_socket


class ProductSupportStatus(_serialization.Model):
    """Class to represent the Product Support Status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar current_version: Gets or sets current version of ServicePack.
    :vartype current_version: str
    :ivar service_pack_status: Gets or sets ServicePack of the product.
    :vartype service_pack_status: str
    :ivar esu_status: Gets or sets the Extended Security Update ESU status.
    :vartype esu_status: str
    :ivar support_status: Gets or sets the support status of the product.
    :vartype support_status: str
    :ivar eta: Gets or sets the ETA.
    :vartype eta: int
    :ivar current_esu_year: Gets or sets the current ESU support year.
    :vartype current_esu_year: str
    :ivar mainstream_end_date: Gets or sets the main stream end date of the product.
    :vartype mainstream_end_date: ~datetime.datetime
    :ivar extended_support_end_date: Gets or sets the extended support end date of the product.
    :vartype extended_support_end_date: ~datetime.datetime
    :ivar extended_security_update_year1_end_date: Gets or sets the extended security update year 1
     end date of the product.
    :vartype extended_security_update_year1_end_date: ~datetime.datetime
    :ivar extended_security_update_year2_end_date: Gets or sets the extended security update year 2
     end date of the product.
    :vartype extended_security_update_year2_end_date: ~datetime.datetime
    :ivar extended_security_update_year3_end_date: Gets or sets the extended security update year 3
     end date of the product.
    :vartype extended_security_update_year3_end_date: ~datetime.datetime
    """

    _validation = {
        "current_version": {"readonly": True},
        "service_pack_status": {"readonly": True},
        "esu_status": {"readonly": True},
        "support_status": {"readonly": True},
        "eta": {"readonly": True},
        "current_esu_year": {"readonly": True},
        "mainstream_end_date": {"readonly": True},
        "extended_support_end_date": {"readonly": True},
        "extended_security_update_year1_end_date": {"readonly": True},
        "extended_security_update_year2_end_date": {"readonly": True},
        "extended_security_update_year3_end_date": {"readonly": True},
    }

    _attribute_map = {
        "current_version": {"key": "currentVersion", "type": "str"},
        "service_pack_status": {"key": "servicePackStatus", "type": "str"},
        "esu_status": {"key": "esuStatus", "type": "str"},
        "support_status": {"key": "supportStatus", "type": "str"},
        "eta": {"key": "eta", "type": "int"},
        "current_esu_year": {"key": "currentEsuYear", "type": "str"},
        "mainstream_end_date": {"key": "mainstreamEndDate", "type": "iso-8601"},
        "extended_support_end_date": {"key": "extendedSupportEndDate", "type": "iso-8601"},
        "extended_security_update_year1_end_date": {"key": "extendedSecurityUpdateYear1EndDate", "type": "iso-8601"},
        "extended_security_update_year2_end_date": {"key": "extendedSecurityUpdateYear2EndDate", "type": "iso-8601"},
        "extended_security_update_year3_end_date": {"key": "extendedSecurityUpdateYear3EndDate", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.current_version = None
        self.service_pack_status = None
        self.esu_status = None
        self.support_status = None
        self.eta = None
        self.current_esu_year = None
        self.mainstream_end_date = None
        self.extended_support_end_date = None
        self.extended_security_update_year1_end_date = None
        self.extended_security_update_year2_end_date = None
        self.extended_security_update_year3_end_date = None


class ProjectProperties(AzureResourceProperties):
    """Properties of a project.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
    :ivar created_timestamp: Time when this project was created. Date-Time represented in ISO-8601
     format.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: Time when this project was last updated. Date-Time represented in
     ISO-8601
     format.
    :vartype updated_timestamp: ~datetime.datetime
    :ivar service_endpoint: Endpoint at which the collector agent can call agent REST API.
    :vartype service_endpoint: str
    :ivar assessment_solution_id: Assessment solution ARM id tracked by
     Microsoft.Migrate/migrateProjects.
    :vartype assessment_solution_id: str
    :ivar project_status: Assessment project status. Known values are: "Active" and "Inactive".
    :vartype project_status: str or ~azure.mgmt.migrationassessment.models.ProjectStatus
    :ivar customer_workspace_id: The ARM id of service map workspace created by customer.
    :vartype customer_workspace_id: str
    :ivar customer_workspace_location: Location of service map workspace created by customer.
    :vartype customer_workspace_location: str
    :ivar public_network_access: This value can be set to 'enabled' to avoid breaking changes on
     existing
     customer resources and templates. If set to 'disabled', traffic over public
     interface is not allowed, and private endpoint connections would be the
     exclusive access method.
    :vartype public_network_access: str
    :ivar private_endpoint_connections: The list of private endpoint connections to the project.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.migrationassessment.models.PrivateEndpointConnection]
    :ivar customer_storage_account_arm_id: The ARM id of the storage account used for interactions
     when public access is
     disabled.
    :vartype customer_storage_account_arm_id: str
    """

    _validation = {
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
        "service_endpoint": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
        "service_endpoint": {"key": "serviceEndpoint", "type": "str"},
        "assessment_solution_id": {"key": "assessmentSolutionId", "type": "str"},
        "project_status": {"key": "projectStatus", "type": "str"},
        "customer_workspace_id": {"key": "customerWorkspaceId", "type": "str"},
        "customer_workspace_location": {"key": "customerWorkspaceLocation", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "private_endpoint_connections": {"key": "privateEndpointConnections", "type": "[PrivateEndpointConnection]"},
        "customer_storage_account_arm_id": {"key": "customerStorageAccountArmId", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        assessment_solution_id: Optional[str] = None,
        project_status: Optional[Union[str, "_models.ProjectStatus"]] = None,
        customer_workspace_id: Optional[str] = None,
        customer_workspace_location: Optional[str] = None,
        public_network_access: Optional[str] = None,
        customer_storage_account_arm_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The status of the last operation. Known values are: "Succeeded",
         "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
        :paramtype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
        :keyword assessment_solution_id: Assessment solution ARM id tracked by
         Microsoft.Migrate/migrateProjects.
        :paramtype assessment_solution_id: str
        :keyword project_status: Assessment project status. Known values are: "Active" and "Inactive".
        :paramtype project_status: str or ~azure.mgmt.migrationassessment.models.ProjectStatus
        :keyword customer_workspace_id: The ARM id of service map workspace created by customer.
        :paramtype customer_workspace_id: str
        :keyword customer_workspace_location: Location of service map workspace created by customer.
        :paramtype customer_workspace_location: str
        :keyword public_network_access: This value can be set to 'enabled' to avoid breaking changes on
         existing
         customer resources and templates. If set to 'disabled', traffic over public
         interface is not allowed, and private endpoint connections would be the
         exclusive access method.
        :paramtype public_network_access: str
        :keyword customer_storage_account_arm_id: The ARM id of the storage account used for
         interactions when public access is
         disabled.
        :paramtype customer_storage_account_arm_id: str
        """
        super().__init__(provisioning_state=provisioning_state, **kwargs)
        self.created_timestamp = None
        self.updated_timestamp = None
        self.service_endpoint = None
        self.assessment_solution_id = assessment_solution_id
        self.project_status = project_status
        self.customer_workspace_id = customer_workspace_id
        self.customer_workspace_location = customer_workspace_location
        self.public_network_access = public_network_access
        self.private_endpoint_connections = None
        self.customer_storage_account_arm_id = customer_storage_account_arm_id


class ResourceId(_serialization.Model):
    """ARM id for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Gets the relative URL to get to this REST resource.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class ServerCollector(ProxyResource):
    """Physical server collector resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.CollectorPropertiesBaseWithAgent
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "CollectorPropertiesBaseWithAgent"},
    }

    def __init__(
        self, *, properties: Optional["_models.CollectorPropertiesBaseWithAgent"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.CollectorPropertiesBaseWithAgent
        """
        super().__init__(**kwargs)
        self.properties = properties


class ServerCollectorListResult(_serialization.Model):
    """The response of a ServerCollector list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The ServerCollector items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.ServerCollector]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerCollector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.ServerCollector"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The ServerCollector items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.ServerCollector]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SharedResourcesDTO(_serialization.Model):
    """Shared Resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar shared_data_disks: Gets the list of shared data disks.
    :vartype shared_data_disks: list[~azure.mgmt.migrationassessment.models.AzureManagedDiskSkuDTO]
    :ivar shared_log_disks: Gets the list of shared log disks.
    :vartype shared_log_disks: list[~azure.mgmt.migrationassessment.models.AzureManagedDiskSkuDTO]
    :ivar shared_temp_db_disks: Gets the list of shared Temporary database disks.
    :vartype shared_temp_db_disks:
     list[~azure.mgmt.migrationassessment.models.AzureManagedDiskSkuDTO]
    :ivar number_of_mounts: Gets number of mounts of shared disks.
    :vartype number_of_mounts: int
    :ivar quorum_witness: Gets quorum witness.
    :vartype quorum_witness: ~azure.mgmt.migrationassessment.models.AzureQuorumWitnessDTO
    """

    _validation = {
        "shared_data_disks": {"readonly": True},
        "shared_log_disks": {"readonly": True},
        "shared_temp_db_disks": {"readonly": True},
        "number_of_mounts": {"readonly": True},
        "quorum_witness": {"readonly": True},
    }

    _attribute_map = {
        "shared_data_disks": {"key": "sharedDataDisks", "type": "[AzureManagedDiskSkuDTO]"},
        "shared_log_disks": {"key": "sharedLogDisks", "type": "[AzureManagedDiskSkuDTO]"},
        "shared_temp_db_disks": {"key": "sharedTempDbDisks", "type": "[AzureManagedDiskSkuDTO]"},
        "number_of_mounts": {"key": "numberOfMounts", "type": "int"},
        "quorum_witness": {"key": "quorumWitness", "type": "AzureQuorumWitnessDTO"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.shared_data_disks = None
        self.shared_log_disks = None
        self.shared_temp_db_disks = None
        self.number_of_mounts = None
        self.quorum_witness = None


class SqlAssessedNetworkAdapter(_serialization.Model):
    """SQL Assessed Network Adapter.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar suitability: Gets the suitability. Known values are: "Unknown", "NotSuitable",
     "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
    :vartype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
    :ivar suitability_detail: Gets the suitability detail. Known values are: "None",
     "MegabytesOfDataTransmittedMissing", "MegabytesOfDataTransmittedOutOfRange",
     "MegabytesOfDataRecievedMissing", and "MegabytesOfDataRecievedOutOfRange".
    :vartype suitability_detail: str or
     ~azure.mgmt.migrationassessment.models.AzureNetworkAdapterSuitabilityDetail
    :ivar suitability_explanation: Gets the suitability explanation. Known values are: "Unknown",
     "NotApplicable", and "InternalErrorOccurred".
    :vartype suitability_explanation: str or
     ~azure.mgmt.migrationassessment.models.AzureNetworkAdapterSuitabilityExplanation
    :ivar monthly_bandwidth_costs: Gets the monthly bandwidth costs.
    :vartype monthly_bandwidth_costs: float
    :ivar net_gigabytes_transmitted_per_month: Gets the net gigabytes transmitted per month.
    :vartype net_gigabytes_transmitted_per_month: float
    :ivar name: Gets the name.
    :vartype name: str
    :ivar display_name: Gets the display name.
    :vartype display_name: str
    :ivar mac_address: Gets the mac address.
    :vartype mac_address: str
    :ivar ip_addresses: Gets the ip addresses.
    :vartype ip_addresses: list[str]
    :ivar megabytes_per_second_received: Gets the megabytes per second received.
    :vartype megabytes_per_second_received: float
    :ivar megabytes_per_second_transmitted: Gets the megabytes per second transmitted.
    :vartype megabytes_per_second_transmitted: float
    """

    _validation = {
        "ip_addresses": {"readonly": True},
    }

    _attribute_map = {
        "suitability": {"key": "suitability", "type": "str"},
        "suitability_detail": {"key": "suitabilityDetail", "type": "str"},
        "suitability_explanation": {"key": "suitabilityExplanation", "type": "str"},
        "monthly_bandwidth_costs": {"key": "monthlyBandwidthCosts", "type": "float"},
        "net_gigabytes_transmitted_per_month": {"key": "netGigabytesTransmittedPerMonth", "type": "float"},
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "ip_addresses": {"key": "ipAddresses", "type": "[str]"},
        "megabytes_per_second_received": {"key": "megabytesPerSecondReceived", "type": "float"},
        "megabytes_per_second_transmitted": {"key": "megabytesPerSecondTransmitted", "type": "float"},
    }

    def __init__(
        self,
        *,
        suitability: Optional[Union[str, "_models.CloudSuitability"]] = None,
        suitability_detail: Optional[Union[str, "_models.AzureNetworkAdapterSuitabilityDetail"]] = None,
        suitability_explanation: Optional[Union[str, "_models.AzureNetworkAdapterSuitabilityExplanation"]] = None,
        monthly_bandwidth_costs: Optional[float] = None,
        net_gigabytes_transmitted_per_month: Optional[float] = None,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        mac_address: Optional[str] = None,
        megabytes_per_second_received: Optional[float] = None,
        megabytes_per_second_transmitted: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword suitability: Gets the suitability. Known values are: "Unknown", "NotSuitable",
         "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
        :paramtype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
        :keyword suitability_detail: Gets the suitability detail. Known values are: "None",
         "MegabytesOfDataTransmittedMissing", "MegabytesOfDataTransmittedOutOfRange",
         "MegabytesOfDataRecievedMissing", and "MegabytesOfDataRecievedOutOfRange".
        :paramtype suitability_detail: str or
         ~azure.mgmt.migrationassessment.models.AzureNetworkAdapterSuitabilityDetail
        :keyword suitability_explanation: Gets the suitability explanation. Known values are:
         "Unknown", "NotApplicable", and "InternalErrorOccurred".
        :paramtype suitability_explanation: str or
         ~azure.mgmt.migrationassessment.models.AzureNetworkAdapterSuitabilityExplanation
        :keyword monthly_bandwidth_costs: Gets the monthly bandwidth costs.
        :paramtype monthly_bandwidth_costs: float
        :keyword net_gigabytes_transmitted_per_month: Gets the net gigabytes transmitted per month.
        :paramtype net_gigabytes_transmitted_per_month: float
        :keyword name: Gets the name.
        :paramtype name: str
        :keyword display_name: Gets the display name.
        :paramtype display_name: str
        :keyword mac_address: Gets the mac address.
        :paramtype mac_address: str
        :keyword megabytes_per_second_received: Gets the megabytes per second received.
        :paramtype megabytes_per_second_received: float
        :keyword megabytes_per_second_transmitted: Gets the megabytes per second transmitted.
        :paramtype megabytes_per_second_transmitted: float
        """
        super().__init__(**kwargs)
        self.suitability = suitability
        self.suitability_detail = suitability_detail
        self.suitability_explanation = suitability_explanation
        self.monthly_bandwidth_costs = monthly_bandwidth_costs
        self.net_gigabytes_transmitted_per_month = net_gigabytes_transmitted_per_month
        self.name = name
        self.display_name = display_name
        self.mac_address = mac_address
        self.ip_addresses = None
        self.megabytes_per_second_received = megabytes_per_second_received
        self.megabytes_per_second_transmitted = megabytes_per_second_transmitted


class SqlAssessmentMigrationIssue(_serialization.Model):
    """Class representing the SQL migration issues.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar issue_id: Gets the issue id.
    :vartype issue_id: str
    :ivar issue_category: Gets the issue category. Known values are: "Issue", "Warning", and
     "Internal".
    :vartype issue_category: str or
     ~azure.mgmt.migrationassessment.models.SqlAssessmentMigrationIssueCategory
    :ivar impacted_objects: Gets the list of impacted objects.
    :vartype impacted_objects:
     list[~azure.mgmt.migrationassessment.models.ImpactedAssessmentObject]
    """

    _validation = {
        "issue_id": {"readonly": True},
        "issue_category": {"readonly": True},
        "impacted_objects": {"readonly": True},
    }

    _attribute_map = {
        "issue_id": {"key": "issueId", "type": "str"},
        "issue_category": {"key": "issueCategory", "type": "str"},
        "impacted_objects": {"key": "impactedObjects", "type": "[ImpactedAssessmentObject]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.issue_id = None
        self.issue_category = None
        self.impacted_objects = None


class SqlAssessmentOptions(ProxyResource):
    """SQL Assessment options web model object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.SqlAssessmentOptionsProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SqlAssessmentOptionsProperties"},
    }

    def __init__(self, *, properties: Optional["_models.SqlAssessmentOptionsProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.SqlAssessmentOptionsProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class SqlAssessmentOptionsListResult(_serialization.Model):
    """The response of a SqlAssessmentOptions list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The SqlAssessmentOptions items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.SqlAssessmentOptions]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlAssessmentOptions]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.SqlAssessmentOptions"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The SqlAssessmentOptions items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.SqlAssessmentOptions]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SqlAssessmentOptionsProperties(_serialization.Model):
    """SQL Assessment options properties Web model object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vm_families: Gets the list of VM families.
    :vartype vm_families: list[~azure.mgmt.migrationassessment.models.VmFamilyOptions]
    :ivar reserved_instance_vm_families: Gets the Reserved Instance VM Families list.
    :vartype reserved_instance_vm_families: list[str or
     ~azure.mgmt.migrationassessment.models.AzureVmFamily]
    :ivar premium_disk_vm_families: Gets the Premium disk VM Families list.
    :vartype premium_disk_vm_families: list[str or
     ~azure.mgmt.migrationassessment.models.AzureVmFamily]
    :ivar savings_plan_vm_families: Gets or sets the Premium disk VM Families list.
    :vartype savings_plan_vm_families: list[str or
     ~azure.mgmt.migrationassessment.models.AzureVmFamily]
    :ivar savings_plan_supported_locations: Gets or sets the list of Azure locations supporting
     Saving Plans for IAAS.
    :vartype savings_plan_supported_locations: list[str or
     ~azure.mgmt.migrationassessment.models.AzureLocation]
    :ivar savings_plan_supported_locations_for_paas: Gets or sets the list of Azure locations
     supporting Saving Plans for PAAS.
    :vartype savings_plan_supported_locations_for_paas: list[str or
     ~azure.mgmt.migrationassessment.models.AzureLocation]
    :ivar reserved_instance_supported_locations_for_iaas: Gets or sets the list of Azure locations
     supporting Reserved Instances for IAAS.
    :vartype reserved_instance_supported_locations_for_iaas: list[str or
     ~azure.mgmt.migrationassessment.models.AzureLocation]
    :ivar savings_plan_supported_offers: Gets or sets the list of Azure Offers supporting Saving
     Plans.
    :vartype savings_plan_supported_offers: list[str or
     ~azure.mgmt.migrationassessment.models.AzureOfferCode]
    :ivar sql_skus: Gets or sets the list of SQL target SKU properties for dropdowns.
    :vartype sql_skus: list[~azure.mgmt.migrationassessment.models.SqlPaaSTargetOptions]
    :ivar reserved_instance_sql_targets: Gets or sets the Reserved Instance SQL target types.
    :vartype reserved_instance_sql_targets: list[str or
     ~azure.mgmt.migrationassessment.models.TargetType]
    :ivar reserved_instance_supported_locations: Gets or sets the list of Azure locations
     supporting Reserved Instances.
    :vartype reserved_instance_supported_locations: list[str or
     ~azure.mgmt.migrationassessment.models.AzureLocation]
    :ivar reserved_instance_supported_currencies: Gets or sets the list of currencies supported for
     Reserved Instances.
    :vartype reserved_instance_supported_currencies: list[str or
     ~azure.mgmt.migrationassessment.models.AzureCurrency]
    :ivar reserved_instance_supported_offers: Gets or sets the list of offers supported for
     Reserved Instances.
    :vartype reserved_instance_supported_offers: list[str or
     ~azure.mgmt.migrationassessment.models.AzureOfferCode]
    :ivar supported_offers: Gets or sets the list of offers supported for SQL assessments.
    :vartype supported_offers: list[str or ~azure.mgmt.migrationassessment.models.AzureOfferCode]
    """

    _validation = {
        "vm_families": {"readonly": True},
        "reserved_instance_vm_families": {"readonly": True},
        "premium_disk_vm_families": {"readonly": True},
    }

    _attribute_map = {
        "vm_families": {"key": "vmFamilies", "type": "[VmFamilyOptions]"},
        "reserved_instance_vm_families": {"key": "reservedInstanceVmFamilies", "type": "[str]"},
        "premium_disk_vm_families": {"key": "premiumDiskVmFamilies", "type": "[str]"},
        "savings_plan_vm_families": {"key": "savingsPlanVmFamilies", "type": "[str]"},
        "savings_plan_supported_locations": {"key": "savingsPlanSupportedLocations", "type": "[str]"},
        "savings_plan_supported_locations_for_paas": {"key": "savingsPlanSupportedLocationsForPaas", "type": "[str]"},
        "reserved_instance_supported_locations_for_iaas": {
            "key": "reservedInstanceSupportedLocationsForIaas",
            "type": "[str]",
        },
        "savings_plan_supported_offers": {"key": "savingsPlanSupportedOffers", "type": "[str]"},
        "sql_skus": {"key": "sqlSkus", "type": "[SqlPaaSTargetOptions]"},
        "reserved_instance_sql_targets": {"key": "reservedInstanceSqlTargets", "type": "[str]"},
        "reserved_instance_supported_locations": {"key": "reservedInstanceSupportedLocations", "type": "[str]"},
        "reserved_instance_supported_currencies": {"key": "reservedInstanceSupportedCurrencies", "type": "[str]"},
        "reserved_instance_supported_offers": {"key": "reservedInstanceSupportedOffers", "type": "[str]"},
        "supported_offers": {"key": "supportedOffers", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        savings_plan_vm_families: Optional[List[Union[str, "_models.AzureVmFamily"]]] = None,
        savings_plan_supported_locations: Optional[List[Union[str, "_models.AzureLocation"]]] = None,
        savings_plan_supported_locations_for_paas: Optional[List[Union[str, "_models.AzureLocation"]]] = None,
        reserved_instance_supported_locations_for_iaas: Optional[List[Union[str, "_models.AzureLocation"]]] = None,
        savings_plan_supported_offers: Optional[List[Union[str, "_models.AzureOfferCode"]]] = None,
        sql_skus: Optional[List["_models.SqlPaaSTargetOptions"]] = None,
        reserved_instance_sql_targets: Optional[List[Union[str, "_models.TargetType"]]] = None,
        reserved_instance_supported_locations: Optional[List[Union[str, "_models.AzureLocation"]]] = None,
        reserved_instance_supported_currencies: Optional[List[Union[str, "_models.AzureCurrency"]]] = None,
        reserved_instance_supported_offers: Optional[List[Union[str, "_models.AzureOfferCode"]]] = None,
        supported_offers: Optional[List[Union[str, "_models.AzureOfferCode"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword savings_plan_vm_families: Gets or sets the Premium disk VM Families list.
        :paramtype savings_plan_vm_families: list[str or
         ~azure.mgmt.migrationassessment.models.AzureVmFamily]
        :keyword savings_plan_supported_locations: Gets or sets the list of Azure locations supporting
         Saving Plans for IAAS.
        :paramtype savings_plan_supported_locations: list[str or
         ~azure.mgmt.migrationassessment.models.AzureLocation]
        :keyword savings_plan_supported_locations_for_paas: Gets or sets the list of Azure locations
         supporting Saving Plans for PAAS.
        :paramtype savings_plan_supported_locations_for_paas: list[str or
         ~azure.mgmt.migrationassessment.models.AzureLocation]
        :keyword reserved_instance_supported_locations_for_iaas: Gets or sets the list of Azure
         locations supporting Reserved Instances for IAAS.
        :paramtype reserved_instance_supported_locations_for_iaas: list[str or
         ~azure.mgmt.migrationassessment.models.AzureLocation]
        :keyword savings_plan_supported_offers: Gets or sets the list of Azure Offers supporting Saving
         Plans.
        :paramtype savings_plan_supported_offers: list[str or
         ~azure.mgmt.migrationassessment.models.AzureOfferCode]
        :keyword sql_skus: Gets or sets the list of SQL target SKU properties for dropdowns.
        :paramtype sql_skus: list[~azure.mgmt.migrationassessment.models.SqlPaaSTargetOptions]
        :keyword reserved_instance_sql_targets: Gets or sets the Reserved Instance SQL target types.
        :paramtype reserved_instance_sql_targets: list[str or
         ~azure.mgmt.migrationassessment.models.TargetType]
        :keyword reserved_instance_supported_locations: Gets or sets the list of Azure locations
         supporting Reserved Instances.
        :paramtype reserved_instance_supported_locations: list[str or
         ~azure.mgmt.migrationassessment.models.AzureLocation]
        :keyword reserved_instance_supported_currencies: Gets or sets the list of currencies supported
         for Reserved Instances.
        :paramtype reserved_instance_supported_currencies: list[str or
         ~azure.mgmt.migrationassessment.models.AzureCurrency]
        :keyword reserved_instance_supported_offers: Gets or sets the list of offers supported for
         Reserved Instances.
        :paramtype reserved_instance_supported_offers: list[str or
         ~azure.mgmt.migrationassessment.models.AzureOfferCode]
        :keyword supported_offers: Gets or sets the list of offers supported for SQL assessments.
        :paramtype supported_offers: list[str or ~azure.mgmt.migrationassessment.models.AzureOfferCode]
        """
        super().__init__(**kwargs)
        self.vm_families = None
        self.reserved_instance_vm_families = None
        self.premium_disk_vm_families = None
        self.savings_plan_vm_families = savings_plan_vm_families
        self.savings_plan_supported_locations = savings_plan_supported_locations
        self.savings_plan_supported_locations_for_paas = savings_plan_supported_locations_for_paas
        self.reserved_instance_supported_locations_for_iaas = reserved_instance_supported_locations_for_iaas
        self.savings_plan_supported_offers = savings_plan_supported_offers
        self.sql_skus = sql_skus
        self.reserved_instance_sql_targets = reserved_instance_sql_targets
        self.reserved_instance_supported_locations = reserved_instance_supported_locations
        self.reserved_instance_supported_currencies = reserved_instance_supported_currencies
        self.reserved_instance_supported_offers = reserved_instance_supported_offers
        self.supported_offers = supported_offers


class SqlAssessmentV2(ProxyResource):
    """SQL Assessment REST resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.SqlAssessmentV2Properties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SqlAssessmentV2Properties"},
    }

    def __init__(self, *, properties: Optional["_models.SqlAssessmentV2Properties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.SqlAssessmentV2Properties
        """
        super().__init__(**kwargs)
        self.properties = properties


class SqlAssessmentV2IaasSuitabilityData(_serialization.Model):
    """Class representing Azure SQL IAAS suitability details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar azure_sql_sku: Gets the azure SQL IAAS SKU.
    :vartype azure_sql_sku: ~azure.mgmt.migrationassessment.models.AzureSqlIaasSkuDTO
    :ivar replica_azure_sql_sku: Gets the replica azure SQL IAAS SKU.
    :vartype replica_azure_sql_sku: list[~azure.mgmt.migrationassessment.models.AzureSqlIaasSkuDTO]
    :ivar shared_resources: Gets the shared resources.
    :vartype shared_resources: ~azure.mgmt.migrationassessment.models.SharedResourcesDTO
    :ivar monthly_compute_cost: Gets the monthly compute cost.
    :vartype monthly_compute_cost: float
    :ivar monthly_storage_cost: Gets the monthly storage cost.
    :vartype monthly_storage_cost: float
    :ivar cost_components: Gets the collection of cost components.
    :vartype cost_components: list[~azure.mgmt.migrationassessment.models.CostComponent]
    :ivar security_suitability: Gets the suitability for Microsoft cloud defender. Known values
     are: "Unknown", "NotSuitable", "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
    :vartype security_suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
    :ivar should_provision_replicas: Gets a value indicating whether replicas should be
     provisioned.
    :vartype should_provision_replicas: bool
    :ivar sku_replication_mode: Gets the replication mode. Known values are: "NotApplicable",
     "ActiveGeoReplication", and "FailoverGroupInstance".
    :vartype sku_replication_mode: str or ~azure.mgmt.migrationassessment.models.SkuReplicationMode
    :ivar migration_guidelines: Gets the list of migration guidelines applicable to this target.
    :vartype migration_guidelines:
     list[~azure.mgmt.migrationassessment.models.SqlMigrationGuideline]
    :ivar recommendation_reasonings: Gets the list of SQL recommendation Reasoning.
    :vartype recommendation_reasonings:
     list[~azure.mgmt.migrationassessment.models.SqlRecommendationReasoning]
    :ivar migration_target_platform: Gets the migration target platform. Known values are:
     "Unknown", "Recommended", "AzureSqlDatabase", "AzureSqlManagedInstance",
     "AzureSqlVirtualMachine", and "AzureVirtualMachine".
    :vartype migration_target_platform: str or ~azure.mgmt.migrationassessment.models.TargetType
    :ivar suitability: Gets the azure suitability. Known values are: "Unknown", "NotSuitable",
     "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
    :vartype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
    :ivar migration_issues: Gets the list of migrations issues.
    :vartype migration_issues:
     list[~azure.mgmt.migrationassessment.models.SqlAssessmentMigrationIssue]
    """

    _validation = {
        "azure_sql_sku": {"readonly": True},
        "replica_azure_sql_sku": {"readonly": True},
        "shared_resources": {"readonly": True},
        "monthly_compute_cost": {"readonly": True},
        "monthly_storage_cost": {"readonly": True},
        "security_suitability": {"readonly": True},
        "should_provision_replicas": {"readonly": True},
        "sku_replication_mode": {"readonly": True},
        "migration_guidelines": {"readonly": True},
        "recommendation_reasonings": {"readonly": True},
        "migration_target_platform": {"readonly": True},
        "suitability": {"readonly": True},
        "migration_issues": {"readonly": True},
    }

    _attribute_map = {
        "azure_sql_sku": {"key": "azureSqlSku", "type": "AzureSqlIaasSkuDTO"},
        "replica_azure_sql_sku": {"key": "replicaAzureSqlSku", "type": "[AzureSqlIaasSkuDTO]"},
        "shared_resources": {"key": "sharedResources", "type": "SharedResourcesDTO"},
        "monthly_compute_cost": {"key": "monthlyComputeCost", "type": "float"},
        "monthly_storage_cost": {"key": "monthlyStorageCost", "type": "float"},
        "cost_components": {"key": "costComponents", "type": "[CostComponent]"},
        "security_suitability": {"key": "securitySuitability", "type": "str"},
        "should_provision_replicas": {"key": "shouldProvisionReplicas", "type": "bool"},
        "sku_replication_mode": {"key": "skuReplicationMode", "type": "str"},
        "migration_guidelines": {"key": "migrationGuidelines", "type": "[SqlMigrationGuideline]"},
        "recommendation_reasonings": {"key": "recommendationReasonings", "type": "[SqlRecommendationReasoning]"},
        "migration_target_platform": {"key": "migrationTargetPlatform", "type": "str"},
        "suitability": {"key": "suitability", "type": "str"},
        "migration_issues": {"key": "migrationIssues", "type": "[SqlAssessmentMigrationIssue]"},
    }

    def __init__(self, *, cost_components: Optional[List["_models.CostComponent"]] = None, **kwargs: Any) -> None:
        """
        :keyword cost_components: Gets the collection of cost components.
        :paramtype cost_components: list[~azure.mgmt.migrationassessment.models.CostComponent]
        """
        super().__init__(**kwargs)
        self.azure_sql_sku = None
        self.replica_azure_sql_sku = None
        self.shared_resources = None
        self.monthly_compute_cost = None
        self.monthly_storage_cost = None
        self.cost_components = cost_components
        self.security_suitability = None
        self.should_provision_replicas = None
        self.sku_replication_mode = None
        self.migration_guidelines = None
        self.recommendation_reasonings = None
        self.migration_target_platform = None
        self.suitability = None
        self.migration_issues = None


class SqlAssessmentV2ListResult(_serialization.Model):
    """The response of a SqlAssessmentV2 list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The SqlAssessmentV2 items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.SqlAssessmentV2]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlAssessmentV2]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.SqlAssessmentV2"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The SqlAssessmentV2 items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.SqlAssessmentV2]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SqlAssessmentV2PaasSuitabilityData(_serialization.Model):
    """Class representing Azure SQL PAAS suitability details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar azure_sql_sku: Gets the azure SQL PAAS SKU.
    :vartype azure_sql_sku: ~azure.mgmt.migrationassessment.models.AzureSqlPaasSkuDTO
    :ivar replica_azure_sql_sku: Gets the replica azure SQL PAAS SKU.
    :vartype replica_azure_sql_sku: list[~azure.mgmt.migrationassessment.models.AzureSqlPaasSkuDTO]
    :ivar shared_resources: Gets the shared resources.
    :vartype shared_resources: ~azure.mgmt.migrationassessment.models.SharedResourcesDTO
    :ivar monthly_compute_cost: Gets the monthly compute cost.
    :vartype monthly_compute_cost: float
    :ivar monthly_storage_cost: Gets the monthly storage cost.
    :vartype monthly_storage_cost: float
    :ivar cost_components: Gets the collection of cost components.
    :vartype cost_components: list[~azure.mgmt.migrationassessment.models.CostComponent]
    :ivar security_suitability: Gets the suitability for Microsoft cloud defender. Known values
     are: "Unknown", "NotSuitable", "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
    :vartype security_suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
    :ivar should_provision_replicas: Gets a value indicating whether replicas should be
     provisioned.
    :vartype should_provision_replicas: bool
    :ivar sku_replication_mode: Gets the replication mode. Known values are: "NotApplicable",
     "ActiveGeoReplication", and "FailoverGroupInstance".
    :vartype sku_replication_mode: str or ~azure.mgmt.migrationassessment.models.SkuReplicationMode
    :ivar migration_guidelines: Gets the list of migration guidelines applicable to this target.
    :vartype migration_guidelines:
     list[~azure.mgmt.migrationassessment.models.SqlMigrationGuideline]
    :ivar recommendation_reasonings: Gets the list of SQL recommendation Reasoning.
    :vartype recommendation_reasonings:
     list[~azure.mgmt.migrationassessment.models.SqlRecommendationReasoning]
    :ivar migration_target_platform: Gets the migration target platform. Known values are:
     "Unknown", "Recommended", "AzureSqlDatabase", "AzureSqlManagedInstance",
     "AzureSqlVirtualMachine", and "AzureVirtualMachine".
    :vartype migration_target_platform: str or ~azure.mgmt.migrationassessment.models.TargetType
    :ivar suitability: Gets the azure suitability. Known values are: "Unknown", "NotSuitable",
     "Suitable", "ConditionallySuitable", and "ReadinessUnknown".
    :vartype suitability: str or ~azure.mgmt.migrationassessment.models.CloudSuitability
    :ivar migration_issues: Gets the list of migrations issues.
    :vartype migration_issues:
     list[~azure.mgmt.migrationassessment.models.SqlAssessmentMigrationIssue]
    """

    _validation = {
        "azure_sql_sku": {"readonly": True},
        "replica_azure_sql_sku": {"readonly": True},
        "shared_resources": {"readonly": True},
        "monthly_compute_cost": {"readonly": True},
        "monthly_storage_cost": {"readonly": True},
        "security_suitability": {"readonly": True},
        "should_provision_replicas": {"readonly": True},
        "sku_replication_mode": {"readonly": True},
        "migration_guidelines": {"readonly": True},
        "recommendation_reasonings": {"readonly": True},
        "migration_target_platform": {"readonly": True},
        "suitability": {"readonly": True},
        "migration_issues": {"readonly": True},
    }

    _attribute_map = {
        "azure_sql_sku": {"key": "azureSqlSku", "type": "AzureSqlPaasSkuDTO"},
        "replica_azure_sql_sku": {"key": "replicaAzureSqlSku", "type": "[AzureSqlPaasSkuDTO]"},
        "shared_resources": {"key": "sharedResources", "type": "SharedResourcesDTO"},
        "monthly_compute_cost": {"key": "monthlyComputeCost", "type": "float"},
        "monthly_storage_cost": {"key": "monthlyStorageCost", "type": "float"},
        "cost_components": {"key": "costComponents", "type": "[CostComponent]"},
        "security_suitability": {"key": "securitySuitability", "type": "str"},
        "should_provision_replicas": {"key": "shouldProvisionReplicas", "type": "bool"},
        "sku_replication_mode": {"key": "skuReplicationMode", "type": "str"},
        "migration_guidelines": {"key": "migrationGuidelines", "type": "[SqlMigrationGuideline]"},
        "recommendation_reasonings": {"key": "recommendationReasonings", "type": "[SqlRecommendationReasoning]"},
        "migration_target_platform": {"key": "migrationTargetPlatform", "type": "str"},
        "suitability": {"key": "suitability", "type": "str"},
        "migration_issues": {"key": "migrationIssues", "type": "[SqlAssessmentMigrationIssue]"},
    }

    def __init__(self, *, cost_components: Optional[List["_models.CostComponent"]] = None, **kwargs: Any) -> None:
        """
        :keyword cost_components: Gets the collection of cost components.
        :paramtype cost_components: list[~azure.mgmt.migrationassessment.models.CostComponent]
        """
        super().__init__(**kwargs)
        self.azure_sql_sku = None
        self.replica_azure_sql_sku = None
        self.shared_resources = None
        self.monthly_compute_cost = None
        self.monthly_storage_cost = None
        self.cost_components = cost_components
        self.security_suitability = None
        self.should_provision_replicas = None
        self.sku_replication_mode = None
        self.migration_guidelines = None
        self.recommendation_reasonings = None
        self.migration_target_platform = None
        self.suitability = None
        self.migration_issues = None


class SqlAssessmentV2Properties(AzureResourceProperties):
    """SQL assessment properties class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
    :ivar os_license: Gets or sets user configurable setting to display the azure hybrid use
     benefit. Known values are: "Unknown", "Yes", and "No".
    :vartype os_license: str or ~azure.mgmt.migrationassessment.models.OsLicense
    :ivar environment_type: Gets or sets user configurable setting to display the environment type.
     Known values are: "Production" and "Test".
    :vartype environment_type: str or ~azure.mgmt.migrationassessment.models.EnvironmentType
    :ivar entity_uptime: Gets or sets the duration for which the entity (SQL, VMs) are up in the
     on-premises environment.
    :vartype entity_uptime: ~azure.mgmt.migrationassessment.models.EntityUptime
    :ivar optimization_logic: Gets or sets SQL optimization logic. Known values are:
     "MinimizeCost", "ModernizeToPaaS", "ModernizeToAzureSqlMi", and "ModernizeToAzureSqlDb".
    :vartype optimization_logic: str or ~azure.mgmt.migrationassessment.models.OptimizationLogic
    :ivar reserved_instance_for_vm: Gets or sets azure reserved instance for VM. Known values are:
     "None", "RI1Year", and "RI3Year".
    :vartype reserved_instance_for_vm: str or
     ~azure.mgmt.migrationassessment.models.AzureReservedInstance
    :ivar azure_offer_code_for_vm: Gets or sets Azure Offer Code for VM. Known values are:
     "Unknown", "MSAZR0003P", "MSAZR0044P", "MSAZR0059P", "MSAZR0060P", "MSAZR0062P", "MSAZR0063P",
     "MSAZR0064P", "MSAZR0029P", "MSAZR0022P", "MSAZR0023P", "MSAZR0148P", "MSAZR0025P",
     "MSAZR0036P", "MSAZR0120P", "MSAZR0121P", "MSAZR0122P", "MSAZR0123P", "MSAZR0124P",
     "MSAZR0125P", "MSAZR0126P", "MSAZR0127P", "MSAZR0128P", "MSAZR0129P", "MSAZR0130P",
     "MSAZR0111P", "MSAZR0144P", "MSAZR0149P", "MSMCAZR0044P", "MSMCAZR0059P", "MSMCAZR0060P",
     "MSMCAZR0063P", "MSMCAZR0120P", "MSMCAZR0121P", "MSMCAZR0125P", "MSMCAZR0128P", "MSAZRDE0003P",
     "MSAZRDE0044P", "MSAZRUSGOV0003P", "EA", "MSAZR0243P", "SavingsPlan1Year", and
     "SavingsPlan3Year".
    :vartype azure_offer_code_for_vm: str or ~azure.mgmt.migrationassessment.models.AzureOfferCode
    :ivar ea_subscription_id: Gets or sets the Enterprise agreement subscription id.
    :vartype ea_subscription_id: str
    :ivar azure_sql_managed_instance_settings: Gets or sets user configurable SQL managed instance
     settings.
    :vartype azure_sql_managed_instance_settings:
     ~azure.mgmt.migrationassessment.models.SqlMiSettings
    :ivar azure_sql_database_settings: Gets or sets user configurable SQL database settings.
    :vartype azure_sql_database_settings: ~azure.mgmt.migrationassessment.models.SqlDbSettings
    :ivar azure_sql_vm_settings: Gets or sets user configurable SQL VM settings.
    :vartype azure_sql_vm_settings: ~azure.mgmt.migrationassessment.models.SqlVmSettings
    :ivar multi_subnet_intent: Gets or sets user preference indicating intent of multi-subnet
     configuration. Known values are: "None", "HighAvailability", and "DisasterRecovery".
    :vartype multi_subnet_intent: str or ~azure.mgmt.migrationassessment.models.MultiSubnetIntent
    :ivar async_commit_mode_intent: Gets or sets user preference indicating intent of async commit
     mode. Known values are: "None", "HighAvailability", and "DisasterRecovery".
    :vartype async_commit_mode_intent: str or
     ~azure.mgmt.migrationassessment.models.AsyncCommitModeIntent
    :ivar is_internet_access_available: Gets or sets a value indicating whether internet access is
     available.
    :vartype is_internet_access_available: bool
    :ivar disaster_recovery_location: Gets or sets the Azure Location or Azure region where to
     which the machines
     will be migrated. Known values are: "Unknown", "EastAsia", "SoutheastAsia", "AustraliaEast",
     "AustraliaSoutheast", "BrazilSouth", "CanadaCentral", "CanadaEast", "WestEurope",
     "NorthEurope", "CentralIndia", "SouthIndia", "WestIndia", "JapanEast", "JapanWest",
     "KoreaCentral", "KoreaSouth", "UkWest", "UkSouth", "NorthCentralUs", "EastUs", "WestUs2",
     "SouthCentralUs", "CentralUs", "EastUs2", "WestUs", "WestCentralUs", "GermanyCentral",
     "GermanyNortheast", "ChinaNorth", "ChinaEast", "USGovArizona", "USGovTexas", "USGovIowa",
     "USGovVirginia", "USDoDCentral", "USDoDEast", "FranceCentral", "AustraliaCentral",
     "SouthAfricaNorth", "FranceSouth", "AustraliaCentral2", "SouthAfricaWest", "GermanyNorth",
     "GermanyWestCentral", "NorwayEast", "NorwayWest", "ChinaEast2", "ChinaNorth2",
     "SwitzerlandNorth", "SwitzerlandWest", "UAENorth", "UAECentral", "UsNatEast", "UsNatWest",
     "UsSecEast", "UsSecCentral", "UsSecWest", "SwedenCentral", and "QatarCentral".
    :vartype disaster_recovery_location: str or
     ~azure.mgmt.migrationassessment.models.AzureLocation
    :ivar enable_hadr_assessment: Gets or sets a value indicating whether HADR assessments needs to
     be created.
    :vartype enable_hadr_assessment: bool
    :ivar azure_security_offering_type: Gets or sets a value indicating azure security offering
     type. Known values are: "NO" and "MDC".
    :vartype azure_security_offering_type: str or
     ~azure.mgmt.migrationassessment.models.AzureSecurityOfferingType
    :ivar reserved_instance: Reserved instance. Known values are: "None", "RI1Year", and "RI3Year".
    :vartype reserved_instance: str or ~azure.mgmt.migrationassessment.models.AzureReservedInstance
    :ivar sql_server_license: SQL server license. Known values are: "Unknown", "Yes", and "No".
    :vartype sql_server_license: str or ~azure.mgmt.migrationassessment.models.SqlServerLicense
    :ivar group_type: Gets the group type for the assessment. Known values are: "Default",
     "Import", and "Import".
    :vartype group_type: str or ~azure.mgmt.migrationassessment.models.GroupType
    :ivar assessment_type: Assessment type of the assessment. Known values are: "Unknown",
     "MachineAssessment", "AvsAssessment", "SqlAssessment", and "WebAppAssessment".
    :vartype assessment_type: str or ~azure.mgmt.migrationassessment.models.AssessmentType
    :ivar azure_location: Azure Location or Azure region where to which the machines will be
     migrated.
    :vartype azure_location: str
    :ivar azure_offer_code: Azure Offer Code. Known values are: "Unknown", "MSAZR0003P",
     "MSAZR0044P", "MSAZR0059P", "MSAZR0060P", "MSAZR0062P", "MSAZR0063P", "MSAZR0064P",
     "MSAZR0029P", "MSAZR0022P", "MSAZR0023P", "MSAZR0148P", "MSAZR0025P", "MSAZR0036P",
     "MSAZR0120P", "MSAZR0121P", "MSAZR0122P", "MSAZR0123P", "MSAZR0124P", "MSAZR0125P",
     "MSAZR0126P", "MSAZR0127P", "MSAZR0128P", "MSAZR0129P", "MSAZR0130P", "MSAZR0111P",
     "MSAZR0144P", "MSAZR0149P", "MSMCAZR0044P", "MSMCAZR0059P", "MSMCAZR0060P", "MSMCAZR0063P",
     "MSMCAZR0120P", "MSMCAZR0121P", "MSMCAZR0125P", "MSMCAZR0128P", "MSAZRDE0003P", "MSAZRDE0044P",
     "MSAZRUSGOV0003P", "EA", "MSAZR0243P", "SavingsPlan1Year", and "SavingsPlan3Year".
    :vartype azure_offer_code: str or ~azure.mgmt.migrationassessment.models.AzureOfferCode
    :ivar currency: Currency in which prices should be reported. Known values are: "Unknown",
     "USD", "DKK", "CAD", "IDR", "JPY", "KRW", "NZD", "NOK", "RUB", "SAR", "ZAR", "SEK", "TRY",
     "GBP", "MXN", "MYR", "INR", "HKD", "BRL", "TWD", "EUR", "CHF", "ARS", "AUD", "CNY", and "TRY".
    :vartype currency: str or ~azure.mgmt.migrationassessment.models.AzureCurrency
    :ivar scaling_factor: Percentage of buffer that user wants on performance metrics when
     recommending
     Azure sizes.
    :vartype scaling_factor: float
    :ivar percentile: Percentile of the utilization data values to be considered while assessing
     machines. Known values are: "Percentile50", "Percentile90", "Percentile95", and
     "Percentile99".
    :vartype percentile: str or ~azure.mgmt.migrationassessment.models.Percentile
    :ivar time_range: Time Range for which the historic utilization data should be considered for
     assessment. Known values are: "Day", "Week", "Month", and "Custom".
    :vartype time_range: str or ~azure.mgmt.migrationassessment.models.TimeRange
    :ivar perf_data_start_time: Gets or sets the start time to consider performance data for
     assessment.
    :vartype perf_data_start_time: ~datetime.datetime
    :ivar perf_data_end_time: Gets or sets the end time to consider performance data for
     assessment.
    :vartype perf_data_end_time: ~datetime.datetime
    :ivar stage: User configurable setting to display the Stage of Assessment. Known values are:
     "InProgress", "UnderReview", and "Approved".
    :vartype stage: str or ~azure.mgmt.migrationassessment.models.AssessmentStage
    :ivar discount_percentage: Custom discount percentage.
    :vartype discount_percentage: float
    :ivar sizing_criterion: Assessment sizing criterion. Known values are: "PerformanceBased" and
     "AsOnPremises".
    :vartype sizing_criterion: str or
     ~azure.mgmt.migrationassessment.models.AssessmentSizingCriterion
    :ivar confidence_rating_in_percentage: Confidence Rating in Percentage.
    :vartype confidence_rating_in_percentage: float
    :ivar prices_timestamp: Last time when rates were queried.
    :vartype prices_timestamp: ~datetime.datetime
    :ivar created_timestamp: Date and Time when assessment was created.
    :vartype created_timestamp: ~datetime.datetime
    :ivar updated_timestamp: Date and Time when assessment was last updated.
    :vartype updated_timestamp: ~datetime.datetime
    :ivar status: Whether assessment is in valid state and all machines have been assessed. Known
     values are: "Created", "Updated", "Running", "Completed", "Invalid", "OutOfSync", "OutDated",
     and "Deleted".
    :vartype status: str or ~azure.mgmt.migrationassessment.models.AssessmentStatus
    :ivar schema_version: Schema version.
    :vartype schema_version: str
    """

    _validation = {
        "stage": {"readonly": True},
        "prices_timestamp": {"readonly": True},
        "created_timestamp": {"readonly": True},
        "updated_timestamp": {"readonly": True},
        "status": {"readonly": True},
        "schema_version": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "os_license": {"key": "osLicense", "type": "str"},
        "environment_type": {"key": "environmentType", "type": "str"},
        "entity_uptime": {"key": "entityUptime", "type": "EntityUptime"},
        "optimization_logic": {"key": "optimizationLogic", "type": "str"},
        "reserved_instance_for_vm": {"key": "reservedInstanceForVm", "type": "str"},
        "azure_offer_code_for_vm": {"key": "azureOfferCodeForVm", "type": "str"},
        "ea_subscription_id": {"key": "eaSubscriptionId", "type": "str"},
        "azure_sql_managed_instance_settings": {"key": "azureSqlManagedInstanceSettings", "type": "SqlMiSettings"},
        "azure_sql_database_settings": {"key": "azureSqlDatabaseSettings", "type": "SqlDbSettings"},
        "azure_sql_vm_settings": {"key": "azureSqlVmSettings", "type": "SqlVmSettings"},
        "multi_subnet_intent": {"key": "multiSubnetIntent", "type": "str"},
        "async_commit_mode_intent": {"key": "asyncCommitModeIntent", "type": "str"},
        "is_internet_access_available": {"key": "isInternetAccessAvailable", "type": "bool"},
        "disaster_recovery_location": {"key": "disasterRecoveryLocation", "type": "str"},
        "enable_hadr_assessment": {"key": "enableHadrAssessment", "type": "bool"},
        "azure_security_offering_type": {"key": "azureSecurityOfferingType", "type": "str"},
        "reserved_instance": {"key": "reservedInstance", "type": "str"},
        "sql_server_license": {"key": "sqlServerLicense", "type": "str"},
        "group_type": {"key": "groupType", "type": "str"},
        "assessment_type": {"key": "assessmentType", "type": "str"},
        "azure_location": {"key": "azureLocation", "type": "str"},
        "azure_offer_code": {"key": "azureOfferCode", "type": "str"},
        "currency": {"key": "currency", "type": "str"},
        "scaling_factor": {"key": "scalingFactor", "type": "float"},
        "percentile": {"key": "percentile", "type": "str"},
        "time_range": {"key": "timeRange", "type": "str"},
        "perf_data_start_time": {"key": "perfDataStartTime", "type": "iso-8601"},
        "perf_data_end_time": {"key": "perfDataEndTime", "type": "iso-8601"},
        "stage": {"key": "stage", "type": "str"},
        "discount_percentage": {"key": "discountPercentage", "type": "float"},
        "sizing_criterion": {"key": "sizingCriterion", "type": "str"},
        "confidence_rating_in_percentage": {"key": "confidenceRatingInPercentage", "type": "float"},
        "prices_timestamp": {"key": "pricesTimestamp", "type": "iso-8601"},
        "created_timestamp": {"key": "createdTimestamp", "type": "iso-8601"},
        "updated_timestamp": {"key": "updatedTimestamp", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "schema_version": {"key": "schemaVersion", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        os_license: Optional[Union[str, "_models.OsLicense"]] = None,
        environment_type: Optional[Union[str, "_models.EnvironmentType"]] = None,
        entity_uptime: Optional["_models.EntityUptime"] = None,
        optimization_logic: Optional[Union[str, "_models.OptimizationLogic"]] = None,
        reserved_instance_for_vm: Optional[Union[str, "_models.AzureReservedInstance"]] = None,
        azure_offer_code_for_vm: Optional[Union[str, "_models.AzureOfferCode"]] = None,
        ea_subscription_id: Optional[str] = None,
        azure_sql_managed_instance_settings: Optional["_models.SqlMiSettings"] = None,
        azure_sql_database_settings: Optional["_models.SqlDbSettings"] = None,
        azure_sql_vm_settings: Optional["_models.SqlVmSettings"] = None,
        multi_subnet_intent: Optional[Union[str, "_models.MultiSubnetIntent"]] = None,
        async_commit_mode_intent: Optional[Union[str, "_models.AsyncCommitModeIntent"]] = None,
        is_internet_access_available: Optional[bool] = None,
        disaster_recovery_location: Optional[Union[str, "_models.AzureLocation"]] = None,
        enable_hadr_assessment: Optional[bool] = None,
        azure_security_offering_type: Optional[Union[str, "_models.AzureSecurityOfferingType"]] = None,
        reserved_instance: Optional[Union[str, "_models.AzureReservedInstance"]] = None,
        sql_server_license: Optional[Union[str, "_models.SqlServerLicense"]] = None,
        group_type: Optional[Union[str, "_models.GroupType"]] = None,
        assessment_type: Optional[Union[str, "_models.AssessmentType"]] = None,
        azure_location: Optional[str] = None,
        azure_offer_code: Optional[Union[str, "_models.AzureOfferCode"]] = None,
        currency: Optional[Union[str, "_models.AzureCurrency"]] = None,
        scaling_factor: Optional[float] = None,
        percentile: Optional[Union[str, "_models.Percentile"]] = None,
        time_range: Optional[Union[str, "_models.TimeRange"]] = None,
        perf_data_start_time: Optional[datetime.datetime] = None,
        perf_data_end_time: Optional[datetime.datetime] = None,
        discount_percentage: Optional[float] = None,
        sizing_criterion: Optional[Union[str, "_models.AssessmentSizingCriterion"]] = None,
        confidence_rating_in_percentage: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: The status of the last operation. Known values are: "Succeeded",
         "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
        :paramtype provisioning_state: str or ~azure.mgmt.migrationassessment.models.ProvisioningState
        :keyword os_license: Gets or sets user configurable setting to display the azure hybrid use
         benefit. Known values are: "Unknown", "Yes", and "No".
        :paramtype os_license: str or ~azure.mgmt.migrationassessment.models.OsLicense
        :keyword environment_type: Gets or sets user configurable setting to display the environment
         type. Known values are: "Production" and "Test".
        :paramtype environment_type: str or ~azure.mgmt.migrationassessment.models.EnvironmentType
        :keyword entity_uptime: Gets or sets the duration for which the entity (SQL, VMs) are up in the
         on-premises environment.
        :paramtype entity_uptime: ~azure.mgmt.migrationassessment.models.EntityUptime
        :keyword optimization_logic: Gets or sets SQL optimization logic. Known values are:
         "MinimizeCost", "ModernizeToPaaS", "ModernizeToAzureSqlMi", and "ModernizeToAzureSqlDb".
        :paramtype optimization_logic: str or ~azure.mgmt.migrationassessment.models.OptimizationLogic
        :keyword reserved_instance_for_vm: Gets or sets azure reserved instance for VM. Known values
         are: "None", "RI1Year", and "RI3Year".
        :paramtype reserved_instance_for_vm: str or
         ~azure.mgmt.migrationassessment.models.AzureReservedInstance
        :keyword azure_offer_code_for_vm: Gets or sets Azure Offer Code for VM. Known values are:
         "Unknown", "MSAZR0003P", "MSAZR0044P", "MSAZR0059P", "MSAZR0060P", "MSAZR0062P", "MSAZR0063P",
         "MSAZR0064P", "MSAZR0029P", "MSAZR0022P", "MSAZR0023P", "MSAZR0148P", "MSAZR0025P",
         "MSAZR0036P", "MSAZR0120P", "MSAZR0121P", "MSAZR0122P", "MSAZR0123P", "MSAZR0124P",
         "MSAZR0125P", "MSAZR0126P", "MSAZR0127P", "MSAZR0128P", "MSAZR0129P", "MSAZR0130P",
         "MSAZR0111P", "MSAZR0144P", "MSAZR0149P", "MSMCAZR0044P", "MSMCAZR0059P", "MSMCAZR0060P",
         "MSMCAZR0063P", "MSMCAZR0120P", "MSMCAZR0121P", "MSMCAZR0125P", "MSMCAZR0128P", "MSAZRDE0003P",
         "MSAZRDE0044P", "MSAZRUSGOV0003P", "EA", "MSAZR0243P", "SavingsPlan1Year", and
         "SavingsPlan3Year".
        :paramtype azure_offer_code_for_vm: str or
         ~azure.mgmt.migrationassessment.models.AzureOfferCode
        :keyword ea_subscription_id: Gets or sets the Enterprise agreement subscription id.
        :paramtype ea_subscription_id: str
        :keyword azure_sql_managed_instance_settings: Gets or sets user configurable SQL managed
         instance settings.
        :paramtype azure_sql_managed_instance_settings:
         ~azure.mgmt.migrationassessment.models.SqlMiSettings
        :keyword azure_sql_database_settings: Gets or sets user configurable SQL database settings.
        :paramtype azure_sql_database_settings: ~azure.mgmt.migrationassessment.models.SqlDbSettings
        :keyword azure_sql_vm_settings: Gets or sets user configurable SQL VM settings.
        :paramtype azure_sql_vm_settings: ~azure.mgmt.migrationassessment.models.SqlVmSettings
        :keyword multi_subnet_intent: Gets or sets user preference indicating intent of multi-subnet
         configuration. Known values are: "None", "HighAvailability", and "DisasterRecovery".
        :paramtype multi_subnet_intent: str or ~azure.mgmt.migrationassessment.models.MultiSubnetIntent
        :keyword async_commit_mode_intent: Gets or sets user preference indicating intent of async
         commit mode. Known values are: "None", "HighAvailability", and "DisasterRecovery".
        :paramtype async_commit_mode_intent: str or
         ~azure.mgmt.migrationassessment.models.AsyncCommitModeIntent
        :keyword is_internet_access_available: Gets or sets a value indicating whether internet access
         is available.
        :paramtype is_internet_access_available: bool
        :keyword disaster_recovery_location: Gets or sets the Azure Location or Azure region where to
         which the machines
         will be migrated. Known values are: "Unknown", "EastAsia", "SoutheastAsia", "AustraliaEast",
         "AustraliaSoutheast", "BrazilSouth", "CanadaCentral", "CanadaEast", "WestEurope",
         "NorthEurope", "CentralIndia", "SouthIndia", "WestIndia", "JapanEast", "JapanWest",
         "KoreaCentral", "KoreaSouth", "UkWest", "UkSouth", "NorthCentralUs", "EastUs", "WestUs2",
         "SouthCentralUs", "CentralUs", "EastUs2", "WestUs", "WestCentralUs", "GermanyCentral",
         "GermanyNortheast", "ChinaNorth", "ChinaEast", "USGovArizona", "USGovTexas", "USGovIowa",
         "USGovVirginia", "USDoDCentral", "USDoDEast", "FranceCentral", "AustraliaCentral",
         "SouthAfricaNorth", "FranceSouth", "AustraliaCentral2", "SouthAfricaWest", "GermanyNorth",
         "GermanyWestCentral", "NorwayEast", "NorwayWest", "ChinaEast2", "ChinaNorth2",
         "SwitzerlandNorth", "SwitzerlandWest", "UAENorth", "UAECentral", "UsNatEast", "UsNatWest",
         "UsSecEast", "UsSecCentral", "UsSecWest", "SwedenCentral", and "QatarCentral".
        :paramtype disaster_recovery_location: str or
         ~azure.mgmt.migrationassessment.models.AzureLocation
        :keyword enable_hadr_assessment: Gets or sets a value indicating whether HADR assessments needs
         to be created.
        :paramtype enable_hadr_assessment: bool
        :keyword azure_security_offering_type: Gets or sets a value indicating azure security offering
         type. Known values are: "NO" and "MDC".
        :paramtype azure_security_offering_type: str or
         ~azure.mgmt.migrationassessment.models.AzureSecurityOfferingType
        :keyword reserved_instance: Reserved instance. Known values are: "None", "RI1Year", and
         "RI3Year".
        :paramtype reserved_instance: str or
         ~azure.mgmt.migrationassessment.models.AzureReservedInstance
        :keyword sql_server_license: SQL server license. Known values are: "Unknown", "Yes", and "No".
        :paramtype sql_server_license: str or ~azure.mgmt.migrationassessment.models.SqlServerLicense
        :keyword group_type: Gets the group type for the assessment. Known values are: "Default",
         "Import", and "Import".
        :paramtype group_type: str or ~azure.mgmt.migrationassessment.models.GroupType
        :keyword assessment_type: Assessment type of the assessment. Known values are: "Unknown",
         "MachineAssessment", "AvsAssessment", "SqlAssessment", and "WebAppAssessment".
        :paramtype assessment_type: str or ~azure.mgmt.migrationassessment.models.AssessmentType
        :keyword azure_location: Azure Location or Azure region where to which the machines will be
         migrated.
        :paramtype azure_location: str
        :keyword azure_offer_code: Azure Offer Code. Known values are: "Unknown", "MSAZR0003P",
         "MSAZR0044P", "MSAZR0059P", "MSAZR0060P", "MSAZR0062P", "MSAZR0063P", "MSAZR0064P",
         "MSAZR0029P", "MSAZR0022P", "MSAZR0023P", "MSAZR0148P", "MSAZR0025P", "MSAZR0036P",
         "MSAZR0120P", "MSAZR0121P", "MSAZR0122P", "MSAZR0123P", "MSAZR0124P", "MSAZR0125P",
         "MSAZR0126P", "MSAZR0127P", "MSAZR0128P", "MSAZR0129P", "MSAZR0130P", "MSAZR0111P",
         "MSAZR0144P", "MSAZR0149P", "MSMCAZR0044P", "MSMCAZR0059P", "MSMCAZR0060P", "MSMCAZR0063P",
         "MSMCAZR0120P", "MSMCAZR0121P", "MSMCAZR0125P", "MSMCAZR0128P", "MSAZRDE0003P", "MSAZRDE0044P",
         "MSAZRUSGOV0003P", "EA", "MSAZR0243P", "SavingsPlan1Year", and "SavingsPlan3Year".
        :paramtype azure_offer_code: str or ~azure.mgmt.migrationassessment.models.AzureOfferCode
        :keyword currency: Currency in which prices should be reported. Known values are: "Unknown",
         "USD", "DKK", "CAD", "IDR", "JPY", "KRW", "NZD", "NOK", "RUB", "SAR", "ZAR", "SEK", "TRY",
         "GBP", "MXN", "MYR", "INR", "HKD", "BRL", "TWD", "EUR", "CHF", "ARS", "AUD", "CNY", and "TRY".
        :paramtype currency: str or ~azure.mgmt.migrationassessment.models.AzureCurrency
        :keyword scaling_factor: Percentage of buffer that user wants on performance metrics when
         recommending
         Azure sizes.
        :paramtype scaling_factor: float
        :keyword percentile: Percentile of the utilization data values to be considered while assessing
         machines. Known values are: "Percentile50", "Percentile90", "Percentile95", and
         "Percentile99".
        :paramtype percentile: str or ~azure.mgmt.migrationassessment.models.Percentile
        :keyword time_range: Time Range for which the historic utilization data should be considered
         for
         assessment. Known values are: "Day", "Week", "Month", and "Custom".
        :paramtype time_range: str or ~azure.mgmt.migrationassessment.models.TimeRange
        :keyword perf_data_start_time: Gets or sets the start time to consider performance data for
         assessment.
        :paramtype perf_data_start_time: ~datetime.datetime
        :keyword perf_data_end_time: Gets or sets the end time to consider performance data for
         assessment.
        :paramtype perf_data_end_time: ~datetime.datetime
        :keyword discount_percentage: Custom discount percentage.
        :paramtype discount_percentage: float
        :keyword sizing_criterion: Assessment sizing criterion. Known values are: "PerformanceBased"
         and "AsOnPremises".
        :paramtype sizing_criterion: str or
         ~azure.mgmt.migrationassessment.models.AssessmentSizingCriterion
        :keyword confidence_rating_in_percentage: Confidence Rating in Percentage.
        :paramtype confidence_rating_in_percentage: float
        """
        super().__init__(provisioning_state=provisioning_state, **kwargs)
        self.os_license = os_license
        self.environment_type = environment_type
        self.entity_uptime = entity_uptime
        self.optimization_logic = optimization_logic
        self.reserved_instance_for_vm = reserved_instance_for_vm
        self.azure_offer_code_for_vm = azure_offer_code_for_vm
        self.ea_subscription_id = ea_subscription_id
        self.azure_sql_managed_instance_settings = azure_sql_managed_instance_settings
        self.azure_sql_database_settings = azure_sql_database_settings
        self.azure_sql_vm_settings = azure_sql_vm_settings
        self.multi_subnet_intent = multi_subnet_intent
        self.async_commit_mode_intent = async_commit_mode_intent
        self.is_internet_access_available = is_internet_access_available
        self.disaster_recovery_location = disaster_recovery_location
        self.enable_hadr_assessment = enable_hadr_assessment
        self.azure_security_offering_type = azure_security_offering_type
        self.reserved_instance = reserved_instance
        self.sql_server_license = sql_server_license
        self.group_type = group_type
        self.assessment_type = assessment_type
        self.azure_location = azure_location
        self.azure_offer_code = azure_offer_code
        self.currency = currency
        self.scaling_factor = scaling_factor
        self.percentile = percentile
        self.time_range = time_range
        self.perf_data_start_time = perf_data_start_time
        self.perf_data_end_time = perf_data_end_time
        self.stage = None
        self.discount_percentage = discount_percentage
        self.sizing_criterion = sizing_criterion
        self.confidence_rating_in_percentage = confidence_rating_in_percentage
        self.prices_timestamp = None
        self.created_timestamp = None
        self.updated_timestamp = None
        self.status = None
        self.schema_version = None


class SqlAssessmentV2Summary(ProxyResource):
    """SQL Assessment REST resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.SqlAssessmentV2SummaryProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "SqlAssessmentV2SummaryProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.SqlAssessmentV2SummaryProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.SqlAssessmentV2SummaryProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class SqlAssessmentV2SummaryData(_serialization.Model):
    """SQL Assessment V2 summary data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar suitability_summary: Sql assessment summary data.
    :vartype suitability_summary: dict[str, int]
    :ivar monthly_compute_cost: Monthly compute cost.
    :vartype monthly_compute_cost: float
    :ivar monthly_storage_cost: Monthly storage cost.
    :vartype monthly_storage_cost: float
    :ivar monthly_license_cost: Monthly license cost.
    :vartype monthly_license_cost: float
    :ivar confidence_score: Confidence Rating.
    :vartype confidence_score: float
    :ivar monthly_security_cost: Monthly security cost.
    :vartype monthly_security_cost: float
    """

    _validation = {
        "suitability_summary": {"readonly": True},
        "monthly_compute_cost": {"readonly": True},
        "monthly_storage_cost": {"readonly": True},
        "monthly_license_cost": {"readonly": True},
        "confidence_score": {"readonly": True},
        "monthly_security_cost": {"readonly": True},
    }

    _attribute_map = {
        "suitability_summary": {"key": "suitabilitySummary", "type": "{int}"},
        "monthly_compute_cost": {"key": "monthlyComputeCost", "type": "float"},
        "monthly_storage_cost": {"key": "monthlyStorageCost", "type": "float"},
        "monthly_license_cost": {"key": "monthlyLicenseCost", "type": "float"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "monthly_security_cost": {"key": "monthlySecurityCost", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.suitability_summary = None
        self.monthly_compute_cost = None
        self.monthly_storage_cost = None
        self.monthly_license_cost = None
        self.confidence_score = None
        self.monthly_security_cost = None


class SqlAssessmentV2SummaryListResult(_serialization.Model):
    """The response of a SqlAssessmentV2Summary list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The SqlAssessmentV2Summary items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.SqlAssessmentV2Summary]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlAssessmentV2Summary]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.SqlAssessmentV2Summary"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The SqlAssessmentV2Summary items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.SqlAssessmentV2Summary]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SqlAssessmentV2SummaryProperties(_serialization.Model):
    """SQL Assessment V2 summary properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar assessment_summary: Gets or sets the Assessment summary.
    :vartype assessment_summary: dict[str,
     ~azure.mgmt.migrationassessment.models.SqlAssessmentV2SummaryData]
    :ivar distribution_by_support_status: Gets the distribution of sqlInstances by support status.
    :vartype distribution_by_support_status: dict[str, int]
    :ivar distribution_by_service_pack_insight: Gets the distribution distribution of sqlInstances
     by service pack insight.
    :vartype distribution_by_service_pack_insight: dict[str, int]
    :ivar distribution_by_sql_version: Gets the distribution of sqlInstances by sql version.
    :vartype distribution_by_sql_version: dict[str, int]
    :ivar distribution_by_sql_edition: Gets the distribution of sqlInstances by sql edition.
    :vartype distribution_by_sql_edition: dict[str, int]
    :ivar instance_distribution_by_sizing_criterion: Gets the instance distribution by sizing
     criterion.
    :vartype instance_distribution_by_sizing_criterion: dict[str, int]
    :ivar database_distribution_by_sizing_criterion: Gets the database distribution by sizing
     criterion.
    :vartype database_distribution_by_sizing_criterion: dict[str, int]
    :ivar number_of_machines: Number of machines part of the assessment.
    :vartype number_of_machines: int
    :ivar number_of_sql_instances: Number of sql instances part of the assessment.
    :vartype number_of_sql_instances: int
    :ivar number_of_successfully_discovered_sql_instances: Number of successfully discovered sql
     instances part of the assessment.
    :vartype number_of_successfully_discovered_sql_instances: int
    :ivar number_of_sql_databases: Number of sql databases part of the assessment.
    :vartype number_of_sql_databases: int
    :ivar number_of_fci_instances: Number of sql failover cluster instances part of the assessment.
    :vartype number_of_fci_instances: int
    :ivar number_of_sql_availability_groups: Number of sql availability groups part of the
     assessment.
    :vartype number_of_sql_availability_groups: int
    """

    _validation = {
        "assessment_summary": {"readonly": True},
        "distribution_by_support_status": {"readonly": True},
        "distribution_by_service_pack_insight": {"readonly": True},
        "distribution_by_sql_version": {"readonly": True},
        "distribution_by_sql_edition": {"readonly": True},
        "instance_distribution_by_sizing_criterion": {"readonly": True},
        "database_distribution_by_sizing_criterion": {"readonly": True},
        "number_of_machines": {"readonly": True},
        "number_of_sql_instances": {"readonly": True},
        "number_of_successfully_discovered_sql_instances": {"readonly": True},
        "number_of_sql_databases": {"readonly": True},
        "number_of_fci_instances": {"readonly": True},
        "number_of_sql_availability_groups": {"readonly": True},
    }

    _attribute_map = {
        "assessment_summary": {"key": "assessmentSummary", "type": "{SqlAssessmentV2SummaryData}"},
        "distribution_by_support_status": {"key": "distributionBySupportStatus", "type": "{int}"},
        "distribution_by_service_pack_insight": {"key": "distributionByServicePackInsight", "type": "{int}"},
        "distribution_by_sql_version": {"key": "distributionBySqlVersion", "type": "{int}"},
        "distribution_by_sql_edition": {"key": "distributionBySqlEdition", "type": "{int}"},
        "instance_distribution_by_sizing_criterion": {"key": "instanceDistributionBySizingCriterion", "type": "{int}"},
        "database_distribution_by_sizing_criterion": {"key": "databaseDistributionBySizingCriterion", "type": "{int}"},
        "number_of_machines": {"key": "numberOfMachines", "type": "int"},
        "number_of_sql_instances": {"key": "numberOfSqlInstances", "type": "int"},
        "number_of_successfully_discovered_sql_instances": {
            "key": "numberOfSuccessfullyDiscoveredSqlInstances",
            "type": "int",
        },
        "number_of_sql_databases": {"key": "numberOfSqlDatabases", "type": "int"},
        "number_of_fci_instances": {"key": "numberOfFciInstances", "type": "int"},
        "number_of_sql_availability_groups": {"key": "numberOfSqlAvailabilityGroups", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.assessment_summary = None
        self.distribution_by_support_status = None
        self.distribution_by_service_pack_insight = None
        self.distribution_by_sql_version = None
        self.distribution_by_sql_edition = None
        self.instance_distribution_by_sizing_criterion = None
        self.database_distribution_by_sizing_criterion = None
        self.number_of_machines = None
        self.number_of_sql_instances = None
        self.number_of_successfully_discovered_sql_instances = None
        self.number_of_sql_databases = None
        self.number_of_fci_instances = None
        self.number_of_sql_availability_groups = None


class SqlAvailabilityGroupDataOverview(_serialization.Model):
    """Assessed Sql Availability Group Data Overview.

    :ivar availability_group_id: Gets the availability group id.
    :vartype availability_group_id: str
    :ivar availability_group_name: Gets the availability group name.
    :vartype availability_group_name: str
    :ivar sql_availability_group_sds_arm_id: Gets the availability group arm id.
    :vartype sql_availability_group_sds_arm_id: str
    :ivar sql_availability_group_entity_id: Gets the availability group entity id.
    :vartype sql_availability_group_entity_id: str
    :ivar sql_availability_replica_id: Gets the availability replica id.
    :vartype sql_availability_replica_id: str
    """

    _attribute_map = {
        "availability_group_id": {"key": "availabilityGroupId", "type": "str"},
        "availability_group_name": {"key": "availabilityGroupName", "type": "str"},
        "sql_availability_group_sds_arm_id": {"key": "sqlAvailabilityGroupSdsArmId", "type": "str"},
        "sql_availability_group_entity_id": {"key": "sqlAvailabilityGroupEntityId", "type": "str"},
        "sql_availability_replica_id": {"key": "sqlAvailabilityReplicaId", "type": "str"},
    }

    def __init__(
        self,
        *,
        availability_group_id: Optional[str] = None,
        availability_group_name: Optional[str] = None,
        sql_availability_group_sds_arm_id: Optional[str] = None,
        sql_availability_group_entity_id: Optional[str] = None,
        sql_availability_replica_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword availability_group_id: Gets the availability group id.
        :paramtype availability_group_id: str
        :keyword availability_group_name: Gets the availability group name.
        :paramtype availability_group_name: str
        :keyword sql_availability_group_sds_arm_id: Gets the availability group arm id.
        :paramtype sql_availability_group_sds_arm_id: str
        :keyword sql_availability_group_entity_id: Gets the availability group entity id.
        :paramtype sql_availability_group_entity_id: str
        :keyword sql_availability_replica_id: Gets the availability replica id.
        :paramtype sql_availability_replica_id: str
        """
        super().__init__(**kwargs)
        self.availability_group_id = availability_group_id
        self.availability_group_name = availability_group_name
        self.sql_availability_group_sds_arm_id = sql_availability_group_sds_arm_id
        self.sql_availability_group_entity_id = sql_availability_group_entity_id
        self.sql_availability_replica_id = sql_availability_replica_id


class SqlAvailabilityReplicaSummary(_serialization.Model):
    """Assessed Sql Availability Replica Summary.

    :ivar number_of_synchronous_read_replicas: Gets the number Of synchronous read replicas.
    :vartype number_of_synchronous_read_replicas: int
    :ivar number_of_synchronous_non_read_replicas: Gets the number Of synchronous non read
     replicas.
    :vartype number_of_synchronous_non_read_replicas: int
    :ivar number_of_asynchronous_read_replicas: Gets the number Of asynchronous read replicas.
    :vartype number_of_asynchronous_read_replicas: int
    :ivar number_of_asynchronous_non_read_replicas: Gets the number Of asynchronous non read
     replicas.
    :vartype number_of_asynchronous_non_read_replicas: int
    :ivar number_of_primary_replicas: Gets the number Of primary replicas.
    :vartype number_of_primary_replicas: int
    """

    _attribute_map = {
        "number_of_synchronous_read_replicas": {"key": "numberOfSynchronousReadReplicas", "type": "int"},
        "number_of_synchronous_non_read_replicas": {"key": "numberOfSynchronousNonReadReplicas", "type": "int"},
        "number_of_asynchronous_read_replicas": {"key": "numberOfAsynchronousReadReplicas", "type": "int"},
        "number_of_asynchronous_non_read_replicas": {"key": "numberOfAsynchronousNonReadReplicas", "type": "int"},
        "number_of_primary_replicas": {"key": "numberOfPrimaryReplicas", "type": "int"},
    }

    def __init__(
        self,
        *,
        number_of_synchronous_read_replicas: Optional[int] = None,
        number_of_synchronous_non_read_replicas: Optional[int] = None,
        number_of_asynchronous_read_replicas: Optional[int] = None,
        number_of_asynchronous_non_read_replicas: Optional[int] = None,
        number_of_primary_replicas: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number_of_synchronous_read_replicas: Gets the number Of synchronous read replicas.
        :paramtype number_of_synchronous_read_replicas: int
        :keyword number_of_synchronous_non_read_replicas: Gets the number Of synchronous non read
         replicas.
        :paramtype number_of_synchronous_non_read_replicas: int
        :keyword number_of_asynchronous_read_replicas: Gets the number Of asynchronous read replicas.
        :paramtype number_of_asynchronous_read_replicas: int
        :keyword number_of_asynchronous_non_read_replicas: Gets the number Of asynchronous non read
         replicas.
        :paramtype number_of_asynchronous_non_read_replicas: int
        :keyword number_of_primary_replicas: Gets the number Of primary replicas.
        :paramtype number_of_primary_replicas: int
        """
        super().__init__(**kwargs)
        self.number_of_synchronous_read_replicas = number_of_synchronous_read_replicas
        self.number_of_synchronous_non_read_replicas = number_of_synchronous_non_read_replicas
        self.number_of_asynchronous_read_replicas = number_of_asynchronous_read_replicas
        self.number_of_asynchronous_non_read_replicas = number_of_asynchronous_non_read_replicas
        self.number_of_primary_replicas = number_of_primary_replicas


class SqlCollector(ProxyResource):
    """The SQL collector REST object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.CollectorPropertiesBaseWithAgent
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "CollectorPropertiesBaseWithAgent"},
    }

    def __init__(
        self, *, properties: Optional["_models.CollectorPropertiesBaseWithAgent"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.CollectorPropertiesBaseWithAgent
        """
        super().__init__(**kwargs)
        self.properties = properties


class SqlCollectorListResult(_serialization.Model):
    """The response of a SqlCollector list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The SqlCollector items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.SqlCollector]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlCollector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SqlCollector"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The SqlCollector items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.SqlCollector]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SqlDbSettings(_serialization.Model):
    """SQL database assessment settings.

    :ivar azure_sql_service_tier: Gets or sets the azure SQL service tier. Known values are:
     "Unknown", "Automatic", "GeneralPurpose", "BusinessCritical", and "HyperScale".
    :vartype azure_sql_service_tier: str or
     ~azure.mgmt.migrationassessment.models.AzureSqlServiceTier
    :ivar azure_sql_data_base_type: Gets or sets the azure PAAS SQL instance type. Known values
     are: "Unknown", "Automatic", "SingleDatabase", and "ElasticPool".
    :vartype azure_sql_data_base_type: str or
     ~azure.mgmt.migrationassessment.models.AzureSqlDataBaseType
    :ivar azure_sql_compute_tier: Gets or sets the azure SQL compute tier. Known values are:
     "Unknown", "Automatic", "Provisioned", and "Serverless".
    :vartype azure_sql_compute_tier: str or ~azure.mgmt.migrationassessment.models.ComputeTier
    :ivar azure_sql_purchase_model: Gets or sets the azure SQL purchase model. Known values are:
     "Unknown", "VCore", and "DTU".
    :vartype azure_sql_purchase_model: str or
     ~azure.mgmt.migrationassessment.models.AzureSqlPurchaseModel
    """

    _attribute_map = {
        "azure_sql_service_tier": {"key": "azureSqlServiceTier", "type": "str"},
        "azure_sql_data_base_type": {"key": "azureSqlDataBaseType", "type": "str"},
        "azure_sql_compute_tier": {"key": "azureSqlComputeTier", "type": "str"},
        "azure_sql_purchase_model": {"key": "azureSqlPurchaseModel", "type": "str"},
    }

    def __init__(
        self,
        *,
        azure_sql_service_tier: Optional[Union[str, "_models.AzureSqlServiceTier"]] = None,
        azure_sql_data_base_type: Optional[Union[str, "_models.AzureSqlDataBaseType"]] = None,
        azure_sql_compute_tier: Optional[Union[str, "_models.ComputeTier"]] = None,
        azure_sql_purchase_model: Optional[Union[str, "_models.AzureSqlPurchaseModel"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_sql_service_tier: Gets or sets the azure SQL service tier. Known values are:
         "Unknown", "Automatic", "GeneralPurpose", "BusinessCritical", and "HyperScale".
        :paramtype azure_sql_service_tier: str or
         ~azure.mgmt.migrationassessment.models.AzureSqlServiceTier
        :keyword azure_sql_data_base_type: Gets or sets the azure PAAS SQL instance type. Known values
         are: "Unknown", "Automatic", "SingleDatabase", and "ElasticPool".
        :paramtype azure_sql_data_base_type: str or
         ~azure.mgmt.migrationassessment.models.AzureSqlDataBaseType
        :keyword azure_sql_compute_tier: Gets or sets the azure SQL compute tier. Known values are:
         "Unknown", "Automatic", "Provisioned", and "Serverless".
        :paramtype azure_sql_compute_tier: str or ~azure.mgmt.migrationassessment.models.ComputeTier
        :keyword azure_sql_purchase_model: Gets or sets the azure SQL purchase model. Known values are:
         "Unknown", "VCore", and "DTU".
        :paramtype azure_sql_purchase_model: str or
         ~azure.mgmt.migrationassessment.models.AzureSqlPurchaseModel
        """
        super().__init__(**kwargs)
        self.azure_sql_service_tier = azure_sql_service_tier
        self.azure_sql_data_base_type = azure_sql_data_base_type
        self.azure_sql_compute_tier = azure_sql_compute_tier
        self.azure_sql_purchase_model = azure_sql_purchase_model


class SqlFCIMetadata(_serialization.Model):
    """Sql fci meta data.

    :ivar state: Gets the Sql fci meta data state. Known values are: "Unknown", "Inherited",
     "Initializing", "Online", "Offline", "Failed", "Pending", "OnlinePending", and
     "OfflinePending".
    :vartype state: str or ~azure.mgmt.migrationassessment.models.SqlFCIMetadataState
    :ivar is_multi_subnet: Gets whether fci is multi subnet.
    :vartype is_multi_subnet: bool
    :ivar fci_shared_disk_count: Gets the fci shared disk count.
    :vartype fci_shared_disk_count: int
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "is_multi_subnet": {"key": "isMultiSubnet", "type": "bool"},
        "fci_shared_disk_count": {"key": "fciSharedDiskCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.SqlFCIMetadataState"]] = None,
        is_multi_subnet: Optional[bool] = None,
        fci_shared_disk_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Gets the Sql fci meta data state. Known values are: "Unknown", "Inherited",
         "Initializing", "Online", "Offline", "Failed", "Pending", "OnlinePending", and
         "OfflinePending".
        :paramtype state: str or ~azure.mgmt.migrationassessment.models.SqlFCIMetadataState
        :keyword is_multi_subnet: Gets whether fci is multi subnet.
        :paramtype is_multi_subnet: bool
        :keyword fci_shared_disk_count: Gets the fci shared disk count.
        :paramtype fci_shared_disk_count: int
        """
        super().__init__(**kwargs)
        self.state = state
        self.is_multi_subnet = is_multi_subnet
        self.fci_shared_disk_count = fci_shared_disk_count


class SqlMigrationGuideline(_serialization.Model):
    """Sql Migration Guideline.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar guideline_id: Gets the guideline id.
    :vartype guideline_id: str
    :ivar migration_guideline_category: Gets the migration guideline category. Known values are:
     "Unknown", "General", "FailoverCluterInstanceGuideLine", and "AvailabilityGroupGuideline".
    :vartype migration_guideline_category: str or
     ~azure.mgmt.migrationassessment.models.SqlMigrationGuidelineCategory
    :ivar migration_guideline_context: Gets the migration guideline context.
    :vartype migration_guideline_context:
     list[~azure.mgmt.migrationassessment.models.MigrationGuidelineContext]
    """

    _validation = {
        "migration_guideline_context": {"readonly": True},
    }

    _attribute_map = {
        "guideline_id": {"key": "guidelineId", "type": "str"},
        "migration_guideline_category": {"key": "migrationGuidelineCategory", "type": "str"},
        "migration_guideline_context": {"key": "migrationGuidelineContext", "type": "[MigrationGuidelineContext]"},
    }

    def __init__(
        self,
        *,
        guideline_id: Optional[str] = None,
        migration_guideline_category: Optional[Union[str, "_models.SqlMigrationGuidelineCategory"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword guideline_id: Gets the guideline id.
        :paramtype guideline_id: str
        :keyword migration_guideline_category: Gets the migration guideline category. Known values are:
         "Unknown", "General", "FailoverCluterInstanceGuideLine", and "AvailabilityGroupGuideline".
        :paramtype migration_guideline_category: str or
         ~azure.mgmt.migrationassessment.models.SqlMigrationGuidelineCategory
        """
        super().__init__(**kwargs)
        self.guideline_id = guideline_id
        self.migration_guideline_category = migration_guideline_category
        self.migration_guideline_context = None


class SqlMiSettings(_serialization.Model):
    """SQL managed instance assessment settings.

    :ivar azure_sql_service_tier: Gets or sets the azure SQL service tier. Known values are:
     "Unknown", "Automatic", "GeneralPurpose", "BusinessCritical", and "HyperScale".
    :vartype azure_sql_service_tier: str or
     ~azure.mgmt.migrationassessment.models.AzureSqlServiceTier
    :ivar azure_sql_instance_type: Gets or sets the azure PAAS SQL instance type. Known values are:
     "Unknown", "Automatic", "SingleInstance", and "InstancePools".
    :vartype azure_sql_instance_type: str or
     ~azure.mgmt.migrationassessment.models.AzureSqlInstanceType
    """

    _attribute_map = {
        "azure_sql_service_tier": {"key": "azureSqlServiceTier", "type": "str"},
        "azure_sql_instance_type": {"key": "azureSqlInstanceType", "type": "str"},
    }

    def __init__(
        self,
        *,
        azure_sql_service_tier: Optional[Union[str, "_models.AzureSqlServiceTier"]] = None,
        azure_sql_instance_type: Optional[Union[str, "_models.AzureSqlInstanceType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_sql_service_tier: Gets or sets the azure SQL service tier. Known values are:
         "Unknown", "Automatic", "GeneralPurpose", "BusinessCritical", and "HyperScale".
        :paramtype azure_sql_service_tier: str or
         ~azure.mgmt.migrationassessment.models.AzureSqlServiceTier
        :keyword azure_sql_instance_type: Gets or sets the azure PAAS SQL instance type. Known values
         are: "Unknown", "Automatic", "SingleInstance", and "InstancePools".
        :paramtype azure_sql_instance_type: str or
         ~azure.mgmt.migrationassessment.models.AzureSqlInstanceType
        """
        super().__init__(**kwargs)
        self.azure_sql_service_tier = azure_sql_service_tier
        self.azure_sql_instance_type = azure_sql_instance_type


class SqlPaaSTargetOptions(_serialization.Model):
    """SQL target options.

    :ivar compute_tier: Gets or sets the Azure SQL compute tier. Known values are: "Unknown",
     "Automatic", "Provisioned", and "Serverless".
    :vartype compute_tier: str or ~azure.mgmt.migrationassessment.models.ComputeTier
    :ivar hardware_generation: Gets or sets the Azure SQL hardware generation. Known values are:
     "Unknown", "Automatic", "Gen5", "Fsv2_series", "M_series", and "DC_series".
    :vartype hardware_generation: str or ~azure.mgmt.migrationassessment.models.HardwareGeneration
    :ivar target_type: Gets or sets the Azure SQL target type. Known values are: "Unknown",
     "Recommended", "AzureSqlDatabase", "AzureSqlManagedInstance", "AzureSqlVirtualMachine", and
     "AzureVirtualMachine".
    :vartype target_type: str or ~azure.mgmt.migrationassessment.models.TargetType
    :ivar service_tier: Gets or sets the Azure SQL service tier. Known values are: "Unknown",
     "Automatic", "GeneralPurpose", "BusinessCritical", and "HyperScale".
    :vartype service_tier: str or ~azure.mgmt.migrationassessment.models.AzureSqlServiceTier
    :ivar target_locations: Gets or sets the target location.
    :vartype target_locations: list[str or ~azure.mgmt.migrationassessment.models.AzureLocation]
    """

    _attribute_map = {
        "compute_tier": {"key": "computeTier", "type": "str"},
        "hardware_generation": {"key": "hardwareGeneration", "type": "str"},
        "target_type": {"key": "targetType", "type": "str"},
        "service_tier": {"key": "serviceTier", "type": "str"},
        "target_locations": {"key": "targetLocations", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        compute_tier: Optional[Union[str, "_models.ComputeTier"]] = None,
        hardware_generation: Optional[Union[str, "_models.HardwareGeneration"]] = None,
        target_type: Optional[Union[str, "_models.TargetType"]] = None,
        service_tier: Optional[Union[str, "_models.AzureSqlServiceTier"]] = None,
        target_locations: Optional[List[Union[str, "_models.AzureLocation"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword compute_tier: Gets or sets the Azure SQL compute tier. Known values are: "Unknown",
         "Automatic", "Provisioned", and "Serverless".
        :paramtype compute_tier: str or ~azure.mgmt.migrationassessment.models.ComputeTier
        :keyword hardware_generation: Gets or sets the Azure SQL hardware generation. Known values are:
         "Unknown", "Automatic", "Gen5", "Fsv2_series", "M_series", and "DC_series".
        :paramtype hardware_generation: str or
         ~azure.mgmt.migrationassessment.models.HardwareGeneration
        :keyword target_type: Gets or sets the Azure SQL target type. Known values are: "Unknown",
         "Recommended", "AzureSqlDatabase", "AzureSqlManagedInstance", "AzureSqlVirtualMachine", and
         "AzureVirtualMachine".
        :paramtype target_type: str or ~azure.mgmt.migrationassessment.models.TargetType
        :keyword service_tier: Gets or sets the Azure SQL service tier. Known values are: "Unknown",
         "Automatic", "GeneralPurpose", "BusinessCritical", and "HyperScale".
        :paramtype service_tier: str or ~azure.mgmt.migrationassessment.models.AzureSqlServiceTier
        :keyword target_locations: Gets or sets the target location.
        :paramtype target_locations: list[str or ~azure.mgmt.migrationassessment.models.AzureLocation]
        """
        super().__init__(**kwargs)
        self.compute_tier = compute_tier
        self.hardware_generation = hardware_generation
        self.target_type = target_type
        self.service_tier = service_tier
        self.target_locations = target_locations


class SqlRecommendationReasoning(_serialization.Model):
    """Class representing Azure SQL Recommendation Reasoning.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar reasoning_id: Gets the reasoning id.
    :vartype reasoning_id: str
    :ivar reasoning_string: Gets the reasoning status.
    :vartype reasoning_string: str
    :ivar reasoning_category: Gets the reasoning category.
    :vartype reasoning_category: str
    :ivar context_parameters: Gets the Sql recommended reasoning parameters.
    :vartype context_parameters:
     list[~azure.mgmt.migrationassessment.models.SqlRecommendationReasoningContext]
    """

    _validation = {
        "context_parameters": {"readonly": True},
    }

    _attribute_map = {
        "reasoning_id": {"key": "reasoningId", "type": "str"},
        "reasoning_string": {"key": "reasoningString", "type": "str"},
        "reasoning_category": {"key": "reasoningCategory", "type": "str"},
        "context_parameters": {"key": "contextParameters", "type": "[SqlRecommendationReasoningContext]"},
    }

    def __init__(
        self,
        *,
        reasoning_id: Optional[str] = None,
        reasoning_string: Optional[str] = None,
        reasoning_category: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword reasoning_id: Gets the reasoning id.
        :paramtype reasoning_id: str
        :keyword reasoning_string: Gets the reasoning status.
        :paramtype reasoning_string: str
        :keyword reasoning_category: Gets the reasoning category.
        :paramtype reasoning_category: str
        """
        super().__init__(**kwargs)
        self.reasoning_id = reasoning_id
        self.reasoning_string = reasoning_string
        self.reasoning_category = reasoning_category
        self.context_parameters = None


class SqlRecommendationReasoningContext(_serialization.Model):
    """Class representing Azure SQL Recommendation Reasoning Context.

    :ivar context_key: Gets the reasoning context key.
    :vartype context_key: str
    :ivar context_value: Gets the reasoning context value.
    :vartype context_value: str
    """

    _attribute_map = {
        "context_key": {"key": "contextKey", "type": "str"},
        "context_value": {"key": "contextValue", "type": "str"},
    }

    def __init__(
        self, *, context_key: Optional[str] = None, context_value: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword context_key: Gets the reasoning context key.
        :paramtype context_key: str
        :keyword context_value: Gets the reasoning context value.
        :paramtype context_value: str
        """
        super().__init__(**kwargs)
        self.context_key = context_key
        self.context_value = context_value


class SqlVmSettings(_serialization.Model):
    """SQL VM assessment settings.

    :ivar instance_series: Gets or sets the Azure VM families (calling instance series to keep it
     consistent with other targets).
    :vartype instance_series: list[str or ~azure.mgmt.migrationassessment.models.AzureVmFamily]
    """

    _attribute_map = {
        "instance_series": {"key": "instanceSeries", "type": "[str]"},
    }

    def __init__(
        self, *, instance_series: Optional[List[Union[str, "_models.AzureVmFamily"]]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword instance_series: Gets or sets the Azure VM families (calling instance series to keep
         it
         consistent with other targets).
        :paramtype instance_series: list[str or ~azure.mgmt.migrationassessment.models.AzureVmFamily]
        """
        super().__init__(**kwargs)
        self.instance_series = instance_series


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.migrationassessment.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.migrationassessment.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.migrationassessment.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.migrationassessment.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UltraDiskAssessmentOptions(_serialization.Model):
    """Assessment options for Ultra disk type.

    :ivar family_name: Family name.
    :vartype family_name: str
    :ivar target_locations: List of locations where ultra disk is supported for this VMfamily.
    :vartype target_locations: list[str]
    """

    _attribute_map = {
        "family_name": {"key": "familyName", "type": "str"},
        "target_locations": {"key": "targetLocations", "type": "[str]"},
    }

    def __init__(
        self, *, family_name: Optional[str] = None, target_locations: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword family_name: Family name.
        :paramtype family_name: str
        :keyword target_locations: List of locations where ultra disk is supported for this VMfamily.
        :paramtype target_locations: list[str]
        """
        super().__init__(**kwargs)
        self.family_name = family_name
        self.target_locations = target_locations


class UpdateGroupBody(_serialization.Model):
    """Properties of group update.

    :ivar e_tag: For optimistic concurrency control.
    :vartype e_tag: str
    :ivar properties: Properties of the group.
    :vartype properties: ~azure.mgmt.migrationassessment.models.GroupBodyProperties
    """

    _attribute_map = {
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "GroupBodyProperties"},
    }

    def __init__(
        self, *, e_tag: Optional[str] = None, properties: Optional["_models.GroupBodyProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword e_tag: For optimistic concurrency control.
        :paramtype e_tag: str
        :keyword properties: Properties of the group.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.GroupBodyProperties
        """
        super().__init__(**kwargs)
        self.e_tag = e_tag
        self.properties = properties


class VmFamilyOptions(_serialization.Model):
    """VM family name, the list of targeted azure locations and the category of the
    family.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar family_name: Name of the VM family.
    :vartype family_name: str
    :ivar target_locations: List of Azure regions.
    :vartype target_locations: list[str]
    :ivar category: Category of the VM family.
    :vartype category: list[str]
    """

    _validation = {
        "family_name": {"readonly": True},
        "target_locations": {"readonly": True},
        "category": {"readonly": True},
    }

    _attribute_map = {
        "family_name": {"key": "familyName", "type": "str"},
        "target_locations": {"key": "targetLocations", "type": "[str]"},
        "category": {"key": "category", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.family_name = None
        self.target_locations = None
        self.category = None


class VmUptime(_serialization.Model):
    """Details on the total up-time for the VM.

    :ivar days_per_month: Number of days in a month for VM uptime.
    :vartype days_per_month: int
    :ivar hours_per_day: Number of hours per day for VM uptime.
    :vartype hours_per_day: int
    """

    _attribute_map = {
        "days_per_month": {"key": "daysPerMonth", "type": "int"},
        "hours_per_day": {"key": "hoursPerDay", "type": "int"},
    }

    def __init__(
        self, *, days_per_month: Optional[int] = None, hours_per_day: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword days_per_month: Number of days in a month for VM uptime.
        :paramtype days_per_month: int
        :keyword hours_per_day: Number of hours per day for VM uptime.
        :paramtype hours_per_day: int
        """
        super().__init__(**kwargs)
        self.days_per_month = days_per_month
        self.hours_per_day = hours_per_day


class VmwareCollector(ProxyResource):
    """VMware collector resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.  # pylint: disable=line-too-long
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.migrationassessment.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.migrationassessment.models.CollectorPropertiesBaseWithAgent
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "CollectorPropertiesBaseWithAgent"},
    }

    def __init__(
        self, *, properties: Optional["_models.CollectorPropertiesBaseWithAgent"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: ~azure.mgmt.migrationassessment.models.CollectorPropertiesBaseWithAgent
        """
        super().__init__(**kwargs)
        self.properties = properties


class VmwareCollectorListResult(_serialization.Model):
    """The response of a VmwareCollector list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The VmwareCollector items on this page. Required.
    :vartype value: list[~azure.mgmt.migrationassessment.models.VmwareCollector]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[VmwareCollector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.VmwareCollector"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The VmwareCollector items on this page. Required.
        :paramtype value: list[~azure.mgmt.migrationassessment.models.VmwareCollector]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WorkloadSummary(_serialization.Model):
    """Workload summary.

    :ivar oracle_instances: Gets or sets oracle databases.
    :vartype oracle_instances: int
    :ivar spring_apps: Gets or sets oracle databases.
    :vartype spring_apps: int
    """

    _attribute_map = {
        "oracle_instances": {"key": "oracleInstances", "type": "int"},
        "spring_apps": {"key": "springApps", "type": "int"},
    }

    def __init__(
        self, *, oracle_instances: Optional[int] = None, spring_apps: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword oracle_instances: Gets or sets oracle databases.
        :paramtype oracle_instances: int
        :keyword spring_apps: Gets or sets oracle databases.
        :paramtype spring_apps: int
        """
        super().__init__(**kwargs)
        self.oracle_instances = oracle_instances
        self.spring_apps = spring_apps
