# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.mysqlflexibleservers.aio import MySQLManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMySQLManagementAdvancedThreatProtectionSettingsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MySQLManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_advanced_threat_protection_settings_list(self, resource_group):
        response = self.client.advanced_threat_protection_settings.list(
            resource_group_name=resource_group.name,
            server_name="str",
            api_version="2025-06-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_advanced_threat_protection_settings_get(self, resource_group):
        response = await self.client.advanced_threat_protection_settings.get(
            resource_group_name=resource_group.name,
            server_name="str",
            advanced_threat_protection_name="str",
            api_version="2025-06-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_advanced_threat_protection_settings_begin_update_put(self, resource_group):
        response = await (
            await self.client.advanced_threat_protection_settings.begin_update_put(
                resource_group_name=resource_group.name,
                server_name="str",
                advanced_threat_protection_name="str",
                parameters={
                    "creationTime": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "provisioningState": "str",
                    "state": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2025-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_advanced_threat_protection_settings_begin_update(self, resource_group):
        response = await (
            await self.client.advanced_threat_protection_settings.begin_update(
                resource_group_name=resource_group.name,
                server_name="str",
                advanced_threat_protection_name="str",
                parameters={"state": "str"},
                api_version="2025-06-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
