# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class ApplicationProperties(_model_base.Model):
    """Details about the Application that would use the Operator's Network APIs.

    :ivar name: Name of the application. Example: Contoso App.
    :vartype name: str
    :ivar application_description: Description of the application.
    :vartype application_description: str
    :ivar application_type: The category that describes the application.
    :vartype application_type: str
    :ivar legal_name: Legal name of the organization owning the application.
    :vartype legal_name: str
    :ivar organization_description: A description of the organization owning the application.
    :vartype organization_description: str
    :ivar tax_number: Unique Tax Number for the user's organization in the country/region the APC
     Gateway is being purchased.
    :vartype tax_number: str
    :ivar privacy_contact_email_address: Email address of the Privacy contact or Data Protection
     officer of the organization.
    :vartype privacy_contact_email_address: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the application. Example: Contoso App."""
    application_description: Optional[str] = rest_field(
        name="applicationDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """Description of the application."""
    application_type: Optional[str] = rest_field(
        name="applicationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The category that describes the application."""
    legal_name: Optional[str] = rest_field(name="legalName", visibility=["read", "create", "update", "delete", "query"])
    """Legal name of the organization owning the application."""
    organization_description: Optional[str] = rest_field(
        name="organizationDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """A description of the organization owning the application."""
    tax_number: Optional[str] = rest_field(name="taxNumber", visibility=["read", "create", "update", "delete", "query"])
    """Unique Tax Number for the user's organization in the country/region the APC Gateway is being
     purchased."""
    privacy_contact_email_address: Optional[str] = rest_field(
        name="privacyContactEmailAddress", visibility=["read", "create", "update", "delete", "query"]
    )
    """Email address of the Privacy contact or Data Protection officer of the organization."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        application_description: Optional[str] = None,
        application_type: Optional[str] = None,
        legal_name: Optional[str] = None,
        organization_description: Optional[str] = None,
        tax_number: Optional[str] = None,
        privacy_contact_email_address: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.programmableconnectivity.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.programmableconnectivity.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.programmableconnectivity.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.programmableconnectivity.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.programmableconnectivity.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Gateway(TrackedResource):
    """A Programmable Connectivity Gateway resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.programmableconnectivity.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.programmableconnectivity.models.GatewayProperties
    """

    properties: Optional["_models.GatewayProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.GatewayProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class GatewayProperties(_model_base.Model):
    """Gateway resource properties.

    :ivar operator_api_connections: List of Operator API Connections selected by the user.
    :vartype operator_api_connections: list[str]
    :ivar gateway_base_url: Base URL of the Gateway resource. This is the URL that the users would
     use to make Open API Gateway requests to the Operators via Azure.
    :vartype gateway_base_url: str
    :ivar provisioning_state: The status of the last operation on the Gateway resource. Known
     values are: "Succeeded", "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and
     "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.programmableconnectivity.models.ProvisioningState
    """

    operator_api_connections: Optional[List[str]] = rest_field(name="operatorApiConnections", visibility=["read"])
    """List of Operator API Connections selected by the user."""
    gateway_base_url: Optional[str] = rest_field(name="gatewayBaseUrl", visibility=["read"])
    """Base URL of the Gateway resource. This is the URL that the users would use to make Open API
     Gateway requests to the Operators via Azure."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation on the Gateway resource. Known values are: \"Succeeded\",
     \"Failed\", \"Canceled\", \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""


class GatewayTagsUpdate(_model_base.Model):
    """The type used for updating tags in Gateway resources.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MarketplaceProperties(_model_base.Model):
    """Azure marketplace properties for a plan.

    :ivar offer_id: Azure marketplace Offer ID for this plan.
    :vartype offer_id: str
    :ivar legacy_offer_id: Azure marketplace Legacy Offer ID for this plan. This is used to fetch
     the details of the plan from the Azure marketplace.
    :vartype legacy_offer_id: str
    :ivar publisher_id: Azure marketplace Publisher ID for this plan.
    :vartype publisher_id: str
    :ivar plan_id: Azure marketplace Plan ID for this plan.
    :vartype plan_id: str
    :ivar term_id: Azure marketplace Term ID for this plan.
    :vartype term_id: str
    """

    offer_id: Optional[str] = rest_field(name="offerId", visibility=["read", "create", "update", "delete", "query"])
    """Azure marketplace Offer ID for this plan."""
    legacy_offer_id: Optional[str] = rest_field(
        name="legacyOfferId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure marketplace Legacy Offer ID for this plan. This is used to fetch the details of the plan
     from the Azure marketplace."""
    publisher_id: Optional[str] = rest_field(
        name="publisherId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure marketplace Publisher ID for this plan."""
    plan_id: Optional[str] = rest_field(name="planId", visibility=["read", "create", "update", "delete", "query"])
    """Azure marketplace Plan ID for this plan."""
    term_id: Optional[str] = rest_field(name="termId", visibility=["read", "create", "update", "delete", "query"])
    """Azure marketplace Term ID for this plan."""

    @overload
    def __init__(
        self,
        *,
        offer_id: Optional[str] = None,
        legacy_offer_id: Optional[str] = None,
        publisher_id: Optional[str] = None,
        plan_id: Optional[str] = None,
        term_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.programmableconnectivity.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.programmableconnectivity.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.programmableconnectivity.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class OperatorApiConnection(TrackedResource):
    """A Programmable Connectivity Operator API Connection resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.programmableconnectivity.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.programmableconnectivity.models.OperatorApiConnectionProperties
    """

    properties: Optional["_models.OperatorApiConnectionProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.OperatorApiConnectionProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperatorApiConnectionProperties(_model_base.Model):
    """Operator API Connection resource properties that cannot be updated once a resource has been
    created.

    :ivar operator_api_plan_id: Reference to the Operator API Plan Resource ID. Required.
    :vartype operator_api_plan_id: str
    :ivar saas_properties: Details about the SaaS offer purchased from the marketplace.
    :vartype saas_properties: ~azure.mgmt.programmableconnectivity.models.SaasProperties
    :ivar configured_application: Details about the Application that would use the Operator's
     Network APIs.
    :vartype configured_application:
     ~azure.mgmt.programmableconnectivity.models.ApplicationProperties
    :ivar app_id: Application ID of the App Developer that is registered with the Operator in a
     specific country/region.
    :vartype app_id: str
    :ivar gateway_id: Reference to the APC Gateway resource ID. Required.
    :vartype gateway_id: str
    :ivar account_type: Type of the account the user has with the Operator's Network API
     infrastructure. AzureManaged | UserManaged. Required. Known values are: "AzureManaged" and
     "UserManaged".
    :vartype account_type: str or ~azure.mgmt.programmableconnectivity.models.AccountType
    :ivar app_secret: Application secret linked to the 'appId'. This should be stored securely and
     is not returned back when the resource information is read.
    :vartype app_secret: str
    :ivar operator_name: Name of the Operator in the linked Operator API Plan belongs to.
    :vartype operator_name: str
    :ivar camara_api_name: The Network API for the current operator in the country/region provided
     in the linked Operator API Plan.
    :vartype camara_api_name: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.programmableconnectivity.models.ProvisioningState
    :ivar status: The status of the OperatorApiConnection resource.
    :vartype status: ~azure.mgmt.programmableconnectivity.models.Status
    """

    operator_api_plan_id: str = rest_field(name="operatorApiPlanId", visibility=["read", "create", "update"])
    """Reference to the Operator API Plan Resource ID. Required."""
    saas_properties: Optional["_models.SaasProperties"] = rest_field(
        name="saasProperties", visibility=["read", "create", "update"]
    )
    """Details about the SaaS offer purchased from the marketplace."""
    configured_application: Optional["_models.ApplicationProperties"] = rest_field(
        name="configuredApplication", visibility=["read", "create", "update"]
    )
    """Details about the Application that would use the Operator's Network APIs."""
    app_id: Optional[str] = rest_field(name="appId", visibility=["read", "create", "update"])
    """Application ID of the App Developer that is registered with the Operator in a specific
     country/region."""
    gateway_id: str = rest_field(name="gatewayId", visibility=["read", "create"])
    """Reference to the APC Gateway resource ID. Required."""
    account_type: Union[str, "_models.AccountType"] = rest_field(name="accountType", visibility=["read", "create"])
    """Type of the account the user has with the Operator's Network API infrastructure. AzureManaged |
     UserManaged. Required. Known values are: \"AzureManaged\" and \"UserManaged\"."""
    app_secret: Optional[str] = rest_field(name="appSecret", visibility=["create", "update"])
    """Application secret linked to the 'appId'. This should be stored securely and is not returned
     back when the resource information is read."""
    operator_name: Optional[str] = rest_field(name="operatorName", visibility=["read"])
    """Name of the Operator in the linked Operator API Plan belongs to."""
    camara_api_name: Optional[str] = rest_field(name="camaraApiName", visibility=["read"])
    """The Network API for the current operator in the country/region provided in the linked Operator
     API Plan."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""
    status: Optional["_models.Status"] = rest_field(visibility=["read"])
    """The status of the OperatorApiConnection resource."""

    @overload
    def __init__(
        self,
        *,
        operator_api_plan_id: str,
        gateway_id: str,
        account_type: Union[str, "_models.AccountType"],
        saas_properties: Optional["_models.SaasProperties"] = None,
        configured_application: Optional["_models.ApplicationProperties"] = None,
        app_id: Optional[str] = None,
        app_secret: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperatorApiConnectionUpdate(_model_base.Model):
    """The type used for update operations of the OperatorApiConnection.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.programmableconnectivity.models.OperatorApiConnectionUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.OperatorApiConnectionUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.OperatorApiConnectionUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperatorApiConnectionUpdateProperties(_model_base.Model):
    """The updatable properties of the OperatorApiConnection.

    :ivar operator_api_plan_id: Reference to the Operator API Plan Resource ID.
    :vartype operator_api_plan_id: str
    :ivar saas_properties: Details about the SaaS offer purchased from the marketplace.
    :vartype saas_properties: ~azure.mgmt.programmableconnectivity.models.SaasProperties
    :ivar configured_application: Details about the Application that would use the Operator's
     Network APIs.
    :vartype configured_application:
     ~azure.mgmt.programmableconnectivity.models.ApplicationProperties
    :ivar app_id: Application ID of the App Developer that is registered with the Operator in a
     specific country/region.
    :vartype app_id: str
    :ivar app_secret: Application secret linked to the 'appId'. This should be stored securely and
     is not returned back when the resource information is read.
    :vartype app_secret: str
    """

    operator_api_plan_id: Optional[str] = rest_field(name="operatorApiPlanId", visibility=["read", "create", "update"])
    """Reference to the Operator API Plan Resource ID."""
    saas_properties: Optional["_models.SaasProperties"] = rest_field(
        name="saasProperties", visibility=["read", "create", "update"]
    )
    """Details about the SaaS offer purchased from the marketplace."""
    configured_application: Optional["_models.ApplicationProperties"] = rest_field(
        name="configuredApplication", visibility=["read", "create", "update"]
    )
    """Details about the Application that would use the Operator's Network APIs."""
    app_id: Optional[str] = rest_field(name="appId", visibility=["read", "create", "update"])
    """Application ID of the App Developer that is registered with the Operator in a specific
     country/region."""
    app_secret: Optional[str] = rest_field(name="appSecret", visibility=["create", "update"])
    """Application secret linked to the 'appId'. This should be stored securely and is not returned
     back when the resource information is read."""

    @overload
    def __init__(
        self,
        *,
        operator_api_plan_id: Optional[str] = None,
        saas_properties: Optional["_models.SaasProperties"] = None,
        configured_application: Optional["_models.ApplicationProperties"] = None,
        app_id: Optional[str] = None,
        app_secret: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.programmableconnectivity.models.SystemData
    """


class OperatorApiPlan(ProxyResource):
    """A Programmable Connectivity Operator API Plans resource. This is a readonly resource that
    indicates which Operator Network APIs are available in the user's subscription.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.programmableconnectivity.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.programmableconnectivity.models.OperatorApiPlanProperties
    """

    properties: Optional["_models.OperatorApiPlanProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.OperatorApiPlanProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperatorApiPlanProperties(_model_base.Model):
    """Operator API Plan properties.

    :ivar operator_name: Name of the Operator this plan belongs to.
    :vartype operator_name: str
    :ivar camara_api_name: Standardized Network API name defined by CAMARA specifications.
    :vartype camara_api_name: str
    :ivar supported_locations: List of Azure regions where this offer is supported.
    :vartype supported_locations: list[str]
    :ivar operator_regions: List of country/region names where this plan is being supported by the
     Operator.
    :vartype operator_regions: list[str]
    :ivar markets: List of country/region names where this plan is being supported by Azure
     Marketplace.
    :vartype markets: list[str]
    :ivar limits: The limits, if any, will be imposed by the operator.
    :vartype limits: str
    :ivar marketplace_properties: Azure marketplace properties for this plan.
    :vartype marketplace_properties:
     ~azure.mgmt.programmableconnectivity.models.MarketplaceProperties
    :ivar provisioning_state: The status of the last operation on the Gateway resource. Known
     values are: "Succeeded", "Failed", "Canceled", "Provisioning", "Updating", "Deleting", and
     "Accepted".
    :vartype provisioning_state: str or
     ~azure.mgmt.programmableconnectivity.models.ProvisioningState
    """

    operator_name: Optional[str] = rest_field(
        name="operatorName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the Operator this plan belongs to."""
    camara_api_name: Optional[str] = rest_field(
        name="camaraApiName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Standardized Network API name defined by CAMARA specifications."""
    supported_locations: Optional[List[str]] = rest_field(
        name="supportedLocations", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of Azure regions where this offer is supported."""
    operator_regions: Optional[List[str]] = rest_field(
        name="operatorRegions", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of country/region names where this plan is being supported by the Operator."""
    markets: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of country/region names where this plan is being supported by Azure Marketplace."""
    limits: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The limits, if any, will be imposed by the operator."""
    marketplace_properties: Optional["_models.MarketplaceProperties"] = rest_field(
        name="marketplaceProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure marketplace properties for this plan."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation on the Gateway resource. Known values are: \"Succeeded\",
     \"Failed\", \"Canceled\", \"Provisioning\", \"Updating\", \"Deleting\", and \"Accepted\"."""

    @overload
    def __init__(
        self,
        *,
        operator_name: Optional[str] = None,
        camara_api_name: Optional[str] = None,
        supported_locations: Optional[List[str]] = None,
        operator_regions: Optional[List[str]] = None,
        markets: Optional[List[str]] = None,
        limits: Optional[str] = None,
        marketplace_properties: Optional["_models.MarketplaceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SaasProperties(_model_base.Model):
    """Details about the SaaS offer purchased from the marketplace.

    :ivar saas_subscription_id: Subscription ID of the SaaS offer purchased from the marketplace.
    :vartype saas_subscription_id: str
    :ivar saas_resource_id: Resource ID of the SaaS offer purchased from the marketplace.
    :vartype saas_resource_id: str
    """

    saas_subscription_id: Optional[str] = rest_field(
        name="saasSubscriptionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Subscription ID of the SaaS offer purchased from the marketplace."""
    saas_resource_id: Optional[str] = rest_field(
        name="saasResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource ID of the SaaS offer purchased from the marketplace."""

    @overload
    def __init__(
        self,
        *,
        saas_subscription_id: Optional[str] = None,
        saas_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Status(_model_base.Model):
    """Description of the current status of the OperatorApiConnection resource.

    :ivar state: Current state of the OperatorApiConnection resource.
    :vartype state: str
    :ivar reason: Explanation of the current state of the OperatorApiConnection resource.
    :vartype reason: str
    """

    state: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Current state of the OperatorApiConnection resource."""
    reason: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Explanation of the current state of the OperatorApiConnection resource."""

    @overload
    def __init__(
        self,
        *,
        state: Optional[str] = None,
        reason: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.programmableconnectivity.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.programmableconnectivity.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
