# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicesdatareplication import RecoveryServicesDataReplicationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestRecoveryServicesDataReplicationMgmtPrivateEndpointConnectionProxiesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(RecoveryServicesDataReplicationMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connection_proxies_get(self, resource_group):
        response = self.client.private_endpoint_connection_proxies.get(
            resource_group_name=resource_group.name,
            vault_name="str",
            private_endpoint_connection_proxy_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connection_proxies_create(self, resource_group):
        response = self.client.private_endpoint_connection_proxies.create(
            resource_group_name=resource_group.name,
            vault_name="str",
            private_endpoint_connection_proxy_name="str",
            resource={
                "etag": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "provisioningState": "str",
                    "remotePrivateEndpoint": {
                        "id": "str",
                        "connectionDetails": [
                            {
                                "groupId": "str",
                                "id": "str",
                                "linkIdentifier": "str",
                                "memberName": "str",
                                "privateIpAddress": "str",
                            }
                        ],
                        "manualPrivateLinkServiceConnections": [
                            {"groupIds": ["str"], "name": "str", "requestMessage": "str"}
                        ],
                        "privateLinkServiceConnections": [
                            {"groupIds": ["str"], "name": "str", "requestMessage": "str"}
                        ],
                        "privateLinkServiceProxies": [
                            {
                                "groupConnectivityInformation": [
                                    {
                                        "customerVisibleFqdns": ["str"],
                                        "groupId": "str",
                                        "internalFqdn": "str",
                                        "memberName": "str",
                                        "privateLinkServiceArmRegion": "str",
                                        "redirectMapId": "str",
                                    }
                                ],
                                "id": "str",
                                "remotePrivateEndpointConnection": {"id": "str"},
                                "remotePrivateLinkServiceConnectionState": {
                                    "actionsRequired": "str",
                                    "description": "str",
                                    "status": "str",
                                },
                            }
                        ],
                    },
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connection_proxies_begin_delete(self, resource_group):
        response = self.client.private_endpoint_connection_proxies.begin_delete(
            resource_group_name=resource_group.name,
            vault_name="str",
            private_endpoint_connection_proxy_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connection_proxies_list(self, resource_group):
        response = self.client.private_endpoint_connection_proxies.list(
            resource_group_name=resource_group.name,
            vault_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_private_endpoint_connection_proxies_validate(self, resource_group):
        response = self.client.private_endpoint_connection_proxies.validate(
            resource_group_name=resource_group.name,
            vault_name="str",
            private_endpoint_connection_proxy_name="str",
            body={
                "etag": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "provisioningState": "str",
                    "remotePrivateEndpoint": {
                        "id": "str",
                        "connectionDetails": [
                            {
                                "groupId": "str",
                                "id": "str",
                                "linkIdentifier": "str",
                                "memberName": "str",
                                "privateIpAddress": "str",
                            }
                        ],
                        "manualPrivateLinkServiceConnections": [
                            {"groupIds": ["str"], "name": "str", "requestMessage": "str"}
                        ],
                        "privateLinkServiceConnections": [
                            {"groupIds": ["str"], "name": "str", "requestMessage": "str"}
                        ],
                        "privateLinkServiceProxies": [
                            {
                                "groupConnectivityInformation": [
                                    {
                                        "customerVisibleFqdns": ["str"],
                                        "groupId": "str",
                                        "internalFqdn": "str",
                                        "memberName": "str",
                                        "privateLinkServiceArmRegion": "str",
                                        "redirectMapId": "str",
                                    }
                                ],
                                "id": "str",
                                "remotePrivateEndpointConnection": {"id": "str"},
                                "remotePrivateLinkServiceConnectionState": {
                                    "actionsRequired": "str",
                                    "description": "str",
                                    "status": "str",
                                },
                            }
                        ],
                    },
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...
