# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, Optional, TypeVar

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._azure_reservation_api_operations import (
    build_get_applied_reservation_list_request,
    build_get_catalog_request,
)
from .._vendor import AzureReservationAPIMixinABC

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AzureReservationAPIOperationsMixin(AzureReservationAPIMixinABC):
    @distributed_trace
    def get_catalog(
        self,
        subscription_id: str,
        reserved_resource_type: Optional[str] = None,
        location: Optional[str] = None,
        publisher_id: Optional[str] = None,
        offer_id: Optional[str] = None,
        plan_id: Optional[str] = None,
        filter: Optional[str] = None,
        skip: Optional[float] = None,
        take: Optional[float] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.Catalog"]:
        """Get the regions and skus that are available for RI purchase for the specified Azure
        subscription.

        Get the regions and skus that are available for RI purchase for the specified Azure
        subscription.

        :param subscription_id: Id of the subscription. Required.
        :type subscription_id: str
        :param reserved_resource_type: The type of the resource for which the skus should be provided.
         Default value is None.
        :type reserved_resource_type: str
        :param location: Filters the skus based on the location specified in this parameter. This can
         be an Azure region or global. Default value is None.
        :type location: str
        :param publisher_id: Publisher id used to get the third party products. Default value is None.
        :type publisher_id: str
        :param offer_id: Offer id used to get the third party products. Default value is None.
        :type offer_id: str
        :param plan_id: Plan id used to get the third party products. Default value is None.
        :type plan_id: str
        :param filter: May be used to filter by Catalog properties. The filter supports 'eq', 'or', and
         'and'. Default value is None.
        :type filter: str
        :param skip: The number of reservations to skip from the list before returning results. Default
         value is None.
        :type skip: float
        :param take: To number of reservations to return. Default value is None.
        :type take: float
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Catalog or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.reservations.models.Catalog]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-11-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-11-01"))
        cls: ClsType[_models.CatalogsResult] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_get_catalog_request(
                    subscription_id=subscription_id,
                    reserved_resource_type=reserved_resource_type,
                    location=location,
                    publisher_id=publisher_id,
                    offer_id=offer_id,
                    plan_id=plan_id,
                    filter=filter,
                    skip=skip,
                    take=take,
                    api_version=api_version,
                    template_url=self.get_catalog.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                request = HttpRequest("GET", next_link)
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("CatalogsResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    get_catalog.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/catalogs"}

    @distributed_trace_async
    async def get_applied_reservation_list(self, subscription_id: str, **kwargs: Any) -> _models.AppliedReservations:
        """Get list of applicable ``Reservation``\ s.

        Get applicable ``Reservation``\ s that are applied to this subscription or a resource group
        under this subscription.

        :param subscription_id: Id of the subscription. Required.
        :type subscription_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AppliedReservations or the result of cls(response)
        :rtype: ~azure.mgmt.reservations.models.AppliedReservations
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-11-01"] = kwargs.pop("api_version", _params.pop("api-version", "2022-11-01"))
        cls: ClsType[_models.AppliedReservations] = kwargs.pop("cls", None)

        request = build_get_applied_reservation_list_request(
            subscription_id=subscription_id,
            api_version=api_version,
            template_url=self.get_applied_reservation_list.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.Error, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AppliedReservations", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_applied_reservation_list.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.Capacity/appliedReservations"
    }
