# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._defender_for_storage_operations import (
    build_cancel_malware_scan_request,
    build_create_request,
    build_get_malware_scan_request,
    build_get_request,
    build_start_malware_scan_request,
)
from .._configuration import SecurityCenterConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class DefenderForStorageOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.security.aio.SecurityCenter`'s
        :attr:`defender_for_storage` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: SecurityCenterConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, resource_id: str, setting_name: Union[str, _models.SettingName], **kwargs: Any
    ) -> _models.DefenderForStorageSetting:
        """Gets the Defender for Storage settings for the specified storage account.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param setting_name: Defender for Storage setting name. "current" Required.
        :type setting_name: str or ~azure.mgmt.security.models.SettingName
        :return: DefenderForStorageSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.DefenderForStorageSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-02-01-preview"))
        cls: ClsType[_models.DefenderForStorageSetting] = kwargs.pop("cls", None)

        _request = build_get_request(
            resource_id=resource_id,
            setting_name=setting_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DefenderForStorageSetting", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create(
        self,
        resource_id: str,
        setting_name: Union[str, _models.SettingName],
        defender_for_storage_setting: _models.DefenderForStorageSetting,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DefenderForStorageSetting:
        """Creates or updates the Defender for Storage settings on a specified storage account.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param setting_name: Defender for Storage setting name. "current" Required.
        :type setting_name: str or ~azure.mgmt.security.models.SettingName
        :param defender_for_storage_setting: Defender for Storage Settings. Required.
        :type defender_for_storage_setting: ~azure.mgmt.security.models.DefenderForStorageSetting
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DefenderForStorageSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.DefenderForStorageSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_id: str,
        setting_name: Union[str, _models.SettingName],
        defender_for_storage_setting: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DefenderForStorageSetting:
        """Creates or updates the Defender for Storage settings on a specified storage account.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param setting_name: Defender for Storage setting name. "current" Required.
        :type setting_name: str or ~azure.mgmt.security.models.SettingName
        :param defender_for_storage_setting: Defender for Storage Settings. Required.
        :type defender_for_storage_setting: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DefenderForStorageSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.DefenderForStorageSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        resource_id: str,
        setting_name: Union[str, _models.SettingName],
        defender_for_storage_setting: Union[_models.DefenderForStorageSetting, IO[bytes]],
        **kwargs: Any
    ) -> _models.DefenderForStorageSetting:
        """Creates or updates the Defender for Storage settings on a specified storage account.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param setting_name: Defender for Storage setting name. "current" Required.
        :type setting_name: str or ~azure.mgmt.security.models.SettingName
        :param defender_for_storage_setting: Defender for Storage Settings. Is either a
         DefenderForStorageSetting type or a IO[bytes] type. Required.
        :type defender_for_storage_setting: ~azure.mgmt.security.models.DefenderForStorageSetting or
         IO[bytes]
        :return: DefenderForStorageSetting or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.DefenderForStorageSetting
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-02-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DefenderForStorageSetting] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(defender_for_storage_setting, (IOBase, bytes)):
            _content = defender_for_storage_setting
        else:
            _json = self._serialize.body(defender_for_storage_setting, "DefenderForStorageSetting")

        _request = build_create_request(
            resource_id=resource_id,
            setting_name=setting_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DefenderForStorageSetting", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def start_malware_scan(
        self, resource_id: str, setting_name: Union[str, _models.SettingName], **kwargs: Any
    ) -> _models.MalwareScan:
        """Initiate a Defender for Storage malware scan for the specified storage account.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param setting_name: Defender for Storage setting name. "current" Required.
        :type setting_name: str or ~azure.mgmt.security.models.SettingName
        :return: MalwareScan or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.MalwareScan
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-02-01-preview"))
        cls: ClsType[_models.MalwareScan] = kwargs.pop("cls", None)

        _request = build_start_malware_scan_request(
            resource_id=resource_id,
            setting_name=setting_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MalwareScan", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def cancel_malware_scan(
        self, resource_id: str, setting_name: Union[str, _models.SettingName], scan_id: str, **kwargs: Any
    ) -> _models.MalwareScan:
        """Cancels a Defender for Storage malware scan for the specified storage account.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param setting_name: Defender for Storage setting name. "current" Required.
        :type setting_name: str or ~azure.mgmt.security.models.SettingName
        :param scan_id: The identifier of the scan. Can be either 'latest' or a GUID. Required.
        :type scan_id: str
        :return: MalwareScan or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.MalwareScan
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-02-01-preview"))
        cls: ClsType[_models.MalwareScan] = kwargs.pop("cls", None)

        _request = build_cancel_malware_scan_request(
            resource_id=resource_id,
            setting_name=setting_name,
            scan_id=scan_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MalwareScan", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_malware_scan(
        self, resource_id: str, setting_name: Union[str, _models.SettingName], scan_id: str, **kwargs: Any
    ) -> _models.MalwareScan:
        """Gets the Defender for Storage malware scan for the specified storage resource.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param setting_name: Defender for Storage setting name. "current" Required.
        :type setting_name: str or ~azure.mgmt.security.models.SettingName
        :param scan_id: The identifier of the scan. Can be either 'latest' or a GUID. Required.
        :type scan_id: str
        :return: MalwareScan or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.MalwareScan
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2025-02-01-preview"))
        cls: ClsType[_models.MalwareScan] = kwargs.pop("cls", None)

        _request = build_get_malware_scan_request(
            resource_id=resource_id,
            setting_name=setting_name,
            scan_id=scan_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("MalwareScan", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
