% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_to_bf.R
\name{p_to_bf}
\alias{p_to_bf}
\alias{p_to_bf.numeric}
\alias{p_to_bf.default}
\title{Convert p-values to (pseudo) Bayes Factors}
\usage{
p_to_bf(x, ...)

\method{p_to_bf}{numeric}(x, log = FALSE, n_obs = NULL, ...)

\method{p_to_bf}{default}(x, log = FALSE, ...)
}
\arguments{
\item{x}{A (frequentist) model object, or a (numeric) vector of p-values.}

\item{...}{Other arguments to be passed (not used for now).}

\item{log}{Wether to return log Bayes Factors. \strong{Note:} The \code{print()} method
always shows \code{BF} - the \code{"log_BF"} column is only accessible from the returned
data frame.}

\item{n_obs}{Number of observations. Either length 1, or same length as \code{p}.}
}
\value{
A data frame with the p-values and pseudo-Bayes factors (against the null).
}
\description{
Convert p-values to (pseudo) Bayes Factors. This transformation has been
suggested by Wagenmakers (2022), but is based on a vast amount of assumptions.
It might therefore be not reliable. Use at your own risks. For more accurate
approximate Bayes factors, use \code{\link[=bic_to_bf]{bic_to_bf()}} instead.
}
\examples{
\dontshow{if (require("parameters")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(iris)
model <- lm(Petal.Length ~ Sepal.Length + Species, data = iris)
p_to_bf(model)

# Examples that demonstrate comparison between
# BIC-approximated and pseudo BF
# --------------------------------------------
m0 <- lm(mpg ~ 1, mtcars)
m1 <- lm(mpg ~ am, mtcars)
m2 <- lm(mpg ~ factor(cyl), mtcars)

# In this first example, BIC-approximated BF and
# pseudo-BF based on p-values are close...

# BIC-approximated BF, m1 against null model
bic_to_bf(BIC(m1), denominator = BIC(m0))

# pseudo-BF based on p-values - dropping intercept
p_to_bf(m1)[-1, ]

# The second example shows that results from pseudo-BF are less accurate
# and should be handled wit caution!
bic_to_bf(BIC(m2), denominator = BIC(m0))
p_to_bf(anova(m2), n_obs = nrow(mtcars))
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Wagenmakers, E.J. (2022). Approximate objective Bayes factors from p-values
and sample size: The 3p(sqrt(n)) rule. Preprint available on ArXiv:
https://psyarxiv.com/egydq
}
}
\seealso{
\code{\link[=bic_to_bf]{bic_to_bf()}} for more accurate approximate Bayes factors.
}
