% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-models.R
\name{fortify-multcomp}
\alias{fortify-multcomp}
\alias{fortify.glht}
\alias{fortify.confint.glht}
\alias{fortify.summary.glht}
\alias{fortify.cld}
\title{Fortify methods for objects produced by \pkg{multcomp}}
\usage{
\method{fortify}{glht}(model, data, ...)

\method{fortify}{confint.glht}(model, data, ...)

\method{fortify}{summary.glht}(model, data, ...)

\method{fortify}{cld}(model, data, ...)
}
\arguments{
\item{model}{an object of class \code{glht}, \code{confint.glht},
\code{summary.glht} or \code{\link[multcomp:cld]{multcomp::cld()}}}

\item{data, ...}{other arguments to the generic ignored in this method.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is deprecated because using \code{broom::tidy()} is a better
solution to convert model objects.
}
\examples{
\dontshow{if (require("multcomp") && require("broom")) withAutoprint(\{ # examplesIf}
amod <- aov(breaks ~ wool + tension, data = warpbreaks)
wht <- multcomp::glht(amod, linfct = multcomp::mcp(tension = "Tukey"))

tidy(wht) # recommended
fortify(wht)

ggplot(tidy(wht), aes(contrast, estimate)) + geom_point()

ci <- confint(wht)
tidy(ci) # recommended
fortify(ci)

ggplot(tidy(confint(wht)),
       aes(contrast, estimate, ymin = conf.low, ymax = conf.high)) +
   geom_pointrange()

smry <- summary(wht)
tidy(smry) # recommended
fortify(smry)

ggplot(mapping = aes(contrast, estimate)) +
   geom_linerange(aes(ymin = conf.low, ymax = conf.high), data = tidy(ci)) +
   geom_point(aes(size = adj.p.value), data = tidy(smry)) +
   scale_size(transform = "reverse")

cld <- multcomp::cld(wht)
tidy(cld) # recommended
fortify(cld)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
