% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-alpha.R
\name{scale_alpha}
\alias{scale_alpha}
\alias{scale_alpha_continuous}
\alias{scale_alpha_binned}
\alias{scale_alpha_discrete}
\alias{scale_alpha_ordinal}
\alias{scale_alpha_datetime}
\alias{scale_alpha_date}
\title{Alpha transparency scales}
\usage{
scale_alpha(name = waiver(), ..., range = NULL, aesthetics = "alpha")

scale_alpha_continuous(
  name = waiver(),
  ...,
  range = NULL,
  aesthetics = "alpha"
)

scale_alpha_binned(name = waiver(), ..., range = NULL, aesthetics = "alpha")

scale_alpha_discrete(...)

scale_alpha_ordinal(name = waiver(), ..., range = NULL, aesthetics = "alpha")
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{...}{Other arguments passed on to \code{\link[=continuous_scale]{continuous_scale()}}, \code{\link[=binned_scale]{binned_scale()}},
or \code{\link[=discrete_scale]{discrete_scale()}} as appropriate, to control name, limits,
breaks, labels and so forth.}

\item{range}{Output range of alpha values. Must lie between 0 and 1.}

\item{aesthetics}{The names of the aesthetics that this scale works with.}
}
\description{
Alpha-transparency scales are not tremendously useful, but can be a
convenient way to visually down-weight less important observations.
\code{scale_alpha()} is an alias for \code{scale_alpha_continuous()} since
that is the most common use of alpha, and it saves a bit of typing.
}
\examples{
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point(aes(alpha = year))

# The default range of 0.1-1.0 leaves all data visible
p

# Include 0 in the range to make data invisible
p + scale_alpha(range = c(0, 1))

# Changing the title
p + scale_alpha("cylinders")
}
\seealso{
The documentation on \link[=aes_colour_fill_alpha]{colour aesthetics}.

Other alpha scales: \code{\link[=scale_alpha_manual]{scale_alpha_manual()}}, \code{\link[=scale_alpha_identity]{scale_alpha_identity()}}.

The \href{https://ggplot2-book.org/scales-colour#sec-scales-alpha}{alpha scales section} of the online ggplot2 book.

Other colour scales: 
\code{\link{scale_colour_brewer}()},
\code{\link{scale_colour_continuous}()},
\code{\link{scale_colour_discrete}()},
\code{\link{scale_colour_gradient}()},
\code{\link{scale_colour_grey}()},
\code{\link{scale_colour_hue}()},
\code{\link{scale_colour_identity}()},
\code{\link{scale_colour_manual}()},
\code{\link{scale_colour_steps}()},
\code{\link{scale_colour_viridis_d}()}
}
\concept{alpha scales}
\concept{colour scales}
