% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_formula.R
\name{find_formula}
\alias{find_formula}
\alias{formula_ok}
\alias{find_formula.default}
\alias{find_formula.nestedLogit}
\title{Find model formula}
\usage{
find_formula(x, ...)

formula_ok(
  x,
  checks = "all",
  action = "warning",
  prefix_msg = NULL,
  verbose = TRUE,
  ...
)

\method{find_formula}{default}(x, verbose = TRUE, ...)

\method{find_formula}{nestedLogit}(x, dichotomies = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}

\item{checks}{Indicates what kind of checks are conducted when checking
the formula notation. Currently, four different formula specification that
can result in unexpected behaviour of downstream-functions are checked.
\code{checks} can be one or more of:
\itemize{
\item \code{"dollar"}: Check if formula contains data name with "$", e.g. \code{mtcars$am}.
\item \code{"T"}: Check if formula contains poly-term with "raw=T", e.g.
\code{poly(x, 2, raw=T)}. In this case, \code{all.vars()} returns \code{T} as variable,
which is not intended.
\item \code{"index"}: Check if formula contains indexed data frames as response
variable (e.g., \code{df[, 5] ~ x}).
\item \code{"name"}: Check if syntactically invalid variable names were used and
quoted in backticks.
\item \code{"all"}: Checks all of the above mentioned options.
}}

\item{action}{Should a message, warning or error be given for an invalid
formula? Must be one of \code{"message"}, \code{"warning"} (default) or \code{"error"}.}

\item{prefix_msg}{Optional string that will be added to the warning/error
message. This can be used to add additional information, e.g. about the
specific function that was calling \code{formula_ok()} and failed.}

\item{verbose}{Toggle warnings.}

\item{dichotomies}{Logical, if model is a \code{nestedLogit} objects, returns
the formulas for the dichotomies.}
}
\value{
A list of formulas that describe the model. For simple models, only
one list-element, \code{conditional}, is returned. For more complex models, the
returned list may have following elements:
\itemize{
\item \code{conditional}, the "fixed effects" part from the model (in the context of
fixed-effects or instrumental variable regression, also called
\emph{regressors}) . One exception are \code{DirichletRegModel} models from
\strong{DirichletReg}, which has two or three components, depending on \code{model}.
\item \code{random}, the "random effects" part from the model (or the \code{id} for
gee-models and similar)
\item \code{zero_inflated}, the "fixed effects" part from the zero-inflation component
of the model. for models from \emph{brms}, this component is named \code{zi}.
\item \code{zero_inflated_random}, the "random effects" part from the zero-inflation
component of the model; for models from \emph{brms}, this component is named
\code{zi_random}.
\item \code{dispersion}, the dispersion formula
\item \code{instruments}, for fixed-effects or instrumental variable regressions like
\code{ivreg::ivreg()}, \code{lfe::felm()} or \code{plm::plm()}, the instrumental variables
\item \code{cluster}, for fixed-effects regressions like \code{lfe::felm()}, the cluster
specification
\item \code{correlation}, for models with correlation-component like \code{nlme::gls()},
the formula that describes the correlation structure
\item \code{scale}, for distributional models such as \code{mgcv::gaulss()} family fitted
with \code{mgcv::gam()}, the formula that describes the scale parameter
\item \code{slopes}, for fixed-effects individual-slope models like \code{feisr::feis()},
the formula for the slope parameters
\item \code{precision}, for \code{DirichletRegModel} models from \strong{DirichletReg}, when
parametrization (i.e. \code{model}) is \code{"alternative"}.
\item \code{bidrange}, for models of class \code{oohbchoice} (from package \strong{DCchoice}),
which indicates the right-hand side of the bar (the bid-range).
}

For models from package \strong{brms}, distributional parameters are also included.
}
\description{
Returns the formula(s) for the different parts of a model (like
fixed or random effects, zero-inflated component, ...). \code{formula_ok()} checks
if a model formula has valid syntax regarding writing \code{TRUE} instead of \code{T}
inside \code{poly()} and that no data names are used (i.e. no \code{data$variable}, but
rather \code{variable}).
}
\note{
For models of class \code{lme} or \code{gls} the correlation-component is only
returned, when it is explicitly defined as named argument (\code{form}), e.g.
\code{corAR1(form = ~1 | Mare)}
}
\examples{
\dontshow{if (require("lme4", quietly = TRUE)) withAutoprint(\{ # examplesIf}
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
find_formula(m)

m <- lme4::lmer(Sepal.Length ~ Sepal.Width + (1 | Species), data = iris)
f <- find_formula(m)
f
format(f)
\dontshow{\}) # examplesIf}
}
